; (***************************************************************************
;
;           RELEASE 1.00 - as contained in the file
;               by Peter Holschbach, 2:2450/660.3, GERMANY
;
;              --------------------------------------------
;               organized for Fido's PASCAL related echoes
;              --------------------------------------------
;
;    09/01/1994 to --/--/---- by Peter Holschbach, 2:2450/660.3,  GERMANY
;
;
;          As far as third party copyrights are not violated this
;          source code is hereby placed to the public domain. Use
;          it whatever way you want, but use AT YOUR OWN RISK.
;
;          In case you should modify the source rather send your
;          modifications to the unit's current organizer (see above for
;          NM address) than to spread it on your own. This will help to
;          keep the unit updated and grant a certain standard to all
;          other users as well.
;
;          The unit is currently still under work. So it might greatly
;          benefit of your participation.
;
;          Those who contributed to the following piece of source,
;          listed in alphabethical order:
;       ================================================================
;          Peter Holschbach ...
;       ================================================================
;          YOUR NAME WILL APPEAR HERE IF YOU CONTRIBUTE USEFUL SOURCE.
;
;          Credits in your own programs are as welcome as unnecessary.
;
;***************************************************************************)

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------


CheckDiskDriver PROC

                 CLC
                 RET
ENDP

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

DiskAllocate PROC
                CLD
                LEA     SI,SwapFilePath         ; DS:SI = pointer at pathname
                LODSB
                MOV     AH,0
                MOV     CX,AX                   ; size of string
                MOV     DL,0                    ; use default drive
                MOV     AX,[SI]                 ; first two chars in AX
                CMP     AH,':'                  ; is a drive selected ?
                JNE     @@useDefaultDrive
                SUB     AL,'A'-1                ; get drive Number
                MOV     DL,AL                   ; DL = new drive for swapout
@@useDefaultDrive:
                LEA     DI,TmpName
                PUSH    CS
                POP     ES                      ; ES:DI = pointer at temp string
                CMP     CX,0
                JE      @@emptyString
                REP_FastMovs                    ; copy String to localStr
                PUSH    DI
                DEC     DI                      ; point at last char in string
                CMP     BYTE PTR ES:[DI],'\'    ; ensure backslash
                POP     DI                      ; point behind the last char
                JE      @@isBackslash
                MOV     BYTE PTR ES:[DI],'\'
                INC     DI
@@emptyString:
@@isBackslash:
                MOV     BYTE PTR ES:[DI],0      ; terminate string

                ; ------- lets test if there is enough space on the drive

                MOV     AH,36h                  ; get free disk space
                                                ; drive is in DL
                INT     21h                     ; AX*BX*CX = free Bytes
                CMP     AX,0FFFFh
                JE      @@SizeError
                MUL     BX
                MUL     CX                      ; DX,AX = disk size
                MOV     BX,SaveSize.lo
                MOV     CX,SaveSize.hi          ; CX,BX = space needed
                SUB     AX,BX
                SBB     DX,CX
                JC      @@isToSmall

                PUSH    DS
                MOV     AX,CS
                MOV     DS,AX
                LEA     DX,TmpName              ; DS:DX = path
                MOV     AH,5Ah                  ; create temporary file
                MOV     CX,SwapFileAttr
                INT     21h
                POP     DS
                MOV     DX,AX                   ; handle to DX
                MOV     AH,ErrCreateTempFile    ; AL = code from DOS
                                                ; CY = Error
                RET
@@SizeError:
                MOV     AX,ErrCantGetSize
                JMP     @@leave
@@isToSmall:
                MOV     AX,ErrNotEnoughSpace

@@leave:
                STC
                RET

ENDP
;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

SwapDisk PROC
                PUSH    DS
                ; ---------------- set write pointer to beginning of file
                MOV     AX,4200h        ; move file pointer, from start of file
                MOV     BX,Handle       ; Handle number
                MOV     CX,0
                MOV     DX,0            ; Offset = 0
                INT     21h

                ; --------------- prepare writing

                LES     DI,SaveSize     ; ES,DI = Size to save

                MOV     DX,OFFSET SavePoint
                MOV     AX,SEG SavePoint
                MOV     DS,AX           ; DS,DX = pointer at start

                ; --------------- write to disk
@@saveLoop:
                MOV     BX,Handle       ; Handle number
                MOV     CX,DosBlockSize ; save max. blocksize
                MOV     AX,ES
                CMP     AX,0            ; less then 64k to save ?
                JNE     @@savemax       ; no -> full size
                CMP     DI,DosBlockSize
                JNB     @@savemax       ; if there is more then one block
                MOV     CX,DI           ; save the rest
@@savemax:
                MOV     AH,40h          ; write to a file
                PUSH    DX
                PUSH    ES
                PUSH    DI
                INT     21h
                POP     DI
                POP     ES
                POP     DX
                JC      @@saveErr         ; error during writing ?
                CMP     AX,CX           ; check if all bytes written
                JNE     @@saveErr         ; error during writing ?
                SUB     DI,AX           ; size to save = size to save - saved
                MOV     AX,ES
                SBB     AX,0
                MOV     ES,AX           ; ES,DI = ES,DI - CX = size to save

                ADD     AX,DI           ; ES+DI = 0 -> nothing left to write
                CMP     AX,0
                JE      @@ready

                MOV     AX,DS
                ADD     AX,DosBlockSize/16 ; next Segment to save
                MOV     DS,AX
                JMP     @@saveLoop
@@ready:
                ; ----------  commite data
                MOV     BX,Handle
                MOV     AH,45h          ; duplicate Handle
                INT     21h
                JC      @@cantDup
                MOV     BX,AX           ; new Handle number
                MOV     AH,03Eh         ; close Handle
                INT     21h
@@cantDup:
                POP     DS
                CLC
                RET

@@saveErr:
                POP     DS
                MOV     AH,ErrWriteFile
                STC
                RET

ENDP


;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

DiskDeAllocate PROC

                PUSH    DS
                LEA     DX,TmpName
                PUSH    CS
                POP     DS
                MOV     AH,41h                  ; delete directory entry
                INT     21h
                POP     DS
                CLC
                RET
ENDP
;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

CheckEMSDriver  PROC
                PUSH     DS
                MOV      AX,3567h         ; get interrupt vector 67h
                INT      21h              ; ES:BX = Vector
                MOV      AX,SEG @CODE
                MOV      DS,AX
                LEA      SI,EMSDeviceName ; DS:SI = pointer at name
                MOV      DI,0Ah           ; offset device name
                CLD
IF ((SIZE EMSDeviceName) MOD 2) NE 0
                MOV      CX,SIZE EMSDeviceName ; compare counter
                REPE     CMPSB            ; compare Strings until not equal
ELSE
                MOV      CX,(SIZE EMSDeviceName) / 2 ; compare counter
                REPE     CMPSW            ; compare Strings until not equal
ENDIF
                POP      DS
                CLC
                JE       @@EmsOk
@@EMSerror:
                STC
                RET
@@EmsOK:
                ; check if LIM EMS >= 4.0
                MOV      AH,46h
                INT      67h
                OR       AH,AH
                JNE      @@EMSerror
                CMP      AL,40h         ; version 4.0 ?
                JL       @@EMSerror     ; the version is to old
                CLC
                RET
ENDP

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

EMSAllocate PROC
                MOV     AX,SaveSize.lo
                MOV     DX,SaveSize.hi          ; DX,AX = size in bytes
                MOV      BX,EmsPageSize         ; Size of one page
                DIV      BX                     ; AX = DX,AX DIV BX
                CMP      DX,0
                JE       @@Hit16K
                INC      AX
@@Hit16k:
                MOV     BX,AX
                MOV     AH,43h                  ; allocate EMS
                INT     67h
                CMP     AH,0
                CLC
                JE      @@EmsOk
                STC
@@EmsOK:
                RET
ENDP

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

SwapEMS PROC
                PUSH    DS              ; save Turbo's DS
                PUSH    CS
                POP     DS
                PUSH    CS
                POP     ES              ; DS = ES = CS

                LEA     SI,SaveSize
                LEA     DI,EMSmovStruc.RegionLength
                MOVSW
                MOVSW                   ; copy the length
                XOR     AX,AX
                STOSB                   ; source memory type = conventional
                STOSW                   ; handle = 0
                MOV     AX,OFFSET SavePoint
                STOSW
                MOV     AX,SEG SavePoint
                STOSW                   ; start from "SavePoint"

                MOV     AL,1
                STOSB                   ; copy to EMS
                MOV     AX,Handle
                STOSW
                XOR     AX,AX
                STOSW
                STOSW

                LEA     SI,EMSmovStruc.RegionLength
                MOV     AX,5700h
                INT     67h
                POP     DS
                OR      AH,AH
                JNZ     @@EMSerror
                RET
@@EMSerror:
                MOV     AL,AH
                MOV     AH,ErrManager
                STC
                RET
ENDP


;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------


EMSDeAllocate PROC
                PUSH    DS
                MOV     DX,Handle
                MOV     AH,45h
                INT     67h
                POP     DS
                CMP     AH,00
                JNE     @@EmsError
                RET
@@EmsError:
                MOV     AL,AH
                MOV     AH,ErrManager   ; to show "a message from EMS"
                STC
                RET
ENDP

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------CheckXMSDriver

CheckXMSDriver  PROC

         MOV    AX,4300h        ; installation check
         INT    2Fh
         CMP    AL,80h
         JE     @@XmsOK
         STC
         RET
@@XmsOk:
         MOV    AX,4310h        ; get adress
         INT    2Fh
         MOV    XMSPointer.Ofst,BX
         MOV    XMSPointer.Segm,ES
         CLC
         RET
ENDP

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

XMSAllocate PROC

                MOV     AX,SaveSize.lo
                MOV     DX,SaveSize.hi  ; DX,AX = size in bytes
                MOV     BX,1024
                DIV     BX              ; calculate size in kbyte
                CMP     DX,0
                JE      @@hit1024
                INC     AX              ; never round down
@@hit1024:
                MOV     DX,AX           ; size needed in AX
                MOV     AH,09h          ; allocate EMM block
                CALL    XmsPointer      ; XMS Call
                CMP     AX,1            ; 1 = ok
                JE      @@XmsOK         ; no problems ?
                MOV     AH,ErrManager   ; to show "a message from XMS"
                MOV     AL,BL           ; erroer number from XMS manager
                STC
                RET
@@XmsOk:
                CLC     ; everything is ok
                RET
ENDP

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

SwapXMS PROC
                PUSH    DS              ; save DS from Turbo Pascal
                MOV     AX,CS
                MOV     DS,AX           ; DS = CS
                MOV     ES,AX           ; ES = CS
                CLD
                LEA     DI,XMSStructur  ; CS:DI = Pointer ad XMS structure
                LEA     SI,SaveSize     ; CS:SI = memory we use
                MOVSW                   ; save size
                MOVSW                   ;    in structure
                XOR     AX,AX           ; clear AX
                STOSW                   ; source handle = 0 => DOS RAM
                MOV     AX,OFFSET SavePoint
                STOSW
                MOV     AX,SEG SavePoint
                STOSW                   ; start adress
                MOV     AX,Handle       ; handle destination
                STOSW
                XOR     AX,AX
                STOSW
                STOSW                   ; offset destination = 0
                MOV     AH,0Bh          ; XMS : "copy block"
                LEA     SI,XMSStructur  ; DS:SI = pointer at structure
                CALL    XmsPointer      ; XMS Call
                POP     DS
                CMP     AX,1            ; CY = 0 if equal
                JNE     @@XMSerror
                RET
@@XMSerror:
                MOV     AH,ErrManager   ; to show "a message from XMS"
                MOV     AL,BL           ; erroer number from XMS manager
                STC
                RET

ENDP


;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

XMSDeAllocate PROC

                MOV     DX,Handle
                MOV     AH,0Ah
                CALL    XmsPointer      ; XMS Call
                CMP     AX,1            ; CY = 0 if equal
                JNE     @@XMSerror
                RET
@@XMSerror:
                MOV     AH,ErrManager   ; to show "a message from XMS"
                MOV     AL,BL           ; erroer number from XMS manager
                STC
                RET

ENDP