unit Fdemo16;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, PrnWin, ExtCtrls, SysUtils,  CB_Types, CB_MFunc;

type
  TForm16 = class(TForm)
    OKBtn: TBitBtn;
    InchesGrid: TBitBtn;
    CentiGrid: TBitBtn;
    PrintWin1: TPrintWin;
    procedure InchesGridClick(Sender: TObject);
    procedure CentiGridClick(Sender: TObject);
  private
    { Private declarations }
  public
     procedure DrawGrid;
 end;

var
  Form16: TForm16;

implementation

{$R *.DFM}

procedure TForm16.DrawGrid;
var
  i: Integer;
  ir: Real;

  xmax: Integer;
  ymax: Integer;

  m: Real;
begin
  PrintWin1.BeginPrint;

  if PrintWin1.Units = poInches then begin
     m := 1.00
  end else begin
    m := 2.54;
  end;

  PrintWin1.DrawRectAt(0,0,PrintWin1.PageWidth,PrintWin1.PageHeight);

  xmax := Round( PrintWin1.PageWidth);
  ymax := Round( PrintWin1.PageHeight);

  PrintWin1.DrawGrid (0,0,1.0,1.0,xmax,ymax);

  ir := 1;
  for i := 1 to xmax-1 do begin
     PrintWin1.DrawTextAt (ir+0.05, 0.25, IntToStr(i));
     ir := ir + 1;
  end;


  ir := 1;
  for i := 1 to ymax-1 do begin
     PrintWin1.DrawTextAt (0.3, ir, IntToStr(i));
     ir := ir + 1;
  end;


  PrintWin1.EndPrint;
end;

procedure TForm16.InchesGridClick(Sender: TObject);
begin
  PrintWin1.Units := poInches;
  DrawGrid;
end;

procedure TForm16.CentiGridClick(Sender: TObject);
begin
  PrintWin1.Units := poCentimetres;
  DrawGrid;
end;

end.
