unit Fdemo09;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, Forms, DBCtrls, DB, DBGrids, Buttons, PrnWin, DBTables, Grids,
  Mask, ExtCtrls, Printers,  FuncsDB, CB_Types, DBPrnWin, CB_MFunc;

type
  TForm09 = class(TForm)
    ScrollBox: TScrollBox;
    Label1: TLabel;
    EditCustNo: TDBEdit;
    Label2: TLabel;
    EditCompany: TDBEdit;
    Label3: TLabel;
    EditAddr: TDBEdit;
    Label4: TLabel;
    EditAddr2: TDBEdit;
    Label5: TLabel;
    EditCity: TDBEdit;
    Label6: TLabel;
    EditState: TDBEdit;
    Label7: TLabel;
    EditZip: TDBEdit;
    Label8: TLabel;
    EditCountry: TDBEdit;
    Label9: TLabel;
    EditPhone: TDBEdit;
    Label10: TLabel;
    EditFAX: TDBEdit;
    Label11: TLabel;
    EditTaxRate: TDBEdit;
    Label12: TLabel;
    EditContact: TDBEdit;
    Label13: TLabel;
    EditLastInvoiceDate: TDBEdit;
    DBGrid1: TDBGrid;
    DBNavigator: TDBNavigator;
    Panel1: TPanel;
    DataSource1: TDataSource;
    Panel2: TPanel;
    Panel3: TPanel;
    Table1: TTable;
    Table2: TTable;
    DataSource2: TDataSource;
    Table2OrderNo: TFloatField;
    Table2CustNo: TFloatField;
    Table2SaleDate: TDateTimeField;
    Table2ShipDate: TDateTimeField;
    Table2ShipVIA: TStringField;
    Table2Terms: TStringField;
    Table2PaymentMethod: TStringField;
    Table2ItemsTotal: TCurrencyField;
    Table2AmountPaid: TCurrencyField;
    Preview: TBitBtn;
    Print: TBitBtn;
    Exit: TBitBtn;
    DBPrintWin1: TDBPrintWin;
    procedure FormCreate(Sender: TObject);
    procedure PreviewClick(Sender: TObject);
    procedure PrintClick(Sender: TObject);
  private
	  procedure DoShow;
  public
  end;

var
  Form09: TForm09;

implementation

{$R *.DFM}

procedure TForm09.FormCreate(Sender: TObject);
begin
  Table1.Open;
  Table2.Open;
end;

procedure TForm09.PreviewClick(Sender: TObject);
begin
  DBPrintWin1.OutputTo := poViewer;
	DoShow;
end;

procedure TForm09.PrintClick(Sender: TObject);
begin
  DBPrintWin1.OutputTo := poPrinter;
	DoShow;
end;


procedure TForm09.DoShow;
var
	y: Integer;
begin
   DBPrintWin1.BeginPrint;
{   DBPrintWin1.SelectSolidBrush (RGB(128,255,255));}
   DBPrintWin1.NewFont ('Arial',20,True,True,True);
   DBPrintWin1.SetTheTextColor (RGB(255,0,0));
   DBPrintWin1.DrawText( 1.0,poCenter,'The Customer');

        DBPrintWin1.NewFont ('Arial',16,False,False,False);
   DBPrintWin1.SetTheTextColor (RGB(0,0,255));
   DBPrintWin1.DrawWindow( 1.6,poCenter,ScrollBox);


   y := DBPrintWin1.GetWindowBottom( 180,500,ScrollBox ) + 50;

   DBPrintWin1.SelectPen (2, RGB(255,0,0));

   DBPrintWin1.NewFont ('Arial',20,True,True,True);
   DBPrintWin1.SetTheTextColor (RGB(255,0,0));
   DBPrintWin1.DrawText( 4.5,poCenter,'The Orders');
   Y := y+150;
   DBPrintWin1.SetFrameStyle(frThinThick);

        DBPrintWin1.NewFont ('Arial',16,False,True,False);
   DBPrintWin1.SetTheTextColor (RGB(0,0,255));
   DBPrintWin1.DrawWindow( 5,poCenter, DBGrid1);


   DBPrintWin1.SelectSolidBrush (RGB(255,0,0));
   DBPrintWin1.SelectHatchedBrush ( RGB(255,255,0), HS_CROSS);
   DBPrintWin1.DrawEllipse( 0.6, 8.3, 2.6, 9.3);


   DBPrintWin1.SelectPen (2, RGB(0,0,0));
   DBPrintWin1.DrawArc( 3.3, 8.3, 5.6, 9.3 ,4.0, 8.6, 5.0, 9.0 );

   DBPrintWin1.NewFont ('Arial',16,True,True,True);
   DBPrintWin1.SetTheTextColor (RGB(0,0,255));
   DBPrintWin1.DrawText( 8,poLeft,'Left Aligned');
   DBPrintWin1.DrawText( 8,poCenter,'Centered');
   DBPrintWin1.DrawText( 8,poRight,'Right Aligned');

   DBPrintWin1.SetFrameStyle(frThickThin);
   DBPrintWin1.DrawRect( 6.8, 7.6, poLeft,1);

   DBPrintWin1.SelectHatchedBrush ( RGB(255,255,0), HS_DIAGCROSS);
   DBPrintWin1.DrawRect( 6.8, 7.6, poCenter,1);

   DBPrintWin1.SelectSolidBrush ( RGB(255,0,255));
   DBPrintWin1.DrawRect( 6.8, 7.6, poRight,1);

   DBPrintWin1.EndPrint;
end;



end.
