unit Fdemo12;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, PrnWin, SysUtils, CB_Types;

type
  TForm12 = class(TForm)
    Exit: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Label4: TLabel;
    PreView: TBitBtn;
    PrintWin1: TPrintWin;
    procedure PreViewClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ExitClick(Sender: TObject);
  private
    { Private declarations }
  public
 end;

var
  Form12: TForm12;

implementation

{$R *.DFM}

procedure TForm12.PreViewClick(Sender: TObject);
var
	Total: Real;
   C1, C2, C3, C4, C5, C6: Real;
   x, y: Real;
   x1,y1,x2,y3: Integer;
   CenterX, CenterY, Radius: Real;
   t, l, b, r: Integer;
begin


	PrintWin1.BeginPrint;
	PrintWin1.SelectSolidBrush (clSilver);
	PrintWin1.NewFont ('Arial', 20, True, TRUE, False);
	PrintWin1.DrawText( 1.6, poCenter, 'The Pie Chart Demo');
	PrintWin1.NewFont ('Arial', 40, False, False, False);
   Total :=  StrToFloat(Edit1.Text) + StrToFloat(Edit2.Text) +
             StrToFloat(Edit3.Text) + StrToFloat(Edit4.Text) +
             StrToFloat(Edit5.Text) + StrToFloat(Edit6.Text);

   { Draw the Pie Chart }
   CenterX := 4.0;
   CenterY := 4.0;
   Radius  := 1.6;

   PrintWin1.DrawRectAt( Round(CenterX-Radius-0.1),Round(CenterY-Radius-0.1),
                         Round(CenterX+Radius+0.1),Round(CenterY+Radius+0.1));

   C1 :=  (2.0*Pi) * (StrToFloat(Edit1.Text)/Total);
   C2 :=  C1+(2.0*Pi) * (StrToFloat(Edit2.Text)/Total);
   C3 :=  C2+(2.0*Pi) * (StrToFloat(Edit3.Text)/Total);
   C4 :=  C3+(2.0*Pi) * (StrToFloat(Edit4.Text)/Total);
   C5 :=  C4+(2.0*Pi) * (StrToFloat(Edit5.Text)/Total);
   C6 :=  C5+(2.0*Pi) * (StrToFloat(Edit6.Text)/Total);

   { Start at 0 }
   x := Radius * Cos(C1);   y := Radius * Sin(C1);
   x1 := 300;            y1 := 0;
   PrintWin1.SelectSolidBrush(RGB(255,0,0));
   t := Round(CenterY-Radius);
   l := Round(CenterX-Radius);
   b := Round(CenterY+Radius);
   r := Round(CenterX+Radius);

   x1 := Round(CenterX)+Round(Radius);  y1 := Round(CenterY);
   PrintWin1.DrawPie(l,t,r,b,   x1,y1,Round(CenterX)+Round(x),Round(CenterY)-Round(y));

   PrintWin1.SelectSolidBrush(RGB(255,255,0));
   x1 := Round(CenterX)+Round(x);  y1 := Round(CenterY)-Round(y);
   x := Radius * Cos(C2);   y := Radius * Sin(C2);
   PrintWin1.DrawPie(l,t,r,b,x1,y1,Round(CenterX)+Round(x),Round(CenterY)-Round(y));

   PrintWin1.SelectSolidBrush(RGB(0,255,0));
   x1 := Round(CenterX)+Round(x);  y1 := Round(CenterY)-Round(y);
   x := Radius * Cos(C3);   y := Radius * Sin(C3);
   PrintWin1.DrawPie(l,t,r,b,x1,y1,Round(CenterX)+Round(x),Round(CenterY)-Round(y));

   PrintWin1.SelectSolidBrush(RGB(0,255,255));
   x1 := Round(CenterX)+Round(x);  y1 := Round(CenterY)-Round(y);
   x := Radius * Cos(C4);   y := Radius * Sin(C4);
   PrintWin1.DrawPie(l,t,r,b,x1,y1,Round(CenterX)+Round(x),Round(CenterY)-Round(y));

   PrintWin1.SelectSolidBrush(RGB(0,0,255));
   x1 := Round(CenterX)+Round(x);  y1 := Round(CenterY)-Round(y);
   x := Radius * Cos(C5);   y := Radius * Sin(C5);
   PrintWin1.DrawPie(l,t,r,b,x1,y1,Round(CenterX)+Round(x),Round(CenterY)-Round(y));

   PrintWin1.SelectSolidBrush(RGB(255,0,255));
   x1 := Round(CenterX)+Round(x);  y1 := Round(CenterY)-Round(y);
   x := Radius * Cos(C6);   y := Radius * Sin(C6);
   PrintWin1.DrawPie(l,t,r,b,x1,y1,Round(CenterX)+Round(x),Round(CenterY)-Round(y));

   PrintWin1.SelectSolidBrush(RGB(192,192,192));

	PrintWin1.EndPrint;
end;

procedure TForm12.FormActivate(Sender: TObject);
begin
	Edit1.Text := '45';
   Edit2.Text := '300';
   Edit3.Text := '75';
	Edit4.Text := '100';
   Edit5.Text := '33';
   Edit6.Text := '200';
end;

procedure TForm12.ExitClick(Sender: TObject);
begin
	Close;
end;

end.
