unit Fdemo10;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, Printers, PrnWin, SysUtils, Funcs, CB_Types;

type
  TForm10 = class(TForm)
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label9: TLabel;
    Label10: TLabel;
    Preview: TBitBtn;
    PrintWin1: TPrintWin;
    procedure PreviewClick(Sender: TObject);
  private
    { Private declarations }
  public
  end;

var
  Form10: TForm10;

implementation

{$R *.DFM}

{ This runs the Print Viewer }
procedure TForm10.PreviewClick(Sender: TObject);
var
	Str: String;
  Str2: String;
  Border: Real;
  MyUnits: String;
  Mul: Real;
begin
   PrintWin1.BeginPrint;
   PrintWin1.NewFont ('Arial',16,True,True,False);
   PrintWin1.SetTheTextColor (RGB(0,0,0));
   Border := 0.5;
   if PrintWin1.Units <> poCentimetres then begin
     MyUnits := 'Inches';
     Mul := 1.0;
   end else begin
     MyUnits := 'Centimetre';
     Mul := 2.54;
   end;
   PrintWin1.DrawRectAt( Border*Mul, Border*Mul, PrintWin1.PageWidth-(Border*Mul),
      PrintWin1.PageHeight-(Border*Mul));
   PrintWin1.DrawText( 1.0*Mul, poCenter, 'The Layout of the selected page');
   Str2 := Printer.Printers[Printer.PrinterIndex];
   Str := Format('You have selected Printer : %s',[Str2]);
   PrintWin1.DrawTextAt( 1*Mul, 1.4*Mul, Str);
   if Printer.Orientation = poPortrait then
   	Str := 'You have selected Portrait Mode'
   else
   	Str := 'You have selected Landscape Mode';
   PrintWin1.DrawTextAt( 1*Mul, 1.8*Mul, Str);

   Str := Format('The Page Height in pixels is : %d',[Printer.PageHeight]);
   PrintWin1.DrawTextAt( 1*Mul, 2.2*Mul, Str);
   Str := Format('The Page Width in pixels is : %d',[Printer.PageWidth]);
   PrintWin1.DrawTextAt( 1*Mul, 2.6*Mul, Str);
   Str := Format('The Page Width in %s is : %f',[MyUnits,PrintWin1.PageWidth]);
   PrintWin1.DrawTextAt( 1*Mul, 3*Mul, Str);

   PrintWin1.EndPrint;
end;


end.
