/**/ 
v="$VER: WFREQIT-CHECK Rexx  Check Incoming for Users  Williamson/Mollitt  54.00"
/*
    Based on FREQIT-IN.rx by Sean Mollitt

    This script should be run aftersession if requests have been sent out.

    If called during a cron event, it will scan the defined freq dir.

    What it does is check any file recd matches those requested by a user
    (FREQIT.usr). If a match is found the file is moved to a special 
    area and a message left for the user which he will receive next time
    he uses FREQIT.
    The  log  file  is updated, the file name is removed from the user file
    and the user file is saved.  
*/ 

sv='v'||right(v,4)
script="WfreqIt"
call close('STDOUT')
call open('STDOUT','RAW:0/10/640/130/ROOF 'script sv'/INACTIVE/AUTO/SCREEN'||GetClip('ASYNCSCREEN'),'w')
call close('STDIN')
call open('STDIN','*','R')
   

/*-------------------------------------- User variables */
 configpath = "CFG:freqit/freqit.cfg"
/*----------------------------------------------------- */

    x=0;z=0;c=0;e=0;up=0;m=0;totk=0;totusers=0

    SAY "[33m[1mWfreqIt-Check[0m "sv" [3m[1mCopyright 1993 Sean Mollitt & Robert Williamson[0m"  

    IF ~show('L','rexxsupport.library') then
        IF ~addlib('rexxsupport.library',0,-30,0) then 
        do
            say 'Error loading rexxsupport.library.'  
            exit
        end


openconfigfile:

    IF ~OPEN('config',configpath,'R') then 
    do
        SAY "Error! Cannot find the config file (freqit.cfg) "    
        signal shutdown
    END

readconfigline:
    cfgln = TRANSLATE(READLN('config'),' ','09'x) /* strips tabs out of config */
    IF LEFT(STRIP(cfgln),1) ~= ';' & COMPRESS(cfgln) ~= "" then 
    DO
        x=x+1
        IF STRIP(WORD(cfgln,1))='BBSLIST' then 
        DO
            z=z+1
            bbsname.z  = STRIP(TRANSLATE(READLN('config'),' ','09'x))
            offset= POS(';',bbsname.z)-1
            IF offset > 0 then bbsname.z = STRIP(LEFT(bbsname.z,offset)) 
            filelist.z = WORD(STRIP(TRANSLATE(READLN('config'),' ','09'x)),1)
            node.z     = WORD(STRIP(TRANSLATE(READLN('config'),' ','09'x)),1)
            time.z     = WORD(STRIP(TRANSLATE(READLN('config'),' ','09'x)),1)
            type.z     = WORD(STRIP(TRANSLATE(READLN('config'),' ','09'x)),1)
            access.z   = WORD(STRIP(TRANSLATE(READLN('config'),' ','09'x)),1)
            signal readconfigline
        END 
        cfg.x = STRIP(STRIP(WORD(cfgln,2)),'B','"')
    END

IF ~EOF('config') then signal readconfigline

filedir = cfg.1
indir   = cfg.2
maxreq  = cfg.3
maxk    = cfg.4
maxover = cfg.5
callout = cfg.6
outnode = cfg.7
txtfile = cfg.8
hlpfile = cfg.9
usrfile = cfg.10
logfile = cfg.11
msgtxt  = cfg.12
msgarea = cfg.13
netarea = cgf.14
maxdays = cfg.15
outbound = cfg.16
pollcmd = cfg.17
hostaddr = cfg.18
userfs=cfg.19
loggroup=cfg.20

    parse arg scandir .
    if arg()=0 then scandir=indir
        else scandir=addslash(scandir)

openuserfile:
    IF ~OPEN('user',usrfile,'R') then 
    do
        SAY "Error! Cannot find the user file (freqit.usr) "  
        signal shutdown
    END

    say "Loading user config"
readuserfile:    
    usrline = UPPER(READLN('user'))
    IF EOF('user') then signal freqit
    m=m+1 ; i=0 ; files.m=0
    name.m= usrline
    totusers = m
    DO FOREVER
        i=i+1
        usrline = READLN('user')
        IF WORD(usrline,1)= "#" then BREAK
        PARSE VAR usrline file.m.i filek.m.i filed.m.i filea.m.i filestat.m.i fileto.m.i filedes.m.i
        files.m = i
    END

    IF ~EOF('user') then signal readuserfile

freqit:

    CALL CLOSE('user')
    if m=0 then 
    DO
        call putlog("FREQIT.usr is empty. No files waiting")
        signal shutdown
    END

    call putlog('Scanning 'scandir)
    inlist = UPPER(SHOWDIR(scandir,'F'))
    if inlist="" then
    do
        say scandir' is empty'
        signal shutdown
    end

    i=0
    DO FOREVER
        i=i+1
        PARSE VAR inlist infile.i inlist
        IF infile.i == "" then BREAK
    END
    i=i-1

    DO x = 1 to i
        DO a = 1 to totusers
            DO b = 1 to files.a
                IF UPPER(file.a.b) = UPPER(infile.x) & filestat.a.b = 'waiting' then 
                DO
                    c=c+1
                    usermsg=msgarea||TRANSLATE(name.a,'_',' ')

                    if ~exists(usermsg) then address COMMAND "Copy" msgtxt usermsg
                        
                    call putlog(file.a.b||" received for "||name.a||". "||TRANSLATE(fileto.a.b,' ','_')||" notified.") 
                    say file.a.b||" received for "||name.a||". "||TRANSLATE(fileto.a.b,' ','_')||" notified." 


                    openmode='a'
                    IF ~OPEN('msgadd',usermsg,'A') then 
                    do
                        If ~open('msgadd',usermsg,'W') then 
                        do
                            SAY "Error opening "usermsg   
                            signal shutdown
                        end
                        openmode='w'
                    END

                    filedes.a.b = STRIP(COMPRESS(filedes.a.b,'"'),'B')
            
                    if indir ~= scandir then
                    do
                        address COMMAND 'Copy' scandir||file.a.b indir
                        if RC=0 then
                        do
                            call delete(scandir||file.a.b)
                            say scandir||file.a.b 'moved to 'indir
                        end
                    end
                    address COMMAND 'FileNote' indir||file.a.b '"'filedes.a.b'"'
                    say indir||file.a.b filedes.a.b

                    if openmode='w' then
                    do
                        CALL WRITELN('msgadd'," WFREQIT "sv" by Sean Mollitt & Robert Williamson  1993")
                        CALL WRITELN('msgadd'," ------------------------------------------------------------")
                    end
                    CALL WRITELN('msgadd',"")
                    CALL WRITELN('msgadd'," File name  : "||file.a.b||"  ("||filek.a.b||")     Freq'ed from: "||filea.a.b)
                    CALL WRITELN('msgadd'," Description: "||filedes.a.b)
                    CALL CLOSE('msgadd')

                    smsg='LOG:RFSacct/'translate(name.a,"_"," ")'.m'
                    if exists(smsg) then call open('um',smsg,'A')
                        else  call open('um',smsg,'W')
                    call writeln('um',' WFREQIT file reception report')
                    CALL WRITELN('um'," File name  : "||file.a.b||"  ("||filek.a.b||")     Freq'ed from: "||filea.a.b)
                    CALL WRITELN('um'," Description: "||filedes.a.b)
                    call close('um')

                    logentry.c = LEFT(infile.x,20)||"  "||LEFT(name.a,20)||"  "||DATE('E')||"  "||filea.a.b||"  "fileto.a.b
                    filestat.a.b = DATE('E')
                END
            END 
        END
    END

    if c=0 then 
    DO
        call putlog("No incoming files match any waiting user files")
        signal shutdown
    END

logit:
    IF ~OPEN('log',logfile,'A') then 
    do
        IF ~OPEN('log',logfile,'W') then 
        do
            SAY "Error! Cannot find log file (freqit.log) "   
            signal shutdown
        END
        CALL WRITELN('log','FREQIT 'sv' LOG FILE')
        CALL WRITELN('log','File requested        User                  Date in    From Node     Destin. ')
        CALL WRITELN('log','-------------------------------------------------------------------------------')
    END
    i=0
    DO i = 1 to c
        CALL WRITELN('log',logentry.i)
    END
    CALL CLOSE('log')

openuserfilewrite:

    IF ~OPEN('user',usrfile,'W') then 
    do
        SAY "Error! Cannot find the userfile" 
        signal shutdown
    END

writeuserfile:
    i=0
    DO o = 1 to totusers
        DO q = 1 to files.o
            i=i+1
            IF file.o.q = "IN" then i=i-1 
        END
        IF i ~= 0 THEN 
        DO
            CALL WRITELN('user',name.o)
            do p = 1 to files.o
                filedat= LEFT(file.o.p,20)||"  "||RIGHT(filek.o.p,7)||"  "||filed.o.p||"  "||filea.o.p||"  "||LEFT(filestat.o.p,8)||" "||fileto.o.p||" "||filedes.o.p
                CALL WRITELN('user',filedat)
            END
            CALL WRITELN('user','#')
        END
    END

    CALL CLOSE('user')

    SAY "User file updated and saved" 

shutdown:
EXIT


/* get filename */
get_fn:
    if LastPos('/', arg(1)) ~= 0 then return SubStr(arg(1), LastPos('/', arg(1)) + 1)
        else if LastPos(':', arg(1)) ~= 0 then return SubStr(arg(1), LastPos(':', arg(1)) + 1)
            else return arg(1)

addslash:
    curr = arg(1)
    select
        when right(curr, 1) = ":" then nop
        when right(curr, 1) = "/" then nop
            otherwise curr = curr"/"
    end
return(curr)

 putlog:
    say arg(1)
    Address "LOGPROC" "Putlog "loggroup time() arg(1)
 return
