/**/
v='$VER: ShowCache Rexx Display Cache for a Site Williamson 55.00'
options results
dtype.5="BBS"
keys.5='number altnum line dial sitename sysop term predial termsess'
dtype.4="FAX"
keys.4='number altnum line dial sysop xprsetup predial'
dtype.3="CLOCK"
keys.3='number altnum line dial sitename baud xprsetup predial'
dtype.2="UUCP"
keys.2='number altnum line dial sitename sysop password uuoptions predial impsess'
dtype.1="FTN"
keys.1='number altnum line dial sitename sysop password multi useakasin useakasout handshake present predial presess impsess freqsess ticsess'
htype.3="EMSI" ;hoflag.3="GE"
htype.2="WAZOO";hoflag.2="G6"
htype.1="FTS1" ;hoflag.1="G1"

parse arg args
port=""
site=""
template="Port/A,Site/A"
if ~ReadArgs(args,template) then do
    say "    "Fault(RC,'ShowCache')
    say '    Usage:     Rx ShowCache 'template
    exit 0
end;else do
    port=upper(port)
    if ~show('p',port) then do
        say '    ShowCache: Cannot find port' port
        exit 0
    end
end

    sitetype=set_sitetype(site)
    say left_justify(" "dtype.sitetype":",15)||site
    do i=1 to words(keys.sitetype)
        wvar=word(keys.sitetype,i)
        if wvar='handshake' then iterate
        x=get_string(wvar'.'site)
        if wvar='number' & x="USES DEFAULT" then do
            say 'Not in Site Cache'
            exit
        end
        say left_justify(" "wvar||":",15)||x
    end
    say left_justify(" "'akalist:',15)||get_string('akalist.'||get_string('number.'site))
    flags=get_string('outflags.'site)
    handshake=""
    do j=1 to 3
        if pos(hoflag.j,flags)>0 then handshake=handshake||htype.j||" "
    end
    if handshake="" then handshake="USES DEFAULT"
    say left_justify(" "'handshake:',15)||handshake
exit

get_string:    
    Address value port
    'String $('arg(1)')'
    if RESULT="" | RESULT='RESULT' then return "USES DEFAULT"
    else Return RESULT

set_sitetype: procedure
if left(upper(arg(1)),3)="BBS" then return 5
else if left(upper(arg(1)),3)="FAX" then return 4
else if left(upper(arg(1)),5)="CLOCK" then return 3
else if (left(upper(arg(1)),2)="UU"|datatype(right(arg(1),2),'MIXED')) then return 2
else return 1

/* align text to right of field  adding spaces or trucating on left to fit   */
right_justify:
    if length(arg(1)) > arg(2) then return (right(arg(1),arg(2)))
        else return (copies(" ",arg(2)-length(arg(1))) || arg(1))

/* align text to left of field  adding spaces or trucating on right to fit   */
left_justify:
    if length(arg(1)) > arg(2) then return (left(arg(1),arg(2)))
        else return (arg(1) || copies(" ",arg(2)-length(arg(1))))

