/**/
v="$VER: ProdCFG  Rexx  Process FTSC Product Code File   Williamson 54.01"
/* fullpath to FTSC Product Codes List */
fpf='FILE:FTSC/FTSCPROD.048'
/* path of ftsc product codes ARCHIVE */
fdir="MAIL:INBOUND/"
/* work dir */
tdir="RAM:TMP"
/* unarc command */
unarc='RAM:REXX/x.REXX'
/**/

    if ~show("L", "rexxsupport.library") then
        if ~addlib("rexxsupport.library", 0, -30, 0) then do
                say "Couldn't access support.library !"
                exit 20
        end
    sv='v'||right(v,5);script="ProdCFG"

    parse upper arg prodarc
    if prodarc="" then signal usage
    if prodarc~="DO" then do
        call makedir(tdir)
        call Pragma('D',tdir)
        if exists('rpdir:x') then address COMMAND 'X' fdir||prodarc
        else do
            cmd=unarc fdir||prodarc
            address "REXX" cmd
        end
        prodfile=showdir(tdir)
        say 'Processing new Product Codes:'prodarc prodfile
        fpf=tdir'/'prodfile
        call delete('ENVARC:ftsflags.0')
    end

    if exists('ENVARC:ftsflags.0') then do
        say "Product flags already configured"
        exit
    end;else do
        say "Configuring product codes"
    end
    envarc=1

if ~open('fpc',fpf,'r') then do
    Say 'Unable to find FTSC Product Code List:'fpf;exit 10
end

/* Mailer flags for certain mailers     */
/* Product Code     Mailer Flags  */
default     =   "7y,cy,ob,ib,py,sy,bn,ay,nn,wn,fy,my,d0"
flags.0     =   '7n,ot,sy'  /*  Fido MelMail    */
flags.5     =   '7n,ot,sy'  /*  Opus            */
flags.7     =   default     /*  WPL             */
flags.12    =   '7n'        /*  FrontDoor       */
flags.27    =   '7n,sf'     /*  Binkely >2.40   */
flags.51    =   'sn,7n'     /*  Binkley/ST      */
flags.57    =   '7n,ot'     /*  TrapDoor        */
flags.58    =   '7n,by'     /*  WelMat >.46     */
flags.66    =   'sy'        /*  TIMS            */
code=0
mailers=0
dropped=0
do forever
    Line=strip(space(translate(ReadLn('fpc'),"   ",'0a'X||'0d'X||'09'X),1))
    if EOF('fpc') then Leave
    if (Line == "") | (left(Line,1)=';') | (left(Line,1)='0d'x) then iterate
    if index(Line,'DROPPED') ~= 0 then do
        parse var Line p','n .
        Line=p','n||copies(',-NA-',4)
        dropped=dropped+1
    end
    Parse var Line p','n','e','f','c','a .
    code=x2d(p)
    prod.code=p;name.code=n;env.code=e;func.code=f;contact.code=c;address.code=a
    if env.code="-NA-" then flags.code='p'
    if flags.code='flags.'code | flags.code='flags.CODE' then flags.code=default

    /* Certain products are flagged as MAILER, when they are not */
    if prod.code ~= 27 & index(upper(func.code),"MAILER") ~= 0 then do
        mailers=mailers+1
        if words(name.code) ~= 1 then name.code = '"'||name.code||'"'
        address COMMAND 'SetEnv' mname.code name.code
        if flags.code ~= default then address COMMAND 'SetEnv ftsflags.'code flags.code
    end
end

maxprod=code
say 'Mailers: 'mailers' Dropped: 'dropped' Total Prods:'maxprod
Close('fpc')
if envarc then do
    address COMMAND "COPY ENV:mname.#? ENVARC:"
    address COMMAND "COPY ENV:ftsflags.#? ENVARC:"
end
exit
usage:
say;say ' 'script sv' by Robert Williamson';say
say '   Please make sure the following are correct for your setup:';say
say '        fpf   'fpf
say '                       fullpath to FTSC Product Codes List'
say '       fdir   'fdir
say '                       path of ftsc product codes ARCHIVE, if newer'
say '       tdir   'tdir
say '                       a temporary work dir'
say '      unarc   'unarc
say '                       fullpath to unarc command';say
say '   If these setting are OK, then run the program:'
say '       ProdCFG DO'
say '           or'
say '       ProdCFG productarchivename'
say
exit
/*
 Does not handle different xprfts.library options for different versions of
 a product; this is done in WPL.

    options  value              meaning

      7       Y                Allow the use of MODEM7 filename exchanging.
      7       N                Don't do anything relating to MODEM7 at all.

      P.S. Technically MODEM7 should not be used in DietIFNA, but some sites
           seem to require it.
       
      C       Y                Allow MODEM7 to be skipped on inbound if the
                               remote polls with a 'c'.
      C       N                Do modem7 anyways.

      O       T                Only ever generate a Telink header block
      O       S                Only ever generate a SeaLink header block
      O       B                Generate both types of header.

      I       T                Accept only Telink header block
      I       S                Accept only SeaLink header block
      I       B                Accept both types of header.

      P       Y                Pickup files on outdial.
      P       N                Don't pickup on outdial.

      S       Y                Allow the use of FTS7 (SeaLink)
      S       F                Do FTS7 even if not asked for.
      S       N                Don't do FTS7 at all

      B       Y                Allow special 'Big Filename' headers to be 
                                 generated
      B       N                Do not generate 'Big filename' headers.

      A       Y                Ask for SeaLink by using block/compliment in
                               ACK/NAK's
      A       N                Use only single character ack/nak.

      N       Y                Ask for MDM7 by polling with NAK rather than
                               a 'c'.
      N       N                Poll with a 'c'.

      W       Y                Wait for Sealink block/compliment on ACK/NAK's
                               NOTE: This will interact VERY badly with Modem7
                               filename transfers, so only use in Sealink
                               transfers.
      W       N                Assume 1 character Xmodem ack/nak

      F       Y                Give the first file a header (Telink/SeaLink)
      F       N                Don't give the first file a header.

      M       Y                First file is Mail bundle (FTS-1)
      M       N                First file is actual outbound file transfer.

      D       #                Debug Level (not yet valid).

  example (The current Defaults):
   XprSetup xprfts.library "7y,cy,ob,ib,py,sy,bn,ay,nn,wn,fy,my,d0"

  Any option not given an explicit value will get the current defaults.  The
  defaults are set up to be as 'friendly' as possible to as many sites.
*/
