/**/
v="$VER: DOOR Wplrx AUX door Handler       Williamson 55.02"

auxdev="CTDL-AUX:"
auxmount='Mount CTDL-AUX: from DEVS:mountlist.aux'
redirect=">CTDL-AUX: <CTDL-AUX:"

options failat 9999
address COMMAND auxmount
options results
options failat 20
signal on syntax  
signal on halt
signal on ioerr
signal on break_c
signal on break_d

    sv=right(v,5);script="DOOR"
    log=show('P','ROOFLOG')
    quote='"'
    cr='\r\n'
    baseport=GetClip('SHELTER')
    logport=lower(baseport)||'wpl'
    parse arg baud slaveport door
say baud
say slaveport
say door
    Address VALUE slaveport
    'Send 'quote||cr||baseport 'Door Handler v'sv' on $(host.sitename)' slaveport||cr||quote
    'Print 'quote||cr||baseport 'Door Handler v'sv' on $(host.sitename)' slaveport||cr||quote
    'Set DOOR TRUE'
    address AREXX 'Mail:rexx/Carrier.rexx 'slaveport word(door,1)
    if upper(word(door,1))="EXECUTE" then cmd=strip(door)
        else cmd=strip(door) redirect
    Call PutLog('Executing:'cmd,10,10)
    address COMMAND cmd
    Address VALUE slaveport
    'Set DOOR FALSE'
    call PutLog('Door Handler exiting',10,10)
    call delete('ENV:DOOR'||slaveport)
exit 0

PutLog:  procedure expose log logport slaveport script
    if log then do
        if arg(3) < GetClip('STATUSLEVEL') then say arg(1)
        if arg(2) > GetClip('LOGLEVEL') then return 0
        address 'ROOFLOG' 'LOGLINE' left(time(),5) script': 'arg(1)
    end;else do
        address LOGPROC 'PutLog "'logport time() right(slaveport,1) script':'arg(1)'"'
    end
return 0

lower:
return(bitor(arg(1),'20'x))

cleanup:
return
break_c:
break_d:
    PutLog('User abort',10,10)
    call cleanup
    exit 10
novalue: 
call template_oops "Novalue" sigl
syntax:
call template_oops "Syntax(RC=" || RC || ")" sigl
failure:
call template_oops "Failure(RC=" || RC || ")" sigl
ioerr:
call template_oops "IOErr" sigl 
halt:
call template_oops "Halt" sigl 
template_oops: 
        parse arg what badport code
        if code ~= "" then  call PutLog("ERR: Line "badport what errortext(code),10,10)
            else call PutLog("ERR: Line" badport what,10,10)
        exit(40)
/**/
