
(* Demo of reading and printing a 256 Color small < 64K bitmap *)
(* With a code 3 of 9 barcode *)
(* Use parts as needed *)

(* This will print a photo and barcode to the screen and the printer *)
(* Note Hi_English will use Y as a negative / Check if you use textout *)

{ Usage:
  SetMapMode(TheDC,MM_HiEnglish);          (* DC Must be in HI English *)
  New(BMP1,Init('Tim.BMP'));                (* read in Tim.BMP *)
  BMP2^.BMPtoDC(TheDC,500,100,200) ;        (* Send it the the DC *)
  PrintBarCode(TheDC,20,38,'012345',True);  (* Print a barcode to the DC *)
  Dispose(BMP1,Done);                       (* Release memory used by the bitmap *)
}

Uses
  Objects,
  WinDos,
  WinCrt,
  TsBar3o9,   (* 3 of 9 barcode printing  uses *)
  Strings,
  WinProcs,
  WinTypes,
  Win31,
  OWindows,
  ODialogs,
  WinSys,
  WinPrn;

Type
  pBMPFile = ^tBMPFile;
  tBMPFile = Object
    DIBInfo     : PBitmapInfo;  (* lots of Info about the bitmap *)
    DIBInfoSize : LongInt;      (* Bytes allocated to the above structure *)
    BitPtr      : Pointer;      (* Bitmap data <64K or oops *)
    BitSize     : LongInt;      (* Bytes allocated to the above structure *)
    ThePalette  : HPalette;     (* handle to Colors - Screen *)
    LogPal      : pLogPalette;  (* Data for the bitmap colors - Prrinte*)
    LogPalMem   : Word;         (* Bytes allocated to the above structure *)

    Constructor Init(Const FileName: String);
      (* Read in the file and fill the above data *)
    Destructor Done;
      (* Dispose the above data *)
    Procedure BMPtoDC(TheDC: hDC;X,Y: Integer;Scale: Real);
      (* Send the picture to device context handle - Must be set for HI_English *)
      (* X,Y,Scale are in inches * 100 ;   500 = 5 inches.  Scale is in inches *)
  End;


{$I-}
Constructor tBMPFile.Init(Const FileName: String);
Type
  tBM = Array[1..2] of Char;
var
  FileHdr    : TBitmapFileHeader;
  F : File;
  RecordsRead: Integer;
  BaseAddr   : Pointer;
  PutAddr    : Pointer;
  BitOff     : LongInt;
  ReadCount  : Word;
  Colors     : Integer;
  I          : Integer;
begin
  DIBInfo     := nil;
  DIBInfoSize := 0;
  BitPtr      := Nil;
  BitSize     := 0;
  ThePalette  := 0;
  LogPal      := Nil;
  LogPalMem   := 0;


  Assign(F,FileName);
  Reset (F,1);
  if IOResult = 0 then
    begin
      BlockRead(F, FileHdr, SizeOf(FileHdr), RecordsRead);
      if (RecordsRead > 0) and (tBM(FileHdr.bfType) = 'BM') then
        begin
          DIBInfoSize := FileHdr.bfOffBits - SizeOf(FileHdr);
          GetMem(DIBInfo, DIBInfoSize);
          BlockRead(F, DIBInfo^, DIBInfoSize, RecordsRead);
          if RecordsRead > 0 then
            begin
              BitSize:= FileSize(F) - FileHdr.bfOffBits;
              GetMem(BitPtr,BitSize);
              Seek(F,FileHdr.bfOffBits);
              BlockRead(F,BitPtr^,BitSize);
            end
          else
            begin
              FreeMem(DIBInfo, DIBInfoSize);
              DIBInfo := nil;
            end;
        end;
      Close(F);
    end;

  If IOResult <> 0 Then
    Begin
      Fail;
      Exit;
    End;

  Case DIBInfo^.bmiHeader.biBitCount Of
  1 : Colors := 2;
  4 : Colors := 16;
  8 : Colors := 256;
  Else
    Colors := 0;
  End;  (* case *)

  LogPalMem := Sizeof(tLogPalette) + (Colors-1) * Sizeof(tPaletteEntry);
  GetMem(LogPal,LogPalMem);

  LogPal^.palVersion   := $0300;
  LogPal^.palNumEntries:= Colors;
  For I := 1 to Colors Do
    LogPal^.palPalEntry[I] := tPaletteEntry(DIBInfo^.bmiColors[I]);

  ThePalette:= CreatePalette(LogPal^);
  If LogPal <> Nil Then
    FreeMem(LogPal,LogPalMem);
end;
{$I+}

Destructor tBMPFile.Done;
begin
  if DIBInfo <> nil then
    FreeMem(DIBInfo, DIBInfoSize);
  If ThePalette <> 0 Then
    DeleteObject(ThePalette);
  If BitPtr <> nil Then
    FreeMem(BitPtr,BitSize);
  DeleteObject(ThePalette);
end;

Procedure tBMPFile.BMPtoDC(TheDC: hDC;X,Y: Integer;Scale: Real);
Var
  Width,Height : Integer;
Begin
  Y := -Y * 10;
  X := X * 10;
  Scale := Scale * 10;
  SelectPalette(TheDC, ThePalette, False);
  RealizePalette(TheDC);

  Width  :=  Trunc(Scale);
  Height :=  Trunc(Scale);
  StretchDIBits(TheDC,X,Y,Width,-Height, 0, 0,
                    DIBInfo^.bmiHeader.biWidth,DIBInfo^.bmiHeader.biHeight,
                    BitPtr,DIBInfo^,
                    DIB_RGB_Colors,
                    SRCCopy);
End;


(* here is where is gets ugly *)
(* This is to demo using the above routines *)

type
  PrnRec = record
    DC: HDC;                    { Printer device context }
    case Integer of
      0: (
        Title: PChar);          { Title of the printout }
      1: (
        Cur: TPoint;            { Next position to write text }
        Finish: TPoint;         { End of the pritable area }
        Height: Word;           { Height of the current line }
        Status: Word);          { Error status of the printer }
      2: (
        Tmp: array[1..14] of Char);
  end;

Var
  TheDC : hDC;
  X,Y  :Integer;
  BMP1 : pBMPFile;
  BMP2 : pBMPFile;
var
  DeviceStr: array[0..80] of Char;
  P: PChar;
  Device, Driver, Port: PChar;
  DocInfo : tDocInfo;
  Lst:  Text;
  PrDC : hDC;
Begin
  TheDC := GetDC(0);
  SetMapMode(TheDC,MM_HiEnglish);

  New(BMP2,Init('Stuff.BMP'));
  New(BMP1,Init('Tim.BMP'));

  AssignDefPrn(Lst);
  Rewrite(Lst);
  with TTextRec(Lst), PrnRec(UserData) do
  PrDC := DC;
  SetMapMode(PrDC,MM_HiEnglish);


  BMP2^.BMPtoDC(TheDC,500,100,200) ;
  BMP1^.BMPtoDC(TheDC,200,100,200) ;
  PrintBarCode(TheDC,20,38,'012345',True);
  textout(TheDC,4000,-4000,'Hello World',11);

  BMP2^.BMPtoDC(PrDC,500,100,200) ;
  BMP1^.BMPtoDC(PrDC,200,100,200) ;
  PrintBarCode(PrDC,15,35,'012345',True);
  textout(PrDC,4000,-4000,'Hello World',11);   (* Negative Y *)
  Close(Lst);


  Dispose(BMP1,Done);
  Dispose(BMP2,Done);

  ReleaseDC(0,TheDC);
End.



