Unit wPreview;

interface

uses
  Forms, SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Dialogs, ExtCtrls, ShellApi, BTPrint, StdCtrls, Buttons,
  Menus, VBXCtrl, Misc, Truebar;

const MaxLpTitles=20;     { max jobs printing at one time }
      MaxPrns=20;         { max printers }
      MaxFonts=10;
      MaxPageLen=58;      { max lines per page (text style printing) }
			MaxPages=30;        { max pages per report (if you want previewing) }
			RefPixPerInchX=300; { reference printer pixels per inch horizontal }
			RefPixPerInchY=300; { reference printer pixels per inch vertical }
      ScrnPixPerInchX=70; { GetDeviceCaps() returns 96, I prefer 70 }
      ScrnPixPerInchY=70; { calc by measuring your screen image and dividing
                            into your screen densities: 640x480, 800x600 }
      ScrollPixels=20;    { when viewing section of large BMP's, scroll 1/2" }
      { following are passed to StartDoc() }
      For8x11=false;  { report designed for 8.5x11 paper size }
      For14x11=true;  { report designed for 14x11 paper size }
			Dlm='|';        { delimiter to use by AddCommand() }

type
	PrnInfo=Record
		{ It may be available but no selectable in the Printer Select window }
		PrName:string[30];  { Printer name as it appears in win.ini }
    PrPort:string[5];   { Lpt?, 1..3 }
		Queue:string[30];  	{ Queue name as it appears in Network setup }
	  CanSelect:boolean;  { will appear in Select Printer window }
    PrType:integer;     { allows associating Queues with this printer type }
		PrWide:Boolean;     { is a wide carriage style printer }
	end;
  LPMain=class(TObject)
		public
			LptPrinters:array [1..MaxPrns] of PrnInfo;
      PrnCnt,AvailCnt,QueueCnt:integer;
      AvailType,QueueType:array [1..MaxPrns] of integer;
      AvailName,QueueName,QueueTitle:array [1..MaxPrns] of string[40];
			AvailWide:array [1..MaxPrns] of boolean;
      { fixed width fonts }
      FontList:array [1..MaxFonts] of string[40]; { over 5 are variable width }
      { CurDest, WantsPreview set in Select Printer window }
			CurDest:integer;       { current hardcopy destination }
      WantsPreview:boolean;  { wants Report Previewing }
			LastHardCopy:integer;  { last hardcopy printer selected }
			procedure LoadPrinters(FromFile:string);
			function  GetPrinterType(aPrinterName:string):integer;
			function  GetQueueNum(ForQueue:string):Integer;
      { Capture sets: No Banner, No Form Feed, Binary Files (No Tab Expand) }
			procedure Capture(PortNum:integer;ToQueue:string);
			procedure EndCapture(PortNum:integer);
	end;
  TPreview = class(TForm)
    Image1: TImage;
    Panel1: TPanel;
    Label1: TLabel;
    Panel2: TPanel;
    Label3: TLabel;
    BitBtn6: TBitBtn;
    BitBtn1: TBitBtn;
    Panel3: TPanel;
    Label2: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Label4: TLabel;
    Edit1: TEdit;
    PopupMenu1: TPopupMenu;
    Close1: TMenuItem;
    N1: TMenuItem;
    FirstPg1: TMenuItem;
    PreviousPg1: TMenuItem;
    NextPg1: TMenuItem;
    LastPg1: TMenuItem;
    N2: TMenuItem;
    PrintAll1: TMenuItem;
    PrintPg1: TMenuItem;
    Image2: TImage;
    GoToPg1: TMenuItem;
    N3: TMenuItem;
    Barcode1: TBarcode;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure Close1Click(Sender: TObject);
    procedure FirstPg1Click(Sender: TObject);
    procedure PreviousPg1Click(Sender: TObject);
    procedure NextPg1Click(Sender: TObject);
    procedure LastPg1Click(Sender: TObject);
    procedure PrintAll1Click(Sender: TObject);
    procedure PrintPg1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Image1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image2MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GoToPg1Click(Sender: TObject);
  private
    wCommands:array [1..MaxPages] of tstringlist;
    ViewPageTot:integer;  { Internal Page Counter For Commands[] }
    CurPage:integer;  { Current Page Being Displayed }
    wCurDest:integer;
    wPageTot:integer;
    wRpWide:boolean;
		wShortTitle:string;
    Zoomable,FitToScreen:boolean;
    BigX,BigY:integer;
    FirstTimeBig:boolean;
    useLandScape:boolean;  { set before calling PlayBackPage }
		function  PlayBackPage(ToScreen:boolean;PageNum:integer):boolean;
		procedure SaveCommands(toFile:string);
    procedure SetButtons;
		procedure ShowBigImage;
		procedure LoadCommands(fromFile:string);
  public
    { after StartDoc, before any print command }
		procedure ShowBluePrint(aCaption,TinyBMP,FullBMP:string);
		procedure PrintBluePrint(FullBMP:string);
		procedure PrintCommandFile(aLoadSpec:string);
  end;
  lpr=class(TObject)
	  private
			Row,Col:Integer;        { current printer row,col for TextStyle }
			RpWide,FixedWidth:Boolean;      { report width, true if greater than 80 }
      RowHeight,ColWidth,Fixed10Width,Fixed12Width,Fixed8Width:integer;
      AdjZeroX,AdjZeroY:double; {Used in cmpxX & cmpxY to correct 0,0 offset }
			Preview: TPreview;
      aCanvas:TCanvas;        { actual display surface }
			NumOfCopies:Integer;    { number of copies }
			CurDest:integer;        { current hardcopy destination }
			CurFont:integer;        { used in SetGDIFont }
      Condensed:boolean;      { use condensed print }
      RowColStyle:boolean;    { set type of text, set using SetTextStyle }
			FromPreview:boolean;    { used by StartDoc2 and Preview window }
	    useLandScape:boolean;   { set in StartDoc }
			Commands:array [1..MaxPages] of tstringlist;
			ViewPageTot:integer;          { used with Commands to track pages }
			InsideCommand:boolean;  { stop recursion of AddCommand() }
      ScaleXby,ScaleYby,VirtualX,VirtualY:longint;
      FromLoadToPrint:boolean; { load an print a command file }
			procedure StartDoc2(ToPreview,Over80Wide:boolean;
  			aBriefTitle:string);  { only used by Preview window }
	      { prints text to selected canvas: screen or printer }
			procedure Wout(xpos,ypos:integer;aStr:string);
				{ use to change font and style to one of FontList[] items }
			procedure setGDIfont(NewFont:string); { set by pxText() }
      procedure SetTextStyle(forText:boolean);
    	  { the following is used to correct alignment
      	  base reference printer is LaserJet at 300 dpi,
					see RefAspectX and RefAspectY below }
      procedure SetScaleXY;
      procedure SetScaleXY70;

				{ scale reference pixels to current canvas }
      function  ScaleX(LaserX:integer):integer;
      function  ScaleY(LaserY:integer):integer;
			{ Easiest way to lay out forms, use centimeters from top and left
			  edge to position items, then print once on printer it is to be
				used on, add the adjustments to list in SetZeroXY() routine to
				correct 0,0 position }
      procedure SetZeroXY(aPrType:integer);
			function  cmpxX(Centimeters:double):integer; { centimeters to pixels }
			function  cmpxY(Centimeters:double):integer; { centimeters to pixels }
			{ old style conversion of 75pix/in to reference pixels,
			  used in Laz??? commands}
      function  y75px(Virtpx:integer):integer;
      function  x75px(Virtpx:integer):integer;
		public
			ShortTitle:string[70];
			Line,Page,PGlen:integer;
      WantsPreview:boolean;  { wants report previewing }
      WindowDest:boolean;  { raster ops are going to a Window }
      pr:TPrinter;        { used when printing hardcopy }
      { the following vars used to correct alignment when using the
        Windows printing system, adjusted proportionally to reference printer
        output }
      RefAspectX,RefAspectY,PrnAspectY,PrnAspectX:integer;
      RefAspectYdbl,RefAspectXdbl:double;
      CanvasWidth,CanvasHeight:integer;
      Running,Abort:boolean;
      CancelState:integer;
      constructor Create;
			procedure StartDoc(Over80Wide:boolean;aBriefTitle:string);
			procedure StopDoc;
	 		procedure SetCaption(toStr:string);
			procedure SetDestination; { call before StartDoc() }
      procedure ForceToScreen;  { These two must be after SetDestination, }
      procedure ForceToPrinter; { before StartDoc, to override default dest. }
    	function  Cancel:integer; { 0-not running, 1-continue, 2-abort }
			{ key print commands should start with AddCommand
			  and end with EndCommand to keep recursion from occuring }
			procedure AddCommand(CommandStr:string);
			procedure EndCommand;

      { the following are used to emulate a line printer }
			procedure TextFont(NewFont:string); { chng font for line printer style }
			procedure Write(astr:string);
			procedure WriteLn(astr:string);
			procedure P(atrow,atcol:integer;astr:string);
			procedure SetRowCol(toRow,toCol:integer);
			function  pRow:integer;
			function  pCol:integer;
			procedure CrLf;
			procedure Eject;  { used for both Text and Raster styles }
			{ converts designated chars to alternate types, for engineering }
			function  SpecChars(istr:string):string;

      { actual routines used for X,Y raster printing, params are
			  in current reference Pixels and use ScaleX and ScaleY to
        convert to current canvas pixels, usually called by cm???
        or Laz???	commands }
			{ aRect values are: left, top, width, height }
			procedure pxLine(aRect:Trect);
			procedure pxText(aPoint:TPoint;uzFont,TheText:string);
			procedure pxImage(IsColor:boolean;aRect:Trect;BMPfile:string);
			procedure pxOrientation(newOrientation:TPrinterOrientation);
			procedure pxBarCode(aRect:Trect;Text:string);
			procedure pxBox(aRect:Trect;GrayLev:integer);
			procedure pxTray(UseTray:integer);

      { the following are used for X,Y raster printing, params are
			  in Centimeters, easiest way to position items,
        translates Centimeters to Reference pixels, passes to px???? commands }
			procedure cmLine(left,top,width,height:double);
			procedure cmBox(left,top,width,height:double;graylev:integer);
			procedure cmText(left,top:double;uzfont,thetext:string);
			procedure cmImage(IsColor:boolean;left,top:double;BMPfile:string);
			procedure cmBarCode(left,top,width,height:double;Text:string);

      { old style laser commands, translates params in old style reference
        system of 75 pixels/in to New Reference Pixels, then to px??? commands }
			{ can be deleted }
			procedure LazLine(top,left,width,height:integer);
			procedure LazBox(top,left,width,height,graylev:integer);
			procedure LazText(top,left:integer;uzfont,thetext:string);
			procedure LazBarCode(top,left,width,height:integer;text:string);
			function  LazInchX(Inches:double):integer;    { inches to 75 pixels/in }
			function  LazInchY(Inches:double):integer;    { inches to 75 pixels/in }
	end;

var lp:LPmain;
		CurPrinting:array [1..MaxLpTitles] of string30;
procedure StartLinePrinter;
procedure StopLinePrinter;

implementation

{$R *.DFM}

{uses Commoncode, NWCaldef, NWconnec, NWPrint;} { NW??? units from Apiary lib }

{ WNetGetConnection>0, no queue attached, 0-Queue name
  returned in RemoteName }
function  WNetGetConnection(LocalDev,RemoteName:Pchar;
  var RetSize:integer):integer;far;external 'USER';

function GetTitle(aStr:string):string;
var ii:integer;
begin
  ii:=pos('::',upper(aStr));
  result:=aStr;
  if ii>0 then begin
    result:=ltrim(trim(substr(aStr,ii+2,70)));
  end;
  ii:=pos(Dlm+Dlm,aStr);
  if ii>10 then result:=substr(aStr,ii+2,70);
end;

procedure TPreview.FormCreate(Sender: TObject);
var ii:integer;
begin
  top:=0;
  width:=627;
  height:=413;
  left:=0;
  CurPage:=1;
	image1.width:=820;
  image1.height:=900;
  panel1.width:=image1.width;
	centerhoriz(self);
	Gen.AddWin('Preview',self);
	for ii:=1 to MaxPages do wCommands[ii]:=nil;
  Zoomable:=false;
  FitToScreen:=false;
  useLandScape:=false;
end;

procedure TPreview.FormClose(Sender: TObject; var Action: TCloseAction);
var bool:boolean;
    ii:integer;
begin
  bool:=true;
  if pin('FORMAT',upper(caption)) then begin
    bool:=YesNoBox('Close Preview Window During Formatting?');
  end;
  if bool then begin
	  for ii:=1 to wPageTot do begin
		  if wCommands[ii]<>nil then wCommands[ii].free;
		end;
	  if Zoomable then begin
  	  Gen.InBluePrint:=false;
    	Gen.FullBP.free;  { free memory }
    	Gen.FullBP:=TBitMap.Create;
    	Gen.TinyBP.free;  { free memory }
      Gen.TinyBP:=TBitMap.Create;
  	end;
		Gen.ReleaseWin(self);
  	action:=caFree;
  end;
end;

procedure Lpr.Wout(xpos,ypos:integer;aStr:string);
var ii,jj,orgx:integer;
    tt:string[20];
begin
  { xpos, ypos should be in laser pixels }
  jj:=length(astr);
  if jj>0 then begin
    with aCanvas do begin
      brush.style:=bsClear;
      if FixedWidth then begin
        if not RowColStyle then begin
          if WindowDest then begin
            ColWidth:=Fixed12Width;
            if font.size=10 then ColWidth:=Fixed10width;
            if font.size=8 then ColWidth:=Fixed8width;
          end else begin
            ColWidth:=Colwidth-1;
            if font.size=10 then ColWidth:=Colwidth-1;
            if font.size=8 then ColWidth:=Colwidth;
          end;
        end;
        orgx:=xpos;
        for ii:=1 to jj do begin
          tt:=copy(astr,ii,1);
          xpos:=orgx+(ii-1)*ColWidth;
          textout(xpos,ypos,tt);
          { Corporate Mono won't produce underlines, have to use Courier }
          if (fsUnderline in font.style) and (font.name=lp.FontList[2]) then begin
            font.name:=lp.FontList[1];
            textout(xpos,ypos,'_');
            font.name:=lp.FontList[2];
          end;
        end;
      end else begin
        textout(xpos,ypos,astr);
      end;
    end;
  end;
end;

procedure TPreview.PrintBluePrint(FullBMP:string);
var tlp:TPrinter;
    PrintBP:TBitmap;
    tcanvas:trect;
    ii,jj:integer;
begin
  caption:='Print B/P';
  windowstate:=wsMinimized;
  tlp:=TPrinter.create;
  tlp.orientation:=poLandScape;
  tlp.begindoc;
  PrintBP:=tbitmap.create;
  PrintBP.loadfromfile(FullBMP);
  { get image aspect ratio }
  jj:=(PrintBP.height*10) div PrintBP.width;
  ii:=(tlp.canvas.cliprect.right*jj) div 10;
  tcanvas:=rect(0,0,tlp.canvas.cliprect.right,ii);
  tlp.fCanvas.copymode:=cmSrcCopy;
  tlp.fCanvas.copyrect(tlp.fCanvas.cliprect,PrintBP.canvas,PrintBP.canvas.cliprect);
  {tlp.fCanvas.draw(0,0,PrintBP);}
  tlp.enddoc;
  tlp.destroy;
  PrintBp.free;
  close;
end;

procedure Lpr.SetTextStyle(forText:boolean);
begin
	if WantsPreview then begin
    if forText<>RowColStyle then
      AddCommand(' 5'+Dlm+iifs(forText,'TRUE','FALSE'));
  end;
  RowColStyle:=forText;
  EndCommand;
end;

procedure Lpr.setGDIfont(NewFont:string);
var ii,jj,OrgFont:integer;
    tstyle:tfontstyles;
begin
  if not empty(NewFont) then begin
    OrgFont:=CurFont;
    with aCanvas do begin
      { when changing font type, must use style '1:12b', where '1:' is style }
      if pin(':',NewFont) then begin
        jj:=pos(':',NewFont);
        if CurFont=0 then CurFont:=2;  { default font type }
        if jj>1 then begin
          ii:=procint(copy(NewFont,1,jj));
          NewFont:=copy(NewFont,jj+1,35);
	        if (ii>0) and (ii<=MaxFonts) then begin
  	        if not empty(lp.FontList[ii]) then CurFont:=ii;
            if ii=2 then CurFont:=1;
    	    end;
        end;
        if orgfont>0 then begin
          if CurFont<>orgfont then begin
            font.name:=lp.FontList[CurFont];
          end;
        end else font.name:=lp.FontList[CurFont];
      end;
      FixedWidth:=(CurFont<6);
      { if you change size, must also reset style }
      if procint(NewFont)>0 then begin
        font.size:=procint(NewFont);
        font.color:=clBlack;
        tstyle:=[];
        if pin('B',upper(NewFont)) then Include(tstyle,fsbold);
        if pin('U',upper(NewFont)) then Include(tstyle,fsUnderline);
        if pin('I',upper(NewFont)) then Include(tstyle,fsItalic);
        { set back to normal }
        if pin('N',upper(NewFont)) then tstyle:=[];
        acanvas.font.style:=tstyle;
      end else begin
        { change only by passing in just B I or U or a combination }
        tstyle:=[];
        if pin('B',upper(NewFont)) then Include(tstyle,fsbold);
        if pin('U',upper(NewFont)) then Include(tstyle,fsUnderline);
        if pin('I',upper(NewFont)) then Include(tstyle,fsItalic);
        { set back to normal }
        if pin('N',upper(NewFont)) then tstyle:=[];
        font.style:=tstyle;
      end;
      RowHeight:=CanvasHeight div 60;
      if CurFont<6 then begin
        Fixed12Width:=(CanvasWidth div 80)+1;
        Fixed10Width:=(CanvasWidth div 104)+1;
        Fixed8Width:=CanvasWidth div 132;
      end;
      ColWidth:=CanvasWidth div 80;  { 12 pt }
 	    if font.size=8 then ColWidth:=CanvasWidth div 132;
   	  if font.size=10 then ColWidth:=CanvasWidth div 104;
    end;
  end;
end;

procedure Lpr.SetScaleXY70;
var t1,t2:longint;
begin
  CanvasWidth:=acanvas.cliprect.right;
  CanvasHeight:=acanvas.cliprect.bottom;
  RefAspectX:=RefPixPerInchX;  { my reference printer is a LaserJet II }
  RefAspectY:=RefPixPerInchY;
  RefAspectXdbl:=RefAspectX;
  RefAspectYdbl:=RefAspectY;
  if WindowDest then begin
	  PrnAspectX:=ScrnPixPerInchX;
  	PrnAspectY:=ScrnPixPerInchX;
  end else begin
	  PrnAspectX:=GetDeviceCaps(acanvas.handle,LOGPIXELSX);
  	PrnAspectY:=GetDeviceCaps(acanvas.handle,LOGPIXELSY);
	end;
  { ScaleXby and ScaleYby used to adjust reference pixels to
    actual pixels }
  t1:=PrnAspectX;
  t2:=RefAspectX;
  ScaleXby:=(t1*100) div t2;
  t1:=PrnAspectY;
  t2:=RefAspectY;
  ScaleYby:=(t1*100) div t2;
  { VirtualX and VirtualY used to adjust Laz???() Pixels to Reference pixels }
  t1:=70;
  t2:=RefAspectX;
  VirtualX:=(t2*10) div t1;
  t1:=70;
  t2:=RefAspectY;
  VirtualY:=(t2*10) div t1;
end;

procedure Lpr.SetScaleXY;
var t1,t2:longint;
begin
  CanvasWidth:=acanvas.cliprect.right;
  CanvasHeight:=acanvas.cliprect.bottom;
  RefAspectX:=RefPixPerInchX;  { my reference printer is a LaserJet II }
  RefAspectY:=RefPixPerInchY;
  RefAspectXdbl:=RefAspectX;
  RefAspectYdbl:=RefAspectY;
	PrnAspectX:=GetDeviceCaps(acanvas.handle,LOGPIXELSX);
  PrnAspectY:=GetDeviceCaps(acanvas.handle,LOGPIXELSY);
  { ScaleXby and ScaleYby used to adjust reference pixels to
    actual pixels }
  t1:=PrnAspectX;
  t2:=RefAspectX;
  ScaleXby:=(t1*100) div t2;
  t1:=PrnAspectY;
  t2:=RefAspectY;
  ScaleYby:=(t1*100) div t2;
  { VirtualX and VirtualY used to adjust Laz???() Pixels to Reference pixels }
  t1:=70;
  t2:=RefAspectX;
  VirtualX:=(t2*10) div t1;
  t1:=70;
  t2:=RefAspectY;
  VirtualY:=(t2*10) div t1;
end;

function  Lpr.ScaleX(LaserX:integer):integer;
var longx:longint;
begin
  longx:=LaserX;
  Result:=(longx*ScaleXby) div 100;
end;

function  Lpr.ScaleY(LaserY:integer):integer;
var longy:longint;
begin
  longy:=LaserY;
  Result:=(longy*ScaleYby) div 100;
end;

function  Lpr.x75px(Virtpx:integer):integer;
var longx:longint;
begin
  longx:=Virtpx;
  Result:=(longx*VirtualX) div 10;
end;

function  Lpr.y75px(Virtpx:integer):integer;
var longy:longint;
begin
  longy:=Virtpx;
  Result:=(longy*VirtualY) div 10;
end;

constructor lpr.Create;
var ii:integer;
begin
  Abort:=false;
  Running:=false;
  Preview:=nil;
  AdjZeroX:=0.0;
  AdjZeroY:=0.0;
	FromPreview:=false;
  WantsPreview:=false;
  WindowDest:=false;
	for ii:=1 to MaxPages do Commands[ii]:=nil;
end;

function LPmain.GetPrinterType(aPrinterName:string):integer;
var ii:integer;
    tt,tt2:string;
begin
  result:=0;
	with lp do begin
	  if AvailCnt>0 then begin
		  tt:=upper(aPrinterName);
		  for ii:=1 to AvailCnt do begin
			  tt2:=upper(AvailName[ii]);
				if tt=tt2 then begin
				  result:=AvailType[ii];
					break;
				end;
			end;
		end;
	end;
end;

function LPmain.GetQueueNum(ForQueue:string):Integer;
var ii:integer;
    tt,tt2:string;
begin
  result:=0;
	with lp do begin
	  if QueueCnt>0 then begin
		  tt:=upper(ForQueue);
		  for ii:=1 to QueueCnt do begin
			  tt2:=upper(QueueName[ii]);
				if tt=tt2 then begin
				  result:=ii;
					break;
				end;
			end;
		end;
	end;
end;

procedure Lpr.SetZeroXY(aPrType:integer);
begin
  { Adjust origin for each printer, used in pxCM() }
  AdjZeroX:=0.0;
  AdjZeroY:=0.0;
  case aPrType of
    5,6,7,8:begin  { LaserJet's }
	    				AdjZeroX:=-0.7;
							AdjZeroY:=-1.9;
        		end;
      2,3,4:begin  { Canon BJ-200's }
              AdjZeroX:=-1.1;
              AdjZeroY:=-1.15;
            end;
         10:begin    { HP DeskJet's }
              AdjZeroX:=0.0;
              AdjZeroY:=0.0;
            end;
  end;
end;

procedure LPmain.LoadPrinters(FromFile:string);
var tt:string;
		tparscnt,ii,jj,kk:integer;
		plist:tstringlist;
    tp1,tp2:pchar;
    tpars:array [1..MaxPars] of string135;
		pr:TPrinter;
begin
	pr:=TPrinter.create;
  plist:=tstringlist.create;
  plist.LoadFromFile(FromFile);
	{ setup printer and queue types first }
	AvailCnt:=0;
	QueueCnt:=0;
	for ii:=1 to MaxPrns do begin
		AvailType[ii]:=0;
		AvailName[ii]:='';
		AvailWide[ii]:=false;
		QueueName[ii]:='';
		QueueTitle[ii]:='';
		QueueType[ii]:=0;
    with LptPrinters[ii] do begin
      PrName:='';
      PrPort:='';
			PrType:=0;
      CanSelect:=True;
      PrWide:=False;
      Queue:='';
    end;
	end;
	for ii:=0 to plist.count-1 do begin
	  if pos('pp:',plist[ii])=1 then begin
		  split(plist[ii],':',tpars,tparscnt);
			pp(AvailCnt);
			AvailType[AvailCnt]:=procint(tpars[2]);
			AvailName[AvailCnt]:=trim(tpars[3]);
			if tparscnt>3 then AvailWide[AvailCnt]:=pin('Y',upper(tpars[4]));
			{ always make the generice printer wide carriage }
			if pin('GENERIC',upper(tpars[3])) then AvailWide[AvailCnt]:=true;
		end;
	  if pos('qq:',plist[ii])=1 then begin
		  split(plist[ii],':',tpars,tparscnt);
			pp(QueueCnt);
			QueueName[QueueCnt]:=upper(trim(tpars[2]));
			QueueTitle[QueueCnt]:=trim(tpars[3]);
			QueueType[QueueCnt]:=procint(tpars[4]);
		end;
	end;
  PrnCnt:=0;
	if pr.printers.count>0 then begin
    tp1:=stralloc(60);
    tp2:=stralloc(60);
	  for ii:=0 to pr.printers.count-1 do begin
      if PrnCnt<MaxPrns then begin
        pp(PrnCnt);
        split(pr.printers[ii],' on ',tpars,tparscnt);
        with LptPrinters[PrnCnt] do begin
          PrName:=trim(tpars[1]);
					PrType:=GetPrinterType(PrName);
          PrPort:=upper(tpars[2]);
          CanSelect:=True;
          if pin('PUB',PrPort) then CanSelect:=false;
          PrWide:=False;
          strpcopy(tp1,PrPort);
          strpcopy(tp2,'');
          Queue:='';
          kk:=58;  { set tp2 buffer size }
          jj:=WNetGetConnection(tp1,tp2,kk);
          tt:='';
          if jj=0 then begin
	          tt:=strpas(tp2);
            { tt should contain something of form: \\MYSERVER\QC_PRINTER }
		        split(tt,'\',tpars,tparscnt);
            Queue:=upper(tpars[tparscnt]);
            jj:=GetQueueNum(Queue);
            { Check Queue printer type matches Windows setup }
            if jj>0 then begin
              if PrType<>QueueType[jj] then Queue:='';
            end else Queue:='';
          end;
        end;
      end;
		end;
    strdispose(tp1);
    strdispose(tp2);
	end;
  { final result of LastHardCopy saved in close method of mainwin }
  WantsPreview:=true;
  CurDest:=pr.printerindex+1;
	pr.free;
  plist.free;
end;

procedure Lpr.Write(astr:string);
begin
  p(Line,Pcol,astr);
end;

procedure Lpr.WriteLn(astr:string);
begin
  p(line,pCol,astr);
  Col:=0;
  pp(line);
end;

procedure Lpr.P(atrow,atcol:integer;astr:string);
var OverPGlen:boolean;
begin
  if Abort then Exit;
	if WantsPreview then AddCommand(' 1'+Dlm+
	  inttostr(atrow)+Dlm+inttostr(atcol)+Dlm+astr);
  if atrow<Row then begin
    Eject;
    pp(page);
  end;
  OverPGlen:=false;
  if atrow>=PgLen then begin
    Eject;
	  OverPGlen:=true;
    pp(page);
  end;
  Row:=atRow;
  Col:=atcol;
  if length(astr)>0 then begin
    if not WantsPreview then begin
      ColWidth:=iifi(Condensed,Fixed8Width,Fixed12Width);
      wout(col*ColWidth,row*RowHeight,astr);
    end;
    Col:=Col+length(astr);
  end;
  if OverPGlen then begin { must not reset row and col till after print }
    row:=0;
    col:=0;
    line:=-1;
  end;
	EndCommand;
end;

procedure Lpr.SetDestination;
{ Set printer options using LPmain info.
	Should be called before StartDoc(), but only once, when
  the choice to print has been made, not inside a loop of any kind
	because the printer destination might be changed by some other event }
var ii:integer;
begin
	NumOfCopies:=1;
	CurDest:=lp.CurDest;
  WantsPreview:=lp.WantsPreview;
  WindowDest:=WantsPreview;
	RpWide:=Lp.LptPrinters[curdest].PrWide;
end;

procedure Lpr.StartDoc2(ToPreview,Over80Wide:boolean;
  aBriefTitle:string);
begin
  FromPreview:=ToPreview;
	StartDoc(Over80Wide,aBriefTitle);
end;

procedure Lpr.StartDoc(Over80Wide:boolean;aBriefTitle:string);
var ii:integer;
    Use70,paper8x11:boolean;
    tt,tt2:string;
begin
	ShortTitle:=aBriefTitle;
  for ii:=1 to MaxLpTitles do begin
	  if empty(CurPrinting[ii]) then begin
		  CurPrinting[ii]:=ShortTitle;
			break;
		end;
	end;
  Abort:=false;
  Running:=true;
  RpWide:=Over80Wide;
  PgLen:=MaxPageLen;
	NumOfCopies:=1;
  { page starts at 0,0 }
  Row:=0;
  Col:=0;
  Page:=1;
  Line:=0;
  RowHeight:=1;
  ColWidth:=1;
  Use70:=false;
  FromLoadToPrint:=false;
	Fixed12Width:=0;
  Fixed8Width:=0;
  CurFont:=0;
	ViewPageTot:=1;
	Commands[ViewPageTot]:=tstringlist.create;
	pr:=TPrinter.create;
	InsideCommand:=false;
	if (CurDest>0) and (CurDest<4) then pr.printerindex:=CurDest-1;
  ShortTitle:=GetTitle(aBrieftitle);
  Use70:=pin('70::',copy(aBriefTitle,1,ii));
  if not FromPreview then begin
	  preview:=tpreview.create(application);
		preview.caption:='Formatting '+ShortTitle;
	  preview.ViewPageTot:=1;
  	preview.panel1.width:=preview.image1.width;
    Commands[ViewPageTot].insert(0,' 1'+Dlm+' 0'+Dlm+
		  iifs(RpWide,'for14x11','for8x11')+Dlm+Dlm+aBriefTitle);
  end;
	if WantsPreview then begin
		WindowDest:=true;
		SetZeroXY(0);
		aCanvas:=Preview.image1.Canvas;
	end else begin
	  if FromPreview then begin
		  if not WindowDest then begin
	      {if useLandScape then pr.Orientation:=poLandScape;}
			  SetZeroXY(lp.LptPrinters[lp.CurDest].PrType);
				pr.begindoc;
				aCanvas:=pr.canvas;
			end;
		end else begin
			WindowDest:=false;
			preview.caption:='Formatting '+aBriefTitle;
      {if useLandScape then pr.Orientation:=poLandScape;}
			SetZeroXY(lp.LptPrinters[lp.CurDest].PrType);
			pr.begindoc;
			aCanvas:=pr.canvas;
		end;
	end;
	with aCanvas do begin
		if not WindowDest then begin
      paper8x11:=not Lp.LptPrinters[CurDest].PrWide;
		end else begin
      paper8x11:=true;
		end;
    if Use70 then SetScaleXY70
    else SetScaleXY;
    SetTextStyle(true);  { start in text style }
		with font do begin
      SetGDIFont('2:12');
      Condensed:=false;
      if WindowDest then begin
        SetGDIFont('2:10');
      end;
			if RpWide And paper8x11 then begin
        Condensed:=true;
	      SetGDIFont('2:8');
			end;
		end;
	end;
end;

procedure Lpr.StopDoc;
var ii:integer;
begin
  for ii:=1 to MaxLpTitles do begin
	  if ShortTitle=CurPrinting[ii] then begin
		  CurPrinting[ii]:='';
			break;
		end;
	end;
	if not WindowDest then begin
		preview.caption:='Printing '+ShortTitle;
    if FromLoadToPrint then begin
    { special case when commands loaded from file }
	    pr.Abort; { close current printer device, handled by PlayBackPage }
      preview.wCurDest:=CurDest;
      preview.wPageTot:=ViewPageTot;
      for ii:=1 to ViewPageTot do begin
        preview.wCommands[ii]:=tstringlist.create;
        preview.wCommands[ii].assign(Commands[ii]);
        Commands[ii].free;
      end;
      { keep track of StartDoc() settings }
      preview.wRpWide:=RpWide;
      preview.wShortTitle:=ShortTitle;
      preview.playbackPage(false,0);
    end else pr.EndDoc;
    preview.close;
	end;
	pr.free;
  Running:=false;
  if WantsPreview then begin
    preview.wCurDest:=CurDest;
    preview.wPageTot:=ViewPageTot;
		for ii:=1 to ViewPageTot do begin
      preview.wCommands[ii]:=tstringlist.create;
		  preview.wCommands[ii].assign(Commands[ii]);
			Commands[ii].free;
		end;
		{ keep track of StartDoc() settings }
    preview.wRpWide:=RpWide;
		preview.wShortTitle:=ShortTitle;
    preview.CurPage:=1;
    preview.PlayBackPage(true,1);
    preview.setbuttons;
  end;
end;


procedure Lpr.SetRowCol(toRow,toCol:integer);
begin
  if Abort then Exit;
	if WantsPreview then AddCommand(' 2'+Dlm+inttostr(torow)+Dlm+
    inttostr(tocol));
  Col:=toCol;
  Row:=toRow;
	EndCommand;
end;


procedure Lpr.CrLf;
begin
  if Abort then Exit;
	if WantsPreview then AddCommand(' 3');
	pp(Row);
  Col:=0;
	EndCommand;
end;


procedure Lpr.Eject;
begin
  if Abort then Exit;
	if not WindowDest then pr.newpage
  else begin
		if ViewPageTot<MaxPages then begin
			pp(ViewPageTot);
      Commands[ViewPageTot]:=tstringlist.create;
    end;
  end;
  Row:=0;
  Line:=0;
  Col:=0;
end;

function Lpr.pRow:integer;
begin
  Result:=Row;
end;

function Lpr.pCol:integer;
begin
	Result:=Col;
end;

function Lpr.SpecChars(istr:string):string;
var ii,tcnt:integer;
    tst:string[10];  { special chars ~ ` ^ }
		tt:string[3];
		tarr:array [1..30] of string135;
begin
  ii:=pos('+/-',istr);
  if ii>0 then begin
    tcnt:=0;
    split(istr,'+/-',tarr,tcnt);
    istr:=unsplit(tarr,'~',tcnt);
  end;
  for ii:=1 to length(istr) do begin
    tst:=Copy(istr,ii,1);
    if tst=Dlm then begin  { degree }
      istr[ii]:=chr(176);
    End Else
    Begin
      if tst='~' then begin  { +/- symbol }
        istr[ii]:=chr(177);
      End Else
      Begin
        if tst='^' then begin  { Greek theta character }
          istr[ii]:=chr(216);
        End Else
        Begin
          if tst='_' then begin  { replace underscores with spaces }
            istr[ii]:=' ';
          End;
        End;
      End;
    End;
  End;
  Result:=istr;
end;

procedure Lpr.pxTray(usetray:integer);
var p1,r1:integer;
    prt:string[20];
begin
  if Abort then Exit;
	if WantsPreview then AddCommand('28'+Dlm+inttostr(usetray))
  else begin
	  { not written yet }
  end;
	EndCommand;
end;

function Lpr.cmpxX(Centimeters:double):integer; { centimeters to pixels }
var ii:integer;
begin
  ii:=procint(strd(((Centimeters+AdjZeroX)/2.54)*RefAspectXdbl,0));
  result:=ii;
end;

function Lpr.cmpxY(Centimeters:double):integer; { centimeters to pixels }
var ii:integer;
begin
  ii:=procint(strd(((Centimeters+AdjZeroY)/2.54)*RefAspectYdbl,0));
  result:=ii;
end;

procedure Lpr.cmLine(left,top,width,height:double);
begin
	pxLine(Rect(cmpxX(left),cmpxY(top),cmpxX(width),cmpxY(height)));
end;

procedure Lpr.cmBox(left,top,width,height:double;graylev:integer);
begin
	pxBox(Rect(cmpxX(left),cmpxY(top),cmpxX(width),cmpxY(height)),GrayLev);
end;

procedure Lpr.cmText(left,top:double;uzfont,thetext:string);
begin
	pxText(Point(cmpxX(left),cmpxY(top)),uzFont,TheText);
end;

procedure Lpr.cmImage(IsColor:boolean;left,top:double;BMPfile:string);
begin
	pxImage(IsColor,Rect(cmpxX(left),cmpxY(top),0,0),BMPfile);
end;

procedure Lpr.cmBarCode(left,top,width,height:double;Text:string);
begin
	pxBarCode(Rect(cmpxX(left),cmpxY(top),cmpxX(width),cmpxY(height)),Text);
end;

procedure Lpr.LazLine(top,left,width,height:integer);
begin
	pxLine(Rect(x75px(left),y75px(top+7),x75px(width),y75px(height)));
end;

procedure Lpr.LazBox(top,left,width,height,graylev:integer);
begin
	pxBox(Rect(x75px(left),y75px(top+7),x75px(width),y75px(height)),GrayLev);
end;

procedure Lpr.LazText(top,left:integer;uzfont,thetext:string);
begin
  SetTextStyle(false);
  pxText(Point(x75px(left),y75px(top-3)),uzFont,TheText);
end;

procedure Lpr.LazBarCode(top,left,width,height:integer;text:string);
begin
	pxBarCode(Rect(x75px(left),y75px(top),x75px(width),y75px(height)),Text);
end;

procedure Lpr.pxLine(aRect:Trect);
begin
  if Abort then Exit;
  if WantsPreview then AddCommand('21'+Dlm+
    ltrim(stri(arect.left,5))+Dlm+ltrim(stri(arect.top,5))+Dlm+
    ltrim(stri(arect.right,5))+Dlm+ltrim(stri(arect.bottom,5)))
  else begin
    with aCanvas do begin
      { if right>bottom then horizontal line }
      if arect.right>arect.bottom then pen.width:=arect.bottom
      else pen.width:=arect.right;
      if WindowDest then pen.width:=2;
      brush.style:=bsClear;
      moveto(ScaleX(arect.left),ScaleY(arect.top));
      if arect.right>arect.bottom then  { horizontal line }
        lineto(ScaleX(arect.left+arect.right),ScaleY(arect.top))
      else                  { vertical line }
        lineto(ScaleX(arect.left),ScaleY(arect.top+arect.bottom));
    end;
  end;
	EndCommand;
end;

procedure Lpr.pxBox(aRect:Trect;GrayLev:integer);
begin
  if Abort then Exit;
  if WantsPreview then AddCommand('22'+Dlm+
    ltrim(stri(arect.left,5))+Dlm+ltrim(stri(arect.top,5))+Dlm+
    ltrim(stri(arect.right,5))+Dlm+ltrim(stri(arect.bottom,5))+Dlm+
    ltrim(stri(graylev,5)))
  else begin
    with aCanvas do begin
      { if i3>i4 then its a horizontal box }
      brush.style:=bsSolid;
      if graylev=0 then brush.color:=clBlack else
        if graylev=1 then brush.color:=clWhite else begin
          { must use Yellow when printing light gray on paper }
          if WindowDest then brush.color:=clAqua else brush.color:=clYellow;
        end;
      fillrect(rect(ScaleX(arect.left),ScaleY(arect.top),
        ScaleX(arect.left+arect.right),ScaleY(arect.top+arect.bottom)));
    end;
  end;
	EndCommand;
end;

procedure Lpr.pxOrientation(newOrientation:TPrinterOrientation);
begin
  if WantsPreview then AddCommand('26'+Dlm+
	  iifs(newOrientation=poPortrait,'PORTRAIT','LANDSCAPE'))
	else begin
	  if Not WindowDest then begin
		  pr.Orientation:=newOrientation;
		  aCanvas:=pr.Canvas;
		end;
	end;
end;

procedure Lpr.pxImage(IsColor:boolean;aRect:Trect;BMPfile:string);
var MustScale:boolean;
begin
  if Abort then Exit;
  if WantsPreview then AddCommand('25'+Dlm+iifs(IsColor,'TRUE','FALSE')+Dlm+
    ltrim(stri(arect.left,5))+Dlm+ltrim(stri(arect.top,5))+Dlm+
    ltrim(stri(arect.right,5))+Dlm+ltrim(stri(arect.bottom,5))+Dlm+BMPfile)
  else begin
  	Gen.PrintBP.loadfromfile(BMPfile);
    aCanvas.Draw(ScaleX(arect.left),ScaleY(arect.top),Gen.PrintBP);
  end;
  EndCommand;
end;

procedure TPreview.ShowBigImage;
var tt,ll:integer;
    halfx,halfy,adjx,adjy,tx,ty:double;
    tr:trect;
begin
  if FitToScreen then begin
    image1.visible:=false;
    image2.visible:=true;
	  SetButtons;
  end else begin
    image2.visible:=false;
    if FirstTimeBig then MouseWait;
    with image1 do begin
	    adjx:=Gen.FullBP.width/width;
  	  adjy:=Gen.FullBP.height/height;
      { adjust BigX and BigY to correct relative position }
      tx:=BigX;
      ty:=BigY;
      { Scale X and Y from Image coords to Bitmap position }
      tX:=tX*adjx;
      tY:=tY*adjy;
      halfx:=width div 2;
      halfy:=height div 2;
      { set X dimensions }
			ll:=procint(strd(tX-halfx,0));
      if ll<0 then ll:=0;
      if ll>(gen.fullBP.width-width) then ll:=gen.fullBP.width-width;
      { set Y dimensions }
			tt:=procint(strd(tY-halfy,0));
      if tt<0 then tt:=0;
      if tt>(gen.fullBP.height-height) then tt:=gen.fullBP.height-height;
      tr:=rect(ll,tt,ll+width-1,tt+height-1);
	  	canvas.copyrect(canvas.cliprect,Gen.FullBP.canvas,tr);
      if ll>0 then button1.enabled:=true
      else button1.enabled:=false;
      if tt>0 then button3.enabled:=true
      else button3.enabled:=false;
      if ll<(gen.fullBP.width-width) then button4.enabled:=true
      else button4.enabled:=false;
      if tt<(gen.fullBP.height-height) then button2.enabled:=true
      else button2.enabled:=false;
    	visible:=true;
      DoEvents;
	    if FirstTimeBig then MouseGo;
      FirstTimeBig:=false;
    end;
  end;
end;

procedure lpr.SetCaption(toStr:string);
{ call before StopDoc }
begin
  ShortTitle:=toStr;
end;

procedure TPreview.ShowBluePrint(aCaption,TinyBMP,FullBMP:string);
begin
  if Gen.InBluePrint then begin
    OKbox('Can Only Have One Blue Print Open At A Time');
    close;
  end else begin
		windowstate:=wsNormal;
    Gen.InBluePrint:=true;
	  Zoomable:=true;
    image1.width:=613;
    image1.height:=337;
    image2.width:=613;
    image2.height:=337;
   	panel1.width:=image1.width;
    label1.caption:='Move>';
   	button3.caption:='&Up';
 	  button2.caption:='&Down';
    button1.caption:='&Left';
   	button4.caption:='&Right';
    caption:=aCaption;
  	FitToScreen:=true;
  	Gen.TinyBP.loadfromfile(TinyBmp);
  	Gen.TinyBP.monochrome:=true;
	  image2.canvas.draw(0,0,Gen.TinyBP);
  	Gen.FullBP.loadfromfile(FullBmp);
    FirstTimeBig:=true;
    show;
  	ShowBigImage;
  end;
end;

procedure Lpr.pxText(aPoint:TPoint;uzFont,TheText:string);
var curcol,atline:integer;
		tt1,tt2,msg:string135;
    i1,i2:longint;
begin
  if Abort then Exit;
	with aPoint do begin
		if WantsPreview then AddCommand('24'+Dlm+
			ltrim(stri(x,5))+Dlm+ltrim(stri(y,5))+Dlm+uzfont+Dlm+thetext)
		else begin
			with aCanvas do begin
				setGDIfont(uzfont);
				brush.style:=bsClear;
				wout(ScaleX(x),ScaleY(y),thetext);
			end;
		end;
	end;
	EndCommand;
end;

procedure Lpr.pxBarCode(aRect:Trect;Text:string);
begin
  if WantsPreview then AddCommand('27'+Dlm+
    stri(arect.left,5)+Dlm+stri(arect.top,5)+Dlm+stri(arect.right,5)+Dlm+
    stri(arect.bottom,5)+Dlm+text)
  else begin
    with preview.barcode1 do begin
      style:=3;
      if WindowDest then begin
        preview.barcode1.visible:=false;
        preview.barcode1.left:=ScaleX(arect.left);
        preview.barcode1.top:=ScaleY(arect.top);
        preview.barcode1.width:=ScaleX(arect.right);
        preview.barcode1.height:=ScaleY(arect.bottom);
        preview.barcode1.visible:=true;
        caption:=text;  { caption must be last item }
      end else begin
        caption:=text;
        printerscalemode:=3;
        printerleft:=ScaleX(arect.left);
        printertop:=ScaleY(arect.top);
        printerwidth:=ScaleX(arect.right);
        printerheight:=ScaleY(arect.bottom);
        printerhdc:=acanvas.handle;
      end;
    end;
  end;
  EndCommand;
end;

function  Lpr.LazInchX(Inches:double):integer;    { inches to 75 pixels/in }
begin
  result:=procint(strd(Inches*RefAspectXdbl,0));
end;

function  Lpr.LazInchY(Inches:double):integer;    { inches to 75 pixels/in }
begin
  result:=procint(strd(Inches*RefAspectYdbl,0));
end;

procedure Lpr.TextFont(NewFont:string);
begin
  if Abort then Exit;
  SetTextStyle(true);
	if WantsPreview then AddCommand(' 4'+Dlm+NewFont)
  else SetGDIfont(NewFont);
	EndCommand;
end;

function Lpr.Cancel:integer;  { usually found in FormClose method }
var bool:boolean;
begin
  Result:=0;
  if Running then begin
    bool:=YesNoBox('Cancel Printing');
    if bool then begin
      result:=2;  { abort }
      OKBox('After ''Wait'' Clears, You May Continue');
    end else result:=1;  { continue formatting }
  end;
  CancelState:=Result;
end;

procedure StartLinePrinter;
var ii:integer;
begin
  Lp:=LPmain.Create;
  for ii:=1 to MaxFonts do lp.FontList[ii]:='';
  lp.FontList[1]:='Courier New';
  {lp.FontList[2]:='Corporate Mono';}  { from TypeCase 2001 fonts CD collection }
  { variable width fonts are subscripts over 5 }
  lp.FontList[6]:='Arial';
  { setup local printer type }
  Lp.LoadPrinters('prninit.txt');
end;

procedure StopLinePrinter;
begin
  Lp.free;
end;

procedure Lpr.AddCommand(CommandStr:string);
begin
  if not InsideCommand then begin
	  InsideCommand:=true;
    { if using command below, "ff" in PlayBackPage S/B 3 }
    {Commands[ViewPageTot].add(stri(ViewPageTot,2)+Dlm+
      stri(Commands[ViewPageTot].count+1,3)+Dlm+CommandStr); }

    { if using command below, "ff" in PlayBackPage S/B 2 }
    Commands[ViewPageTot].add(stri(ViewPageTot,2)+Dlm+CommandStr);

    { Why 2 ways? I have a frequent short report that only takes up a half
      page, I store the results of the first in the top half, the next in
      the bottom half.  Then I use AddStrings() and Sort to merge the two
      pages before finally printing. }
	end;
end;

procedure Lpr.EndCommand;
begin
	InsideCommand:=false;
end;

procedure TPreview.LoadCommands(fromFile:string);
var LoadList:Tstringlist;
 		ii,jj:integer;
begin
  LoadList:=tstringlist.create;
  LoadList.loadfromfile(fromFile);
  wPageTot:=0;
  for jj:=1 to MaxPages do begin
    if wCommands[jj]<>nil then wCommands[jj].clear;
  end;
  for jj:=0 to LoadList.Count-1 do begin
    ii:=strtoint(copy(LoadList[jj],1,2));
    if ii<1 then ii:=1;
    if wCommands[ii]=nil then wCommands[ii]:=tstringlist.create;
    wCommands[ii].Add(LoadList[jj]);
    if ii>wPageTot then wPageTot:=ii;
  end;
  LoadList.free;
end;

procedure TPreview.SaveCommands(toFile:string);
var SaveList:Tstringlist;
 		jj:integer;
begin
  SaveList:=tstringlist.create;
  for jj:=1 to wPageTot do SaveList.AddStrings(wCommands[jj]);
  SaveList.savetofile(toFile);
  SaveList.free;
end;

function TPreview.PlayBackPage(ToScreen:boolean;PageNum:integer):boolean;
var lpp:Lpr;
    pcnt,opt,ii,jj,ff,start,finish:integer;
		pstr:array [1..8] of string135;
    tt,tt2:string;
begin
  { if Pagenum=0 then print all pages }
  lpp:=Lpr.Create;
  lpp.SetDestination;
  with lpp do begin
    CurDest:=wCurDest;
    WantsPreview:=false;
    WindowDest:=ToScreen;
    start:=PageNum;
    finish:=PageNum;
    if PageNum=0 then begin
	    start:=1;
  	  finish:=wPageTot;
    end;
		if ToScreen then begin
			if empty(wShortTitle) then caption:='Preview'
				else caption:=trim(wShortTitle);
      windowstate:=wsNormal;
		  aCanvas:=image1.canvas;
			StartDoc2(ToScreen,wRpWide,wShortTitle);
		end else begin
			if empty(wShortTitle) then lpp.preview.caption:='Printing'
				else lpp.preview.caption:='Printing '+trim(wShortTitle);
      lpp.useLandScape:=self.useLandScape;
		  StartDoc(wRpWide,wShortTitle);
		end;
    { debug line}
    {if Gen.User='BRAD ' then SaveCommands(TempPath('demoInfo.txt'));}
    for ii:=start to finish do begin
		  { find first entry }
      if ToScreen then begin
	      image1.canvas.brush.style:=bsSolid;
        image1.canvas.brush.color:=clWhite;
        image1.canvas.fillrect(image1.canvas.cliprect);
        image1.visible:=false;
        label2.caption:='Pg '+ltrim(stri(start,3))+
          ' of '+ltrim(stri(wPageTot,3));
        MouseWait;
      end;
			if wCommands[ii].count>0 then begin
			  for jj:=0 to wCommands[ii].count-1 do begin
          doevents2;
					split(wCommands[ii][jj],Dlm,pstr,pcnt);
          ff:=2;   { first field after page number and/or sequence no. }
					opt:=procint(pstr[ff]);
					case opt of
             { Row,Col style reports }
					   1:p(procint(pstr[ff+1]),procint(pstr[ff+2]),pstr[ff+3]);
					   2:SetRowCol(procint(pstr[ff+1]),procint(pstr[ff+2]));
					   3:CrLf;
					   4:TextFont(pstr[ff+1]);
             { Special Commands }
					   5:SetTextStyle(pin('TRUE',pstr[ff+1]));
		     		 { Raster style reports and called by above }
					  21:pxLine(Rect(procint(pstr[ff+1]),procint(pstr[ff+2]),
                 procint(pstr[ff+3]),procint(pstr[ff+4])));
					  22:pxBox(Rect(procint(pstr[ff+1]),procint(pstr[ff+2]),
                 procint(pstr[ff+3]),procint(pstr[ff+4])),procint(pstr[ff+5]));
					 	24:pxText(Point(procint(pstr[ff+1]),procint(pstr[ff+2])),pstr[ff+3],
                 pstr[ff+4]);
						25:pxImage(pin('TRUE',pstr[ff+1]),Rect(procint(pstr[ff+2]),
                 procint(pstr[ff+3]),
                 procint(pstr[ff+4]),procint(pstr[ff+5])),pstr[ff+6]);
						26:begin
						     if pin('PORTRAIT',pstr[ff+1]) then
									 pxOrientation(poPortrait)
								 else
									 pxOrientation(poLandScape);
							 end;
						27:pxBarCode(Rect(procint(pstr[ff+1]),procint(pstr[ff+2]),
                 procint(pstr[ff+3]),procint(pstr[ff+4])),pstr[ff+5]);
					  28:pxTray(procint(pstr[ff+1]));
					end;
				end;
			end else OKbox('Page '+inttostr(ii)+' Is Blank');
      { last page Eject in StopDoc }
      if ToScreen then begin
        MouseGo;
        SetButtons;
        image1.visible:=true;
      end;
			if not ToScreen and (ii<finish) then Eject;
    end;
		StopDoc;
  end;
	result:=(lpp.CancelState<>2);  { not cancelled }
  lpp.free;
end;

procedure TPreview.BitBtn6Click(Sender: TObject);
begin
  PlayBackPage(false,0);
end;

procedure TPreview.BitBtn1Click(Sender: TObject);
begin
  PlayBackPage(false,CurPage);
end;

procedure TPreview.Button3Click(Sender: TObject);
begin
  if zoomable then begin
    BigY:=BigY-ScrollPixels;
    if BigY<0 then BigY:=0;
    ShowBigImage;
  end else begin
	  Curpage:=1;
  	PlayBackPage(true,1);
  	SetButtons;
  end;
end;

procedure TPreview.Button4Click(Sender: TObject);
begin
  if zoomable then begin
    BigX:=BigX+ScrollPixels;
    ShowBigImage;
  end else begin
	  CurPage:=wPageTot;
  	PlayBackPage(true,CurPage);
  	SetButtons;
  end;
end;

procedure TPreview.Button2Click(Sender: TObject);
begin
  if zoomable then begin
    BigY:=BigY+ScrollPixels;
    ShowBigImage;
  end else begin
	  if CurPage>1 then begin
  	  CurPage:=CurPage-1;
    	PlayBackPage(true,CurPage);
		  SetButtons;
  	end;
  end;
end;

procedure TPreview.Button1Click(Sender: TObject);
begin
  if zoomable then begin
    BigX:=BigX-ScrollPixels;
    if BigX<0 then BigX:=0;
    ShowBigImage;
  end else begin
	  if CurPage<wPageTot then begin
  	  CurPage:=CurPage+1;
    	PlayBackPage(true,CurPage);
	    SetButtons;
		end;
  end;
end;

procedure TPreview.Edit1KeyPress(Sender: TObject; var Key: Char);
var ii:integer;
begin
  if getret(key) then begin
    ii:=procint(edit1.text);
    if (ii>0) and (ii<=wPageTot) then begin
	    CurPage:=ii;
  	  PlayBackPage(true,CurPage);
	    SetButtons;
  	end;
  end;
end;

procedure TPreview.SetButtons;
begin
  if Zoomable then begin
    button1.enabled:=not FitToScreen;
    button2.enabled:=not FitToScreen;
    button3.enabled:=not FitToScreen;
    button4.enabled:=not FitToScreen;
    { set popupmenu choices }
    Firstpg1.enabled:=false;
    Previouspg1.enabled:=false;
    bitbtn6.enabled:=false;
    gotopg1.enabled:=false;
    bitbtn1.enabled:=false;
    printall1.enabled:=false;
    printpg1.enabled:=false;
    Nextpg1.enabled:=false;
    Lastpg1.enabled:=false;
    edit1.enabled:=false;
  end else begin
    if wPageTot=1 then begin
      button1.enabled:=false;
      button2.enabled:=false;
      button3.enabled:=false;
      button4.enabled:=false;
      { set popupmenu choices }
      Firstpg1.enabled:=false;
      Previouspg1.enabled:=false;
      bitbtn6.enabled:=false;
      gotopg1.enabled:=false;
      printall1.enabled:=false;
      Nextpg1.enabled:=false;
      Lastpg1.enabled:=false;
      edit1.enabled:=false;
    end else begin
      button1.enabled:=true;
      button2.enabled:=true;
      button3.enabled:=true;
      button4.enabled:=true;
      Firstpg1.enabled:=true;
      Previouspg1.enabled:=true;
      Nextpg1.enabled:=true;
      Lastpg1.enabled:=true;
      edit1.enabled:=true;
      bitbtn6.enabled:=true;
      gotopg1.enabled:=true;
      printall1.enabled:=true;
      if CurPage=1 then begin
        button3.enabled:=false;
        button2.enabled:=false;
        Firstpg1.enabled:=false;
        Previouspg1.enabled:=false;
      end;
      if CurPage=wPageTot then begin
        button4.enabled:=false;
        button1.enabled:=false;
        Nextpg1.enabled:=false;
        Lastpg1.enabled:=false;
      end;
    end;
  end;
end;

procedure Lpr.ForceToScreen;
begin
  { override current print dest., force report to Report Preview }
  WantsPreview:=true;
  WindowDest:=true;
end;

procedure Lpr.ForceToPrinter;
begin
  { override current print dest., force report to a printer }
  WantsPreview:=false;
  WindowDest:=false;
end;

procedure TPreview.Close1Click(Sender: TObject);
begin
  Close;
end;

procedure TPreview.FirstPg1Click(Sender: TObject);
begin
  Curpage:=1;
  PlayBackPage(true,1);
  SetButtons;
end;

procedure TPreview.PreviousPg1Click(Sender: TObject);
begin
  if CurPage>1 then begin
    CurPage:=CurPage-1;
    PlayBackPage(true,CurPage);
	  SetButtons;
  end;
end;

procedure TPreview.NextPg1Click(Sender: TObject);
begin
  if CurPage<wPageTot then begin
    CurPage:=CurPage+1;
    PlayBackPage(true,CurPage);
    SetButtons;
	end;
end;

procedure TPreview.LastPg1Click(Sender: TObject);
begin
  CurPage:=wPageTot;
  PlayBackPage(true,CurPage);
  SetButtons;
end;

procedure TPreview.PrintAll1Click(Sender: TObject);
begin
  PlayBackPage(false,0);
end;

procedure TPreview.PrintPg1Click(Sender: TObject);
begin
  PlayBackPage(false,CurPage);
end;

procedure TPreview.FormShow(Sender: TObject);
begin
  top:=0;
  left:=0;
  centerhoriz(self);
end;

procedure LPmain.Capture(PortNum:integer;ToQueue:string);
{ Code below modified from Apiary Netware Lib, file:
 				 \apiary\examples\sdk\printca1.pas }
var {Flags1:NWCAPTURE_FLAGS1;
		Flags2:NWCAPTURE_FLAGS2;
    Conn:NWCONN_HANDLE;}
    Server,Lpt,None:array [0..50] of char;
    code:integer;
begin
  { Flag codes: $80 no banner, $40 no tab expansion, $08 no form feed }
	{if (PortNum>0) and (PortNum<4) then begin
  	if empty(ToQueue) then EndCapture(PortNum)
  	else begin
      NWGetDefaultConnectionID(Conn);
      strpcopy(Server,'\\PREC_DIE\'+upper(ToQueue));
      strpcopy(Lpt,'LPT'+inttostr(PortNum));
      strpcopy(none,'');
      EndCapture(PortNum);
      WNetAddConnection(Server,none,Lpt);
  	  code:=NWGetCaptureFlags(PortNum,Flags1,Flags2);
      Flags1.printFlags:=Flags1.printFlags and (not $80);
      Flags1.printFlags:=Flags1.printFlags and (not $40);
      Flags1.printFlags:=Flags1.printFlags or $08;
  	  code:=NWSetCaptureFlags(Conn,PortNum,Flags1);
  	end;
	end else OKbox('Error: Tried To Start Capture On Lpt'+inttostr(Portnum)+
    ':');}
end;

procedure LPmain.EndCapture(PortNum:integer);
begin
  if (PortNum>0) and (PortNum<4) then begin
    {NWFlushCapture(PortNum);
    NWEndCapture(PortNum);}
  end else OKbox('Error: Tried To End Capture On Lpt'+inttostr(Portnum)+
    ':');
end;

procedure TPreview.Image1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if zoomable then begin
    FitToScreen:=not FitToScreen;
	  BigX:=x;
  	BigY:=Y;
  	ShowBigImage;
  end;
end;

procedure TPreview.Image2MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if zoomable then begin
	  FitToScreen:=not FitToScreen;
  	BigX:=x;
  	BigY:=Y;
  	ShowBigImage;
  end;
end;

procedure TPreview.GoToPg1Click(Sender: TObject);
var ii:integer;
begin
  ii:=procint(InputBox('Go To','Page #',''));
  if (ii>0) and (ii<=wPageTot) then begin
    CurPage:=ii;
    PlayBackPage(true,CurPage);
    SetButtons;
  end;
end;

procedure TPreview.PrintCommandFile(aLoadSpec:string);
var ii:integer;
    tt,tt2:string;
begin
	ii:=pos('::',upper(aLoadSpec));
  if ii>0 then begin
		tt:=ltrim(trim(substr(aLoadSpec,ii+2,70)));
    wShortTitle:=aLoadSpec;
		if not FileExists(tt) then begin
      OkBox('Pre-Load File Not Found: '+tt);
      close;
		end else begin
			LoadCommands(tt);
	    wCurDest:=lp.curdest;
		  wRpWide:=pin('for14x11',wCommands[1][0]);
		  wShortTitle:=GetTitle(wCommands[1][0]);
			if lp.WantsPreview then begin
				windowstate:=wsNormal;
			  PlayBackPage(true,1);
			end else begin
				windowstate:=wsMinimized;
			  PlayBackPage(false,0);
			end;
		end;
	end;
end;

end.
