unit JcCommon;

interface

Uses SysUtils,Classes,DBFserver,CommonCode;

Const CRMAX=30;
			MaxDue=75;
      MaxTools=25;
			MaxLots=100;
			MaxDeps=45;

type
  JCMainRec=Class(TObject)
	public
		qcgang:string[70];
		{ Job Inquiry DBF's }
		jobs,due,ship,labor,outside,cust,parts:oDB;
		tools,jipinfo,invshelf,assembly,jobitems:oDB;
		invmat,outjobs,poprcdel,outpo,vendors:oDB;
		matspecs,porders,crosref,packets:oDB;
		{ following used by cross ref. routines }
    crcnt,crroot,mcrcnt,mcrroot:integer;
 	  crmaincn,crorgcn,crosnode,mcrmaincn,mcrorgcn,mcrosnode:string[6];
	  crmainpn,crorgpn,mcrmainpn,mcrorgpn:string[20];
		crcust,mcrcust:array [1..CRMAX] of string[6];
		crmain,mcrmain:array [1..CRMAX] of boolean;
		crnote,mcrnote:array [1..CRMAX] of string[60];
		crpn,mcrpn:array [1..CRMAX] of string[20];
		crrec,mcrrec:array [1..CRMAX] of longint;
    clist:array [1..30] of string[6];
    olots,suffixes:array [1..MaxLots] of string[3];
	  depcnt:integer;
		depcode:array [1..MaxDeps] of string10;
		depname:array [1..MaxDeps] of string80;
		constructor Create;
		function  croscust(pnum:string;aliasname,history,cust:oDB;
			pnsrc:boolean):string;
		function  crosload(partnum,custnum:string;crosref:oDB):boolean;
		procedure flagstpos(job_num:string;stype:array of integer);
		function  mcrosload(partnum,custnum:string;crosmat:oDB):boolean;
		function  oldlots(orgpo:string):string;
		function  Endlot(curlot:string;shiftup:boolean):string;
		procedure LoadDepList;
    function  vdiv( dnum:string ):boolean;
    function  ndiv( dnum:string ):string;
    function  rngdep( subnum:integer ):string;
    function  vdep( dnum:integer ):boolean;
    function  pdep( dnum:string ):integer;
    function  ndep( dnum:string ):string;
  end;
  JobRec=Class(TObject)
	public
	  { oDB's used by "Load()", must be open }
    jobs,due,ship,cust,parts,jipinfo,jobitems:oDB;
	  { oDB's to used by "LoadInv", only open as needed }
		labor,outside,tools,invshelf,assembly:oDB;
		invmat,outjobs,poprcdel,outpo,vendors:oDB;
		matspecs,porders,crosref,packets:oDB;
    { the following are the original values,
      reset to these if a change is aborted }
    { drecs[] always contains the current list of due records }
    oscnt,ocnt,ojstatus:integer;
    odates:array [1..MaxDue] of longint;
    odqty:array [1..MaxDue] of double;
    oqty,ouprice:double;
    oponum:string[32];
    orevnum:string[12];
    omotdate,ostatdate:longint;
    { the following may be changed }
    jobnum,joblink,revnum,custref,depnum,barfai,waitstatus:string[12];
    billnum,lineitem,shipnum,custnum,clozapprov,lotmadeto:string[6];
		lotinspto,lotshipto:string[6];
    partname,buyer,custname,partnum,ponum,tobpless:string[40];
    qty,orgqty,uprice,addon,totdue,totship,material:double;
		otherup,otherchgs,mater_est,proc_est,labor_est,bid,complete,partial:double;
		othertext:string;
		uptext,note1,note2,note3:string[60];
    tcnt,dcnt,scnt,jstatus,StillDue,matsel,procsel:integer;
		recnum,orderdate,motdate,statdate,setupdate,porecdate,lastchange:longint;
    SaveData,taxable,ourmat,tobp,islocked:boolean;
    jobchg,duechg,shipchg,jipchg,itemschg:boolean;
    divname,depname,invless:string[30];
    { following used to track special cost items }
    specitem:array [1..3] of string[5];
    speccom:array [1..3] of string[25];
    specup:array [1..3] of double;
    specper:array [1..3] of string[3];
    ttrems:array [1..5] of string[30]; {trip ticket remarks}
		mat1,mat2:string[35];
    sinv,ddates,sdates,drecs,srecs:array [1..MaxDue] of longint;
    sshippr:array [1..MaxDue] of string[15];
    dqty,sqty:array [1..MaxDue] of double;
    dstat:array [1..MaxDue] of integer;
    slot,svia:array [1..MaxDue] of string[5];
    toolsa:array [1..MaxTools] of string[30];
		constructor Create;
		function  Load(jbnum:string;WithLock:boolean):boolean;
		procedure Save;
		procedure QuickInfo;  { report }
		procedure LoadInv(var totdone,totless:longint;
			var InvStr:array of string135;var invcnt:integer);
		procedure ChkRevNo(forpn:string);
		procedure LdmSpec(var rtt,rtt2:string);
		procedure RunBal(rettot:double;
			var InvStr:array of string135;var atpos:integer;maxents:integer);
  end;

procedure StartJCcommon;
procedure StopJCcommon;
function  fCurLot(apat:string):integer;
function  GetJStatus(jstat:integer;statdate:longint):String;
procedure CrosGroup(frominv:boolean;var tcustname,tcustnum,tourvend:string);
function  ShortEName(ename:string;lnamelen:integer):string;
function  WaitCode(mwait:string):string;

var jcm:JCMainRec;

implementation

uses wPreview,wAboutbx;

procedure StartJCcommon;
begin
  ClearFlagUse;  { at startup }
  jcm:=JCMainRec.Create;
end;

constructor JobRec.Create;
begin
	jobs:=Nil;
	due:=Nil;
	ship:=Nil;
	labor:=Nil;
	outside:=Nil;
	cust:=Nil;
	parts:=Nil;
	tools:=Nil;
	jipinfo:=Nil;
	invshelf:=Nil;
	assembly:=Nil;
	jobitems:=Nil;
	invmat:=Nil;
	outjobs:=Nil;
	poprcdel:=Nil;
	outpo:=Nil;
	vendors:=Nil;
	matspecs:=Nil;
	porders:=Nil;
	crosref:=Nil;
  packets:=nil;
end;

constructor JCMainRec.Create;
begin
	qcgang:='RUDY TOM CARLOS ';
	jobs:=Nil;
	due:=Nil;
	ship:=Nil;
	labor:=Nil;
	outside:=Nil;
	cust:=Nil;
	parts:=Nil;
	tools:=Nil;
	jipinfo:=Nil;
	invshelf:=Nil;
	assembly:=Nil;
	jobitems:=Nil;
	invmat:=Nil;
	outjobs:=Nil;
	poprcdel:=Nil;
	outpo:=Nil;
	vendors:=Nil;
	matspecs:=Nil;
	porders:=Nil;
	crosref:=Nil;
  packets:=nil;
  LoadDepList;
end;

procedure StopJCcommon;
begin
  ClearFlagUse;  { at shutdown }
  jcm.free;
end;

function GetJStatus(jstat:integer;statdate:longint):String;
begin
  Result:='';
  case jstat of
    1: Result:='Cancelled  '+dshyph(statdate);
    2: Result:='Completed  '+dshyph(statdate);
    3: Result:='Closed  '+dshyph(statdate);
  end;
end;

procedure JCMainRec.flagstpos(job_num:string;stype:array of integer);
var tt:string[60];
    changlog:oDB;
    ii:integer;
begin
  changlog:=Nil;
{ log when changes were made to any job info: labor,due/ship dates,costs,etc }
	with jcm do begin
		dbUse(changlog,compath('changlog'));
		if Not empty(job_num) then begin
			if changlog.Seek(job_num) then begin
				if Not changlog.aLock then begin
					dbClose(changlog);
					exit;
				End;
			End Else
			Begin
				changlog.Append;
			End;
			changlog.ss('job_no',job_num);
			changlog.ss('change_1',changlog.s('change_2'));
			changlog.ss('change_2',changlog.s('change_3'));
			changlog.ss('change_3',changlog.s('change_4'));
			changlog.ss('change_4',changlog.s('change_5'));
			changlog.ss('change_5',changlog.s('mostrecent'));
			tt:=datehyph(xDate)+' '+Gen.EmpNum+' ';
			for ii:=1 to 11 do begin
				if stype[ii]>0 then begin
					tt:=tt+(chr(ii+64));
				End;
			End;
			changlog.ss('mostrecent',tt);
		End;
		dbClose(changlog);
	end;
end;


function shortename(ename:string;lnamelen:integer):string;
var tname:string[30];
    start:integer;
begin
  if Gen.AtPDS then begin
    if pos('AGIET',upper(ename))>0 then begin  { special case for Agietron }
      Result:=Copy('  AGIE    ',1,lnamelen+2);
    End;
  End;
  tname:=Copy(ename,1,1)+' ';
  if pos(',',ename)>1 then begin
    ename:=Copy(ename,1,pos(',',ename)-1);
  End;
  if pos('.',ename) = 0 then begin
    start:=pos(' ',ename)+1;
  End Else
  Begin
    start:=pos('.',ename)+2;
  End;
  if start=0 then begin
    start := 1;
  End;
  tname:=tname + Copy(ename,start,lnamelen);
  Result:=upper(tname);
end;


function waitcode(mwait:string):string;
begin
  if mwait='WFM  ' then begin
    Result:='WAITING FOR MATERIAL';
  end else
  if mwait='WFPO ' then begin
    Result:='WAITING FOR HARDCOPY P.O.';
  end Else Result:=mwait;
end;

function JCMainRec.croscust(pnum:string;aliasname,history,cust:oDB;
  pnsrc:boolean):string;
var ii,icnt,jj:integer;
    res,oarea,maincnt:integer;
    cnum,tseke:string[10];
		harea,carea:boolean;
begin
	harea:=dbIsClosed(history);
	if harea then dbUse(history,jcpath('history'));
	carea:=dbIsClosed(cust);
	if carea then dbUse(cust,compath('cust'));
	icnt:=0;
	maincnt:=0;  { track position of main ref. }
	cnum:=space(6);
	if history.Seek(pnum) then begin
		While (Not history.Eof) And (history.s('part_no')=pnum) do begin
			DoEvents2;
			if (history.Seek(history.s('cust_no'))) And 
			    (history.s('fclass')<>'*') then begin
				jj:=0;
				if icnt>0 then begin
					for ii:=1 to icnt do begin
						DoEvents2;
						if history.s('cust_no')=jcm.clist[ii] then begin
							jj:=ii;
							break;
						End;
					End;
				End;
				if (jj=0) And (icnt<40) then begin
					pp(icnt);
					jcm.clist[icnt]:=history.s('cust_no');
				End;
			End;
			history.Skip;
		End;
	End;
	if aliasname.Seek(pnum) then begin
		While (Not aliasname.Eof) And 
		    (aliasname.s('part_no')=pnum) do begin
			DoEvents2;
			tseke:=aliasname.s('cust_no');
			if (cust.Seek(tseke)) And (cust.s('fclass')<>'*') then begin
				jj:=0;
				for ii:=1 to icnt do begin
					DoEvents2;
					if aliasname.s('cust_no')=jcm.clist[ii] then begin
						jj:=ii;
						break;
					End;
				End;
				if (jj=0) And (icnt<40) then begin
					pp(icnt);
					jj:=icnt;
					jcm.clist[icnt]:=aliasname.s('cust_no');
				End;
				if jj>0 then begin
					if aliasname.b('mainref') then begin
						maincnt:=jj;
					End;
				End;
			End;
			aliasname.Skip;
		End;
	End;
	if harea then dbClose(history);
	if carea then dbClose(cust);
	Result:=cnum;
end;


function JCMainRec.crosload(partnum,custnum:string;crosref:oDB):boolean;
var ii,oarea:integer;
    crarea,bool:boolean;
begin
	with jcm do begin
		crcnt:=0;
		crosnode:=space(5);
		crmainpn:=space(20);
		crmaincn:=space(6);
		crorgpn:=partnum;
		crorgcn:=custnum;
		crroot:=0;
		crarea:=dbIsClosed(crosref);
		if crarea then dbUse(crosref,jcpath('crosref'));
		for ii:=1 to CRMAX do crpn[ii]:=space(20);
		for ii:=1 to CRMAX do crcust[ii]:=space(6);
		for ii:=1 to CRMAX do crmain[ii]:=False;
		for ii:=1 to CRMAX do crnote[ii]:=' ';
		for ii:=1 to CRMAX do crrec[ii]:=0;
		if empty(custnum) then begin
			custnum:=croscust(partnum,crosref,Nil,Nil,true);
			crorgcn:=custnum;
		End;
		if crosref.Seek(partnum+custnum) then begin
			crosnode:=crosref.s('node');
			crosref.SetOrder(2);
			crosref.Seek(crosnode);
			While (Not crosref.Eof) And (crosnode=crosref.s('node')) And
					(crcnt<CRMAX) do begin
				DoEvents2;
				pp(crcnt);
				crpn[crcnt]:=crosref.s('part_no');
				crcust[crcnt]:=crosref.s('cust_no');
				crmain[crcnt]:=crosref.b('mainref');
				if crmain[crcnt] then begin
					crroot:=crcnt;
					crmainpn:=crpn[crcnt];
					crmaincn:=crcust[crcnt];
				End;
				crnote[crcnt]:=crosref.s('note');
				crrec[crcnt]:=crosref.RecNo;
				crosref.Skip;
			End;
			crosref.SetOrder(1);
		End;
		{ even if no cross ref, set main pn and cust no to the orig. params }
		if empty(crmainpn) then begin  { no main ref }
			crmainpn:=partnum;
			crmaincn:=custnum;
		End;
		if crarea then dbClose(crosref);
		if crcnt>0 then begin
			Result:=True;  { found at least one ref. }
		End;
		Result:=False;
	end;
end;


function JCMainRec.mcrosload(partnum,custnum:string;crosmat:oDB):boolean;
var ii,oarea:integer;
    crarea,bool:boolean;
begin
	with jcm do begin
		crarea:=dbIsClosed(crosmat);
		if crarea then dbUse(crosmat,jcpath('crosmat'));
		mcrcnt:=0;
		mcrroot:=0;
		mcrosnode:=space(5);
		mcrmainpn:=space(20);
		mcrmaincn:=space(6);
		mcrorgpn:=partnum;
		mcrorgcn:=custnum;
		for ii:=1 to CRMAX do mcrpn[ii]:=space(20);
		for ii:=1 to CRMAX do mcrcust[ii]:=space(6);
		for ii:=1 to CRMAX do mcrmain[ii]:=False;
		for ii:=1 to CRMAX do mcrnote[ii]:=' ';
		for ii:=1 to CRMAX do mcrrec[ii]:=0;
		if empty(custnum) then begin
			custnum:=croscust(partnum,crosmat,Nil,Nil,false);
			mcrorgcn:=custnum;
		End;
		if crosmat.Seek(partnum+custnum) then begin
			mcrosnode:=crosmat.s('node');
			crosmat.SetOrder(2);
			crosmat.Seek(mcrosnode);
			While (Not crosmat.eof) And
			  (mcrosnode=crosmat.s('node')) And
				(mcrcnt<CRMAX) do begin
				DoEvents2;
				pp(mcrcnt);
				mcrpn[mcrcnt]:=crosmat.s('part_no');
				mcrcust[mcrcnt]:=crosmat.s('cust_no');
				mcrmain[mcrcnt]:=crosmat.b('mainref');
				if mcrmain[mcrcnt] then begin
					mcrroot:=mcrcnt;
					mcrmainpn:=mcrpn[mcrcnt];
					mcrmaincn:=mcrcust[mcrcnt];
				End;
				mcrnote[mcrcnt]:=crosmat.s('note');
				mcrrec[mcrcnt]:=crosmat.RecNo;
				crosmat.Skip;
			End;
			crosmat.SetOrder(1);
		End;
		{ even if no cross ref, set main pn and cust no to the orig. params }
		if empty(mcrmainpn) then begin  { no main ref }
			mcrmainpn:=partnum;
			mcrmaincn:=custnum;
		End;
		if crarea then dbClose(crosmat);
		if mcrcnt>0 then begin
			Result:=True;  { found at least one ref. }
		End;
		Result:=False;
	end;
end;


function JCMainRec.Endlot(curlot:string;shiftup:boolean):string;
{ also see oldlots() below to get old style when printing }
var tparscnt,ii,level,jj,llen:integer;
    tpars:array [1..10] of string135;
    corejob:string[10];
begin
	with jcm do begin
		for ii:=1 to MAXLOTS do suffixes[ii]:=' ';
		tparscnt:=0;
		llen:=length(curlot);
		for ii:=1 to 10 do tpars[ii]:='';
		corejob:=' ';
		ii:=pos('-',curlot);
		tpars[1]:=trim(curlot);
		if ii>1 then begin  { when called from P.O. routine }
			split(curlot,'-',tpars,tparscnt);
			corejob:=tpars[1];
			tpars[1]:=tpars[2];
		End Else
		Begin
			if (ProcDbl(tpars[1])>0) And (length(tpars[1])>2) then begin
				corejob:=tpars[1];
				tpars[1]:='  ';
			End Else
			Begin
				tpars[1]:=Copy(curlot,1,2);
			End;
		End;
		{ lots are: 01-99, keep to 2 chars if possible }
		suffixes[1]:='  ';
		for ii:=2 to 100 do begin
			DoEvents2;
			if ii<11 then begin
				suffixes[ii]:='0'+transform(ii-1,'9');
			End Else
			Begin
				suffixes[ii]:=transform(ii-1,'99');
			End;
		End;
		tpars[1]:=padr(tpars[1],2);
		jj:=fcurlot(tpars[1]);
		if shiftup then begin
			pp(jj);
		End Else
		Begin
			jj:=jj-1;
		End;
		if (jj>0) And (jj<=MAXLOTS) then begin
			tpars[1]:=suffixes[jj];
		End;
		if Not empty(corejob) then begin
			if Not empty(tpars[1]) then begin
				tpars[1]:=corejob+'-'+tpars[1];
			End Else
			Begin
				tpars[1]:=corejob;
			End;
		End;
		if llen>length(tpars[1]) then begin
			Result:=padr(tpars[1],llen);
		End Else
		Begin
			Result:=tpars[1];
		End;
	end;
end;


function fcurlot(apat:string):integer;
var ii,jj:integer;
begin
  jj:=0;
  apat:=Copy(apat,1,2);
  for ii:=1 to MAXLOTS do begin
    if apat=jcm.suffixes[ii] then begin
      jj:=ii;
      break;
    End;
  End;
  Result:=jj;
end;


function JCMainRec.oldlots(orgpo:string):string;
var pc1,pc2:string[20];
    ii,jj,kk,ll:integer;
    ret:string[10];
begin
	with jcm do begin
		olots[1]:=' ';
		olots[2]:='A';
		olots[3]:='B';
		olots[4]:='C';
		olots[5]:='D';
		olots[6]:='E';
		olots[7]:='F';
		olots[8]:='G';
		olots[9]:='H';
		olots[10]:='J';
		olots[11]:='K';
		olots[12]:='L';
		olots[13]:='M';
		olots[14]:='N';
		olots[15]:='P';
		olots[16]:='Q';
		olots[17]:='R';
		olots[18]:='S';
		olots[19]:='T';
		olots[20]:='U';
		olots[21]:='V';
		olots[22]:='W';
		olots[23]:='X';
		olots[24]:='Y';
		olots[25]:='Z';
		olots[26]:='AA';
		olots[27]:='AB';
		olots[28]:='AC';
		olots[29]:='AD';
		olots[30]:='AE';
		olots[31]:='AF';
		olots[32]:='AG';
		olots[33]:='AH';
		olots[34]:='AJ';
		olots[35]:='AK';
		olots[36]:='AL';
		olots[37]:='AM';
		olots[38]:='AN';
		olots[39]:='AP';
		olots[40]:='AQ';
		olots[41]:='AR';
		olots[42]:='AS';
		olots[43]:='AT';
		olots[44]:='AU';
		olots[45]:='AV';
		olots[46]:='AW';
		olots[47]:='AX';
		olots[48]:='AY';
		olots[49]:='AZ';
		ll:=length(orgpo);
		if empty(orgpo) then begin
			Result:=orgpo;
		End;
		ii:=pos('-',orgpo);
		ret:=orgpo;
		if (length(trim(orgpo))<9) And (pos('-',orgpo)>0) then begin
			jj:=fcurlot(orgpo);
			if (jj>0) And (jj<51) then begin
				pc1:=Copy(orgpo,1,ii-1);
				pc2:=trim(Copy(orgpo,ii+1,6));
				if jj=2 then begin
					ret:=pc1;
				End Else
				Begin
					ret:=pc1+'-'+olots[jj-1];
				End;
			End;
		End;
		Result:=ret;
	end;
end;

function oktoload(thisrec:longint;reclist:array of longint):boolean;
var ii,jj:integer;
begin
  jj:=-1;
  result:=True;
  ii:=high(reclist);
  for ii:=0 to high(reclist) do begin
    if thisrec=reclist[ii] then begin
      jj:=ii;
      break;
    End;
  End;
  if jj>=0 then begin
    result:=False;
  End;
end;

procedure AddInv(tt:string;var InvStr:array of String135;
	var atpos:integer;MaxEnts:integer);
begin
  if atpos<MaxEnts then begin
    pp(atpos);
    InvStr[atpos]:=tt;
  end;
end;

procedure JobRec.runbal(rettot:double;
  var InvStr:array of string135;var atpos:integer;maxents:integer);
var ii,mm,kk,yy,jj,xx:integer;
		bool:boolean;
    tdue,tship,duesum:double;
    inventor:oDB;
		jlist,jfnd:TStringList;
    tt:string;
		dlist:array [0..100] of longint;
		qlist,jbal:array [0..100] of double;
begin
  inventor:=Nil;
  jlist:=Tstringlist.create;
  jfnd:=Tstringlist.create;
  dbUse(inventor,jcpath('inventor'));
  if empty(custnum) then begin
    if inventor.Seek(partnum) then begin
      custnum:=inventor.s('cust_no');
    End;
  End;
  jcm.crosload(partnum,custnum,nil);
  { check to see if part and cust valid entries, even if they may }
  { not be main refs. in some situations }
  if (parts.Seek(jcm.crmainpn)) And (cust.Seek(jcm.crmaincn)) And
    (Not empty(jcm.crmaincn)) then begin
    if Not inventor.Seek(jcm.crmainpn+jcm.crmaincn) then begin
      inventor.Append;
      inventor.ss('part_no',jcm.crmainpn);
      inventor.ss('cust_no',jcm.crmaincn);
      inventor.ss('div_no','1 ');
      inventor.unLock;
    End;
  End;
  inventor.Seek(jcm.crmainpn+jcm.crmaincn);
  { now load due date list }
  if jcm.crcnt=0 then begin
    jcm.crcnt:=1;
    jcm.crpn[1]:=jcm.crmainpn;
    jcm.crcust[1]:=jcm.crmaincn;
  End;
  jobs.setorder(2);
  for ii:=1 to jcm.crcnt do begin
    if jobs.Seek(jcm.crpn[ii]) then begin
      bool:=False;
      { check to see if part already done }
      if ii>1 then begin
        for kk:=1 to ii-1 do begin
          if jcm.crpn[kk]=jcm.crpn[ii] then begin
            bool:=True;
            break;
          End;
        End;
      End;
      if Not bool then begin  { haven't calculated for this part yet }
        While (Not jobs.Eof) And
				  (jcm.crpn[ii]=jobs.s('part_no')) do begin
          if jobs.f('jstatus')=0 then begin
            tship:=0;
            if ship.Seek(jobs.s('job_no')) then begin
              While (Not ship.Eof) And
							  (jobs.s('job_no')=ship.s('job_no')) do begin
                tship:=tship+(ship.f('qty'));
                ship.Skip;
              End;
            End;
            mm:=-1;
            if jfnd.count>0 then begin
              for jj:=0 to jfnd.count-1 do begin
                if jobs.s('job_no')=jfnd[jj] then begin
                  mm:=jj;
                  break;
                End;
              End;
            End;
            if mm<0 then begin
						  jfnd.add(jobs.s('job_no')+
							  transform(jobs.f('qty')-tship,'99999999'));
              tdue:=0;
              if due.Seek(jobs.s('job_no')) then begin
                While (Not due.Eof) And
                  (jobs.s('job_no')=due.s('job_no'))
                  do begin
                  tdue:=tdue+(due.f('qty'));
                  { go out 1 yr. }
                  if (tdue>tship) And
                    ((due.d('fdate')<=(datemath(xDate,380))) or
										(due.d('fdate')>=ctod('01/01/99')))
                    then begin
                    jlist.add(dtos(due.d('fdate'))+
                      due.s('job_no')+
                      transform(due.f('qty'),'99999999'));
                  End;
                  due.Skip;
                End;
              end;
            End;
          End;
          jobs.Skip;
        End;
      End;
    End;
  End;
  if jlist.count>0 then begin
    { sort individual entries }
    jlist.sort;
    for ii:=0 to jlist.count-1 do begin
      { these items must be in this order of assignment
        because dlist and qlist need jlist before jlist is changed }
      dlist[ii]:=stod(Copy(jlist[ii],1,8));
      qlist[ii]:=ProcDbl(Copy(jlist[ii],19,8));
      jlist[ii]:=Copy(jlist[ii],9,10);
    End;
    { sort job totals }
  End;
  if jfnd.count>0 then begin
    jfnd.sort;
    for ii:=0 to jfnd.count-1 do begin
      jbal[ii]:=ProcDbl(Copy(jfnd[ii],11,8));
      jfnd[ii]:=Copy(jfnd[ii],1,10);
    End;
  End;
  addinv('',invstr,atpos,maxents);
  addinv(space(14)+'DELIVERY REQUIREMENTS',invstr,atpos,maxents);
  addinv('',invstr,atpos,maxents);
  tt:=space(11)+'Current:  '+transform(rettot,'99,999,999')+
  	'    Balance';
  addinv(tt,invstr,atpos,maxents);
  duesum:=0;
  for ii:=0 to jlist.count-1 do begin
    tt:='  '+copy(jlist[ii],1,8)+dshyph(dlist[ii])+
    	'   '+transform(qlist[ii],'99,999,999');
    duesum:=duesum+(qlist[ii]);
    tt:=tt+'  '+transform(rettot-duesum,'99,999,999');
	  addinv(tt,invstr,atpos,maxents);
  End;
  addinv('',invstr,atpos,maxents);
  tt:=space(16)+'TOTAL BAL. DUE';
  addinv(tt,invstr,atpos,maxents);
  addinv('',invstr,atpos,maxents);
  tdue:=0;
  for ii:=0 to jfnd.count-1 do begin
    tt:=space(9)+jfnd[ii]+'  '+transform(jbal[ii],'99,999,999');
	  addinv(tt,invstr,atpos,maxents);
    tdue:=tdue+(jbal[ii]);
  end;
  addinv('',invstr,atpos,maxents);
  tt:=space(15)+'TOTAL '+transform(tdue,'99,999,999');
  addinv(tt,invstr,atpos,maxents);
  jobs.setorder(1);
  dbClose(inventor);
  pp(atpos);  { add when so it is correct after returning }
 	jlist.free;
 	jfnd.free;
end;

procedure JobRec.LoadInv(var totdone,totless:longint;
  var InvStr:array of string135;var invcnt:integer);
var curarea,maxents,ii,jj,kk,rcnt:integer;
		tcustname,tt,tt2,tt3:string135;
    t1,t2,t3,tdone,tless:longint;
		rlist:array [1..50] of longint;
		hcnt,seln:integer;
		ojarea,ojdone,oparea,ovarea,oim:boolean;
    lastpo:string[20];
		tpounds,tcount:double;
		lastin:longint;
begin
	oim:=dbIsClosed(invmat);
	ojarea:=dbIsClosed(outjobs);
	ojdone:=dbIsClosed(poprcdel);
	oparea:=dbIsClosed(outpo);
	ovarea:=dbIsClosed(vendors);
	if oim then dbUse(invmat,jcpath('invmat'));
	if ojarea then dbUse(outjobs,jcpath('outjobs'));
	if ojdone then dbUse(poprcdel,jcpath('poprcdel'));
	if ovarea then dbUse(vendors,compath('vendors'));
	if oparea then begin
	  dbUse(outpo,jcpath('outpo'));
		outpo.SetOrder(2);
	End;
  maxents:=high(InvStr);
  invcnt:=-1;
  for ii:=1 to 50 do rlist[ii]:=0;
  for ii:=0 to maxents do invstr[ii]:='';
  if not empty(jobnum) then begin
    jcm.crosload(partnum,custnum,nil);
    cust.Seek(custnum);
    tcustname:=upper(cust.s('name'));
    if jcm.crcnt=0 then begin
      jcm.crcnt:=1;
      jcm.crpn[1]:=partnum;
      jcm.crcust[1]:=custnum;
    End;
    tt:=tcustname;
    tt2:=custnum;
    tt3:='';
    crosgroup(True,tt,tt2,tt3);
    if tt2<>custnum then begin
      pp(jcm.crcnt);
      jcm.crpn[jcm.crcnt]:=partnum;
      jcm.crcust[jcm.crcnt]:=tt2;
    End;
    totdone:=0;
    totless:=0;
    invcnt:= -1; { string array is zero based }
    rcnt:=0;
    for ii:=1 to jcm.crcnt do begin
      if invshelf.Seek(jcm.crpn[ii]+jcm.crcust[ii]) then begin
        While (Not invshelf.Eof) And
				  (jcm.crpn[ii]=invshelf.s('part_no'))
          And (jcm.crcust[ii]=invshelf.s('cust_no')) do begin
          { only load data when adjusting }
          tt:='';
					DoEvents2;
          if invcnt<maxents then begin
						{ this record hasn't been loaded yet }
            if oktoload(invshelf.RecNo,rlist) then begin
              pp(rcnt);
              rlist[rcnt]:=invshelf.RecNo;
              invcnt:=invcnt+1;
              tdone:=0;
              tless:=0;
							t1:=invshelf.l('donecnt');
							t2:=invshelf.l('doneat');
							t3:=invshelf.l('doneodd');
              if not invshelf.b('incomplete') then begin
                tdone:=(t1*t2)+t3;
              end else begin
                tless:=(t1*t2)+t3;
              end;
              totless:=totless+tless;
              totdone:=totdone+tdone;
              tt:='';
              tt:=tt+invshelf.st('part_no');
              if not empty(invshelf.st('rev_no')) then
                tt:=tt+' '''+invshelf.st('rev_no')+'''';
              tt:=padr(tt,17);
              tt:=tt+' S.O. '+invshelf.sn('lot_no',7);
              tt:=tt+' Loc. '+Copy(invshelf.s('location'),1,3);
              tt:=tt+' Inv# '+ltrim(invshelf.s('inv_no'));
			        addinv(tt,invstr,invcnt,maxents);
              if tdone>0 then
                tt:='   '+ltrim(ltransform(tdone,'99,999,999'))+
                  ' Complete'
              else
                tt:='   '+ltrim(ltransform(tless,'99,999,999'))+
                  ' Incomplete';
							tt:=tt+'  Updated '+
							  datehyph(invshelf.d('lastupdate'));
             	addinv(tt,invstr,invcnt,maxents);
							tt:=invshelf.st('comment1')+
							  invshelf.st('comment2');
							if not empty(tt) then begin
               	addinv('   '+tt,invstr,invcnt,maxents);
							end;
            end;
          End;
          invshelf.Skip;
        End;
      End;
			if assembly.Seek(jcm.crpn[ii]) then begin
				While (Not assembly.Eof) And
				  (jcm.crpn[ii]=assembly.s('assy_no')) do begin
					if (invshelf.Seek(assembly.s('part_no'))) then begin
						While (Not invshelf.Eof) And
						(invshelf.s('part_no')=assembly.s('part_no'))
						do begin
							if (invcnt<maxents) and
									(oktoload(invshelf.RecNo,rlist)) then begin
								rcnt:=rcnt+1;
								rlist[rcnt]:=invshelf.RecNo;
								invcnt:=invcnt+1;
								tdone:=0;
								tless:=0;
								t1:=invshelf.l('donecnt');
								t2:=invshelf.l('doneat');
								t3:=invshelf.l('doneodd');
								if not invshelf.b('incomplete') then begin
									tdone:=(t1*t2)+t3;
								end else begin
									tless:=(t1*t2)+t3;
								end;
								totless:=totless+tless;
								totdone:=totdone+tdone;
								tt:='';
								tt:=tt+invshelf.st('part_no');
								if not empty(invshelf.st('rev_no')) then
									tt:=tt+' '''+invshelf.st('rev_no')+'''';
								tt:=padr(tt,17);
								tt:=tt+' S.O. '+invshelf.sn('lot_no',7);
								tt:=tt+' Loc. '+Copy(invshelf.s('location'),1,3);
								tt:=tt+' Inv# '+ltrim(invshelf.s('inv_no'));
	             	addinv(tt,invstr,invcnt,maxents);
								if tdone>0 then
									tt:='   '+ltrim(ltransform(tdone,'99,999,999'))+
										' Complete'
								else
									tt:='   '+ltrim(ltransform(tless,'99,999,999'))+
										' Incomplete';
								tt:=tt+'  Updated '+
									datehyph(invshelf.d('lastupdate'));
              	addinv(tt,invstr,invcnt,maxents);
								tt:=assembly.st('assy_no');
                tt2:=assembly.st('part_no');
								if (invcnt<maxents) and (tt<>tt2) then begin
									tt:='   '+assembly.st('name')+
									  ' Of '+tt;
	              	addinv(tt,invstr,invcnt,maxents);
								end;
								tt:=invshelf.st('comment1')+
								  invshelf.st('comment2');
								if not empty(tt) then begin
	              	addinv('   '+tt,invstr,invcnt,maxents);
								end;
							end;
							invshelf.Skip;
						End;
					End;
					assembly.Skip;
				End;
			end;
    End;
		{ load running balance }
		RunBal(totdone,InvStr,invcnt,maxents);
    if invmat.Seek(trim(jobnum)) then begin
     	addinv('',invstr,invcnt,maxents);
      addinv(space(14)+'MATERIAL INVENTORY',invstr,invcnt,maxents);
     	addinv('',invstr,invcnt,maxents);
      while (not invmat.Eof) and (trim(jobnum)=invmat.st('lot_no')) do begin
				DoEvents2;
        tt:='Lot '+invmat.sn('lot_no',9);
        tt:=tt+
          transform(invmat.f('lbs_mat'),'99,999')+' Lbs.,  Loc. ';
        tt:=tt+
          invmat.sn('location',3)+' Inv #'+invmat.st('inv_no');
	     	addinv(tt,invstr,invcnt,maxents);
        invmat.Skip;
      end;
    end;
   	addinv('',invstr,invcnt,maxents);
    addinv(space(12)+'OUTSIDE PROCESSING LIST',invstr,invcnt,maxents);
   	addinv('',invstr,invcnt,maxents);
    addinv('Shipped'+space(10)+'Out/Do Back'+space(2)+'Lbs.',
      invstr,invcnt,maxents);
    if outjobs.Seek(jobnum) then begin
      lastpo:=' ';
      hcnt:=0;
      While (Not outjobs.Eof) And
        (outjobs.s('job_no')=jobnum) do begin
				DoEvents2;
        if (outjobs.d('received')=0) And
          (outjobs.d('fdate')>=(DateMath(xDate,-35))) then begin
          if lastpo<>outjobs.s('po_no') then begin
            hcnt:=hcnt+1;
          End;
          outpo.Seek(outjobs.s('out_no'));
          tpounds:=0;
          tcount:=0;
          lastin:=ctod(' ');
          if poprcdel.Seek(outjobs.s('po_no')) then begin
            While (Not poprcdel.Eof) And
              (poprcdel.s('po_no')=outjobs.s('po_no')) do begin
							DoEvents2;
              lastin:=poprcdel.d('dtreceived');
              tpounds:=tpounds+(poprcdel.f('pounds'));
              tcount:=tcount+(poprcdel.f('count'));
              poprcdel.Skip;
            End;
          End;
          jobs.Seek(outjobs.s('job_no'));
          vendors.Seek(outpo.s('for_vend'));
          cust.Seek(jobs.s('cust_no'));
          tt:=Copy(outjobs.s('po_no'),1,8)+' '+
            Copy(upper(vendors.s('name')),1,5)+'  '+
            copy(datehyph(outjobs.d('fdate')),1,5)+'  '+
            copy(datehyph(outjobs.d('dtrequired')),1,5);
          if outpo.f('poundcode')<>1 then begin
            tt:=tt+
              transform(outjobs.f('pounds')-tpounds,'999999');
            if outjobs.f('count')>0 then
              tt:=tt+
          	    transform(outjobs.f('count')-tcount,'99,999,999')+
                ' PCS.';
			  	   	addinv(tt,invstr,invcnt,maxents);
          End Else
          Begin
            tt:=tt+
              transform(outjobs.f('pounds')-tpounds,'9,999,999');
			     	addinv(tt,invstr,invcnt,maxents);
          End;
          lastpo:=outjobs.s('po_no');
        End;
        outjobs.Skip;
      End;
    End;
    if hcnt=0 then begin
     	addinv('',invstr,invcnt,maxents);
      addinv(space(10)+'No Outstanding Processing',invstr,invcnt,maxents);
    End;
    if oim then dbClose(invmat);
    if ojarea then dbClose(outjobs);
    if ojdone then dbClose(poprcdel);
    if oparea then dbClose(outpo);
    if ovarea then dbClose(vendors);
  end;
End;

procedure JobRec.ldmspec(var rtt,rtt2:string);
var ii,seln:integer;
    omat,opord,ovend:boolean;
begin
	rtt:=space(35);
	rtt2:=space(35);
	omat:=dbIsClosed(matspecs);
	opord:=dbIsClosed(porders);
	ovend:=dbIsClosed(vendors);
	if omat then dbUse(matspecs,jcpath('matspecs'));
	if opord then dbUse(porders,jcpath('porders'));
  if ovend then dbUse(vendors,compath('vendors'));
	if porders.Seek(trim(jobnum)) then begin
		rtt:='';
		if vendors.Seek(porders.s('vendor_no')) then begin
			split(vendors.s('name'),' ',pars,parscnt);
			rtt:=pars[1]+' ';
			if parscnt>1 then begin
				rtt:=rtt+pars[2];
			End;
			rtt:=rtt+', ';
		End;
		if matspecs.Seek(porders.s('part_no')) then begin
			rtt:=rtt+trim(matspecs.s('mattype'));
			split(matspecs.s('size_req'),' ',pars,parscnt);
			rtt2:=trim(porders.s('qty'))+' '+pars[1];
			for ii:=1 to parscnt-1 do begin
				if pars[ii]='X' then begin
					rtt2:=rtt2+'x'+pars[ii+1];
				End;
			End;
			rtt2:=rtt2+'  DUE '+
			  ltrim(Copy(datehyph(porders.d('dtrequired')),1,5));
		End;
	End Else
	Begin
		if jipinfo.Seek(jobnum) then begin
			rtt:=jipinfo.s('mat1');
			rtt2:=jipinfo.s('mat2');
		End;
	End;
	if omat then dbClose(matspecs);
	if opord then dbClose(porders);
	if ovend then dbClose(vendors);
end;


procedure JobRec.chkrevno(forpn:string);
var tt:string;
begin
  if parts.Seek(forpn) then begin
    if (parts.s('rev_mot') <> parts.s('lrev_mot')) Or
      (parts.s('lmot_date') <> parts.s('mot_date'))
			then begin
      tt:='Rev Change: P/N '+trim(forpn);
      tt:=tt+' Current Rev: '+parts.s('rev_mot')+' Was '+
        trim(parts.s('lrev_mot'));
      tt:=tt+' Current MOT: '+datehyph(parts.d('mot_date'))+' Was '+
        datehyph(parts.d('lmot_date'));
      if Gen.User='CARL ' then begin
			  if YesNoBox(tt) then begin
					if parts.aLock then begin
						parts.ss('lrev_mot',parts.s('rev_mot'));
						parts.dd('lmot_date',parts.d('mot_date'));
						parts.dd('lastchange',xDate);
						parts.unLock;
					End Else
					Begin
						OKbox('Unable To Save Change - Try Again Later');
					End;
				end;
      End;
    End;
  End;
End;

function JobRec.Load(jbnum:string;WithLock:boolean):boolean;
var ii,jj:integer;
    fother,tup,dollar,tax:string[30];
		tup2:double;
begin
	jobnum:='';
	revnum:='';
	orevnum:='';
	partnum:='';
	partname:='';
	custnum:='';
	shipnum:='';
	custname:='';
	buyer:='';
	depname:='';
	ponum:='';
	oponum:='';
	motdate:=0;
	omotdate:=0;
	jstatus:=0;
	ojstatus:=0;
	statdate:=0;
	qty:=0.00;
	uprice:=0.00;
	ouprice:=0.00;
	addon:=0.00;
  jobchg:=false;
	duechg:=false;
	shipchg:=false;
	jipchg:=false;
	itemschg:=false;
	SaveData:=false;
	scnt:=0;
	dcnt:=0;
	ocnt:=0;
	oscnt:=0;
	tcnt:=0;
	StillDue:=0;
	recnum:=0;
	islocked:=false;
  tobpless:='';
  billnum:='';
  lineitem:='';
  orgqty:=0;
  note1:='';
  note2:='';
  note3:='';
  taxable:=false;
  ourmat:=true;
  tobp:=true;
	barfai:='';
	waitstatus:='';
	clozapprov:='';
	lotmadeto:='';
	lotinspto:='';
	lotshipto:='';
	mater_est:=0;
	proc_est:=0;
	labor_est:=0;
	bid:=0;
	complete:=0;
	partial:=0;
	material:=0;
	matsel:=0;
	procsel:=0;
	setupdate:=0;
	porecdate:=0;
	lastchange:=0;
	invless:='';
  for ii:=1 to 3 do begin
    specitem[ii]:='';
    speccom[ii]:='';
    specup[ii]:=0;
    specper[ii]:='';
  end;
  for ii:=1 to 5 do ttrems[ii]:='';
	mat1:='';
	mat2:='';
	for ii:=1 to MaxDue do begin
		DoEvents2;
		dqty[ii]:=0;
		ddates[ii]:=0;
		dstat[ii]:=0;
		drecs[ii]:=0;
		odqty[ii]:=0;
		odates[ii]:=0;
		srecs[ii]:=0;
		sqty[ii]:=0;
		sdates[ii]:=0;
		sinv[ii]:=0;
		slot[ii]:='   ';
		svia[ii]:='   ';
		sshippr[ii]:=space(12);
	end;
	for ii:=1 to MaxTools do begin
		toolsa[ii]:='';
	end;
	jobnum:=padr(jbnum,10);
	if not empty(jobnum) then begin
		jobs.SetOrder(1);
		if jobs.Seek(jobnum) then begin
			recnum:=jobs.RecNo;
		  if withlock then begin
				if jobs.aLock then begin
					islocked:=true;
					FlagOn(jobnum,'J');
				end;
			end;
			revnum:=jobs.s('rev_no');
			joblink:=jobs.s('joblink');
			custref:=jobs.s('cust_ref');
			orderdate:=jobs.d('orderdate');
			orevnum:=revnum;
			partnum:=jobs.s('part_no');
			if parts.Seek(partnum) then partname:=parts.s('name');
			custnum:=jobs.s('cust_no');
			shipnum:=jobs.s('ship_no');
			billnum:=jobs.s('bill_to');
      lineitem:=jobs.s('line_item');
			if cust.Seek(custnum) then custname:=cust.s('name');
			if jipinfo.Seek(jobnum) then begin
        buyer:=jipinfo.st('buyer');
        tobp:=jipinfo.b('tobp');
        tobpless:=jipinfo.s('less');
        ttrems[1]:=jipinfo.s('rem1');
        ttrems[2]:=jipinfo.s('rem2');
        ttrems[3]:=jipinfo.s('rem3');
        ttrems[4]:=jipinfo.s('rem4');
        ttrems[5]:=jipinfo.s('rem5');
				mat1:=jipinfo.s('mat1');
				mat2:=jipinfo.s('mat2');
      end;
			depname:=GetDept(jobs.s('dep'));
			depnum:=jobs.s('dep');
			ponum:=jobs.s('po_no');
			oponum:=ponum;
			qty:=jobs.n('qty');
      orgqty:=jobs.f('org_qty');
			oqty:=qty;
			uprice:=jobs.n('unit_price');
			ouprice:=uprice;
			motdate:=jobs.d('mot_date');
			omotdate:=motdate;
			jstatus:=jobs.i('jstatus');
			ojstatus:=jstatus;
			statdate:=jobs.d('statdate');
			ostatdate:=statdate;
	    taxable:=jobs.b('taxable');
	    ourmat:=empty(jobs.s('ourmat'));
			barfai:=jobs.s('bar_fai');
			waitstatus:=jobs.s('waitstatus');
			clozapprov:=jobs.s('clozapprov');
			lotmadeto:=jobs.s('lotmadeto');
			lotinspto:=jobs.s('lotinspto');
			lotshipto:=jobs.s('lotshipto');
			mater_est:=jobs.f('mater_est');
			proc_est:=jobs.f('proc_est');
			labor_est:=jobs.f('labor_est');
			bid:=jobs.f('bid');
			complete:=jobs.f('complete');
			partial:=jobs.f('partial');
			material:=jobs.f('material');
			matsel:=jobs.i('matsel');
			procsel:=jobs.i('procsel');
			setupdate:=jobs.d('setupdate');
			porecdate:=jobs.d('porecdate');
			lastchange:=jobs.d('lastchange');
			invless:=jobs.s('less');
			if dbIsOpen(tools) then begin
				tools.SetOrder(2);
				if tools.Seek(partnum) then begin
					while (not tools.Eof) and (partnum=tools.s('part_no')) and
						(tcnt<MaxTools)
					do begin
						DoEvents2;
						tcnt:=tcnt+1;
						toolsa[tcnt]:=tools.sn('tool_no',10)+' '+tools.sn('name',20);
						tools.Skip;
					end;
				end;
			end;
			totdue:=0;
			totship:=0;
			if ship.Seek(jobnum) then begin
				while (not ship.Eof) and (jobnum=ship.s('job_no')) and
					(scnt<MaxDue) do begin
					DoEvents2;
					scnt:=scnt+1;
					jj:=pos('-',ship.s('shipper_no'));
					if jj>0 then slot[scnt]:=copy(ship.s('shipper_no'),jj+1,3);
					sdates[scnt]:=ship.d('fdate');
					sqty[scnt]:=ship.f('qty');
					srecs[scnt]:=ship.RecNo;
					totship:=totship+sqty[scnt];
					sinv[scnt]:=ship.d('inv_date');
					svia[scnt]:=ship.s('ship_via');
					sshippr[scnt]:=ship.s('shipper_no');
					ship.Skip;
				end;
			end;
			if due.Seek(jobnum) then begin
				while (not due.Eof) and (jobnum=due.s('job_no')) and
						(dcnt<MaxDue) do begin
					DoEvents2;
					dcnt:=dcnt+1;
					ocnt:=dcnt;
					dqty[dcnt]:=due.f('qty');
					odqty[dcnt]:=dqty[dcnt];
					drecs[dcnt]:=due.RecNo;
					totdue:=totdue+dqty[dcnt];
					if (totdue>totship) and (StillDue=0) then StillDue:=dcnt;
					ddates[dcnt]:=due.d('fdate');
					odates[dcnt]:=ddates[dcnt];
					due.Skip;
				end;
			end;
		end;
		otherup:=0;
		otherchgs:=0;
		othertext:='';
		if jobitems.Seek(jobnum) then begin
      ii:=0;
			While (Not jobitems.Eof) And (jobitems.s('job_no')=jobnum) do begin
				DoEvents2;
				if (pos('L',jobitems.s('itype'))>0) Or
					(pos('1',jobitems.s('itype'))>0) then begin  { lot charge }
					otherchgs:=otherchgs+(jobitems.f('unit_price'));
					if Gen.CanSeePrice then begin
						othertext:=othertext+trim(jobitems.s('descrip'))+' ($'+
							ltrim(transform(jobitems.f('unit_price'),
								'999,999.99'))+')';
					End Else
					Begin
						othertext:=othertext+trim(jobitems.s('descrip'));
					End;
				End Else
				Begin
					otherup:=otherup+(jobitems.f('unit_price'));
				End;
        ii:=ii+1;
        if ii<4 then begin
			    specitem[ii]:=jobitems.s('item');
  	  		speccom[ii]:=jobitems.s('descrip');
    			specup[ii]:=jobitems.f('unit_price');
    			specper[ii]:=jobitems.s('itype');
        end;
				jobitems.Skip;
			End;
		End;
		dollar:='';
		fother:='';
		tax:='';
		if taxable then begin
			tax:='+Tax ';
		End;
		if Gen.AtPDS then begin
			if Gen.CanSeePrice then begin  { can see prices }
				if jobs.f('unit_price')<0 then begin
					dollar:='   @ $'+
					ltrim(transform(abs(jobs.f('unit_price')),'999,999.99'))+
						'/Lot';
				End Else
				Begin
					if jobs.f('unit_price')>0 then begin
						if jobs.f('unit_price')>2 then begin
							dollar:='   @ $'+
								ltrim(transform(jobs.f('unit_price'),'999,999.99'));
						End Else
						Begin
							dollar:='   @ $'+
								ltrim(transform(jobs.f('unit_price'),'9,999.9999'));
						End;
					End Else
					Begin
						if Not empty(tax) then begin
							dollar:='   @ $0.00';
						End;
					End;
				End;
			End;
		End Else
		Begin
			tup:=ltrim(transform(jobs.f('unit_price')+otherup,'999,999.9999'));
			tup2:=ProcDbl(Copy(tup,length(tup)-1,2));
			if Gen.CanSeePrice then begin
				if tup2>0 then begin
					dollar:='    @ $'+
						ltrim(transform(jobs.f('unit_price')+
						otherup,'999,999.9999'));
				End Else
				Begin
					dollar:='    @ $'+
						ltrim(transform(jobs.f('unit_price')+
						otherup,'999,999.99'));
				End;
			End;
		End;
		tup:='';
		if (otherchgs>0) Or (otherup>0) then begin
			if otherup>0 then begin
				if otherup>2 then begin
					tup:='+'+ltrim(transform(otherup,'999,999.99'));
				End Else
				Begin
					tup:='+'+ltrim(transform(otherup,'999.9999'));
				End;
			End;
			if otherchgs>0 then begin
				if Not empty(dollar) then begin
					fother:='+'+ltrim(transform(otherchgs,'99,999.99'));
				End Else
				Begin
					fother:=' @ $0.00+'+ltrim(transform(otherchgs,'99,999.99'));
				End;
			End;
		End;
		uptext:=dollar+tup+fother+tax;
	end;
  result:=islocked;
end;

procedure JobRec.Save;
var jobrecs:array [1..3] of longint;
    ii,jj:integer;
begin
  if not islocked then 
	  OKbox('Severe Error - Attempted to save Job Info not previously locked')
	else begin
		if recnum>0 then jobs.go(recnum)
		else jobs.append;
		jobs.ss('job_no',jobnum);
		jobs.ss('part_no',partnum);
		jobs.ss('rev_no',revnum);
		jobs.ss('joblink',joblink);
		jobs.ss('cust_ref',custref);
		jobs.dd('orderdate',orderdate);
		orevnum:=revnum;
		jobs.ss('cust_no',custnum);
		jobs.ss('ship_no',shipnum);
		jobs.ss('bill_to',billnum);
		jobs.ss('line_item',lineitem);
		jobs.ss('dep',depnum);
		jobs.ss('po_no',ponum);
		oponum:=ponum;
		jobs.ff('qty',qty);
		jobs.ff('org_qty',orgqty);
		oqty:=qty;
		jobs.ff('unit_price',uprice);
		ouprice:=uprice;
		jobs.dd('mot_date',motdate);
		omotdate:=motdate;
		jobs.ii('jstatus',jstatus);
		ojstatus:=jstatus;
		jobs.dd('statdate',statdate);
		ostatdate:=statdate;
		jobs.bb('taxable',taxable);
		if ourmat then jobs.ss('ourmat',' ')
		else jobs.ss('ourmat','C');
		jobs.ss('bar_fai',barfai);
		jobs.ss('waitstatus',waitstatus);
		jobs.ss('clozapprov',clozapprov);
		jobs.ss('lotmadeto',lotmadeto);
		jobs.ss('lotinspto',lotinspto);
		jobs.ss('lotshipto',lotshipto);
		jobs.ff('mater_est',mater_est);
		jobs.ff('proc_est',proc_est);
		jobs.ff('labor_est',labor_est);
		jobs.ff('bid',bid);
		jobs.ff('complete',complete);
		jobs.ff('partial',partial);
		jobs.ff('material',material);
		jobs.ii('matsel',matsel);
		jobs.ii('procsel',procsel);
		jobs.dd('setupdate',setupdate);
		jobs.dd('porecdate',porecdate);
		jobs.dd('lastchange',lastchange);
		jobs.ss('less',invless);
		if jipchg then begin
			if jipinfo.Seek(jobnum) then begin
				jipinfo.lock;
			end else jipinfo.append;
			jipinfo.ss('job_no',jobnum);
			jipinfo.ss('buyer',buyer);
			jipinfo.bb('tobp',tobp);
			jipinfo.ss('less',tobpless);
			jipinfo.ss('rem1',ttrems[1]);
			jipinfo.ss('rem2',ttrems[2]);
			jipinfo.ss('rem3',ttrems[3]);
			jipinfo.ss('rem4',ttrems[4]);
			jipinfo.ss('rem5',ttrems[5]);
			jipinfo.ss('mat1',mat1);
			jipinfo.ss('mat2',mat2);
			jipinfo.unlock;
		end;
		totdue:=0;
		for ii:=1 to dcnt do begin
			totdue:=totdue+dqty[ii];
		end;
		if duechg then begin
			if dcnt>0 then begin
				for ii:=1 to dcnt do begin
					DoEvents2;
					if drecs[ii]>0 then begin
						due.Go(drecs[ii]);
						due.Lock;
					end else due.Append;
					drecs[ii]:=due.RecNo;
					due.ss('job_no',jobnum);
					due.dd('fdate',ddates[ii]);
					due.ff('qty',dqty[ii]);
					due.unLock;
				end;
			end;
			{ purge leftover items, some may have been deleted }
			if ocnt>dcnt then begin
				for ii:=dcnt+1 to ocnt do begin
					if drecs[ii]>0 then begin
						due.Go(drecs[ii]);
						due.Lock;
						drecs[ii]:=0;
						due.ss('job_no',space(10));
						due.unLock;
					end;
				end;
			end;
			{ clear status indicator }
			for ii:=1 to MaxDue do begin
				dstat[ii]:=0;
			end;
			ocnt:=dcnt;
			{ make original match new info }
			if ocnt>0 then begin
				for ii:=1 to ocnt do begin
					odqty[ii]:=dqty[ii];
					odates[ii]:=ddates[ii];
				end;
			end;
			totship:=0;
			for ii:=1 to scnt do begin
				totship:=totship+sqty[ii];
			end;
			if shipchg then begin
				if scnt>0 then begin
					for ii:=1 to scnt do begin
						DoEvents2;
						if srecs[ii]>0 then begin
							ship.Go(srecs[ii]);
							ship.Lock;
						end else ship.Append;
						srecs[ii]:=ship.RecNo;
						ship.ss('job_no',jobnum);
						ship.dd('fdate',sdates[ii]);
						ship.ff('qty',sqty[ii]);
						ship.dd('inv_date',sinv[ii]);
						ship.ss('ship_via',svia[ii]);
						ship.ss('shipper_no',sshippr[ii]);
						ship.unLock;
					end;
				end;
				{ purge leftover items, some may have been deleted }
				if oscnt>scnt then begin
					for ii:=scnt+1 to oscnt do begin
						if srecs[ii]>0 then begin
							ship.Go(srecs[ii]);
							ship.Lock;
							srecs[ii]:=0;
							ship.ss('job_no',space(10));
							ship.unLock;
						end;
					end;
				end;
			end;
			oscnt:=scnt;
		end;
		{ save job items }
		if itemschg then begin
			if jobitems.Seek(jobnum) then begin
				for jj:=1 to 3 do jobrecs[jj]:=0;
				jj:=0;
				While (Not jobitems.Eof) And (jobitems.s('job_no')=jobnum) do begin
					jj:=jj+1;
					jobrecs[jj]:=jobitems.recno;
					jobitems.Skip;
				end;
				for jj:=1 to 3 do begin
					if specup[jj]>0 then begin
						if jobrecs[jj]>0 then begin
							jobitems.go(jobrecs[jj]);
							jobitems.lock;
						end else jobitems.append;
						jobitems.ss('job_no',jobnum);
						jobitems.ss('item',specitem[jj]);
						jobitems.ss('descrip',speccom[jj]);
						jobitems.ff('unit_price',specup[jj]);
						jobitems.ss('itype',upper(specper[jj]));
						jobitems.unlock;
					end else begin
						if jobrecs[jj]>0 then begin
							jobitems.lock;
							jobitems.ss('job_no',' ');
							jobitems.unlock;
						end;
					end;
				end;
			end;
		end;
		otherup:=0;
		otherchgs:=0;
		othertext:='';
		for ii:=1 to 3 do begin
			if (pin('L',specper[ii])) Or
				(pin('1',specper[ii])) then begin  { lot charge }
				otherchgs:=otherchgs+specup[ii];
				if Gen.CanSeePrice then begin
					othertext:=othertext+trim(speccom[ii])+' ($'+
						ltrim(transform(specup[ii],
							'999,999.99'))+')';
				End Else
				Begin
					othertext:=othertext+trim(speccom[ii]);
				End;
			End Else
			Begin
				otherup:=otherup+specup[ii];
			End;
		end;
		FlagOff(jobnum,'J');
    { reset statuses back to unchanged }
	  jobchg:=false;
		duechg:=false;
		shipchg:=false;
		jipchg:=false;
		itemschg:=false;
    jobs.unLock;
	end;
end;

procedure JobRec.quickinfo;
var tpartn,tst,tejob:string;
    ii,i:integer;
    lpp:Lpr;
begin
  lpp:=Lpr.create;
	tpartn:=trim(partnum);
	if Not empty(revnum) then begin
		tpartn:=tpartn+'  '''+trim(revnum)+'''';
	End;
  lpp.SetDestination;
	lpp.StartDoc(for8x11,trim(jobnum)+' Job Info');
	lpp.p(1,2,datehyph(xDate));
	tejob:=trim(jobnum);
	tst:='';
  for i:=1 to length(tejob) do tst:=tst+substr(tejob,i,1)+' ';
	lpp.p(1,35,tst);
	if empty(joblink) then begin
		lpp.p(1,71,upper(longtime));
	End Else
	Begin
		lpp.p(1,11,upper(longtime));
		tejob:='(Linked to Job '+trim(joblink)+')';
		lpp.p(1,79-length(tejob),tejob);
	End;
	lpp.p(2,2,replicate('=',77));
	lpp.p(3,2,padc(trim(custname)+'  ('+trim(custnum)+')',76));
	lpp.p(4,2,'PART: ' + trim(tpartn)+'  '+trim(partname));
	lpp.p(5,2,'P.O.: ' +trim(ponum)+'    '+trim(custref));
	lpp.p(5,56,'DEPT: ' + Copy(upper(depname),1,16));
	lpp.p(6,2,' QTY:');
	lpp.p(6,8,ltrim(transform(qty,'999,999,999')));
	lpp.p(7,2,replicate('=',77));
	if jstatus>0 then begin
		if jstatus=1 then begin
			lpp.p(8,26,' ** JOB CANCELLED ');
		End Else
		if jstatus=2 then begin
			lpp.p(8,26,' ** JOB COMPLETED ');
		End Else
		if jstatus=3 then begin
			lpp.p(8,26,'  ** JOB CLOSED ');
		End;
		lpp.p(8,lpp.pCol,datehyph(statdate));
		lpp.p(8,lpp.pCol,' ** ');
	End;
	lpp.p(10,9,'DUE');
	lpp.p(10,16,'(Total ');
	lpp.p(lpp.pRow,lpp.pCol,ltrim(transform(totdue,'99,999,999'))+')');
	lpp.p(10,41,'SHIP');
	lpp.p(10,57,'(Total ');
	lpp.p(lpp.pRow,lpp.pCol,ltrim(transform(totship,'99,999,999'))+')');
	lpp.p(11,62,'Inv.    Ship');
	lpp.p(12,7,
		'  DATE         QUANTITY     LOT   DATE      QUANTITY   DATE     VIA');
	lpp.p(13,7,
		'  ----         --------     ---   ----      --------   ----     ---');
	ii:=dcnt;
	lpp.line := 14;
	if scnt>ii then begin
		ii := scnt;
	End;
	for i:=1 to ii do begin
		DoEvents2;
		if i<=dcnt then begin
			lpp.p(lpp.line,7,dshyph(ddates[i]));
			lpp.p(lpp.line,19,transform(dqty[i],'999,999,999'));
		End;
		if i<=scnt then begin
			if sinv[i]>0 then begin
				lpp.p(lpp.line,36,slot[i]);
			End;
			lpp.p(lpp.line,39,datehyph(sdates[i]));
			lpp.p(lpp.line,48,transform(sqty[i],'999,999,999'));
			if Not empty(slot[i]) then begin
				lpp.p(lpp.line,60,datehyph(sinv[i]));
				lpp.p(lpp.line,71,svia[i]);
			End;
		End;
		lpp.line:=lpp.line+1;
	End;
	lpp.line:=lpp.line+1;
	if jstatus>0 then begin
		lpp.p(lpp.line,0,
			padc('(Balance Due '+ltrim(transform(0,'99,999,999'))+')',79));
	End Else
	Begin
		lpp.p(lpp.line,0,padc('(Balance Due '+
			ltrim(transform(totdue-totship,'99,999,999'))+')',79));
	End;
	lpp.crlf;
	lpp.StopDoc;
  lpp.free;
End;

procedure JCMainRec.LoadDepList;
var DepList:Tstringlist;
		ii:integer;
begin
  DepList:=Tstringlist.create;
	if Gen.AtPDS then begin
		DepList.LoadFromFile(compath('pdsdepts.dat'));
	End Else
	Begin
		DepList.LoadFromFile(compath('pgdepts.dat'));
	End;
	depcnt:=0;
	if DepList.Count>0 then begin
		for ii:=0 to deplist.count-1 do begin
		  if ii<high(depname) then begin
				split(deplist[ii],':',pars,parscnt);
				if (parscnt=2) and (depcnt<MaxDeps) then begin
				  depcnt:=depcnt+1;
					depcode[depcnt]:=padr(pars[1],3);
					depname[depcnt]:=pars[2];
				End;
			end;
		end;
	end;
  DepList.free;
end;

function JCMainRec.vdiv( dnum:string ):boolean;
{ VDIV, valid Division }
begin
  if dnum='1 ' then begin
    Result:=True;
  End Else
  if (dnum='2 ') And (Gen.AtPDS) then begin
    Result:=True;
  End;
  Result:=False;
end;


function JCMainRec.ndiv( dnum:string ):string;
{ NDIV, name of Division }
begin
  if dnum='1 ' then begin
    Result:='Arizona ';
  End Else
  if (dnum='2 ') And (Gen.AtPDS) then begin
    Result:='California ';
  End;
  Result:='* Div. Unknown *';
end;


function JCMainRec.rngdep( subnum:integer ):string;
{ RNGDEP, get Dept. position in Dept list. }
begin
  Result:=' ';
  if (subnum>0) And (subnum<=Depcnt) then begin
    Result:=depcode[subnum];
  End;
end;


function JCMainRec.vdep( dnum:integer ):boolean;
{ VDEP, is valid Dept number? }
begin
  Result:=False;
  if (dnum>0) and (dnum<=depcnt) then begin
    Result:=True;
  End;
end;


function JCMainRec.pdep( dnum:string ):integer;
{ PDEP,  return Dept code to position }
var ddi,ddk:integer;
begin
  ddk:=0;
  for ddi:=1 to depcnt do begin
    if dnum=depcode[ddi] then begin
      ddk:=ddi;
      break;
    End;
  End;
  Result:=ddk;
end;


function JCMainRec.ndep( dnum:string ):string;
{ NDEP,  return Dept title to position }
var ddi,ddj:integer;
begin
  ddj:=0;
  Result:='* Dept. Unknown *';
  for ddi:=1 to depcnt do begin
    if dnum=depcode[ddi] then begin
      ddj:=ddi;
      break;
    End;
  End;
  if ddj>0 then begin
    Result:=depname[ddj];
  End;
end;



End.
