unit JobDetails;

interface

  uses DBFserver, wPreview, CommonCode, JcCommon;

	type

    JDrec=Class(TObject)
		private
		  { following used to track aliases used
			  by "jbfstart" found in jccommon.pas }
			dbfsrc,curjob,lastjob:integer;
			labor,outside,history,partclas,vendors,emp:oDB;
      parts,jobs,due,ship,cust,tools,jipinfo,jobitems:oDB;
			{ vars used by Job Detail routines }
      ftot_labor,absval,comtot,tot1,tot2:double;
			actcnt,estcnt,invset,mcnt,pcnt,rdcnt,rdsmax,rscnt:integer;
      mpcnt,ecnt,specicnt,ddcnt,sscnt,due_cnt,ship_cnt,showscnt:integer;
      shocom1,shocom2,shocom3,no_emps,depcnt,rtcnt:integer;
      sstot,ssdue,tot_ship,tot_due:double;
      job_bid,tot_job,tot_mat,tot_proc:double;
			matwt,procwt:double;
      ejob_tot,job_tot,commtot,acttot:double;
      ssldate,sslinvdt,curr_date:longint;
			thisjob,adjcom1,adjcom2:string[120];
			donewline,hadzero,shotstot:boolean;
      shocom:boolean;
			ssldue,sslship:longint;
			tot_labor,ssship,ssadj,etot_mat,etot_proc,ssmat,ssproc,hjob_tot:double;
			dlist:array [1..100] of longint;
			slist:array [1..100] of longint;
			actlist:array [1..10] of string135;
			estlist:array [1..10] of string135;
			empa:array [1..12] of double;
			empar:array [1..12] of string[5];
			subtot:array [1..12] of double;
			tot:array [1..12] of double;
			mlist:array [1..150] of longint;
			plist:array [1..150] of longint;
			trate:array [1..15] of double;
			trtot:array [1..15] of double;
			dephrs:array [1..20] of double;
			deplist:array [1..20] of string[5];
			deptot:array [1..20] of double;
			apclas:array [1..10] of string[5];
			acost_ea:array [1..10] of double;
			acost_lb:array [1..10] of double;
			actual:array [1..10] of string[3];
			apnote:array [1..10] of string[30];
			ehours:array [1..50] of double;
			enum:array [1..50] of string[4];
			eperc:array [1..50] of double;
			jp:lpr;
			tjob:jobrec;
			procedure JDstop;
			procedure jbfstart(use_arch:integer);
			function  calccomm(cfor:string):double;
			procedure fillactest;
			procedure incline;
			procedure jbdthead;
			procedure jdmain;
			procedure jdsumbox;
			procedure labordt;
			procedure lstdueship;
			function  lvblank(vv:double):string;
			procedure mpsel(mp:integer;choice:double);
			procedure oddinvoices;
			procedure outsidt;
			procedure prtarray(prtot:boolean);
			procedure shosummary(addon:boolean);
			procedure shosumtots;
			procedure showcomments(shonum:integer);
			function  showsum(atline:integer):integer;
			procedure prjbdetail;
			procedure fastjbd;
			procedure fdueship;
			procedure falabor;
			procedure faoutside;
			procedure fsumbox;
			procedure faoutsidt;
			procedure fajdsumbox;
			procedure fashowest(lnum:integer);
			procedure ldpcosts;
			procedure cloz5dbfs;
		public
			histonly,sumsonly,sumdets,hardcopy,shortform:boolean;
			sumarr:array [1..3] of double;
			sumlist:string[120];
			constructor Create;
			procedure PrintDetails(var jlist:array of string40);
			procedure histupdate(pJobRec:JobRec);
		end;


implementation

constructor JDrec.Create;
var ii:integer;
begin
	tjob:=JobRec.Create;
	Jp:=Lpr.Create;
	labor:=Nil;
	outside:=Nil;
	history:=Nil;
	partclas:=Nil;
	vendors:=Nil;
	emp:=Nil;
	parts:=Nil;
	jobs:=Nil;
	due:=Nil;
	ship:=Nil;
	cust:=Nil;
	tools:=Nil;
	jipinfo:=Nil;
	jobitems:=Nil;
	sumsonly:=False;  { fast detail }
  sumdets:=false;   { sum detail results }
  hardcopy:=false;  { these are hardcopies print then close }
	histonly:=false;  { do not print report, only format it }
	shortform:=False;  { leave false, show labor or ship detail }
	for ii:=1 to 3 do sumarr[ii]:=0;
  sumlist:=' ';
	if pos(Upper(Gen.User),'ERNIE RICK ')>0 then begin
		sumsonly:=True;
	End;
end;

procedure JDrec.JDstop;
begin
	jp.free;
	tjob.free;
end;

procedure JDrec.PrintDetails(var jlist:array of string40);
var ii,kk:integer;
    TryAgain:boolean;
begin
	jbfstart(1);  {  open non rotating files needed }
	jbfstart(4);  {  open main Job Detail files needed }
	jp.SetDestination;
  lastjob:=high(jlist);
  for ii:=0 to High(jlist) do begin
    if not empty(jlist[ii]) then begin
      lastjob:=ii;
    end;
  end;
  for ii:=0 to lastjob do begin
		DoEvents2;
    curjob:=ii; { used to track when to print final summary }
    thisjob:=padr(substr(jlist[ii],1,10),10);
    TryAgain:=true;
    kk:=0;
    while TryAgain do begin
      DoEvents2;
      pp(kk);
      tjob.jobs:=jobs;
      tjob.due:=due;
      tjob.ship:=ship;
      tjob.labor:=labor;
      tjob.outside:=outside;
      tjob.vendors:=vendors;
      tjob.cust:=cust;
      tjob.parts:=parts;
      tjob.tools:=tools;
      tjob.jipinfo:=jipinfo;
      tjob.jobitems:=jobitems;
      if jobs.Seek(thisjob) then begin
        tjob.load(thisjob,false);
        if sumsonly then begin
          fastjbd;
          TryAgain:=False;
          kk:=0;
        end else
        begin
          prjbdetail;
          TryAgain:=False;
          kk:=0;
        End;
      end else begin
        case dbfsrc of
          4:begin
              jbfstart(2);
            end;
          2:begin
              jbfstart(3);
            end;
          3:begin
              jbfstart(4);
            end;
        end;
      end;
      if kk=3 then begin
        OKbox(trim(thisjob)+' Not Found');
        TryAgain:=false; { only try 3 different areas }
      end;
    end;
  end;
  jbfstart(-1);  {  close unneeded files }
end;


procedure JDrec.prjbdetail;
begin
  { vars used by sumsonly routine }
  mpcnt:=0;
  ecnt:=0;
  specicnt:=0;
  sstot:=0.00;
  ssmat:=0.00;
  ssproc:=0.00;
  ssship:=0.00;
  ssadj:=0.00;
  ssdue:=0.00;
  matwt:=0;
  procwt:=0;
  tjob.otherup:=0;
  tjob.otherchgs:=0;
  sslship:=0;
  sslinvdt:=0;
  ssldue:=xDate;
  mpcnt:=0;
  jp.Page:=1;
  jp.line:=1;
  ddcnt:=2;
  sscnt:=2;
  tot_ship:=0;
  due_cnt:=0;
  ship_cnt:=0;
  tot_due:=0;
  job_bid:=0.00;
  tot_job:=0.00;
  etot_mat:=0.00;
  etot_proc:=0.00;
  tot_mat:=0.00;
  tot_proc:=0.00;
  hjob_tot:=0.00;
  job_tot:=0.00;
  tot_labor:=0.00;
  jobs.Seek(thisjob);
  if Not parts.Seek(jobs.s('part_no')+jobs.s('job_no')) then begin
    parts.Seek(jobs.s('part_no'));
  End;
  cust.Seek(trim(jobs.s('cust_no')));
  due.Seek(trim(thisjob));
  ship.Seek(trim(thisjob));
	jp.StartDoc(for14x11,trim(thisjob)+' Job Detail');
  jbdthead;
  jdmain;
  lstdueship;
  labordt;
  outsidt;
  if Gen.AtPDS then begin
    if jp.line+11>=jp.PgLen then begin
      jp.line:=jp.line + 20;
      incline;
    End;
  end else incline;
  jdsumbox;
  if (sumdets) and (curjob=lastjob) then begin
    if not histonly then shosummary(True);
  End;
  jp.StopDoc;  { done formatting job detail report }
  if histonly then begin
    if (sumdets) and (curjob=lastjob) then shosummary(false);
  end;
  { histupdate(tjob,tjd); }
end;


procedure JDrec.jbdthead;
begin
  jp.line:=1;
  jp.p(jp.line,1,upper(Gen.CompanyName));
  jp.p(jp.line,58,'JOB DETAIL REPORT');
  if jobs.f('jstatus')>0 then begin
    if jobs.f('jstatus')=1 then begin
      jp.p(jp.line,97,'CANCELLED: ');
    end else
    begin
      if jobs.f('jstatus')=2 then begin
        jp.p(jp.line,97,'COMPLETED: ');
      end else
      begin
        if jobs.f('jstatus')=3 then begin
          if jobs.d('statdate')=0 then begin
          	jp.p(jp.line,93,'CLOSED BY: '+ jobs.s('clozapprov')+' ');
          end else jp.p(jp.line,97,'CLOSED: ');
        end;
      end;
    End;
    jp.p(jp.line,jp.pCol,ltrim(datehyph(jobs.d('statdate'))));
  End;
  jp.p(pp(jp.line),118,'DATE: '+ltrim(datehyph(xDate)));
  if Gen.AtPDS then begin
    jp.p(jp.line,1,'FOR '+Gen.User);
  End;
  jp.p(jp.line,58,replicate('-',17));
  if jobs.f('jstatus')>0 then begin
    if jobs.f('jstatus')=3 then begin
      jp.p(jp.line,97,'H A R D   C O P Y');
    End;
  End;
  jp.p(pp(jp.line),118,'PAGE: '+ltrim(transform(jp.Page,'999')));
	pp(jp.line);

  jp.p(jp.line,1,'JOB NUMBER');
  jp.p(jp.line,14,'CUSTOMER NAME');
  jp.p(jp.line,42,'QUANTITY');
  jp.p(jp.line,53,'PART NUMBER');
  jp.p(jp.line,78,'******* DUE *******');
  jp.p(jp.line,100,'*********** SHIPPED ************');
  incline;

  if Gen.AtPDS then begin
    jp.p(jp.line,1,'DIV');
    jp.p(jp.line,7,'DEP');
  end else jp.p(jp.line,1,'DEP');
  jp.p(jp.line,14,'CUSTOMER PO#');
  jp.p(jp.line,40,'UNIT PRICE');
  jp.p(jp.line,53,'PART NAME');
  jp.p(jp.line,80,'QUANTITY');
  jp.p(jp.line,91,'DATE');
  jp.p(jp.line,102,'QUANTITY');
  jp.p(jp.line,113,'DATE');
  jp.p(jp.line,120,'INV DATE');
  jp.p(jp.line,129,'VIA');
  incline;

  jp.p(jp.line,1,replicate('-',10));
  jp.p(jp.line,14,replicate('-',24));
  jp.p(jp.line,40,replicate('-',10));
  jp.p(jp.line,53,replicate('-',20));
  jp.p(jp.line,78,replicate('-',10));
  jp.p(jp.line,89,replicate('-',8));
  jp.p(jp.line,100,replicate('-',10));
  jp.p(jp.line,111,replicate('-',8));
  jp.p(jp.line,120,replicate('-',8));
  jp.p(jp.line,129,'---');
  incline;
  incline;
end;


procedure JDrec.jdmain;
begin
  jp.p(jp.line,1,replicate('*',10));
  jp.p(jp.line,53,replicate('*',20));
  incline;
  jp.p(jp.line,1,thisjob);
  jp.p(jp.line,14,Copy(cust.s('name'),1,25));
  jp.p(jp.line,39,transform(jobs.f('qty'),'999,999,999'));
  jp.p(jp.line,53,trim(jobs.s('part_no')));
  if Not empty(jobs.s('rev_no')) then begin
    jp.p(jp.line,jp.pCol,'  '''+trim(jobs.s('rev_no'))+'''');
  End;
  if Not jobs.d('mot_date')=0 then begin
    jp.p(jp.line,jp.pCol,' MOT '+ltrim(datehyph(jobs.d('mot_date'))));
  End;
  if Not empty(jobs.s('joblink')) then begin
    jp.p(jp.line,86,'** ALSO SEE JOB '+trim(jobs.s('joblink')));
  End;
  incline;
  jp.p(jp.line,1,replicate('*',10));
  jp.p(jp.line,53,replicate('*',20));
  incline;
  if Gen.AtPDS then begin
    jp.p(jp.line,2,jobs.s('div_no'));
    jp.p(jp.line,7,jobs.s('dep'));
  end else jp.p(jp.line,1,jobs.s('dep'));
  jp.p(jp.line,14,jobs.s('po_no'));
  tjob.otherup:=0;
  tjob.otherchgs:=0;
  if jobs.f('unit_price')<0 then begin
    jp.p(jp.line,38,transform(abs(jobs.f('unit_price')),'9,999.99')+'/LOT');
  end else
  begin
    jp.p(jp.line,38,transform(jobs.f('unit_price')+
		  tjob.otherup,'999,999.9999'));
  End;
  jp.p(jp.line,53,parts.s('name'));
  incline;
  incline;
  { if not Gen.AtPDS then begin }
    { oddinvoices }
  { end; }
end;


procedure JDrec.oddinvoices;
begin
  { arhist.Seek(trim(cutjobno(jobs.s('job_no')))); }
end;


procedure JDrec.showcomments(shonum:integer);
begin
  if shonum=1 then begin
    jp.p(jp.line,10,'NOTE:');
    jp.p(jp.line,16,jp.specchars(jobs.s('note')));
  end else
  begin
    if shonum=2 then begin
      if Not empty(jobs.s('note2')) then begin
        jp.p(jp.line,16,jp.specchars(jobs.s('note2')));
      End;
    end else
    begin
      if shonum=3 then begin
        if Not empty(jobs.s('note3')) then begin
          jp.p(jp.line,16,jp.specchars(jobs.s('note3')));
        End;
      end;
    end;
  End;
end;


procedure JDrec.lstdueship;
var ii:integer;
begin
	for ii:=1 to 100 do dlist[ii]:=0;
	for ii:=1 to 100 do slist[ii]:=0;
  rdcnt:=0;
  rscnt:=0;
  if due.Seek(jobs.s('job_no')) then begin
    While (Not due.Eof) And (jobs.s('job_no')=due.s('job_no')) do begin
			DoEvents2;
      pp(rdcnt);
      dlist[rdcnt]:=due.RecNo;
      due.Skip;
    end;
  End;
  if ship.Seek(jobs.s('job_no')) then begin
    While (Not ship.Eof) And (jobs.s('job_no')=ship.s('job_no')) do begin
			DoEvents2;
      hadzero:=False;
      pp(rscnt);
      slist[rscnt]:=ship.RecNo;
      if ship.f('qty')=0 then begin
       ship.Lock;
       ship.ss('job_no',space(10));
       ship.unLock;
       hadzero:=True;
      End;
      ship.Skip;
      if hadzero then begin  { start over }
        rscnt:=0;
				for ii:=1 to 100 do slist[ii]:=0;
        if Not ship.Seek(jobs.s('job_no')) then begin
          break;
        End;
      End;
    End;
  End;
  if rscnt>rdcnt then rdsmax:=rscnt
    else rdsmax:=rdcnt;
  shocom1:=0;
  shocom2:=0;
  shocom3:=0;
  if rdsmax>0 then begin
    for ii:=1 to rdsmax do begin
			DoEvents2;
      donewline:=False;
      if (ii<=rdcnt) And (dlist[ii]>0) then begin
        due.Go(dlist[ii]);
        if due.s('job_no')=jobs.s('job_no') then begin
          if shocom1=0 then begin
            showcomments(1);
            shocom1:=jp.line;
            donewline:=True;
          end else
          begin
            if shocom2=0 then begin
              showcomments(2);
              shocom2:=jp.line;
              donewline:=True;
            end else
            begin
              if shocom3=0 then begin
                showcomments(3);
                shocom3:=jp.line;
                donewline:=True;
              End;
            End;
          End;
          if Not shortform then begin
            jp.p(jp.line,77,
						  transform(due.f('qty'),'999,999,999'));
            jp.p(jp.line,89,datehyph(due.d('fdate')));
            donewline:=True;
          End;
          if ssldue=xDate then begin
            ssldue:=due.d('fdate');
          End;
          tot_due:=tot_due + due.f('qty');
        End;
      End;
      if (ii<=rscnt) And (slist[ii]>0) then begin
        ship.Go(slist[ii]);
        if ship.s('job_no') = ship.s('job_no') then begin
          if shocom1=0 then begin
            showcomments(1);
            shocom1:=jp.line;
            donewline:=True;
          end else
          begin
            if (shocom2=0) And (shocom1<>jp.line) then begin
              showcomments(2);
              shocom2:=jp.line;
              donewline:=True;
            end else
            begin
              if (shocom3=0) And (shocom1<>jp.line) And (shocom2<>jp.line)
							then begin
                showcomments(3);
                shocom3:=jp.line;
                donewline:=True;
              End;
            End;
          End;
          if Not shortform then begin
            jp.p(jp.line,99,
						  transform(ship.f('qty'),'999,999,999'));
            jp.p(jp.line,111,datehyph(ship.d('fdate')));
            jp.p(jp.line,120,datehyph(ship.d('inv_date')));
            jp.p(jp.line,129,ship.s('ship_via'));
            donewline:=True;
          End;
          sslship:=ship.d('fdate');
          sslinvdt:=ship.d('inv_date');
          tot_ship:=tot_ship + ship.f('qty');
        End;
      End;
      if donewline then begin
        incline;
      End;
    End;
  End;
  ssdue:=tot_due;
  ssship:=tot_ship;
  showscnt:=0;
  if shocom1=0 then begin
    showcomments(1);
    incline;
    showcomments(2);
    showscnt:=showsum(showscnt);
    incline;
    showcomments(3);
    showscnt:=showsum(showscnt);
    incline;
    shocom2:=jp.line;
    shocom3:=jp.line;
  End;
  if shocom2=0 then begin
    showcomments(2);
    showscnt:=showsum(showscnt);
    incline;
    showcomments(3);
    showscnt:=showsum(showscnt);
    incline;
    shocom3:=jp.line;
  End;
  if shocom3=0 then begin
    showcomments(3);
    showscnt:=showsum(showscnt);
    incline;
  End;
  incline;
  jp.p(jp.line,1,'EMPLOYEE LABOR TOTALS THIS JOB:');
  if showscnt<2 then begin
    showscnt:=showsum(showscnt);
  End;
  incline;
  if showscnt<2 then begin
    showscnt:=showsum(showscnt);
    incline;
  End;
end;

function JDrec.showsum(atline:integer):integer;
begin
	pp(atline);
	if atline=1 then begin
		if tot_ship>0 then begin
			jp.p(jp.line,100,replicate('-',10));
			if shortform then begin
				jp.p(jp.line,112,'LAST SHIP '+datehyph(sslship));
			End;
		End;
	end else
	begin
		if atline=2 then begin
			if tot_ship>0 then begin
				jp.p(jp.line,99,transform(tot_ship,'999,999,999'));
				sumarr[3]:=sumarr[3]+tot_ship;
				if shortform then begin
					jp.p(jp.line,112,'LAST INV. '+datehyph(sslinvdt));
				End;
			End;
		end;
	End;
	Result:=atline;
end;


procedure JDrec.labordt;
var ii,i,j:integer;
    ll:longint;
begin
  labor.Seek(trim(thisjob));
  no_emps:=0;
	for ii:=1 to 12 do empa[ii]:=0;
	for ii:=1 to 12 do tot[ii]:=0;
	for ii:=1 to 12 do subtot[ii]:=0;
	for ii:=1 to 20 do deptot[ii]:=0;
	for ii:=1 to 20 do deplist[ii]:='   ';
	for ii:=1 to 20 do dephrs[ii]:=0;
	for ii:=1 to 12 do empar[ii]:='   ';
	for ii:=1 to 50 do enum[ii]:='   ';
	for ii:=1 to 50 do ehours[ii]:=0;
	for ii:=1 to 50 do eperc[ii]:=0;
	for ii:=1 to 15 do trate[ii]:=0;
	for ii:=1 to 15 do trtot[ii]:=0;
  depcnt:=0;
  ecnt:=0;
  rtcnt:=0;
  curr_date:=ctod(' ');
  While labor.s('job_no') = thisjob do begin
		DoEvents2;
    curr_date:=labor.d('trans_date');
    While (labor.d('trans_date') = curr_date) And (labor.s('job_no') = thisjob) do begin
			DoEvents2;
      ll:=labor.RecNo;
      j:=0;
      for i:=1 to 12 do begin
        if labor.s('emp_no') = empar[i] then begin
          j:=i;
          break;
        End;
      End;
      if j=0 then begin
        pp(no_emps);
        if no_emps = 13 then begin
          if Not shortform then begin
            prtarray(True);
          End;
          no_emps:=1;
          for i:=1 to 12 do begin
            empar[no_emps]:='   ';
          End;
        End;
        empar[no_emps]:=labor.s('emp_no');
        empa[no_emps]:=empa[no_emps] + labor.f('hours');
        tot[no_emps]:=tot[no_emps] + labor.f('hours');
        subtot[no_emps]:=subtot[no_emps] + labor.f('hours');
      end else
			begin
        empa[j]:=empa[j] + labor.f('hours');
        tot[j]:=tot[j] + labor.f('hours');
        subtot[j]:=subtot[j] + labor.f('hours');
      End;
      j:=0;
      if ecnt>0 then begin
        for i:=1 to ecnt do begin
          if labor.s('emp_no')=enum[i] then begin
            j:=i;
            break;
          End;
        End;
      End;
      if j>0 then begin
        eperc[j]:=eperc[j]+labor.f('hours');
        ehours[j]:=ehours[j]+labor.f('hours');
      end else
			begin
        if ecnt<50 then begin
          pp(ecnt);
          enum[ecnt]:=labor.s('emp_no');
          eperc[ecnt]:=labor.f('hours');
          ehours[ecnt]:=labor.f('hours');
        End;
      End;
      emp.Seek(labor.s('emp_no'));
      j:=0;
      if depcnt>0 then begin
        for i:=1 to depcnt do begin
          if emp.s('depart')=deplist[i] then begin
            j:=i;
            break;
          End;
        End;
      End;
      if j=0 then begin
        pp(depcnt);
        deplist[depcnt]:=emp.s('depart');
        j:=depcnt;
      End;
      deptot[j]:=deptot[j]+labor.f('rate')*labor.f('hours');
      dephrs[j]:=dephrs[j]+labor.f('hours');
      j:=0;
      if rtcnt>0 then begin
        for i:=1 to rtcnt do begin
          if labor.f('rate')=trate[i] then begin
            j:=i;
            break;
          End;
        End;
      End;
      if j>0 then begin
        trtot[j]:=trtot[j]+labor.f('hours');
      end else
      begin
        if rtcnt<50 then begin
          pp(rtcnt);
          trate[rtcnt]:=labor.f('rate');
          trtot[rtcnt]:=labor.f('hours');
        End;
      End;
      if labor.Eof then begin
        break;
      End;
      labor.Skip;
    end;
    if Not shortform then begin
      prtarray(False);
    End;
    if labor.Eof then begin
      break;
    End;
  end;
  if Not shortform then begin
    prtarray(True);
  End;
  shosumtots;
end;


procedure JDrec.shosummary(addon:boolean);
begin
  if addon then begin
    jp.p(jp.line,1,padc('SUMMARY FOR JOBS:'+trim(sumlist),132));
    jp.p(jp.line+2,55,'TOTAL BID'+transform(sumarr[1],'999,999,999.99'));
    jp.p(jp.line+3,54,'TOTAL COST'+transform(sumarr[2],'999,999,999.99'));
    jp.p(jp.line+4,53,'TOTAL PARTS'+transform(sumarr[3],'999,999,999.99'));
    if sumarr[3]>0 then begin
      jp.p(jp.line+6,55,'UNIT COST'+transform(sumarr[2]/sumarr[3],'999,999.9999'));
    end else
		begin
      jp.p(jp.line+6,55,'UNIT COST'+transform(0,'999,999.9999'));
    End;
    jp.line:=jp.line+6;
  end else
	begin
	  jp.StartDoc(for8x11,'Detail Summary');
    jp.p(2,1,padc('PART DETAIL SUMMARY REPORT',79));
    jp.p(2,71,datehyph(xDate));
    jp.p(4,1,padc('FOR JOBS:'+trim(sumlist),79));
    jp.p(6,28,'TOTAL BID'+transform(sumarr[1],'999,999,999.99'));
    jp.p(7,27,'TOTAL COST'+transform(sumarr[2],'999,999,999.99'));
    jp.p(8,26, 'TOTAL PARTS'+transform(sumarr[3],'999,999,999.99'));
    if sumarr[3]>0 then begin
      jp.p(10,28,'UNIT COST'+transform(sumarr[2]/sumarr[3],'9,999,999.9999'));
    end else
		begin
      jp.p(10,28,'UNIT COST'+transform(0,'9,999,999.9999'));
    End;
    jp.StopDoc;
  End;
end;

procedure JDrec.incline;
begin
	pp(jp.line);
	if jp.line>=jp.PgLen then begin
		jp.Page:=jp.Page + 1;
		jp.Eject;
		jp.line:=1;
		jp.p(jp.line,1,upper(Gen.CompanyName));
		jp.p(jp.line,58,'JOB DETAIL REPORT');
		jp.p(pp(jp.line),118,'DATE: '+ltrim(datehyph(xDate)));
		jp.p(jp.line,1,'***********************');
		jp.p(jp.line,58,'-----------------');
		jp.p(pp(jp.line),118,'TIME: '+upper(ltrim(longtime)));
		jp.p(jp.line,1,thisjob+' CONTINUED...');
		jp.p(pp(jp.line),118,'PAGE: '+ltrim(transform(jp.Page,'999')));
		jp.p(jp.line,1,'***********************');
		jp.line:=jp.line+2;
	End;
end;


procedure JDrec.prtarray(prtot:boolean);
var dotots,shostot:boolean;
    i,j:integer;
begin
  shostot:=False;
  dotots:=False;
  if (no_emps>=12) Or (prtot) then begin
    dotots:=True;
  End;
  j:=0;
  for i:=1 to 12 do begin
    if empa[i]>0 then begin
      j:=i;
      break;
    End;
  End;
  if j>0 then begin
    jp.p(jp.line,1,datehyph(curr_date));
    for i:=1 to 12 do begin
      if empa[i]>0 then begin
        jp.p(jp.line,(i*10)+2,transform(empa[i],'99.99'));
      End;
      empa[i]:=0;
    End;
    incline;
  End;
  if Not dotots then begin
    if jp.line>=jp.PgLen then begin
      shostot:=True;
    End;
  End;
  j:=0;
  for i:=1 to 12 do begin
    if tot[i]>0 then begin
      j:=i;
      break;
    End;
  End;
  if j=0 then begin
    dotots:=False;
  End;
  j:=0;
  for i:=1 to 12 do begin
    if subtot[i]>0 then begin
      j:=i;
      break;
    End;
  End;
  if j=0 then begin
    shostot:=False;
  End;
  if (dotots) Or (shostot) then begin
    if dotots then begin
      jp.p(jp.line,1,'TOTALS:');
    end else
		begin
      jp.p(jp.line,0,'SUBTOTAL:');
    End;
    for i:=1 to 12 do begin
      if dotots then begin
        if tot[i]>0 then begin
          jp.p(jp.line,(i*10)+1,transform(tot[i],'999.99'));
        End;
      end else
			begin
        if subtot[i]>0 then begin
          jp.p(jp.line,(i*10)+1,transform(subtot[i],'999.99'));
        End;
      End;
    End;
		pp(jp.line);
    jp.p(jp.line,1,'EMP NO:');
    for i:=1 to 12 do begin
      if dotots then begin
        if tot[i]>0 then begin
          jp.p(jp.line,(i*10)+2,empar[i]);
        End;
      end else
			begin
        if subtot[i]>0 then begin
          jp.p(jp.line,(i*10)+2,empar[i]);
        End;
      End;
    End;
		pp(jp.line);
    for i:=1 to 12 do begin
      if dotots then begin
        if tot[i]>0 then begin
          if emp.Seek(trim(empar[i])) then begin
            jp.p(jp.line,i*10,shortename(emp.s('name'),5));
          End;
        End;
      end else
			begin
        if subtot[i]>0 then begin
          if emp.Seek(trim(empar[i])) then begin
            jp.p(jp.line,i*10,shortename(emp.s('name'),5));
          End;
        End;
      End;
      if dotots then begin
        tot[i]:=0.00;
        subtot[i]:=0.00;
        empar[i]:='   ';
      end else
			begin
        subtot[i]:=0.00;
      End;
    End;
		pp(jp.line);
    incline;
  End;
end;


procedure JDrec.outsidt;
var ii,yy:integer;
begin
	for ii:=1 to 150 do mlist[ii]:=0;
	for ii:=1 to 150 do plist[ii]:=0;
  mcnt:=0;
  pcnt:=0;
  tot_mat:=0.00;
  tot_proc:=0.00;
  if jp.line+4>=jp.PgLen then begin
    jp.line:=jp.line+10;
    incline;
  End;
  jp.p(jp.line,1,replicate('*',23)+' MATERIALS '+replicate('*',29));
  jp.p(jp.line,71,replicate('*',22)+' OUTSIDE PROCESS '+replicate('*',22));
  incline;
  jp.p(jp.line,3,'DATE');
  jp.p(jp.line,10,'VENDOR#');
  jp.p(jp.line,19,'VENDOR NAME');
  jp.p(jp.line,41,'INVOICE NO');
  jp.p(jp.line,53,'INVOICE AMT');
  jp.p(jp.line,73,'DATE');
  jp.p(jp.line,80,'VENDOR#');
  jp.p(jp.line,89,'VENDOR NAME');
  jp.p(jp.line,110,'INVOICE NO');
  jp.p(jp.line,121,'INVOICE AMT');
  incline;
  if outside.Seek(thisjob) then begin
    While (Not outside.Eof) And (thisjob=outside.s('job_no')) 
		do begin
			DoEvents2;
      if outside.s('cost_type')='M' then begin
        pp(mcnt);
        mlist[mcnt]:=outside.RecNo;
      End;
      if outside.s('cost_type')='P' then begin
        pp(pcnt);
        plist[pcnt]:=outside.RecNo;
      End;
      outside.Skip;
    End;
  End;
  { append requests for commissions at end of processing array }
  pp(pcnt);
  plist[pcnt]:=-1;
  pp(pcnt);
  plist[pcnt]:=-2;
  for yy:=1 to 150 do begin
    commtot:=0;
    if mlist[yy]>0 then begin
			DoEvents2;
      outside.Go(mlist[yy]);
      vendors.Seek(outside.s('vendor_no'));
      jp.p(jp.line,1,datehyph(outside.d('trans_date')));
      jp.p(jp.line,10,outside.s('vendor_no'));
      jp.p(jp.line,19,upper(Copy(vendors.s('name'),1,20)));
      jp.p(jp.line,41,outside.s('invoice_no'));
      absval:=outside.f('inv_amount');
      jp.p(jp.line,53,transform(absval,'999,999.99'));
      tot_mat:=tot_mat + absval;
    End;
    if plist[yy]<>0 then begin
      if plist[yy]>0 then begin
				DoEvents2;
        outside.Go(plist[yy]);
        vendors.Seek(outside.s('vendor_no'));
        jp.p(jp.line,71,datehyph(outside.d('trans_date')));
        jp.p(jp.line,80,outside.s('vendor_no'));
        jp.p(jp.line,89,upper(Copy(vendors.s('name'),1,20)));
        jp.p(jp.line,110,outside.s('invoice_no'));
        jp.p(jp.line,121,transform(outside.f('inv_amount'),'999,999.99'));
        tot_proc:=tot_proc+outside.f('inv_amount');
        commtot:=outside.f('inv_amount');  { needed to force incline below }
      end else
			begin
        if plist[yy]=-1 then begin
          comtot:=calccomm('1');
          if comtot>0 then begin
            jp.p(jp.line,89,'TONY ROCCO - COMMISSION');
            jp.p(jp.line,121,transform(comtot,'999,999.99'));
            tot_proc:=tot_proc + comtot;
          End;
        end else
				begin
					if plist[yy]=-2 then begin
						comtot:=calccomm('2');
						if comtot>0 then begin
							jp.p(jp.line,89,'GEORGE MUSIL - COMMISSION');
							jp.p(jp.line,121,transform(comtot,'999,999.99'));
							tot_proc:=tot_proc + comtot;
						End;
					End;
				end;
      End;
    End;
    if (mlist[yy]<>0) Or (commtot<>0) then begin
      incline;
    End;
  End;
  incline;
  jp.p(jp.line,53,replicate('-',11));
  jp.p(jp.line,121,replicate('-',11));
  incline;
  jp.p(jp.line,29,'TOTAL MATERIAL COST:');
  jp.p(jp.line,51,transform(tot_mat,'9,999,999.99'));
  if Gen.AtPDS then begin
    mpsel(1,1);
  End;
  jp.p(jp.line,90,'TOTAL PROCESSING COST:');
  if Gen.AtPDS then begin
    mpsel(2,1);
  End;
  jp.p(jp.line,119,transform(tot_proc,'9,999,999.99'));
  jp.line:=jp.line + 1;
  ldpcosts;  { set mpcnt, apclas[], in epart.prg }
  etot_mat:=0;
  etot_proc:=0;
  if mpcnt>0 then begin
    for yy:=1 to mpcnt do begin
      partclas.Seek(apclas[yy]);
			if actual[yy]='L' then begin
				etot_proc:=etot_proc + acost_ea[yy];
			end else begin
				if (partclas.s('mat_proc')='M') Or (partclas.s('mat_proc')='C') 
				then begin
					etot_mat:=etot_mat + (acost_ea[yy]*tot_ship);
				end else
				begin
					etot_proc:=etot_proc + (acost_ea[yy]*tot_ship);
				end;
      End;
    End;
  End;
  if Gen.AtPDS then begin
    jp.p(jp.line,39,'ESTIMATED:');
    jp.p(jp.line,51,lvblank(etot_mat));
    mpsel(1,2);
    jp.p(jp.line,102,'ESTIMATED:');
    mpsel(2,2);
    jp.p(jp.line,119,lvblank(etot_proc));
    jp.line:=jp.line + 1;
    jp.p(jp.line,34,'ADJUSTED TOTAL:');
    jp.p(jp.line,51,lvblank(jobs.f('mater_est')));
    mpsel(1,3);
    jp.p(jp.line,97,'ADJUSTED TOTAL:');
    mpsel(2,3);
    jp.p(jp.line,119,lvblank(jobs.f('proc_est')));
  end else
	begin
    {  jp.line = jp.line + 1 }
    {  @ jp.line,39 say "ESTIMATED:" }
    {  @ jp.line,51 say lvblank(jobs.f('mater_est')); }
    {  @ jp.line,102 say "ESTIMATED:" }
    {  @ jp.line,119 say lvblank(jobs.f('proc_est')) }
  End;
  incline;
  incline;
  ssmat:=tot_mat;
  if jobs.f('matsel') = 2 then begin
    ssmat:=etot_mat;
  end else
  if jobs.f('matsel') = 3 then begin
    ssmat:=jobs.f('mater_est');
  End;
  ssproc:=tot_proc;
  if jobs.f('procsel') = 2 then begin
    ssproc:=etot_proc;
  end else
  if jobs.f('procsel') = 3 then begin
    ssproc:=jobs.f('proc_est');
  End;
end;


procedure JDrec.jdsumbox;
var ii,lli:integer;
    tt:string;
begin
	for ii:=1 to 10 do actlist[ii]:='*'+space(63)+'* *'+space(38)+'*';
	for ii:=1 to 10 do estlist[ii]:='*'+space(63)+'*';
  estcnt:=0;
  actcnt:=0;
  tot1:=0.00;
  tot2:=0.00;
  fillactest;
  sstot:=ssmat + ssproc + tot_labor;
  adjcom1:=jobs.s('jdnote1');
  adjcom2:=jobs.s('jdnote2');
  ejob_tot:=0;
  if jobs.f('unit_price')<0 then begin
    job_bid:=abs(jobs.f('unit_price'));
  end else
	begin
    job_bid:=(tot_ship * (jobs.f('unit_price')+
		  tjob.otherup))+tjob.otherchgs;
  End;
  if Not Gen.AtPDS then begin
    job_bid:=jobs.f('qty') * jobs.f('unit_price');
  End;
  hjob_tot:=job_tot;
  job_tot:=tot_labor + tot_mat + tot_proc;
  ejob_tot:=tot_labor + etot_mat + etot_proc;
  if Gen.AtPDS then begin
    if False then begin  { ignore for now }
      jp.p(jp.line,3,
			  'ACTUAL MATERIAL, PROCESS & OUTSIDE LABOR COST FOR THIS S.O.');
      jp.p(pp(jp.line),82,'COMMENT');
      jp.p(jp.line,0,replicate('*',65));
      jp.p(pp(jp.line),66,replicate('*',40));
      jp.p(jp.line,0,'*  MATL-PROCESS-LABOR');
      jp.p(jp.line,23,'LBS/UNIT');
      jp.p(jp.line,33,'COST/LB');
      jp.p(jp.line,42,'UNIT COST');
      jp.p(jp.line,53,'TOTAL COST *');
      jp.p(pp(jp.line),66,'*'+space(38)+'*');
      jp.p(jp.line,0,'*  '+replicate('-',18));
      jp.p(jp.line,23,replicate('-',8));
      jp.p(jp.line,33,replicate('-',7));
      jp.p(jp.line,42,replicate('-',9));
      jp.p(jp.line,53,replicate('-',10)+' *');
      jp.p(pp(jp.line),66,'*'+space(38)+'*');
      if acttot>0 then begin
        for ii:=1 to 6 do begin
          jp.p(pp(jp.line),0,actlist[ii]);
        End;
      end else
			begin
        jp.p(pp(jp.line),0,'*'+space(63)+'* *'+space(38)+'*');
      End;
      jp.p(jp.line,0,replicate('*',65));
      jp.p(pp(jp.line),66,replicate('*',40));
    End;

    jp.p(jp.line,2,
		  'ESTIMATED MATERIAL, PROCESS & OUTSIDE LABOR COST FOR THIS S.O.');
    jp.p(jp.line,70,'PARTS AND MATERIAL TO INVENTORY');
    if jobs.f('unit_price')<0 then begin
      jp.p(jp.line,108,'LOT PRICE');
    End;
		pp(jp.line);
    jp.p(jp.line,0,replicate('*',65));
    jp.p(jp.line,66,replicate('*',40));
    jp.p(jp.line,108,'TOTAL BID:');
    jp.p(pp(jp.line),119,transform(job_bid,'9,999,999.99'));
    sumarr[1]:=sumarr[1]+job_bid;

		jp.p(jp.line,0,'*  MATL-PROCESS-LABOR');
    jp.p(jp.line,23,'LBS/UNIT');
    jp.p(jp.line,33,'COST/LB');
    jp.p(jp.line,42,'UNIT COST');
    jp.p(jp.line,53,'TOTAL COST *');
    jp.p(pp(jp.line),66,'*'+space(38)+'*');

		jp.p(jp.line,0,'*  '+replicate('-',18));
    jp.p(jp.line,23,replicate('-',8));
    jp.p(jp.line,33,replicate('-',7));
    jp.p(jp.line,42,replicate('-',9));
    jp.p(jp.line,53,replicate('-',10)+' *');
    jp.p(jp.line,66,'* COMPLETE TO BLUEPRINT :');
    invset:=0;
    tt:=ltrim(transform(jobs.f('complete'),'999,999,999'));
    if length(tt)>invset then begin
      invset:=length(tt);
    End;
    tt:=ltrim(transform(jobs.f('partial'),'999,999,999'));
    if length(tt)>invset then begin
      invset:=length(tt);
    End;
    tt:=ltrim(transform(jobs.f('material'),'999,999,999'));
    if length(tt)>invset then begin
      invset:=length(tt);
    End;
    if jobs.f('complete')>0 then begin
      tt:=ltrim(transform(jobs.f('complete'),'999,999,999'));
      jp.p(jp.line,96,space(invset-length(tt))+tt);
    end else
		begin
      if jobs.f('jstatus')>0 then begin
        jp.p(jp.line,96,space(invset-5)+'- 0 -');
      end else
			begin
        jp.p(jp.line,93,replicate('_',11));
      End;
    End;
    jp.p(jp.line,105,'*');
    jp.p(jp.line,107,'TOTAL COST:');
    job_tot:=tot_labor;
    if jobs.f('matsel')=1 then begin
      job_tot:=job_tot+tot_mat;
    end else
    begin
	    if jobs.f('matsel')=2 then begin
  	    job_tot:=job_tot+etot_mat;
    	end else
    	begin
        if jobs.f('matsel')=3 then begin
          job_tot:=job_tot+jobs.f('mater_est');
        end Else
        begin
          job_tot:=job_tot+tot_mat;
				end;
			end;
		end;
		if jobs.f('procsel')=1 then begin
			job_tot:=job_tot+tot_proc;
		end else
		begin
			if jobs.f('procsel')=2 then begin
				job_tot:=job_tot+etot_proc;
			end else
			begin
				if jobs.f('procsel')=3 then begin
					job_tot:=job_tot+jobs.f('proc_est');
				end Else
				begin
					job_tot:=job_tot+tot_proc;
				end;
			end;
		end;
    jp.p(pp(jp.line),119,transform(job_tot,'9,999,999.99'));
    sumarr[2]:=sumarr[2]+job_tot;
    jp.p(jp.line,0,estlist[1]);
    jp.p(jp.line,66,'* PARTIALLY COMPLETE    : ');
    if jobs.f('partial')>0 then begin
      tt:=ltrim(transform(jobs.f('partial'),'999,999,999'));
      jp.p(jp.line,96,space(invset-length(tt))+tt);
    end else
		begin
      if jobs.f('jstatus')>0 then begin
        jp.p(jp.line,96,space(invset-5)+'- 0 -');
      end else
			begin
        jp.p(jp.line,93,replicate('_',11));
      End;
    End;
    jp.p(pp(jp.line),105,'*');
    jp.p(jp.line,0,estlist[2]);
    jp.p(jp.line,66,'* LESS : ');
    if Not empty(jobs.s('less')) then begin
      jp.p(jp.line,76,jobs.st('less'));
      jp.p(jp.line,105,'*');
    end else
		begin
      jp.p(jp.line,76,replicate('_',28)+' *');
    End;
    if tjob.otherchgs<>0 then begin
      jp.p(jp.line,107,'BID INCLUDES '+
        ltrim(transform(tjob.otherchgs,'99,999.99'))+' ADJ.');
    End;
		pp(jp.line);
    jp.p(jp.line,0,estlist[3]);
    jp.p(jp.line,66,'* LBS. MATERIAL IN STOCK: ');
    if jobs.f('material')>0 then begin
      tt:=ltrim(transform(jobs.f('material'),'999,999,999'));
      jp.p(jp.line,96,space(invset-length(tt))+tt);
    end else
		begin
      if jobs.f('jstatus')>0 then begin
        jp.p(jp.line,96,space(invset-5)+'- 0 -');
      End;
    End;
    jp.p(pp(jp.line),105,'*');
    jp.p(jp.line,0,estlist[4]);
    jp.p(jp.line,66,'*'+replicate('-',38)+'*');
    jp.p(jp.line,jp.pCol,replicate('*',26));

              { @ jp.line,107 say "TOTAL COST:" }
              { @ jp.line,119 say ejob_tot pict "9,999,999.99" }

		pp(jp.line);
    jp.p(jp.line,0,estlist[5]);
    jp.p(pp(jp.line),66,'* COMMENT: '+padl(adjcom1,27)+
		  ' * CLOSE                   *');
    jp.p(jp.line,0,estlist[6]);
    if empty(jobs.s('clozapprov')) then begin
      jp.p(jp.line,66,'* '+padl(adjcom2,36)+' * APPROVAL ____  ________ *');
    end else
		begin
      jp.p(jp.line, 66,'* '+padl(adjcom2,36)+' * APPROVAL:  '+
        jobs.s('clozapprov')+'  '+dshyph(jobs.d('statdate'))+' *');
    End;
          { @ jp.line,107 say "TOTAL COST:" }
		pp(jp.line);
    if mpcnt>6 then begin
      for lli:=7 to mpcnt do begin
        if lli<=estcnt then begin
          jp.p(pp(jp.line),0,estlist[lli]);
        End;
      End;
    End;
    jp.p(jp.line,0,replicate('*',65));
    jp.p(jp.line,66,replicate('*',40));
    jp.p(jp.line,jp.pCol,replicate('*',26));
		pp(jp.line);
  end else
	begin
    jp.p(jp.line,34,'EST LABOR COST:');
    jp.p(jp.line,51,lvblank(jobs.f('labor_est')));
    jp.p(jp.line,108,'TOTAL BID:');
    jp.p(pp(jp.line),119,lvblank(job_bid));
    jp.p(jp.line,38,'LABOR COST:');
    jp.p(jp.line,51,transform(tot_labor,'9,999,999.99'));
    jp.p(jp.line,107,'TOTAL COST:');
    job_tot:=tot_labor+tot_mat+tot_proc;
    jp.p(jp.line,119,transform(job_tot,'9,999,999.99'));
    jp.line:=jp.line+1;
  End;
end;


procedure JDrec.fillactest;
var ii:integer;
    tt,ttst:string[132];
begin
  actcnt:=0;
  estcnt:=0;
  if mpcnt>0 then begin
    for ii:=1 to mpcnt do begin
      if Not empty(apclas[ii]) then begin
        tt:='* ';
        if partclas.Seek(apclas[ii]) then begin
          ttst:=partclas.s('descript');
        end else
				begin
          ttst:=' ';
        End;
        tt:=tt+' '+padr(ttst,19);
        if partclas.s('mat_proc')='P' then begin
          tt:=tt+transform(procwt,'9999.9999');
        end else
				begin
          if partclas.s('mat_proc')='M' then begin
            tt:=tt+transform(matwt,'9999.9999');
          end else
          begin
            tt:=tt+space(9);
          End;
        End;
        tt:=tt+'  '+transform(acost_lb[ii],'9999.99');
        tt:=tt+'  '+transform(acost_ea[ii],'9999.9999');
        if Not empty(actual[ii]) then begin
          tt:=tt+actual[ii];
        end else
				begin
          tt:=tt+' ';
        End;
				if actual[ii]='L' then begin
					tt:=tt+transform(acost_ea[ii],'999,999.99');
					tot2:=tot2 + acost_ea[ii];
				end else begin
					tt:=tt+transform(acost_ea[ii]*tot_ship,'999,999.99');
					if (partclas.s('mat_proc')='M') Or (partclas.s('mat_proc')='C')
						then begin
						tot1:=tot1 + (acost_ea[ii])*tot_ship;
					end else
					begin
						tot2:=tot2 + (acost_ea[ii])*tot_ship;
					end;
        End;
      End;
      tt:=tt+'  *';
      if empty(actual[ii]) then begin
        estcnt:=estcnt+1;
        estlist[estcnt]:=tt;
      end else
			begin
          { old style }
        estcnt:=estcnt+1;
        estlist[estcnt]:=tt;

          { new style, not used as yet }
          { actcnt:=actcnt+1 }
          { actlist[actcnt]:=tt+" * "+apnote[ii]+" *" }
      End;
    End;
  End;
end;


procedure JDrec.shosumtots;
var tt1,tt2,tt3:double;
    ti,kk,nn:integer;
    tt4:string[10];
begin
  incline;
  jp.p(jp.line,1,'NO');
  jp.p(jp.line,11,'HOURS');
  jp.p(jp.line,17,'% WRKD');
  jp.p(jp.line,25,'EMPLOYEE NAME');
  incline;
  tot_labor:=0.00;
  job_tot:=0.00;
  if ecnt>1 then begin
    for ti:=1 to ecnt do begin
      job_tot:=job_tot+ehours[ti];
    End;
    if job_tot=0 then begin
      job_tot:=1;
    End;
    for ti:=1 to ecnt do begin
      eperc[ti]:=(ehours[ti]/job_tot)*100;
    End;
    for kk:=1 to ecnt do begin
      for nn:=1 to ecnt-1 do begin
        if sumsonly then begin
          if eperc[nn]<eperc[nn+1] then begin
            tt4:=enum[nn+1];
            tt2:=eperc[nn+1];
            tt3:=ehours[nn+1];
            enum[nn+1]:=enum[nn];
            eperc[nn+1]:=eperc[nn];
            ehours[nn+1]:=ehours[nn];
            enum[nn]:=tt4;
            eperc[nn]:=tt2;
            ehours[nn]:=tt3;
          End;
        end else
				begin
          if Gen.AtPDS then begin
            if enum[nn]>enum[nn+1] then begin
              tt4:=enum[nn+1];
              tt2:=eperc[nn+1];
              tt3:=ehours[nn+1];
              enum[nn+1]:=enum[nn];
              eperc[nn+1]:=eperc[nn];
              ehours[nn+1]:=ehours[nn];
              enum[nn]:=tt4;
              eperc[nn]:=tt2;
              ehours[nn]:=tt3;
            End;
          end else
					begin
            if eperc[nn]>eperc[nn+1] then begin
              tt4:=enum[nn+1];
              tt2:=eperc[nn+1];
              tt3:=ehours[nn+1];
              enum[nn+1]:=enum[nn];
              eperc[nn+1]:=eperc[nn];
              ehours[nn+1]:=ehours[nn];
              enum[nn]:=tt4;
              eperc[nn]:=tt2;
              ehours[nn]:=tt3;
            End;
          End;
        End;
      End;
    End;
  end else
	begin
    job_tot:=ehours[1];
  End;
  if rtcnt>1 then begin
    for kk:=1 to rtcnt do begin
      for nn:=1 to rtcnt-1 do begin
        if trate[nn]>trate[nn+1] then begin
          tt1:=trate[nn+1];
          tt2:=trtot[nn+1];
          trate[nn+1]:=trate[nn];
          trtot[nn+1]:=trtot[nn];
          trate[nn]:=tt1;
          trtot[nn]:=tt2;
        End;
      End;
    End;
  End;
  if ecnt>0 then begin
    for ti:=1 to ecnt do begin
      emp.Seek(enum[ti]);
      jp.p(jp.line,1,emp.s('emp_no'));
      jp.p(jp.line,8,transform(ehours[ti],'9,999.99'));
      jp.p(jp.line,17,transform(eperc[ti],'999.99'));
      jp.p(jp.line,25,Copy(trim(upper(emp.s('name'))),1,23));
      if ti<=rtcnt then begin
        jp.p(jp.line,51,transform(trtot[ti],'9,999.99'));
        jp.p(jp.line,60,'HRS AT');
        jp.p(jp.line,67,transform(trate[ti],'99.99'));
        jp.p(jp.line,73,'=');
        jp.p(jp.line,74,transform(trate[ti] * trtot[ti],'999,999.99'));
        tot_labor:=tot_labor + (trate[ti]*trtot[ti]);
      End;
      if ti<=depcnt then begin
        if Not sumsonly then begin
          jp.p(jp.line,91,Copy(upper(ndep(deplist[ti])),1,16));
          jp.p(jp.line,109,transform(dephrs[ti],'9,999.99')+' HRS');
          jp.p(jp.line,122,transform(deptot[ti],'999,999.99'));
        end else
				begin
          jp.p(jp.line,50,Copy(upper(ndep(deplist[ti])),1,16));
          jp.p(jp.line,68,transform(dephrs[ti],'9,999.99')+' HRS');
          jp.p(jp.line,81,transform(deptot[ti],'999,999.99'));
        End;
      End;
      incline;
    End;
  End;
  if rtcnt>ecnt then begin
    for ti:=ecnt+1 to rtcnt do begin
      jp.p(jp.line,51,transform(trtot[ti],'9,999.99'));
      jp.p(jp.line,60,'HRS AT');
      jp.p(jp.line,67,transform(trate[ti],'99.99'));
      jp.p(jp.line,73,'=');
      jp.p(jp.line,74,transform(trate[ti] * trtot[ti],'999,999.99'));
      tot_labor:=tot_labor + (trate[ti]*trtot[ti]);
      incline;
    End;
  End;
  if Not sumsonly then begin
    incline;
    jp.p(jp.line,44,'TOTAL LABOR:');
    jp.p(jp.line,56,transform(job_tot,'99,999.99'));
    jp.p(jp.line,66,'HOURS');
    jp.p(jp.line,73,'=');
    jp.p(jp.line,74,transform(tot_labor,'999,999.99'));
    incline;
  End;
  incline;
end;


procedure JDrec.mpsel(mp:integer;choice:double);
begin
  if mp=1 then begin
		if jobs.f('matsel')=choice then begin
			jp.p(jp.line,jp.pCol,'  [*]');
		end else
		begin
			jp.p(jp.line,jp.pCol,'  [ ]');
		End;
	end else
  begin
    if mp=2 then begin
      if jobs.f('procsel')=choice then begin
        jp.p(jp.pRow,jp.pCol,'  [*]');
      end else
      begin
        jp.p(jp.pRow,jp.pCol,'  [ ]');
      End;
    End;
  end;
end;


function JDrec.lvblank(vv:double):string;
begin
  Result:=space(12);
  if vv>0 then begin
    Result:=transform(vv,'9,999,999.99');
  End;
end;


function JDrec.calccomm(cfor:string):double;
var talias:string[15];
    invoices,hist2:oDB;
begin
  invoices:=nil;
  hist2:=nil;
  dbUse(invoices,arpath('invoices'));
  dbUse(hist2,arpath('history'));
  commtot:=0;
  if hist2.Seek(trim(thisjob)) then begin
    While (Not hist2.Eof) And (thisjob=cutjobno(hist2.s('invoice_no'))) do begin
			DoEvents2;
      if (hist2.s('trans_type')='I') And (hist2.s('commfor')=cfor)
			then begin
        commtot:=commtot+hist2.f('commission');
      End;
      hist2.Skip;
    End;
  End;
  if invoices.Seek(trim(thisjob)) then begin
    While (Not invoices.Eof) And (thisjob=cutjobno(invoices.s('invoice_no'))) do begin
			DoEvents2;
      if invoices.s('commfor')=cfor then begin
        commtot:=commtot+invoices.f('commission');
      End;
      invoices.Skip;
    End;
  End;
  dbClose(invoices);
  dbClose(hist2);
  Result:=commtot;
end;

procedure JDrec.fastjbd;
var ii:integer;
    longst:string;
begin
  mpcnt:=0;
  rtcnt:=0;
  for ii:=1 to 50 do enum[ii]:='   ';
  for ii:=1 to 50 do ehours[ii]:=0.00;
  for ii:=1 to 50 do eperc[ii]:=0.00;
  for ii:=1 to 20 do deptot[ii]:=0.00;
  for ii:=1 to 20 do dephrs[ii]:=0.00;
  for ii:=1 to 20 do deplist[ii]:=space(3);
  ecnt:=0;
  depcnt:=0;
  tjob.otherup:=0;
  tjob.otherchgs:=0;
  { vars used by sumsonly routine }
  sstot:=0.00;
  ssmat:=0.00;
  ssproc:=0.00;
  ssship:=0.00;
  ssadj:=0.00;
  ssdue:=0.00;
  sslship:=ctod(' ');
  ssldate:=ctod(' ');
  ssldue:=xDate;
  mpcnt:=0;
  tot_ship:=0;
  tot_due:=0;
  job_bid:=0.00;
  tot_job:=0.00;
  etot_mat:=0.00;
  etot_proc:=0.00;
  tot_mat:=0.00;
  tot_proc:=0.00;
  hjob_tot:=0.00;
  job_tot:=0.00;
  tot_labor:=0.00;
	{ for select file assignments see proc jccommon.prg }
  jobs.Seek(thisjob);
  if Not parts.Seek(jobs.s('part_no')+
			jobs.s('job_no')) then begin
    parts.Seek(jobs.s('part_no'));
  End;
  due.Seek(trim(thisjob));
  ship.Seek(trim(thisjob));
  fdueship;
  falabor;
  faoutside;
  adjcom1:=space(28);
  adjcom2:=space(37);
  fsumbox;

	jp.StartDoc(for14x11,trim(thisjob)+' Short Detail');
  jp.Line := 1;
  jp.page:=1;
  longst:='P.O. '+trim(jobs.s('po_no'))+'      P/N '+
	  trim(jobs.s('part_no'));
  if Not empty(jobs.s('rev_no')) then begin
    longst:=longst+'  '''+trim(jobs.s('rev_no'))+'''';
  End;
  if jobs.d('mot_date')>0 then begin
    longst:=longst+' MOT '+ltrim(datehyph(jobs.d('mot_date')));
  End;
  longst:=longst+'   '+trim(parts.s('name'));
  jp.p(jp.Line,1,'JOB SUMMARY REPORT');
  jp.p(jp.Line,20,padc(thisjob,40));
  jp.p(jp.Line,63,'DATED '+datehyph(xDate));
  jp.Line:=jp.Line+1;
  jp.p(jp.Line,1,'------------------');
  if (jobs.f('jstatus')=1) Or
	  (jobs.f('jstatus')=2) Or
	  (jobs.f('jstatus')=3) then begin
    if jobs.f('jstatus')=1 then begin
      jp.p(jp.Line,61,'CANCELLED ');
    End Else
    if jobs.f('jstatus')=2 then begin
      jp.p(jp.Line,61,'COMPLETED ');
    End Else
    if jobs.f('jstatus')=3 then begin
      if jobs.d('statdate')=0 then begin
        jp.p(jp.line,64,'CLOSED');
      end else jp.p(jp.line,55,'CLOSED BY: '+ jobs.s('clozapprov')+' ');
    end;
    jp.p(jp.Line,jp.pcol,datehyph(jobs.d('statdate')));
  End;
  jp.Line:=jp.Line+2;
  jp.p(jp.Line,1,padc(longst,78));
  jp.Line:=jp.Line+2;
  if Gen.AtPDS then begin
    jp.p(jp.Line,1,'-- INVENTORY --');
  End;
  jp.p(jp.Line,28,'  QTY ORDERED '+transform(jobs.f('qty'),'9,999,999'));
  if jobs.f('unit_price')<0 then begin
    jp.p(jp.Line,54,'@ '+ltrim(transform(abs(jobs.f('unit_price')),'9,999.99'))+'/LOT');
    jp.p(jp.pRow,jp.pCol,' := $ '+
      ltrim(transform(abs(jobs.f('unit_price')),'99,999.99')))
  End Else
  Begin
    jp.p(jp.Line,54,'@ '+ltrim(transform(jobs.f('unit_price')+tjob.otherup,'999,999.9999')));
    jp.p(jp.pRow,jp.pCol,' := $ '+
      ltrim(transform(jobs.f('qty')*(jobs.f('unit_price')+tjob.otherup),'9,999,999.99')))
  End;
  jp.Line:=jp.Line+2;
  if Gen.AtPDS then begin
    jp.p(jp.Line,0,'Comp. B/P '+
		  ltrim(transform(jobs.f('complete'),'99,999,999')));
  End;
  jp.p(jp.Line,28,'TOTAL SHIPPED '+transform(ssship,'9,999,999'));
  sumarr[3]:=sumarr[3]+ssship;
  if ssship>0 then begin
    jp.p(jp.pRow,jp.pCol,'   LAST SHIPMENT '+datehyph(sslship));
  End;
  jp.Line:=jp.Line+1;
  if Gen.AtPDS then begin
    jp.p(jp.Line,2,'Partial '+
		  ltrim(transform(jobs.f('partial'),'99,999,999')));
    jp.p(jp.pRow,jp.pCol,' Less '+Copy(jobs.s('less'),1,15));
  End;
  if ssship>0 then begin
    jp.p(jp.pRow,55,'LAST INVOICE '+datehyph(ssldate));
  End;
  jp.Line:=jp.Line+1;
  if Gen.AtPDS then begin
    jp.p(jp.Line,0,'Lbs. Mat. '+
		  ltrim(transform(jobs.f('material'),'99,999')));
  End;
  if jobs.f('unit_price')<0 then begin
    jp.p(jp.Line,30,' TOTAL BID '+transform(abs(jobs.f('unit_price'))+tjob.otherchgs,
      '999,999.99'));
  End Else
  Begin
    jp.p(jp.Line,30,' TOTAL BID '+transform((ssship*(jobs.f('unit_price')+tjob.otherup))
      +tjob.otherchgs,'999,999.99'));
  End;
  jp.p(jp.Line,54,'BID INCLUDES '+
    ltrim(transform(tjob.otherchgs,'99,999.99'))+' ADJ.');
  jp.Line:=jp.Line+2;
  jp.p(jp.Line,30,'TOTAL COST '+transform(sstot,'999,999.99'));
  jp.Line:=jp.Line+2;
  jp.p(jp.Line,29,'TOTAL LABOR '+transform(tot_labor,'999,999.99')+'  ');
  jp.p(jp.pRow,jp.pCol,ltrim(transform(hjob_tot,'99,999.99')+' Hrs  '));
  jp.Line:=jp.Line+1;
  faoutsidt;
  ftot_labor:=tot_labor;
  shosumtots;
  tot_labor:=ftot_labor;
  incline;
  fajdsumbox;
  jp.StopDoc;
  if jobs.i('jstatus')>0 then begin
    {histupdate;}
  End;
end;


procedure JDrec.fdueship;
begin
  shocom:=True;
  While due.s('job_no') = jobs.s('job_no')
	do begin
		DoEvents2;
    if ssldue=xDate then begin
      ssldue := due.d('fdate');
    End;
    tot_due := tot_due + due.f('qty');
    due.Skip;
  End;
  While ship.s('job_no') = jobs.s('job_no')
	do begin
		DoEvents2;
    sslship := ship.d('fdate');
    ssldate := ship.d('inv_date');
    tot_ship:=tot_ship + ship.f('qty');
    ship.Skip;
  End;
  ssdue := tot_due;
  ssship := tot_ship;
end;


procedure JDrec.falabor;
var i,j:integer;
begin
  labor.Seek(thisjob);
  While labor.s('job_no') = thisjob do begin
		DoEvents2;
    job_tot:=job_tot + labor.f('hours');
    tot_labor:=tot_labor+(labor.f('hours')*labor.f('rate'));
    emp.Seek(labor.s('emp_no'));
    j:=0;
    if depcnt>0 then begin
      for i:=1 to depcnt do begin
        if emp.s('depart')=deplist[i] then begin
          j:=i;
          break;
        End;
      End;
    End;
    if j=0 then begin
      depcnt:=depcnt+1;
      deplist[depcnt]:=emp.s('depart');
      j:=depcnt;
    End;
    deptot[j]:=deptot[j]+
		  labor.f('rate')*labor.f('hours');
    dephrs[j]:=dephrs[j]+labor.f('hours');
    j:=0;
    if ecnt>0 then begin
      for i:=1 to ecnt do begin
        if labor.s('emp_no')=enum[i] then begin
          j:=i;
          break;
        End;
      End;
    End;
    if j>0 then begin
      ehours[j]:=ehours[j]+labor.f('hours');
    End Else
    Begin
      if ecnt<50 then begin
        ecnt:=ecnt+1;
        enum[ecnt]:=labor.s('emp_no');
        ehours[ecnt]:=labor.f('hours');
      End;
    End;
    labor.Skip;
  End;
  if ecnt>0 then begin
    if job_tot=0 then begin
      job_tot:=1;
    End;
    for i:=1 to ecnt do begin
      eperc[i]:= (ehours[i]/job_tot)*100;
    End;
  End;
end;


procedure JDrec.faoutside;
var yy:integer;
begin
  { job detail report outside costs program }
  outside.Seek(thisjob);
  tot_mat:=0.00;
  tot_proc:=0.00;
  While thisjob=outside.s('job_no') do begin
		DoEvents2;
    if outside.s('cost_type')='M' then begin
      tot_mat:=tot_mat + outside.f('inv_amount');
    End;
    if outside.s('cost_type')='P' then begin
      tot_proc:=tot_proc + outside.f('inv_amount');
    End;
    outside.Skip;
  End;
  ldpcosts;  { this proc in epart.prg }

  etot_mat:=0;
  etot_proc:=0;
  if mpcnt>0 then begin
    for yy:=1 to mpcnt do begin
      partclas.Seek(apclas[yy]);
      if (partclas.s('mat_proc')='M') Or (partclas.s('mat_proc')='C') then begin
        etot_mat:=etot_mat + (acost_ea[yy]*tot_ship);
      End Else
      Begin
        etot_proc:=etot_proc + (acost_ea[yy]*tot_ship);
      End;
    End;
  End;
  ssmat := tot_mat;
  if jobs.f('matsel') = 2 then begin
    ssmat := etot_mat;
  End Else
  if jobs.f('matsel') = 3 then begin
    ssmat := jobs.f('mater_est');
  End;
  ssproc := tot_proc;
  if jobs.f('procsel') = 2 then begin
    ssproc := etot_proc;
  End Else
  if jobs.f('procsel') = 3 then begin
    ssproc := jobs.f('proc_est');
  End;
end;


procedure JDrec.fsumbox;
begin
  sstot := ssmat + ssproc + tot_labor;
  ejob_tot:=0;
  if jobs.f('unit_price')<0 then begin
    job_bid:=abs(jobs.f('unit_price'))+tjob.otherchgs;
  End Else
  Begin
    job_bid:=(tot_ship * (jobs.f('unit_price')+tjob.otherup))+tjob.otherchgs;
  End;
  hjob_tot := job_tot;
  job_tot:=tot_labor + tot_mat + tot_proc;
  ejob_tot:=tot_labor + etot_mat + etot_proc;
  job_tot:=tot_labor;
  if jobs.f('matsel')=1 then begin
    job_tot := job_tot+tot_mat;
  End Else
  if jobs.f('matsel')=2 then begin
    job_tot := job_tot+etot_mat;
  End Else
  if jobs.f('matsel')=3 then begin
    job_tot := job_tot+jobs.f('mater_est');
  End Else Begin
    job_tot := job_tot+tot_mat;
  End;
  if jobs.f('procsel')=1 then begin
    job_tot := job_tot+tot_proc;
  End Else
  if jobs.f('procsel')=2 then begin
    job_tot := job_tot+etot_proc;
  End Else
  if jobs.f('procsel')=3 then begin
    job_tot := job_tot+jobs.f('proc_est');
  End Else Begin
    job_tot := job_tot+tot_proc;
  End;
end;


procedure JDrec.faoutsidt;
var yy:integer;
begin
  { job detail report outside costs program }
  jp.Line:=jp.Line+1;
  jp.p(jp.Line,1,'MATERIAL COST:');
  jp.p(jp.Line,17,transform(tot_mat,'9,999,999.99'));
  if Gen.AtPDS then begin
    mpsel(1,1);
  End;
  jp.p(jp.Line,40,'PROCESSING COST:');
  if Gen.AtPDS then begin
    mpsel(2,1);
  End;
  jp.p(jp.Line,63,transform(tot_proc,'9,999,999.99'));
  jp.Line := jp.Line + 1;
  ldpcosts;  { this proc in epart.prg }
  etot_mat:=0;
  etot_proc:=0;
  if mpcnt>0 then begin
    for yy:=1 to mpcnt do begin
      partclas.Seek(apclas[yy]);
      if (partclas.s('mat_proc')='M') Or (partclas.s('mat_proc')='C') then begin
        etot_mat:=etot_mat + (acost_ea[yy]*tot_ship);
      End Else
      Begin
        etot_proc:=etot_proc + (acost_ea[yy]*tot_ship);
      End;
    End;
  End;
  if Gen.AtPDS then begin
    jp.p(jp.Line,5,'ESTIMATED:');
    jp.p(jp.Line,17,lvblank(etot_mat));
    mpsel(1,2);
    jp.p(jp.Line,46,'ESTIMATED:');
    mpsel(2,2);
    jp.p(jp.Line,63,lvblank(etot_proc));
    jp.Line := jp.Line + 1;
    jp.p(jp.Line,0,'ADJUSTED TOTAL:');
    jp.p(jp.Line,17,lvblank(jobs.f('mater_est')));
    mpsel(1,3);
    jp.p(jp.Line,41,'ADJUSTED TOTAL:');
    mpsel(2,3);
    jp.p(jp.Line,63,lvblank(jobs.f('proc_est')));
  End Else
  Begin
    {  line = line + 1 }
    {  @ line,39 say "ESTIMATED:" }
    {  @ line,51 say lvblank(mater_est) }
    {  @ line,102 say "ESTIMATED:" }
    {  @ line,119 say lvblank(proc_est) }
  End;
  jp.Line:=jp.Line+2;
  ssmat := tot_mat;
  if jobs.f('matsel') = 2 then begin
    ssmat := etot_mat;
  End Else
  if jobs.f('matsel') = 3 then begin
    ssmat := jobs.f('mater_est');
  End;
  ssproc := tot_proc;
  if jobs.f('procsel') = 2 then begin
    ssproc := etot_proc;
  End Else
  if jobs.f('procsel') = 3 then begin
    ssproc := jobs.f('proc_est');
  End;
end;


procedure JDrec.fajdsumbox;
var lli:integer;
begin
  ejob_tot:=0;
  if jobs.f('unit_price')<0 then begin
    job_bid:=abs(jobs.f('unit_price'))+tjob.otherchgs;
  End Else
  Begin
    job_bid:=(tot_ship * (jobs.f('unit_price')+tjob.otherup))+tjob.otherchgs;
  End;
  if Not Gen.AtPDS then begin
    job_bid:=(jobs.f('qty') * jobs.f('unit_price'))+tjob.otherchgs;
  End;
  adjcom1:=jobs.s('jdnote1');
  adjcom2:=jobs.s('jdnote2');
  hjob_tot := job_tot;
  job_tot:=tot_labor + tot_mat + tot_proc;
  ejob_tot:=tot_labor + etot_mat + etot_proc;
  tot1:=0.00;
  tot2:=0.00;
  if Gen.AtPDS then begin
    jp.p(jp.Line,5,'ESTIMATED MATERIAL - PROCESS & LABOR COST FOR THIS PART');
    jp.p(jp.Line,70,'PARTS AND MATERIAL TO INVENTORY');
    jp.Line := jp.Line+1;

    jp.p(jp.Line,0,
      '*****************************************************************');
    jp.p(jp.Line,66,'****************************************');
    if jobs.f('unit_price')<0 then begin
      jp.p(jp.Line,108,'LOT PRICE');
    End;
    jp.Line := jp.Line+1;

    jp.p(jp.Line,0,'*  MATL-PROCESS-LABOR');
    jp.p(jp.Line,23,'LBS/UNIT');
    jp.p(jp.Line,33,'COST/LB');
    jp.p(jp.Line,42,'UNIT COST');
    jp.p(jp.Line,53,'TOTAL COST *');
    jp.p(jp.Line,66,'*                                      *');
    jp.p(jp.Line,108,'TOTAL BID:');
    jp.p(jp.Line,119,transform(job_bid,'9,999,999.99'));
    sumarr[1]:=sumarr[1]+job_bid;
    jp.Line := jp.Line+1;

    jp.p(jp.Line,0,'*  ------------------');
    jp.p(jp.Line,23,'--------');
    jp.p(jp.Line,33,'-------');
    jp.p(jp.Line,42,'---------');
    jp.p(jp.Line,53,'---------- *');
    jp.p(jp.Line,66,'* COMPLETE TO BLUEPRINT  :');
    if jobs.f('complete')>0 then begin
      jp.p(jp.Line,93,
			  transform(jobs.f('complete'),'999,999,999'));
    End Else
    Begin
      jp.p(jp.Line,93,'___________');
    End;
    jp.p(jp.Line,105,'*');
    jp.Line := jp.Line+1;

    fashowest(1);
    jp.p(jp.Line,66,'* PARTIALLY COMPLETE     : ');
    if jobs.f('partial')>0 then begin
      jp.p(jp.Line,93,
			  transform(jobs.f('partial'),'999,999,999'));
    End Else
    Begin
      jp.p(jp.Line,93,'___________');
    End;
    jp.p(jp.Line,105,'*');
    jp.p(jp.Line,107,'TOTAL COST:');
    jp.p(jp.Line,119,transform(sstot,'9,999,999.99'));
    sumarr[2]:=sumarr[2]+sstot;
    jp.Line := jp.Line+1;

    fashowest(2);
    jp.p(jp.Line,66,'* LESS  : ');
    if Not empty(jobs.s('less')) then begin
      jp.p(jp.Line,76,trim(jobs.s('less')));
      jp.p(jp.Line,105,'*');
    End Else
    Begin
      jp.p(jp.Line,76,'____________________________ *');
    End;
    jp.Line := jp.Line+1;

    fashowest(3);
    jp.p(jp.Line,66,'* LBS. MATERIAL IN STOCK : ');
    if jobs.f('material')>0 then begin
      jp.p(jp.Line,93,
			  transform(jobs.f('material'),'999,999,999'));
    End;
    jp.p(jp.Line,105,'*');
    if Not numsequal(tjob.otherchgs,0) then begin
      jp.p(jp.Line,107,'BID INCLUDES '+
        ltrim(transform(tjob.otherchgs,'99,999.99'))+' ADJ.')
    End;
    jp.Line := jp.Line+1;
    fashowest(4);
    jp.p(jp.Line,66,'*--------------------------------------*');

              { @ line,107 say "TOTAL COST:" }
              { @ line,119 say ejob_tot pict "9,999,999.99" }

    jp.Line := jp.Line+1;

    fashowest(5);
    jp.p(jp.Line,66,'* COMMENT:'+padl(adjcom1,28)+' *');
    jp.Line := jp.Line+1;

    fashowest(6);
    if empty(jobs.s('clozapprov')) then begin
      jp.p(jp.Line,66,'*'+padl(adjcom2,37)+' *');
    End Else
    Begin
      jp.p(jp.Line,66,'*'+padl(adjcom2,37)+' *');
    End;
    jp.Line := jp.Line+1;
    if mpcnt<=6 then begin
      jp.p(jp.Line,0,
        '*****************************************************************');
      jp.p(jp.Line,66,'****************************************');
      jp.Line := jp.Line+1;
    End Else
    Begin
      for lli:=7 to mpcnt do begin
        fashowest(lli);
        if lli<=mpcnt then begin
          jp.p(jp.Line,66,'*                                      *');
        End;
        jp.Line := jp.Line+1;
      End;
      jp.p(jp.Line,0,
        '*****************************************************************');
      jp.p(jp.Line,66,'****************************************');
      jp.Line := jp.Line+1;
    End;
  End Else
  Begin
    jp.p(jp.Line,34,'EST LABOR COST:');
    jp.p(jp.Line,51,lvblank(jobs.f('labor_est')));
    jp.p(jp.Line,108,'TOTAL BID:');
    jp.p(jp.Line,119,lvblank(job_bid));
    jp.Line := jp.Line+1;
    jp.p(jp.Line,38,'LABOR COST:');
    jp.p(jp.Line,51,transform(tot_labor,'9,999,999.99'));
    jp.p(jp.Line,107,'TOTAL COST:');
    job_tot:=tot_labor+tot_mat+tot_proc;
    jp.p(jp.Line,119,transform(job_tot,'9,999,999.99'));
    jp.Line := jp.Line+1;
  End;
end;


procedure JDrec.fashowest(lnum:integer);
var ttst:string;
begin
  jp.p(jp.Line,0,'*'+transform(lnum,'9'));
  if (mpcnt>0) And (lnum<=mpcnt) then begin
    if partclas.Seek(apclas[lnum]) then begin
      ttst := partclas.s('descript');
    End Else
    Begin
      ttst := ' ';
    End;
    jp.p(jp.Line,jp.pCol,' '+upper(Copy(ttst,1,16)));
    if partclas.s('mat_proc')='P' then begin
      jp.p(jp.Line,21,transform(procwt,'9999.9999'));
    End Else
    Begin
      if partclas.s('mat_proc')='M' then begin
        jp.p(jp.Line,21,transform(matwt,'9999.9999'));
      End;
    End;
    jp.p(jp.Line,32,transform(acost_lb[lnum],'9999.99'));
    jp.p(jp.Line,41,transform(acost_ea[lnum],'9999.9999'));
    if Not empty(actual[lnum]) then begin
      jp.p(jp.pRow,jp.pCol,actual[lnum]);
    End;
    jp.p(jp.Line,52,transform(acost_ea[lnum]*tot_ship,'999,999.99'));
    if (partclas.s('mat_proc')='M') Or (partclas.s('mat_proc')='C') then begin
      tot1:=tot1 + (acost_ea[lnum])*tot_ship;
    End Else
    Begin
      tot2:=tot2 + (acost_ea[lnum])*tot_ship;
    End;
  End;
  jp.p(jp.Line,62,'  *');
end;

procedure JDrec.cloz5dbfs;
begin
	dbClose(jobs);
	dbClose(due);
	dbClose(ship);
	dbClose(labor);
	dbClose(outside);
end;

procedure JDrec.jbfstart(use_arch:integer);
begin
  if use_arch<0 then begin  { close all files except MainDBF's }
	  dbClose(jobs);
	  dbClose(due);
	  dbClose(ship);
	  dbClose(labor);
	  dbClose(outside);
	  dbClose(history);
	  dbClose(partclas);
	  dbClose(vendors);
	  dbClose(emp);
	  dbClose(cust);
	  dbClose(parts);
	  dbClose(tools);
	  dbClose(jipinfo);
	  dbClose(jobitems);
	end else begin
		if use_arch=1 then begin  { open other files needed }
			dbUse(history,jcpath('history'));
			dbUse(partclas,jcpath('partclas'));
			dbUse(vendors,compath('vendors'));
			dbUse(emp,compath('emp'));
			dbUse(cust,compath('cust'));
			dbUse(parts,compath('parts'));
			dbUse(tools,jcpath('tools'));
			dbUse(jipinfo,jcpath('jipinfo'));
			dbUse(jobitems,jcpath('jobitems'));
		End;
		if (use_arch=2) and (dbfsrc<>use_arch) then begin
			cloz5dbfs;
			dbUse(jobs,archpath('jobs'));
			dbUse(due,archpath('due'));
			dbUse(ship,archpath('ship'));
			dbUse(labor,archpath('labor'));
      labor.setorder(2);
			dbUse(outside,archpath('outside'));
		end;
		if (use_arch=3) and (dbfsrc<>use_arch) then begin
			cloz5dbfs;
			dbUse(jobs,temparch('jobs'));
			dbUse(due,temparch('due'));
			dbUse(ship,temparch('ship'));
			dbUse(labor,temparch('labor'));
      labor.setorder(2);
			dbUse(outside,temparch('outside'));
		end;
		if (use_arch=4) and (dbfsrc<>use_arch) then begin
			cloz5dbfs;
			dbUse(jobs,compath('jobs'));
			dbUse(due,jcpath('due'));
			dbUse(ship,jcpath('ship'));
			dbUse(labor,jcpath('labor'));
      labor.setorder(2);
			dbUse(outside,jcpath('outside'));
		end;
	end;
	dbfsrc:=use_arch;
end;

procedure JDrec.ldpcosts;
var ii:integer;
    tt:string;
begin
  for ii:=1 to 10 do apclas[ii]:='   ';
  for ii:=1 to 10 do apnote[ii]:=space(36);
  for ii:=1 to 10 do actual[ii]:=' ';
  for ii:=1 to 10 do acost_lb[ii]:=0.00;
  for ii:=1 to 10 do acost_ea[ii]:=0.00;
  matwt:=0.00;
  procwt:=0.00;
  split(parts.s('costclas'),':',pars,parscnt);
  mpcnt:=0;
  if parscnt>0 then begin
    mpcnt:=parscnt;
    for ii:=1 to mpcnt do begin
      apclas[ii] := Copy(pars[ii]+'   ',1,3);
    End;
    split(parts.s('lbs_ea'),':',pars,parscnt);
    if parscnt>2 then begin
      for ii:=1 to parscnt-2 do begin
        actual[ii] := pars[ii];
      End;
    End;
    split(parts.s('cost_lb'),':',pars,parscnt);
    for ii:=1 to mpcnt do begin
      acost_lb[ii] := ProcDbl(pars[ii]);
    End;
    split(parts.s('cost_ea'),':',pars,parscnt);
    for ii:=1 to mpcnt do begin
      acost_ea[ii] := ProcDbl(pars[ii]);
    End;
  End;
  tt:=parts.s('comments');
  if (Not empty(tt)) And (parscnt>0) then begin
    split(tt,':',pars,parscnt);
    for ii:=1 to parscnt do begin
      apnote[ii] :=pars[ii];
    End;
  End;
  split(parts.s('lbs_ea'),':',pars,parscnt);
  if parscnt>=2 then begin
    matwt:=ProcDbl(pars[parscnt-1]);  { Mat. weight }
    procwt := ProcDbl(pars[parscnt]);  { Process weight }
  End;
end;

procedure JDrec.histupdate(pJobRec:JobRec);
{ used by both fastjbd and jbdet1 }
var kk,nn:integer;
    tt1:string;
		tj:JobRec;
    tt2,tupr,tt3:double;
begin
  { no longer update history if closed }
  if pos(Gen.User,'CONNIE DIANNE BRAD KATHLEEN KATHY ')=0 then begin
    Exit;
  End;
	tj:=pJobRec;
	{ seek jobs->part_no+descend(jobs->job_no) }
	if history.Seek(tj.jobs.s('part_no')+tj.jobs.s('job_no')) then history.Lock
	else begin
		history.Append;
		history.ss('part_no',tj.jobs.s('part_no'));
		history.ss('job_no',tj.jobs.s('job_no'));
		history.ff('jstatus',tj.jobs.f('jstatus'));
	End;
	with tj do begin
		if ecnt>1 then begin
			for kk:=1 to ecnt do begin
				DoEvents2;
				for nn:=1 to ecnt-1 do begin
					if eperc[nn]<eperc[nn+1] then begin
						tt1:=enum[nn+1];
						tt2:=eperc[nn+1];
						tt3:=ehours[nn+1];
						enum[nn+1]:=enum[nn];
						eperc[nn+1]:=eperc[nn];
						ehours[nn+1]:=ehours[nn];
						enum[nn]:=tt1;
						eperc[nn]:=tt2;
						ehours[nn]:=tt3;
					End;
				End;
			end;
		End;
		history.ss('cust_no',jobs.s('cust_no'));
		history.dd('due_date',ssldue);
		history.ss('po_no',jobs.s('po_no'));
		history.ss('div_no',jobs.s('div_no'));
		history.ss('dep_no',jobs.s('dep'));
		history.ss('rev_no',jobs.s('rev_no'));
		history.dd('mot_date',jobs.d('mot_date'));
		history.ff('jstatus',jobs.f('jstatus'));
		history.dd('close_date',jobs.d('statdate'));
		history.ss('clozapprov',jobs.s('clozapprov'));
		history.ss('ourmat',jobs.s('ourmat'));
		history.dd('lastupdate',xDate);
		history.dd('orderdate',jobs.d('orderdate'));
		history.dd('setupdate',jobs.d('setupdate'));
		history.dd('porecdate',jobs.d('porecdate'));
		history.ss('emp1',enum[1]);
		history.ss('emp2',enum[2]);
		history.ss('emp3',enum[3]);
		history.ff('hours1',ehours[1]);
		history.ff('hours2',ehours[2]);
		history.ff('hours3',ehours[3]);
		history.ff('unit_price',jobs.f('unit_price')+tj.otherup);
		history.ss('joblink',jobs.s('joblink'));
		history.ff('qty_orderd',jobs.f('qty'));
		history.ff('qty_shippd',ssship);
		history.bb('otheritems',jobs.b('otheritems'));
		history.dd('final',sslship);
		if jobs.f('unit_price')<0 then begin
			{ lot price }
			history.ff('bid',-jobs.f('unit_price')+ssadj);
		End Else
		Begin
			history.ff('bid',(ssship*jobs.f('unit_price'))+ssadj);
		End;
		if Gen.AtPDS then begin
			history.ff('est_mater',etot_mat);
			history.ff('est_proc',etot_proc);
			{ calc est labor using unit price less mat/proc share }
			if ssship>0 then begin
				tupr:=(etot_mat+etot_proc)/ssship;
				history.ff('labor_est',(history.f('unit_price')-tupr)*ssship);
				if history.f('labor_est')<0 then begin
					history.ff('labor_est',0);
				End;
			End;
		End Else
		Begin
			history.ff('est_mater',history.f('mater_est'));
			history.ff('labor_est',history.f('labor_est'));
			history.ff('est_proc',history.f('proc_est'));
		End;
		history.ff('labor_act',tot_labor);
		history.ff('act_mater',ssmat);
		history.ff('act_proc',ssproc);
		history.ff('ttl_hours',hjob_tot);
		history.ff('complete',jobs.f('complete'));
		history.ff('partial',jobs.f('partial'));
		history.ss('less',jobs.s('less'));
		history.ff('material',jobs.f('material'));
	end;
	history.unLock;
end;


End.
