unit Dlmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, wPreview, wSelPrn, Misc;

type
  Tmainwin = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    ActiveWindows1: TMenuItem;
    Normal1: TMenuItem;
    Cascade1: TMenuItem;
    Tile1: TMenuItem;
    Samples1: TMenuItem;
    PlainText1: TMenuItem;
    N2: TMenuItem;
    SelectPrinter1: TMenuItem;
    PreviewJobCost1: TMenuItem;
    ViewBluePrint1: TMenuItem;
    PrintBluePrint1: TMenuItem;
    PreviewJobDueShip1: TMenuItem;
    N4: TMenuItem;
    ViewPictureofPart1: TMenuItem;
    N5: TMenuItem;
    CodePrintSample1: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Cascade1Click(Sender: TObject);
    procedure Tile1Click(Sender: TObject);
    procedure Normal1Click(Sender: TObject);
    procedure SelectPrinter1Click(Sender: TObject);
    procedure PlainText1Click(Sender: TObject);
    procedure PreviewJobCost1Click(Sender: TObject);
    procedure PreviewJobDueShip1Click(Sender: TObject);
    procedure ViewBluePrint1Click(Sender: TObject);
    procedure PrintBluePrint1Click(Sender: TObject);
    procedure ViewPictureofPart1Click(Sender: TObject);
    procedure CodePrintSample1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  mainwin: Tmainwin;

implementation

{$R *.DFM}

procedure Tmainwin.Exit1Click(Sender: TObject);
begin
  close;
end;

procedure Tmainwin.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  StopLinePrinter;
  StopMisc;
end;

procedure Tmainwin.FormCreate(Sender: TObject);
begin
  WindowState:=wsNormal;
  top:=0;
  width:=640;
  height:=480;
  left:=(screen.width-width) div 2;
  StartMisc;
  StartLinePrinter;
end;

procedure Tmainwin.Cascade1Click(Sender: TObject);
begin
  self.cascade;
end;

procedure Tmainwin.Tile1Click(Sender: TObject);
begin
  self.tile;
end;

procedure Tmainwin.Normal1Click(Sender: TObject);
var ii:integer;
begin
  WindowState:=wsNormal;
  top:=0;
  left:=0;
  width:=640;
  height:=480;
end;

procedure Tmainwin.SelectPrinter1Click(Sender: TObject);
begin
  newprinter:=tnewprinter.create(self);
  newprinter.show;
end;

procedure Tmainwin.PlainText1Click(Sender: TObject);
var tpr:TPreview;
begin
  tpr:=TPreview.create(self);
	tpr.PrintCommandFile('load::demorout.txt');
end;

procedure Tmainwin.PreviewJobCost1Click(Sender: TObject);
var tpr:TPreview;
begin
  tpr:=TPreview.create(self);
	tpr.PrintCommandFile('load::demojob.txt');
end;

procedure Tmainwin.PreviewJobDueShip1Click(Sender: TObject);
var tpr:TPreview;
begin
  tpr:=TPreview.create(self);
	tpr.PrintCommandFile('load::demoinfo.txt');
end;

procedure Tmainwin.ViewBluePrint1Click(Sender: TObject);
var tpr:tpreview;
begin
  tpr:=tpreview.create(self);
  tpr.windowstate:=wsNormal;
  tpr.ShowBluePrint('P/N 12345-67 ','demobps.bmp','demobp.bmp');
end;

procedure Tmainwin.PrintBluePrint1Click(Sender: TObject);
var tpr:tpreview;
begin
  tpr:=tpreview.create(self);
  tpr.caption:='Print B/P 12345-67';
  tpr.windowstate:=wsMinimized;
  tpr.PrintBluePrint('demobp.bmp');
end;

procedure Tmainwin.ViewPictureofPart1Click(Sender: TObject);
var lpp:lpr;
begin
  lpp:=lpr.create;
  with lpp do begin
 	  SetDestination;
	  ForceToScreen;
	  StartDoc(for8x11,'TEST PHOTO');
  	cmImage(true,2,2,'demopic.bmp');
  	cmText(5,5.5,'12b','Photo Of P/N 12345-67');
  	StopDoc;
  end;
  lpp.free;
end;

procedure Tmainwin.CodePrintSample1Click(Sender: TObject);
var lpp:lpr;
    ii:integer;
begin
  lpp:=lpr.create;
  with Lpp do begin
	  SetDestination;
  	StartDoc(for8x11,'Test Routines');
    cmText(3,1,'6:24','Text Sample Arial 24 pt');
    cmText(1,2.3,'30','Text Sample Arial Bold 30 pt');
    cmBox(0,4,10,1,0);
    cmBox(1,5.2,0.2,12,0);
    { must force font change when changing style from Raster to Text }
    TextFont('12');
    cmText(2,6,'b','Text Sample Bold');
    cmText(2,7,'bi','Text Sample Bold Italic');
    cmText(3,8,'biu','Text Sample Bold Italic Underline');
    Eject;
	  for ii:=1 to 10 do writeln(inttostr(ii));
    write('one ');
    write('two ');
    write('three');
    writeln('');
 		StopDoc;
  end;
  lpp.free;
end;

end.
