unit Selprn;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  Tnewprinter = class(TForm)
    Button1: TButton;
    prnlist: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    CheckBox1: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure prnlistClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  newprinter: Tnewprinter;

implementation

{$R *.DFM}

uses dbfserver, CommonCode, wPreview;

procedure Tnewprinter.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure Tnewprinter.FormCreate(Sender: TObject);
var ii,jj:integer;
    tt,tt2:string;
begin
  prnlist.clear;
  top:=0;
  left:=0;
  width:=509;
  height:=175;
  centerhoriz(self);
  Gen.AddWin('Select Printer',self);
  if lp.PrnCnt>0 then begin
    for ii:=1 to lp.PrnCnt do begin
      with lp.PrnList[ii] do begin
        if CanSelect then begin
          jj:=pos(trim(gen.user),uppercase(prdescription));
          tt:=prdescription;
          if jj>0 then begin
            tt2:=uppercase(copy(gen.user,1,1))+copy(lowercase(gen.user),2,20);
            tt:=tt2+copy(prdescription,jj,40);
          end;
          tt2:=padr(PrDescription,23)+padr(prname,21);
          if empty(queue) then tt2:=tt2+' Lpt'+inttostr(prport)
          else tt2:=tt2+' '+queue;
          prnlist.items.add(' '+tt2);
        end;
      end;
    end;
  end;
	if (lp.CurDest>0) and (lp.CurDest<prnlist.items.count) then
	  prnlist.itemindex:=lp.CurDest-1;
  checkbox1.checked:=lp.WantsPreview;
  show;
end;

procedure Tnewprinter.prnlistClick(Sender: TObject);
var ii,jj:integer;
begin
  jj:=-1;  { have to find position because inaccessible items not listed }
  for ii:=1 to lp.prncnt do begin
    if lp.PrnList[ii].canselect then pp(jj);
    if jj> -1 then begin
      if prnlist.selected[jj] then begin
        lp.CurDest:=ii;
        break;
      end;
    end;
  end;
end;

procedure Tnewprinter.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  lp.WantsPreview:=checkbox1.checked;
  Gen.ReleaseWin(self);
  action:=caFree;
end;

end.
