unit Dlmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, NuDelphi, WinBrows, Menus, CommonCode, DBFserver,
  wPreview, wSelPrn;

type
  Tmainwin = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    BrowseDatabases1: TMenuItem;
    Exit1: TMenuItem;
    SystemInfo1: TMenuItem;
    TranslatexBase1: TMenuItem;
    ActiveWindows1: TMenuItem;
    Normal1: TMenuItem;
    Cascade1: TMenuItem;
    Tile1: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    SelectPrinter1: TMenuItem;
    FlushFieldList1: TMenuItem;
    N3: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure BrowseDatabases1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure SystemInfo1Click(Sender: TObject);
    procedure TranslatexBase1Click(Sender: TObject);
    procedure Cascade1Click(Sender: TObject);
    procedure Tile1Click(Sender: TObject);
    procedure Normal1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SelectPrinter1Click(Sender: TObject);
    procedure FlushFieldList1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  mainwin: Tmainwin;

implementation

{$R *.DFM}

procedure Tmainwin.Exit1Click(Sender: TObject);
begin
  close;
end;

procedure Tmainwin.BrowseDatabases1Click(Sender: TObject);
begin
  DBFbrowse('');
end;

procedure Tmainwin.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	PutProgIni('Printers','WantsPreview',iifs(lp.WantsPreview,'1','0'));
  StopLinePrinter;
  StopCommonCode;
  StopDBserver;
end;

procedure Tmainwin.FormCreate(Sender: TObject);
var tt:string;
begin
  WindowState:=wsNormal;
  top:=0;
  left:=0;
  width:=640;
  height:=480;
	centerhoriz(self);
  StartDBserver;
  StartCommonCode;
  StartLinePrinter;
  Gen.CodeSource:='XX';
  { determine installed directory }
  tt:=paramstr(0);
  split(tt,'\',pars,parscnt);
  parscnt:=parscnt-1;  { knock off exe part }
  InstalledTo:=unsplit(pars,'\',parscnt);
end;

procedure Tmainwin.SystemInfo1Click(Sender: TObject);
begin
  ShowStatus;
end;

procedure Tmainwin.TranslatexBase1Click(Sender: TObject);
begin
  if Gen.FindWin('Translate xBase','')=0 then begin
    db2dl:=tdb2dl.create(self);
    db2dl.show;
    db2dl.seldir;
  end else db2dl.show;
end;

procedure Tmainwin.Cascade1Click(Sender: TObject);
begin
  cascade;
end;

procedure Tmainwin.Tile1Click(Sender: TObject);
begin
  tile;
end;

procedure Tmainwin.Normal1Click(Sender: TObject);
var ii:integer;
begin
  WindowState:=wsNormal;
  top:=0;
  left:=0;
  width:=640;
  height:=480;
  if Gen.MiscWinCnt>0 then begin
    for ii:=1 to gen.miscwincnt do begin
      gen.miscwinlist[ii].wform.top:=gen.miscwinlist[ii].top;
      gen.miscwinlist[ii].wform.left:=gen.miscwinlist[ii].left;
      gen.miscwinlist[ii].wform.width:=gen.miscwinlist[ii].width;
      gen.miscwinlist[ii].wform.height:=gen.miscwinlist[ii].height;
    end;
  end;
end;

procedure Tmainwin.FormShow(Sender: TObject);
begin
  if Gen.FindWin('Translate xBase','')=0 then begin
    db2dl:=tdb2dl.create(self);
    db2dl.show;
    db2dl.InDir:=InstalledTo;
    db2dl.LoadLists;
  end else db2dl.show;
end;

procedure Tmainwin.SelectPrinter1Click(Sender: TObject);
begin
  if Gen.FindWin('Select Printer','')=0 then
    newprinter:=tnewprinter.create(self);
  newprinter.show;
end;

procedure Tmainwin.FlushFieldList1Click(Sender: TObject);
var tdb:oDB;
begin
  if YesNoBox('Re-Load Field Info Database, When DBFDIRS.TXT Changed') then begin
    tdb:=nil;
    dbUseExclusive(tdb,InstalledTo+'\fields');
    tdb.Zap;
    dbClose(tdb);
  end;
end;

end.
