/*
 *	JD
 *
 *	Send job to printer or spooler using direct protocol.
 *
 *	These entries in WATTCP.CFG are recognised:
 *
 *	PRINTERHOST = domain name or ip address of host
 *	PORTBASE = number of port for LPT1, LPT2 at PORTBASE+1, etc.
 *	PRINTERNUM = 0 for LPT1, 1 for LPT2, 2 for LPT3.
 *
 *	These can be overriden on the command line with:
 *
 *	-H<printerhost>
 *	-B<portbase>
 *	-P<printernum>
 *
 *	Defaults are:
 *
 *	PORTBASE = 9100
 *	PRINTERNUM = 0
 *
 *	When printing a job, outputs one dot per 1k bytes.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tcp.h"

#define	BUFFERSIZE	1024

char		*printerhost = "printer";
int		portbase = 9100;
int		printernum = 0;
char		buffer[BUFFERSIZE];
tcp_Socket	sock;
void		(*normal_init)(char *name, char *value);

void my_init(char *name, char *value)
{
	if (strcmp(name, "PRINTERHOST") == 0)
		printerhost = strdup(value);
	else if (strcmp(name, "PORTBASE") == 0)
		portbase = atoi(value);
	else if (strcmp(name, "PRINTERNUM") == 0)
		printernum = atoi(value);
	else if (normal_init)
		(*normal_init)(name, value);
}

int jd(char *host, int port, FILE *file)
{
	longword	hostaddr;
	int		localport;
	int		status = 0;
	int		connected = 0;
	int		completed = 0;
	int		i;

	if (!(hostaddr = resolve(host)))
	{
		(void)printf("JD: %s: Cannot get address for host\n", host);
		return (1);
	}
	localport = 255 + (MsecClock() & 255);
	if (!tcp_open(&sock, localport, hostaddr, port, NULL))
	{
		(void)printf("JD: Cannot connect to host\n");
		return (1);
	}
	sock_wait_established(&sock, sock_delay, NULL, &status);
	connected = 1;
	(void)printf("connected");
	/* dump file */
	while ((i = fread(buffer, sizeof(char), BUFFERSIZE, file)) != 0)
	{
		sock_write(&sock, buffer, i);
		(void)printf(".");
		sock_tick(&sock, &status);
	}
	(void)printf("\n");
	completed = 1;
	sock_tick(&sock, &status);	/* in case they sent reset */
	sock_close(&sock);
	sock_wait_closed(&sock, sock_delay, NULL, &status);
sock_err:
	if (status == -1)
		(void)printf("JD: Remote host reset connection\n");
	if (!connected)
		(void)printf("JD: Could not get connected.\n");
	return(!completed);
}

int main(int argc, char **argv)
{
	char		*s;
	FILE		*file;
	int		status;

	/* hook onto init procedure to get NAME=VALUE pairs */
	normal_init = usr_init;
	usr_init = my_init;
	sock_init();
	for (--argc, ++argv; argc > 0 && *(s = argv[0]) == '-'; --argc, ++argv)
	{
		s++;
		switch (*s)
		{
		case 'B':
			portbase = atoi(++s);
			break;
		case 'H':
			printerhost = ++s;
			break;
		case 'P':
			printernum = atoi(++s);
			break;
		}
	}
	(void)printf("PRINTERHOST = %s PORT = %d\n", printerhost,
		portbase + printernum);
	if (argc <= 0)
		file = stdin;
	else
	{
		if ((file = fopen(argv[0], "rb")) == 0)
		{
			(void)printf("JD: %s: No such file\n", argv[0]);
			return (1);
		}
	}
	status = jd(printerhost, portbase + printernum, file);
	return (status);
}
