UNIT File_IO;

INTERFACE
USES Dos;

(*  Only ONE file may be open at any one time. This is all that is
**  necessary for protocol support. *)

Const BufferSize = 1024;
Type  BufferType = array[0..BufferSize-1] of Byte;

Procedure fioInit;
Function  fioFind(Pathname:String; Var Name:String; Var Size,Time:LongInt): Boolean;
Function  fioCreate(Pathname:String): Boolean;
Function  fioOpen(Pathname:String): Boolean;
Procedure fioClose;
Function  fioEOF:Boolean;
Function  fioSize : LongInt;
Function  fioSeek(Position:LongInt): Boolean;
Procedure fioPreRead;
Function  fioRead(Var Buffer:BufferType; BytesWanted:Word; Var BytesRead:Word): Boolean;
Function  fioWrite(Var Buffer:BufferType; Bytes2Write:Word): Boolean;
Procedure fioSetFTime(Time:LongInt);

IMPLEMENTATION

Const
  PreBuffSize = BufferSize;
Var
  IsOpen   : Boolean;
  TheFile  : File;
  PreBuff  : array[0..PreBuffSize-1] of Byte;
  PreLeft  : Integer;  (* leftmost byte index in PreBuff[] *)
  PreRight : Integer;  (* 1 + rightmost byte index in PreBuff[] *)
  PreIO    : Boolean;
  PreEOF   : Boolean;

(* reset file_io sub-system *)

Procedure fioInit;
Begin
  IsOpen  := False;
  PreLeft := 0;
  PreRight:= 0;
  PreIO   := True;
  PreEOF  := False
End;

(* open an existing file for read *)

Function fioOpen(Pathname:String): Boolean;
Begin {$I-}
   if IsOpen then
     begin
       fioOpen := False;
       exit
     end;
   PreEOF := False;
   Assign(TheFile,Pathname);
   Reset(TheFile,1);
   if IOresult = 0 then IsOpen := True;
   fioOpen := (IOresult = 0)
End; {$I+}

(* open a file for write *)

Function fioCreate(Pathname:String): Boolean;
Begin {$I-}
   if IsOpen then
     begin
       fioCreate := False;
       exit
     end;
   PreEOF := False;
   Assign(TheFile,Pathname);
   ReWrite(TheFile,1);
   if IOresult = 0 then IsOpen := True;
   fioCreate := (IOresult = 0)
End; {$I+}

(* close opened file *)

Procedure fioClose;
Begin {$I-}
   IsOpen := False;
   Close(TheFile);
   IF (IOresult <> 0) Then
      { ignore result }
End; {$I+}

(* position file pointer *)

Function fioSeek(Position:LongInt): Boolean;
Begin {$I-}
   if not IsOpen then
     begin
       fioSeek := False;
       exit
     end;
   PreLeft := 0;
   PreRight := 0;
   Seek(TheFile,Position);
   fioSeek := (IOresult = 0)
End; {$I+}

(* write to opened file *)

Function fioWrite(Var Buffer:BufferType; Bytes2Write:Word):Boolean;
Begin {$I-}
   if not IsOpen then
     begin
       fioWrite := False;
       exit
     end;
   BlockWrite(TheFile,Buffer,Bytes2Write);
   fioWrite := (IOresult = 0)
End; {$I+}

(* read into 'read ahead' buffer. Call before having to wait for ACK, etc *)

Procedure fioPreRead;
Begin {$I-}
  if IsOpen and (PreLeft = PreRight) then
    begin
      (* fill PreBuff[] *)
      PreLeft := 0;
      BlockRead(TheFile,PreBuff,PreBuffSize,PreRight);
      if PreRight < PreBuffSize then PreEOF := True;
      PreIO := (IOresult = 0)
    end
End; {$I+}

(* return EOF flag *)

Function fioEOF:Boolean;
Begin
  if (PreLeft = PreRight) and PreEOF then fioEOF := True
  else fioEOF := False;
End;

(* read from opened file *)

Function fioRead(Var Buffer:BufferType; BytesWanted:Word; Var BytesRead:Word):Boolean;
Var
   i  : Integer;
Begin
   if not IsOpen then
     begin
       fioRead := False;
       exit
     end;
   fioPreRead;
   (* compute # bytes we will return *)
   if BytesWanted > BufferSize then BytesWanted := BufferSize;
   if BytesWanted <= (PreRight-PreLeft) then BytesRead := BytesWanted
   else BytesRead := PreRight - PreLeft;
   (* get the bytes *)
   for i := 0 to BytesRead-1 do Buffer[i] := PreBuff[PreLeft+i];
   PreLeft := PreLeft + BytesRead;
   (* return correct I/O result *)
   if PreLeft = PreRight then fioRead := PreIO
   else fioRead := True
End;

(* find file *)

Function fioFind(Pathname: String; Var Name: String; Var Size, Time: LongInt): Boolean;
Var
   Info: SearchRec;
Begin {$I-}
   FindFirst(Pathname,Archive,Info);
   IF (DosError <> 0) OR (IOresult <> 0) Then
   Begin
      fioFind := False;
      Exit
   End;
   Name := Info.Name;
   Size := Info.Size;
   Time := Info.Time;
   fioFind := True
End; {$I+}

(* get file size *)

Function fioSize : LongInt;
Begin
  if IsOpen then fioSize := FileSize(TheFile)
  else fioSize := 0;
End;

(* set file time *)

Procedure fioSetFTime(Time: LongInt);
Begin {$I-}
   SetFTime(TheFile,Time);
   IF (IOresult <> 0) Then
      {null}
End; {$I+}
Begin
  (* initialize *)
  fioInit
End.
