//Camera.tpl
/*
Under many circumstances just two vectors in the camera statement are all
you need: location and look_at.  For example:

      camera {
        location <3,5,-10>
        look_at  <0,2,1>
      }

The location is simply the X, Y, Z coordinates of the camera. The camera
can be located anywhere in the ray tracing universe.  The default location
is <0,0,0>.  The look_at vector tells POV-Ray to pan and tilt the camera
until it is looking at the specified X, Y, Z coordinate.  By default the
camera looks at a point one unit in the +Z direction from the location.

The look_at specification should almost always be the LAST item in the
camera statement.  If other camera items are placed after the look_at
vector then the camera may not continue to look at the specified point.
*/

camera{
  location < ,  ,  >
  look_at < ,  ,  >
}
