/*
 * SerialPortStatus.java
 * 
 * Copyright (c) 1996-1997 Central Data Corporation
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software or its
 * documentation, or derivatives or compilations of them, is described
 * in the file "license.html".
 *
 * CENTRAL DATA CORPORATION IS MAKING THE SOFTWARE AND ITS DOCUMENTATION
 * AVAILABLE "AS IS" FOR NO FEE. CENTRAL DATA CORPORATION MAKES NO
 * REPRESENTATIONS OR WARRANTIES WITH REGARD TO THIS SOFTWARE OR ITS
 * DOCUMENTATION, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. CENTRAL DATA CORPORATION SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, COPYING,
 * MODIFYING, OR DISTRIBUTING THIS SOFTWARE OR ITS DOCUMENTATION, OR
 * DERIVATIVES OR COMPILATIONS OF THEM.
 */

package portio;

/**
 * Status of modem signals on standard RS-232 serial port. This serves simply as a
 * parameter block and provides no associated methods. Use the SerialPort setStatus
 * to set parameters.
 *
 * @version $Revision: 2.1 $ ($Date: 1997/02/19 18:00:00 $)
 */
public class SerialPortStatus extends PortStatus implements Cloneable {

    /**
     * RTS (outgoing--write only)
     */
    public boolean RTS;

    /**
     * CTS (incoming--read only)
     */
    public boolean CTS;

    /**
     * DTR (outgoing--write only)
     */
    public boolean DTR;

    /**
     * DSR (incoming--read only)
     */
    public boolean DSR;

    /**
     * DCD (incoming--read only)
     */
    public boolean DCD;

    /**
     * Instantiates a status block with all signals off
     */
    public SerialPortStatus()
    {
        RTS = CTS = DTR = DSR = DCD = false;
    }

    /**
     * Converts to string
     */
    public String toString()
    {
        return "RTS Out=" + (RTS ? "On" : "Off") +
              ", CTS In=" + (CTS ? "On" : "Off") +
              ", DTR Out=" + (DTR ? "On" : "Off") +
              ", DSR In=" + (DSR ? "On" : "Off") +
              ", DCD In=" + (DCD ? "On" : "Off");
    }

    /**
     * Clones the port status object
     */
    public Object clone()
    {
        try { return super.clone(); }
        catch( CloneNotSupportedException e ) { System.out.println( "SerialPortStatus: " + e ); }
        return null;
    }
}

