/*
 * SerialPort.java
 * 
 * Copyright (c) 1996-1997 Central Data Corporation
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software or its
 * documentation, or derivatives or compilations of them, is described
 * in the file "license.html".
 *
 * CENTRAL DATA CORPORATION IS MAKING THE SOFTWARE AND ITS DOCUMENTATION
 * AVAILABLE "AS IS" FOR NO FEE. CENTRAL DATA CORPORATION MAKES NO
 * REPRESENTATIONS OR WARRANTIES WITH REGARD TO THIS SOFTWARE OR ITS
 * DOCUMENTATION, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. CENTRAL DATA CORPORATION SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, COPYING,
 * MODIFYING, OR DISTRIBUTING THIS SOFTWARE OR ITS DOCUMENTATION, OR
 * DERIVATIVES OR COMPILATIONS OF THEM.
 */

package portio;

/**
 * This class provides basic serial port functionality using an associated PortDriver
 * and PortPrivate object to implement the actual hardware interface.
 *
 * @version $Revision: 2.1 $ ($Date: 1997/02/19 18:00:00 $)
 */
public class SerialPort extends Port {

    /**
     * Creates a new serial port.  A prior call directly into the driver
     * instance can be used to determine how many serial ports are available
     * to select a valid port number.
     *
     * @param driver port driver providing the hardware interface
     * @param number number of the serial port to open (zero is first)
     * @exception PortIOException problems occurred during open processing
     */
    public SerialPort( PortDriver driver, int number )
        throws PortIOException
    {
        super( driver, number );
    }

    /**
     * Sets parameters for the port.
     * @param params SerialPortParams object
     * @see SerialPortParams
     * @exception PortIOException if a problem occurs setting the requested parameters
     */
    public void setParams( SerialPortParams params )
        throws PortIOException
    {
        driverPrivate.setParams( params );
    }

    /**
     * Gets params (baud rate, character size, flow control, etc) for the port.
     *
     * @return SerialPortParams with current settings
     * @exception PortIOException if a problem occurs with the fetch
     * @see SerialPortParams
     */
    public SerialPortParams getParams()
        throws PortIOException
    {
        return (SerialPortParams) driverPrivate.getParams();
    }

    /**
     * Sets serial status lines (modem signals RTS and DTR) for the port.
     * @param status SerialPortStatus object
     * @see SerialPortStatus
     * @exception PortIOException if a problem occurs
     */
    public void setStatus( SerialPortStatus status )
        throws PortIOException
    {
        driverPrivate.setStatus( status );
    }

    /**
     * Sends a break at the port.
     *
     * @param duration zero yields a standard 250ms break, non-zero values specify
     * custom break durations in ms (if supported, else the standard break is
     * substituted).
     * @exception PortIOException if a problem/event occurs during the break
     */
    public void sendBreak( int duration )
        throws PortIOException
    {
        driverPrivate.sendBreak( duration );
    }
}
