/*
 * PortDriverInfo.java
 * 
 * Copyright (c) 1996-1997 Central Data Corporation
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software or its
 * documentation, or derivatives or compilations of them, is described
 * in the file "license.html".
 *
 * CENTRAL DATA CORPORATION IS MAKING THE SOFTWARE AND ITS DOCUMENTATION
 * AVAILABLE "AS IS" FOR NO FEE. CENTRAL DATA CORPORATION MAKES NO
 * REPRESENTATIONS OR WARRANTIES WITH REGARD TO THIS SOFTWARE OR ITS
 * DOCUMENTATION, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. CENTRAL DATA CORPORATION SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, COPYING,
 * MODIFYING, OR DISTRIBUTING THIS SOFTWARE OR ITS DOCUMENTATION, OR
 * DERIVATIVES OR COMPILATIONS OF THEM.
 */

package portio;

/**
 * This data-only class provides read-only information about the PortDriver,
 * and the actual hardware device it is connected to. The normal way to get
 * this information is using a PortDriverInfo info = driver.getDriverInfo();
 * statement after constructing the actual driver.
 *
 * @version $Revision: 2.1 $ ($Date: 1997/02/19 18:00:00 $)
 */
public class PortDriverInfo implements Cloneable {
    /**
     * The number of serial ports provided by this PortDriver
     */
    public int serialCount;

    /**
     * The number of parallel ports provided by this PortDriver
     */
    public int parallelCount;

    /**
     * The manufacturer of the device
     */
    public String manufacturer;

    /**
     * The manufacturer's name for the device
     */
    public String deviceId;

    /**
     * The firmware revision of the device
     */
    public String deviceRev;

    /**
     * Version information about the PortDriver itself
     */
    public String driverRev;

    /**
     * Converts the information to a string
     */
    public String toString()
    {
        return "Serial count: " + serialCount + ", Parallel count: " + parallelCount +
            ",\nDevice: " + manufacturer + " " + deviceId + ", Revision: " + deviceRev +
            ",\nDriver revision: " + driverRev;
    }

    /**
     * Clones this PortDriverInfo object
     */
    public Object clone()
    {
        try { return super.clone(); }
        catch( CloneNotSupportedException e ) { System.out.println( "PortDriverInfo: " + e ); }
        return null;
    }
}

