/*
 * ParallelPortStatus.java
 * 
 * Copyright (c) 1996-1997 Central Data Corporation
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software or its
 * documentation, or derivatives or compilations of them, is described
 * in the file "license.html".
 *
 * CENTRAL DATA CORPORATION IS MAKING THE SOFTWARE AND ITS DOCUMENTATION
 * AVAILABLE "AS IS" FOR NO FEE. CENTRAL DATA CORPORATION MAKES NO
 * REPRESENTATIONS OR WARRANTIES WITH REGARD TO THIS SOFTWARE OR ITS
 * DOCUMENTATION, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. CENTRAL DATA CORPORATION SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, COPYING,
 * MODIFYING, OR DISTRIBUTING THIS SOFTWARE OR ITS DOCUMENTATION, OR
 * DERIVATIVES OR COMPILATIONS OF THEM.
 */

package portio;

/**
 * Parallel port status block with state of important parallel port
 * signals. Note that the PortStatus class itself is empty.
 *
 * @version $Revision: 2.1 $ ($Date: 1997/02/19 18:00:00 $)
 */
public class ParallelPortStatus extends PortStatus implements Cloneable {

    /**
     * Paper out
     */
    public boolean paperEmpty;

    /**
     * Error condition
     */
    public boolean error;

    /**
     * Printer selected
     */
    public boolean select;

    /**
     * Creates a new status object with all fields false.
     */
    public ParallelPortStatus()
    {
        paperEmpty = error = select = false;
    }

    /**
     * Converts the status to a string.
     */
    public String toString()
    {
        return "Paper Empty=" + (paperEmpty ? "Yes" : "No") +
              ", Error=" + (error ? "Yes" : "No") +
              ", Selected=" + (select ? "Yes" : "No");
    }

    /**
     * Clones this port status object.
     */
    public Object clone()
    {
        try { return super.clone(); }
        catch( CloneNotSupportedException e ) { System.out.println( "ParallelPortStatus: " + e ); }
        return null;
    }
}
