/*
 * ParallelPort.java
 * 
 * Copyright (c) 1996-1997 Central Data Corporation
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software or its
 * documentation, or derivatives or compilations of them, is described
 * in the file "license.html".
 *
 * CENTRAL DATA CORPORATION IS MAKING THE SOFTWARE AND ITS DOCUMENTATION
 * AVAILABLE "AS IS" FOR NO FEE. CENTRAL DATA CORPORATION MAKES NO
 * REPRESENTATIONS OR WARRANTIES WITH REGARD TO THIS SOFTWARE OR ITS
 * DOCUMENTATION, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. CENTRAL DATA CORPORATION SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, COPYING,
 * MODIFYING, OR DISTRIBUTING THIS SOFTWARE OR ITS DOCUMENTATION, OR
 * DERIVATIVES OR COMPILATIONS OF THEM.
 */

package portio;

/**
 * This class provides basic parallel port functionality using an associated PortDriver
 * and PortPrivate object to implement the actual hardware interface.
 *
 * @version $Revision: 2.1 $ ($Date: 1997/02/19 18:00:00 $)
 */
public class ParallelPort extends Port {

    /**
     * Creates a new parallel port.  A prior call to PortDriver.getDriverInfo
     * can be used to determine how many parallel ports are available.
     *
     * @param driver PortDriver providing the hardware interface
     * @param number number of the parallel port to open (zero is first)
     * @see PortDriver
     * @exception PortIOException if problems occurred during open processing
     */
    public ParallelPort( PortDriver driver, int number )
        throws PortIOException
    {
        super( driver, number );
    }
}
