program delete_duplicate_4dos_command_history_entries;
uses dos , crt ;
type
    link = ^node;
    node = record
             cmd  : string ;
             next : link ;
           end;
var
   inbufr,
   inlist,
   ccmd      : string ;

   anchor,
   chain,
   temp,
   cnode     : link ;

   before,
   after     : text ;

   infile,
   outfile,
   tmpfile   : string ;

   i_case,
   twirl     : boolean ;
   histnumb  : word ;
   histsize,
   fdt       : longint ;

procedure showhelp ( errornum : byte );
const
    progdata = '4HIST- Free 4DOS utility: command history duplicate entry deleter.';
    progdat2 = 'V1.00: September 8, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';
    usage = 'Usage: 4HIST file [/i (ignore case)]';
var
    message : string [80];
begin
    writeln ( progdata );
    writeln ( progdat2 );
    writeln ;
    writeln ( usage );
    writeln ;

    case errornum of
      1 : message := 'you must specify -exactly- one filespec.';
      2 : message := 'unable to open ' + paramstr (1) + '!';
      3 : message := 'file is empty, cannot continue.';
    end;
    writeln ( 'ERROR: (#',errornum,') - ', message );
    halt ( errornum );
end;

function converttoupper(w : string) : string;
var
   cp  : integer;        {the position of the character to change.}
begin
     for cp := 1 to length(w) do
         w[cp] := upcase(w[cp]);
     converttoupper := w;
end;

procedure openfiles(var sfile, dfile : text; name1, name2 : string);
var
     dirinfo : searchrec ;
     inname  : string [12] ;
     insize  : longint ;

begin       { open the file to process, and another for output }
     findfirst ( name1, archive, dirinfo );
     if doserror <> 0 then
        showhelp (2);

     inname := dirinfo.name ;
     insize := dirinfo.size ;

     assign ( sfile, inname );     { we know names of both, }
{$i-} reset ( sfile ); {$i+}     { but if source does not exist, }
     if ( ioresult <> 0 ) then  { show help                     }
         showhelp(2);

     if insize = 0 then
         showhelp(3);

     assign ( dfile,name2 );     { create output file regardless }
     rewrite ( dfile );
end;

begin
     outfile := 'dda_4h-!.out';
     tmpfile := 'dda_4h-!.tmp';
     if paramcount >= 1 then
        infile := paramstr (1)
     else showhelp (1) ;

     i_case := false ;
     if ( paramcount = 2 ) then
        if (( converttoupper ( paramstr (2) )) = '/I' )  then
           i_case := true ;

     openfiles ( before, after, infile, outfile );

     new ( anchor );
     anchor^.cmd  := '';
     anchor^.next := nil ;
     chain := anchor ;

     twirl := true ;
     histsize := 0 ;
     histnumb := 0 ;

     while not eof ( before ) do begin
           readln ( before, ccmd );

           twirl := not twirl ;
           if twirl then write ('\')
                   else write ('/');
           gotoxy ( wherex - 1, wherey );

           histsize := histsize + length ( ccmd ) ;
           histnumb := histnumb + 1 ;

           new ( cnode );
           cnode^.cmd  := ccmd ;
           cnode^.next := nil  ;
           chain := anchor ;

           inbufr := cnode^.cmd ;
           if i_case then inbufr := converttoupper ( inbufr );

           while ( chain^.next <> nil )  do begin

                 inlist := chain^.next^.cmd ;
                 if i_case then inlist := converttoupper ( inlist );

                 if ( inbufr = inlist ) then
                 begin
                      temp := chain^.next ;
                      chain^.next := chain^.next^.next ;
                      dispose ( temp );
                 end
                 else
                    chain := chain^.next ;
           end;

           inlist := chain^.cmd ;
           if i_case then inlist := converttoupper ( inlist );

           if ( inbufr <> inlist ) then
           begin
              chain^.next := cnode ;
              chain := cnode ;
           end;
     end;

     histsize := histsize + histnumb ;
     write ( 'History was: ', histsize, ' bytes (',
              histnumb, ' commands), and is now: ' );
     histsize := 0 ;
     histnumb := 0 ;
     repeat
           temp := anchor ;
           anchor := anchor^.next;
           dispose ( temp );
           writeln ( after, anchor^.cmd ) ;
           histsize := histsize + length ( anchor^.cmd ) ;
           histnumb := histnumb + 1 ;
     until anchor^.next = nil ;
     dispose ( anchor );

     histsize := histsize + histnumb ;
     writeln ( histsize, ' bytes (', histnumb, ' commands).' );

     close ( after );
     reset ( after );
     getftime ( before, fdt );
     setftime ( after, fdt );
     close ( before );
     close ( after );
     rename ( before, tmpfile );
     rename ( after, infile );
     erase  ( before );

end.
