#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <4dlib.h>
#include <4Dserial.h>

// Demonstration of a simple terminal for the 4D Serial Library.

// USEAGE SERIAL <base> <IRQ>          base of 1016 = 3f8, 760 = 2f8
// Demo is designed for regular async mode, not fossil or digiboard.

void main(int, char *argv[]) {

unsigned		bas;
char			ts[20];
unsigned char	c;
int 			a = 0,b = 0,i;

	bas = atoi(argv[1]);
	i = atoi(argv[2]);
	if (SERIAL_OpenPort(SERIAL_ASYNC,bas,i,2400,'N',8,1) != 0) {
		printf("\nINITILIZATION ERROR: [%d]\n",c);
		exit(1);
	}
	clrscr();

	for(;;) {
		if (SERIAL.Error) {
			printf(">>>%d<<<",SERIAL.Error);
			SERIAL.Error = 0;
		}
		if (kbhit()) {
			c = getch();
			if (c == 0x001B) {  // End program //
				SERIAL_ClosePort();
				break;
			} else
			if (c == '~') {
				SERIAL_TransmitStr("Jeff Jones\r");
			} else
			if (c == 0x00) {
				SERIAL_TransmitChar(c);
				c = getch();
			}
			SERIAL_TransmitChar(c);
		}
		if ((c = SERIAL_ReceiveChar())!=0) { // Received a char //
			c = SERIAL_ReceiveChar();
			if (c == '\n') {
				b++;
			} else
			if (c == '\r') {
				a = 0;
			} else
			if (c == 8) {
				if (a > 0) a--;
			} else {
				fastprintchar(b, a, 14, 0, c);
				if (a++ > 79) {
					b++;
					a = 0;
				}
			}
			if (b>23) {
				fastscrollup(14, 0);
				b--;
			}
			gotoxy(a+1,b+1);
		}
	}
}