
	//------------------------------------------------------------------//
	//	  	 The following functions are used by you the programmer     //
	//------------------------------------------------------------------//

#define SERIAL_ONESECOND    (182/10)// Definition for one second of Ticks //

#define SERIAL_PARITY_ERROR	0x0001  // Parity Error 					   //
#define SERIAL_FRAME_ERROR  0x0002  // Framing Error					   //
#define SERIAL_BREAK_ERROR  0x0003  // Break Error						   //
#define SERIAL_OVRRUN_ERROR 0x0004  // Overrun Error                       //

#define SERIAL_LOCAL       	0x0000  //                                     //
#define SERIAL_ASYNC      	0x0001  // Simple settings for the type of     //
#define SERIAL_FOSSIL     	0x0002  // communications to be performed.     //
#define SERIAL_DIGIBOARD 	0x0003  //                                     //

extern char *SERIAL_OSName[5];

typedef struct {
	int		Count;
	int		Start;
	int		Cnext;
	int		Size;
	char *	Buffer;
} RING;

typedef struct {
	long 				Timers[10]; // Timer funct. counters  					//
	char				Type; 		// NonZero if Local Mode  					//
	char				Error; 		// NonZero if Comm Error  					//
	char				FIFOExists; // NonZero if FIFO exists 					//
	int      			PortBase; 	// Base of comm Port      					//
	int					IRQ; 		// IRQ Being used, 0=None 					//
	char				IRQShared; 	// True is IRQ is shared  					//
	char				OSType; 	// Set to equal OS type   					//
	unsigned char		InChar; 	// Char read from port    					//
	unsigned char		ModemStatus;// Modem Status Register  					//
	unsigned char		LineStatus; // Line Status Register   					//
	char				MaxSend; 	// Max Chars to send      					//
	char            	InputHS; 	// NonZero to hold input  					//
	char            	OutputHS; 	// NonZero to hold output 					//
	unsigned char far 	*DataReady; // DigiBoard FAR Data Ready Pointer Address //
	unsigned char		Abort;  	// NonZero if action aborted by CTRL-(K/C)  //
	RING				OutRing;    // Output data buffer	  					//
	RING				InRing;     // Input data buffer     					//
} SERIALINFO;

extern SERIALINFO SERIAL;

extern int 	SERIAL_OpenPort(char AsyncType, unsigned PortBase, int IRQ, long baudrate, int parity, int databits, int stopbits);
extern void SERIAL_ClosePort(void);
extern int 	SERIAL_CheckError(void);
extern int	SERIAL_TransmitChar(char c);
extern void SERIAL_TransmitStr(char *s);
extern int	SERIAL_ReceiveChar(void); // No Wait Function //
extern int 	SERIAL_DataReady(void);
extern void SERIAL_ToggleDTR(char OnOff);
extern int 	SERIAL_OnLine(void);
extern void	SERIAL_PurgeOutBuf(void);
extern void	SERIAL_PurgeInBuf(void);
extern void	SERIAL_FlushOutBuf(void);
extern void SERIAL_GetOSType(void);
extern void SERIAL_GiveSlice(void);
extern void SERIAL_TickDelay(long Ticks);
extern void SERIAL_SetTimer(int TimerNumber, long Ticks);
extern long	SERIAL_GetTimer(int TimerNumber);
