\ Word count program
\ Will count characters, words, lines, pages, and printing time for
\ any file or file(s) in the current directory
\ Program copyright (C) 1985 Thomas Almy.  All rights reserved.
\ Permission is granted to registered users of Forthcmp to sell or distribute
\ computer programs incorporating the compiled contents of this file.

200 MSDOS
INCLUDE DOS1

\ *** PRINTER CHARACTERISTICS FOR PRINTING PRINTER TIME *******
\ *** MUST SET FOR YOUR PRINTER.  THESE ARE FOR EPSON FX-85 ***

160 CONSTANT chars/sec	\ printing speed, ignoring line feed
66 CONSTANT lines/page  
6 CONSTANT lines/sec	\ slew rate for line feed

0 0 IN/OUT
: USAGE MESSAGES  CR  
	." USAGE: WC {filenames}" CR
	." Filenames may have * or ? wildcards." CR
	." File `-' means standard input." CR
	;


128 CONSTANT SCRATCH_BUF \ file block


HCB INFILE

\ KEY -- FROM A FILE

\ We will blanket allocate memory from location 6000 for 55k
\  to be used as a large file buffer.

1024 55 *  CONSTANT INBUFSZ
6000 CONSTANT INBUFFER   \ PUT INPUT BUFFER IN HIGH MEMORY
VARIABLE INBUFPTR
VARIABLE INBUFEND  

: KEY  INBUFPTR @ INBUFEND @ = IF ( fetch block )
     INFILE INBUFFER INBUFSZ FREAD ?DUP IF ( everything OK )
            INBUFFER INBUFPTR !  INBUFFER + INBUFEND !
     ELSE [CTRL] Z EXIT 
     THEN
    THEN
    INBUFPTR @ C@ 127 AND
   1 INBUFPTR +! ;


\ DIRECTORY SEARCHING STUFF

VARIABLE NEXTITEM

\ We will take the program argument list and fake it as a
\ line of keyboard input to make parsing easier.
0 0 IN/OUT
: DODIR  ( -- )
   SCRATCH_BUF COUNT >BUFFER  \ stuff arglist
   NEXTITEM ON			\ force reading of next item
   ;


\ PRINT A VALUE, PRINT A TIME

2 0 IN/OUT
: .VAL  ( dvalue -- )   
   <# #S #> 10 OVER - SPACES TYPE ;

2 0 IN/OUT
: .TIME  ( dtime -- )   
  5 SPACES
  60 MU/MOD 60 MU/MOD DROP
  ?DUP IF . ." hr " THEN
  ?DUP IF . ." min " THEN
  ?DUP IF . ." sec " THEN ;

\ GOTO A NEW FILE
2VARIABLE NBYTES    
2VARIABLE TOTBYTES
2VARIABLE NWORDS    
2VARIABLE TOTWORDS
2VARIABLE NLINES    
2VARIABLE TOTLINES
VARIABLE NPAGES     
2VARIABLE TOTPAGES
VARIABLE PAGEPOS

HCB WILDFILE 

VARIABLE INFILEP

1 0 IN/OUT 
: PUTN ( character -- , put in string of INFILE )
   INFILEP @ C! 1 INFILEP +! ;

VARIABLE /PNTR
0 0 IN/OUT
: MAKE-FILENAME \ set up INFILE with path from WILDFILE and
		\ file name from SCRATCH_BUF
	INFILE 3 + INFILEP ! \ address of destination string
	INFILEP @  /PNTR !  \ location of last slash 
	WILDFILE HCB>N COUNT 0 ?DO COUNT DUP PUTN 
		DUP [CHAR] \ = OVER [CHAR] / = OR SWAP [CHAR] : = OR IF
			INFILEP @ /PNTR ! THEN 
	LOOP
	DROP ( wildfile pointer )
	/PNTR @ INFILEP !	\ get rid of characters after last \
	SCRATCH_BUF 30 + \ remainder of filename
	BEGIN COUNT DUP WHILE PUTN REPEAT 2DROP
	INFILEP @ INFILE 3 + - INFILE 2 + C! \ length
	0 PUTN \ zero delimit string
	;

0 0 IN/OUT
: RESET-STUFF
  0. NBYTES 2!
  0. NWORDS 2!
  0. NLINES 2!
  1 NPAGES !		\ each file is always at least 1 page
  INBUFEND @ INBUFPTR !  ( force first read )
  ;

0 1 IN/OUT 
: NEW-FILE? ( -- success )
  BEGIN NEXTITEM @ IF ( must scan input stream )
		BL WORD DUP @ [CHAR] - 8 LSHIFT 1+ = IF ( use std-input )
			DROP
			C" (std-input)" INFILE NAME>HCB
			stdin @ INFILE !
			RESET-STUFF
			-1
			EXIT
		THEN
		DUP C@ 0= IF DROP 0 EXIT THEN ( End of line )
		WILDFILE NAME>HCB
		WILDFILE HCB>N 0 firstf
		NEXTITEM OFF 
	ELSE
		nextf
	THEN 
    WHILE ( search failed )
	NEXTITEM ON
    REPEAT
  MAKE-FILENAME
  INFILE O_RD FOPEN IF CR 
    ." OPEN FAILED FOR " INFILE .FNAME
    NEW-FILE? EXIT THEN	\ recurse for additional files
  RESET-STUFF
  -1 ( SUCCESS! )   ;

\ PRINT TOTALS
2VARIABLE TOTTIME
0 0 IN/OUT
: PRINT-TOTALS
  NBYTES 2@ TOTBYTES 2@ D- D0= IF CR EXIT THEN
  CR ." TOTALS--" 11 SPACES
  TOTBYTES 2@ .VAL  
  TOTWORDS 2@ .VAL
  TOTLINES 2@ .VAL  
  TOTPAGES 2@ .VAL
  TOTTIME 2@ .TIME   
  CR ;

0 0 IN/OUT
: PRINT-STATISTICS
  CR INFILE .FNAME
  19 INFILE HCB>N C@ - 0 MAX SPACES
  NBYTES 2@  2DUP  .VAL      TOTBYTES 2@ D+  TOTBYTES 2!
  NWORDS 2@  2DUP  .VAL      TOTWORDS 2@ D+  TOTWORDS 2!
  NLINES 2@  2DUP  .VAL      TOTLINES 2@ D+  TOTLINES 2!
  NPAGES @ 0 2DUP  .VAL      TOTPAGES 2@ D+  TOTPAGES 2!
  NBYTES 2@  chars/sec  UM/MOD  NIP  0
    NPAGES @  lines/page lines/sec / UM*
    D+ ( total time )
  2DUP  .TIME    TOTTIME 2@ D+  TOTTIME 2! ;


\  COUNT THE FILE
1 0 IN/OUT
\ : BUMP   DUP 2@ 1. D+ ROT 2! ;
CODE BUMP  
	AX BX MOV
	1 # 2 +[BX] ADD
	0 # [BX] ADC
	RET
END-CODE


0 0 IN/OUT
: COUNT-FILE   PAGEPOS OFF
    NBYTES BUMP
    KEY ( prime the pump )
    BEGIN  
      BEGIN ( out of word loop )
        DUP BL <= 
      WHILE
	CASE
	  [CTRL] L OF 1 NPAGES +! PAGEPOS OFF ENDOF
	  [CTRL] J OF NLINES BUMP 1 PAGEPOS +!
	    PAGEPOS @ 66 > IF 1 NPAGES +! PAGEPOS OFF THEN ENDOF
	  [CTRL] Z OF NBYTES 2@ 1. D- NBYTES 2! EXIT ENDOF ( done! )
	ENDCASE
    	NBYTES BUMP  KEY
      REPEAT
      NWORDS BUMP ( entering a word )
      BEGIN ( in word loop )
        DUP BL >
      WHILE
        DROP
	NBYTES BUMP
	KEY
      REPEAT
    AGAIN
;


\ CLOSE THE FILE

0 0 IN/OUT
: CLOSE-THE-FILE
	INFILE HCB>H stdin <> IF
		INFILE FCLOSE DROP
	THEN ;

\ MESSAGES
0 0 IN/OUT
: HELLO \ MESSAGES
\  ." Word Count Program," CR
\  ." Copyright (C) 1985 by Tom Almy" CR  CONSOLE
  ." FILENAME                BYTES     WORDS     LINES     PAGES     TIME"  CR
  0. TOTBYTES 2!  
  0. TOTWORDS 2!  
  0. TOTLINES 2!  
  0. TOTPAGES 2!
  0. TOTTIME  2!
;

: MAIN 
    128 C@ 0= IF USAGE EXIT THEN
    HELLO 
    DODIR
    BEGIN 
      NEW-FILE? WHILE
      COUNT-FILE
      CLOSE-THE-FILE
      PRINT-STATISTICS
    REPEAT
    PRINT-TOTALS
;


INCLUDE DOS2
INCLUDE FORTHLIB

END

