extern long *SIN, *COS;
extern int xtrans, ytrans, ztrans;
extern int xang, yang, zang;
extern long scal;


typedef struct
{
	int x,y;
} VERTEX_2D;

typedef struct
{
	int color, lados, ptr;
	VERTEX_2D *vertice;
} POL_2D;

typedef struct
{
	int x,y,z;
} VERTEX_3D;

typedef struct
{
	int vis, lados, color, ptr, norm_ptr;
} POL_3D;

typedef struct
{
	int num_of_pols, num_of_ptrs,num_of_verts;
	int pointer_ptr, vertice_ptr;
	POL_3D far *pol;
	int far *pointer;
	VERTEX_3D far *vertice;
} OBJECT;

void swap_P3D( POL_3D far *pol, int a, int b );
void swapint( int far *a, int far *b );
void sortpoly( OBJECT far *, POL_3D far *, int far *, VERTEX_3D far * );

void getpoly( POL_3D far *, int far *, VERTEX_2D far *,
						VERTEX_2D far *, int far *,
							int far *, int );

void getpoly_3D( POL_3D far *list, int far *vertxlist,
					VERTEX_3D far *polylist,
						VERTEX_3D far *salida, int numpol );

void rotate( VERTEX_3D far *pol, int lados, int xang, int yang, int zang );
void translate( VERTEX_3D far *pol, int lados, int xt, int yt, int zt );
void z_persp( VERTEX_3D far *pol, int lados );
void zoom( VERTEX_3D far *pol, int lados );
void copypoly3d( VERTEX_3D far *origen, VERTEX_3D far *destino, int lados );
void copy3to2d( VERTEX_3D far *orig, VERTEX_2D far *dest, int lados );
void polyclip( VERTEX_2D far *pol, int lados );
void copypoly2d( VERTEX_2D far *origen, VERTEX_2D far *destino, int lados );
void mat2vid( VERTEX_2D far *verts, int lados );
void mat2vid_3D( VERTEX_3D far *verts, int lados );

