#pragma inline
#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <time.h>
#include <math.h>
#include <alloc.h>
#include <process.h>
#include "polylib.h"
#include "graph.h"

void InitSinCos( void );
int old_mode;

int polyg1[30], polyg2[30], polyg3[30], polyg4[30], polyg5[30];

//                 lados   ptr <- a la lista de punteros
// Polgonos:  vis     colr    ptr a la normal
POL_3D polys[]={
			{	1,	4,  1,  0,  1},
			{	1,  4,  2,  4,  2},
			{	1,  4,  3,  8,  3},
			{	1,  4,  4, 12,  4},
			{	1,  4,  5, 16,  5},
			{	1,  4,  6, 20,  6}
		};

//lista de punteros a los vrtices
int verts[]={
				0, 1, 2, 3,
				0, 3, 7, 4,
				0, 1, 5, 4,
				1, 5, 6, 2,
				2, 6, 7, 3,
				4, 5, 6, 7
			};

//Lista de vrtices
VERTEX_3D polyga[]={
			  {	-50, -50, 50}, //0
			  {	 50, -50, 50}, //1
			  {	 50,  50, 50}, //2
			  {	-50,  50, 50}, //3
			  {	-50, -50,-50}, //4
			  {	 50, -50,-50}, //5
			  {	 50,  50,-50}, //6
			  {	-50,  50,-50}, //7
			 };

OBJECT far *cube;

OBJECT far *initobj( void )
{	OBJECT far *obj;
	obj=(OBJECT far *)farmalloc(sizeof(OBJECT));
	obj->num_of_pols=6;
	obj->pol=(POL_3D far *)&polys;
	obj->pointer=(int far *)&verts;
	obj->vertice=(VERTEX_3D far *)&polyga;
	return obj;
}

int col, lados;

void initvars( void )
{
	xang=yang=zang=xtrans=ytrans=ztrans=0;
	scal=0x8000;
}

int get_kb( void )
{	int car;
	if(kbhit())
		car=getch();
	else
		return 0;

	if(car)
		switch(car)
		{
			case '>': scal+=200; break;
			case '<': scal-=200; break;
			case 75: xang--; break;
			case 77: xang++; break;
			case 80: yang--; break;
			case 72: yang++; break;
			case 'a':
			case 'A': zang--; break;
			case 's':
			case 'S': zang++; break;
			case 155: xtrans--; break;
			case 157: xtrans++; break;
			case 152: ytrans--; break;
			case 160: ytrans++; break;
			case 'z':
			case 'Z': ztrans--; break;
			case 'x':
			case 'X': ztrans++; break;
			default: return car;
		};
	return car;
}

void transform( void )
{
		copypoly3d((VERTEX_3D far *)&polyga, (VERTEX_3D far *)&polyg2, 8 );
		translate((VERTEX_3D far *)&polyg2, 8, xtrans, ytrans, ztrans );
		rotate( (VERTEX_3D far *)&polyg2, 8, xang, yang, zang);
		zoom((VERTEX_3D far *)&polyg2, 8 );
		sortpoly( cube, (POL_3D far *)polys, (int far *)verts,
						(VERTEX_3D far *)polyg2 );
		z_persp((VERTEX_3D far *)&polyg2, 8 );
		copy3to2d((VERTEX_3D far *)&polyg2, (VERTEX_2D far *)polyg3, 8);
		mat2vid( (VERTEX_2D far *)&polyg3[0], 8 );
//		polyclip( (VERTEX_2D far *)&polyg3[0], 8 );
}

void transform1( void )
{
	copypoly3d((VERTEX_3D far *)&polyga[0], (VERTEX_3D far *)&polyg2[0], 8 );
	translate((VERTEX_3D far *)&polyg2, 8, xtrans, ytrans, ztrans );
	rotate( (VERTEX_3D far *)&polyg2, 8, xang, yang, zang);
	zoom((VERTEX_3D far *)&polyg2, 8 );
	sortpoly( cube, (POL_3D far *)polys, (int far *)verts,
					(VERTEX_3D far *)polyg2 );
	z_persp((VERTEX_3D far *)&polyg2, 8 );
	mat2vid_3D( (VERTEX_3D far *)&polyg2[0], 8 );
}

void render( int segm )
{	int cuenta;

	SCRN=segm;
	clear( 0, segm );

	for(cuenta=0; cuenta<cube->num_of_pols; cuenta++ )
	{
		getpoly( (POL_3D far *)polys, (int far *)verts,
						(VERTEX_2D far *)polyg3,
							(VERTEX_2D far *)polyg4,
							(int far *)&col,
								(int far *)&lados, cuenta );

		drawpoly( (int far *)&polyg4, lados, col);
	};
}

void render1( int segm )
{	int cuenta;

	SCRN=segm;
	clear( 0, segm );

	for(cuenta=0; cuenta<cube->num_of_pols; cuenta++ )
	{
		getpoly( (POL_3D far *)polys, (int far *)verts,
						(VERTEX_2D far *)polyg2,
							(VERTEX_2D far *)polyg3,
								(int far *)&col,
									(int far *)&lados, cuenta );

		getpoly_3D( (POL_3D far *)polys, (int far *)verts,
					(VERTEX_3D far *)polyg2,
						(VERTEX_3D far *)polyg3, cuenta );

		drawpol1( (VERTEX_3D far *)polyg3, lados  );
	};
}

void main( void )
{   int car, vscr;

	InitSinCos();

	old_mode=getvmode();
	setvmode(19);

	cube=initobj();
	initclosed();
	vscr=valloc(65000);
	initvars();

	car=1;
	while(car!=27)
	{
		if(car)
		{
			transform1();
			if(vscr!=1)
			{
				render1( vscr);
				flip( vscr, 0xA000 );
			}
			else
				render1( 0xA000);
		};
		car = get_kb();
	};

salida:
	setvmode(old_mode);
	vfree(vscr);
	farfree(cube);
	if( closed!=1)
		vfree(closed);
	printf("\nRegresando a DOS...\n\n");
	return;
}

