// PrintNow.cpp : Defines the class behaviors for the application.
//
// PrintNow version 1.0.
// Copyright  1997 Ziff-Davis Publishing
// First published in PC Magazine April 22, 1997
// Written by Gregory A. Wolking.

#include "stdafx.h"
#include "PrintNow.h"
#include "PNDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPNApp

BEGIN_MESSAGE_MAP(CPNApp, CWinApp)
	//{{AFX_MSG_MAP(CPNApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPNApp construction

CPNApp::CPNApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
	m_pszAppName = "PrintNow";
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CPNApp object

CPNApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CPNApp initialization

BOOL CPNApp::InitInstance()
{
	BOOL first_instance = FALSE;
	OSVERSIONINFO vi;

	// Initialize pointer and handle.
	m_hMappedData = NULL;
	m_pInstanceCount = NULL;

	// Make sure we're running under either Windows 95 or NT 4.0.
	vi.dwOSVersionInfoSize = sizeof(vi);
	GetVersionEx(&vi);
	if (!((vi.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
		|| (vi.dwPlatformId == VER_PLATFORM_WIN32_NT && vi.dwMajorVersion == 4)))
	{
		::MessageBox(NULL, "This program requires Windows 95 or Windows NT 4.0", "PrintNow", MB_ICONSTOP);
		return FALSE;
	}
	// Try to open our file-mapped data object.
	if ((m_hMappedData = OpenFileMapping(FILE_MAP_WRITE, FALSE, "PrintNow data")) == NULL)
	{	
		// If open failed, we must be the first instance, so
		first_instance = TRUE;			// set flag,
		m_hMappedData =					// and try to create the object.
			CreateFileMapping(
				(HANDLE) 0xFFFFFFFFL,	// Use the system page file instead of a separate temporary file.
				NULL,					// Default security access.
				PAGE_READWRITE,			// Read-write access.
				0, sizeof(UINT),		// Reserve enough space to hold a UINT.
				"PrintNow data");		// Create a named object so subsequent instances can find it.
	}
	// If object exists, try to create the necessary view of our mapped data.
	if (m_hMappedData != NULL)
		m_pInstanceCount = (UINT *) MapViewOfFile(m_hMappedData, FILE_MAP_WRITE, 0, 0, sizeof(UINT));
	// If unable to access mapped data, display error message and quit.
	if (m_hMappedData == NULL || m_pInstanceCount == NULL)
	{
		::MessageBox(NULL, "Unable to create or access shared data.", "PrintNow", MB_ICONSTOP);
		return FALSE;
	}
	if (first_instance)			// If we're the first instance,
		*m_pInstanceCount = 1;	// set instance counter to 1.
	else						// Otherwise,
		++ *m_pInstanceCount;	// increment it.

	// Create the main dialog and get a pointer to it.
	CPNDlg dlg;
	m_pMainWnd = &dlg;
	{
		// Build string for window caption and tooltip text.
		// Note: This is the only place I need to format an integer as ASCII text.
		// When linking with the static MFC libraries, using this
		// code instead of CString.Format() eliminates a call to sprintf()
		// and shaves about 6K off the size of the .EXE file.
		// If you choose to rebuild using the dynamic MFC libraries, this
		// has no effect on the .EXE file size because sprintf() resides
		// in the runtime DLL. Thus, you could replace this block with:
		//		CString text;
		//		text.Format("PrintNow(%u)", *m_pInstanceCount);
		//		dlg.m_strCaption = text;
		// This code allows the instance counter to range from 1 to 99,999.
		CString text("PrintNow (");			// Create base string.
		UINT value = *m_pInstanceCount;		// Get copy of instance counter.
		char buff[6] = {0, 0, 0, 0, 0, 0};	// Buffer for ASCII text (5 digits + null terminator)
		char *ascii = &buff[5];				// String is built from right to left, so point to
											// the end of the buffer.
		while (value)						// While value is not 0,
		{
			--ascii;						// Point to previous character.
			*ascii = '0' + (value % 10);	// Remainder gives us the digit.
			value /= 10;					// Shift value one place to right.
		}
		text += ascii;						// Append ASCII number to string.
		text += ")";						// Finish with closing paren.
		dlg.m_strCaption = text;			// Give dialog a copy of the string
		dlg.m_dwPlatform = vi.dwPlatformId;	// and tell it which platform we're on.
		m_pszAppName = text;				// Set app name (used for message box captions).
	}
	dlg.DoModal();	// Launch the dialog.
	return FALSE;	// App terminates when dialog closes.
}

// Clean up file-mapped data on termination.
int CPNApp::ExitInstance() 
{
	// If pointer is not NULL, unmap our view of the object.
	// System automatically deletes the object when all mapped views have been
	// released, so we don't need to worry about tracking whether or not we're
	// the last instance to terminate.
	if (m_pInstanceCount)
		UnmapViewOfFile((void *) m_pInstanceCount);
	// If object handle is not NULL, close it. This is really just a formality;
	// Windows supposedly closes any open handles automatically when an app terminates,
	// but better safe than sorry!
	if (m_hMappedData)
		CloseHandle(m_hMappedData);
	// Call base class to complete termination.
	return CWinApp::ExitInstance();
}
