// PNDlg.h : header file
//
// PrintNow version 1.0.
// Copyright  1997 Ziff-Davis Publishing
// First published in PC Magazine April 22, 1997
// Written by Gregory A. Wolking.

/////////////////////////////////////////////////////////////////////////////
// CPNDlg dialog
#include "dibapi.h"
class CPNDlg : public CDialog
{
// Construction
public:
	CPNDlg(CWnd* pParent = NULL);	// standard constructor
	//  Variables initialized by CPNApp::InitInstance()
	CString m_strCaption;			// Used for dialog caption, tooltip, and menu text.
	DWORD m_dwPlatform;				// Indicates current platform (Win 95 or NT).

// Dialog Data
	//{{AFX_DATA(CPNDlg)
	enum { IDD = IDD_PN_DIALOG };
	CButton	m_cmdUnload;
	CStatic	m_lblPrintWait;
	CStatic	m_lblCurrent;
	CStatic	m_lblStatus;
	CButton	m_cmdPrintClipboard;
	CButton	m_cmdApply;
	BOOL	m_bAlways;
	BOOL	m_bCenterImage;
	BOOL	m_bEnabled;
	int		m_intScaleMode;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPNDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CPNDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OncmdApply();
	afx_msg void OncmdUnload();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnDrawClipboard();
	afx_msg void OnChangeCbChain(HWND hWndRemove, HWND hWndAfter);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg LONG On_Taskbar_Notify(WPARAM wParam, LPARAM lParam);
	afx_msg LONG On_Print_Clipboard(WPARAM wParam, LPARAM lParam);
	afx_msg LONG On_Update_Button(WPARAM wParam, LPARAM lParam);
	afx_msg LONG On_Popup(WPARAM wParam, LPARAM lParam);
	afx_msg LONG On_Terminate(WPARAM wParam, LPARAM lParam);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OncmdUnloadAll();
	//}}AFX_MSG
	afx_msg void Update_Apply_Button(UINT nID);
	afx_msg void On_My_Command(UINT nID);
	afx_msg void OnHelpContext();
	afx_msg void OnHelp();
	afx_msg void OnHelpFinder();
	DECLARE_MESSAGE_MAP()
private:
	// Functions
	BOOL Bring_To_Top();
	BOOL Check_Clipboard_Hook();
	BOOL Copy_Clipboard_Image();
	void Discard_Image();
	void Do_Print(BOOL ask_first);
	void Do_Print_Clipboard();
	void Do_Print_Setup();
	BOOL Do_Taskbar_Icon(UINT func, LPCTSTR text);
	void Do_Taskbar_Menu();
	void Hide_Controls(BOOL hide);
	void Hide_Dialog();
	BOOL Hook_Clipboard(BOOL hook);
	UINT Init_Dialog_Data();
	void Init_DIB_Data();
	void Parse_Command_Line();
	void Prepare_Image(HDC hDC);
	void Prepare_Menu();
	void Set_Tooltip_Text();
	void Show_Dialog();
	void Show_Printer_Name();
	// Scalar variables
	BOOL m_bClipboardHooked;	// TRUE while hooked into clipboard chain.
	BOOL m_bDialogActive;		// TRUE when main dialog is visible and persistent
								// (as opposed to when dialog is only made visible
								// temporarily to allow proper placement of
								// print dialog and/or to show warning message
								// while printing is in progress)
	BOOL m_bFirstPass;			// TRUE only while hooking clipboard chain.
	BOOL m_bInPrintLoop;		// TRUE while printing is in progress.
	BOOL m_bIsPrinting;			// TRUE when Print or Print Setup dialog is active.
	BOOL m_bMenuActive;			// TRUE when pop-up menu is active.
	BOOL m_bShutdown;			// TRUE only when terminating.
	BOOL m_bTaskbarHooked;		// TRUE when task bar icon is installed.
	DWORD m_dwPopupContext;		// Holds context ID for pop-up help.
	int m_intMyTimer;			// Timer ID for startup kludge (see OnInitDialog).
	// Objects, handles, and pointers
	CMenu*			m_pMainMenu;		// Main menu.
	CMenu*			m_pPopUpMenu;		// Task-bar pop-up menu.
	CMenu*			m_pScaleSubMenu;	// Image-scaling sub-menu.
	CPalette*		m_pPal;				// Image palette.
	CPrintDialog*	m_pPrintDialog;		// Print common dialog.
	CRect			m_rcDIB;			// Image size.
	CRect			m_rcDest;			// Page coordinates for printed image.
	HDIB			m_hDIB;				// Handle to DIB image
	HWND			m_hWndNextViewer;	// Next viewer in clipboard chain.
	HICON			m_hIcon;			// Handle to our icon.
};
