

//---------------------------FLATARRY.H------------------------------------//

#ifndef _flatarry_h_
#define _flatarry_h_

typedef long VHANDLE;
typedef unsigned char BYTE;
typedef unsigned int WORD;

#include <fstream.h>

#ifndef _EMS_
#define _EMS_ 0
#endif

inline long align( long a, long b ) {  // align unruly numbers
  return ((a-1) / b + 1) * b;
}

class FlatArray {    	// the generic base class for flat memory model
 protected:             // used by virtual memory; only descendants are used
  VHANDLE size;         // array's total size
  long dw;              // dummy character
 public:
  FlatArray( VHANDLE i ) { size = (i>0 ? i : 0); }
  virtual char far& operator [] (VHANDLE i) { return (char far&)dw; };
  virtual size_t far & FlatArray::operator() (VHANDLE i);
  VHANDLE get_size() { return size; }
  virtual operator int() { return 0; } // to check validity of array
};

// define base class for all virtual arrays (disk, EMS, or heap-debug)

class HeapArray :public FlatArray {     // a memory-heap-based array object
  char far * p;                         //  mainly good for debugging &
  long c;                               //  illustration purposes.
  long size;
public:
  HeapArray(VHANDLE sz);
  ~HeapArray();
  operator int() { return (p?1:0); }    // to check validity
  char far & operator[] (VHANDLE x);    // for array indexing
};


class DiskArray : public FlatArray {    // binary-file-based array using
					//   C++ stream functions:
  long page;                            // current page number
  long mask;                            // bitmask for indexing
  size_t bufsize;                       // size of page in memory
  char far *pbuf;                       // addres of page buffer
  fstream file;                         // the file object
  access(long newpage);                 // change file page being accessed
public:
  DiskArray(VHANDLE sz, char *p="DISKARRY.000", size_t nbits=6 );
  ~DiskArray();              //      ^----default filename
  operator int() { return  (file) && (pbuf!=NULL);  }
  char far & DiskArray::operator[] (long index);
};

#if _EMS_

  #define EMS_PHYS_PAGESIZE (0x4000L)

  extern "C" {
   BYTE EMSmap(int handle, int log, int phys);
   int EMSalloc(int num_ems_pages);
   WORD EMSframe();
   BYTE EMSfree(int handle);
   BYTE EMSinstall();
  }

  class EMSArray : public FlatArray {  // expanded-memory-based array object:
    long page;                         //  interface very similar to that
    long mask;                         //    of file array
    int nbits;
    size_t bufsize;
    char far *pbuf;
    access(long newpage);
  public:
    size_t numEMSpages;
    int EMShandle;         	// handle of allocated EMS blocks
    EMSArray(VHANDLE size=0x00100000);
    operator int() { return  ( EMShandle > 0 ); }
    char far & operator[] (long index);
    ~EMSArray();
  };
#endif /*_EMS_*/


#endif /** _flatarry_h_ **/
