/* REXX program to create a WPS object for PMView 0.92 */

'cls'

say "Have you already installed PMView? That is, do you already have the"
reply = GetYesNo('environment variables in your CONFIG.SYS')
if \reply then do
   say "Please run INSTALL (or do the steps in DIY.TXT) instead of this"
   say "program. To run INSTALL, simply enter INSTALL at an OS/2 prompt."
   end

say 'Creating "PMVIEW92" icon for desktop.'

Call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
Call sysloadfuncs

fullpath=Directory()
if right(fullpath, 1) \= "\" then do
   fullpath = fullpath || "\"
   end

drop res.
call SysFileTree fullpath || "PMVIEW.EXE", res, "OF"
if res.1 = "RES.1" then do
   say "Hmm, I can't find PMView.EXE here...."
   say "I'm afraid I'll have to stop."
   say
   say "Please make sure to unzip PMView into this directory and"
   say "re-run this program."
   exit
   end
else do
   assoc = '*.BMP,*.EPS,*.GIF,*.IFF,*.JPG,*.MSP,*.PBM,*.PCD,*.PCX,' ||,
           '*.PGM,*.PIC,*.PNG,*.PPM,*.SHW,*.TGA,*.TIF,'
   Call SysCreateObject 'WPProgram','PMView92','<WP_DESKTOP>','CCVIEW=YES;EXENAME='||fullpath||'\PMVIEW.EXE;PROGTYPE=PM;PARAMETERS=%*;STARTUPDIR='||fullpath||';ASSOCFILTER='||assoc,'R'
   Say "Okay, I've created a desktop icon for PMView."
   end

say "If you are a registered user, and you have put your name and code"
say "in a file called MYCODE, then enter REGME at an OS/2 prompt to"
say "register your new copy of PMView."
say
say "(If you are a registered user and have NOT put your name and code in"
say "MYCODE, we recommend that you do so. All you have to do is create"
say "a text file called MYCODE and put two lines in it -- your name as"
say "the first line, and your code as the second line. Then you can"
say "register your new copy by simply entering REGME at an OS/2 prompt.)"
say
say "Thanks for your interest in PMView."

exit

GetYesNo: procedure
ok = 0
do until ok
   call charout, arg(1) || "? "
   pull reply
   reply = left(reply, 1)
   ok = (reply = "Y") | (reply = "N")
   if \ok then do
      say
      say 'Huh? Please enter "Y" or "N".'
      end
   end /* loop */
return (reply = "Y")
