/*rexx*/
/**********************************************************************/
/* Exec:     Install utility                                          */
/* Function: Install Heliotropic Systems, Inc. shareware              */
/* History:  08/02/95 - LMK - Set up for PMSysLev                     */
/*                          - Included handling for possible previous */
/*                            install of FileFind...                  */
/**********************************************************************/
/*                                                                    */
"@echo off"
/*                                                                    */
/* Ensure that you can use the REXXUTILs...                           */
/*                                                                    */
  if 0 < RxFuncQuery('SysLoadFuncs') then do
      call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
      call SysLoadFuncs
  end
/*                                                                    */
/* Set up the default variables...                                    */
/*                                                                    */
  bootdrive = translate(value('PATH',,'OS2ENVIRONMENT'))
  thedrive  = substr(bootdrive,pos('\OS2\SYSTEM',bootdrive)-2,2)
  ObjMode   = 'Replace'
  returnRC  = 0
  TRUE      = (1=1)
  FALSE     = (0=1)
  been_here = FALSE
  done_that = FALSE
  drop bootdrive
/*                                                                    */
/* Proceed with the installation...                                   */
/*                                                                    */
  say ' '
  say '                 Installing PMSysLev Utility'
  say ' '
  call Drive_Check
  result = VROBJ_Check()
  if result \= 0 then
      signal Done
  result = File_Check()
  if result \= 0 then
      signal Done
  call Check_Kit
  result = Inst_Part1()
  if result \= 0 then
      signal Done
  call Inst_Part2
  if been_here = FALSE then
      call Create_Kit
  call Create_PMSysLev
  call Create_Register
  call Create_ReadMe
  call Clean_Up
  say ' '
  say '     Installation completed.'
  say ' '
Done:
  exit
/*                                                                    */
/* Determine all of the available Drive letters...                    */
/*                                                                    */
Drive_Check:
  all_drives = SysDriveMap(thedrive,'USED') /* can't see CD's empty!! */
  i = 1
  do forever
      parse var all_drives d_letter.i all_drives
      if all_drives = "" then
          leave
      i = i + 1
  end
  d_letter.0 = i
return
/*                                                                    */
/* Check to see if there is a vrobj.dll to work with...               */
/*                                                                    */
VROBJ_Check:
  say ' '
  say '  Please wait while your system is checked for VROBJ.DLL...'
  say ' '
  dll_check = 0
  do i = 1 to d_letter.0
      say '     Checking Drive 'd_letter.i
      saveRC = SysFileTree( d_letter.i || '\VROBJ.DLL', 'DLLs', 'FS' )
      dll_check = dll_check + DLLs.0
      if DLLs.0 > 0 then do
          say '     VROBJ.DLL has been located.'
          leave
      end
  end
  if dll_check = 0 then do
      say '  Warning:  VROBJ.DLL was not found on this system! '
      say '  You must download it and put it in your LIBPATH to use PMSysLev.'
      returnRC = 4
  end
return returnRC
/*                                                                    */
/* Make sure everything is here to work on...                         */
/*                                                                    */
File_Check:
  say ' '
  say '  Checking to make sure all of the PMSysLev files are intact...'
  say ' '
  ifile.0 = 8
  ifile.1 = 'pmsyslev.exe'
  ifile.2 = 'pmsyslev.hlp'
  ifile.3 = 'pmsyslev.hst'
  ifile.4 = 'regpmsl.txt'
  ifile.5 = 'readme.1st'
  ifile.6 = 'file_id.diz'
  ifile.7 = 'sun.ico'
  ifile.8 = 'install.cmd'
  do i = 1 to ifile.0 - 1
      saveRC = SysFileTree( ifile.i, 'Files', 'F' )
      if Files.0 = 0 then do
          say '  Warning:  'ifile.i' was not found!'
          say ' '
          say '  All of the files are required for installation of PMSysLev.'
          say '  Use PKUNZIP again with the "-o" operand.'
          returnRC = 4
          leave
      end
  end
  if returnRC = 0 then
      say '     OK, everthing is intact.'
return returnRC
/*                                                                    */
/* Check for existence of previous installs...                        */
/*                                                                    */
Check_Kit:
  call SysInI 'USER', 'PM_Workplace:Location', 'All:', 'ids.'
  do i = 1 to ids.0
      if ids.i = '<WP_LMK_HSU>' then do
          been_here = TRUE
          leave
      end
  end
return
/*                                                                    */
/* Find out where to put all of this...                               */
/*                                                                    */
Inst_Part1:
  UnPack_Dir = Directory()
  say ' '
  say '  Enter the drive letter and name of the directory in which you want'
  say '  PMSysLev installed (default: 'UnPack_Dir'):'
  pull Install_Dir
  if Install_Dir = "" then
      Install_Dir = UnPack_Dir
  else do
/*                                                                    */
/* If you need to, create the directory...                            */
/*                                                                    */
      saveRC = SysFileTree(Install_Dir, 'Dirs', 'D')
      if Dirs.0 = 0 then do
          if 0 < SysMkDir(Install_Dir) then do
              say ' '
              say '  Warning:  Unable to create target directory.'
              returnRC = 4
              leave
          end
      end
  end
  say ' '
return returnRC
/*                                                                    */
/* Install the puppy...                                               */
/*                                                                    */
Inst_Part2:
  if Install_Dir \= UnPack_Dir then do
      say '  Please wait will PMSysLev files are copied to 'Install_Dir'...'
      do i = 1 to ifile.0 - 1
          '@xcopy 'ifile.i Install_Dir || '\*.* > nul'
      end
  end
  saveRC = SysFileTree( Install_Dir'\Filefind.exe', 'Files', 'F' )
  if Files.0 = 1 then
      done_that = TRUE
return
/*                                                                    */
/* Create the folder for Heliotropic Systems...                       */
/*                                                                    */
Create_Kit:
  location    = "<WP_DESKTOP>"
  title       = "Heliotropic^Systems^Utilities"
  classname   = "WPFolder"
  SetupString = "OBJECTID=<WP_LMK_HSU>;"
  SetupString = SetupString || "NOLINK=YES;"
  SetupString = SetupString || "NOCOPY=YES;"
  SetupString = SetupString || "NOPRINT=YES;"
  SetupString = SetupString || "NORENAME=YES;"
  SetupString = SetupString || "NOSHADOW=YES;"
  SetupString = SetupString || "NOTDEFAULTICON=YES;"
  SetupString = SetupString || "ICONFILE="Install_Dir"\SUN.ICO;"
  call Make_Object
return
/*                                                                    */
/* Create the object for PMSysLev                                     */
/*                                                                    */
Create_PMSysLev:
  location    = "<WP_LMK_HSU>"
  title       = "PMSysLev"
  classname   = "WPProgram"
  SetupString = "OBJECTID=<LMK_HSU_PMSL>;"
  SetupString = SetupString || "EXENAME="Install_Dir"\PMSysLev.EXE;"
  SetupString = SetupString || "STARTUPDIR="Install_Dir";"
  SetupString = SetupString || "PROGTYPE=PM;"
  SetupString = SetupString || "AUTOCLOSE=YES;"
  call Make_Object
return
/*                                                                    */
/* Create the object for the registration form                        */
/*                                                                    */
Create_Register:
  if been_here = TRUE then do
      if done_that = TRUE then do
          call SysDestroyObject "<LMK_HSU_REG>"
          location    = "<WP_LMK_HSU>"
          title       = "FileFind Registration"
          classname   = "WPShadow"
          SetupString = "SHADOWID="Install_Dir"\Register.Txt;"
          SetupString = SetupString || "OBJECTID=<LMK_HSU_REGFF>;"
          call Make_Object
      end
  end
  location    = "<WP_LMK_HSU>"
  title       = "PMSysLev Registration"
  classname   = "WPShadow"
  SetupString = "SHADOWID="Install_Dir"\Regpmsl.Txt;"
  SetupString = SetupString || "OBJECTID=<LMK_HSU_REGPMSL>;"
  call Make_Object
return
/*                                                                    */
/* Create the object for the readme file                              */
/*                                                                    */
Create_ReadMe:
  if been_here = TRUE then do
      if done_that = TRUE then do
          tempfile = SysTempFileName('TEMP.???')
          outfile  = tempfile
          fline.0  = 10
          fline.1  = '******************************************************************'
          fline.2  = 'Utility:   FileFind'
          fline.3  = '******************************************************************'
          fline.4  = ' '
          fline.5  = 'Version:  2.07 - Release date:  July 13, 1995'
          fline.6  = ' '
          fline.7  = 'Changes:  None'
          fline.8  = ' '
          fline.9  = 'History:  07/13/95 - lmk - Public release'
          fline.10 = ' '
          do i = 1 to fline.0
              call lineout outfile, fline.i
          end
          call lineout outfile
          newfile  = 'FileFind.Hst'
          "@copy "outfile Install_Dir"\"newfile '> nul'
          call SysFileDelete outfile
      end
  end
  location    = "<WP_LMK_HSU>"
  title       = "Read Me First"
  classname   = "WPShadow"
  SetupString = "SHADOWID="Install_Dir"\Readme.1st;"
  SetupString = SetupString || "OBJECTID=<LMK_HSU_1ST>;"
  call Make_Object
return
/*                                                                    */
/* Clean up the files you no longer need...                           */
/*                                                                    */
Clean_Up:
  if Install_Dir \= UnPack_Dir then do
      do i = 6 to ifile.0
          call SysFileDelete Install_Dir'\'ifile.i
      end
  end
return
/*                                                                    */
/* Build the objects for the desktop...                               */
/*                                                                    */
Make_Object:
  say ' '
  say '     Creating 'title' at 'location' as 'classname
  saveRC = 0
  saveRC = SysCreateObject(classname,title,location,SetupString,ObjMode)
  if saveRC \= 1 then
      say '  Warning:  Creation of new object returned 'saveRC
  say ' '
return
