/* -----------------------------------------------------------------------

@echo off
cls
ECHO This INSTALL routine requires that you have OS/2 REXX support installed.
ECHO You should run Selective Installation from the OS/2 Setup Folder to
ECHO install REXX support before attempting to run this CMD file.
PAUSE
EXIT

   -----------------------------------------------------------------------

     SETUP.CMD -- Oberon Software PMQWK Install Procedure
                  Copyright (c) 1993 by Oberon Software, Mankato, MN
                  All rights reserved

   ----------------------------------------------------------------------- */

/* ----------------------------------------------------------------------- */
'@echo off'

/* ----------------------------------------------------------------------- */
/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/* ----------------------------------------------------------------------- */
/* "Global" variables */

CopyRLine0 = 'Oberon Software PMQWK Install Procedure'
CopyRLine1 = 'Copyright (c) 1993 by Oberon Software, Mankato, MN'
CopyRLine2 = 'All rights reserved'

SourcePath  = ''
TargetPath  = 'C:\PMQWK'
TargetPath2 = ''
DLLPath     = ''
RestorePath = ''
AvailDrives = ''
BootDrive   = ''
LIBSubPath. = ''
SpaceNeeded = 500000
SpaceAvail  = 0

SourceFile.   = ''
SourceFile.0  = 12
SourceFile.1  = 'Coming.Up'    ; SourceFile.1.Shadow  = 1
SourceFile.2  = 'Oberon.Ico'   ; SourceFile.2.FIcon   = 1
SourceFile.3  = 'PmQWK.Doc'    ; SourceFile.3.Shadow  = 1
SourceFile.4  = 'PmQWK.Exe'    ; SourceFile.4.Program = 1
SourceFile.5  = 'PmQWK.Hlp'
SourceFile.6  = 'Read.Me'      ; SourceFile.6.Shadow  = 1
SourceFile.7  = 'RegExpUT.DLL' ; SourceFile.7.DLL     = 1
SourceFile.8  = 'Setup.Cmd'    ; SourceFile.8.NoInst  = 1
SourceFile.9  = 'Taglines.Txt' ; SourceFile.9.Careful = 1
SourceFile.10 = 'Whats.New'    ; SourceFile.10.Shadow = 1
SourceFile.11 = 'ZFront.Doc'   ; SourceFile.11.Shadow = 1
SourceFile.12 = 'ZFront.Exe'


AvailDrives = SysDriveMap('A:', 'USED')
call Install
call SysCls
say ''
say 'Oberon Software PMQWK Install Ended!'
say ''
say '  Oberon Software'
say '  518 Blue Earth St.'
say '  Mankato, MN 56001-2142'
say '  1-507-388-7001'
say ''
Exit 0


/* ----------------------------------------------------------------------- */

Install:
  if BootDrive = '' then
    do
      call GetBootDrive
      if result = 0 then return
    end
  if SourcePath = '' then
    do
      parse source . . argv0 .
      temp = reverse(argv0)
      temp = substr(temp, pos('\', temp))
      if length(temp) > 3 then temp = substr(temp, 2)
      SourcePath = reverse(temp)
    end

  do forever
    parse value SysDriveInfo(substr(TargetPath, 1, 2)) with dummy SpaceAvail dummy2
    if DLLPath = '*Program Directory*' then
      tempDLLPath = TargetPath
    else
      tempDLLPath = DLLPath
    InstallDone = 0
    call PutCopyright
    say ''
    say 'Select one of the following:'
    say ''
    say ''
    say '       1. Select SOURCE Path      (Current is:' SourcePath')'
    say '       2. Select TARGET Path      (Current is:' TargetPath')'
    say '       3. Select DLL    Path      (Current is:' tempDLLPath')'
    say '       4. Install PMQWK'
    say '       0. Quit Install Procedure'
    say ''
    say ''
    if SpaceAvail < SpaceNeeded then
      say 'NOTE: Installation requires' SpaceNeeded 'bytes on target drive, only' SpaceAvail 'available!.'
    call charout ,'Enter 0, 1, 2, 3, or 4: '
    do forever
      k = SysGetKey('NOECHO')
      if k = '0' | k = '1' | k = '2' | k = '3' | k = '4' | k = D2C(27) then
        do
          if k = D2C(27) then k = '0'
          say k
          ProgAction = k
          leave
        end
      else
        call beep 1760, 50
    end
    select
      when ProgAction = '0' then leave
      when ProgAction = '1' then call AskPath 'SOURCE'
      when ProgAction = '2' then call AskPath 'TARGET'
      when ProgAction = '3' then call AskLIBPath
      when ProgAction = '4' then call DoInstall
    end
    if InstallDone \= 0 then leave
  end
  return


/* ----------------------------------------------------------------------- */

DoInstall:
  call PutCopyright

  if SpaceAvail < SpaceNeeded then
    do
      say ''
      say 'You do NOT have enough room on the target disk for all files!'
      call GetYN 'Do you want to continue anyway?'
      if result \= 1 then return
      call PutCopyright
    end

  pathOK = 1
  cwd = directory()
  testpath = directory(TargetPath)
  call directory cwd
  if translate(testpath) \= translate(TargetPath) then
    do
      say ''
      say 'Target path "'TargetPath'" does not exist!'
      call GetYN 'Create it?'
      if result = '1' then
        do
          r = SysMkDir(TargetPath)
          if r \= 0 then
            do
              say 'Cannot create directory "'TargetPath'"'
              call charout ,'Press any key...'
              call SysGetKey 'NOECHO'
              pathOK = 0
            end
        end
      else
        pathOK = 0
    end

  if pathOK = 0 then return

  tempSrc = SourcePath
  n = length(tempSrc)
  if substr(tempSrc, n, 1) \= '\' then tempSrc = tempSrc||'\'
  tempDest = TargetPath
  n = length(tempDest)
  if substr(tempDest, n, 1) \= '\' then tempDest = tempDest||'\'
  do i = 1 to SourceFile.0
    if SourceFile.i.NoInst \= 1 then
      do
        if SourceFile.i.DLL = 1 & DLLPath \= '*Program Directory*' then
          say 'Installing' tempSrc||SourceFile.i '-->' DLLPath
        else
          say 'Installing' tempSrc||SourceFile.i '-->' TargetPath
        r = stream(tempSrc||SourceFile.i, 'C', 'query exists')
        if r = '' then
          do
            call beep 1760, 50
            say '  Cannot find' tempSrc||SourceFile.i'!!'
            say '  File not installed.'
            call charout ,'  Press any key...'
            call SysGetKey 'NOECHO'
            say ''
          end
        else
          do
            if SourceFile.i.Careful = 1 then
              do
                r2 = stream(tempDest||SourceFile.i, 'C', 'query exists')
                if r2 \= '' then
                  do
                    call beep 1760, 50
                    say '  File:' tempDest||SourceFile.i 'exists and may contain user data!'
                    call charout ,'  Select: (1) Skip file, (2) Overwrite file: '
                    do forever
                      k = SysGetKey('NOECHO')
                      if k = '1' | k = '2' then
                        leave
                      else
                        call beep 1760, 50
                    end
                    say k
                  end
                else
                  k = '2'
                if k = '2' then 'copy' tempSrc||SourceFile.i TargetPath '>nul'
              end
            else
              do
                if SourceFile.i.DLL = 1 & DLLPath \= '*Program Directory*' then
                  'copy' tempSrc||SourceFile.i DLLPath '>nul'
                else
                  'copy' tempSrc||SourceFile.i TargetPath '>nul'
              end
          end
      end
  end

  call PutCopyright
  say '    Installation of files is complete!'
  say ''
  say ''
  say 'If you wish, Install can create a desktop folder containing PMQWK'
  say 'program and information objects for you.'
  say ''
  call GetYN 'Do you want a desktop folder installed?'
  if result = 1 then call CreateFolder

  call PutCopyright
  say '    Installation of files is complete!'
  say ''
  say ''
  call charout ,'Press any key...'
  call SysGetKey 'NOECHO'

  InstallDone = 1
  return


/* ----------------------------------------------------------------------- */

CreateFolder:
  call PutCopyright

  hadError = 0
  iconFile = ''
  do i = 1 to SourceFile.0
    if SourceFile.i.FIcon = 1 then
      do
        iconFile = SourceFile.i
        leave
      end
  end

  classname='WPFolder'
  title='Oberon Software'
  location='<WP_DESKTOP>'
  if iconFile = '' then
    do
      setup='OBJECTID=<OBERON_FOLDER>;'||,
            'ICONPOS=25,75;'||,
            'OPEN=ICON;'
    end
  else
    do
      setup='OBJECTID=<OBERON_FOLDER>;'||,
            'ICONFILE='tempDest||iconFile';'||,
            'ICONPOS=25,75;'||,
            'OPEN=ICON;'
    end
  option='F'
  call BldObj

  do i = 1 to SourceFile.0
    if SourceFile.i.Program = 1 then
      do
        classname='WPProgram'
        title='PmQWK! 1.00-8'
        location='<OBERON_FOLDER>'
        setup='OBJECTID=<OBERON_PMQWK>;'||,
              'EXENAME='tempDest||SourceFile.i';'||,
              'STARTUPDIR='TargetPath';'||,
              'PROGTYPE=PM;'
        option='U'
        call BldObj
        leave
      end
  end

  do i = 1 to SourceFile.0
    if SourceFile.i.Shadow = 1 then
      do
        classname='WPShadow'
        title=SourceFile.i
        location='<OBERON_FOLDER>'
        setup='SHADOWID='||tempDest||SourceFile.i';'
        option='U'
        call BldObj
      end
  end

  if hadError = 1 then
    do
      call charout ,'Press any key...'
      call SysGetKey 'NOECHO'
    end
  return




BldObj:
  call charout ,'    Building:' title '... '
  r = SysCreateObject(classname, title, location, setup, option)
  if r = 1 then
    say 'Object created!'
  else
    do
      if r = 0 then
        say 'Not created!  Already exists.'
      else
        do
          say 'Not created!  Return code='r
          hadError = 1
        end
    end
  return


/* ----------------------------------------------------------------------- */

PutCopyright:
  call SysCls
  say CopyRLine0
  say CopyRLine1
  say CopyRLine2
  say ''
  say ''
  return

/* ----------------------------------------------------------------------- */

GetBootDrive:
  gbdRC = -1
  do while gbdRC = -1
    call PutCopyright
    say '    Please enter the drive letter for your boot drive.'
    call charout ,'    Press the letter for the drive or ESC to quit: '
    do forever
      k = translate(SysGetKey('NOECHO'))
      if k = D2C(27) then
        do
          gbdRC = 0
          leave
        end
      else
        do
          if k = D2C(13) then k = 'C'
          k = k||':'
          if pos(k, AvailDrives) = 0 then
            call beep 1760, 50
          else
            do
              call SysFileTree k||'\Config.Sys', 'foo', 'F'
              if foo.0 = 0 then
                do
                  say ''
                  say 'Cannot locate file "'k'\Config.Sys"'
                  call charout ,'Press any key...'
                  call SysGetKey 'NOECHO'
                  leave
                end
              else
                do
                  BootDrive = k
                  call GetLIBPath
                  gbdRC = 1
                  leave
                end
            end
        end
    end
  end
  return gbdRC

/* ----------------------------------------------------------------------- */

GetLIBPATH:
  srchRC = SysFileSearch('LIBPATH=', BootDrive||'\Config.Sys', 'lpath')
  if srchRC = 0 then
    do i = 1 to lpath.0
      if translate(substr(lpath.i, 1, 8)) = 'LIBPATH=' then
        do
          j = 0
          temp = substr(lpath.i, 9)
          do while length(temp) > 0
            parse var temp tpath ';' temp
            j = j + 1
            if tpath = '.' then
              do
                LIBSubPath.j = '*Program Directory*'
                DLLPath = LIBSubPath.j
              end
            else
              LIBSubPath.j = tpath
          end
          LIBSubPath.0 = j
          if DLLPath = '' then DLLPath = LIBSubPath.1
        end
    end
  return


AskLIBPath:
  if LIBSubPath.0 > 0 then
    do
      j = 0
      i = 0
      lpSelect = 0
      topval   = 1
      call PutCopyright
      say "    Please select a path for PMQWK's associated DLL file to be placed"
      say '    from the following list of paths in your LIBPATH:'
      say ''
      do forever
        i = i + 1
        j = j + 1
        say '    ' D2C(j+64)':' LIBSubPath.i
        if j = 10 | i = LIBSubPath.0 then
          do
            topkey = D2C(j+C2D('A')-1)
            say ''
            call charout ,' -- A-'topkey'=Select, R=restart, Q (or ESC)=exit, any other key=more --'
            k = C2D(translate(SysGetKey('NOECHO')))
            if k = 27 then k = C2D('Q')
            if k = C2D('Q') then leave
            if k = C2D('R') then
              do
                i = 0
                j = 0
                topval = 1
              end
            else
              do
                topkey = j+C2D('A')
                if k > C2D('@') & k < topkey then
                  do
                    lpSelect = topval + (k - C2D('A'))
                    DLLPath = LIBSubPath.lpSelect
                    leave
                  end
                j = 0
                if i = LIBSubPath.0 then i = 0
                topval = i + 1
                call PutCopyright
                say "    Please select a path for PMQWK's associated DLL file to be placed"
                say '    from the following list of paths in your LIBPATH:'
                say ''
              end
          end
      end
    end
  return


/* ----------------------------------------------------------------------- */

AskPath:
parse arg apType
  cwd = directory()
  do forever
    call SysCls
    say 'Select' apType 'Path'
    say ''
    say 'Current setting is:'
    if apType = 'SOURCE' then
      say '    ' SourcePath
    else
      say '    ' TargetPath
    say ''
    call charout ,'Enter new setting (press ENTER to leave unchanged): '
    np = linein('stdin')
    np = strip(np, 'B')
    if length(np) = 0 then
      leave
    else
      do
        if substr(np, length(np), 1) = '\' then
          do
            if (np = '\') | (length(np) = 3 & substr(np, 2, 1) = ':') then
              nop
            else
              np = substr(np, 1, length(np) - 1)
          end
        if np = '..' & length(cwd) > 3 then
          do
            temp = reverse(cwd)
            temp = substr(temp, pos('\', temp)+1)
            np = reverse(temp)
          end
        if np = '.' then np = cwd
        if substr(np, 2, 1) \= ':' then
          do
            if substr(np, 1, 1) = '\' then
              np = substr(cwd, 1, 2) || np
            else
              np = cwd || '\' || np
          end
        if pos(translate(substr(np, 1, 2)), AvailDrives) = 0 then
          do
            call beep 1760, 50
            say ''
            say 'Invalid drive letter "'substr(np, 1, 2)'"'
            call charout ,'Press any key...'
            call SysGetKey 'NOECHO'
          end
        else
          do
            testnp = directory(np)
            if translate(testnp) = translate(np) then
              do
                call directory cwd
                if apType = 'SOURCE' then
                  SourcePath = testnp
                else
                  TargetPath = testnp
                leave
              end
            else
              do
                call beep 1760, 50
                say ''
                say 'Directory path "'np'" does not exist!'
                if apType = 'SOURCE' then
                  do
                    call charout ,'Press any key...'
                    call SysGetKey 'NOECHO'
                  end
                else
                  do
                    call GetYN 'Create it?'
                    if result = '1' then
                      do
                        r = SysMkDir(np)
                        if r = 0 then
                          do
                            testnp = directory(np)
                            call directory cwd
                            if apType = 'SOURCE' then
                              SourcePath = testnp
                            else
                              TargetPath = testnp
                            leave
                          end
                        else
                          do
                            say 'Cannot create directory "'np'"'
                            call charout, 'Press any key...'
                            call SysGetKey 'NOECHO'
                          end
                      end
                  end
              end
          end
      end
  end
  return


/* ----------------------------------------------------------------------- */

GetYN: procedure
parse arg gynPrompt
  call charout ,gynPrompt '(y/N) '
  do forever
    k = translate(SysGetKey('NOECHO'))
    if k = D2C(27) | k = D2C(13) then k = 'N'
    select
      when k = 'Y' then
        do
          ynRC = 1
          leave
        end
      when k = 'N' then
        do
          ynRC = 0
          leave
        end
      otherwise
        call beep 1760, 50
    end
  end
  return ynRC

/* ----------------------------------------------------------------------- */

