EXTPROC CEnvi
//********************************************************
//*** PMWPtch.cmd - Patch PMWIN.DLL for bigger queues. ***
//********************************************************

#define MIN_QUEUE_SIZE 1
#define MAX_QUEUE_SIZE 255

Instructions()
{
   printf("PMWPtch - Patch PMWIN.DLL for always big message queues.\n");
   printf("USAGE: PMWPtch <PmWin.dll_spec> <queue_size>\n");
   printf("WHERE: PmWin.dll_spec - location of PMWIN.DLL file\n");
   printf("       queue_size - size of PM queue, from %d to %d\n",
          MIN_QUEUE_SIZE,MAX_QUEUE_SIZE);
   printf("EXAMPLE: PMWPtch C:\\OS2\\DLL\\PMWIN.DLL 222\n");
   exit(1);
}

OldCode32 = '\x53\x56\x57\x55\x8B\xC4\x16\x50\x8C\xD2\x83\xE2\x03\x80\xCA\x04'
            '\xFF\x75\x08\x8B\x45\x0C\x0F\xBF\xC8\x3B\xC1\x0F\x85\x25\x00\x00'
            '\x00\x66\x50\x66\x68\x01\x00\x8B\xC4\xC1\xC8\x10\xC1\xE0\x03\x0A'
NewCode32 = '\x53\x56\x57\x55\x8B\xC4\x16\x50\x8C\xD2\x83\xE2\x03\x80\xCA\x04'
            '\xFF\x75\x08\x31\xC0\xB0\xDE\x89\xC1\x39\xC8\x0F\x85\x25\x00\x00'
            '\x00\x66\x50\x66\x68\x01\x00\x8B\xC4\xC1\xC8\x10\xC1\xE0\x03\x0A'
CodeLength32 = GetArraySpan(OldCode32) + 1;
//OldCode16 = '\x8E\xD8\xFF\x76\x0A\xFF\x76\x08\xFF\x76\x06\x6A\x00\x0E\xE8\x06'
//            '\x00\x1F\xC9\xCA\x06\x00\x90\xC8\x0E\x00\x00\x57\x56\x1E\xB8'
//NewCode16 = '\x8E\xD8\x6A\x00\x68\xDD\x00\x90\xFF\x76\x06\x6A\x00\x0E\xE8\x06'
//            '\x00\x1F\xC9\xCA\x06\x00\x90\xC8\x0E\x00\x00\x57\x56\x1E\xB8'
//CodeLength16 = GetArraySpan(OldCode16) + 1;


PatchIt(FileName)
{
   if ( !(fp = fopen(FileName,"rb")) ) {
      printf("Unable to open source file \"%s\".\nCannot patch!\n",FileName);
      return;
   }
   BufSize = fread(buf,1000000,fp);
   fclose(fp);
   puts("find 32-bit old code");
   if ( BufSize < 10  ||  1000000 <= BufSize
     || !(CodeOffset32 = FindCodeOffset(buf,BufSize,OldCode32,CodeLength32)) ) {
      printf("Could not find old 32-bit code in \"%s\"\nCannot Patch!\n",FileName);
      return;
   }
//   puts("find 16-bit old code");
//   if ( !(CodeOffset16 = FindCodeOffset(buf,BufSize,OldCode16,CodeLength16)) ) {
//      printf("Could not find old 16-bit code in \"%s\"\nCannot Patch!\n",FileName);
//      return;
//   }
   // replace old code with new
   memcpy(buf+CodeOffset32,NewCode32,CodeLength32);
//   memcpy(buf+CodeOffset16,NewCode16,CodeLength16);

   // give last chance
   printf("About to ovewrite old version of %s. You should have a\n",FileName);
   printf("backup.  Are you sure you want to overwrite? (Y/N) ");
   while( kbhit() ) getch();
   do {
      answer = toupper(getch());
   } while( answer != 'Y' && answer != 'N' );
   printf("%c\n",answer);

   if ( 'Y' == answer ) {
      fp = fopen(FileName,"wb");
      if ( !fp  ||  (BufSize != fwrite(buf,BufSize,fp)) ) {
         printf("Cannot open \"%s\" for writing.\nCannot patch.\n",FileName);
         return;
      }
      fclose(fp);
   }
}

FindCodeOffset(buf,bufsize,code,codelen)
{
   FirstByte = code[0];
   for ( next = buf, len = bufsize; 0 < len; next++, len-- ) {
      if ( !(b = memchr(next,FirstByte,len)) )
         return 0;
      if ( !memcmp(b,code,codelen) ) {
         printf("\nFOUND!!! at %08X\n",b-buf);
         return b - buf;
      }
      len -= b - next;
      next = b;
   }
   return 0;
}

main(argc,argv)
{
   if ( argc != 3
     || (QueueSize = atoi(argv[2])) < MIN_QUEUE_SIZE
     || MAX_QUEUE_SIZE < QueueSize )
      Instructions();

   NewCode32[0x16] = QueueSize;
   PatchIt(argv[1]);
}

