EXTPROC CEnvi

if ( !DosLoadModule("PMWIN",ModuleHandle) ) {
   printf("Cannot load PMWIN\n");
} else {
   printf("PMWIN module handle = %d\n",ModuleHandle);
   #define ORD_WIN32CREATEMSGQUEUE 716
   #define ORD_WIN16CREATEMSGQUEUE 58

   if ( !DosQueryProcAddr(ModuleHandle,ORD_WIN32CREATEMSGQUEUE,NULL,ProcAddress) ) {
      printf("Cannot find address for create msg queue\n");
   } else {
      printf("Address of CreateMsgQueue = %08X\n",ProcAddress);
      // show the code there
      for ( i = 0; i < 10; i++ ) {
         for ( j = 0; j < 16; j++ ) {
            printf(" %02X",peek(ProcAddress+(i*16)+j));
         }
         puts("");
      }
   }
   DosFreeModule(ModuleHandle);
}


DosLoadModule(pModuleName,pRetModuleHandle)
{
   #define ORD_DOS32LOADMODULE  318
   lLoadError[100] = '\0';
   lRc = DynamicLink("DOSCALLS",ORD_DOS32LOADMODULE,BIT32,CDECL,
                     lLoadError,100,pModuleName,lModHandle);
   pRetModuleHandle = lModHandle;
   if ( lRc ) {
      printf("lRc = %d\n",lRc);
      printf("Error message = \"%s\"\n",lLoadError);
   }
   return ( 0 == lRc );
}

DosFreeModule(pModuleHandle)
{
   #define ORD_DOS32FREEMODULE  322
   DynamicLink("DOSCALLS",ORD_DOS32FREEMODULE,BIT32,CDECL,pModuleHandle);
}

DosQueryProcAddr(pModuleHandle,pOrdinal,pProcName,pRetProcAddress)
{
   #define ORD_DOS32QUERYPROCADDR  321
   lRc = DynamicLink("DOSCALLS",ORD_DOS32QUERYPROCADDR,BIT32,CDECL,
                     pModuleHandle,pOrdinal,pProcName,lRetProcAddress);
   pRetProcAddress = lRetProcAddress;
   return ( 0 == lRc );
}

