#! sh
# $Id: pmm2elm.sh,v 1.1 1997/02/16 00:59:21 stefand Exp $
# pmm2sh.sh: Create ELM or YARN mail folders from  PMMail mail folders.
#
# This converts the mail in PMMail (1.x) folders into a format the
# OS/2 port of elm 2.3 by Kai Uwe Rommel can handle: Messages 
# are separated by 20 ^A (Ctrl-A) characters.
# (In vi, e.g., enter those by hitting Ctrl-V -Ctrl-A).
# Actually, it doesn't _convert_ the PMMail folder, as it doesn't
# change the PMMail folder, it just creates ELM folders.
# If you change the 20 ^A to a full stop, and ^L^@^@ you can also
# use it to change the stuff to MAILBOX folders YARN understands.
#
# This script relies on the following to be installed on your
# computer: sh.exe (tested with sh.exe from ksh527rt.zip), and
# cat.exe and mv.exe. They require the emx runtime library 
# (emxrt.zip)and all that can be found on ususal OS/2 ftp sites.
# Put this script somewhere in your path.
#
# To create a mail folder, say from the folder 'John', open a
# command line window, start sh.exe, and go to the directory where 
# that folder lives, e.g.:
#
#  sh.exe
#  cd  E:/bin/os2/pmmail/pmmail/stefan0.act/Mail0.FLD/John0.FLD
# 
# There you will find a lot of files with the extension *.msg, and
# these are your messages. Simply type:
#
#  pmm2elm *.msg > jdoe
#
# and you will have an ELM mail folder of the name 'jdoe'.
# Now you can move that one into your $MAIL directory, and elm
# will find it:
#
#  mv -i jdoe f:/usr/sad/mail
#
# If the folder 'John' exists already it will complain, then you 
# can simply append the stuff from PMMail to the existing ELM folder:
#
#  cat jdoe >> f:/usr/sad/mail/jdoe
#
# and elm is happy with that, too. 
# If you have a large directory structure you will want to make that
# more automatic, but I don't, and it is a bit hard to guess from
# PMMails 8.3 folder names what the ELM folder name is that you want.
# In the above example the PMMail folder for John actually becomes the
# ELM folder jdoe, which is what his email name might be (say:
# John is jdoe@bla.blub).
# Also, one can probably do all that neatly with REXX, but people who
# use elm are likely to have all the GNU stuff (sh, mv, cat, ..)
# anyway.
#
# As always: Back up your ELM or YARN folders before you play with this,
# and it comes without any explicit or implied warranty, you use it at
# your own risk.
#          
# Stefan A. Deutscher, 15-Feb-1997  
# (sad@utk.edu, stefand@ibm.net, stefand@elphy.irz.hu-berlin.de)
#



if [ $# -eq 0 -o "$1" = "-h" ]; then
 echo "Usage: [sh] pmm2elm.sh pattern > output_folder"
 echo
 echo "Example:   sh pmm2elm.sh *.msg  > peter"
 echo "           pmm2elm    *.msg  > jdoe"
fi

while [  $# -gt 0 -a -f "$1"  ] 
do
 echo 
 cat $1
 shift
done

# $Log: pmm2elm.sh,v $
# Revision 1.1  1997/02/16 00:59:21  stefand
# Initial revision
#
# end of pmm2elm.sh
