/*
PMLPP - A POP3 mail "peeker" for OS/2<tm>.
Copyright (C) 1997 James R. Louvau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You may contact the author of PMLPP at:

E-mail     : jim@vwm.com
Snail-mail : Jim Louvau
             3437 335th St.
             West Des Moines, IA 50266
*/

#include "pmlpp.h"

static PSZ
GetProfileName( )
/***************/
{
   static CHAR szPath[ CCHMAXPATH ] = "";
   PTIB        ptib;
   PPIB        ppib;

   if ( ! *szPath )
   {
      char * p;

      DosGetInfoBlocks( &ptib, &ppib );
      DosQueryModuleName(( HMODULE ) ppib->pib_hmte, sizeof( szPath ), szPath );

      p = strrchr( szPath, '.' );
      if ( p )
      {
         strcpy( p, ".INI" );
      }
      else
      {
         strcat( szPath, ".INI" );
      }
   }

   return ( szPath );
}

BOOL
LoadProfile( HWND    hwnd,
             PCONFIG pprf )
/*************************/
{
   HINI hini = PrfOpenProfile( WinQueryAnchorBlock( hwnd ), GetProfileName( ));

   if ( hini != NULLHANDLE )
   {
      ULONG cbProfile = CFGSAVESIZE;
      BOOL  bGotIt    = PrfQueryProfileData( hini, "PMLPP", "Config", pprf, &cbProfile );

      PrfCloseProfile( hini );

      if ( bGotIt )
      {
         return ( TRUE );
      }
   }

   return ( FALSE );
}

void
SaveProfile( HWND    hwnd,
             PCONFIG pprf )
/*************************/
{
   HINI hini = PrfOpenProfile( WinQueryAnchorBlock( hwnd ), GetProfileName( ));
   if ( hini != NULLHANDLE )
   {
      CHAR szPassword[ 32 ];

      if ( ! pprf->bSavePW )
      {
         strcpy( szPassword, pprf->szPassword );
         memset( pprf->szPassword, 0, sizeof( pprf->szPassword ));
      }

      PrfWriteProfileData( hini, "PMLPP", "Config", pprf, CFGSAVESIZE );
      PrfCloseProfile( hini );

      if ( ! pprf->bSavePW )
      {
         strcpy( pprf->szPassword, szPassword );
      }
   }
}

MRESULT EXPENTRY
ConfigDlgProc( HWND   hwnd,
               ULONG  msg,
               MPARAM mp1, 
               MPARAM mp2  )
/**************************/
{
   static PCONFIG pcfg = NULL;

   switch ( msg )
   {
      case WM_INITDLG:
         {
            pcfg = ( PCONFIG ) PVOIDFROMMP( mp2 );

            WinSetDlgItemText( hwnd, EF_SERVER, pcfg->szServer );
            WinSetDlgItemText( hwnd, EF_USER, pcfg->szUser );
            WinSetDlgItemText( hwnd, EF_PASSWORD, pcfg->szPassword );
            WinSetDlgItemText( hwnd, EF_PROGRAM, pcfg->szProgram );
            WinSetDlgItemText( hwnd, EF_OPTIONS, pcfg->szOptions );
            WinSetDlgItemText( hwnd, EF_DIRECTORY, pcfg->szDirectory );

            WinSetDlgItemShort( hwnd, EF_PORT, pcfg->usPort, FALSE );

            if (( pcfg->ulInterval < 1L ) || ( pcfg->ulInterval > 86400L ))
            {
               pcfg->ulInterval = 60L;
            }

            WinSendDlgItemMsg( hwnd, SPB_INTERVAL, SPBM_SETLIMITS, MPFROMLONG( 86400L ),
                               MPFROMLONG( 1L ));

            WinSendDlgItemMsg( hwnd, SPB_INTERVAL, SPBM_SETCURRENTVALUE,
                               MPFROMLONG( pcfg->ulInterval ), MPVOID );

            WinCheckButton( hwnd, CB_PLAYSOUND, ( pcfg->bSound ) ? 1 : 0 );

            WinCheckButton( hwnd, CB_FORCEIP, ( pcfg->bForceIP ) ? 1 : 0 );

            WinCheckButton( hwnd, CB_SAVEPASSWORD, ( pcfg->bSavePW ) ? 1 : 0 );
         }
         return ( MRFALSE );

      case WM_COMMAND:
         {
            switch ( SHORT1FROMMP( mp1 ))
            {
               case DID_OK:
                  {
                     StopPolling( pcfg );

                     WinQueryDlgItemText( hwnd, EF_SERVER, sizeof( pcfg->szServer ),
                                          pcfg->szServer );
                     WinQueryDlgItemText( hwnd, EF_USER, sizeof( pcfg->szUser ),
                                          pcfg->szUser );
                     WinQueryDlgItemText( hwnd, EF_PASSWORD, sizeof( pcfg->szPassword ),
                                          pcfg->szPassword );
                     WinQueryDlgItemText( hwnd, EF_PROGRAM, sizeof( pcfg->szProgram ),
                                          pcfg->szProgram );
                     WinQueryDlgItemText( hwnd, EF_OPTIONS, sizeof( pcfg->szOptions ),
                                          pcfg->szOptions );
                     WinQueryDlgItemText( hwnd, EF_DIRECTORY, sizeof( pcfg->szDirectory ),
                                          pcfg->szDirectory );

                     WinQueryDlgItemShort( hwnd, EF_PORT, ( PSHORT ) &( pcfg->usPort ),
                                           FALSE );

                     WinSendDlgItemMsg( hwnd, SPB_INTERVAL, SPBM_QUERYVALUE, 
                                        MPFROMP( &( pcfg->ulInterval )), 
                                        MPFROM2SHORT( 0, SPBQ_UPDATEIFVALID ));

                     pcfg->bSound = ( WinQueryButtonCheckstate( hwnd, CB_PLAYSOUND ) ? TRUE
                                      : FALSE );

                     pcfg->bForceIP = ( WinQueryButtonCheckstate( hwnd, CB_FORCEIP ) ? TRUE
                                        : FALSE );

                     pcfg->bSavePW = ( WinQueryButtonCheckstate( hwnd, CB_SAVEPASSWORD ) ? TRUE
                                       : FALSE );

                     StartPolling( pcfg );

                     WinDismissDlg( hwnd, 1 );
                  }
                  break;

               case DID_CANCEL:
                  {
                     WinDismissDlg( hwnd, 0 );
                  }
                  break;
            }
         }
         return ( MRZERO );
   }

   return ( WinDefDlgProc( hwnd, msg, mp1, mp2 ));
}

void
Configure( HWND    hwnd,
           PCONFIG pprf )
/***********************/
{
   if ( WinDlgBox( HWND_DESKTOP, hwnd, ConfigDlgProc, NULLHANDLE, DLG_CONFIGURE, pprf ))
   {
      SaveProfile( hwnd, pprf );
   }
}
