/**************************************************************************
 *  File name  :  help.h
 *
 *  Description:  This header file contains the identifiers for the
 *                constants used by the help manager.
 *
 *  Concepts   :  help manager
 *
 *  API's      :  [none]
 *
 *  Required
 *    Files    :  [none]
 *
 *  Copyright (C) 1991 IBM Corporation
 *
 *      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
 *      sample code created by IBM Corporation. This sample code is not
 *      part of any standard or IBM product and is provided to you solely
 *      for  the purpose of assisting you in the development of your
 *      applications.  The code is provided "AS IS", without
 *      warranty of any kind.  IBM shall not be liable for any damages
 *      arising out of your use of the sample code, even if they have been
 *      advised of the possibility of such damages.                                                    *
 *************************************************************************/

/*
 *  Help table and subtables
 */
#define TEMPLATE_HELP_TABLE                 1000
#define SUBTABLE_MAIN                       2000
#define SUBTABLE_PRODUCTINFODLG             3000


/*
 *  Main window help panels
 */
#define PANEL_MAIN                          2100
#define PANEL_PRODUCTINFODLG                3100


#define PANEL_FILE                          2210
#define PANEL_FILENEW                       2220
#define PANEL_FILEOPEN                      2230
#define PANEL_FILESAVE                      2240
#define PANEL_FILESAVEAS                    2250
#define PANEL_FILELIST                      2260
#define PANEL_FILEEXIT                      2270
#define PANEL_EDIT                          2310
#define PANEL_EDITUNDO                      2320
#define PANEL_EDITREMOVE                    2330
#define PANEL_EDITMOVE                      2340
#define PANEL_EDITSTOP                      2350
#define PANEL_EDITNOCOMPUTER                2360
#define PANEL_EDITSETUP                     2370
#define PANEL_OPTIONS                          2410
#define PANEL_OPTIONS_TONE                     2560
#define PANEL_OPTIONS_COOR                     2570
#define PANEL_OPTIONS_STATS                    2420
#define PANEL_OPTIONS_SPEED                    2430
#define PANEL_OPTIONS_HASH                     2440
#define PANEL_OPTIONS_BOTH                     2450
#define PANEL_OPTIONS_BOOK                     2460
#define PANEL_OPTIONS_AWINDOW                  2470
#define PANEL_OPTIONS_BWINDOW                  2480
#define PANEL_OPTIONS_CONTEMP                  2490
#define PANEL_SKILL                         2510
#define PANEL_SKILL_TIME                    2520
#define PANEL_SKILL_RANDOM                  2530
#define PANEL_SKILL_EASY                    2540
#define PANEL_SKILL_DEPTH                   2550
#define PANEL_SIDE                            2610
#define PANEL_SIDE_REVERSE                    2620
#define PANEL_SIDE_SWITCH                     2630
#define PANEL_SIDE_WHITE                      2640
#define PANEL_SIDE_BLACK                      2650
#define PANEL_SIDE_REFRESH                    2660
#define PANEL_COLOR                         2710
#define PANEL_HELP                          2910
#define PANEL_HELPINDEX                     2920
#define PANEL_HELPGENERAL                   2930
#define PANEL_HELPUSINGHELP                 2940
#define PANEL_HELPKEYS                      2950
#define PANEL_HELPTUTORIAL                  2960
#define PANEL_HELPPRODUCTINFO               2970

/*
 *  Enter text dialog help subtable
 */
#define PANEL_PRODUCTINFO_OK                3110

#define HID_FS_OPEN_DLG_HELP_PANEL          4163
#define HID_FS_SAVE_DLG_HELP_PANEL          4210
#define MESSAGELEN          50    /* maximum length for messages */
#define MSGBOXID        1001
/***************************  End of help.h  ****************************/
