@ -----------------------------------------------------------------
@ Sample of keywords file for the keywords highlighting feature of EPM
@ -----------------------------------------------------------------
@  This file is used by EPM to figure out which keywords to highlight
@  It contains all the ANSI C keywords, plus all the #defines,
@  typedefs and function prototypes of the 2.1 toolkit.
@  Since it is huge, it takes a long time to load (8 sec on my 486-33 machine).
@  Update:  The size has been cut in half by converting spaces to tabs.
@           If you don't use a monospaced font, things will appear misaligned.
@           The Extended Attribute EPM.TABS was used to ensure that tab stops
@           are set at every 8 columns.
@  EPM looks for this file along the EPMPATH.
@  The loading time can be reduced by removing some keywords from the list.
@  The format to follow is described below.
@
@ ------------------------------------------------------------------
@ Format of the file
@ ------------------------------------------------------------------
@ The first character of the first line is the "special" character.
@ If it appears at the beginning of a line after, it is
@ either followed by a space and marks then a comment, or
@ by any other character and is then a topic name.
@ Currently the only topics are :
@  DELIM
@     "start string" "end string" "bg color" "fg color" "escape character" "column"
@     What's between the 'start' and 'end' delimiters is set to the 'color' color.
@     If no 'end' is specified, the whole line after any 'start' string is colored.
@     If an 'Escape' character appears just before a 'end' string, it won't be considered an end delimiter.
@     If an 'Escape' character appears just before a 'start' string, it won't be considered a start delimiter.
@     An 'Escape' character can be escaped by another 'Escape' character
@     If the column field is present, a start delimiter will be valid only if it starts on this column
@     If the end delimiter is not on the same line as the start, no color changes will be done.
@     The special character can be used as a placeholder, eg if you want a column but no escape character
@  DELIMI
@     Like DELIM, but case insensitive.
@  KEYWORDS
@     "name" "fg color" "bg color"
@     They must include only characters specified in the CHARSET section, case sensitive.
@  INSENSITIVE
@     "name" "fg color" "bg color"
@     Same as KEYWORDS except case insensitive.
@  CHARSET
@     "string including all the characters"
@     List of characters allowed in the names of the KEYWORDS and INSENSITIVE sections.
@  SPECIAL
@     "name" "fg color" "bg color"
@     Any occurrence of these strings will be changed to the specified color.
@     They can include any character.
@  SPECIALI
@     Like SPECIAL, but case insensitive.
@  BREAKCHAR
@     "character" "fg color" "bg color"
@     This character is considered as a space when keywords in @KEYWORDS
@     or @INSENSITIVE are looked for.  If colors are specified, a break
@     at the beginning of a keyword will have its own color, else it will
@     have the same color as the keyword.
@  ENDCHAR
@     "character" "fg color" "bg color"@
@     The character after this one is considered as a space when keywords
@     in @KEYWORDS or @INSENSITIVE are looked for.  If colors are
@     specified, an end char at the end of a keyword will have its own
@     color, else it will have the same color as the keyword.
@
@     An end character at the end of a keyword in @KEYWORDS or
@     @INSENSITIVE is hilited with its own color.
@
@  The background and foreground colors are values between 0 and 15
@  (see the EPM doc). If a value of -1 is given then the default
@  foreground or background color is used.
@
@ -----------------------------------------------------------------
@ Actual description of the keywords
@ -----------------------------------------------------------------
@
@DELIM
@
@ Start   Color Color  End     Escape
@ string  bg    fg     string  character
  /*       11     9   */
  //       11     9
  "        -1     10   "       \
  '        -1     10   '       \
@
@SPECIAL
@
{  -1  11
}  -1  11
;  -1  11
,  -1  11
?  -1  11
:  -1  11
<  -1  11
>  -1  11
=  -1  11
(  -1  11
)  -1  11
[  -1  11
]  -1  11
+  -1  11
*  -1  11
-  -1  11
/  -1  11
@
@CHARSET
@
abcdefghijklmnopqrstuvwxyz_#ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789
@
@KEYWORDS
@
@ -------------------- C pre-processor keywords ---------------------------
#define 	-1	12
#elif		-1	12
#else		-1	12
#endif		-1	12
#include	-1	12
#if		-1	12
#ifdef		-1	12
#ifndef 	-1	12
#pragma 	-1	12
#undef		-1	12
@ -------------------- C language constructs ---------------------------
auto		-1	15
break		-1	15
case		-1	15
char		-1	15
const		-1	15
continue	-1	15
default 	-1	15
do		-1	15
double		-1	15
enum		-1	15
else		-1	15
extern		-1	15
float		-1	15
for		-1	15
goto		-1	15
if		-1	15
int		-1	15
long		-1	15
main		-1	15
register	-1	15
return		-1	15
short		-1	15
signed		-1	15
sizeof		-1	15
static		-1	15
struct		-1	15
switch		-1	15
typedef 	-1	15
union		-1	15
unsigned	-1	15
void		-1	15
volatile	-1	15
while		-1	15
freopen 	-1	15
fflush		-1	15
fopen		-1	15
fclose		-1	15
remove		-1	15
rename		-1	15
tmpfile 	-1	15
tmpnam		-1	15
setvbuf 	-1	15
setbuf		-1	15
fprintf 	-1	15
printf		-1	15
sprintf 	-1	15
vprintf 	-1	15
vfprintf	-1	15
vsprintf	-1	15
fscanf		-1	15
scanf		-1	15
sscanf		-1	15
fgetc		-1	15
fgets		-1	15
fputc		-1	15
fputs		-1	15
getc		-1	15
getchar 	-1	15
gets		-1	15
putc		-1	15
putchar 	-1	15
puts		-1	15
ungetc		-1	15
fread		-1	15
FILE		-1	15
stdin		-1	15
stderr		-1	15
stdout		-1	15
size_t		-1	15
fread		-1	15
fwrite		-1	15
fseek		-1	15
ftell		-1	15
rewind		-1	15
fgetpos 	-1	15
fsetpos 	-1	15
SEEK_SET	-1	15
SEEK_CUR	-1	15
SEEK_END	-1	15
fpos_t		-1	15
clearerr	-1	15
feof		-1	15
ferror		-1	15
perror		-1	15
isalnum 	-1	15
isalpha 	-1	15
iscntrl 	-1	15
isdigit 	-1	15
isgraph 	-1	15
islower 	-1	15
isprint 	-1	15
ispunct 	-1	15
isspace 	-1	15
isupper 	-1	15
isxdigit	-1	15
tolower 	-1	15
toupper 	-1	15
strcpy		-1	15
strncpy 	-1	15
strcat		-1	15
strncat 	-1	15
strcmp		-1	15
strncmp 	-1	15
strchr		-1	15
strrchr 	-1	15
strspn		-1	15
strcspn 	-1	15
strpbrk 	-1	15
strstr		-1	15
strlen		-1	15
strerror	-1	15
strtok		-1	15
memcpy		-1	15
memmove 	-1	15
memcmp		-1	15
memchr		-1	15
memset		-1	15
sin		-1	15
cos		-1	15
tan		-1	15
asin		-1	15
acos		-1	15
atan		-1	15
atan2		-1	15
sinh		-1	15
cosh		-1	15
tanh		-1	15
exp		-1	15
log		-1	15
log10		-1	15
pow		-1	15
sqrt		-1	15
ceil		-1	15
floor		-1	15
fabs		-1	15
ldexp		-1	15
frexp		-1	15
modf		-1	15
fmod		-1	15
atof		-1	15
atoi		-1	15
atol		-1	15
strtod		-1	15
strtol		-1	15
strtoul 	-1	15
rand		-1	15
srand		-1	15
calloc		-1	15
malloc		-1	15
realloc 	-1	15
free		-1	15
abort		-1	15
exit		-1	15
atexit		-1	15
system		-1	15
getenv		-1	15
bsearch 	-1	15
qsort		-1	15
abs		-1	15
labs		-1	15
div		-1	15
div_t		-1	15
ldiv		-1	15
ldiv_t		-1	15
assert		-1	15
va_list 	-1	15
va_start	-1	15
va_arg		-1	15
va_end		-1	15
setjmp		-1	15
jmp_buf 	-1	15
longjmp 	-1	15
signal		-1	15
SIGABRT 	-1	15
SIGFPE		-1	15
SIGILL		-1	15
SIGINT		-1	15
SIGSEV		-1	15
SIGTERM 	-1	15
SIG_ERR 	-1	15
raise		-1	15
clock_t 	-1	15
clock		-1	15
time_t		-1	15
time		-1	15
difftime	-1	15
mktime		-1	15
tm		-1	15
asctime 	-1	15
ctime		-1	15
gmtime		-1	15
localtime	-1	15
strftime	-1	15
CHAR_BIT	-1	15
CHAR_MAX	-1	15
UCHAR_MAX	-1	15
SCHAR_MAX	-1	15
CHAR_MIN	-1	15
SCHAR_MIN	-1	15
INT_MAX 	-1	15
INT_MIN 	-1	15
LONG_MAX	-1	15
LONG_MIN	-1	15
SCHAR_MAX	-1	15
SCHAR_MIN	-1	15
SHRT_MAX	-1	15
SHRT_MIN	-1	15
UCHAR_MAX	-1	15
UINT_MAX	-1	15
ULONG_MAX	-1	15
USHRT_MAX	-1	15
FLT_RADIX	-1	15
FLT_ROUNDS	-1	15
FLT_DIG 	-1	15
FLT_EPSILON	-1	15
FLT_MANT_DIG	-1	15
FLT_MAX 	-1	15
FLT_MAX_EXP	-1	15
FLT_MIN 	-1	15
FLT_MIN_EXP	-1	15
DBL_DIG 	-1	15
DBL_EPSILON	-1	15
DBL_MANT_DIG	-1	15
DBL_MAX 	-1	15
DBL_MAX_EXP	-1	15
DBL_MIN 	-1	15
DBL_MIN_EXP	-1	15
@	-------------------- C++ language constructs -------------------------
catch		-1	15
class		-1	15
delete		-1	15
friend		-1	15
inline		-1	15
new		-1	15
operator	-1	15
private		-1	15
protected	-1	15
public		-1	15
template	-1	15
this		-1	15
throw		-1	15
try		-1	15
virtual		-1	15
@ -------------------- OS/2 Toolkit definitions	---------------------------
__BDCALLS__						-1	5
BDHKFLAG_PUSH						-1	5
BDHKFLAG_END_PUSH					-1	5
BDHKFLAG_AUTO_PUSH					-1	5
BDHKFLAG_FIELD_REV					-1	5
BDHKFLAG_SCREEN_REV					-1	5
BDHKFLAG_BIDI_POPUP					-1	5
BDHKFLAG_AUTOMATIC					-1	5
BDHKFLAG_INITIAL					-1	5
BDHKFLAG_MIDDLE 					-1	5
BDHKFLAG_FINAL						-1	5
BDHKFLAG_ISOLATED					-1	5
BDFLAG_AUTOPUSH_RTL					-1	5
BDFLAG_AUTOPUSH_LTR					-1	5
BDFLAG_PUSHLEVEL					-1	5
BDFLAG_LAYER						-1	5
BDFLAG_FIELD_REV					-1	5
BDCSD_AUTOMATIC 					-1	5
BDCSD_PASSTHRU						-1	5
BDCSD_BASE						-1	5
BDCSD_INITIAL						-1	5
BDCSD_MIDDLE						-1	5
BDCSD_FINAL						-1	5
BDCSD_ISOLATED						-1	5
BDNUM_ARABIC						-1	5
BDNUM_PASSTHRU						-1	5
BDNUM_HINDU						-1	5
BDORIENT_LTR						-1	5
BDORIENT_RTL						-1	5
BD_LEVEL						-1	5
BD_SUPPORT						-1	5
NlsQueryBidiAtt 					-1	5
NlsSetBidiAtt						-1	5
NlsShapeBidiString					-1	5
NlsEditShape						-1	5
NlsInverseString					-1	5
NlsConvertBidiNumerics					-1	5
NlsSetBidiPrint 					-1	5
NlsConvertBidiString					-1	5
__BSE__ 						-1	5
INCL_BASEINCLUDED					-1	5
INCL_DOS						-1	5
INCL_SUB						-1	5
INCL_DOSERRORS						-1	5
__BSEDEV__						-1	5
BSEDEV_INCLUDED 					-1	5
IOCTL_ASYNC						-1	5
IOCTL_SCR_AND_PTRDRAW					-1	5
IOCTL_KEYBOARD						-1	5
IOCTL_PRINTER						-1	5
IOCTL_LIGHTPEN						-1	5
IOCTL_POINTINGDEVICE					-1	5
IOCTL_DISK						-1	5
IOCTL_PHYSICALDISK					-1	5
IOCTL_MONITOR						-1	5
IOCTL_GENERAL						-1	5
ASYNC_SETBAUDRATE					-1	5
ASYNC_SETLINECTRL					-1	5
ASYNC_TRANSMITIMM					-1	5
ASYNC_SETBREAKOFF					-1	5
ASYNC_SETMODEMCTRL					-1	5
ASYNC_SETBREAKON					-1	5
ASYNC_STOPTRANSMIT					-1	5
ASYNC_STARTTRANSMIT					-1	5
ASYNC_SETDCBINFO					-1	5
ASYNC_GETBAUDRATE					-1	5
ASYNC_GETLINECTRL					-1	5
ASYNC_GETCOMMSTATUS					-1	5
ASYNC_GETLINESTATUS					-1	5
ASYNC_GETMODEMOUTPUT					-1	5
ASYNC_GETMODEMINPUT					-1	5
ASYNC_GETINQUECOUNT					-1	5
ASYNC_GETOUTQUECOUNT					-1	5
ASYNC_GETCOMMERROR					-1	5
ASYNC_GETCOMMEVENT					-1	5
ASYNC_GETDCBINFO					-1	5
SCR_ALLOCLDT						-1	5
SCR_DEALLOCLDT						-1	5
PTR_GETPTRDRAWADDRESS					-1	5
SCR_ALLOCLDTOFF 					-1	5
KBD_SETTRANSTABLE					-1	5
KBD_SETINPUTMODE					-1	5
KBD_SETINTERIMFLAG					-1	5
KBD_SETSHIFTSTATE					-1	5
KBD_SETTYPAMATICRATE					-1	5
KBD_SETFGNDSCREENGRP					-1	5
KBD_SETSESMGRHOTKEY					-1	5
KBD_SETFOCUS						-1	5
KBD_SETKCB						-1	5
KBD_SETNLS						-1	5
KBD_CREATE						-1	5
KBD_DESTROY						-1	5
KBD_GETINPUTMODE					-1	5
KBD_GETINTERIMFLAG					-1	5
KBD_GETSHIFTSTATE					-1	5
KBD_READCHAR						-1	5
KBD_PEEKCHAR						-1	5
KBD_GETSESMGRHOTKEY					-1	5
KBD_GETKEYBDTYPE					-1	5
KBD_GETCODEPAGEID					-1	5
KBD_XLATESCAN						-1	5
PRT_QUERYJOBHANDLE					-1	5
PRT_SETFRAMECTL 					-1	5
PRT_SETINFINITERETRY					-1	5
PRT_INITPRINTER 					-1	5
PRT_ACTIVATEFONT					-1	5
PRT_GETFRAMECTL 					-1	5
PRT_GETINFINITERETRY					-1	5
PRT_GETPRINTERSTATUS					-1	5
PRT_QUERYACTIVEFONT					-1	5
PRT_VERIFYFONT						-1	5
MOU_ALLOWPTRDRAW					-1	5
MOU_UPDATEDISPLAYMODE					-1	5
MOU_SCREENSWITCH					-1	5
MOU_SETSCALEFACTORS					-1	5
MOU_SETEVENTMASK					-1	5
MOU_SETHOTKEYBUTTON					-1	5
MOU_SETPTRSHAPE 					-1	5
MOU_DRAWPTR						-1	5
MOU_REMOVEPTR						-1	5
MOU_SETPTRPOS						-1	5
MOU_SETPROTDRAWADDRESS					-1	5
MOU_SETREALDRAWADDRESS					-1	5
MOU_SETMOUSTATUS					-1	5
MOU_DISPLAYMODECHANGE					-1	5
MOU_GETBUTTONCOUNT					-1	5
MOU_GETMICKEYCOUNT					-1	5
MOU_GETMOUSTATUS					-1	5
MOU_READEVENTQUE					-1	5
MOU_GETQUESTATUS					-1	5
MOU_GETEVENTMASK					-1	5
MOU_GETSCALEFACTORS					-1	5
MOU_GETPTRPOS						-1	5
MOU_GETPTRSHAPE 					-1	5
MOU_GETHOTKEYBUTTON					-1	5
MOU_VER 						-1	5
DSK_LOCKDRIVE						-1	5
DSK_UNLOCKDRIVE 					-1	5
DSK_REDETERMINEMEDIA					-1	5
DSK_SETLOGICALMAP					-1	5
DSK_BLOCKREMOVABLE					-1	5
DSK_GETLOGICALMAP					-1	5
DSK_SETDEVICEPARAMS					-1	5
DSK_WRITETRACK						-1	5
DSK_FORMATVERIFY					-1	5
DSK_GETDEVICEPARAMS					-1	5
DSK_READTRACK						-1	5
DSK_VERIFYTRACK 					-1	5
PDSK_LOCKPHYSDRIVE					-1	5
PDSK_UNLOCKPHYSDRIVE					-1	5
PDSK_WRITEPHYSTRACK					-1	5
PDSK_GETPHYSDEVICEPARAMS				-1	5
PDSK_READPHYSTRACK					-1	5
PDSK_VERIFYPHYSTRACK					-1	5
MON_REGISTERMONITOR					-1	5
DEV_FLUSHINPUT						-1	5
DEV_FLUSHOUTPUT 					-1	5
DEV_QUERYMONSUPPORT					-1	5
RX_QUE_OVERRUN						-1	5
RX_HARDWARE_OVERRUN					-1	5
PARITY_ERROR						-1	5
FRAMING_ERROR						-1	5
CHAR_RECEIVED						-1	5
LAST_CHAR_SENT						-1	5
CTS_CHANGED						-1	5
DSR_CHANGED						-1	5
DCD_CHANGED						-1	5
BREAK_DETECTED						-1	5
ERROR_OCCURRED						-1	5
RI_DETECTED						-1	5
TX_WAITING_FOR_CTS					-1	5
TX_WAITING_FOR_DSR					-1	5
TX_WAITING_FOR_DCD					-1	5
TX_WAITING_FOR_XON					-1	5
TX_WAITING_TO_SEND_XON					-1	5
TX_WAITING_WHILE_BREAK_ON				-1	5
TX_WAITING_TO_SEND_IMM					-1	5
RX_WAITING_FOR_DSR					-1	5
WRITE_REQUEST_QUEUED					-1	5
DATA_IN_TX_QUE						-1	5
HARDWARE_TRANSMITTING					-1	5
CHAR_READY_TO_SEND_IMM					-1	5
WAITING_TO_SEND_XON					-1	5
WAITING_TO_SEND_XOFF					-1	5
CTS_ON							-1	5
DSR_ON							-1	5
RI_ON							-1	5
DCD_ON							-1	5
BUILD_BPB_FROM_MEDIUM					-1	5
REPLACE_BPB_FOR_DEVICE					-1	5
REPLACE_BPB_FOR_MEDIUM					-1	5
ASCII_MODE						-1	5
BINARY_MODE						-1	5
CONVERSION_REQUEST					-1	5
INTERIM_CHAR						-1	5
HOTKEY_MAX_COUNT					-1	5
HOTKEY_CURRENT_COUNT					-1	5
KBD_DATA_RECEIVED					-1	5
KBD_DATA_BINARY 					-1	5
KBD_READ_WAIT						-1	5
KBD_READ_NOWAIT 					-1	5
SHIFT_REPORT_MODE					-1	5
MOUSE_MOTION						-1	5
MOUSE_MOTION_WITH_BN1_DOWN				-1	5
MOUSE_BN1_DOWN						-1	5
MOUSE_MOTION_WITH_BN2_DOWN				-1	5
MOUSE_BN2_DOWN						-1	5
MOUSE_MOTION_WITH_BN3_DOWN				-1	5
MOUSE_BN3_DOWN						-1	5
MHK_BUTTON1						-1	5
MHK_BUTTON2						-1	5
MHK_BUTTON3						-1	5
MOU_NOWAIT						-1	5
MOU_WAIT						-1	5
MHK_NO_HOTKEY						-1	5
MOUSE_QUEUEBUSY 					-1	5
MOUSE_BLOCKREAD 					-1	5
MOUSE_FLUSH						-1	5
MOUSE_UNSUPPORTED_MODE					-1	5
MOUSE_DISABLED						-1	5
MOUSE_MICKEYS						-1	5
PRINTER_TIMEOUT 					-1	5
PRINTER_IO_ERROR					-1	5
PRINTER_SELECTED					-1	5
PRINTER_OUT_OF_PAPER					-1	5
PRINTER_ACKNOWLEDGED					-1	5
PRINTER_NOT_BUSY					-1	5
MODE_DTR_CONTROL					-1	5
MODE_DTR_HANDSHAKE					-1	5
MODE_CTS_HANDSHAKE					-1	5
MODE_DSR_HANDSHAKE					-1	5
MODE_DCD_HANDSHAKE					-1	5
MODE_DSR_SENSITIVITY					-1	5
MODE_AUTO_TRANSMIT					-1	5
MODE_AUTO_RECEIVE					-1	5
MODE_ERROR_CHAR 					-1	5
MODE_NULL_STRIPPING					-1	5
MODE_BREAK_CHAR 					-1	5
MODE_RTS_CONTROL					-1	5
MODE_RTS_HANDSHAKE					-1	5
MODE_TRANSMIT_TOGGLE					-1	5
MODE_NO_WRITE_TIMEOUT					-1	5
MODE_READ_TIMEOUT					-1	5
MODE_WAIT_READ_TIMEOUT					-1	5
MODE_NOWAIT_READ_TIMEOUT				-1	5
DEVTYPE_48TPI						-1	5
DEVTYPE_96TPI						-1	5
DEVTYPE_35						-1	5
DEVTYPE_8SD						-1	5
DEVTYPE_8DD						-1	5
DEVTYPE_FIXED						-1	5
DEVTYPE_TAPE						-1	5
DEVTYPE_UNKNOWN 					-1	5
DTR_ON							-1	5
RTS_ON							-1	5
DTR_OFF 						-1	5
RTS_OFF 						-1	5
RIGHTSHIFT						-1	5
LEFTSHIFT						-1	5
CONTROL 						-1	5
ALT							-1	5
SCROLLLOCK_ON						-1	5
NUMLOCK_ON						-1	5
CAPSLOCK_ON						-1	5
INSERT_ON						-1	5
LEFTCONTROL						-1	5
LEFTALT 						-1	5
RIGHTCONTROL						-1	5
RIGHTALT						-1	5
SCROLLLOCK						-1	5
NUMLOCK 						-1	5
CAPSLOCK						-1	5
SYSREQ							-1	5
__BSEDOS__						-1	5
INCL_DOSINCLUDED					-1	5
INCL_DOSPROCESS 					-1	5
INCL_DOSFILEMGR 					-1	5
INCL_DOSMEMMGR						-1	5
INCL_DOSSEMAPHORES					-1	5
INCL_DOSDATETIME					-1	5
INCL_DOSMODULEMGR					-1	5
INCL_DOSRESOURCES					-1	5
INCL_DOSNLS						-1	5
INCL_DOSEXCEPTIONS					-1	5
INCL_DOSMISC						-1	5
INCL_DOSMONITORS					-1	5
INCL_DOSQUEUES						-1	5
INCL_DOSSESMGR						-1	5
INCL_DOSDEVICES 					-1	5
INCL_DOSDEVIOCTL					-1	5
INCL_DOSNMPIPES 					-1	5
INCL_DOSPROFILE 					-1	5
INCL_DOSMVDM						-1	5
INCL_DOSERRORS						-1	5
EXIT_THREAD						-1	5
EXIT_PROCESS						-1	5
DosCwait						-1	5
DosSetPrty						-1	5
DCWA_PROCESS						-1	5
DCWA_PROCESSTREE					-1	5
DCWW_WAIT						-1	5
DCWW_NOWAIT						-1	5
CREATE_READY						-1	5
CREATE_SUSPENDED					-1	5
STACK_SPARSE						-1	5
STACK_COMMITTED 					-1	5
DBG_C_Null						-1	5
DBG_C_ReadMem						-1	5
DBG_C_ReadMem_I 					-1	5
DBG_C_ReadMem_D 					-1	5
DBG_C_ReadReg						-1	5
DBG_C_WriteMem						-1	5
DBG_C_WriteMem_I					-1	5
DBG_C_WriteMem_D					-1	5
DBG_C_WriteReg						-1	5
DBG_C_Go						-1	5
DBG_C_Term						-1	5
DBG_C_SStep						-1	5
DBG_C_Stop						-1	5
DBG_C_Freeze						-1	5
DBG_C_Resume						-1	5
DBG_C_NumToAddr 					-1	5
DBG_C_ReadCoRegs					-1	5
DBG_C_WriteCoRegs					-1	5
DBG_C_ThrdStat						-1	5
DBG_C_MapROAlias					-1	5
DBG_C_MapRWAlias					-1	5
DBG_C_UnMapAlias					-1	5
DBG_C_Connect						-1	5
DBG_C_ReadMemBuf					-1	5
DBG_C_WriteMemBuf					-1	5
DBG_C_SetWatch						-1	5
DBG_C_ClearWatch					-1	5
DBG_C_RangeStep 					-1	5
DBG_C_Continue						-1	5
DBG_C_AddrToObject					-1	5
DBG_C_XchgOpcode					-1	5
DBG_C_LinToSel						-1	5
DBG_C_SelToLin						-1	5
TC_EXIT 						-1	5
TC_HARDERROR						-1	5
TC_TRAP 						-1	5
TC_KILLPROCESS						-1	5
TC_EXCEPTION						-1	5
EXLST_ADD						-1	5
EXLST_REMOVE						-1	5
EXLST_EXIT						-1	5
EXEC_SYNC						-1	5
EXEC_ASYNC						-1	5
EXEC_ASYNCRESULT					-1	5
EXEC_TRACE						-1	5
EXEC_BACKGROUND 					-1	5
EXEC_LOAD						-1	5
EXEC_ASYNCRESULTDB					-1	5
PRTYS_PROCESS						-1	5
PRTYS_PROCESSTREE					-1	5
PRTYS_THREAD						-1	5
PRTYC_NOCHANGE						-1	5
PRTYC_IDLETIME						-1	5
PRTYC_REGULAR						-1	5
PRTYC_TIMECRITICAL					-1	5
PRTYC_FOREGROUNDSERVER					-1	5
PRTYD_MINIMUM						-1	5
PRTYD_MAXIMUM						-1	5
DKP_PROCESSTREE 					-1	5
DKP_PROCESS						-1	5
CCHMAXPATH						-1	5
CCHMAXPATHCOMP						-1	5
FILE_BEGIN						-1	5
FILE_CURRENT						-1	5
FILE_END						-1	5
HDIR_SYSTEM						-1	5
HDIR_CREATE						-1	5
DCPY_EXISTING						-1	5
DCPY_APPEND						-1	5
DCPY_FAILEAS						-1	5
FILE_NORMAL						-1	5
FILE_READONLY						-1	5
FILE_HIDDEN						-1	5
FILE_SYSTEM						-1	5
FILE_DIRECTORY						-1	5
FILE_ARCHIVED						-1	5
FILE_IGNORE						-1	5
MUST_HAVE_READONLY					-1	5
MUST_HAVE_HIDDEN					-1	5
MUST_HAVE_SYSTEM					-1	5
MUST_HAVE_DIRECTORY					-1	5
MUST_HAVE_ARCHIVED					-1	5
FILE_EXISTED						-1	5
FILE_CREATED						-1	5
FILE_TRUNCATED						-1	5
FILE_OPEN						-1	5
FILE_TRUNCATE						-1	5
FILE_CREATE						-1	5
OPEN_ACTION_FAIL_IF_EXISTS				-1	5
OPEN_ACTION_OPEN_IF_EXISTS				-1	5
OPEN_ACTION_REPLACE_IF_EXISTS				-1	5
OPEN_ACTION_FAIL_IF_NEW 				-1	5
OPEN_ACTION_CREATE_IF_NEW				-1	5
OPEN_ACCESS_READONLY					-1	5
OPEN_ACCESS_WRITEONLY					-1	5
OPEN_ACCESS_READWRITE					-1	5
OPEN_SHARE_DENYREADWRITE				-1	5
OPEN_SHARE_DENYWRITE					-1	5
OPEN_SHARE_DENYREAD					-1	5
OPEN_SHARE_DENYNONE					-1	5
OPEN_FLAGS_NOINHERIT					-1	5
OPEN_FLAGS_NO_LOCALITY					-1	5
OPEN_FLAGS_SEQUENTIAL					-1	5
OPEN_FLAGS_RANDOM					-1	5
OPEN_FLAGS_RANDOMSEQUENTIAL				-1	5
OPEN_FLAGS_NO_CACHE					-1	5
OPEN_FLAGS_FAIL_ON_ERROR				-1	5
OPEN_FLAGS_WRITE_THROUGH				-1	5
OPEN_FLAGS						-1	5
OPEN_FLAGS_DASD 					-1	5
OPEN_FLAGS_NONSPOOLED					-1	5
OPEN_FLAGS_PROTECTED_HANDLE				-1	5
SEARCH_PATH						-1	5
SEARCH_CUR_DIRECTORY					-1	5
SEARCH_ENVIRONMENT					-1	5
SEARCH_IGNORENETERRS					-1	5
FIL_STANDARD						-1	5
FIL_QUERYEASIZE 					-1	5
FIL_QUERYEASFROMLIST					-1	5
FIL_QUERYFULLNAME					-1	5
FS_ATTACH						-1	5
FS_DETACH						-1	5
FS_SPOOLATTACH						-1	5
FS_SPOOLDETACH						-1	5
FSCTL_HANDLE						-1	5
FSCTL_PATHNAME						-1	5
FSCTL_FSDNAME						-1	5
FSCTL_ERROR_INFO					-1	5
FSCTL_MAX_EASIZE					-1	5
FSAIL_QUERYNAME 					-1	5
FSAIL_DEVNUMBER 					-1	5
FSAIL_DRVNUMBER 					-1	5
FSAT_CHARDEV						-1	5
FSAT_PSEUDODEV						-1	5
FSAT_LOCALDRV						-1	5
FSAT_REMOTEDRV						-1	5
FSIL_ALLOC						-1	5
FSIL_VOLSER						-1	5
FHT_DISKFILE						-1	5
FHT_CHRDEV						-1	5
FHT_PIPE						-1	5
FHB_DSKREMOTE						-1	5
FHB_CHRDEVREMOTE					-1	5
FHB_PIPEREMOTE						-1	5
HANDTYPE_FILE						-1	5
HANDTYPE_DEVICE 					-1	5
HANDTYPE_PIPE						-1	5
HANDTYPE_PROTECTED					-1	5
HANDTYPE_NETWORK					-1	5
__HEV__ 						-1	5
FEA_NEEDEA						-1	5
EAT_BINARY						-1	5
EAT_ASCII						-1	5
EAT_BITMAP						-1	5
EAT_METAFILE						-1	5
EAT_ICON						-1	5
EAT_EA							-1	5
EAT_MVMT						-1	5
EAT_MVST						-1	5
EAT_ASN1						-1	5
DosOpen2						-1	5
DosFindFirst2						-1	5
DosQFHandState						-1	5
DosProtectQFHandState					-1	5
DosSetFHandState					-1	5
DosProtectSetFHandState 				-1	5
DosQHandType						-1	5
DosQFSAttach						-1	5
DosNewSize						-1	5
DosProtectNewSize					-1	5
DosBufReset						-1	5
DosChgFilePtr						-1	5
DosProtectChgFilePtr					-1	5
DosMkDir						-1	5
DosMkDir2						-1	5
DosRmDir						-1	5
DosSelectDisk						-1	5
DosQCurDisk						-1	5
DosChDir						-1	5
DosQCurDir						-1	5
DosQFSInfo						-1	5
DosQVerify						-1	5
DosQFileInfo						-1	5
DosProtectQFileInfo					-1	5
DosQPathInfo						-1	5
DSPI_WRTTHRU						-1	5
ENUMEA_LEVEL_NO_VALUE					-1	5
ENUMEA_REFTYPE_FHANDLE					-1	5
ENUMEA_REFTYPE_PATH					-1	5
ENUMEA_REFTYPE_MAX					-1	5
DosSubAlloc						-1	5
DOSSUBALLOC						-1	5
DosSubFree						-1	5
DOSSUBFREE						-1	5
DosSubSet						-1	5
DOSSUBSET						-1	5
DosSubUnset						-1	5
DOSSUBUNSET						-1	5
DC_SEM_SHARED						-1	5
DCMW_WAIT_ANY						-1	5
DCMW_WAIT_ALL						-1	5
SEM_INDEFINITE_WAIT					-1	5
SEM_IMMEDIATE_RETURN					-1	5
__HSEM__						-1	5
__HEV__ 						-1	5
DosTimerAsync						-1	5
DosTimerStart						-1	5
DosTimerStop						-1	5
PT_16BIT						-1	5
PT_32BIT						-1	5
RT_POINTER						-1	5
RT_BITMAP						-1	5
RT_MENU 						-1	5
RT_DIALOG						-1	5
RT_STRING						-1	5
RT_FONTDIR						-1	5
RT_FONT 						-1	5
RT_ACCELTABLE						-1	5
RT_RCDATA						-1	5
RT_MESSAGE						-1	5
RT_DLGINCLUDE						-1	5
RT_VKEYTBL						-1	5
RT_KEYTBL						-1	5
RT_CHARTBL						-1	5
RT_DISPLAYINFO						-1	5
RT_FKASHORT						-1	5
RT_FKALONG						-1	5
RT_HELPTABLE						-1	5
RT_HELPSUBTABLE 					-1	5
RT_FDDIR						-1	5
RT_FD							-1	5
RT_MAX							-1	5
RF_ORDINALID						-1	5
DosGetResource2 					-1	5
DosGetCtryInfo						-1	5
DosGetDBCSEv						-1	5
DosCaseMap						-1	5
DosGetCollate						-1	5
DosGetCp						-1	5
DosSetProcCp						-1	5
SIG_UNSETFOCUS						-1	5
SIG_SETFOCUS						-1	5
QUE_FIFO						-1	5
QUE_LIFO						-1	5
QUE_PRIORITY						-1	5
QUE_NOCONVERT_ADDRESS					-1	5
QUE_CONVERT_ADDRESS					-1	5
DSP_IMPLIEDCUR						-1	5
DSP_PATHREF						-1	5
DSP_IGNORENETERR					-1	5
QSV_MAX_PATH_LENGTH					-1	5
Q_MAX_PATH_LENGTH					-1	5
QSV_MAX_TEXT_SESSIONS					-1	5
QSV_MAX_PM_SESSIONS					-1	5
QSV_MAX_VDM_SESSIONS					-1	5
QSV_BOOT_DRIVE						-1	5
QSV_DYN_PRI_VARIATION					-1	5
QSV_MAX_WAIT						-1	5
QSV_MIN_SLICE						-1	5
QSV_MAX_SLICE						-1	5
QSV_PAGE_SIZE						-1	5
QSV_VERSION_MAJOR					-1	5
QSV_VERSION_MINOR					-1	5
QSV_VERSION_REVISION					-1	5
QSV_MS_COUNT						-1	5
QSV_TIME_LOW						-1	5
QSV_TIME_HIGH						-1	5
QSV_TOTPHYSMEM						-1	5
QSV_TOTRESMEM						-1	5
QSV_TOTAVAILMEM 					-1	5
QSV_MAXPRMEM						-1	5
QSV_MAXSHMEM						-1	5
QSV_TIMER_INTERVAL					-1	5
QSV_MAX_COMP_LENGTH					-1	5
QSV_MAX 						-1	5
FERR_DISABLEHARDERR					-1	5
FERR_ENABLEHARDERR					-1	5
FERR_ENABLEEXCEPTION					-1	5
FERR_DISABLEEXCEPTION					-1	5
SIS_MMIOADDR						-1	5
SIS_MEC_TABLE						-1	5
SIS_SYS_LOG						-1	5
DosInsMessage						-1	5
DosQSysInfo						-1	5
SSF_RELATED_INDEPENDENT 				-1	5
SSF_RELATED_CHILD					-1	5
SSF_FGBG_FORE						-1	5
SSF_FGBG_BACK						-1	5
SS							-1	5
SSF_TRACEOPT_NONE					-1	5
SSF_TRACEOPT_TRACE					-1	5
SSF_TRACEOPT_TRACEALL					-1	5
SSF_INHERTOPT_SHELL					-1	5
SSF_INHERTOPT_PARENT					-1	5
SSF_TYPE_DEFAULT					-1	5
SSF_TYPE_FULLSCREEN					-1	5
SSF_TYPE_WINDOWABLEVIO					-1	5
SSF_TYPE_PM						-1	5
SSF_TYPE_VDM						-1	5
SSF_TYPE_GROUP						-1	5
SSF_TYPE_DLL						-1	5
SSF_TYPE_WINDOWEDVDM					-1	5
SSF_TYPE_PDD						-1	5
SSF_TYPE_VDD						-1	5
SSF_CONTROL_VISIBLE					-1	5
SSF_CONTROL_INVISIBLE					-1	5
SSF_CONTROL_MAXIMIZE					-1	5
SSF_CONTROL_MINIMIZE					-1	5
SSF_CONTROL_NOAUTOCLOSE 				-1	5
SSF_CONTROL_SETPOS					-1	5
SET_SESSION_UNCHANGED					-1	5
SET_SESSION_SELECTABLE					-1	5
SET_SESSION_NON_SELECTABLE				-1	5
SET_SESSION_BOND					-1	5
SET_SESSION_NO_BOND					-1	5
STOP_SESSION_SPECIFIED					-1	5
STOP_SESSION_ALL					-1	5
DosQAppType						-1	5
FAPPTYP_NOTSPEC 					-1	5
FAPPTYP_NOTWINDOWCOMPAT 				-1	5
FAPPTYP_WINDOWCOMPAT					-1	5
FAPPTYP_WINDOWAPI					-1	5
FAPPTYP_BOUND						-1	5
FAPPTYP_DLL						-1	5
FAPPTYP_DOS						-1	5
FAPPTYP_PHYSDRV 					-1	5
FAPPTYP_VIRTDRV 					-1	5
FAPPTYP_PROTDLL 					-1	5
FAPPTYP_WINDOWSREAL					-1	5
FAPPTYP_WINDOWSPROT					-1	5
FAPPTYP_WINDOWSPROT31					-1	5
FAPPTYP_32BIT						-1	5
FAPPTYP_EXETYPE 					-1	5
FAPPTYP_RESERVED					-1	5
EAT_APPTYP_PMAPI					-1	5
EAT_APPTYP_DOS						-1	5
EAT_APPTYP_PMW						-1	5
EAT_APPTYP_NOPMW					-1	5
EAT_APPTYP_EXETYPE					-1	5
EAT_APPTYP_RESERVED					-1	5
DosDevIOCtl2						-1	5
DEVINFO_PRINTER 					-1	5
DEVINFO_RS232						-1	5
DEVINFO_FLOPPY						-1	5
DEVINFO_COPROCESSOR					-1	5
DEVINFO_SUBMODEL					-1	5
DEVINFO_MODEL						-1	5
DEVINFO_ADAPTER 					-1	5
INFO_COUNT_PARTITIONABLE_DISKS				-1	5
INFO_GETIOCTLHANDLE					-1	5
INFO_FREEIOCTLHANDLE					-1	5
NP_INDEFINITE_WAIT					-1	5
NP_DEFAULT_WAIT 					-1	5
NP_STATE_DISCONNECTED					-1	5
NP_STATE_LISTENING					-1	5
NP_STATE_CONNECTED					-1	5
NP_STATE_CLOSING					-1	5
NP_ACCESS_INBOUND					-1	5
NP_ACCESS_OUTBOUND					-1	5
NP_ACCESS_DUPLEX					-1	5
NP_INHERIT						-1	5
NP_NOINHERIT						-1	5
NP_WRITEBEHIND						-1	5
NP_NOWRITEBEHIND					-1	5
NP_READMODE_BYTE					-1	5
NP_READMODE_MESSAGE					-1	5
NP_TYPE_BYTE						-1	5
NP_TYPE_MESSAGE 					-1	5
NP_END_CLIENT						-1	5
NP_END_SERVER						-1	5
NP_WAIT 						-1	5
NP_NOWAIT						-1	5
NP_UNLIMITED_INSTANCES					-1	5
NPSS_EOI						-1	5
NPSS_RDATA						-1	5
NPSS_WSPACE						-1	5
NPSS_CLOSE						-1	5
NPSS_WAIT						-1	5
NP_NBLK 						-1	5
NP_SERVER						-1	5
NP_WMESG						-1	5
NP_RMESG						-1	5
NP_ICOUNT						-1	5
NP_DISCONNECTED 					-1	5
NP_LISTENING						-1	5
NP_CONNECTED						-1	5
NP_CLOSING						-1	5
PROF_ORDINAL						-1	5
PROF_SYSTEM						-1	5
PROF_USER						-1	5
PROF_USEDD						-1	5
PROF_KERNEL						-1	5
PROF_VERBOSE						-1	5
PROF_ENABLE						-1	5
PROF_ALLOC						-1	5
PROF_CLEAR						-1	5
PROF_ON 						-1	5
PROF_OFF						-1	5
PROF_DUMP						-1	5
PROF_FREE						-1	5
PROF_SHIFT						-1	5
PROF_MOD_NAME_SIZE					-1	5
PROF_END_OF_DATA					-1	5
for							-1	5
ERROR_NO						-1	5
ERROR_NO						-1	5
INCL_DOSERRORS						-1	5
INCL_ERROR_H						-1	5
INCL_ERROR2_H						-1	5
NO_ERROR						-1	5
ERROR_INVALID_FUNCTION					-1	5
ERROR_FILE_NOT_FOUND					-1	5
ERROR_PATH_NOT_FOUND					-1	5
ERROR_TOO_MANY_OPEN_FILES				-1	5
ERROR_ACCESS_DENIED					-1	5
ERROR_INVALID_HANDLE					-1	5
ERROR_ARENA_TRASHED					-1	5
ERROR_NOT_ENOUGH_MEMORY 				-1	5
ERROR_INVALID_BLOCK					-1	5
ERROR_BAD_ENVIRONMENT					-1	5
ERROR_BAD_FORMAT					-1	5
ERROR_INVALID_ACCESS					-1	5
ERROR_INVALID_DATA					-1	5
ERROR_INVALID_DRIVE					-1	5
ERROR_CURRENT_DIRECTORY 				-1	5
ERROR_NOT_SAME_DEVICE					-1	5
ERROR_NO_MORE_FILES					-1	5
ERROR_WRITE_PROTECT					-1	5
ERROR_BAD_UNIT						-1	5
ERROR_NOT_READY 					-1	5
ERROR_BAD_COMMAND					-1	5
ERROR_CRC						-1	5
ERROR_BAD_LENGTH					-1	5
ERROR_SEEK						-1	5
ERROR_NOT_DOS_DISK					-1	5
ERROR_SECTOR_NOT_FOUND					-1	5
ERROR_OUT_OF_PAPER					-1	5
ERROR_WRITE_FAULT					-1	5
ERROR_READ_FAULT					-1	5
ERROR_GEN_FAILURE					-1	5
ERROR_SHARING_VIOLATION 				-1	5
ERROR_LOCK_VIOLATION					-1	5
ERROR_WRONG_DISK					-1	5
ERROR_FCB_UNAVAILABLE					-1	5
ERROR_SHARING_BUFFER_EXCEEDED				-1	5
ERROR_CODE_PAGE_MISMATCHED				-1	5
ERROR_HANDLE_EOF					-1	5
ERROR_HANDLE_DISK_FULL					-1	5
ERROR_NOT_SUPPORTED					-1	5
ERROR_REM_NOT_LIST					-1	5
ERROR_DUP_NAME						-1	5
ERROR_BAD_NETPATH					-1	5
ERROR_NETWORK_BUSY					-1	5
ERROR_DEV_NOT_EXIST					-1	5
ERROR_TOO_MANY_CMDS					-1	5
ERROR_ADAP_HDW_ERR					-1	5
ERROR_BAD_NET_RESP					-1	5
ERROR_UNEXP_NET_ERR					-1	5
ERROR_BAD_REM_ADAP					-1	5
ERROR_PRINTQ_FULL					-1	5
ERROR_NO_SPOOL_SPACE					-1	5
ERROR_PRINT_CANCELLED					-1	5
ERROR_NETNAME_DELETED					-1	5
ERROR_NETWORK_ACCESS_DENIED				-1	5
ERROR_BAD_DEV_TYPE					-1	5
ERROR_BAD_NET_NAME					-1	5
ERROR_TOO_MANY_NAMES					-1	5
ERROR_TOO_MANY_SESS					-1	5
ERROR_SHARING_PAUSED					-1	5
ERROR_REQ_NOT_ACCEP					-1	5
ERROR_REDIR_PAUSED					-1	5
ERROR_SBCS_ATT_WRITE_PROT				-1	5
ERROR_SBCS_GENERAL_FAILURE				-1	5
ERROR_XGA_OUT_MEMORY					-1	5
ERROR_FILE_EXISTS					-1	5
ERROR_DUP_FCB						-1	5
ERROR_CANNOT_MAKE					-1	5
ERROR_FAIL_I24						-1	5
ERROR_OUT_OF_STRUCTURES 				-1	5
ERROR_ALREADY_ASSIGNED					-1	5
ERROR_INVALID_PASSWORD					-1	5
ERROR_INVALID_PARAMETER 				-1	5
ERROR_NET_WRITE_FAULT					-1	5
ERROR_NO_PROC_SLOTS					-1	5
ERROR_NOT_FROZEN					-1	5
ERROR_SYS_COMP_NOT_LOADED				-1	5
ERR_TSTOVFL						-1	5
ERR_TSTDUP						-1	5
ERROR_NO_ITEMS						-1	5
ERROR_INTERRUPT 					-1	5
ERROR_DEVICE_IN_USE					-1	5
ERROR_TOO_MANY_SEMAPHORES				-1	5
ERROR_EXCL_SEM_ALREADY_OWNED				-1	5
ERROR_SEM_IS_SET					-1	5
ERROR_TOO_MANY_SEM_REQUESTS				-1	5
ERROR_INVALID_AT_INTERRUPT_TIME 			-1	5
ERROR_SEM_OWNER_DIED					-1	5
ERROR_SEM_USER_LIMIT					-1	5
ERROR_DISK_CHANGE					-1	5
ERROR_DRIVE_LOCKED					-1	5
ERROR_BROKEN_PIPE					-1	5
ERROR_OPEN_FAILED					-1	5
ERROR_BUFFER_OVERFLOW					-1	5
ERROR_DISK_FULL 					-1	5
ERROR_NO_MORE_SEARCH_HANDLES				-1	5
ERROR_INVALID_TARGET_HANDLE				-1	5
ERROR_PROTECTION_VIOLATION				-1	5
ERROR_VIOKBD_REQUEST					-1	5
ERROR_INVALID_CATEGORY					-1	5
ERROR_INVALID_VERIFY_SWITCH				-1	5
ERROR_BAD_DRIVER_LEVEL					-1	5
ERROR_CALL_NOT_IMPLEMENTED				-1	5
ERROR_SEM_TIMEOUT					-1	5
ERROR_INSUFFICIENT_BUFFER				-1	5
ERROR_INVALID_NAME					-1	5
ERROR_INVALID_LEVEL					-1	5
ERROR_NO_VOLUME_LABEL					-1	5
ERROR_MOD_NOT_FOUND					-1	5
ERROR_PROC_NOT_FOUND					-1	5
ERROR_WAIT_NO_CHILDREN					-1	5
ERROR_CHILD_NOT_COMPLETE				-1	5
ERROR_DIRECT_ACCESS_HANDLE				-1	5
ERROR_NEGATIVE_SEEK					-1	5
ERROR_SEEK_ON_DEVICE					-1	5
ERROR_IS_JOIN_TARGET					-1	5
ERROR_IS_JOINED 					-1	5
ERROR_IS_SUBSTED					-1	5
ERROR_NOT_JOINED					-1	5
ERROR_NOT_SUBSTED					-1	5
ERROR_JOIN_TO_JOIN					-1	5
ERROR_SUBST_TO_SUBST					-1	5
ERROR_JOIN_TO_SUBST					-1	5
ERROR_SUBST_TO_JOIN					-1	5
ERROR_BUSY_DRIVE					-1	5
ERROR_SAME_DRIVE					-1	5
ERROR_DIR_NOT_ROOT					-1	5
ERROR_DIR_NOT_EMPTY					-1	5
ERROR_IS_SUBST_PATH					-1	5
ERROR_IS_JOIN_PATH					-1	5
ERROR_PATH_BUSY 					-1	5
ERROR_IS_SUBST_TARGET					-1	5
ERROR_SYSTEM_TRACE					-1	5
ERROR_INVALID_EVENT_COUNT				-1	5
ERROR_TOO_MANY_MUXWAITERS				-1	5
ERROR_INVALID_LIST_FORMAT				-1	5
ERROR_LABEL_TOO_LONG					-1	5
ERROR_TOO_MANY_TCBS					-1	5
ERROR_SIGNAL_REFUSED					-1	5
ERROR_DISCARDED 					-1	5
ERROR_NOT_LOCKED					-1	5
ERROR_BAD_THREADID_ADDR 				-1	5
ERROR_BAD_ARGUMENTS					-1	5
ERROR_BAD_PATHNAME					-1	5
ERROR_SIGNAL_PENDING					-1	5
ERROR_UNCERTAIN_MEDIA					-1	5
ERROR_MAX_THRDS_REACHED 				-1	5
ERROR_MONITORS_NOT_SUPPORTED				-1	5
ERROR_UNC_DRIVER_NOT_INSTALLED				-1	5
ERROR_LOCK_FAILED					-1	5
ERROR_SWAPIO_FAILED					-1	5
ERROR_SWAPIN_FAILED					-1	5
ERROR_BUSY						-1	5
ERROR_CANCEL_VIOLATION					-1	5
ERROR_ATOMIC_LOCK_NOT_SUPPORTED 			-1	5
ERROR_READ_LOCKS_NOT_SUPPORTED				-1	5
ERROR_INVALID_SEGMENT_NUMBER				-1	5
ERROR_INVALID_CALLGATE					-1	5
ERROR_INVALID_ORDINAL					-1	5
ERROR_ALREADY_EXISTS					-1	5
ERROR_NO_CHILD_PROCESS					-1	5
ERROR_CHILD_ALIVE_NOWAIT				-1	5
ERROR_INVALID_FLAG_NUMBER				-1	5
ERROR_SEM_NOT_FOUND					-1	5
ERROR_INVALID_STARTING_CODESEG				-1	5
ERROR_INVALID_STACKSEG					-1	5
ERROR_INVALID_MODULETYPE				-1	5
ERROR_INVALID_EXE_SIGNATURE				-1	5
ERROR_EXE_MARKED_INVALID				-1	5
ERROR_BAD_EXE_FORMAT					-1	5
ERROR_ITERATED_DATA_EXCEEDS_64k 			-1	5
ERROR_INVALID_MINALLOCSIZE				-1	5
ERROR_DYNLINK_FROM_INVALID_RING 			-1	5
ERROR_IOPL_NOT_ENABLED					-1	5
ERROR_INVALID_SEGDPL					-1	5
ERROR_AUTODATASEG_EXCEEDS_64k				-1	5
ERROR_RING2SEG_MUST_BE_MOVABLE				-1	5
ERROR_RELOC_CHAIN_XEEDS_SEGLIM				-1	5
ERROR_INFLOOP_IN_RELOC_CHAIN				-1	5
ERROR_ENVVAR_NOT_FOUND					-1	5
ERROR_NOT_CURRENT_CTRY					-1	5
ERROR_NO_SIGNAL_SENT					-1	5
ERROR_FILENAME_EXCED_RANGE				-1	5
ERROR_RING2_STACK_IN_USE				-1	5
ERROR_META_EXPANSION_TOO_LONG				-1	5
ERROR_INVALID_SIGNAL_NUMBER				-1	5
ERROR_THREAD_1_INACTIVE 				-1	5
ERROR_INFO_NOT_AVAIL					-1	5
ERROR_LOCKED						-1	5
ERROR_BAD_D						-1	5
ERROR_BAD_DYNALINK					-1	5
ERROR_TOO_MANY_MODULES					-1	5
ERROR_NESTING_NOT_ALLOWED				-1	5
ERROR_CANNOT_SHRINK					-1	5
ERROR_ZOMBIE_PROCESS					-1	5
ERROR_STACK_IN_HIGH_MEMORY				-1	5
ERROR_INVALID_EXITROUTINE_RING				-1	5
ERROR_GETBUF_FAILED					-1	5
ERROR_FLUSHBUF_FAILED					-1	5
ERROR_TRANSFER_TOO_LONG 				-1	5
ERROR_FORCENOSWAP_FAILED				-1	5
ERROR_SMG_NO_TARGET_WINDOW				-1	5
ERROR_NO_CHILDREN					-1	5
ERROR_INVALID_SCREEN_GROUP				-1	5
ERROR_BAD_PIPE						-1	5
ERROR_PIPE_BUSY 					-1	5
ERROR_NO_DATA						-1	5
ERROR_PIPE_NOT_CONNECTED				-1	5
ERROR_MORE_DATA 					-1	5
ERROR_VC_DISCONNECTED					-1	5
ERROR_CIRCULARITY_REQUESTED				-1	5
ERROR_DIRECTORY_IN_CDS					-1	5
ERROR_INVALID_FSD_NAME					-1	5
ERROR_INVALID_PATH					-1	5
ERROR_INVALID_EA_NAME					-1	5
ERROR_EA_LIST_INCONSISTENT				-1	5
ERROR_EA_LIST_TOO_LONG					-1	5
ERROR_NO_META_MATCH					-1	5
ERROR_FINDNOTIFY_TIMEOUT				-1	5
ERROR_NO_MORE_ITEMS					-1	5
ERROR_SEARCH_STRUC_REUSED				-1	5
ERROR_CHAR_NOT_FOUND					-1	5
ERROR_TOO_MUCH_STACK					-1	5
ERROR_INVALID_ATTR					-1	5
ERROR_INVALID_STARTING_RING				-1	5
ERROR_INVALID_DLL_INIT_RING				-1	5
ERROR_CANNOT_COPY					-1	5
ERROR_DIRECTORY 					-1	5
ERROR_OPLOCKED_FILE					-1	5
ERROR_OPLOCK_THREAD_EXISTS				-1	5
ERROR_VOLUME_CHANGED					-1	5
ERROR_FINDNOTIFY_HANDLE_IN_USE				-1	5
ERROR_FINDNOTIFY_HANDLE_CLOSED				-1	5
ERROR_NOTIFY_OBJECT_REMOVED				-1	5
ERROR_ALREADY_SHUTDOWN					-1	5
ERROR_EAS_DIDNT_FIT					-1	5
ERROR_EA_FILE_CORRUPT					-1	5
ERROR_EA_TABLE_FULL					-1	5
ERROR_INVALID_EA_HANDLE 				-1	5
ERROR_NO_CLUSTER					-1	5
ERROR_CREATE_EA_FILE					-1	5
ERROR_CANNOT_OPEN_EA_FILE				-1	5
ERROR_EAS_NOT_SUPPORTED 				-1	5
ERROR_NEED_EAS_FOUND					-1	5
ERROR_DUPLICATE_HANDLE					-1	5
ERROR_DUPLICATE_NAME					-1	5
ERROR_EMPTY_MUXWAIT					-1	5
ERROR_MUTEX_OWNED					-1	5
ERROR_NOT_OWNER 					-1	5
ERROR_PARAM_TOO_SMALL					-1	5
ERROR_TOO_MANY_HANDLES					-1	5
ERROR_TOO_MANY_OPENS					-1	5
ERROR_WRONG_TYPE					-1	5
ERROR_UNUSED_CODE					-1	5
ERROR_THREAD_NOT_TERMINATED				-1	5
ERROR_INIT_ROUTINE_FAILED				-1	5
ERROR_MODULE_IN_USE					-1	5
ERROR_NOT_ENOUGH_WATCHPOINTS				-1	5
ERROR_TOO_MANY_POSTS					-1	5
ERROR_ALREADY_POSTED					-1	5
ERROR_ALREADY_RESET					-1	5
ERROR_SEM_BUSY						-1	5
ERROR_USER_DEFINED_BASE 				-1	5
ERROR_I24_WRITE_PROTECT 				-1	5
ERROR_I24_BAD_UNIT					-1	5
ERROR_I24_NOT_READY					-1	5
ERROR_I24_BAD_COMMAND					-1	5
ERROR_I24_CRC						-1	5
ERROR_I24_BAD_LENGTH					-1	5
ERROR_I24_SEEK						-1	5
ERROR_I24_NOT_DOS_DISK					-1	5
ERROR_I24_SECTOR_NOT_FOUND				-1	5
ERROR_I24_OUT_OF_PAPER					-1	5
ERROR_I24_WRITE_FAULT					-1	5
ERROR_I24_READ_FAULT					-1	5
ERROR_I24_GEN_FAILURE					-1	5
ERROR_I24_DISK_CHANGE					-1	5
ERROR_I24_WRONG_DISK					-1	5
ERROR_I24_UNCERTAIN_MEDIA				-1	5
ERROR_I24_CHAR_CALL_INTERRUPTED 			-1	5
ERROR_I24_NO_MONITOR_SUPPORT				-1	5
ERROR_I24_INVALID_PARAMETER				-1	5
ERROR_I24_DEVICE_IN_USE 				-1	5
ERROR_I24_QUIET_INIT_FAIL				-1	5
ALLOWED_FAIL						-1	5
ALLOWED_ABORT						-1	5
ALLOWED_RETRY						-1	5
ALLOWED_IGNORE						-1	5
ALLOWED_ACKNOWLEDGE					-1	5
ALLOWED_DISPATCH					-1	5
ALLOWED_REGDUMP 					-1	5
ALLOWED_DETACHED					-1	5
ALLOWED_RESERVED					-1	5
I24_OPERATION						-1	5
I24_AREA						-1	5
I24_CLASS						-1	5
ERRCLASS_OUTRES 					-1	5
ERRCLASS_TEMPSIT					-1	5
ERRCLASS_AUTH						-1	5
ERRCLASS_INTRN						-1	5
ERRCLASS_HRDFAIL					-1	5
ERRCLASS_SYSFAIL					-1	5
ERRCLASS_APPERR 					-1	5
ERRCLASS_NOTFND 					-1	5
ERRCLASS_BADFMT 					-1	5
ERRCLASS_LOCKED 					-1	5
ERRCLASS_MEDIA						-1	5
ERRCLASS_ALREADY					-1	5
ERRCLASS_UNK						-1	5
ERRCLASS_CANT						-1	5
ERRCLASS_TIME						-1	5
ERRACT_RETRY						-1	5
ERRACT_DLYRET						-1	5
ERRACT_USER						-1	5
ERRACT_ABORT						-1	5
ERRACT_PANIC						-1	5
ERRACT_IGNORE						-1	5
ERRACT_INTRET						-1	5
ERRLOC_UNK						-1	5
ERRLOC_DISK						-1	5
ERRLOC_NET						-1	5
ERRLOC_SERDEV						-1	5
ERRLOC_MEM						-1	5
TC_NORMAL						-1	5
TC_HARDERR						-1	5
TC_GP_TRAP						-1	5
TC_SIGNAL						-1	5
TC_XCPT 						-1	5
ERROR_INVALID_PROCID					-1	5
ERROR_INVALID_PDELTA					-1	5
ERROR_NOT_DESCENDANT					-1	5
ERROR_NOT_SESSION_MANAGER				-1	5
ERROR_INVALID_PCLASS					-1	5
ERROR_INVALID_SCOPE					-1	5
ERROR_INVALID_THREADID					-1	5
ERROR_DOSSUB_SHRINK					-1	5
ERROR_DOSSUB_NOMEM					-1	5
ERROR_DOSSUB_OVERLAP					-1	5
ERROR_DOSSUB_BADSIZE					-1	5
ERROR_DOSSUB_BADFLAG					-1	5
ERROR_DOSSUB_BADSELECTOR				-1	5
ERROR_MR_MSG_TOO_LONG					-1	5
MGS_MR_MSG_TOO_LONG					-1	5
ERROR_MR_MID_NOT_FOUND					-1	5
ERROR_MR_UN_ACC_MSGF					-1	5
ERROR_MR_INV_MSGF_FORMAT				-1	5
ERROR_MR_INV_IVCOUNT					-1	5
ERROR_MR_UN_PERFORM					-1	5
ERROR_TS_WAKEUP 					-1	5
ERROR_TS_SEMHANDLE					-1	5
ERROR_TS_NOTIMER					-1	5
ERROR_TS_HANDLE 					-1	5
ERROR_TS_DATETIME					-1	5
ERROR_SYS_INTERNAL					-1	5
ERROR_QUE_CURRENT_NAME					-1	5
ERROR_QUE_PROC_NOT_OWNED				-1	5
ERROR_QUE_PROC_OWNED					-1	5
ERROR_QUE_DUPLICATE					-1	5
ERROR_QUE_ELEMENT_NOT_EXIST				-1	5
ERROR_QUE_NO_MEMORY					-1	5
ERROR_QUE_INVALID_NAME					-1	5
ERROR_QUE_INVALID_PRIORITY				-1	5
ERROR_QUE_INVALID_HANDLE				-1	5
ERROR_QUE_LINK_NOT_FOUND				-1	5
ERROR_QUE_MEMORY_ERROR					-1	5
ERROR_QUE_PREV_AT_END					-1	5
ERROR_QUE_PROC_NO_ACCESS				-1	5
ERROR_QUE_EMPTY 					-1	5
ERROR_QUE_NAME_NOT_EXIST				-1	5
ERROR_QUE_NOT_INITIALIZED				-1	5
ERROR_QUE_UNABLE_TO_ACCESS				-1	5
ERROR_QUE_UNABLE_TO_ADD 				-1	5
ERROR_QUE_UNABLE_TO_INIT				-1	5
ERROR_VIO_INVALID_MASK					-1	5
ERROR_VIO_PTR						-1	5
ERROR_VIO_APTR						-1	5
ERROR_VIO_RPTR						-1	5
ERROR_VIO_CPTR						-1	5
ERROR_VIO_LPTR						-1	5
ERROR_VIO_MODE						-1	5
ERROR_VIO_WIDTH 					-1	5
ERROR_VIO_ATTR						-1	5
ERROR_VIO_ROW						-1	5
ERROR_VIO_COL						-1	5
ERROR_VIO_TOPROW					-1	5
ERROR_VIO_BOTROW					-1	5
ERROR_VIO_RIGHTCOL					-1	5
ERROR_VIO_LEFTCOL					-1	5
ERROR_SCS_CALL						-1	5
ERROR_SCS_VALUE 					-1	5
ERROR_VIO_WAIT_FLAG					-1	5
ERROR_VIO_UNLOCK					-1	5
ERROR_SGS_NOT_SESSION_MGR				-1	5
ERROR_SMG_INVALID_SGID					-1	5
ERROR_SMG_INVALID_SESSION_ID				-1	5
ERROR_SMG_NOSG						-1	5
ERROR_SMG_NO_SESSIONS					-1	5
ERROR_SMG_GRP_NOT_FOUND 				-1	5
ERROR_SMG_SESSION_NOT_FOUND				-1	5
ERROR_SMG_SET_TITLE					-1	5
ERROR_KBD_PARAMETER					-1	5
ERROR_KBD_NO_DEVICE					-1	5
ERROR_KBD_INVALID_IOWAIT				-1	5
ERROR_KBD_INVALID_LENGTH				-1	5
ERROR_KBD_INVALID_ECHO_MASK				-1	5
ERROR_KBD_INVALID_INPUT_MASK				-1	5
ERROR_MON_INVALID_PARMS 				-1	5
ERROR_MON_INVALID_DEVNAME				-1	5
ERROR_MON_INVALID_HANDLE				-1	5
ERROR_MON_BUFFER_TOO_SMALL				-1	5
ERROR_MON_BUFFER_EMPTY					-1	5
ERROR_MON_DATA_TOO_LARGE				-1	5
ERROR_MOUSE_NO_DEVICE					-1	5
ERROR_MOUSE_INV_HANDLE					-1	5
ERROR_MOUSE_INV_PARMS					-1	5
ERROR_MOUSE_CANT_RESET					-1	5
ERROR_MOUSE_DISPLAY_PARMS				-1	5
ERROR_MOUSE_INV_MODULE					-1	5
ERROR_MOUSE_INV_ENTRY_PT				-1	5
ERROR_MOUSE_INV_MASK					-1	5
NO_ERROR_MOUSE_NO_DATA					-1	5
NO_ERROR_MOUSE_PTR_DRAWN				-1	5
ERROR_INVALID_FREQUENCY 				-1	5
ERROR_NLS_NO_COUNTRY_FILE				-1	5
ERROR_NLS_OPEN_FAILED					-1	5
ERROR_NLS_NO_CTRY_CODE					-1	5
ERROR_NO_COUNTRY_OR_CODEPAGE				-1	5
ERROR_NLS_TABLE_TRUNCATED				-1	5
ERROR_NLS_BAD_TYPE					-1	5
ERROR_NLS_TYPE_NOT_FOUND				-1	5
ERROR_VIO_SMG_ONLY					-1	5
ERROR_VIO_INVALID_ASCIIZ				-1	5
ERROR_VIO_DEREGISTER					-1	5
ERROR_VIO_NO_POPUP					-1	5
ERROR_VIO_EXISTING_POPUP				-1	5
ERROR_KBD_SMG_ONLY					-1	5
ERROR_KBD_INVALID_ASCIIZ				-1	5
ERROR_KBD_INVALID_MASK					-1	5
ERROR_KBD_REGISTER					-1	5
ERROR_KBD_DEREGISTER					-1	5
ERROR_KBD_DEREGISTER					-1	5
ERROR_MOUSE_SMG_ONLY					-1	5
ERROR_MOUSE_INVALID_ASCIIZ				-1	5
ERROR_MOUSE_INVALID_MASK				-1	5
ERROR_MOUSE_REGISTER					-1	5
ERROR_MOUSE_DEREGISTER					-1	5
ERROR_SMG_BAD_ACTION					-1	5
ERROR_SMG_INVALID_CALL					-1	5
ERROR_SCS_SG_NOTFOUND					-1	5
ERROR_SCS_NOT_SHELL					-1	5
ERROR_VIO_INVALID_PARMS 				-1	5
ERROR_VIO_FUNCTION_OWNED				-1	5
ERROR_VIO_RETURN					-1	5
ERROR_SCS_INVALID_FUNCTION				-1	5
ERROR_SCS_NOT_SESSION_MGR				-1	5
ERROR_VIO_REGISTER					-1	5
ERROR_VIO_NO_MODE_THREAD				-1	5
ERROR_VIO_NO_SAVE_RESTORE_THD				-1	5
ERROR_VIO_IN_BG 					-1	5
ERROR_VIO_ILLEGAL_DURING_POPUP				-1	5
ERROR_SMG_NOT_BASESHELL 				-1	5
ERROR_SMG_BAD_STATUSREQ 				-1	5
ERROR_QUE_INVALID_WAIT					-1	5
ERROR_VIO_LOCK						-1	5
ERROR_MOUSE_INVALID_IOWAIT				-1	5
ERROR_VIO_INVALID_HANDLE				-1	5
ERROR_VIO_ILLEGAL_DURING_LOCK				-1	5
ERROR_VIO_INVALID_LENGTH				-1	5
ERROR_KBD_INVALID_HANDLE				-1	5
ERROR_KBD_NO_MORE_HANDLE				-1	5
ERROR_KBD_CANNOT_CREATE_KCB				-1	5
ERROR_KBD_CODEPAGE_LOAD_INCOMPL 			-1	5
ERROR_KBD_INVALID_CODEPAGE_ID				-1	5
ERROR_KBD_NO_CODEPAGE_SUPPORT				-1	5
ERROR_KBD_FOCUS_REQUIRED				-1	5
ERROR_KBD_FOCUS_ALREADY_ACTIVE				-1	5
ERROR_KBD_KEYBOARD_BUSY 				-1	5
ERROR_KBD_INVALID_CODEPAGE				-1	5
ERROR_KBD_UNABLE_TO_FOCUS				-1	5
ERROR_SMG_SESSION_NON_SELECT				-1	5
ERROR_SMG_SESSION_NOT_FOREGRND				-1	5
ERROR_SMG_SESSION_NOT_PARENT				-1	5
ERROR_SMG_INVALID_START_MODE				-1	5
ERROR_SMG_INVALID_RELATED_OPT				-1	5
ERROR_SMG_INVALID_BOND_OPTION				-1	5
ERROR_SMG_INVALID_SELECT_OPT				-1	5
ERROR_SMG_START_IN_BACKGROUND				-1	5
ERROR_SMG_INVALID_STOP_OPTION				-1	5
ERROR_SMG_BAD_RESERVE					-1	5
ERROR_SMG_PROCESS_NOT_PARENT				-1	5
ERROR_SMG_INVALID_DATA_LENGTH				-1	5
ERROR_SMG_NOT_BOUND					-1	5
ERROR_SMG_RETRY_SUB_ALLOC				-1	5
ERROR_KBD_DETACHED					-1	5
ERROR_VIO_DETACHED					-1	5
ERROR_MOU_DETACHED					-1	5
ERROR_VIO_FONT						-1	5
ERROR_VIO_USER_FONT					-1	5
ERROR_VIO_BAD_CP					-1	5
ERROR_VIO_NO_CP 					-1	5
ERROR_VIO_NA_CP 					-1	5
ERROR_INVALID_CODE_PAGE 				-1	5
ERROR_CPLIST_TOO_SMALL					-1	5
ERROR_CP_NOT_MOVED					-1	5
ERROR_MODE_SWITCH_INIT					-1	5
ERROR_CODE_PAGE_NOT_FOUND				-1	5
ERROR_UNEXPECTED_SLOT_RETURNED				-1	5
ERROR_SMG_INVALID_TRACE_OPTION				-1	5
ERROR_VIO_INTERNAL_RESOURCE				-1	5
ERROR_VIO_SHELL_INIT					-1	5
ERROR_SMG_NO_HARD_ERRORS				-1	5
ERROR_CP_SWITCH_INCOMPLETE				-1	5
ERROR_VIO_TRANSPARENT_POPUP				-1	5
ERROR_CRITSEC_OVERFLOW					-1	5
ERROR_CRITSEC_UNDERFLOW 				-1	5
ERROR_VIO_BAD_RESERVE					-1	5
ERROR_INVALID_ADDRESS					-1	5
ERROR_ZERO_SELECTORS_REQUESTED				-1	5
ERROR_NOT_ENOUGH_SELECTORS_AVA				-1	5
ERROR_INVALID_SELECTOR					-1	5
ERROR_SMG_INVALID_PROGRAM_TYPE				-1	5
ERROR_SMG_INVALID_PGM_CONTROL				-1	5
ERROR_SMG_INVALID_INHERIT_OPT				-1	5
ERROR_VIO_EXTENDED_SG					-1	5
ERROR_VIO_NOT_PRES_MGR_SG				-1	5
ERROR_VIO_SHIELD_OWNED					-1	5
ERROR_VIO_NO_MORE_HANDLES				-1	5
ERROR_VIO_SEE_ERROR_LOG 				-1	5
ERROR_VIO_ASSOCIATED_DC 				-1	5
ERROR_KBD_NO_CONSOLE					-1	5
ERROR_MOUSE_NO_CONSOLE					-1	5
ERROR_MOUSE_INVALID_HANDLE				-1	5
ERROR_SMG_INVALID_DEBUG_PARMS				-1	5
ERROR_KBD_EXTENDED_SG					-1	5
ERROR_MOU_EXTENDED_SG					-1	5
ERROR_SMG_INVALID_ICON_FILE				-1	5
ERROR_TRC_PID_NON_EXISTENT				-1	5
ERROR_TRC_COUNT_ACTIVE					-1	5
ERROR_TRC_SUSPENDED_BY_COUNT				-1	5
ERROR_TRC_COUNT_INACTIVE				-1	5
ERROR_TRC_COUNT_REACHED 				-1	5
ERROR_NO_MC_TRACE					-1	5
ERROR_MC_TRACE						-1	5
ERROR_TRC_COUNT_ZERO					-1	5
ERROR_SMG_TOO_MANY_DDS					-1	5
ERROR_SMG_INVALID_NOTIFICATION				-1	5
ERROR_LF_INVALID_FUNCTION				-1	5
ERROR_LF_NOT_AVAIL					-1	5
ERROR_LF_SUSPENDED					-1	5
ERROR_LF_BUF_TOO_SMALL					-1	5
ERROR_LF_BUFFER_CORRUPTED				-1	5
ERROR_LF_BUFFER_FULL					-1	5
ERROR_LF_INVALID_DAEMON 				-1	5
ERROR_LF_INVALID_RECORD 				-1	5
ERROR_LF_INVALID_TEMPL					-1	5
ERROR_LF_INVALID_SERVICE				-1	5
ERROR_LF_GENERAL_FAILURE				-1	5
ERROR_LF_INVALID_ID					-1	5
ERROR_LF_INVALID_HANDLE 				-1	5
ERROR_LF_NO_ID_AVAIL					-1	5
ERROR_LF_TEMPLATE_AREA_FULL				-1	5
ERROR_LF_ID_IN_USE					-1	5
ERROR_MOU_NOT_INITIALIZED				-1	5
ERROR_MOUINITREAL_DONE					-1	5
ERROR_DOSSUB_CORRUPTED					-1	5
ERROR_MOUSE_CALLER_NOT_SUBSYS				-1	5
ERROR_ARITHMETIC_OVERFLOW				-1	5
ERROR_TMR_NO_DEVICE					-1	5
ERROR_TMR_INVALID_TIME					-1	5
ERROR_PVW_INVALID_ENTITY				-1	5
ERROR_PVW_INVALID_ENTITY_TYPE				-1	5
ERROR_PVW_INVALID_SPEC					-1	5
ERROR_PVW_INVALID_RANGE_TYPE				-1	5
ERROR_PVW_INVALID_COUNTER_BLK				-1	5
ERROR_PVW_INVALID_TEXT_BLK				-1	5
ERROR_PRF_NOT_INITIALIZED				-1	5
ERROR_PRF_ALREADY_INITIALIZED				-1	5
ERROR_PRF_NOT_STARTED					-1	5
ERROR_PRF_ALREADY_STARTED				-1	5
ERROR_PRF_TIMER_OUT_OF_RANGE				-1	5
ERROR_PRF_TIMER_RESET					-1	5
ERROR_VDD_LOCK_USEAGE_DENIED				-1	5
ERROR_TIMEOUT						-1	5
ERROR_VDM_DOWN						-1	5
ERROR_VDM_LIMIT 					-1	5
ERROR_VDD_NOT_FOUND					-1	5
ERROR_INVALID_CALLER					-1	5
ERROR_PID_MISMATCH					-1	5
ERROR_INVALID_VDD_HANDLE				-1	5
ERROR_VLPT_NO_SPOOLER					-1	5
ERROR_VCOM_DEVICE_BUSY					-1	5
ERROR_VLPT_DEVICE_BUSY					-1	5
ERROR_NESTING_TOO_DEEP					-1	5
ERROR_VDD_MISSING					-1	5
ERROR_BIDI_INVALID_LENGTH				-1	5
ERROR_BIDI_INVALID_INCREMENT				-1	5
ERROR_BIDI_INVALID_COMBINATION				-1	5
ERROR_BIDI_INVALID_RESERVED				-1	5
ERROR_BIDI_INVALID_EFFECT				-1	5
ERROR_BIDI_INVALID_CSDREC				-1	5
ERROR_BIDI_INVALID_CSDSTATE				-1	5
ERROR_BIDI_INVALID_LEVEL				-1	5
ERROR_BIDI_INVALID_TYPE_SUPPORT 			-1	5
ERROR_BIDI_INVALID_ORIENTATION				-1	5
ERROR_BIDI_INVALID_NUM_SHAPE				-1	5
ERROR_BIDI_INVALID_CSD					-1	5
ERROR_BIDI_NO_SUPPORT					-1	5
NO_ERROR_BIDI_RW_INCOMPLETE				-1	5
ERROR_IMP_INVALID_PARM					-1	5
ERROR_IMP_INVALID_LENGTH				-1	5
MSG_HPFS_DISK_ERROR_WARN				-1	5
ERROR_MON_BAD_BUFFER					-1	5
ERROR_MODULE_CORRUPTED					-1	5
ERROR_SM_OUTOF_SWAPFILE 				-1	5
ERROR_LF_TIMEOUT					-1	5
ERROR_LF_SUSPEND_SUCCESS				-1	5
ERROR_LF_RESUME_SUCCESS 				-1	5
ERROR_LF_REDIRECT_SUCCESS				-1	5
ERROR_LF_REDIRECT_FAILURE				-1	5
ERROR_SWAPPER_NOT_ACTIVE				-1	5
ERROR_INVALID_SWAPID					-1	5
ERROR_IOERR_SWAP_FILE					-1	5
ERROR_SWAP_TABLE_FULL					-1	5
ERROR_SWAP_FILE_FULL					-1	5
ERROR_CANT_INIT_SWAPPER 				-1	5
ERROR_SWAPPER_ALREADY_INIT				-1	5
ERROR_PMM_INSUFFICIENT_MEMORY				-1	5
ERROR_PMM_INVALID_FLAGS 				-1	5
ERROR_PMM_INVALID_ADDRESS				-1	5
ERROR_PMM_LOCK_FAILED					-1	5
ERROR_PMM_UNLOCK_FAILED 				-1	5
ERROR_PMM_MOVE_INCOMPLETE				-1	5
ERROR_UCOM_DRIVE_RENAMED				-1	5
ERROR_UCOM_FILENAME_TRUNCATED				-1	5
ERROR_UCOM_BUFFER_LENGTH				-1	5
ERROR_MON_CHAIN_HANDLE					-1	5
ERROR_MON_NOT_REGISTERED				-1	5
ERROR_SMG_ALREADY_TOP					-1	5
ERROR_PMM_ARENA_MODIFIED				-1	5
ERROR_SMG_PRINTER_OPEN					-1	5
ERROR_PMM_SET_FLAGS_FAILED				-1	5
ERROR_INVALID_DOS_DD					-1	5
ERROR_BLOCKED						-1	5
ERROR_NOBLOCK						-1	5
ERROR_INSTANCE_SHARED					-1	5
ERROR_NO_OBJECT 					-1	5
ERROR_PARTIAL_ATTACH					-1	5
ERROR_INCACHE						-1	5
ERROR_SWAP_IO_PROBLEMS					-1	5
ERROR_CROSSES_OBJECT_BOUNDARY				-1	5
ERROR_LONGLOCK						-1	5
ERROR_SHORTLOCK 					-1	5
ERROR_UVIRTLOCK 					-1	5
ERROR_ALIASLOCK 					-1	5
ERROR_ALIAS						-1	5
ERROR_NO_MORE_HANDLES					-1	5
ERROR_SCAN_TERMINATED					-1	5
ERROR_TERMINATOR_NOT_FOUND				-1	5
ERROR_NOT_DIRECT_CHILD					-1	5
ERROR_DELAY_FREE					-1	5
ERROR_GUARDPAGE 					-1	5
ERROR_SWAPERROR 					-1	5
ERROR_LDRERROR						-1	5
ERROR_NOMEMORY						-1	5
ERROR_NOACCESS						-1	5
ERROR_NO_DLL_TERM					-1	5
ERROR_CPSIO_CODE_PAGE_INVALID				-1	5
ERROR_CPSIO_NO_SPOOLER					-1	5
ERROR_CPSIO_FONT_ID_INVALID				-1	5
ERROR_CPSIO_INTERNAL_ERROR				-1	5
ERROR_CPSIO_INVALID_PTR_NAME				-1	5
ERROR_CPSIO_NOT_ACTIVE					-1	5
ERROR_CPSIO_PID_FULL					-1	5
ERROR_CPSIO_PID_NOT_FOUND				-1	5
ERROR_CPSIO_READ_CTL_SEQ				-1	5
ERROR_CPSIO_READ_FNT_DEF				-1	5
ERROR_CPSIO_WRITE_ERROR 				-1	5
ERROR_CPSIO_WRITE_FULL_ERROR				-1	5
ERROR_CPSIO_WRITE_HANDLE_BAD				-1	5
ERROR_CPSIO_SWIT_LOAD					-1	5
ERROR_CPSIO_INV_COMMAND 				-1	5
ERROR_CPSIO_NO_FONT_SWIT				-1	5
ERROR_ENTRY_IS_CALLGATE 				-1	5
__BSEMEMF__						-1	5
PAG_READ						-1	5
PAG_WRITE						-1	5
PAG_EXECUTE						-1	5
PAG_GUARD						-1	5
PAG_DEFAULT						-1	5
PAG_COMMIT						-1	5
PAG_DECOMMIT						-1	5
OBJ_TILE						-1	5
OBJ_PROTECTED						-1	5
OBJ_GETTABLE						-1	5
OBJ_GIVEABLE						-1	5
fPERM							-1	5
fSHARE							-1	5
fALLOC							-1	5
fALLOCSHR						-1	5
fGETNMSHR						-1	5
fGETSHR 						-1	5
fGIVESHR						-1	5
fSET							-1	5
DOSSUB_INIT						-1	5
DOSSUB_GROW						-1	5
DOSSUB_SPARSE_OBJ					-1	5
DOSSUB_SERIALIZE					-1	5
PAG_SHARED						-1	5
PAG_FREE						-1	5
PAG_BASE						-1	5
__BSEORD__						-1	5
ORD_ANSIINJECT						-1	5
ORD_ANSIKEYDEF						-1	5
ORD_ANSIINTERP						-1	5
ORD_NLSCONVERTBIDINUMERICS				-1	5
ORD_NLSCONVERTBIDISTRING				-1	5
ORD_NLSSETBIDIATT					-1	5
ORD_NLSQUERYBIDIATT					-1	5
ORD_NLSINVERSESTRING					-1	5
ORD_NLSSETBIDIPRINT					-1	5
ORD_NLSEDITSHAPE					-1	5
ORD_NLSSHAPEBIDISTRING					-1	5
ORD_NLSINTSETBIDIATT					-1	5
ORD_NLSINTQUERYBIDIATT					-1	5
ORD_NLPOPUP						-1	5
ORD_BKSMAIN						-1	5
ORD_BKSMAIN						-1	5
ORD_BKSMAIN						-1	5
ORD_DRGACCESSDRAGINFO					-1	5
ORD_DRGADDSTRHANDLE					-1	5
ORD_DRGALLOCDRAGINFO					-1	5
ORD_DRGALLOCDRAGTRANSFER				-1	5
ORD_DRGDELETEDRAGINFOSTRHANDLES 			-1	5
ORD_DRGDELETESTRHANDLE					-1	5
ORD_DRGDRAG						-1	5
ORD_DRGFREEDRAGINFO					-1	5
ORD_DRGFREEDRAGTRANSFER 				-1	5
ORD_DRGGETPS						-1	5
ORD_DRGPOSTTRANSFERMSG					-1	5
ORD_DRGPUSHDRAGINFO					-1	5
ORD_DRGQUERYDRAGITEM					-1	5
ORD_DRGQUERYDRAGITEMCOUNT				-1	5
ORD_DRGQUERYDRAGITEMPTR 				-1	5
ORD_DRGQUERYNATIVERMF					-1	5
ORD_DRGQUERYNATIVERMFLEN				-1	5
ORD_DRGQUERYSTRNAME					-1	5
ORD_DRGQUERYSTRNAMELEN					-1	5
ORD_DRGQUERYTRUETYPE					-1	5
ORD_DRGQUERYTRUETYPELEN 				-1	5
ORD_DRGRELEASEPS					-1	5
ORD_DRGSENDTRANSFERMSG					-1	5
ORD_DRGSETDRAGPOINTER					-1	5
ORD_DRGSETDRAGIMAGE					-1	5
ORD_DRGSETDRAGITEM					-1	5
ORD_DRGVERIFYNATIVERMF					-1	5
ORD_DRGVERIFYRMF					-1	5
ORD_DRGVERIFYTRUETYPE					-1	5
ORD_DRGVERIFYTYPE					-1	5
ORD_DRGVERIFYTYPESET					-1	5
ORD_DRGDRAGFILES					-1	5
ORD_DRGACCEPTDROPPEDFILES				-1	5
ORD_DRG32ACCESSDRAGINFO 				-1	5
ORD_DRG32ADDSTRHANDLE					-1	5
ORD_DRG32ALLOCDRAGINFO					-1	5
ORD_DRG32ALLOCDRAGTRANSFER				-1	5
ORD_DRG32DELETEDRAGINFOSTRHANDLES			-1	5
ORD_DRG32DELETESTRHANDLE				-1	5
ORD_DRG32DRAG						-1	5
ORD_DRG32FREEDRAGINFO					-1	5
ORD_DRG32FREEDRAGTRANSFER				-1	5
ORD_DRG32GETPS						-1	5
ORD_DRG32POSTTRANSFERMSG				-1	5
ORD_DRG32PUSHDRAGINFO					-1	5
ORD_DRG32QUERYDRAGITEM					-1	5
ORD_DRG32QUERYDRAGITEMCOUNT				-1	5
ORD_DRG32QUERYDRAGITEMPTR				-1	5
ORD_DRG32QUERYNATIVERMF 				-1	5
ORD_DRG32QUERYNATIVERMFLEN				-1	5
ORD_DRG32QUERYSTRNAME					-1	5
ORD_DRG32QUERYSTRNAMELEN				-1	5
ORD_DRG32QUERYTRUETYPE					-1	5
ORD_DRG32QUERYTRUETYPELEN				-1	5
ORD_DRG32RELEASEPS					-1	5
ORD_DRG32SENDTRANSFERMSG				-1	5
ORD_DRG32SETDRAGPOINTER 				-1	5
ORD_DRG32SETDRAGIMAGE					-1	5
ORD_DRG32SETDRAGITEM					-1	5
ORD_DRG32VERIFYNATIVERMF				-1	5
ORD_DRG32VERIFYRMF					-1	5
ORD_DRG32VERIFYTRUETYPE 				-1	5
ORD_DRG32VERIFYTYPE					-1	5
ORD_DRG32VERIFYTYPESET					-1	5
ORD_DRG32DRAGFILES					-1	5
ORD_DRG32ACCEPTDROPPEDFILES				-1	5
ORD_FKAINIT						-1	5
ORD_QUERYFKADISPLAYDETAILS				-1	5
ORD_WINFKAWNDPROC					-1	5
ORD_WINLOADFKA						-1	5
ORD_WINCREATEFKA					-1	5
ORD_WINSETFKAFORM					-1	5
ORD_WINQUERYFKAFORM					-1	5
ORD_WINGOTOFKA						-1	5
ORD_WINGOFROMFKA					-1	5
ORD_WINCREATEHELPINSTANCE				-1	5
ORD_WINDESTROYHELPINSTANCE				-1	5
ORD_WINQUERYHELPINSTANCE				-1	5
ORD_WINASSOCIATEHELPINSTANCE				-1	5
ORD_WINLOADHELPTABLE					-1	5
ORD_WINCREATEHELPTABLE					-1	5
ORD_WIN32CREATEHELPINSTANCE				-1	5
ORD_WIN32DESTROYHELPINSTANCE				-1	5
ORD_WIN32QUERYHELPINSTANCE				-1	5
ORD_WIN32ASSOCIATEHELPINSTANCE				-1	5
ORD_WIN32LOADHELPTABLE					-1	5
ORD_WIN32CREATEHELPTABLE				-1	5
ORD_DDFINITIALIZE					-1	5
ORD_DDFPARA						-1	5
ORD_DDFSETFORMAT					-1	5
ORD_DDFSETTEXTALIGN					-1	5
ORD_DDFSETCOLOR 					-1	5
ORD_DDFINFORM						-1	5
ORD_DDFSETFONTSTYLE					-1	5
ORD_DDFHYPERTEXT					-1	5
ORD_DDFBEGINLIST					-1	5
ORD_DDFLISTITEM 					-1	5
ORD_DDFENDLIST						-1	5
ORD_DDFTEXT						-1	5
ORD_DDFMETAFILE 					-1	5
ORD_DDFSETFONT						-1	5
ORD_DDFBITMAP						-1	5
ORD_KBDSETCUSTXT					-1	5
ORD_KBDGETCP						-1	5
ORD_KBDCHARIN						-1	5
ORD_KBDSETCP						-1	5
ORD_KBDSYNCH						-1	5
ORD_KBDREGISTER 					-1	5
ORD_KBDSTRINGIN 					-1	5
ORD_KBDGETSTATUS					-1	5
ORD_KBDSETSTATUS					-1	5
ORD_KBDGETFOCUS 					-1	5
ORD_KBDFLUSHBUFFER					-1	5
ORD_KBDXLATE						-1	5
ORD_KBDCLOSE						-1	5
ORD_KBDFREEFOCUS					-1	5
ORD_KBDDEREGISTER					-1	5
ORD_KBDSETFGND						-1	5
ORD_KBDPEEK						-1	5
ORD_KBDOPEN						-1	5
ORD_KBDGETHWID						-1	5
ORD_KBDSETHWID						-1	5
ORD_DOSMONOPEN						-1	5
ORD_DOSMONCLOSE 					-1	5
ORD_DOSMONREAD						-1	5
ORD_DOSMONWRITE 					-1	5
ORD_DOSMONREG						-1	5
ORD_MOUGETPTRSHAPE					-1	5
ORD_MOUSETPTRSHAPE					-1	5
ORD_MOUGETNUMMICKEYS					-1	5
ORD_MOUGETHOTKEY					-1	5
ORD_MOUGETSCALEFACT					-1	5
ORD_MOUFLUSHQUE 					-1	5
ORD_MOUGETNUMBUTTONS					-1	5
ORD_MOUCLOSE						-1	5
ORD_MOUSETHOTKEY					-1	5
ORD_MOUSETSCALEFACT					-1	5
ORD_MOUGETNUMQUEEL					-1	5
ORD_MOUDEREGISTER					-1	5
ORD_MOUGETEVENTMASK					-1	5
ORD_MOUSETEVENTMASK					-1	5
ORD_MOUOPEN						-1	5
ORD_MOUREMOVEPTR					-1	5
ORD_MOUGETPTRPOS					-1	5
ORD_MOUREADEVENTQUE					-1	5
ORD_MOUSETPTRPOS					-1	5
ORD_MOUGETDEVSTATUS					-1	5
ORD_MOUSYNCH						-1	5
ORD_MOUREGISTER 					-1	5
ORD_MOUSETDEVSTATUS					-1	5
ORD_MOUDRAWPTR						-1	5
ORD_MOUINITREAL 					-1	5
ORD_MOUGETTHRESHOLD					-1	5
ORD_MOUSETTHRESHOLD					-1	5
ORD_DOSPUTMESSAGE					-1	5
ORD_DOSTRUEGETMESSAGE					-1	5
ORD_DOSINSMESSAGE					-1	5
ORD_DOS32INSERTMESSAGE					-1	5
ORD_DOS32PUTMESSAGE					-1	5
ORD_DOS32TRUEGETMESSAGE 				-1	5
ORD_DOSIQUERYMESSAGECP					-1	5
ORD_DOS32IQUERYMESSAGECP				-1	5
ORD_DOSCASEMAP						-1	5
ORD_DOSGETCOLLATE					-1	5
ORD_DOSGETCTRYINFO					-1	5
ORD_DOSGETDBCSEV					-1	5
ORD_DOS32QUERYCTRYINFO					-1	5
ORD_DOS32QUERYDBCSENV					-1	5
ORD_DOS32MAPCASE					-1	5
ORD_DOS32QUERYCOLLATE					-1	5
ORD_DOSMAKENMPIPE					-1	5
ORD_DOSQNMPIPEINFO					-1	5
ORD_DOSCONNECTNMPIPE					-1	5
ORD_DOSDISCONNECTNMPIPE 				-1	5
ORD_DOSQNMPHANDSTATE					-1	5
ORD_DOSSETNMPHANDSTATE					-1	5
ORD_DOSPEEKNMPIPE					-1	5
ORD_DOSWAITNMPIPE					-1	5
ORD_DOSTRANSACTNMPIPE					-1	5
ORD_DOSCALLNMPIPE					-1	5
ORD_DOSRAWREADNMPIPE					-1	5
ORD_DOSRAWWRITENMPIPE					-1	5
ORD_DOSSETNMPIPESEM					-1	5
ORD_DOSQNMPIPESEMSTATE					-1	5
ORD_DOSCWAIT						-1	5
ORD_DOSENTERCRITSEC					-1	5
ORD_DOSEXIT						-1	5
ORD_DOSEXITCRITSEC					-1	5
ORD_DOSEXITLIST 					-1	5
ORD_DOSGETINFOSEG					-1	5
ORD_DOSGETPRTY						-1	5
ORD_DOSKILLPROCESS					-1	5
ORD_DOSSETPRTY						-1	5
ORD_DOSPTRACE						-1	5
ORD_DOSHOLDSIGNAL					-1	5
ORD_DOSSETSIGHANDLER					-1	5
ORD_DOSFLAGPROCESS					-1	5
ORD_DOSMAKEPIPE 					-1	5
ORD_DOSSEMSETWAIT					-1	5
ORD_DOSMUXSEMWAIT					-1	5
ORD_DOSCLOSESEM 					-1	5
ORD_DOSCREATESEM					-1	5
ORD_DOSOPENSEM						-1	5
ORD_DOSRESUMETHREAD					-1	5
ORD_DOSSUSPENDTHREAD					-1	5
ORD_DOSSETDATETIME					-1	5
ORD_DOSTIMERASYNC					-1	5
ORD_DOSTIMERSTART					-1	5
ORD_DOSTIMERSTOP					-1	5
ORD_DOSSLEEP						-1	5
ORD_DOSGETDATETIME					-1	5
ORD_DOSALLOCSEG 					-1	5
ORD_DOSALLOCSHRSEG					-1	5
ORD_DOSGETSHRSEG					-1	5
ORD_DOSGIVESEG						-1	5
ORD_DOSREALLOCSEG					-1	5
ORD_DOSFREESEG						-1	5
ORD_DOSALLOCHUGE					-1	5
ORD_DOSGETHUGESHIFT					-1	5
ORD_DOSREALLOCHUGE					-1	5
ORD_DOSCREATECSALIAS					-1	5
ORD_DOSLOADMODULE					-1	5
ORD_DOSGETPROCADDR					-1	5
ORD_DOSFREEMODULE					-1	5
ORD_DOSGETMODHANDLE					-1	5
ORD_DOSGETMODNAME					-1	5
ORD_DOSGETMACHINEMODE					-1	5
ORD_DOSBEEP						-1	5
ORD_DOSCLIACCESS					-1	5
ORD_DOSDEVCONFIG					-1	5
ORD_DOSDEVIOCTL 					-1	5
ORD_DOSBUFRESET 					-1	5
ORD_DOSCHDIR						-1	5
ORD_DOSCHGFILEPTR					-1	5
ORD_DOSCLOSE						-1	5
ORD_DOSDELETE						-1	5
ORD_DOSDUPHANDLE					-1	5
ORD_DOSFILELOCKS					-1	5
ORD_DOSFINDCLOSE					-1	5
ORD_DOSFINDFIRST					-1	5
ORD_DOSFINDNEXT 					-1	5
ORD_DOSMKDIR						-1	5
ORD_DOSMOVE						-1	5
ORD_DOSNEWSIZE						-1	5
ORD_DOSPORTACCESS					-1	5
ORD_DOSOPEN						-1	5
ORD_DOSQCURDIR						-1	5
ORD_DOSQCURDISK 					-1	5
ORD_DOSQFHANDSTATE					-1	5
ORD_DOSQFILEINFO					-1	5
ORD_DOSQFILEMODE					-1	5
ORD_DOSQFSINFO						-1	5
ORD_DOSQHANDTYPE					-1	5
ORD_DOSQVERIFY						-1	5
ORD_DOSRMDIR						-1	5
ORD_DOSSELECTDISK					-1	5
ORD_DOSSETFHANDSTATE					-1	5
ORD_DOSSETFILEINFO					-1	5
ORD_DOSSETFILEMODE					-1	5
ORD_DOSSETMAXFH 					-1	5
ORD_DOSSETVERIFY					-1	5
ORD_DOSSYSTEMSERVICE					-1	5
ORD_DOSSETVEC						-1	5
ORD_DOSSYSTRACE 					-1	5
ORD_DOSGETENV						-1	5
ORD_DOSGETVERSION					-1	5
ORD_DOSGETPID						-1	5
ORD_DOSOPEN2						-1	5
ORD_DOSLIBINIT						-1	5
ORD_DOSSETFSINFO					-1	5
ORD_DOSQPATHINFO					-1	5
ORD_DOSDEVIOCTL2					-1	5
ORD_DOSSETPATHINFO					-1	5
ORD_DOSISETRELMAXFH					-1	5
ORD_DOSIDEVIOCTL					-1	5
ORD_DOS32FORCEDELETE					-1	5
ORD_DOS32KILLTHREAD					-1	5
ORD_DOSQUERYRASINFO					-1	5
ORD_DOSERROR						-1	5
ORD_DOSGETSEG						-1	5
ORD_DOSLOCKSEG						-1	5
ORD_DOSUNLOCKSEG					-1	5
ORD_DOSSIZESEG						-1	5
ORD_DOSMEMAVAIL 					-1	5
ORD_DOSPHYSICALDISK					-1	5
ORD_DOSGETCP						-1	5
ORD_DOSSENDSIGNAL					-1	5
ORD_DOSHUGESHIFT					-1	5
ORD_DOSHUGEINCR 					-1	5
ORD_DOSREAD						-1	5
ORD_DOSWRITE						-1	5
ORD_DOSERRCLASS 					-1	5
ORD_DOSSEMREQUEST					-1	5
ORD_DOSSEMCLEAR 					-1	5
ORD_DOSSEMWAIT						-1	5
ORD_DOSSEMSET						-1	5
ORD_DOSEXECPGM						-1	5
ORD_DOSCREATETHREAD					-1	5
ORD_DOSSUBSET						-1	5
ORD_DOSSUBALLOC 					-1	5
ORD_DOSSUBFREE						-1	5
ORD_DOSREADASYNC					-1	5
ORD_DOSWRITEASYNC					-1	5
ORD_DOSSEARCHPATH					-1	5
ORD_DOSSCANENV						-1	5
ORD_DOSSETCP						-1	5
ORD_DOSGETRESOURCE					-1	5
ORD_DOSGETPPID						-1	5
ORD_DOSCALLBACK 					-1	5
ORD_DOSR2STACKREALLOC					-1	5
ORD_DOSFSRAMSEMREQUEST					-1	5
ORD_DOSFSRAMSEMCLEAR					-1	5
ORD_DOSQAPPTYPE 					-1	5
ORD_DOSSETPROCCP					-1	5
ORD_DOSDYNAMICTRACE					-1	5
ORD_DOSQSYSINFO 					-1	5
ORD_DOSFSATTACH 					-1	5
ORD_DOSQFSATTACH					-1	5
ORD_DOSFSCTL						-1	5
ORD_DOSFINDFIRST2					-1	5
ORD_DOSMKDIR2						-1	5
ORD_DOSFILEIO						-1	5
ORD_DOSFINDNOTIFYCLOSE					-1	5
ORD_DOSFINDNOTIFYFIRST					-1	5
ORD_DOSFINDNOTIFYNEXT					-1	5
ORD_DOSEDITNAME 					-1	5
ORD_DOSCOPY						-1	5
ORD_DOSFORCEDELETE					-1	5
ORD_DOSENUMATTRIBUTE					-1	5
ORD_DOSSHUTDOWN 					-1	5
ORD_DOSGETRESOURCE2					-1	5
ORD_DOSFREERESOURCE					-1	5
ORD_DOS32SETMAXFH					-1	5
ORD_DOS32SETVERIFY					-1	5
ORD_DOS32ERRCLASS					-1	5
ORD_DOS32ERROR						-1	5
ORD_DOSMAXPATHLEN					-1	5
ORD_DOSPAGESIZE 					-1	5
ORD_DOSLOCALINFO					-1	5
ORD_DOSGLOBALINFO					-1	5
ORD_DOS32SETFILEINFO					-1	5
ORD_DOS32SETPATHINFO					-1	5
ORD_DOS32SETDEFAULTDISK 				-1	5
ORD_DOS32SETFHSTATE					-1	5
ORD_DOS32SETFSINFO					-1	5
ORD_DOS32QUERYPATHINFO					-1	5
ORD_DOS32QUERYHTYPE					-1	5
ORD_DOS32QUERYVERIFY					-1	5
ORD_DOS32DELETEDIR					-1	5
ORD_DOS32SCANENV					-1	5
ORD_DOS32SEARCHPATH					-1	5
ORD_DOS32SLEEP						-1	5
ORD_DOS32GETDATETIME					-1	5
ORD_DOS32DEVCONFIG					-1	5
ORD_DOS32ENTERCRITSEC					-1	5
ORD_DOS32EXITCRITSEC					-1	5
ORD_DOS32EXIT						-1	5
ORD_DOS32KILLPROCESS					-1	5
ORD_DOS32SETPRIORITY					-1	5
ORD_DOS32RESUMETHREAD					-1	5
ORD_DOS32SUSPENDTHREAD					-1	5
ORD_DOS32CREATEPIPE					-1	5
ORD_DOS32CALLNPIPE					-1	5
ORD_DOS32CONNECTNPIPE					-1	5
ORD_DOS32DISCONNECTNPIPE				-1	5
ORD_DOS32CREATENPIPE					-1	5
ORD_DOS32PEEKNPIPE					-1	5
ORD_DOS32QUERYNPHSTATE					-1	5
ORD_DOS32RAWREADNPIPE					-1	5
ORD_DOS32RAWWRITENPIPE					-1	5
ORD_DOS32QUERYNPIPEINFO 				-1	5
ORD_DOS32QUERYNPIPESEMSTATE				-1	5
ORD_DOS32SETNPHSTATE					-1	5
ORD_DOS32SETNPIPESEM					-1	5
ORD_DOS32TRANSACTNPIPE					-1	5
ORD_DOS32WAITNPIPE					-1	5
ORD_DOS32RESETBUFFER					-1	5
ORD_DOS32SETCURRENTDIR					-1	5
ORD_DOS32SETFILEPTR					-1	5
ORD_DOS32CLOSE						-1	5
ORD_DOS32COPY						-1	5
ORD_DOS32DELETE 					-1	5
ORD_DOS32DUPHANDLE					-1	5
ORD_DOS32EDITNAME					-1	5
ORD_DOS32FINDCLOSE					-1	5
ORD_DOS32FINDFIRST					-1	5
ORD_DOS32FINDNEXT					-1	5
ORD_DOSOPENVDD						-1	5
ORD_DOSREQUESTVDD					-1	5
ORD_DOSCLOSEVDD 					-1	5
ORD_DOS32FSATTACH					-1	5
ORD_DOS32CREATEDIR					-1	5
ORD_DOS32MOVE						-1	5
ORD_DOS32SETFILESIZE					-1	5
ORD_DOS32OPEN						-1	5
ORD_DOS32QUERYCURRENTDIR				-1	5
ORD_DOS32QUERYCURRENTDISK				-1	5
ORD_DOS32QUERYFHSTATE					-1	5
ORD_DOS32QUERYFSATTACH					-1	5
ORD_DOS32QUERYFSINFO					-1	5
ORD_DOS32QUERYFILEINFO					-1	5
ORD_DOS32WAITCHILD					-1	5
ORD_DOS32READ						-1	5
ORD_DOS32WRITE						-1	5
ORD_DOS32EXECPGM					-1	5
ORD_DOS32DEVIOCTL					-1	5
ORD_DOS32FSCTL						-1	5
ORD_DOS32BEEP						-1	5
ORD_DOS32PHYSICALDISK					-1	5
ORD_DOS32SETCP						-1	5
ORD_DOS32SETPROCESSCP					-1	5
ORD_DOS32STOPTIMER					-1	5
ORD_DOS32QUERYCP					-1	5
ORD_DOS32SETDATETIME					-1	5
ORD_DOS32EXITLIST					-1	5
ORD_DOS32ALLOCMEM					-1	5
ORD_DOS32ALLOCSHAREDMEM 				-1	5
ORD_DOS32GETNAMEDSHAREDMEM				-1	5
ORD_DOS32GETSHAREDMEM					-1	5
ORD_DOS32GIVESHAREDMEM					-1	5
ORD_DOS32FREEMEM					-1	5
ORD_DOS32SETMEM 					-1	5
ORD_DOS32QUERYMEM					-1	5
ORD_DOS32OPENVDD					-1	5
ORD_DOS32REQUESTVDD					-1	5
ORD_DOS32CLOSEVDD					-1	5
ORD_DOS32CREATETHREAD					-1	5
ORD_DOS32GETINFOBLOCKS					-1	5
ORD_DOS32DYNAMICTRACE					-1	5
ORD_DOS32DEBUG						-1	5
ORD_DOS32LOADMODULE					-1	5
ORD_DOS32QUERYMODULEHANDLE				-1	5
ORD_DOS32QUERYMODULENAME				-1	5
ORD_DOS32QUERYPROCADDR					-1	5
ORD_DOS32FREEMODULE					-1	5
ORD_DOS32QUERYAPPTYPE					-1	5
ORD_DOS32CREATEEVENTSEM 				-1	5
ORD_DOS32OPENEVENTSEM					-1	5
ORD_DOS32CLOSEEVENTSEM					-1	5
ORD_DOS32RESETEVENTSEM					-1	5
ORD_DOS32POSTEVENTSEM					-1	5
ORD_DOS32WAITEVENTSEM					-1	5
ORD_DOS32QUERYEVENTSEM					-1	5
ORD_DOS32CREATEMUTEXSEM 				-1	5
ORD_DOS32OPENMUTEXSEM					-1	5
ORD_DOS32CLOSEMUTEXSEM					-1	5
ORD_DOS32REQUESTMUTEXSEM				-1	5
ORD_DOS32RELEASEMUTEXSEM				-1	5
ORD_DOS32QUERYMUTEXSEM					-1	5
ORD_DOS32CREATEMUXWAITSEM				-1	5
ORD_DOS32OPENMUXWAITSEM 				-1	5
ORD_DOS32CLOSEMUXWAITSEM				-1	5
ORD_DOS32WAITMUXWAITSEM 				-1	5
ORD_DOS32ADDMUXWAITSEM					-1	5
ORD_DOS32DELETEMUXWAITSEM				-1	5
ORD_DOS32QUERYMUXWAITSEM				-1	5
ORD_DOS32SUBSETMEM					-1	5
ORD_DOS32SUBALLOCMEM					-1	5
ORD_DOS32SUBFREEMEM					-1	5
ORD_DOS32SUBUNSETMEM					-1	5
ORD_DOS32QUERYSYSINFO					-1	5
ORD_DOS32WAITTHREAD					-1	5
ORD_DOS32ASYNCTIMER					-1	5
ORD_DOS32STARTTIMER					-1	5
ORD_DOS32GETRESOURCE					-1	5
ORD_DOS32FREERESOURCE					-1	5
ORD_DOS32SETEXCEPTIONHANDLER				-1	5
ORD_DOS32UNSETEXCEPTIONHANDLER				-1	5
ORD_DOS32RAISEEXCEPTION 				-1	5
ORD_DOS32UNWINDEXCEPTION				-1	5
ORD_DOS32TMRQUERYFREQ					-1	5
ORD_DOS32TMRQUERYTIME					-1	5
ORD_DOS32REGISTERPERFCTRS				-1	5
ORD_DOS32ENUMATTRIBUTE					-1	5
ORD_DOS32QUERYDOSPROPERTY				-1	5
ORD_DOS32SETDOSPROPERTY 				-1	5
ORD_DOSQUERYDOSPROPERTY 				-1	5
ORD_DOSSETDOSPROPERTY					-1	5
ORD_DOS32PROFILE					-1	5
ORD_DOS32SETSIGNALEXCEPTIONFOC				-1	5
ORD_DOS32SENDSIGNALEXCEPTION				-1	5
ORD_DOS32ENTERMUSTCOMPLETE				-1	5
ORD_DOS32EXITMUSTCOMPLETE				-1	5
ORD_DOS32SETRELMAXFH					-1	5
ORD_DOS32SHUTDOWN					-1	5
ORD_DOS32REPLACEMODULE					-1	5
ORD_DOS32ACKNOWLEDGESIGNALEXC				-1	5
ORD_DOS32TIB						-1	5
ORD_DOSTMRQUERYFREQ					-1	5
ORD_DOSTMRQUERYTIME					-1	5
ORD_DOSREGISTERPERFCTRS 				-1	5
ORD_DOSFLATTOSEL					-1	5
ORD_DOSSELTOFLAT					-1	5
ORD_DOS32FLATTOSEL					-1	5
ORD_DOS32SELTOFLAT					-1	5
ORD_DOS32SETFILELOCKS					-1	5
ORD_DOS32CANCELLOCKREQUEST				-1	5
ORD_DOSOPENCHANGENOTIFY 				-1	5
ORD_DOSRESETCHANGENOTIFY				-1	5
ORD_DOSCLOSECHANGENOTIFY				-1	5
ORD_DOS32OPENCHANGENOTIFY				-1	5
ORD_DOS32RESETCHANGENOTIFY				-1	5
ORD_DOS32CLOSECHANGENOTIFY				-1	5
ORD_DOS32QUERYRESOURCESIZE				-1	5
ORD_DOSQUERYRESOURCESIZE				-1	5
ORD_DOS32INITIALIZEPORTHOLE				-1	5
ORD_DOS32QUERYHEADERINFO				-1	5
ORD_DOSINITIALIZEPORTHOLE				-1	5
ORD_DOSQUERYHEADERINFO					-1	5
ORD_DOS32QUERYPROCTYPE					-1	5
ORD_DOSQUERYPROCTYPE					-1	5
ORD_DOS32PROTECTSETFILEPTR				-1	5
ORD_DOSPROTECTCLOSE					-1	5
ORD_DOSPROTECTFILEIO					-1	5
ORD_DOSPROTECTFILELOCKS 				-1	5
ORD_DOSPROTECTNEWSIZE					-1	5
ORD_DOSPROTECTOPEN					-1	5
ORD_DOSPROTECTQFHANDSTATE				-1	5
ORD_DOSPROTECTSETFHANDSTATE				-1	5
ORD_DOSPROTECTQFILEINFO 				-1	5
ORD_DOSPROTECTSETFILEINFO				-1	5
ORD_DOSPROTECTCHGFILEPTR				-1	5
ORD_DOSPROTECTENUMATTRIBUTE				-1	5
ORD_DOS32PROTECTENUMATTRIBUTE				-1	5
ORD_DOS32PROTECTOPEN					-1	5
ORD_DOS32PROTECTCLOSE					-1	5
ORD_DOS32PROTECTSETFILELOCKS				-1	5
ORD_DOS32PROTECTSETFILESIZE				-1	5
ORD_DOS32PROTECTREAD					-1	5
ORD_DOS32PROTECTWRITE					-1	5
ORD_DOS32PROTECTSETFILEINFO				-1	5
ORD_DOS32PROTECTSETFHSTATE				-1	5
ORD_DOS32PROTECTQUERYFHSTATE				-1	5
ORD_DOS32PROTECTQUERYFILEINFO				-1	5
ORD_DEVOPENDC						-1	5
ORD_DEVCLOSEDC						-1	5
ORD_DEVPOSTDEVICEMODES					-1	5
ORD_DEVESCAPE						-1	5
ORD_DEVQUERYHARDCOPYCAPS				-1	5
ORD_DEVQUERYCAPS					-1	5
ORD_GPICREATEPS 					-1	5
ORD_GPIQUERYPS						-1	5
ORD_GPIDESTROYPS					-1	5
ORD_GPIRESETPS						-1	5
ORD_GPISAVEPS						-1	5
ORD_GPIRESTOREPS					-1	5
ORD_GPIASSOCIATE					-1	5
ORD_GPIERRORSEGMENTDATA 				-1	5
ORD_GPIERASE						-1	5
ORD_GPISETDRAWCONTROL					-1	5
ORD_GPIQUERYDRAWCONTROL 				-1	5
ORD_GPIDRAWCHAIN					-1	5
ORD_GPIDRAWFROM 					-1	5
ORD_GPIDRAWSEGMENT					-1	5
ORD_GPISETSTOPDRAW					-1	5
ORD_GPIQUERYSTOPDRAW					-1	5
ORD_GPIREMOVEDYNAMICS					-1	5
ORD_GPIDRAWDYNAMICS					-1	5
ORD_GPISETDRAWINGMODE					-1	5
ORD_GPIQUERYDRAWINGMODE 				-1	5
ORD_GPIGETDATA						-1	5
ORD_GPIPUTDATA						-1	5
ORD_GPISETPICKAPERTURESIZE				-1	5
ORD_GPIQUERYPICKAPERTURESIZE				-1	5
ORD_GPISETPICKAPERTUREPOSITION				-1	5
ORD_GPIQUERYPICKAPERTUREPOSITION			-1	5
ORD_GPISETTAG						-1	5
ORD_GPIQUERYTAG 					-1	5
ORD_GPICORRELATECHAIN					-1	5
ORD_GPICORRELATEFROM					-1	5
ORD_GPICORRELATESEGMENT 				-1	5
ORD_GPIRESETBOUNDARYDATA				-1	5
ORD_GPIQUERYBOUNDARYDATA				-1	5
ORD_GPIOPENSEGMENT					-1	5
ORD_GPICLOSESEGMENT					-1	5
ORD_GPIDELETESEGMENT					-1	5
ORD_GPIDELETESEGMENTS					-1	5
ORD_GPIQUERYSEGMENTNAMES				-1	5
ORD_GPISETINITIALSEGMENTATTRS				-1	5
ORD_GPIQUERYINITIALSEGMENTATTRS 			-1	5
ORD_GPISETSEGMENTATTRS					-1	5
ORD_GPIQUERYSEGMENTATTRS				-1	5
ORD_GPISETSEGMENTPRIORITY				-1	5
ORD_GPIQUERYSEGMENTPRIORITY				-1	5
ORD_GPISETEDITMODE					-1	5
ORD_GPIQUERYEDITMODE					-1	5
ORD_GPISETELEMENTPOINTER				-1	5
ORD_GPIQUERYELEMENTPOINTER				-1	5
ORD_GPIOFFSETELEMENTPOINTER				-1	5
ORD_GPIDELETEELEMENT					-1	5
ORD_GPIDELETEELEMENTRANGE				-1	5
ORD_GPILABEL						-1	5
ORD_GPISETELEMENTPOINTERATLABEL 			-1	5
ORD_GPIDELETEELEMENTSBETWEENLABELS			-1	5
ORD_GPIQUERYELEMENTTYPE 				-1	5
ORD_GPIQUERYELEMENT					-1	5
ORD_GPIELEMENT						-1	5
ORD_GPIBEGINELEMENT					-1	5
ORD_GPIENDELEMENT					-1	5
ORD_GPISETSEGMENTTRANSFORMMATRIX			-1	5
ORD_GPIQUERYSEGMENTTRANSFORMMATRIX			-1	5
ORD_GPISETMODELTRANSFORMMATRIX				-1	5
ORD_GPIQUERYMODELTRANSFORMMATRIX			-1	5
ORD_GPICALLSEGMENTMATRIX				-1	5
ORD_GPISETDEFAULTVIEWMATRIX				-1	5
ORD_GPIQUERYDEFAULTVIEWMATRIX				-1	5
ORD_GPISETPAGEVIEWPORT					-1	5
ORD_GPIQUERYPAGEVIEWPORT				-1	5
ORD_GPISETVIEWINGTRANSFORMMATRIX			-1	5
ORD_GPIQUERYVIEWINGTRANSFORMMATRIX			-1	5
ORD_GPISETGRAPHICSFIELD 				-1	5
ORD_GPIQUERYGRAPHICSFIELD				-1	5
ORD_GPISETVIEWINGLIMITS 				-1	5
ORD_GPIQUERYVIEWINGLIMITS				-1	5
ORD_GPICONVERT						-1	5
ORD_GPISETATTRMODE					-1	5
ORD_GPIQUERYATTRMODE					-1	5
ORD_GPIPOP						-1	5
ORD_GPISETATTRS 					-1	5
ORD_GPIQUERYATTRS					-1	5
ORD_GPICREATELOGCOLORTABLE				-1	5
ORD_GPIREALIZECOLORTABLE				-1	5
ORD_GPIUNREALIZECOLORTABLE				-1	5
ORD_GPIQUERYCOLORDATA					-1	5
ORD_GPIQUERYLOGCOLORTABLE				-1	5
ORD_GPIQUERYREALCOLORS					-1	5
ORD_GPIQUERYNEARESTCOLOR				-1	5
ORD_GPIQUERYCOLORINDEX					-1	5
ORD_GPIQUERYRGBCOLOR					-1	5
ORD_GPISETCOLOR 					-1	5
ORD_GPIQUERYCOLOR					-1	5
ORD_GPISETBACKCOLOR					-1	5
ORD_GPIQUERYBACKCOLOR					-1	5
ORD_GPISETMIX						-1	5
ORD_GPIQUERYMIX 					-1	5
ORD_GPISETBACKMIX					-1	5
ORD_GPIQUERYBACKMIX					-1	5
ORD_GPISETLINETYPE					-1	5
ORD_GPIQUERYLINETYPE					-1	5
ORD_GPISETLINEWIDTH					-1	5
ORD_GPIQUERYLINEWIDTH					-1	5
ORD_GPISETLINEWIDTHGEOM 				-1	5
ORD_GPIQUERYLINEWIDTHGEOM				-1	5
ORD_GPISETLINEEND					-1	5
ORD_GPIQUERYLINEEND					-1	5
ORD_GPISETLINEJOIN					-1	5
ORD_GPIQUERYLINEJOIN					-1	5
ORD_GPISETCURRENTPOSITION				-1	5
ORD_GPIQUERYCURRENTPOSITION				-1	5
ORD_GPIMOVE						-1	5
ORD_GPILINE						-1	5
ORD_GPIPOLYLINE 					-1	5
ORD_GPIBOX						-1	5
ORD_GPIPTVISIBLE					-1	5
ORD_GPIRECTVISIBLE					-1	5
ORD_GPISETARCPARAMS					-1	5
ORD_GPIQUERYARCPARAMS					-1	5
ORD_GPIPOINTARC 					-1	5
ORD_GPIFULLARC						-1	5
ORD_GPIPARTIALARC					-1	5
ORD_GPIPOLYFILLET					-1	5
ORD_GPIPOLYFILLETSHARP					-1	5
ORD_GPIPOLYSPLINE					-1	5
ORD_GPISETBITMAPID					-1	5
ORD_GPIQUERYBITMAPHANDLE				-1	5
ORD_GPISETPATTERNSET					-1	5
ORD_GPIQUERYPATTERNSET					-1	5
ORD_GPISETPATTERN					-1	5
ORD_GPIQUERYPATTERN					-1	5
ORD_GPISETPATTERNREFPOINT				-1	5
ORD_GPIQUERYPATTERNREFPOINT				-1	5
ORD_GPIBEGINAREA					-1	5
ORD_GPIENDAREA						-1	5
ORD_GPILOADFONTS					-1	5
ORD_GPIUNLOADFONTS					-1	5
ORD_GPICREATELOGFONT					-1	5
ORD_GPIDELETESETID					-1	5
ORD_GPIQUERYNUMBERSETIDS				-1	5
ORD_GPIQUERYSETIDS					-1	5
ORD_GPIQUERYFONTS					-1	5
ORD_GPIQUERYFONTMETRICS 				-1	5
ORD_GPIQUERYKERNINGPAIRS				-1	5
ORD_GPIQUERYWIDTHTABLE					-1	5
ORD_GPISETCP						-1	5
ORD_GPIQUERYCP						-1	5
ORD_GPIQUERYTEXTBOX					-1	5
ORD_DEVQUERYDEVICENAMES 				-1	5
ORD_GPIQUERYDEFCHARBOX					-1	5
ORD_GPIQUERYFONTFILEDESCRIPTIONS			-1	5
ORD_GPISETCHARSET					-1	5
ORD_GPIQUERYCHARSET					-1	5
ORD_GPISETCHARBOX					-1	5
ORD_GPIQUERYCHARBOX					-1	5
ORD_GPISETCHARANGLE					-1	5
ORD_GPIQUERYCHARANGLE					-1	5
ORD_GPISETCHARSHEAR					-1	5
ORD_GPIQUERYCHARSHEAR					-1	5
ORD_GPISETCHARDIRECTION 				-1	5
ORD_GPIQUERYCHARDIRECTION				-1	5
ORD_GPIQUERYCHARDIRECTION				-1	5
ORD_GPISETCHARMODE					-1	5
ORD_GPIQUERYCHARMODE					-1	5
ORD_GPICHARSTRING					-1	5
ORD_GPICHARSTRINGAT					-1	5
ORD_GPICHARSTRINGPOS					-1	5
ORD_GPICHARSTRINGPOSAT					-1	5
ORD_GPISETMARKERSET					-1	5
ORD_GPIQUERYMARKERSET					-1	5
ORD_GPISETMARKER					-1	5
ORD_GPIQUERYMARKER					-1	5
ORD_GPISETMARKERBOX					-1	5
ORD_GPIQUERYMARKERBOX					-1	5
ORD_GPIMARKER						-1	5
ORD_GPIPOLYMARKER					-1	5
ORD_GPIIMAGE						-1	5
ORD_GPICREATEBITMAP					-1	5
ORD_GPIDELETEBITMAP					-1	5
ORD_GPISETBITMAP					-1	5
ORD_GPISETBITMAPDIMENSION				-1	5
ORD_GPIQUERYBITMAPDIMENSION				-1	5
ORD_GPIQUERYDEVICEBITMAPFORMATS 			-1	5
ORD_GPIQUERYBITMAPPARAMETERS				-1	5
ORD_GPISETBITMAPBITS					-1	5
ORD_GPIQUERYBITMAPBITS					-1	5
ORD_GPIBITBLT						-1	5
ORD_GPISETPEL						-1	5
ORD_GPIQUERYPEL 					-1	5
ORD_GPICREATEREGION					-1	5
ORD_GPISETREGION					-1	5
ORD_GPIDESTROYREGION					-1	5
ORD_GPICOMBINEREGION					-1	5
ORD_GPIEQUALREGION					-1	5
ORD_GPIOFFSETREGION					-1	5
ORD_GPIPTINREGION					-1	5
ORD_GPIRECTINREGION					-1	5
ORD_GPIQUERYREGIONBOX					-1	5
ORD_GPIQUERYREGIONRECTS 				-1	5
ORD_GPISETCLIPREGION					-1	5
ORD_GPIQUERYCLIPREGION					-1	5
ORD_GPIQUERYCLIPBOX					-1	5
ORD_GPIINTERSECTCLIPRECTANGLE				-1	5
ORD_GPIEXCLUDECLIPRECTANGLE				-1	5
ORD_GPIOFFSETCLIPREGION 				-1	5
ORD_GPIPAINTREGION					-1	5
ORD_GPILOADMETAFILE					-1	5
ORD_GPICOPYMETAFILE					-1	5
ORD_GPIPLAYMETAFILE					-1	5
ORD_GPISAVEMETAFILE					-1	5
ORD_GPIDELETEMETAFILE					-1	5
ORD_GPIQUERYMETAFILEBITS				-1	5
ORD_GPISETMETAFILEBITS					-1	5
ORD_GPIQUERYMETAFILELENGTH				-1	5
ORD_GPISETCLIPPATH					-1	5
ORD_GPIBEGINPATH					-1	5
ORD_GPIENDPATH						-1	5
ORD_GPICLOSEFIGURE					-1	5
ORD_GPIMODIFYPATH					-1	5
ORD_GPIFILLPATH 					-1	5
ORD_GPISTARTREQUEST					-1	5
ORD_GPIQUERYDEVICE					-1	5
ORD_DEVSTDOPEN						-1	5
ORD_GPIQUERYCHARSTRINGPOS				-1	5
ORD_GPIQUERYCHARSTRINGPOSAT				-1	5
ORD_GPISETPS						-1	5
ORD_SEGSGWOPENSEGMENTWINDOW				-1	5
ORD_MTENDREADREQUEST					-1	5
ORD_MTGETDESCRIPTION					-1	5
ORD_FMTORDERTABLE					-1	5
ORD_MTGETCODEPAGE					-1	5
ORD_MTGETLCT						-1	5
ORD_MTGETGDDINFO					-1	5
ORD_FMTCONVERTGOCAPOLY					-1	5
ORD_MTGETFIRSTFONT					-1	5
ORD_SEGSGWNEWPARTDATA					-1	5
ORD_MTSTARTREADREQUEST					-1	5
ORD_MTGETFIRSTGRAPHICSDATA				-1	5
ORD_MTGETNEXTFONT					-1	5
ORD_MTGETNEXTGRAPHICSDATA				-1	5
ORD_GPILOADPUBLICFONTS					-1	5
ORD_GPIUNLOADPUBLICFONTS				-1	5
ORD_GPICOMMENT						-1	5
ORD_GPIWCBITBLT 					-1	5
ORD_GPISTROKEPATH					-1	5
ORD_SEGSGWNEXTORDERF					-1	5
ORD_GPIOUTLINEPATH					-1	5
ORD_GPISETDEFTAG					-1	5
ORD_GPIQUERYDEFTAG					-1	5
ORD_GPISETDEFATTRS					-1	5
ORD_GPIQUERYDEFATTRS					-1	5
ORD_GPISETDEFVIEWINGLIMITS				-1	5
ORD_GPIQUERYDEFVIEWINGLIMITS				-1	5
ORD_GPISETDEFARCPARAMS					-1	5
ORD_GPIQUERYDEFARCPARAMS				-1	5
ORD_GPITRANSLATE					-1	5
ORD_GPISCALE						-1	5
ORD_GPIROTATE						-1	5
ORD_GPIPOLYLINEDISJOINT 				-1	5
ORD_GPIPATHTOREGION					-1	5
ORD_GPIFLOODFILL					-1	5
ORD_GPIDRAWBITS 					-1	5
ORD_GPIQUERYBITMAPINFOHEADER				-1	5
ORD_GPIQUERYLOGICALFONT 				-1	5
ORD_GPIQUERYFACESTRING					-1	5
ORD_GPIQUERYFONTACTION					-1	5
ORD_GPICREATEPALETTE					-1	5
ORD_GPIDELETEPALETTE					-1	5
ORD_GPISELECTPALETTE					-1	5
ORD_GPIANIMATEPALETTE					-1	5
ORD_GPISETPALETTEENTRIES				-1	5
ORD_GPIQUERYPALETTE					-1	5
ORD_GPIQUERYPALETTEINFO 				-1	5
ORD_GPIQUERYCHAREXTRA					-1	5
ORD_GPISETCHAREXTRA					-1	5
ORD_GPIQUERYCHARBREAKEXTRA				-1	5
ORD_GPISETCHARBREAKEXTRA				-1	5
ORD_GPIFRAMEREGION					-1	5
ORD_GPICONVERTWITHMATRIX				-1	5
ORD_GPI32ASSOCIATE					-1	5
ORD_GPI32BEGINAREA					-1	5
ORD_GPI32BEGINELEMENT					-1	5
ORD_GPI32BEGINPATH					-1	5
ORD_GPI32BITBLT 					-1	5
ORD_GPI32BOX						-1	5
ORD_GPI32CALLSEGMENTMATRIX				-1	5
ORD_GPI32CHARSTRING					-1	5
ORD_GPI32CHARSTRINGAT					-1	5
ORD_GPI32CLOSEFIGURE					-1	5
ORD_GPI32CLOSESEGMENT					-1	5
ORD_GPI32COMBINEREGION					-1	5
ORD_GPI32COMMENT					-1	5
ORD_GPI32CONVERT					-1	5
ORD_GPI32COPYMETAFILE					-1	5
ORD_GPI32CORRELATECHAIN 				-1	5
ORD_GPI32CORRELATEFROM					-1	5
ORD_GPI32CREATELOGFONT					-1	5
ORD_GPI32CREATEPS					-1	5
ORD_GPI32CREATEREGION					-1	5
ORD_GPI32DELETEBITMAP					-1	5
ORD_GPI32DELETEELEMENT					-1	5
ORD_GPI32DELETEELEMENTRANGE				-1	5
ORD_GPI32DELETEELEMENTSBETWEENLABE			-1	5
ORD_GPI32DELETEMETAFILE 				-1	5
ORD_GPI32DELETESEGMENT					-1	5
ORD_GPI32DELETESEGMENTS 				-1	5
ORD_GPI32DELETESETID					-1	5
ORD_GPI32DESTROYPS					-1	5
ORD_GPI32DRAWCHAIN					-1	5
ORD_GPI32DRAWDYNAMICS					-1	5
ORD_GPI32DRAWFROM					-1	5
ORD_GPI32DRAWSEGMENT					-1	5
ORD_GPI32ELEMENT					-1	5
ORD_GPI32ENDAREA					-1	5
ORD_GPI32ENDELEMENT					-1	5
ORD_GPI32ENDPATH					-1	5
ORD_GPI32EQUALREGION					-1	5
ORD_GPI32ERASE						-1	5
ORD_GPI32ERRORSEGMENTDATA				-1	5
ORD_GPI32EXCLUDECLIPRECTANGLE				-1	5
ORD_GPI32FILLPATH					-1	5
ORD_GPI32FULLARC					-1	5
ORD_GPI32GETDATA					-1	5
ORD_GPI32IMAGE						-1	5
ORD_GPI32INTERSECTCLIPRECTANGLE 			-1	5
ORD_GPI32LABEL						-1	5
ORD_GPI32LINE						-1	5
ORD_GPI32LOADBITMAP					-1	5
ORD_GPI32LOADFONTS					-1	5
ORD_GPI32LOADMETAFILE					-1	5
ORD_GPI32MARKER 					-1	5
ORD_GPI32MODIFYPATH					-1	5
ORD_GPI32MOVE						-1	5
ORD_GPI32OFFSETCLIPREGION				-1	5
ORD_GPI32OFFSETELEMENTPOINTER				-1	5
ORD_GPI32OFFSETREGION					-1	5
ORD_GPI32OPENSEGMENT					-1	5
ORD_GPI32PAINTREGION					-1	5
ORD_GPI32PLAYMETAFILE					-1	5
ORD_GPI32POINTARC					-1	5
ORD_GPI32POLYFILLET					-1	5
ORD_GPI32POLYFILLETSHARP				-1	5
ORD_GPI32POLYLINE					-1	5
ORD_GPI32POLYMARKER					-1	5
ORD_GPI32POLYSPLINE					-1	5
ORD_GPI32POP						-1	5
ORD_GPI32PTINREGION					-1	5
ORD_GPI32PTVISIBLE					-1	5
ORD_GPI32PUTDATA					-1	5
ORD_GPI32QUERYARCPARAMS 				-1	5
ORD_GPI32QUERYATTRMODE					-1	5
ORD_GPI32QUERYBACKCOLOR 				-1	5
ORD_GPI32QUERYBACKMIX					-1	5
ORD_GPI32QUERYBITMAPDIMENSION				-1	5
ORD_GPI32QUERYBITMAPHANDLE				-1	5
ORD_GPI32QUERYBOUNDARYDATA				-1	5
ORD_GPI32QUERYCHARANGLE 				-1	5
ORD_GPI32QUERYCHARBOX					-1	5
ORD_GPI32QUERYCHARDIRECTION				-1	5
ORD_GPI32QUERYCHARMODE					-1	5
ORD_GPI32QUERYCHARSET					-1	5
ORD_GPI32QUERYCHARSHEAR 				-1	5
ORD_GPI32QUERYCLIPBOX					-1	5
ORD_GPI32QUERYCLIPREGION				-1	5
ORD_GPI32QUERYCOLOR					-1	5
ORD_GPI32QUERYCOLORDATA 				-1	5
ORD_GPI32QUERYCOLORINDEX				-1	5
ORD_GPI32QUERYCP					-1	5
ORD_GPI32QUERYCURRENTPOSITION				-1	5
ORD_GPI32QUERYDEFCHARBOX				-1	5
ORD_GPI32QUERYDEFAULTVIEWMATRIX 			-1	5
ORD_GPI32QUERYDEVICE					-1	5
ORD_GPI32QUERYDEVICEBITMAPFORMATS			-1	5
ORD_GPI32QUERYDRAWCONTROL				-1	5
ORD_GPI32QUERYDRAWINGMODE				-1	5
ORD_GPI32QUERYEDITMODE					-1	5
ORD_GPI32QUERYELEMENT					-1	5
ORD_GPI32QUERYELEMENTPOINTER				-1	5
ORD_GPI32QUERYELEMENTTYPE				-1	5
ORD_GPI32QUERYFONTFILEDESCRIPTIONS			-1	5
ORD_GPI32QUERYFONTMETRICS				-1	5
ORD_GPI32QUERYGRAPHICSFIELD				-1	5
ORD_GPI32QUERYINITIALSEGMENTATTRS			-1	5
ORD_GPI32QUERYKERNINGPAIRS				-1	5
ORD_GPI32QUERYLINEEND					-1	5
ORD_GPI32QUERYLINEJOIN					-1	5
ORD_GPI32QUERYLINETYPE					-1	5
ORD_GPI32QUERYLINEWIDTH 				-1	5
ORD_GPI32QUERYLINEWIDTHGEOM				-1	5
ORD_GPI32QUERYMARKER					-1	5
ORD_GPI32QUERYMARKERBOX 				-1	5
ORD_GPI32QUERYMARKERSET 				-1	5
ORD_GPI32QUERYMETAFILEBITS				-1	5
ORD_GPI32QUERYMETAFILELENGTH				-1	5
ORD_GPI32QUERYMIX					-1	5
ORD_GPI32QUERYMODELTRANSFORMMATRIX			-1	5
ORD_GPI32QUERYNEARESTCOLOR				-1	5
ORD_GPI32QUERYNUMBERSETIDS				-1	5
ORD_GPI32QUERYPS					-1	5
ORD_GPI32QUERYPAGEVIEWPORT				-1	5
ORD_GPI32QUERYPATTERN					-1	5
ORD_GPI32QUERYPATTERNREFPOINT				-1	5
ORD_GPI32QUERYPATTERNSET				-1	5
ORD_GPI32QUERYPEL					-1	5
ORD_GPI32QUERYPICKAPERTUREPOSITION			-1	5
ORD_GPI32QUERYPICKAPERTURESIZE				-1	5
ORD_GPI32QUERYRGBCOLOR					-1	5
ORD_GPI32QUERYREALCOLORS				-1	5
ORD_GPI32QUERYREGIONBOX 				-1	5
ORD_GPI32QUERYSEGMENTATTRS				-1	5
ORD_GPI32QUERYSEGMENTNAMES				-1	5
ORD_GPI32QUERYSEGMENTPRIORITY				-1	5
ORD_GPI32QUERYSEGMENTTRANSFORMMATR			-1	5
ORD_GPI32QUERYSETIDS					-1	5
ORD_GPI32QUERYSTOPDRAW					-1	5
ORD_GPI32QUERYTAG					-1	5
ORD_GPI32QUERYTEXTBOX					-1	5
ORD_GPI32QUERYVIEWINGLIMITS				-1	5
ORD_GPI32QUERYVIEWINGTRANSFORMMATR			-1	5
ORD_GPI32QUERYWIDTHTABLE				-1	5
ORD_GPI32RECTINREGION					-1	5
ORD_GPI32RECTVISIBLE					-1	5
ORD_GPI32REMOVEDYNAMICS 				-1	5
ORD_GPI32RESETBOUNDARYDATA				-1	5
ORD_GPI32RESETPS					-1	5
ORD_GPI32RESTOREPS					-1	5
ORD_GPI32SAVEMETAFILE					-1	5
ORD_GPI32SAVEPS 					-1	5
ORD_GPI32SETARCPARAMS					-1	5
ORD_GPI32SETATTRMODE					-1	5
ORD_GPI32SETBACKCOLOR					-1	5
ORD_GPI32SETBACKMIX					-1	5
ORD_GPI32SETBITMAP					-1	5
ORD_GPI32SETBITMAPDIMENSION				-1	5
ORD_GPI32SETBITMAPID					-1	5
ORD_GPI32SETCHARANGLE					-1	5
ORD_GPI32SETCHARBOX					-1	5
ORD_GPI32SETCHARDIRECTION				-1	5
ORD_GPI32SETCHARMODE					-1	5
ORD_GPI32SETCHARSET					-1	5
ORD_GPI32SETCHARSHEAR					-1	5
ORD_GPI32SETCLIPPATH					-1	5
ORD_GPI32SETCLIPREGION					-1	5
ORD_GPI32SETCOLOR					-1	5
ORD_GPI32SETCP						-1	5
ORD_GPI32SETCURRENTPOSITION				-1	5
ORD_GPI32SETDEFAULTVIEWMATRIX				-1	5
ORD_GPI32SETDRAWCONTROL 				-1	5
ORD_GPI32SETDRAWINGMODE 				-1	5
ORD_GPI32SETEDITMODE					-1	5
ORD_GPI32SETELEMENTPOINTER				-1	5
ORD_GPI32SETELEMENTPOINTERATLABEL			-1	5
ORD_GPI32SETGRAPHICSFIELD				-1	5
ORD_GPI32SETINITIALSEGMENTATTRS 			-1	5
ORD_GPI32SETLINEEND					-1	5
ORD_GPI32SETLINEJOIN					-1	5
ORD_GPI32SETLINETYPE					-1	5
ORD_GPI32SETLINEWIDTH					-1	5
ORD_GPI32SETLINEWIDTHGEOM				-1	5
ORD_GPI32SETMARKER					-1	5
ORD_GPI32SETMARKERBOX					-1	5
ORD_GPI32SETMARKERSET					-1	5
ORD_GPI32SETMETAFILEBITS				-1	5
ORD_GPI32SETMIX 					-1	5
ORD_GPI32SETMODELTRANSFORMMATRIX			-1	5
ORD_GPI32SETPS						-1	5
ORD_GPI32SETPAGEVIEWPORT				-1	5
ORD_GPI32SETPATTERN					-1	5
ORD_GPI32SETPATTERNREFPOINT				-1	5
ORD_GPI32SETPATTERNSET					-1	5
ORD_GPI32SETPEL 					-1	5
ORD_GPI32SETPICKAPERTUREPOSITION			-1	5
ORD_GPI32SETREGION					-1	5
ORD_GPI32SETSEGMENTATTRS				-1	5
ORD_GPI32SETSEGMENTPRIORITY				-1	5
ORD_GPI32SETSEGMENTTRANSFORMMATRIX			-1	5
ORD_GPI32SETSTOPDRAW					-1	5
ORD_GPI32SETTAG 					-1	5
ORD_GPI32SETVIEWINGLIMITS				-1	5
ORD_GPI32SETVIEWINGTRANSFORMMATRIX			-1	5
ORD_GPI32STROKEPATH					-1	5
ORD_GPI32UNLOADFONTS					-1	5
ORD_GPI32WCBITBLT					-1	5
ORD_GPI32POLYLINEDISJOINT				-1	5
ORD_GPI32PATHTOREGION					-1	5
ORD_GPI32FLOODFILL					-1	5
ORD_GPI32SUSPENDPLAY					-1	5
ORD_GPI32RESUMEPLAY					-1	5
ORD_GPI32OUTLINEPATH					-1	5
ORD_GPI32TRANSLATE					-1	5
ORD_GPI32SCALE						-1	5
ORD_GPI32ROTATE 					-1	5
ORD_GPI32QUERYDEFARCPARAMS				-1	5
ORD_GPI32QUERYDEFTAG					-1	5
ORD_GPI32QUERYDEFVIEWINGLIMITS				-1	5
ORD_GPI32SETDEFARCPARAMS				-1	5
ORD_GPI32SETDEFTAG					-1	5
ORD_GPI32SETDEFVIEWINGLIMITS				-1	5
ORD_GPI32QUERYBITMAPPARAMETERS				-1	5
ORD_GPI32QUERYLOGICALFONT				-1	5
ORD_GPI32QUERYFACESTRING				-1	5
ORD_GPI32QUERYFONTACTION				-1	5
ORD_							-1	5
ORD_GPI32DELETEPALETTE					-1	5
ORD_GPI32SELECTPALETTE					-1	5
ORD_GPI32QUERYPALETTE					-1	5
ORD_GPI32CHARSTRINGPOS					-1	5
ORD_GPI32CHARSTRINGPOSAT				-1	5
ORD_GPI32CORRELATESEGMENT				-1	5
ORD_GPI32QUERYATTRS					-1	5
ORD_GPI32QUERYCHARSTRINGPOS				-1	5
ORD_GPI32QUERYCHARSTRINGPOSAT				-1	5
ORD_GPI32QUERYFONTS					-1	5
ORD_GPI32QUERYREGIONRECTS				-1	5
ORD_GPI32SETATTRS					-1	5
ORD_GPI32SETPICKAPERTURESIZE				-1	5
ORD_GPI32QUERYDEFATTRS					-1	5
ORD_GPI32SETDEFATTRS					-1	5
ORD_GPI32CREATELOGCOLORTABLE				-1	5
ORD_GPI32QUERYLOGCOLORTABLE				-1	5
ORD_GPI32CREATEPALETTE					-1	5
ORD_GPI32ANIMATEPALETTE 				-1	5
ORD_GPI32SETPALETTEENTRIES				-1	5
ORD_GPI32QUERYPALETTEINFO				-1	5
ORD_GPI32CREATEBITMAP					-1	5
ORD_GPI32QUERYBITMAPBITS				-1	5
ORD_GPI32QUERYBITMAPINFOHEADER				-1	5
ORD_GPI32SETBITMAPBITS					-1	5
ORD_GPI32DRAWBITS					-1	5
ORD_DEV32CLOSEDC					-1	5
ORD_DEV32ESCAPE 					-1	5
ORD_DEV32QUERYCAPS					-1	5
ORD_DEV32QUERYDEVICENAMES				-1	5
ORD_DEV32QUERYHARDCOPYCAPS				-1	5
ORD_DEV32POSTDEVICEMODES				-1	5
ORD_DEV32OPENDC 					-1	5
ORD_GPI32DESTROYREGION					-1	5
ORD_GPI32PARTIALARC					-1	5
ORD_GPI32QUERYCHAREXTRA 				-1	5
ORD_GPI32SETCHAREXTRA					-1	5
ORD_GPI32QUERYCHARBREAKEXTRA				-1	5
ORD_GPI32SETCHARBREAKEXTRA				-1	5
ORD_GPI32FRAMEREGION					-1	5
ORD_GPI32CONVERTWITHMATRIX				-1	5
ORD_GPI32LOADPUBLICFONTS				-1	5
ORD_GPI32UNLOADPUBLICFONTS				-1	5
ORD_WINQUERYDESKTOPWINDOW				-1	5
ORD_WINQUERYOBJECTWINDOW				-1	5
ORD_WINREGISTERCLASS					-1	5
ORD_WINQUERYCLASSNAME					-1	5
ORD_WINQUERYCLASSINFO					-1	5
ORD_WINCREATEWINDOW					-1	5
ORD_WINDESTROYWINDOW					-1	5
ORD_WINSETWINDOWPOS					-1	5
ORD_WINSETMULTWINDOWPOS 				-1	5
ORD_WINQUERYWINDOWPOS					-1	5
ORD_WINENABLEWINDOW					-1	5
ORD_WINISWINDOWENABLED					-1	5
ORD_WINSHOWWINDOW					-1	5
ORD_WINENABLEWINDOWUPDATE				-1	5
ORD_WINISWINDOWVISIBLE					-1	5
ORD_WINSETWINDOWTEXT					-1	5
ORD_WINQUERYWINDOWTEXT					-1	5
ORD_WINQUERYWINDOWTEXTLENGTH				-1	5
ORD_WINWINDOWFROMID					-1	5
ORD_WINMULTWINDOWFROMIDS				-1	5
ORD_WINISWINDOW 					-1	5
ORD_WINISCHILD						-1	5
ORD_WINSETPARENT					-1	5
ORD_WINSETOWNER 					-1	5
ORD_WINQUERYWINDOW					-1	5
ORD_WINQUERYWINDOWRECT					-1	5
ORD_WINQUERYWINDOWPROCESS				-1	5
ORD_WINSETWINDOWUSHORT					-1	5
ORD_WINQUERYWINDOWUSHORT				-1	5
ORD_WINSETWINDOWULONG					-1	5
ORD_WINQUERYWINDOWULONG 				-1	5
ORD_WINBEGINENUMWINDOWS 				-1	5
ORD_WINGETNEXTWINDOW					-1	5
ORD_WINENDENUMWINDOWS					-1	5
ORD_WINWINDOWFROMPOINT					-1	5
ORD_WINMAPWINDOWPOINTS					-1	5
ORD_WINSUBCLASSWINDOW					-1	5
ORD_WINLOCKWINDOW					-1	5
ORD_WINQUERYWINDOWLOCKCOUNT				-1	5
ORD_WINREGISTERWINDOWDESTROY				-1	5
ORD_WINOPENWINDOWDC					-1	5
ORD_WINGETSCREENPS					-1	5
ORD_WINGETPS						-1	5
ORD_WINRELEASEPS					-1	5
ORD_WINBEGINPAINT					-1	5
ORD_WINENDPAINT 					-1	5
ORD_WININVALIDATERECT					-1	5
ORD_WININVALIDATEREGION 				-1	5
ORD_WINVALIDATERECT					-1	5
ORD_WINVALIDATEREGION					-1	5
ORD_WINQUERYUPDATERECT					-1	5
ORD_WINQUERYUPDATEREGION				-1	5
ORD_WINUPDATEWINDOW					-1	5
ORD_WINEXCLUDEUPDATEREGION				-1	5
ORD_WINLOCKWINDOWUPDATE 				-1	5
ORD_WINLOCKVISREGIONS					-1	5
ORD_WINWINDOWFROMDC					-1	5
ORD_WINCREATEMSGQUEUE					-1	5
ORD_WINDESTROYMSGQUEUE					-1	5
ORD_WINQUERYQUEUESTATUS 				-1	5
ORD_WINSENDMSG						-1	5
ORD_WINBROADCASTMSG					-1	5
ORD_WININSENDMSG					-1	5
ORD_WINGETMSG						-1	5
ORD_WINPEEKMSG						-1	5
ORD_WINWAITMSG						-1	5
ORD_WINDISPATCHMSG					-1	5
ORD_WINPOSTMSG						-1	5
ORD_WINPOSTQUEUEMSG					-1	5
ORD_WINQUERYMSGPOS					-1	5
ORD_WINQUERYMSGTIME					-1	5
ORD_WINCALLMSGFILTER					-1	5
ORD_WINSETMSGINTEREST					-1	5
ORD_WINSETCAPTURE					-1	5
ORD_WINQUERYCAPTURE					-1	5
ORD_WINSETFOCUS 					-1	5
ORD_WINQUERYFOCUS					-1	5
ORD_WINSETACTIVEWINDOW					-1	5
ORD_WINQUERYACTIVEWINDOW				-1	5
ORD_WINSETSYSMODALWINDOW				-1	5
ORD_WINQUERYSYSMODALWINDOW				-1	5
ORD_WINISTHREADACTIVE					-1	5
ORD_WINSTARTTIMER					-1	5
ORD_WINSTOPTIMER					-1	5
ORD_WINGETCURRENTTIME					-1	5
ORD_WINLOADPOINTER					-1	5
ORD_WINCREATEPOINTER					-1	5
ORD_WINDESTROYPOINTER					-1	5
ORD_OLDWINQUERYPOINTERINFO				-1	5
ORD_WINQUERYSYSPOINTER					-1	5
ORD_WINSETPOINTER					-1	5
ORD_WINQUERYPOINTER					-1	5
ORD_WINSHOWPOINTER					-1	5
ORD_WINSETPOINTERPOS					-1	5
ORD_WINQUERYPOINTERPOS					-1	5
ORD_WINGETSYSBITMAP					-1	5
ORD_WINCREATECURSOR					-1	5
ORD_WINDESTROYCURSOR					-1	5
ORD_WINSHOWCURSOR					-1	5
ORD_WINQUERYCURSORINFO					-1	5
ORD_WINLOADACCELTABLE					-1	5
ORD_WINCREATEACCELTABLE 				-1	5
ORD_WINDESTROYACCELTABLE				-1	5
ORD_WINTRANSLATEACCEL					-1	5
ORD_WINSETACCELTABLE					-1	5
ORD_WINQUERYACCELTABLE					-1	5
ORD_WINCOPYACCELTABLE					-1	5
ORD_WINSETHOOK						-1	5
ORD_WINRELEASEHOOK					-1	5
ORD_WINOPENCLIPBRD					-1	5
ORD_WINCLOSECLIPBRD					-1	5
ORD_WINEMPTYCLIPBRD					-1	5
ORD_WINSETCLIPBRDOWNER					-1	5
ORD_WINQUERYCLIPBRDOWNER				-1	5
ORD_WINSETCLIPBRDDATA					-1	5
ORD_WINQUERYCLIPBRDDATA 				-1	5
ORD_WINENUMCLIPBRDFMTS					-1	5
ORD_WINQUERYCLIPBRDFMTINFO				-1	5
ORD_WINSETCLIPBRDVIEWER 				-1	5
ORD_WINQUERYCLIPBRDVIEWER				-1	5
ORD_WINLOADDLG						-1	5
ORD_WINCREATEDLG					-1	5
ORD_WINPROCESSDLG					-1	5
ORD_WINDLGBOX						-1	5
ORD_WINDISMISSDLG					-1	5
ORD_WINSENDDLGITEMMSG					-1	5
ORD_WINSETDLGITEMSHORT					-1	5
ORD_WINQUERYDLGITEMSHORT				-1	5
ORD_WINMAPDLGPOINTS					-1	5
ORD_WINSUBSTITUTESTRINGS				-1	5
ORD_WINENUMDLGITEM					-1	5
ORD_WINSETDLGITEMTEXT					-1	5
ORD_WINQUERYDLGITEMTEXT 				-1	5
ORD_WINLOADMENU 					-1	5
ORD_WINCREATEMENU					-1	5
ORD_WINALARM						-1	5
ORD_WINMESSAGEBOX					-1	5
ORD_WINCREATESTDWINDOW					-1	5
ORD_WINCREATEFRAMECONTROLS				-1	5
ORD_WINCALCFRAMERECT					-1	5
ORD_WINFLASHWINDOW					-1	5
ORD_WINGETMINPOSITION					-1	5
ORD_WINGETMAXPOSITION					-1	5
ORD_WINQUERYSYSVALUE					-1	5
ORD_WINSETSYSVALUE					-1	5
ORD_WINSETSYSCOLORS					-1	5
ORD_WINQUERYSYSCOLOR					-1	5
ORD_WINSCROLLWINDOW					-1	5
ORD_WINTRACKRECT					-1	5
ORD_WINSHOWTRACKRECT					-1	5
ORD_GPILOADBITMAP					-1	5
ORD_WINLOADSTRING					-1	5
ORD_WINLOADMESSAGE					-1	5
ORD_WINSETRECTEMPTY					-1	5
ORD_WINSETRECT						-1	5
ORD_WINCOPYRECT 					-1	5
ORD_WINISRECTEMPTY					-1	5
ORD_WINEQUALRECT					-1	5
ORD_WINPTINRECT 					-1	5
ORD_WINOFFSETRECT					-1	5
ORD_WININFLATERECT					-1	5
ORD_WININTERSECTRECT					-1	5
ORD_WINUNIONRECT					-1	5
ORD_WINSUBTRACTRECT					-1	5
ORD_WINMAKERECT 					-1	5
ORD_WINMAKEPOINTS					-1	5
ORD_WININVERTRECT					-1	5
ORD_WINFILLRECT 					-1	5
ORD_KBDPACKET						-1	5
ORD_WINDRAWPOINTER					-1	5
ORD_WINDEFWINDOWPROC					-1	5
ORD_WINDEFDLGPROC					-1	5
ORD_WINGETKEYSTATE					-1	5
ORD_WINGETPHYSKEYSTATE					-1	5
ORD_WINSETKEYBOARDSTATETABLE				-1	5
ORD_WINENABLEPHYSINPUT					-1	5
ORD_WINSETCP						-1	5
ORD_WINQUERYCP						-1	5
ORD_WINQUERYCPLIST					-1	5
ORD_WINCPTRANSLATESTRING				-1	5
ORD_WINCPTRANSLATECHAR					-1	5
ORD_WINCOMPARESTRINGS					-1	5
ORD_WINUPPER						-1	5
ORD_WINUPPERCHAR					-1	5
ORD_WINNEXTCHAR 					-1	5
ORD_WINPREVCHAR 					-1	5
ORD_WINCREATEHEAP					-1	5
ORD_WINDESTROYHEAP					-1	5
ORD_WINAVAILMEM 					-1	5
ORD_WINALLOCMEM 					-1	5
ORD_WINREALLOCMEM					-1	5
ORD_WINFREEMEM						-1	5
ORD_WINLOCKHEAP 					-1	5
ORD_WINCREATEATOMTABLE					-1	5
ORD_WINDESTROYATOMTABLE 				-1	5
ORD_WINADDATOM						-1	5
ORD_WINFINDATOM 					-1	5
ORD_WINDELETEATOM					-1	5
ORD_WINQUERYATOMUSAGE					-1	5
ORD_WINQUERYATOMLENGTH					-1	5
ORD_WINQUERYATOMNAME					-1	5
ORD_WINQUERYSYSTEMATOMTABLE				-1	5
ORD_WINGETLASTERROR					-1	5
ORD_WINGETERRORINFO					-1	5
ORD_WINFREEERRORINFO					-1	5
ORD_WININITIALIZE					-1	5
ORD_WINTERMINATE					-1	5
ORD_WINCATCH						-1	5
ORD_WINTHROW						-1	5
ORD_WINQUERYVERSION					-1	5
ORD__WINSETERRORINFO					-1	5
ORD_WINISPHYSINPUTENABLED				-1	5
ORD_WINQUERYWINDOWDC					-1	5
ORD_WINDRAWBORDER					-1	5
ORD_WINDRAWTEXT 					-1	5
ORD_WINDRAWBITMAP					-1	5
ORD_WINQUERYWINDOWPTR					-1	5
ORD_WINSETWINDOWPTR					-1	5
ORD_WINMSGSEMWAIT					-1	5
ORD_WINMSGMUXSEMWAIT					-1	5
ORD_WINCANCELSHUTDOWN					-1	5
ORD_WINSETWINDOWBITS					-1	5
ORD_WINGETCLIPPS					-1	5
ORD_WINSAVEWINDOWPOS					-1	5
ORD_WINFOCUSCHANGE					-1	5
ORD_WINQUERYQUEUEINFO					-1	5
ORD_WINSETCLASSMSGINTEREST				-1	5
ORD_WINQUERYDLGITEMTEXTLENGTH				-1	5
ORD_WINDDEINITIATE					-1	5
ORD_WINDDERESPOND					-1	5
ORD_WINDDEPOSTMSG					-1	5
ORD_WINSETPRESPARAM					-1	5
ORD_WINQUERYPRESPARAM					-1	5
ORD_WINREMOVEPRESPARAM					-1	5
ORD_DUMWINCREATEHELPINSTANCE				-1	5
ORD_DUMWINDESTROYHELPINSTANCE				-1	5
ORD_DUMWINASSOCIATEHELPINSTANCE 			-1	5
ORD_DUMWINCREATEHELPTABLE				-1	5
ORD_DUMWINLOADHELPTABLE 				-1	5
ORD_DUMWINQUERYHELPINSTANCE				-1	5
ORD_DUMMYHELPENTRY					-1	5
ORD_WINSETCLASSTHUNKPROC				-1	5
ORD_WINQUERYCLASSTHUNKPROC				-1	5
ORD_WINSETWINDOWTHUNKPROC				-1	5
ORD_WINQUERYWINDOWTHUNKPROC				-1	5
ORD_WINQUERYWINDOWMODEL 				-1	5
ORD_WINSETDESKTOPBKGND					-1	5
ORD_WINQUERYDESKTOPBKGND				-1	5
ORD_WINPOPUPMENU					-1	5
ORD_WINREALIZEPALETTE					-1	5
ORD_WINDELETELIBRARY					-1	5
ORD_WINLOADPROCEDURE					-1	5
ORD_WINDELETEPROCEDURE					-1	5
ORD_WINSETMSGMODE					-1	5
ORD_WINSETSYNCHROMODE					-1	5
ORD_WINGETDLGMSG					-1	5
ORD_WINREGISTERUSERMSG					-1	5
ORD_WINQUERYANCHORBLOCK 				-1	5
ORD_WINREGISTERUSERDATATYPE				-1	5
ORD_WINISWINDOWSHOWING					-1	5
ORD_WINLOADLIBRARY					-1	5
ORD_WINCREATEPOINTERINDIRECT				-1	5
ORD_WINQUERYPOINTERINFO 				-1	5
ORD_WINGETERASEPS					-1	5
ORD_WINRELEASEERASEPS					-1	5
ORD_WINSTRETCHPOINTER					-1	5
ORD_WINSETPOINTEROWNER					-1	5
ORD_WIN32ADDATOM					-1	5
ORD_WIN32ALARM						-1	5
ORD_WIN32BEGINENUMWINDOWS				-1	5
ORD_WIN32BEGINPAINT					-1	5
ORD_WIN32CALCFRAMERECT					-1	5
ORD_WIN32CANCELSHUTDOWN 				-1	5
ORD_WIN32CLOSECLIPBRD					-1	5
ORD_WIN32COMPARESTRINGS 				-1	5
ORD_WIN32COPYACCELTABLE 				-1	5
ORD_WIN32COPYRECT					-1	5
ORD_WIN32CPTRANSLATECHAR				-1	5
ORD_WIN32CPTRANSLATESTRING				-1	5
ORD_WIN32CREATEACCELTABLE				-1	5
ORD_WIN32CREATEATOMTABLE				-1	5
ORD_WIN32CREATECURSOR					-1	5
ORD_WIN32CREATEMSGQUEUE 				-1	5
ORD_WIN32CREATEPOINTER					-1	5
ORD_WIN32DDEINITIATE					-1	5
ORD_WIN32DDEPOSTMSG					-1	5
ORD_WIN32DDERESPOND					-1	5
ORD_WIN32DELETEATOM					-1	5
ORD_WIN32DELETELIBRARY					-1	5
ORD_WIN32DESTROYACCELTABLE				-1	5
ORD_WIN32DESTROYATOMTABLE				-1	5
ORD_WIN32DESTROYCURSOR					-1	5
ORD_WIN32DESTROYMSGQUEUE				-1	5
ORD_WIN32DESTROYPOINTER 				-1	5
ORD_WIN32DESTROYWINDOW					-1	5
ORD_WIN32DISMISSDLG					-1	5
ORD_WIN32DRAWBITMAP					-1	5
ORD_WIN32DRAWBORDER					-1	5
ORD_WIN32DRAWPOINTER					-1	5
ORD_WIN32EMPTYCLIPBRD					-1	5
ORD_WIN32ENABLEPHYSINPUT				-1	5
ORD_WIN32ENABLEWINDOW					-1	5
ORD_WIN32ENABLEWINDOWUPDATE				-1	5
ORD_WIN32ENDENUMWINDOWS 				-1	5
ORD_WIN32ENDPAINT					-1	5
ORD_WIN32ENUMCLIPBRDFMTS				-1	5
ORD_WIN32ENUMDLGITEM					-1	5
ORD_WIN32EQUALRECT					-1	5
ORD_WIN32EXCLUDEUPDATEREGION				-1	5
ORD_WIN32FILLRECT					-1	5
ORD_WIN32FINDATOM					-1	5
ORD_WIN32FLASHWINDOW					-1	5
ORD_WIN32FOCUSCHANGE					-1	5
ORD_							-1	5
ORD_WIN32FREEERRORINFO					-1	5
ORD_WIN32GETCLIPPS					-1	5
ORD_WIN32GETCURRENTTIME 				-1	5
ORD_WIN32GETERRORINFO					-1	5
ORD_WIN32GETKEYSTATE					-1	5
ORD_WIN32GETLASTERROR					-1	5
ORD_WIN32GETMAXPOSITION 				-1	5
ORD_WIN32GETMINPOSITION 				-1	5
ORD_WIN32GETNEXTWINDOW					-1	5
ORD_WIN32GETPS						-1	5
ORD_WIN32GETPHYSKEYSTATE				-1	5
ORD_WIN32GETSCREENPS					-1	5
ORD_WIN32GETSYSBITMAP					-1	5
ORD_WIN32INSENDMSG					-1	5
ORD_WIN32INFLATERECT					-1	5
ORD_WIN32INITIALIZE					-1	5
ORD_WIN32INTERSECTRECT					-1	5
ORD_WIN32INVALIDATERECT 				-1	5
ORD_WIN32INVALIDATEREGION				-1	5
ORD_WIN32INVERTRECT					-1	5
ORD_WIN32ISCHILD					-1	5
ORD_WIN32ISPHYSINPUTENABLED				-1	5
ORD_WIN32ISRECTEMPTY					-1	5
ORD_WIN32ISTHREADACTIVE 				-1	5
ORD_WIN32ISWINDOW					-1	5
ORD_WIN32ISWINDOWENABLED				-1	5
ORD_WIN32ISWINDOWSHOWING				-1	5
ORD_WIN32ISWINDOWVISIBLE				-1	5
ORD_WIN32LOADACCELTABLE 				-1	5
ORD_WIN32LOADLIBRARY					-1	5
ORD_WIN32LOADMENU					-1	5
ORD_WIN32LOADMESSAGE					-1	5
ORD_WIN32LOADPOINTER					-1	5
ORD_WIN32LOADSTRING					-1	5
ORD_WIN32LOCKVISREGIONS 				-1	5
ORD_WIN32LOCKWINDOWUPDATE				-1	5
ORD_WIN32MAKEPOINTS					-1	5
ORD_WIN32MAKERECT					-1	5
ORD_WIN32MAPDLGPOINTS					-1	5
ORD_WIN32MAPWINDOWPOINTS				-1	5
ORD_WIN32MESSAGEBOX					-1	5
ORD_WIN32MSGSEMWAIT					-1	5
ORD_WIN32NEXTCHAR					-1	5
ORD_WIN32OFFSETRECT					-1	5
ORD_WIN32OPENCLIPBRD					-1	5
ORD_WIN32OPENWINDOWDC					-1	5
ORD_WIN32PREVCHAR					-1	5
ORD_WIN32PROCESSDLG					-1	5
ORD_WIN32PTINRECT					-1	5
ORD_WIN32QUERYACCELTABLE				-1	5
ORD_WIN32QUERYACTIVEWINDOW				-1	5
ORD_WIN32QUERYANCHORBLOCK				-1	5
ORD_WIN32QUERYATOMLENGTH				-1	5
ORD_WIN32QUERYATOMNAME					-1	5
ORD_WIN32QUERYATOMUSAGE 				-1	5
ORD_WIN32QUERYCAPTURE					-1	5
ORD_WIN32QUERYCLASSNAME 				-1	5
ORD_WIN32QUERYCLIPBRDDATA				-1	5
ORD_WIN32QUERYCLIPBRDFMTINFO				-1	5
ORD_WIN32QUERYCLIPBRDOWNER				-1	5
ORD_WIN32QUERYCLIPBRDVIEWER				-1	5
ORD_WIN32QUERYCP					-1	5
ORD_WIN32QUERYCPLIST					-1	5
ORD_WIN32QUERYCURSORINFO				-1	5
ORD_WIN32QUERYDESKTOPWINDOW				-1	5
ORD_WIN32QUERYDLGITEMSHORT				-1	5
ORD_WIN32QUERYDLGITEMTEXT				-1	5
ORD_WIN32QUERYDLGITEMTEXTLENGTH 			-1	5
ORD_WIN32QUERYFOCUS					-1	5
ORD_WIN32QUERYMSGPOS					-1	5
ORD_WIN32QUERYMSGTIME					-1	5
ORD_WIN32QUERYOBJECTWINDOW				-1	5
ORD_WIN32QUERYPOINTER					-1	5
ORD_WIN32QUERYPOINTERINFO				-1	5
ORD_WIN32QUERYPOINTERPOS				-1	5
ORD_WIN32QUERYQUEUEINFO 				-1	5
ORD_WIN32QUERYQUEUESTATUS				-1	5
ORD_WIN32QUERYSYSCOLOR					-1	5
ORD_WIN32QUERYSYSMODALWINDOW				-1	5
ORD_WIN32QUERYSYSPOINTER				-1	5
ORD_WIN32QUERYSYSVALUE					-1	5
ORD_WIN32QUERYSYSTEMATOMTABLE				-1	5
ORD_WIN32QUERYUPDATERECT				-1	5
ORD_WIN32QUERYUPDATEREGION				-1	5
ORD_WIN32QUERYVERSION					-1	5
ORD_WIN32QUERYWINDOW					-1	5
ORD_WIN32QUERYWINDOWDC					-1	5
ORD_WIN32QUERYWINDOWPOS 				-1	5
ORD_WIN32QUERYWINDOWPROCESS				-1	5
ORD_WIN32QUERYWINDOWPTR 				-1	5
ORD_WIN32QUERYWINDOWRECT				-1	5
ORD_WIN32QUERYWINDOWTEXT				-1	5
ORD_WIN32QUERYWINDOWTEXTLENGTH				-1	5
ORD_WIN32QUERYWINDOWULONG				-1	5
ORD_WIN32QUERYWINDOWUSHORT				-1	5
ORD_WIN32REGISTERUSERDATATYPE				-1	5
ORD_WIN32REGISTERUSERMSG				-1	5
ORD_WIN32RELEASEPS					-1	5
ORD_WIN32SCROLLWINDOW					-1	5
ORD_WIN32SETACCELTABLE					-1	5
ORD_WIN32SETACTIVEWINDOW				-1	5
ORD_WIN32SETCAPTURE					-1	5
ORD_WIN32SETCLASSMSGINTEREST				-1	5
ORD_WIN32SETCLIPBRDDATA 				-1	5
ORD_WIN32SETCLIPBRDOWNER				-1	5
ORD_WIN32SETCLIPBRDVIEWER				-1	5
ORD_WIN32SETCP						-1	5
ORD_WIN32SETDLGITEMSHORT				-1	5
ORD_WIN32SETDLGITEMTEXT 				-1	5
ORD_WIN32SETFOCUS					-1	5
ORD_WIN32SETMSGINTEREST 				-1	5
ORD_WIN32SETMSGMODE					-1	5
ORD_WIN32SETMULTWINDOWPOS				-1	5
ORD_WIN32SETOWNER					-1	5
ORD_WIN32SETPARENT					-1	5
ORD_WIN32SETPOINTER					-1	5
ORD_WIN32SETPOINTERPOS					-1	5
ORD_WIN32SETRECT					-1	5
ORD_WIN32SETRECTEMPTY					-1	5
ORD_WIN32SETSYNCHROMODE 				-1	5
ORD_WIN32SETSYSCOLORS					-1	5
ORD_WIN32SETSYSMODALWINDOW				-1	5
ORD_WIN32SETSYSVALUE					-1	5
ORD_WIN32SETWINDOWBITS					-1	5
ORD_WIN32SETWINDOWPOS					-1	5
ORD_WIN32SETWINDOWPTR					-1	5
ORD_WIN32SETWINDOWTEXT					-1	5
ORD_WIN32SETWINDOWULONG 				-1	5
ORD_WIN32SETWINDOWUSHORT				-1	5
ORD_WIN32SHOWCURSOR					-1	5
ORD_WIN32SHOWPOINTER					-1	5
ORD_WIN32SHOWTRACKRECT					-1	5
ORD_WIN32SHOWWINDOW					-1	5
ORD_WIN32STARTTIMER					-1	5
ORD_WIN32STOPTIMER					-1	5
ORD_WIN32SUBSTITUTESTRINGS				-1	5
ORD_WIN32SUBTRACTRECT					-1	5
ORD_WIN32TERMINATE					-1	5
ORD_WIN32TRACKRECT					-1	5
ORD_WIN32UNIONRECT					-1	5
ORD_WIN32UPDATEWINDOW					-1	5
ORD_WIN32UPPER						-1	5
ORD_WIN32UPPERCHAR					-1	5
ORD_WIN32VALIDATERECT					-1	5
ORD_WIN32VALIDATEREGION 				-1	5
ORD_WIN32WAITMSG					-1	5
ORD_WIN32WINDOWFROMDC					-1	5
ORD_WIN32WINDOWFROMID					-1	5
ORD_WIN32WINDOWFROMPOINT				-1	5
ORD_WIN32BROADCASTMSG					-1	5
ORD_WIN32POSTQUEUEMSG					-1	5
ORD_WIN32SENDDLGITEMMSG 				-1	5
ORD_WIN32TRANSLATEACCEL 				-1	5
ORD_WIN32CALLMSGFILTER					-1	5
ORD_WIN32CREATEFRAMECONTROLS				-1	5
ORD_WIN32CREATEMENU					-1	5
ORD_WIN32CREATESTDWINDOW				-1	5
ORD_WIN32CREATEWINDOW					-1	5
ORD_WIN32DEFDLGPROC					-1	5
ORD_WIN32DEFWINDOWPROC					-1	5
ORD_WIN32DISPATCHMSG					-1	5
ORD_WIN32DRAWTEXT					-1	5
ORD_WIN32GETDLGMSG					-1	5
ORD_WIN32GETMSG 					-1	5
ORD_WIN32MSGMUXSEMWAIT					-1	5
ORD_WIN32MULTWINDOWFROMIDS				-1	5
ORD_WIN32PEEKMSG					-1	5
ORD_WIN32POSTMSG					-1	5
ORD_WIN32SENDMSG					-1	5
ORD_WIN32SETKEYBOARDSTATETABLE				-1	5
ORD_WIN32CREATEDLG					-1	5
ORD_WIN32DLGBOX 					-1	5
ORD_WIN32LOADDLG					-1	5
ORD_WIN32QUERYCLASSINFO 				-1	5
ORD_WIN32REGISTERCLASS					-1	5
ORD_WIN32RELEASEHOOK					-1	5
ORD_WIN32SETHOOK					-1	5
ORD_WIN32SUBCLASSWINDOW 				-1	5
ORD_WIN32SETCLASSTHUNKPROC				-1	5
ORD_WIN32QUERYCLASSTHUNKPROC				-1	5
ORD_WIN32SETWINDOWTHUNKPROC				-1	5
ORD_WIN32QUERYWINDOWTHUNKPROC				-1	5
ORD_WIN32QUERYWINDOWMODEL				-1	5
ORD_WIN32SETDESKTOPBKGND				-1	5
ORD_WIN32QUERYDESKTOPBKGND				-1	5
ORD_WIN32POPUPMENU					-1	5
ORD_WIN32SETPRESPARAM					-1	5
ORD_WIN32QUERYPRESPARAM 				-1	5
ORD_WIN32REMOVEPRESPARAM				-1	5
ORD_WIN32REALIZEPALETTE 				-1	5
ORD_WIN32CREATEPOINTERINDIRECT				-1	5
ORD_WIN32SAVEWINDOWPOS					-1	5
ORD_WIN32GETERASEPS					-1	5
ORD_WIN32RELEASEERASEPS 				-1	5
ORD_WIN32SETPOINTEROWNER				-1	5
ORD_WIN32STRETCHPOINTER 				-1	5
ORD_WIN32SETERRORINFO					-1	5
ORD_WIN32WAITEVENTSEM					-1	5
ORD_WIN32REQUESTMUTEXSEM				-1	5
ORD_WIN32WAITMUXWAITSEM 				-1	5
ORD_PICPRINT						-1	5
ORD_PICICHG						-1	5
ORD_PIC32PRINT						-1	5
ORD_PIC32ICHG						-1	5
ORD_PRF32PIF2MET					-1	5
ORD_WINQUERYPROFILEINT					-1	5
ORD_WINQUERYPROFILESTRING				-1	5
ORD_WINWRITEPROFILESTRING				-1	5
ORD_WINQUERYPROFILESIZE 				-1	5
ORD_WINQUERYPROFILEDATA 				-1	5
ORD_WINWRITEPROFILEDATA 				-1	5
ORD_WININITSESSIONMGR					-1	5
ORD_WINSETFGNDWINDOW					-1	5
ORD_WINADDPROGRAM					-1	5
ORD_WINREMOVEPROGRAM					-1	5
ORD_WINCHANGEPROGRAM					-1	5
ORD_WINQUERYDEFINITION					-1	5
ORD_WINQUERYPROGRAMTITLES				-1	5
ORD_WINCREATEGROUP					-1	5
ORD_WINADDTOGROUP					-1	5
ORD_WINQUERYPROGRAMUSE					-1	5
ORD_WINREMOVEFROMGROUP					-1	5
ORD_WINDESTROYGROUP					-1	5
ORD_WINQUERYFILEEXTOPTS 				-1	5
ORD_WINSETFILEEXTOPTS					-1	5
ORD_WINQUERYPROGRAMTYPE 				-1	5
ORD_PRFQUERYPROFILEINT					-1	5
ORD_PRFQUERYPROFILESTRING				-1	5
ORD_PRFWRITEPROFILESTRING				-1	5
ORD_PRFQUERYPROFILESIZE 				-1	5
ORD_PRFQUERYPROFILEDATA 				-1	5
ORD_PRFWRITEPROFILEDATA 				-1	5
ORD_PRFOPENPROFILE					-1	5
ORD_PRFCLOSEPROFILE					-1	5
ORD_PRFRESET						-1	5
ORD_PRFQUERYPROFILE					-1	5
ORD_WININSTSTARTAPP					-1	5
ORD_WINTERMINATEAPP					-1	5
ORD_WINCREATESWITCHENTRY				-1	5
ORD_WINQUERYSESSIONTITLE				-1	5
ORD_WINADDSWITCHENTRY					-1	5
ORD_WINCHANGESWITCHENTRY				-1	5
ORD_PRFADDPROGRAM					-1	5
ORD_PRFREMOVEPROGRAM					-1	5
ORD_PRFCHANGEPROGRAM					-1	5
ORD_PRFQUERYDEFINITION					-1	5
ORD_PRFQUERYPROGRAMTITLES				-1	5
ORD_PRFCREATEGROUP					-1	5
ORD_WINQUERYSWITCHENTRY 				-1	5
ORD_WINQUERYSWITCHHANDLE				-1	5
ORD_PRFQUERYPROGRAMHANDLE				-1	5
ORD_PRFQUERYPROGRAMCATEGORY				-1	5
ORD_PRFDESTROYGROUP					-1	5
ORD_WINQUERYTASKTITLE					-1	5
ORD_WINQUERYTASKSIZEPOS 				-1	5
ORD_WINQUERYSWITCHLIST					-1	5
ORD_WINREMOVESWITCHENTRY				-1	5
ORD_WINSWITCHTOPROGRAM					-1	5
ORD_WINSWITCHPROGRAMREGISTER				-1	5
ORD_WINENDPROGRAM					-1	5
ORD_WINSTOPPROGRAM					-1	5
ORD_WINENDWINDOWSESSION 				-1	5
ORD_WINSWITCHTOTASKMANAGER				-1	5
ORD_WINSWITCHTOPROGRAM2 				-1	5
ORD_WINPROCESSHOTKEY					-1	5
ORD_WININITSESSION					-1	5
ORD_WINENDSESSION					-1	5
ORD_WININITSWENTRY					-1	5
ORD_WINSETSWENTRY					-1	5
ORD_WINQUERYEXTIDFOCUS					-1	5
ORD_WINSETEXTIDFOCUS					-1	5
ORD_WINNOSHUTDOWN					-1	5
ORD_WINSETTITLE 					-1	5
ORD_WINSETTITLEANDICON					-1	5
ORD_PRF32QUERYPROFILESIZE				-1	5
ORD_PRF32OPENPROFILE					-1	5
ORD_PRF32CLOSEPROFILE					-1	5
ORD_PRF32REMOVEPROGRAM					-1	5
ORD_PRF32DESTROYGROUP					-1	5
ORD_PRF32QUERYPROFILE					-1	5
ORD_PRF32RESET						-1	5
ORD_PRF32ADDPROGRAM					-1	5
ORD_PRF32CHANGEPROGRAM					-1	5
ORD_PRF32QUERYDEFINITION				-1	5
ORD_PRF32QUERYPROGRAMTITLES				-1	5
ORD_PRF32QUERYPROFILEINT				-1	5
ORD_PRF32QUERYPROFILESTRING				-1	5
ORD_PRF32WRITEPROFILESTRING				-1	5
ORD_PRF32QUERYPROFILEDATA				-1	5
ORD_PRF32WRITEPROFILEDATA				-1	5
ORD_WIN32STARTAPP					-1	5
ORD_WIN32ADDSWITCHENTRY 				-1	5
ORD_WIN32CREATESWITCHENTRY				-1	5
ORD_WIN32QUERYSESSIONTITLE				-1	5
ORD_WIN32CHANGESWITCHENTRY				-1	5
ORD_WIN32QUERYSWITCHENTRY				-1	5
ORD_WIN32QUERYSWITCHHANDLE				-1	5
ORD_WIN32QUERYSWITCHLIST				-1	5
ORD_WIN32QUERYTASKSIZEPOS				-1	5
ORD_WIN32QUERYTASKTITLE 				-1	5
ORD_WIN32REMOVESWITCHENTRY				-1	5
ORD_WIN32TERMINATEAPP					-1	5
ORD_WIN32SWITCHTOPROGRAM				-1	5
ORD_WIN32SWITCHPROGRAMREGISTER				-1	5
ORD_WINSTARTAPP 					-1	5
ORD_WINHAPPFROMPID					-1	5
ORD_WINHSWITCHFROMHAPP					-1	5
ORD_DOSREADQUEUE					-1	5
ORD_DOSPURGEQUEUE					-1	5
ORD_DOSCLOSEQUEUE					-1	5
ORD_DOSQUERYQUEUE					-1	5
ORD_DOSPEEKQUEUE					-1	5
ORD_DOSWRITEQUEUE					-1	5
ORD_DOSOPENQUEUE					-1	5
ORD_DOSCREATEQUEUE					-1	5
ORD_DOS32READQUEUE					-1	5
ORD_DOS32PURGEQUEUE					-1	5
ORD_DOS32CLOSEQUEUE					-1	5
ORD_DOS32QUERYQUEUE					-1	5
ORD_DOS32PEEKQUEUE					-1	5
ORD_DOS32WRITEQUEUE					-1	5
ORD_DOS32OPENQUEUE					-1	5
ORD_DOS32CREATEQUEUE					-1	5
ORD_DOSSTOPSESSION					-1	5
ORD_DOSSELECTSESSION					-1	5
ORD_DOSSETSESSION					-1	5
ORD_DOSSTARTSESSION					-1	5
ORD_DOSSMREGISTERDD					-1	5
ORD_DOS32STARTSESSION					-1	5
ORD_DOS32SELECTSESSION					-1	5
ORD_DOS32SETSESSION					-1	5
ORD_DOS32STOPSESSION					-1	5
ORD_WINFONTDLG						-1	5
ORD_WINDEFFONTDLGPROC					-1	5
ORD_WINFILEDLG						-1	5
ORD_WINDEFFILEDLGPROC					-1	5
ORD_WINFREEFILEDLGLIST					-1	5
ORD_VIOENDPOPUP 					-1	5
ORD_VIOGETPHYSBUF					-1	5
ORD_VIOGETANSI						-1	5
ORD_VIOSETANSI						-1	5
ORD_VIODEREGISTER					-1	5
ORD_VIOSCROLLUP 					-1	5
ORD_VIOPRTSC						-1	5
ORD_VIOGETCURPOS					-1	5
ORD_VIOWRTCELLSTR					-1	5
ORD_VIOPOPUP						-1	5
ORD_VIOSCROLLRT 					-1	5
ORD_VIOWRTCHARSTR					-1	5
ORD_VIOSETCURPOS					-1	5
ORD_VIOSCRUNLOCK					-1	5
ORD_VIOWRTTTY						-1	5
ORD_VIOGETMODE						-1	5
ORD_VIOSETMODE						-1	5
ORD_VIOSCRLOCK						-1	5
ORD_VIOREADCELLSTR					-1	5
ORD_VIOSAVREDRAWWAIT					-1	5
ORD_VIOWRTNATTR 					-1	5
ORD_VIOGETCURTYPE					-1	5
ORD_VIOSAVREDRAWUNDO					-1	5
ORD_VIOGETFONT						-1	5
ORD_VIOREADCHARSTR					-1	5
ORD_VIOGETBUF						-1	5
ORD_VIOSETCURTYPE					-1	5
ORD_VIOSETFONT						-1	5
ORD_VIOMODEUNDO 					-1	5
ORD_VIOMODEWAIT 					-1	5
OR							-1	5
ORD_VIOGETCP						-1	5
ORD_VIOSETCP						-1	5
ORD_VIOSHOWBUF						-1	5
ORD_VIOSCROLLLF 					-1	5
ORD_VIOREGISTER 					-1	5
ORD_VIOGETCONFIG					-1	5
ORD_VIOSCROLLDN 					-1	5
ORD_VIOWRTCHARSTRATT					-1	5
ORD_VIOGETSTATE 					-1	5
ORD_VIOPRTSCTOGGLE					-1	5
ORD_VIOSETSTATE 					-1	5
ORD_VIOWRTNCELL 					-1	5
ORD_VIOWRTNCHAR 					-1	5
ORD_VIOASSOCIATE					-1	5
ORD_VIOCREATEPS 					-1	5
ORD_VIODELETESETID					-1	5
ORD_VIOGETDEVICECELLSIZE				-1	5
ORD_VIOGETORG						-1	5
ORD_VIOCREATELOGFONT					-1	5
ORD_VIODESTROYPS					-1	5
ORD_VIOQUERYSETIDS					-1	5
ORD_VIOSETORG						-1	5
ORD_VIOQUERYFONTS					-1	5
ORD_VIOSETDEVICECELLSIZE				-1	5
ORD_VIOSHOWPS						-1	5
ORD_VIOGETPSADDRESS					-1	5
ORD_VIOGLOBALREG					-1	5
ORD_XVIOSETCASTATE					-1	5
ORD_XVIOCHECKCHARTYPE					-1	5
ORD_XVIODESTROYCA					-1	5
ORD_XVIOCREATECA					-1	5
ORD_VIOCHECKCHARTYPE					-1	5
ORD_XVIOGETCASTATE					-1	5
ORD_WINDEFAVIOWINDOWPROC				-1	5
__BSESUB__						-1	5
INCL_KBD						-1	5
INCL_VIO						-1	5
INCL_MOU						-1	5
Kbd16CharIn						-1	5
Kbd16Close						-1	5
Kbd16DeRegister 					-1	5
Kbd16FlushBuffer					-1	5
Kbd16FreeFocus						-1	5
Kbd16GetCp						-1	5
Kbd16GetFocus						-1	5
Kbd16GetHWID						-1	5
Kbd16GetStatus						-1	5
Kbd16Open						-1	5
Kbd16Peek						-1	5
Kbd16Register						-1	5
Kbd16SetCp						-1	5
Kbd16SetCustXt						-1	5
Kbd16SetFgnd						-1	5
Kbd16SetHWID						-1	5
Kbd16SetStatus						-1	5
Kbd16StringIn						-1	5
Kbd16Synch						-1	5
Kbd16Xlate						-1	5
KbdCharIn						-1	5
KbdClose						-1	5
KbdDeRegister						-1	5
KbdFlushBuffer						-1	5
KbdFreeFocus						-1	5
KbdGetCp						-1	5
KbdGetFocus						-1	5
KbdGetHWID						-1	5
KbdGetStatus						-1	5
KbdOpen 						-1	5
KbdPeek 						-1	5
KbdRegister						-1	5
KbdSetCp						-1	5
KbdSetCustXt						-1	5
KbdSetFgnd						-1	5
KbdSetHWID						-1	5
KbdSetStatus						-1	5
KbdStringIn						-1	5
KbdSynch						-1	5
KbdXlate						-1	5
KR_KBDCHARIN						-1	5
KR_KBDPEEK						-1	5
KR_KBDFLUSHBUFFER					-1	5
KR_KBDGETSTATUS 					-1	5
KR_KBDSETSTATUS 					-1	5
KR_KBDSTRINGIN						-1	5
KR_KBDOPEN						-1	5
KR_KBDCLOSE						-1	5
KR_KBDGETFOCUS						-1	5
KR_KBDFREEFOCUS 					-1	5
KR_KBDGETCP						-1	5
KR_KBDSETCP						-1	5
KR_KBDXLATE						-1	5
KR_KBDSETCUSTXT 					-1	5
IO_WAIT 						-1	5
IO_NOWAIT						-1	5
KEYBOARD_ECHO_ON					-1	5
KEYBOARD_ECHO_OFF					-1	5
KEYBOARD_BINARY_MODE					-1	5
KEYBOARD_ASCII_MODE					-1	5
KEYBOARD_MODIFY_STATE					-1	5
KEYBOARD_MODIFY_INTERIM 				-1	5
KEYBOARD_MODIFY_TURNAROUND				-1	5
KEYBOARD_2B_TURNAROUND					-1	5
KEYBOARD_SHIFT_REPORT					-1	5
KBDSTF_RIGHTSHIFT					-1	5
KBDSTF_LEFTSHIFT					-1	5
KBDSTF_CONTROL						-1	5
KBDSTF_ALT						-1	5
KBDSTF_SCROLLLOCK_ON					-1	5
KBDSTF_NUMLOCK_ON					-1	5
KBDSTF_CAPSLOCK_ON					-1	5
KBDSTF_INSERT_ON					-1	5
KBDSTF_LEFTCONTROL					-1	5
KBDSTF_LEFTALT						-1	5
KBDSTF_RIGHTCONTROL					-1	5
KBDSTF_RIGHTALT 					-1	5
KBDSTF_SCROLLLOCK					-1	5
KBDSTF_NUMLOCK						-1	5
KBDSTF_CAPSLOCK 					-1	5
KBDSTF_SYSREQ						-1	5
KBDTRF_SHIFT_KEY_IN					-1	5
KBDTRF_CONVERSION_REQUEST				-1	5
KBDTRF_FINAL_CHAR_IN					-1	5
KBDTRF_INTERIM_CHAR_IN					-1	5
VioCheckCharType					-1	5
VioDeRegister						-1	5
VioEndPopUp						-1	5
VioGetAnsi						-1	5
VioGetBuf						-1	5
VioGetConfig						-1	5
VioGetCp						-1	5
VioGetCurPos						-1	5
VioGetCurType						-1	5
VioGetFont						-1	5
VioGetMode						-1	5
VioGetPhysBuf						-1	5
VioGetState						-1	5
VioModeUndo						-1	5
VioModeWait						-1	5
VioPopUp						-1	5
VioPrtSc						-1	5
VioPrtScToggle						-1	5
VioReadCellStr						-1	5
VioReadCharStr						-1	5
VioRedrawSize						-1	5
VioRegister						-1	5
VioSavRedrawUndo					-1	5
VioSavRedrawWait					-1	5
VioScrLock						-1	5
VioScrUnLock						-1	5
VioScrollDn						-1	5
VioScrollLf						-1	5
VioScrollRt						-1	5
VioScrollUp						-1	5
VioSetAnsi						-1	5
VioSetCp						-1	5
VioSetCurPos						-1	5
VioSetCurType						-1	5
VioSetFont						-1	5
VioSetMode						-1	5
VioSetState						-1	5
VioShowBuf						-1	5
VioWrtCellStr						-1	5
VioWrtCharStr						-1	5
VioWrtCharStrAtt					-1	5
VioWrtNAttr						-1	5
VioWrtNCell						-1	5
VioWrtNChar						-1	5
VioWrtTTY						-1	5
Vio16CheckCharType					-1	5
Vio16DeRegister 					-1	5
Vio16EndPopUp						-1	5
Vio16GetAnsi						-1	5
Vio16GetBuf						-1	5
Vio16GetConfig						-1	5
Vio16GetCp						-1	5
Vio16GetCurPos						-1	5
Vio16GetCurType 					-1	5
Vio16GetFont						-1	5
Vio16GetMode						-1	5
Vio16GetPhysBuf 					-1	5
Vio16GetState						-1	5
Vio16ModeUndo						-1	5
Vio16ModeWait						-1	5
Vio16PopUp						-1	5
Vio16PrtSc						-1	5
Vio16PrtScToggle					-1	5
Vio16ReadCellStr					-1	5
Vio16ReadCharStr					-1	5
Vio16RedrawSize 					-1	5
Vio16Register						-1	5
Vio16SavRedrawUndo					-1	5
Vio16SavRedrawWait					-1	5
Vio16ScrLock						-1	5
Vio16ScrUnLock						-1	5
Vio16ScrollDn						-1	5
Vio16ScrollLf						-1	5
Vio16ScrollRt						-1	5
Vio16ScrollUp						-1	5
Vio16SetAnsi						-1	5
Vio16SetCp						-1	5
Vio16SetCurPos						-1	5
Vio16SetCurType 					-1	5
Vio16SetFont						-1	5
Vio16SetMode						-1	5
Vio16SetState						-1	5
Vio16ShowBuf						-1	5
Vio16WrtCellStr 					-1	5
Vio16WrtCharStr 					-1	5
Vio16WrtCharStrAtt					-1	5
Vio16WrtNAttr						-1	5
Vio16WrtNCell						-1	5
Vio16WrtNChar						-1	5
Vio16WrtTTY						-1	5
VR_VIOGETCURPOS 					-1	5
VR_VIOGETCURTYPE					-1	5
VR_VIOGETMODE						-1	5
VR_VIOGETBUF						-1	5
VR_VIOGETPHYSBUF					-1	5
VR_VIOSETCURPOS 					-1	5
VR_VIOSETCURTYPE					-1	5
VR_VIOSETMODE						-1	5
VR_VIOSHOWBUF						-1	5
VR_VIOREADCHARSTR					-1	5
VR_VIOREADCELLSTR					-1	5
VR_VIOWRTNCHAR						-1	5
VR_VIOWRTNATTR						-1	5
VR_VIOWRTNCELL						-1	5
VR_VIOWRTTTY						-1	5
VR_VIOWRTCHARSTR					-1	5
VR_VIOWRTCHARSTRATT					-1	5
VR_VIOWRTCELLSTR					-1	5
VR_VIOSCROLLUP						-1	5
VR_VIOSCROLLDN						-1	5
VR_VIOSCROLLLF						-1	5
VR_VIOSCROLLRT						-1	5
VR_VIOSETANSI						-1	5
VR_VIOGETANSI						-1	5
VR_VIOPRTSC						-1	5
VR_VIOSCRLOCK						-1	5
VR_VIOSCRUNLOCK 					-1	5
VR_VIOSAVREDRAWWAIT					-1	5
VR_VIOSAVREDRAWUNDO					-1	5
VR_VIOPOPUP						-1	5
VR_VIOENDPOPUP						-1	5
VR_VIOPRTSCTOGGLE					-1	5
VR_VIOMODEWAIT						-1	5
VR_VIOMODEUNDO						-1	5
VR_VIOGETFONT						-1	5
VR_VIOGETCONFIG 					-1	5
VR_VIOSETCP						-1	5
VR_VIOGETCP						-1	5
VR_VIOSETFONT						-1	5
VR_VIOGETSTATE						-1	5
VR_VIOSETSTATE						-1	5
COLORS_2						-1	5
COLORS_4						-1	5
COLORS_16						-1	5
VGMT_OTHER						-1	5
VGMT_GRAPHICS						-1	5
VGMT_DISABLEBURST					-1	5
VCC_SBCSCHAR						-1	5
VCC_DBCSFULLCHAR					-1	5
VCC_DBCS1STHALF 					-1	5
VCC_DBCS2NDHALF 					-1	5
ANSI_ON 						-1	5
ANSI_OFF						-1	5
VSRWI_SAVEANDREDRAW					-1	5
VSRWI_REDRAW						-1	5
VSRWN_SAVE						-1	5
VSRWN_REDRAW						-1	5
UNDOI_GETOWNER						-1	5
UNDOI_RELEASEOWNER					-1	5
UNDOK_ERRORCODE 					-1	5
UNDOK_TERMINATE 					-1	5
VMWR_POPUP						-1	5
VMWN_POPUP						-1	5
LOCKIO_NOWAIT						-1	5
LOCKIO_WAIT						-1	5
LOCK_SUCCESS						-1	5
LOCK_FAIL						-1	5
VP_NOWAIT						-1	5
VP_WAIT 						-1	5
VP_OPAQUE						-1	5
VP_TRANSPARENT						-1	5
DISPLAY_MONOCHROME					-1	5
DISPLAY_CGA						-1	5
DISPLAY_EGA						-1	5
DISPLAY_VGA						-1	5
DISPLAY_8514A						-1	5
DISPLAY_IMAGEADAPTER					-1	5
DISPLAY_XGA						-1	5
MONITOR_MONOCHROME					-1	5
MONITOR_COLOR						-1	5
MONITOR_ENHANCED					-1	5
MONITOR_8503						-1	5
MONITOR_851X_COLOR					-1	5
MONITOR_8514						-1	5
MONITOR_FLATPANEL					-1	5
MONITOR_8507_8604					-1	5
MONITOR_8515						-1	5
MONITOR_9515						-1	5
MONITOR_9517						-1	5
MONITOR_9518						-1	5
VIO_CONFIG_CURRENT					-1	5
VIO_CONFIG_PRIMARY					-1	5
VIO_CONFIG_SECONDARY					-1	5
VGFI_GETCURFONT 					-1	5
VGFI_GETROMFONT 					-1	5
MouClose						-1	5
MouDeRegister						-1	5
MouDrawPtr						-1	5
MouFlushQue						-1	5
MouGetDevStatus 					-1	5
MouGetEventMask 					-1	5
MouGetNumButtons					-1	5
MouGetNumMickeys					-1	5
MouGetNumQueEl						-1	5
MouGetPtrPos						-1	5
MouGetPtrShape						-1	5
MouGetScaleFact 					-1	5
MouGetThreshold 					-1	5
MouInitReal						-1	5
MouOpen 						-1	5
MouReadEventQue 					-1	5
MouRegister						-1	5
MouRemovePtr						-1	5
MouSetDevStatus 					-1	5
MouSetEventMask 					-1	5
MouSetPtrPos						-1	5
MouSetPtrShape						-1	5
MouSetScaleFact 					-1	5
MouSetThreshold 					-1	5
MouSynch						-1	5
Mou16Close						-1	5
Mou16DeRegister 					-1	5
Mou16DrawPtr						-1	5
Mou16FlushQue						-1	5
Mou16GetDevStatus					-1	5
Mou16GetEventMask					-1	5
Mou16GetNumButtons					-1	5
Mou16GetNumMickeys					-1	5
Mou16GetNumQueEl					-1	5
Mou16GetPtrPos						-1	5
Mou16GetPtrShape					-1	5
Mou16GetScaleFact					-1	5
Mou16GetThreshold					-1	5
Mou16InitReal						-1	5
Mou16Open						-1	5
Mou16ReadEventQue					-1	5
Mou16Register						-1	5
Mou16RemovePtr						-1	5
Mou16SetDevStatus					-1	5
Mou16SetEventMask					-1	5
Mou16SetPtrPos						-1	5
Mou16SetPtrShape					-1	5
Mou16SetScaleFact					-1	5
Mou16SetThreshold					-1	5
Mou16Synch						-1	5
MR_MOUGETNUMBUTTONS					-1	5
MR_MOUGETNUMMICKEYS					-1	5
MR_MOUGETDEVSTATUS					-1	5
MR_MOUGETDEVSTATUS					-1	5
MR_MOUGETNUMQUEEL					-1	5
MR_MOUREADEVENTQUE					-1	5
MR_MOUGETSCALEFACT					-1	5
MR_MOUGETEVENTMASK					-1	5
MR_MOUSETSCALEFACT					-1	5
MR_MOUSETEVENTMASK					-1	5
MR_MOUOPEN						-1	5
MR_MOUCLOSE						-1	5
MR_MOUGETPTRSHAPE					-1	5
MR_MOUSETPTRSHAPE					-1	5
MR_MOUDRAWPTR						-1	5
MR_MOUREMOVEPTR 					-1	5
MR_MOUGETPTRPOS 					-1	5
MR_MOUSETPTRPOS 					-1	5
MR_MOUINITREAL						-1	5
MR_MOUSETDEVSTATUS					-1	5
MHK_BUTTON1						-1	5
MHK_BUTTON2						-1	5
MHK_BUTTON3						-1	5
MOUSE_QUEUEBUSY 					-1	5
MOUSE_BLOCKREAD 					-1	5
MOUSE_FLUSH						-1	5
MOUSE_UNSUPPORTED_MODE					-1	5
MOUSE_DISABLED						-1	5
MOUSE_MICKEYS						-1	5
MOU_NOWAIT						-1	5
MOU_WAIT						-1	5
MOUSE_MOTION						-1	5
MOUSE_MOTION_WITH_BN1_DOWN				-1	5
MOUSE_BN1_DOWN						-1	5
MOUSE_MOTION_WITH_BN2_DOWN				-1	5
MOUSE_BN2_DOWN						-1	5
MOUSE_MOTION_WITH_BN3_DOWN				-1	5
MOUSE_BN3_DOWN						-1	5
MOU_NODRAW						-1	5
MOU_DRAW						-1	5
MOU_MICKEYS						-1	5
MOU_PELS						-1	5
__BSETIB__						-1	5
__BSEXCPT__						-1	5
XCPT_CONTINUE_SEARCH					-1	5
XCPT_CONTINUE_EXECUTION 				-1	5
XCPT_CONTINUE_STOP					-1	5
EH_NONCONTINUABLE					-1	5
EH_UNWINDING						-1	5
EH_EXIT_UNWIND						-1	5
EH_STACK_INVALID					-1	5
EH_NESTED_CALL						-1	5
UNWIND_ALL						-1	5
XCPT_FATAL_EXCEPTION					-1	5
XCPT_SEVERITY_CODE					-1	5
XCPT_CUSTOMER_CODE					-1	5
XCPT_FACILITY_CODE					-1	5
XCPT_EXCEPTION_CODE					-1	5
XCPT_UNKNOWN_ACCESS					-1	5
XCPT_READ_ACCESS					-1	5
XCPT_WRITE_ACCESS					-1	5
XCPT_EXECUTE_ACCESS					-1	5
XCPT_SPACE_ACCESS					-1	5
XCPT_LIMIT_ACCESS					-1	5
XCPT_DATA_UNKNOWN					-1	5
XCPT_SIGNAL_INTR					-1	5
XCPT_SIGNAL_KILLPROC					-1	5
XCPT_SIGNAL_BREAK					-1	5
XCPT_GUARD_PAGE_VIOLATION				-1	5
XCPT_UNABLE_TO_GROW_STACK				-1	5
XCPT_DATATYPE_MISALIGNMENT				-1	5
XCPT_BREAKPOINT 					-1	5
XCPT_SINGLE_STEP					-1	5
XCPT_ACCESS_VIOLATION					-1	5
XCPT_ILLEGAL_INSTRUCTION				-1	5
XCPT_FLOAT_DENORMAL_OPERAND				-1	5
XCPT_FLOAT_DIVIDE_BY_ZERO				-1	5
XCPT_FLOAT_INEXACT_RESULT				-1	5
XCPT_FLOAT_INVALID_OPERATION				-1	5
XCPT_FLOAT_OVERFLOW					-1	5
XCPT_FLOAT_STACK_CHECK					-1	5
XCPT_FLOAT_UNDERFLOW					-1	5
XCPT_INTEGER_DIVIDE_BY_ZERO				-1	5
XCPT_INTEGER_OVERFLOW					-1	5
XCPT_PRIVILEGED_INSTRUCTION				-1	5
XCPT_IN_PAGE_ERROR					-1	5
XCPT_PROCESS_TERMINATE					-1	5
XCPT_ASYNC_PROCESS_TERMINATE				-1	5
XCPT_NONCONTINUABLE_EXCEPTION				-1	5
XCPT_INVALID_DISPOSITION				-1	5
XCPT_INVALID_LOCK_SEQUENCE				-1	5
XCPT_ARRAY_BOUNDS_EXCEEDED				-1	5
XCPT_B1NPX_ERRATA_02					-1	5
XCPT_UNWIND						-1	5
XCPT_BAD_STACK						-1	5
XCPT_INVALID_UNWIND_TARGET				-1	5
XCPT_SIGNAL						-1	5
CONTEXT_CONTROL 					-1	5
CONTEXT_INTEGER 					-1	5
CONTEXT_SEGMENTS					-1	5
CONTEXT_FLOATING_POINT					-1	5
CONTEXT_FULL						-1	5
EXCEPTION_MAXIMUM_PARAMETERS				-1	5
END_OF_CHAIN						-1	5
__EXE__ 						-1	5
EXEID							-1	5
__EXE386__						-1	5
BITPERWORD						-1	5
BITPERBYTE						-1	5
OBJPAGELEN						-1	5
E32MAGIC1						-1	5
E32MAGIC2						-1	5
E32MAGIC						-1	5
E32RESBYTES1						-1	5
E32RESBYTES2						-1	5
E32RESBYTES3						-1	5
E32LEBO 						-1	5
E32BEBO 						-1	5
E32LEWO 						-1	5
E32BEWO 						-1	5
E32LEVEL						-1	5
E32CPU286						-1	5
E32CPU386						-1	5
E32CPU486						-1	5
E32_MAGIC1						-1	5
E32_MAGIC2						-1	5
E32_BORDER						-1	5
E32_WORDER						-1	5
E32_LEVEL						-1	5
E32_CPU 						-1	5
E32_OS							-1	5
E32_VER 						-1	5
E32_MFLAGS						-1	5
E32_MPAGES						-1	5
E32_STARTOBJ						-1	5
E32_EIP 						-1	5
E32_STACKOBJ						-1	5
E32_ESP 						-1	5
E32_PAGESIZE						-1	5
E32_PAGESHIFT						-1	5
E32_FIXUPSIZE						-1	5
E32_FIXUPSUM						-1	5
E32_LDRSIZE						-1	5
E32_LDRSUM						-1	5
E32_OBJTAB						-1	5
E32_OBJCNT						-1	5
E32_OBJMAP						-1	5
E32_ITERMAP						-1	5
E32_RSRCTAB						-1	5
E32_RSRCCNT						-1	5
E32_RESTAB						-1	5
E32_ENTTAB						-1	5
E32_DIRTAB						-1	5
E32_DIRCNT						-1	5
E32_FPAGETAB						-1	5
E32_FRECTAB						-1	5
E32_IMPMOD						-1	5
E32_IMPMODCNT						-1	5
E32_IMPPROC						-1	5
E32_PAGESUM						-1	5
E32_DATAPAGE						-1	5
E32_PRELOAD						-1	5
E32_NRESTAB						-1	5
E32_CBNRESTAB						-1	5
E32_NRESSUM						-1	5
E32_AUTODATA						-1	5
E32_DEBUGINFO						-1	5
E32_DEBUGLEN						-1	5
E32_INSTPRELOAD 					-1	5
E32_INSTDEMAND						-1	5
E32_HEAPSIZE						-1	5
E32_STACKSIZE						-1	5
E32NOTP 						-1	5
E32NOLOAD						-1	5
E32PMAPI						-1	5
E32PMW							-1	5
E32NOPMW						-1	5
E32NOEXTFIX						-1	5
E32NOINTFIX						-1	5
E32SYSDLL						-1	5
E32LIBINIT						-1	5
E32LIBTERM						-1	5
E32APPMASK						-1	5
E32PROTDLL						-1	5
E32DEVICE						-1	5
E32MODEXE						-1	5
E32MODDLL						-1	5
E32MODPROTDLL						-1	5
E32MODPDEV						-1	5
E32MODVDEV						-1	5
E32MODMASK						-1	5
RINTSIZE16						-1	5
RINTSIZE32						-1	5
RORDSIZE						-1	5
RNAMSIZE16						-1	5
RNAMSIZE32						-1	5
RADDSIZE16						-1	5
RADDSIZE32						-1	5
NR_STYPE						-1	5
NR_FLAGS						-1	5
R32_SOFF						-1	5
R32_OBJNO						-1	5
R32_MODORD						-1	5
R32_OFFSET16						-1	5
R32_OFFSET32						-1	5
R32_PROCOFF16						-1	5
R32_PROCOFF32						-1	5
R32_PROCORD						-1	5
R32_ENTRY						-1	5
R32_ADDVAL16						-1	5
R32_ADDVAL32						-1	5
R32_SRCCNT						-1	5
R32_CHAIN						-1	5
NRSTYP							-1	5
NRSBYT							-1	5
NRSSEG							-1	5
NRSPTR							-1	5
NRSOFF							-1	5
NRPTR48 						-1	5
NROFF32 						-1	5
NRSOFF32						-1	5
NRSRCMASK						-1	5
NRALIAS 						-1	5
NRCHAIN 						-1	5
NRRTYP							-1	5
NRRINT							-1	5
NRRORD							-1	5
NRRNAM							-1	5
NRADD							-1	5
NRRENT							-1	5
NR32BITOFF						-1	5
NR32BITADD						-1	5
NR16OBJMOD						-1	5
NR8BITORD						-1	5
PAGEPERDIR						-1	5
LG2DIR							-1	5
O32_SIZE						-1	5
O32_BASE						-1	5
O32_FLAGS						-1	5
O32_PAGEMAP						-1	5
O32_MAPSIZE						-1	5
O32_RESERVED						-1	5
OBJREAD 						-1	5
OBJWRITE						-1	5
OBJRSRC 						-1	5
OBJINVALID						-1	5
LNKNONPERM						-1	5
OBJNONPERM						-1	5
OBJPERM 						-1	5
OBJRESIDENT						-1	5
OBJCONTIG						-1	5
OBJDYNAMIC						-1	5
OBJTYPEMASK						-1	5
OBJALIAS16						-1	5
OBJBIGDEF						-1	5
OBJIOPL 						-1	5
OBJDISCARD						-1	5
OBJSHARED						-1	5
OBJPRELOAD						-1	5
OBJEXEC 						-1	5
OBJCONFORM						-1	5
NSDISCARD						-1	5
NSMOVE							-1	5
NSSHARED						-1	5
NSPRELOAD						-1	5
NSEXRD							-1	5
NSCONFORM						-1	5
GETPAGEIDX						-1	5
PUTPAGEIDX						-1	5
PUTPAGESIZ						-1	5
GETPAGESIZ						-1	5
PAGEFLAGS						-1	5
VALID							-1	5
ITERDATA						-1	5
INVALID 						-1	5
ZEROED							-1	5
RANGE							-1	5
ITERDATA2						-1	5
B32_CNT 						-1	5
B32_TYPE						-1	5
B32_OBJ 						-1	5
E32_EFLAGS						-1	5
E32_OFFSET16						-1	5
E32_OFFSET32						-1	5
E32_GATEOFF						-1	5
E32_GATE						-1	5
E32_MODORD						-1	5
E32_VALUE						-1	5
FIXENT16						-1	5
FIXENT32						-1	5
GATEENT16						-1	5
FWDENT							-1	5
EMPTY							-1	5
ENTRY16 						-1	5
GATE16							-1	5
ENTRY32 						-1	5
ENTRYFWD						-1	5
TYPEINFO						-1	5
E32EXPORT						-1	5
E32SHARED						-1	5
E32PARAMS						-1	5
FWD_ORDINAL						-1	5
IDM_CHILDVPSYSMENU					-1	5
IDM_FILE						-1	5
IDM_SEARCH						-1	5
IDM_PRINT						-1	5
IDM_VIEWPORT						-1	5
IDM_EDIT						-1	5
IDM_CLIP_COPY						-1	5
IDM_CLIP_CF						-1	5
IDM_CLIP_AF						-1	5
IDM_LIBRARIES						-1	5
IDM_OPTIONS						-1	5
IDM_VIEWPAGES						-1	5
IDM_TOC 						-1	5
IDM_OPTION_EXPLEVEL					-1	5
IDM_OPTION_EXPBRANCH					-1	5
IDM_OPTION_EXPALL					-1	5
IDM_OPTION_COLBRANCH					-1	5
IDM_OPTION_COLALL					-1	5
IDM_PREVIOUS						-1	5
IDM_HELP						-1	5
IDM_HELPHELP						-1	5
IDM_HELP_EXTENDED					-1	5
IDM_USING_HELP						-1	5
IDM_GENERAL_HELP					-1	5
IDM_HELP_KEYS						-1	5
IDM_HELP_INDEX						-1	5
IDM_TUTORIAL						-1	5
__NEWEXE__						-1	5
EMAGIC							-1	5
ENEWEXE 						-1	5
ENEWHDR 						-1	5
ERESWDS 						-1	5
ERES1WDS						-1	5
ERES2WDS						-1	5
ECP							-1	5
ECBLP							-1	5
EMINALLOC						-1	5
E_MAGIC 						-1	5
E_CBLP							-1	5
E_CP							-1	5
E_CRLC							-1	5
E_CPARHDR						-1	5
E_MINALLOC						-1	5
E_MAXALLOC						-1	5
E_SS							-1	5
E_SP							-1	5
E_CSUM							-1	5
E_IP							-1	5
E_CS							-1	5
E_LFARLC						-1	5
E_OVNO							-1	5
E_RES							-1	5
E_OEMID 						-1	5
E_OEMINFO						-1	5
E_RES2							-1	5
E_LFANEW						-1	5
NEMAGIC 						-1	5
NERESBYTES						-1	5
NECRC							-1	5
NE_MAGIC						-1	5
NE_VER							-1	5
NE_REV							-1	5
NE_ENTTAB						-1	5
NE_CBENTTAB						-1	5
NE_CRC							-1	5
NE_FLAGS						-1	5
NE_AUTODATA						-1	5
NE_HEAP 						-1	5
NE_STACK						-1	5
NE_CSIP 						-1	5
NE_SSSP 						-1	5
NE_CSEG 						-1	5
NE_CMOD 						-1	5
NE_CBNRESTAB						-1	5
NE_SEGTAB						-1	5
NE_RSRCTAB						-1	5
NE_RESTAB						-1	5
NE_MODTAB						-1	5
NE_IMPTAB						-1	5
NE_NRESTAB						-1	5
NE_CMOVENT						-1	5
NE_ALIGN						-1	5
NE_CRES 						-1	5
NE_RES							-1	5
NE_EXETYP						-1	5
NE_FLAGSOTHERS						-1	5
NE_USAGE						-1	5
NE_PNEXTEXE						-1	5
NE_ONEWEXE						-1	5
NE_PFILEINFO						-1	5
NE_UNKNOWN						-1	5
NE_OS2							-1	5
NE_WINDOWS						-1	5
NE_DOS4 						-1	5
NE_DEV386						-1	5
NENOTP							-1	5
NEIERR							-1	5
NEBOUND 						-1	5
NEAPPTYP						-1	5
NENOTWINCOMPAT						-1	5
NEWINCOMPAT						-1	5
NEWINAPI						-1	5
NEFLTP							-1	5
NEI386							-1	5
NEI286							-1	5
NEI086							-1	5
NEPROT							-1	5
NEPPLI							-1	5
NEINST							-1	5
NESOLO							-1	5
NELONGNAMES						-1	5
NEWINISPROT						-1	5
NEWINGETPROPFON 					-1	5
NEWLOAPPL						-1	5
NS_SECTOR						-1	5
NS_CBSEG						-1	5
NS_FLAGS						-1	5
NS_MINALLOC						-1	5
NSTYPE							-1	5
NSCODE							-1	5
NSDATA							-1	5
NSITER							-1	5
NSMOVE							-1	5
NSSHARED						-1	5
NSPRELOAD						-1	5
NSEXRD							-1	5
NSRELOC 						-1	5
NSCONFORM						-1	5
NSEXPDOWN						-1	5
NSDPL							-1	5
SHIFTDPL						-1	5
NSDISCARD						-1	5
NS32BIT 						-1	5
NSHUGE							-1	5
NSGDT							-1	5
NSPURE							-1	5
NSALIGN 						-1	5
NSLOADED						-1	5
NR_STYPE						-1	5
NR_FLAGS						-1	5
NR_SOFF 						-1	5
NR_SEGNO						-1	5
NR_RES							-1	5
NR_ENTRY						-1	5
NR_MOD							-1	5
NR_MOD							-1	5
NR_PROC 						-1	5
NR_OSTYPE						-1	5
NR_OSRES						-1	5
NRSTYP							-1	5
NRSBYT							-1	5
NRSSEG							-1	5
NRSPTR							-1	5
NRSOFF							-1	5
NRPTR48 						-1	5
NROFF32 						-1	5
NRSOFF32						-1	5
NRADD							-1	5
NRRTYP							-1	5
NRRINT							-1	5
NRRORD							-1	5
NRRNAM							-1	5
NRROSF							-1	5
RS_LEN							-1	5
RS_STRING						-1	5
RT_ID							-1	5
RT_NRES 						-1	5
RT_PROC 						-1	5
RN_OFFSET						-1	5
RN_LENGTH						-1	5
RN_FLAGS						-1	5
RN_ID							-1	5
RN_HANDLE						-1	5
RN_USAGE						-1	5
RSORDID 						-1	5
RNMOVE							-1	5
RNPURE							-1	5
RNPRELOAD						-1	5
RNDISCARD						-1	5
RS_ALIGN						-1	5
__OS2_H__						-1	5
OS2_INCLUDED						-1	5
__OS2DEF__						-1	5
OS2DEF_INCLUDED 					-1	5
FAR							-1	5
NEAR							-1	5
APIENTRY						-1	5
EXPENTRY						-1	5
APIENTRY16						-1	5
PASCAL16						-1	5
CDECL16 						-1	5
VOID							-1	5
FALSE							-1	5
TRUE							-1	5
NULL							-1	5
NULL							-1	5
NULLHANDLE						-1	5
NULLSHANDLE						-1	5
CHAR							-1	5
SHORT							-1	5
LONG							-1	5
INT							-1	5
BOOL32							-1	5
PBOOL32 						-1	5
MAKEP							-1	5
MAKE16P 						-1	5
SELECTOROF						-1	5
OFFSETOF						-1	5
MAKETYPE						-1	5
FIELDOFFSET						-1	5
MAKEULONG						-1	5
MAKELONG						-1	5
MAKEUSHORT						-1	5
MAKESHORT						-1	5
LOBYTE							-1	5
HIBYTE							-1	5
LOUCHAR 						-1	5
HIUCHAR 						-1	5
LOUSHORT						-1	5
HIUSHORT						-1	5
MAKEERRORID						-1	5
ERRORIDERROR						-1	5
ERRORIDSEV						-1	5
SEVERITY_NOERROR					-1	5
SEVERITY_WARNING					-1	5
SEVERITY_ERROR						-1	5
SEVERITY_SEVERE 					-1	5
SEVERITY_UNRECOVERABLE					-1	5
WINERR_BASE						-1	5
GPIERR_BASE						-1	5
DEVERR_BASE						-1	5
SPLERR_BASE						-1	5
__HSEM__						-1	5
ADDRESS 						-1	5
DRIVER_NAME						-1	5
DRIVER_DATA						-1	5
DATA_TYPE						-1	5
COMMENT 						-1	5
PROC_NAME						-1	5
PROC_PARAMS						-1	5
SPL_PARAMS						-1	5
NETWORK_PARAMS						-1	5
PD_JOB_PROPERTY 					-1	5
FATTR_SEL_ITALIC					-1	5
FATTR_SEL_UNDERSCORE					-1	5
FATTR_SEL_OUTLINE					-1	5
FATTR_SEL_STRIKEOUT					-1	5
FATTR_SEL_BOLD						-1	5
FATTR_TYPE_KERNING					-1	5
FATTR_TYPE_MBCS 					-1	5
FATTR_TYPE_DBCS 					-1	5
FATTR_TYPE_ANTIALIASED					-1	5
FATTR_FONTUSE_NOMIX					-1	5
FATTR_FONTUSE_OUTLINE					-1	5
FATTR_FONTUSE_TRANSFORMABLE				-1	5
FACESIZE						-1	5
FM_TYPE_FIXED						-1	5
FM_TYPE_LICENSED					-1	5
FM_TYPE_KERNING 					-1	5
FM_TYPE_DBCS						-1	5
FM_TYPE_MBCS						-1	5
FM_TYPE_64K						-1	5
FM_TYPE_ATOMS						-1	5
FM_TYPE_FAMTRUNC					-1	5
FM_TYPE_FACETRUNC					-1	5
FM_DEFN_OUTLINE 					-1	5
FM_DEFN_IFI						-1	5
FM_DEFN_WIN						-1	5
FM_DEFN_GENERIC 					-1	5
FM_SEL_ITALIC						-1	5
FM_SEL_UNDERSCORE					-1	5
FM_SEL_NEGATIVE 					-1	5
FM_SEL_OUTLINE						-1	5
FM_SEL_STRIKEOUT					-1	5
FM_SEL_BOLD						-1	5
FM_SEL_ISO9241_TESTED					-1	5
FM_ISO_9518_640 					-1	5
FM_ISO_9515_640 					-1	5
FM_ISO_9515_1024					-1	5
FM_ISO_9517_640 					-1	5
FM_ISO_9517_1024					-1	5
FM_CAP_NOMIX						-1	5
WRECT							-1	5
PWRECT							-1	5
NPWRECT 						-1	5
WPOINT							-1	5
PWPOINT 						-1	5
NPWPOINT						-1	5
ICON_FILE						-1	5
ICON_RESOURCE						-1	5
ICON_DATA						-1	5
ICON_CLEAR						-1	5
__OS2NLS__						-1	5
RID_DBE_OFFSET						-1	5
STR_DBE_OFFSET						-1	5
VK_DBE_FIRST						-1	5
VK_DBE_LAST						-1	5
VK_DBE_IMEFIRST 					-1	5
VK_DBE_IMELAST						-1	5
VK_DBE_OEMFIRST 					-1	5
VK_DBE_OEMLAST						-1	5
VK_DBE_ALPHANUMERIC					-1	5
VK_DBE_KATAKANA 					-1	5
VK_DBE_HIRAGANA 					-1	5
VK_DBE_SBCSCHAR 					-1	5
VK_DBE_DBCSCHAR 					-1	5
VK_DBE_SBCSDBCSCHAR					-1	5
VK_DBE_ROMAN						-1	5
VK_DBE_HANJA						-1	5
VK_DBE_HANGEUL						-1	5
VK_DBE_JAMO						-1	5
VK_DBE_HANZI						-1	5
VK_DBE_TSANGJYE 					-1	5
VK_DBE_PHONETIC 					-1	5
VK_DBE_KANJI						-1	5
VK_DBE_IMEACTIVATE					-1	5
VK_DBE_CONV						-1	5
VK_DBE_NOCONV						-1	5
VK_DBE_TANGO						-1	5
VK_DBE_WORDREGISTER					-1	5
VK_DBE_IMEDIALOG					-1	5
VK_DBE_IME_MBSELECTED					-1	5
VK_DBE_IME_LBSELECTED					-1	5
VK_DBE_CODEINPUT					-1	5
VK_DBE_ALLCANDIDATE					-1	5
VK_DBE_PREVCANDIDATE					-1	5
VK_DBE_IMEDEACTIVATE					-1	5
VK_DBE_IME_WORDREGISTED 				-1	5
VK_DBE_IMECONTROL					-1	5
VK_DBE_IME_FREEPS					-1	5
VK_DBE_IMEMODEEXIT					-1	5
WC_DBE_APPSTAT						-1	5
WC_DBE_KBDSTAT						-1	5
WC_DBE_PECIC						-1	5
WM_DBE_SETAPPLSTAT					-1	5
WM_DBE_KKCPARAMS					-1	5
FCF_DBE_STATAREA					-1	5
DBE_KSF_ALPHANUMERIC					-1	5
DBE_KSF_KATAKANA					-1	5
DBE_KSF_HIRAGANA					-1	5
DBE_KSF_CAPS						-1	5
DBE_KSF_ROMAN						-1	5
DBE_KSF_HANKAKU 					-1	5
DBE_KSF_ZENKAKU 					-1	5
DBE_KSF_SBCS						-1	5
DBE_KSF_DBCS						-1	5
DBE_KSF_UPPER						-1	5
DBE_KSF_LOWER						-1	5
DBE_KSF_TEXT						-1	5
DBE_KSF_NOROMAN 					-1	5
DBE_KSF_DISABLEONTHESPOT				-1	5
DBE_KSF_ROMANTEXT					-1	5
DBE_KSF_JAMO						-1	5
DBE_KSF_HANGEUL 					-1	5
DBE_KSF_PHONETIC					-1	5
DBE_KSF_TSANGJYE					-1	5
DBE_WPM_APPLSTAT_VISIBILITY				-1	5
DBE_AS_APPLTOP						-1	5
DBE_AS_KBDTOP						-1	5
DBE_AS_PECICTOP 					-1	5
DBE_AS_APPLBOTTOM					-1	5
DBE_KKCPARAMS_SET					-1	5
DBE_KKCPARAMS_QUERY					-1	5
DBE_KKCPARAMS_PHYSICALATTRIBUTE 			-1	5
DBE_KKCPARAMS_PECICCURSORPOS				-1	5
DBE_IMCTL_QUERY 					-1	5
DBE_IMCTL_SET						-1	5
DBE_IMCTL_IMEENABLE					-1	5
DBE_IMCTL_IMEDISABLE					-1	5
DBE_IMCTL_IMEMODE					-1	5
DBE_IMCTL_NOTIMEMODE					-1	5
DBE_IMCTL_INHERIT_PFRAME				-1	5
DBE_IMCTL_INTERIMREQUEST				-1	5
DBE_MCTL_QUERY						-1	5
DBE_MCTL_SET						-1	5
DBE_MCTL_INPUTMODEREQUEST				-1	5
DBE_MCTL_JAPANREQ					-1	5
DBE_MCTL_ALPHANUMERIC					-1	5
DBE_MCTL_KATAKANA					-1	5
DBE_MCTL_HIRAGANA					-1	5
DBE_MCTL_SBCSCHAR					-1	5
DBE_MCTL_DBCSCHAR					-1	5
DBE_MCTL_ROMAN						-1	5
DBE_MCTL_NOROMAN					-1	5
DBE_MCTL_KKCREQ 					-1	5
DBE_MCTL_CP932REQ					-1	5
DBE_MCTL_KKCENABLE					-1	5
DBE_MCTL_KKCDISABLE					-1	5
DBE_MCTL_HANKAKU					-1	5
DBE_MCTL_ZENKAKU					-1	5
DBE_MCTL_JAMO						-1	5
DBE_MCTL_HANGEUL					-1	5
DBE_MCTL_INTERIMREQUEST 				-1	5
DBE_MCTL_PHONETIC					-1	5
DBE_MCTL_TSANGJYE					-1	5
DBE_MCTL_INHERIT_PFRAME 				-1	5
DBE_FD_DESC_SYSTEM					-1	5
DBE_FD_DESC_PUBLIC					-1	5
DBE_FD_DESC_PRIVATE					-1	5
SC_DBE_IME						-1	5
SC_DBE_IMESEPARATOR					-1	5
PM_INCLUDED						-1	5
INCL_AVIO						-1	5
INCL_BITMAPFILEFORMAT					-1	5
INCL_DEV						-1	5
INCL_ERRORS						-1	5
INCL_FONTFILEFORMAT					-1	5
INCL_GPI						-1	5
INCL_ORDERS						-1	5
INCL_PIC						-1	5
INCL_SPL						-1	5
INCL_WIN						-1	5
INCL_WINSTDDLGS 					-1	5
INCL_WINWORKPLACE					-1	5
AVIO_INCLUDED						-1	5
Vio16Associate						-1	5
Vio16CreateLogFont					-1	5
Vio16CreatePS						-1	5
Vio16DeleteSetId					-1	5
Vio16DestroyPS						-1	5
Vio16GetDeviceCellSize					-1	5
Vio16GetOrg						-1	5
Vio16QueryFonts 					-1	5
Vio16QuerySetIds					-1	5
Vio16SetDeviceCellSize					-1	5
Vio16SetOrg						-1	5
Vio16ShowPS						-1	5
Win16DefAVioWindowProc					-1	5
VioAssociate						-1	5
VioCreateLogFont					-1	5
VioCreatePS						-1	5
VioDeleteSetId						-1	5
VioDestroyPS						-1	5
VioGetDeviceCellSize					-1	5
VioGetOrg						-1	5
VioQueryFonts						-1	5
VioQuerySetIds						-1	5
VioSetDeviceCellSize					-1	5
VioSetOrg						-1	5
VioShowPS						-1	5
WinDefAVioWindowProc					-1	5
PMBITMAP_INCLUDED					-1	5
CBD_COMPRESSION 					-1	5
CBD_DECOMPRESSION					-1	5
CBD_BITS						-1	5
CBD_COLOR_CONVERSION					-1	5
BCA_UNCOMP						-1	5
BCA_HUFFMAN1D						-1	5
BCA_RLE4						-1	5
BCA_RLE8						-1	5
BCA_RLE24						-1	5
BRU_METRIC						-1	5
BRA_BOTTOMUP						-1	5
BRH_NOTHALFTONED					-1	5
BRH_ERRORDIFFUSION					-1	5
BRH_PANDA						-1	5
BRH_SUPERCIRCLE 					-1	5
BCE_PALETTE						-1	5
BCE_RGB 						-1	5
BFT_ICON						-1	5
BFT_BMAP						-1	5
BFT_POINTER						-1	5
BFT_COLORICON						-1	5
BFT_COLORPOINTER					-1	5
BFT_BITMAPARRAY 					-1	5
DDI_INCLUDED						-1	5
INCL_GRE_ARCS						-1	5
INCL_GRE_BITMAPS					-1	5
INCL_GRE_CLIP						-1	5
INCL_GRE_COLORTABLE					-1	5
INCL_GRE_DCS						-1	5
INCL_GRE_DEVICE 					-1	5
INCL_GRE_DEVMISC					-1	5
INCL_GRE_DEVSUPPORT					-1	5
INCL_GRE_FONTS						-1	5
INCL_GRE_JOURNALING					-1	5
INCL_GRE_LCID						-1	5
INCL_GRE_LINES						-1	5
INCL_GRE_MARKERS					-1	5
INCL_GRE_PALETTE					-1	5
INCL_GRE_PATHS						-1	5
INCL_GRE_PICK						-1	5
INCL_GRE_POLYGON					-1	5
INCL_GRE_REGIONS					-1	5
INCL_GRE_SCANS						-1	5
INCL_GRE_SCREEN 					-1	5
INCL_GRE_SETID						-1	5
INCL_GRE_STRINGS					-1	5
INCL_GRE_XFORMS 					-1	5
INCL_GRE_DEVMISC1					-1	5
INCL_GRE_DEVMISC2					-1	5
INCL_GRE_DEVMISC3					-1	5
MAXTABLEENTRIES 					-1	5
NUMBEROFMAJORFUN					-1	5
NUMBEROFMINORFUN					-1	5
POINTFX_DEFINED 					-1	5
COM_DRAW16						-1	5
COM_BOUND16						-1	5
COM_CORRELATE16 					-1	5
COM_ALT_BOUND16 					-1	5
COM_AREA16						-1	5
COM_PATH16						-1	5
COM_TRANSFORM16 					-1	5
COM_RECORDING16 					-1	5
COM_DEVICE16						-1	5
COM_SCR_BOUND16 					-1	5
COM_PRECLIP16						-1	5
COM_DRAW						-1	5
COM_BOUND						-1	5
COM_CORRELATE						-1	5
COM_ALT_BOUND						-1	5
COM_AREA						-1	5
COM_PATH						-1	5
COM_TRANSFORM						-1	5
COM_RECORDING						-1	5
COM_DEVICE						-1	5
COM_SCR_BOUND						-1	5
COM_PRECLIP						-1	5
COPYCRGN_ALLINTERSECT					-1	5
COPYCRGN_VISRGN 					-1	5
COPYCRGN_CLIPRGN					-1	5
SETUPDC_VISRGN						-1	5
SETUPDC_ORIGIN						-1	5
SETUPDC_ACCUMBOUNDSON					-1	5
SETUPDC_ACCUMBOUNDSOFF					-1	5
SETUPDC_RECALCCLIP					-1	5
SETUPDC_SETOWNER					-1	5
SETUPDC_CLEANDC 					-1	5
INAT_DEFAULTATTRIBUTES					-1	5
INAT_CURRENTATTRIBUTES					-1	5
GATTR_DEFAULT						-1	5
ATYPE_COLOR						-1	5
ATYPE_BACK_COLOR					-1	5
ATYPE_MIX_MODE						-1	5
ATYPE_BACK_MIX_MODE					-1	5
CHS_START_XY						-1	5
CHS_ATTR_INFO						-1	5
PCTL_DRAW						-1	5
PCTL_BOUND						-1	5
PCTL_CORRELATE						-1	5
PCTL_USERBOUNDS 					-1	5
PCTL_AREA						-1	5
RB_GPI							-1	5
RB_USER 						-1	5
GBD_GPI 						-1	5
GBD_USER						-1	5
EA_DRAW 						-1	5
EA_CANCEL						-1	5
BLTMODE_SRC_BITMAP					-1	5
BLTMODE_ATTRS_PRES					-1	5
BBO_TARGWORLD						-1	5
LCID_AVIO_1						-1	5
LCID_AVIO_2						-1	5
LCID_AVIO_3						-1	5
LCID_BITMAP_ID_REQUEST					-1	5
LCID_RANGE_GPI						-1	5
LCID_RANGE_AVIO 					-1	5
LCID_RANGE_BOTH 					-1	5
LCID_GRAPHICS_MIN					-1	5
LCID_GRAPHICS_MAX					-1	5
LCIDT_NONE						-1	5
RDC_RGBMODE						-1	5
RDC_SETOWNERTOSHELL					-1	5
SX_UNITY						-1	5
SX_CAT_AFTER						-1	5
SX_CAT_BEFORE						-1	5
SX_OVERWRITE						-1	5
MATRIX_SIMPLE						-1	5
MATRIX_UNITS						-1	5
MATRIX_XY_EXCHANGE					-1	5
MATRIX_X_NEGATE 					-1	5
MATRIX_Y_NEGATE 					-1	5
MATRIX_TRANSLATION					-1	5
NCC_CLEANDC						-1	5
LCOL_SYSCOLORS						-1	5
CAPS_MIX_OR						-1	5
CAPS_MIX_COPY						-1	5
CAPS_MIX_UNDERPAINT					-1	5
CAPS_MIX_XOR						-1	5
CAPS_MIX_INVISIBLE					-1	5
CAPS_MIX_AND						-1	5
CAPS_MIX_OTHER						-1	5
CAPS_DEV_FONT_SIM_BOLD					-1	5
CAPS_DEV_FONT_SIM_ITALIC				-1	5
CAPS_DEV_FONT_SIM_UNDERSCORE				-1	5
CAPS_DEV_FONT_SIM_STRIKEOUT				-1	5
CAPS_BACKMIX_OR 					-1	5
CAPS_BACKMIX_COPY					-1	5
CAPS_BACKMIX_UNDERPAINT 				-1	5
CAPS_BACKMIX_XOR					-1	5
CAPS_BACKMIX_INVISIBLE					-1	5
CAPS_RASTER_BITBLT					-1	5
CAPS_RASTER_BANDING					-1	5
CAPS_RASTER_STRETCHBLT					-1	5
CAPS_RASTER_SETPEL					-1	5
CAPS_FONT_OUTLINE_MANAGE				-1	5
CAPS_FONT_IMAGE_MANAGE					-1	5
SFONT_RASTER						-1	5
SFONT_OUTLINE						-1	5
FONT							-1	5
DCCAPS_LINE						-1	5
DCCAPS_CURVE						-1	5
DCCAPS_AREA						-1	5
DCCAPS_MARKER						-1	5
DCCAPS_TEXT						-1	5
BITMAP_USAGE_TRANSLATE					-1	5
SLH_FORMAT_IS_16_DOT_16 				-1	5
PSL_YMAJOR						-1	5
DI_HDC							-1	5
DI_HBITMAP						-1	5
REALIZE_FONT						-1	5
REALIZE_ENGINE_FONT					-1	5
DELETE_FONT						-1	5
RF_DEVICE_FONT						-1	5
RF_LOAD_ENGINE_FONT					-1	5
RF_DELETE_FONT						-1	5
RF_DELETE_ENGINE_FONT					-1	5
CURVE_IDENTIFIER					-1	5
LINE_IDENTIFIER 					-1	5
CURVE_DO_FIRST_PEL					-1	5
JNL_TEMP_FILE						-1	5
JNL_PERM_FILE						-1	5
JNL_ENGINERAM_FILE					-1	5
JNL_USERRAM_FILE					-1	5
JNL_DRAW_OPTIMIZATION					-1	5
JNL_BOUNDS_OPTIMIZATION 				-1	5
RP_BACKGROUND						-1	5
RP_FOREGROUND						-1	5
RP_DEFAULTSCHANGED					-1	5
LR_CLIPPED						-1	5
LR_NOTBORDER						-1	5
LR_BORDER						-1	5
LR_LEFT 						-1	5
LR_RIGHT						-1	5
OPTH_NO_CLIPPING_REQD					-1	5
OPTH_QRY_PATH_POINTS					-1	5
MC_32BIT						-1	5
MC_16BIT						-1	5
GSB_OPT_4BPP						-1	5
GSB_OPT_8BPP						-1	5
GSB_OPT_16BPP						-1	5
GSB_OPT_LINEAR						-1	5
GSB_OPT_PLANAR						-1	5
GSB_OPT_HRGN						-1	5
DDIM_INCLUDED						-1	5
NGreGetArcParameters					-1	5
GreGetArcParameters					-1	5
NGreSetArcParameters					-1	5
GreSetArcParameters					-1	5
NGreArc 						-1	5
GreArc							-1	5
NGrePartialArc						-1	5
GrePartialArc						-1	5
NGreFullArcInterior					-1	5
GreFullArcInterior					-1	5
NGreFullArcBoundary					-1	5
GreFullArcBoundary					-1	5
NGreFullArcBoth 					-1	5
GreFullArcBoth						-1	5
NGreBoxInterior 					-1	5
GreBoxInterior						-1	5
NGreBoxBoundary 					-1	5
GreBoxBoundary						-1	5
NGreBoxBoth						-1	5
GreBoxBoth						-1	5
NGrePolyFillet						-1	5
GrePolyFillet						-1	5
NGrePolyFilletSharp					-1	5
GrePolyFilletSharp					-1	5
NGrePolySpline						-1	5
GrePolySpline						-1	5
NGreDisjointLines					-1	5
GreDisjointLines					-1	5
NGreGetCurrentPosition					-1	5
GreGetCurrentPosition					-1	5
NGreSetCurrentPosition					-1	5
GreSetCurrentPosition					-1	5
NGrePolyLine						-1	5
GrePolyLine						-1	5
NGreDrawLinesInPath					-1	5
GreDrawLinesInPath					-1	5
NGrePolyShortLine					-1	5
GrePolyShortLine					-1	5
NGrePolyScanline					-1	5
GrePolyScanline 					-1	5
NGreDrawBits						-1	5
GreDrawBits						-1	5
NGreDeviceCreateBitmap					-1	5
GreDeviceCreateBitmap					-1	5
NGreDeviceDeleteBitmap					-1	5
GreDeviceDeleteBitmap					-1	5
NGreDeviceSelectBitmap					-1	5
GreDeviceSelectBitmap					-1	5
NGreBitblt						-1	5
GreBitblt						-1	5
NGreGetPel						-1	5
GreGetPel						-1	5
NGreSetPel						-1	5
GreSetPel						-1	5
NGreImageData						-1	5
GreImageData						-1	5
NGreScanLR						-1	5
GreScanLR						-1	5
NGreFloodFill						-1	5
GreFloodFill						-1	5
NGreSaveScreenBits					-1	5
GreSaveScreenBits					-1	5
NGreRestoreScreenBits					-1	5
GreRestoreScreenBits					-1	5
NGreDrawBorder						-1	5
GreDrawBorder						-1	5
NGreDeviceSetCursor					-1	5
GreDeviceSetCursor					-1	5
NGreGetBitmapBits					-1	5
GreGetBitmapBits					-1	5
NGreSetBitmapBits					-1	5
GreSetBitmapBits					-1	5
NGreSetColorCursor					-1	5
GreSetColorCursor					-1	5
NGreCharString						-1	5
GreCharString						-1	5
NGreCharStringPos					-1	5
GreCharStringPos					-1	5
NGreQueryTextBox					-1	5
GreQueryTextBox 					-1	5
NGreQueryCharPositions					-1	5
GreQueryCharPositions					-1	5
NGreQueryWidthTable					-1	5
GreQueryWidthTable					-1	5
NGrePolyMarker						-1	5
GrePolyMarker						-1	5
NGreCharRect						-1	5
GreCharRect						-1	5
NGreCharStr						-1	5
GreCharStr						-1	5
NGreScrollRect						-1	5
GreScrollRect						-1	5
NGreUpdateCursor					-1	5
GreUpdateCursor 					-1	5
NGreBeginArea						-1	5
GreBeginArea						-1	5
NGreEndArea						-1	5
GreEndArea						-1	5
NGreBeginPath						-1	5
GreBeginPath						-1	5
NGreEndPath						-1	5
GreEndPath						-1	5
NGreCloseFigure 					-1	5
GreCloseFigure						-1	5
NGreFillPath						-1	5
GreFillPath						-1	5
NGreOutlinePath 					-1	5
GreOutlinePath						-1	5
NGreModifyPath						-1	5
GreModifyPath						-1	5
NGreStrokePath						-1	5
GreStrokePath						-1	5
NGreSelectClipPath					-1	5
GreSelectClipPath					-1	5
NGreSavePath						-1	5
GreSavePath						-1	5
NGreRestorePath 					-1	5
GreRestorePath						-1	5
NGreAreaSetAttributes					-1	5
GreAreaSetAttributes					-1	5
NGrePathToRegion					-1	5
GrePathToRegion 					-1	5
NGrePolygonSet						-1	5
GrePolygonSet						-1	5
NGreDrawRLE						-1	5
GreDrawRLE						-1	5
NGreDevicePolygonSet					-1	5
GreDevicePolygonSet32					-1	5
NGreGetRegionBox					-1	5
GreGetRegionBox 					-1	5
NGreGetRegionRects					-1	5
GreGetRegionRects					-1	5
NGreOffsetRegion					-1	5
GreOffsetRegion 					-1	5
NGrePtInRegion						-1	5
GrePtInRegion						-1	5
NGreRectInRegion					-1	5
GreRectInRegion 					-1	5
NGreCreateRectRegion					-1	5
GreCreateRectRegion					-1	5
NGreDestroyRegion					-1	5
GreDestroyRegion					-1	5
NGreSetRectRegion					-1	5
GreSetRectRegion					-1	5
NGreCombineRegion					-1	5
GreCombineRegion					-1	5
NGreCombineRectRegion					-1	5
GreCombineRectRegion					-1	5
NGreCombineShortLineRegion				-1	5
GreCombineShortLineRegion				-1	5
NGreEqualRegion 					-1	5
GreEqualRegion						-1	5
NGrePaintRegion 					-1	5
GrePaintRegion						-1	5
NGreSetRegionOwner					-1	5
GreSetRegionOwner					-1	5
NGreFrameRegion 					-1	5
GreFrameRegion						-1	5
NGreGetClipBox						-1	5
GreGetClipBox						-1	5
NGreGetClipRects					-1	5
GreGetClipRects 					-1	5
NGreOffsetClipRegion					-1	5
GreOffsetClipRegion					-1	5
NGrePtVisible						-1	5
GrePtVisible						-1	5
NGreRectVisible 					-1	5
GreRectVisible						-1	5
NGreQueryClipRegion					-1	5
GreQueryClipRegion					-1	5
NGreSelectClipRegion					-1	5
GreSelectClipRegion					-1	5
NGreIntersectClipRectangle				-1	5
GreIntersectClipRectangle				-1	5
NGreExcludeClipRectangle				-1	5
GreExcludeClipRectangle 				-1	5
NGreSetXformRect					-1	5
GreSetXformRect 					-1	5
NGreSaveRegion						-1	5
GreSaveRegion						-1	5
NGreRestoreRegion					-1	5
GreRestoreRegion					-1	5
NGreSelectPathRegion					-1	5
GreSelectPathRegion					-1	5
NGreRegionSelectBitmap					-1	5
GreRegionSelectBitmap					-1	5
NGreCopyClipRegion					-1	5
GreCopyClipRegion					-1	5
NGreSetupDC						-1	5
GreSetupDC						-1	5
NGreGetPageUnits					-1	5
GreGetPageUnits 					-1	5
NGreSetPageUnits					-1	5
GreSetPageUnits 					-1	5
GreSetPageUnits 					-1	5
NGreGetModelXform					-1	5
GreGetModelXform					-1	5
NGreSetModelXform					-1	5
GreSetModelXform					-1	5
NGreGetWindowViewportXform				-1	5
GreGetWindowViewportXform				-1	5
NGreSetWindowViewportXform				-1	5
GreSetWindowViewportXform				-1	5
NGreGetGlobalViewingXform				-1	5
GreGetGlobalViewingXform				-1	5
NGreSetGlobalViewingXform				-1	5
GreSetGlobalViewingXform				-1	5
NGreSaveXformData					-1	5
GreSaveXformData					-1	5
NGreRestoreXformData					-1	5
GreRestoreXformData					-1	5
NGreGetPageViewport					-1	5
GreGetPageViewport					-1	5
NGreSetPageViewport					-1	5
GreSetPageViewport					-1	5
NGreGetGraphicsField					-1	5
GreGetGraphicsField					-1	5
NGreSetGraphicsField					-1	5
GreSetGraphicsField					-1	5
NGreGetViewingLimits					-1	5
GreGetViewingLimits					-1	5
NGreSetViewingLimits					-1	5
GreSetViewingLimits					-1	5
NGreQueryViewportSize					-1	5
GreQueryViewportSize					-1	5
NGreConvert						-1	5
GreConvert						-1	5
NGreSaveXform						-1	5
GreSaveXform						-1	5
NGreRestoreXform					-1	5
GreRestoreXform 					-1	5
NGreMultiplyXforms					-1	5
GreMultiplyXforms					-1	5
NGreConvertWithMatrix					-1	5
GreConvertWithMatrix					-1	5
NGreDeviceGetAttributes 				-1	5
GreDeviceGetAttributes					-1	5
NGreDeviceSetAVIOFont2					-1	5
GreDeviceSetAVIOFont2					-1	5
NGreGetPairKerningTable 				-1	5
GreGetPairKerningTable					-1	5
NGreDeviceSetAVIOFont					-1	5
GreDeviceSetAVIOFont					-1	5
NGreDeviceSetAttributes 				-1	5
GreDeviceSetAttributes					-1	5
NGreDeviceSetGlobalAttribute				-1	5
GreDeviceSetGlobalAttribute				-1	5
NGreNotifyClipChange					-1	5
GreNotifyClipChange					-1	5
NGreNotifyTransformChange				-1	5
GreNotifyTransformChange				-1	5
NGreRealizeFont 					-1	5
GreRealizeFont						-1	5
NGreErasePS						-1	5
GreErasePS						-1	5
NGreSetStyleRatio					-1	5
GreSetStyleRatio					-1	5
NGreDeviceQueryFontAttributes				-1	5
GreDeviceQueryFontAttributes				-1	5
NGreDeviceQueryFonts					-1	5
GreDeviceQueryFonts					-1	5
NGreDeviceInvalidateVisRegion				-1	5
GreDeviceInvalidateVisRegion				-1	5
NGreGetPickWindow					-1	5
GreGetPickWindow					-1	5
NGreSetPickWindow					-1	5
GreSetPickWindow					-1	5
NGreResetBounds 					-1	5
GreResetBounds						-1	5
NGreGetBoundsData					-1	5
GreGetBoundsData					-1	5
NGreAccumulateBounds					-1	5
GreAccumulateBounds					-1	5
NGreGetExtraError					-1	5
GreGetExtraError					-1	5
NGreSetExtraError					-1	5
GreSetExtraError					-1	5
NGreGetCodePage 					-1	5
GreGetCodePage						-1	5
NGreSetCodePage 					-1	5
GreSetCodePage						-1	5
NGreLockDevice						-1	5
GreLockDevice						-1	5
NGreUnlockDevice					-1	5
GreUnlockDevice 					-1	5
NGreDeath						-1	5
GreDeath						-1	5
NGreResurrection					-1	5
GreResurrection 					-1	5
NGreGetDCOrigin 					-1	5
GreGetDCOrigin						-1	5
NGreDeviceSetDCOrigin					-1	5
GreDeviceSetDCOrigin					-1	5
NGreGetLineOrigin					-1	5
GreGetLineOrigin					-1	5
NGreSetLineOrigin					-1	5
GreSetLineOrigin					-1	5
NGreGetStyleRatio					-1	5
GreGetStyleRatio					-1	5
NGreQueryColorData					-1	5
GreQueryColorData					-1	5
NGreQueryLogColorTable					-1	5
GreQueryLogColorTable					-1	5
NGreCreateLogColorTable 				-1	5
GreCreateLogColorTable					-1	5
NGreRealizeColorTable					-1	5
GreRealizeColorTable					-1	5
NGreUnrealizeColorTable 				-1	5
GreUnrealizeColorTable					-1	5
NGreQueryRealColors					-1	5
GreQueryRealColors					-1	5
NGreQueryNearestColor					-1	5
GreQueryNearestColor					-1	5
NGreQueryColorIndex					-1	5
GreQueryColorIndex					-1	5
NGreQueryRGBColor					-1	5
GreQueryRGBColor					-1	5
NGreQueryDeviceBitmaps					-1	5
GreQueryDeviceBitmaps					-1	5
NGreQueryDeviceCaps					-1	5
GreQueryDeviceCaps					-1	5
NGreEscape						-1	5
GreEscape						-1	5
NGreQueryHardcopyCaps					-1	5
GreQueryHardcopyCaps					-1	5
NGreQueryDevResource2					-1	5
GreQueryDevResource2					-1	5
GreOpenScreenChangeArea 				-1	5
NGreOpenScreenChangeArea				-1	5
GreGetScreenChangeArea					-1	5
NGreGetScreenChangeArea 				-1	5
GreCloseScreenChangeArea				-1	5
NGreCloseScreenChangeArea				-1	5
GreGetScreenBits					-1	5
NGreGetScreenBits					-1	5
GreSetScreenBits					-1	5
NGreSetScreenBits					-1	5
NGreDeviceCreatePalette 				-1	5
GreDeviceCreatePalette					-1	5
NGreDeviceDeletePalette 				-1	5
GreDeviceDeletePalette					-1	5
NGreDeviceSetPaletteEntries				-1	5
GreDeviceSetPaletteEntries				-1	5
NGreDeviceAnimatePalette				-1	5
GreDeviceAnimatePalette 				-1	5
NGreDeviceResizePalette 				-1	5
GreDeviceResizePalette					-1	5
NGreRealizePalette					-1	5
GreRealizePalette					-1	5
NGreQueryHWPaletteInfo					-1	5
GreQueryHWPaletteInfo					-1	5
NGreUpdateColors					-1	5
GreUpdateColors 					-1	5
NGreQueryPaletteRealization				-1	5
GreQueryPaletteRealization				-1	5
NGreGetVisRects 					-1	5
GreGetVisRects						-1	5
NGreCreatePalette					-1	5
GreCreatePalette					-1	5
NGreDeletePalette					-1	5
GreDeletePalette					-1	5
NGreSelectPalette					-1	5
GreSelectPalette					-1	5
NGreSetPaletteEntries					-1	5
GreSetPaletteEntries					-1	5
NGreAnimatePalette					-1	5
GreAnimatePalette					-1	5
NGreQueryPalette					-1	5
GreQueryPalette 					-1	5
NGreQueryPaletteInfo					-1	5
GreQueryPaletteInfo					-1	5
NGreSetPaletteOwner					-1	5
GreSetPaletteOwner					-1	5
NGreResizePalette					-1	5
GreResizePalette					-1	5
NGreQueryDefaultPaletteInfo				-1	5
GreQueryDefaultPaletteInfo				-1	5
NGreOpenDC						-1	5
GreOpenDC						-1	5
NGreCloseDC						-1	5
GreCloseDC						-1	5
NGreResetDC						-1	5
GreResetDC						-1	5
NGreGetHandle						-1	5
GreGetHandle						-1	5
NGreSetHandle						-1	5
GreSetHandle						-1	5
NGreGetProcessControl					-1	5
GreGetProcessControl					-1	5
NGreSetProcessControl					-1	5
GreSetProcessControl					-1	5
NGreSaveDC						-1	5
GreSaveDC						-1	5
NGreRestoreDC						-1	5
GreRestoreDC						-1	5
NGreQueryDeviceNames					-1	5
GreQueryDeviceNames					-1	5
NGreQueryEngineVersion					-1	5
GreQueryEngineVersion					-1	5
NGreSetDCOwner						-1	5
GreSetDCOwner						-1	5
NGreQueryBitmapSelection				-1	5
GreQueryBitmapSelection 				-1	5
NGreGetBitmapInfoHeader 				-1	5
GreGetBitmapInfoHeader					-1	5
NGreConvertBitmapData					-1	5
GreConvertBitmapData					-1	5
NGreInvalidateVisRegion 				-1	5
GreInvalidateVisRegion					-1	5
NGreCreateBitmap					-1	5
GreCreateBitmap 					-1	5
NGreDeleteBitmap					-1	5
GreDeleteBitmap 					-1	5
NGreSelectBitmap					-1	5
GreSelectBitmap 					-1	5
NGreGetBitmapParameters 				-1	5
GreGetBitmapParameters					-1	5
NGreGetBitmapDimension					-1	5
GreGetBitmapDimension					-1	5
NGreSetBitmapDimension					-1	5
GreSetBitmapDimension					-1	5
NGreSetCursor						-1	5
GreSetCursor						-1	5
NGreGetAttributes					-1	5
GreGetAttributes					-1	5
NGreSetAttributes					-1	5
GreSetAttributes					-1	5
NGreSetGlobalAttribute					-1	5
GreSetGlobalAttribute					-1	5
NGreSetBitmapOwner					-1	5
GreSetBitmapOwner					-1	5
NGreGetDefaultAttributes				-1	5
GreGetDefaultAttributes 				-1	5
NGreSetDefaultAttributes				-1	5
GreSetDefaultAttributes 				-1	5
NGreGetDefaultArcParameters				-1	5
GreGetDefaultArcParameters				-1	5
NGreSetDefaultArcParameters				-1	5
GreSetDefaultArcParameters				-1	5
NGreGetDefaultViewingLimits				-1	5
GreGetDefaultViewingLimits				-1	5
NGreSetDefaultViewingLimits				-1	5
GreSetDefaultViewingLimits				-1	5
NGreInitializeAttributes				-1	5
GreInitializeAttributes 				-1	5
NGreDeleteSetId 					-1	5
GreDeleteSetId						-1	5
NGreQueryNumberSetIds					-1	5
GreQueryNumberSetIds					-1	5
NGreQuerySetIds 					-1	5
GreQuerySetIds						-1	5
NGreQuerySetIdUsage					-1	5
GreQuerySetIdUsage					-1	5
NGreQueryBitmapHandle					-1	5
GreQueryBitmapHandle					-1	5
NGreSetBitmapID 					-1	5
GreSetBitmapID						-1	5
NGreCopyDCLoadData					-1	5
GreCopyDCLoadData					-1	5
NGreQueryFullFontFileDescriptions			-1	5
GreQueryFullFontFileDescriptions			-1	5
NGreQueryLogicalFont					-1	5
GreQueryLogicalFont					-1	5
NGreCreateLogicalFont					-1	5
GreCreateLogicalFont					-1	5
NGreLoadFont						-1	5
GreLoadFont						-1	5
NGreUnloadFont						-1	5
GreUnloadFont						-1	5
NGreQueryFonts						-1	5
GreQueryFonts						-1	5
NGreQueryFontAttributes 				-1	5
GreQueryFontAttributes					-1	5
NGreInstallIFI						-1	5
GreInstallIFI						-1	5
NGreLoadPublicFont					-1	5
GreLoadPublicFont					-1	5
NGreUnLoadPublicFont					-1	5
GreUnLoadPublicFont					-1	5
NGreQueryCodePageVector 				-1	5
GreQueryCodePageVector					-1	5
NGreQueryFontFileDescriptions				-1	5
GreQueryFontFileDescriptions				-1	5
NGreQueryFaceString					-1	5
GreQueryFaceString					-1	5
NGreQueryFontAction					-1	5
GreQueryFontAction					-1	5
NGreAccumulateJournalFile				-1	5
GreAccumulateJournalFile				-1	5
NGreCreateJournalFile					-1	5
GreCreateJournalFile					-1	5
NGreDeleteJournalFile					-1	5
GreDeleteJournalFile					-1	5
NGreStartJournalFile					-1	5
GreStartJournalFile					-1	5
NGreStopJournalFile					-1	5
GreStopJournalFile					-1	5
NGrePlayJournalFile					-1	5
GrePlayJournalFile					-1	5
NGreOpenJournalFile					-1	5
GreOpenJournalFile					-1	5
NGreCreateFontHandle					-1	5
GreCreateFontHandle					-1	5
NGreQueryFontHandle					-1	5
GreQueryFontHandle					-1	5
NGreSelectFontHandle					-1	5
GreSelectFontHandle					-1	5
NGreDeleteFontHandle					-1	5
GreDeleteFontHandle					-1	5
NGreSetFontHandleOwner					-1	5
GreSetFontHandleOwner					-1	5
DEV_INCLUDED						-1	5
INCL_DEVERRORS						-1	5
INCL_DEV						-1	5
INCL_DEV						-1	5
DEV_ERROR						-1	5
DEV_OK							-1	5
OD_QUEUED						-1	5
OD_DIRECT						-1	5
OD_INFO 						-1	5
OD_METAFILE						-1	5
OD_MEMORY						-1	5
OD_METAFILE_NOQUERY					-1	5
CAPS_FAMILY						-1	5
CAPS_IO_CAPS						-1	5
CAPS_TECHNOLOGY 					-1	5
CAPS_DRIVER_VERSION					-1	5
CAPS_WIDTH						-1	5
CAPS_HEIGHT						-1	5
CAPS_WIDTH_IN_CHARS					-1	5
CAPS_HEIGHT_IN_CHARS					-1	5
CAPS_HORIZONTAL_RESOLUTION				-1	5
CAPS_VERTICAL_RESOLUTION				-1	5
CAPS_CHAR_WIDTH 					-1	5
CAPS_CHAR_HEIGHT					-1	5
CAPS_SMALL_CHAR_WIDTH					-1	5
CAPS_SMALL_CHAR_HEIGHT					-1	5
CAPS_COLORS						-1	5
CAPS_COLOR_PLANES					-1	5
CAPS_COLOR_BITCOUNT					-1	5
CAPS_COLOR_TABLE_SUPPORT				-1	5
CAPS_MOUSE_BUTTONS					-1	5
CAPS_FOREGROUND_MIX_SUPPORT				-1	5
CAPS_BACKGROUND_MIX_SUPPORT				-1	5
CAPS_DEVICE_WINDOWING					-1	5
CAPS_ADDITIONAL_GRAPHICS				-1	5
CAPS_VIO_LOADABLE_FONTS 				-1	5
CAPS_WINDOW_BYTE_ALIGNMENT				-1	5
CAPS_BITMAP_FORMATS					-1	5
CAPS_RASTER_CAPS					-1	5
CAPS_MARKER_HEIGHT					-1	5
CAPS_MARKER_WIDTH					-1	5
CAPS_DEVICE_FONTS					-1	5
CAPS_GRAPHICS_SUBSET					-1	5
CAPS_GRAPHICS_VERSION					-1	5
CAPS_GRAPHICS_VECTOR_SUBSET				-1	5
CAPS_PHYS_COLORS					-1	5
CAPS_COLOR_INDEX					-1	5
CAPS_GRAPHICS_CHAR_WIDTH				-1	5
CAPS_GRAPHICS_CHAR_HEIGHT				-1	5
CAPS_HORIZONTAL_FONT_RES				-1	5
CAPS_VERTICAL_FONT_RES					-1	5
CAPS_DEVICE_FONT_SIM					-1	5
CAPS_LINEWIDTH_THICK					-1	5
CAPS_DEVICE_POLYSET_POINTS				-1	5
CAPS_IO_DUMMY						-1	5
CAPS_IO_SUPPORTS_OP					-1	5
CAPS_IO_SUPPORTS_IP					-1	5
CAPS_IO_SUPPORTS_IO					-1	5
CAPS_TECH_UNKNOWN					-1	5
CAPS_TECH_VECTOR_PLOTTER				-1	5
CAPS_TECH_RASTER_DISPLAY				-1	5
CAPS_TECH_RASTER_PRINTER				-1	5
CAPS_TECH_RASTER_CAMERA 				-1	5
CAPS_TECH_POSTSCRIPT					-1	5
CAPS_COLTABL_RGB_8					-1	5
CAPS_COLTABL_RGB_8_PLUS 				-1	5
CAPS_COLTABL_TRUE_MIX					-1	5
CAPS_COLTABL_REALIZE					-1	5
CAPS_FM_OR						-1	5
CAPS_FM_OVERPAINT					-1	5
CAPS_FM_XOR						-1	5
CAPS_FM_LEAVEALONE					-1	5
CAPS_FM_AND						-1	5
CAPS_FM_GENERAL_BOOLEAN 				-1	5
CAPS_BM_OR						-1	5
CAPS_BM_OVERPAINT					-1	5
CAPS_BM_XOR						-1	5
CAPS_BM_LEAVEALONE					-1	5
CAPS_BM_AND						-1	5
CAPS_BM_GENERAL_BOOLEAN 				-1	5
CAPS_BM_SRCTRANSPARENT					-1	5
CAPS_BM_DESTTRANSPARENT 				-1	5
CAPS_DEV_WINDOWING_SUPPORT				-1	5
CAPS_VDD_DDB_TRANSFER					-1	5
CAPS_GRAPHICS_KERNING_SUPPORT				-1	5
CAPS_FONT_OUTLINE_DEFAULT				-1	5
CAPS_FONT_IMAGE_DEFAULT 				-1	5
CAPS_SCALED_DEFAULT_MARKERS				-1	5
CAPS_COLOR_CURSOR_SUPPORT				-1	5
CAPS_PALETTE_MANAGER					-1	5
CAPS_COSMETIC_WIDELINE_SUPPORT				-1	5
CAPS_DIRECT_FILL					-1	5
CAPS_REBUILD_FILLS					-1	5
CAPS_CLIP_FILLS 					-1	5
CAPS_ENHANCED_FONTMETRICS				-1	5
CAPS_TRANSFORM_SUPPORT					-1	5
CAPS_BYTE_ALIGN_REQUIRED				-1	5
CAPS_BYTE_ALIGN_RECOMMENDED				-1	5
CAPS_BYTE_ALIGN_NOT_REQUIRED				-1	5
CAPS_RASTER_BITBLT					-1	5
CAPS_RASTER_BANDING					-1	5
CAPS_RASTER_BITBLT_SCALING				-1	5
CAPS_RASTER_SET_PEL					-1	5
CAPS_RASTER_FONTS					-1	5
CAPS_RASTER_FLOOD_FILL					-1	5
DEVESC_ERROR						-1	5
DEVESC_NOTIMPLEMENTED					-1	5
DEVESC_QUERYESCSUPPORT					-1	5
DEVESC_GETSCALINGFACTOR 				-1	5
DEVESC_QUERYVIOCELLSIZES				-1	5
DEVESC_GETCP						-1	5
DEVESC_STARTDOC 					-1	5
DEVESC_ENDDOC						-1	5
DEVESC_NEXTBAND 					-1	5
DEVESC_ABORTDOC 					-1	5
DEVESC_NEWFRAME 					-1	5
DEVESC_DRAFTMODE					-1	5
DEVESC_FLUSHOUTPUT					-1	5
DEVESC_RAWDATA						-1	5
DEVESC_SETMODE						-1	5
DEVESC_DBE_FIRST					-1	5
DEVESC_DBE_LAST 					-1	5
DEVESC_CHAR_EXTRA					-1	5
DEVESC_BREAK_EXTRA					-1	5
DEVESC_STD_JOURNAL					-1	5
DPDM_ERROR						-1	5
DPDM_NONE						-1	5
DPDM_POSTJOBPROP					-1	5
DPDM_CHANGEPROP 					-1	5
DPDM_QUERYJOBPROP					-1	5
DQHC_ERROR						-1	5
HCAPS_CURRENT						-1	5
HCAPS_SELECTABLE					-1	5
PMERR_INCLUDED						-1	5
INCL_WINERRORS_INCL					-1	5
PMERR_INVALID_HWND					-1	5
PMERR_INVALID_HMQ					-1	5
PMERR_PARAMETER_OUT_OF_RANGE				-1	5
PMERR_WINDOW_LOCK_UNDERFLOW				-1	5
PMERR_WINDOW_LOCK_OVERFLOW				-1	5
PMERR_BAD_WINDOW_LOCK_COUNT				-1	5
PMERR_WINDOW_NOT_LOCKED 				-1	5
PMERR_INVALID_SELECTOR					-1	5
PMERR_CALL_FROM_WRONG_THREAD				-1	5
PMERR_RESOURCE_NOT_FOUND				-1	5
PMERR_INVALID_STRING_PARM				-1	5
PMERR_INVALID_HHEAP					-1	5
PMERR_INVALID_HEAP_POINTER				-1	5
PMERR_INVALID_HEAP_SIZE_PARM				-1	5
PMERR_INVALID_HEAP_SIZE 				-1	5
PMERR_INVALID_HEAP_SIZE_WORD				-1	5
PMERR_HEAP_OUT_OF_MEMORY				-1	5
PMERR_HEAP_MAX_SIZE_REACHED				-1	5
PMERR_INVALID_HATOMTBL					-1	5
PMERR_INVALID_ATOM					-1	5
PMERR_INVALID_ATOM_NAME 				-1	5
PMERR_INVALID_INTEGER_ATOM				-1	5
PMERR_ATOM_NAME_NOT_FOUND				-1	5
PMERR_QUEUE_TOO_LARGE					-1	5
PMERR_INVALID_FLAG					-1	5
PMERR_INVALID_HACCEL					-1	5
PMERR_INVALID_HPTR					-1	5
PMERR_INVALID_HENUM					-1	5
PMERR_INVALID_SRC_CODEPAGE				-1	5
PMERR_INVALID_DST_CODEPAGE				-1	5
PMERR_UNKNOWN_COMPONENT_ID				-1	5
PMERR_UNKNOWN_ERROR_CODE				-1	5
PMERR_SEVERITY_LEVELS					-1	5
PMERR_INVALID_RESOURCE_FORMAT				-1	5
WINDBG_WINDOW_UNLOCK_WAIT				-1	5
PMERR_NO_MSG_QUEUE					-1	5
PMERR_WIN_DEBUGMSG					-1	5
PMERR_QUEUE_FULL					-1	5
PMERR_LIBRARY_LOAD_FAILED				-1	5
PMERR_PROCEDURE_LOAD_FAILED				-1	5
PMERR_LIBRARY_DELETE_FAILED				-1	5
PMERR_PROCEDURE_DELETE_FAILED				-1	5
PMERR_ARRAY_TOO_LARGE					-1	5
PMERR_ARRAY_TOO_SMALL					-1	5
PMERR_DATATYPE_ENTRY_BAD_INDEX				-1	5
PMERR_DATATYPE_ENTRY_CTL_BAD				-1	5
PMERR_DATATYPE_ENTRY_CTL_MISS				-1	5
PMERR_DATATYPE_ENTRY_INVALID				-1	5
PMERR_DATATYPE_ENTRY_NOT_NUM				-1	5
PMERR_DATATYPE_ENTRY_NOT_OFF				-1	5
PMERR_DATATYPE_INVALID					-1	5
PMERR_DATATYPE_NOT_UNIQUE				-1	5
PMERR_DATATYPE_TOO_LONG 				-1	5
PMERR_DATATYPE_TOO_SMALL				-1	5
PMERR_DIRECTION_INVALID 				-1	5
PMERR_INVALID_HAB					-1	5
PMERR_INVALID_HSTRUCT					-1	5
PMERR_LENGTH_TOO_SMALL					-1	5
PMERR_MSGID_TOO_SMALL					-1	5
PMERR_NO_HANDLE_ALLOC					-1	5
PMERR_NOT_IN_A_PM_SESSION				-1	5
PMERR_MSG_QUEUE_ALREADY_EXISTS				-1	5
PMERR_OLD_RESOURCE					-1	5
INCL_SHLERRORS_INCL					-1	5
PMERR_INVALID_PIB					-1	5
PMERR_INSUFF_SPACE_TO_ADD				-1	5
PMERR_INVALID_GROUP_HANDLE				-1	5
PMERR_DUPLICATE_TITLE					-1	5
PMERR_INVALID_TITLE					-1	5
PMERR_HANDLE_NOT_IN_GROUP				-1	5
PMERR_INVALID_TARGET_HANDLE				-1	5
PMERR_INVALID_PATH_STATEMENT				-1	5
PMERR_NO_PROGRAM_FOUND					-1	5
PMERR_INVALID_BUFFER_SIZE				-1	5
PMERR_BUFFER_TOO_SMALL					-1	5
PMERR_PL_INITIALISATION_FAIL				-1	5
PMERR_CANT_DESTROY_SYS_GROUP				-1	5
PMERR_INVALID_TYPE_CHANGE				-1	5
PMERR_INVALID_PROGRAM_HANDLE				-1	5
PMERR_NOT_CURRENT_PL_VERSION				-1	5
PMERR_INVALID_CIRCULAR_REF				-1	5
PMERR_MEMORY_ALLOCATION_ERR				-1	5
PMERR_MEMORY_DEALLOCATION_ERR				-1	5
PMERR_TASK_HEADER_TOO_BIG				-1	5
PMERR_INVALID_INI_FILE_HANDLE				-1	5
PMERR_MEMORY_SHARE					-1	5
PMERR_OPEN_QUEUE					-1	5
PMERR_CREATE_QUEUE					-1	5
PMERR_WRITE_QUEUE					-1	5
PMERR_READ_QUEUE					-1	5
PMERR_CALL_NOT_EXECUTED 				-1	5
PMERR_UNKNOWN_APIPKT					-1	5
PMERR_INITHREAD_EXISTS					-1	5
PMERR_CREATE_THREAD					-1	5
PMERR_NO_HK_PROFILE_INSTALLED				-1	5
PMERR_INVALID_DIRECTORY 				-1	5
PMERR_WILDCARD_IN_FILENAME				-1	5
PMERR_FILENAME_BUFFER_FULL				-1	5
PMERR_FILENAME_TOO_LONG 				-1	5
PMERR_INI_FILE_IS_SYS_OR_USER				-1	5
PMERR_BROADCAST_PLMSG					-1	5
PMERR_190_INIT_DONE					-1	5
PMERR_HMOD_FOR_PMSHAPI					-1	5
PMERR_SET_HK_PROFILE					-1	5
PMERR_API_NOT_ALLOWED					-1	5
PMERR_INI_STILL_OPEN					-1	5
PMERR_PROGDETAILS_NOT_IN_INI				-1	5
PMERR_PIBSTRUCT_NOT_IN_INI				-1	5
PMERR_INVALID_DISKPROGDETAILS				-1	5
PMERR_PROGDETAILS_READ_FAILURE				-1	5
PMERR_PROGDETAILS_WRITE_FAILURE 			-1	5
PMERR_PROGDETAILS_QSIZE_FAILURE 			-1	5
PMERR_INVALID_PROGDETAILS				-1	5
PMERR_SHEPROFILEHOOK_NOT_FOUND				-1	5
PMERR_190PLCONVERTED					-1	5
PMERR_FAILED_TO_CONVERT_INI_PL				-1	5
PMERR_PMSHAPI_NOT_INITIALISED				-1	5
PMERR_INVALID_SHELL_API_HOOK_ID 			-1	5
PMERR_DOS_ERROR 					-1	5
PMERR_NO_SPACE						-1	5
PMERR_INVALID_SWITCH_HANDLE				-1	5
PMERR_NO_HANDLE 					-1	5
PMERR_INVALID_PROCESS_ID				-1	5
PMERR_NOT_SHELL 					-1	5
PMERR_INVALID_WINDOW					-1	5
PMERR_INVALID_POST_MSG					-1	5
PMERR_INVALID_PARAMETERS				-1	5
PMERR_INVALID_PROGRAM_TYPE				-1	5
PMERR_NOT_EXTENDED_FOCUS				-1	5
PMERR_INVALID_SESSION_ID				-1	5
PMERR_SMG_INVALID_ICON_FILE				-1	5
PMERR_SMG_ICON_NOT_CREATED				-1	5
PMERR_SHL_DEBUG 					-1	5
PMERR_OPENING_INI_FILE					-1	5
PMERR_INI_FILE_CORRUPT					-1	5
PMERR_INVALID_PARM					-1	5
PMERR_NOT_IN_IDX					-1	5
PMERR_NO_ENTRIES_IN_GROUP				-1	5
PMERR_INI_WRITE_FAIL					-1	5
PMERR_IDX_FULL						-1	5
PMERR_INI_PROTECTED					-1	5
PMERR_MEMORY_ALLOC					-1	5
PMERR_INI_INIT_ALREADY_DONE				-1	5
PMERR_INVALID_INTEGER					-1	5
PMERR_INVALID_ASCIIZ					-1	5
PMERR_CAN_NOT_CALL_SPOOLER				-1	5
PMERR_VALIDATION_REJECTED				-1	5
PMERR_WARNING_WINDOW_NOT_KILLED 			-1	5
PMERR_ERROR_INVALID_WINDOW				-1	5
PMERR_ALREADY_INITIALIZED				-1	5
PMERR_MSG_PROG_NO_MOU					-1	5
PMERR_MSG_PROG_NON_RECOV				-1	5
PMERR_WINCONV_INVALID_PATH				-1	5
PMERR_PI_NOT_INITIALISED				-1	5
PMERR_PL_NOT_INITIALISED				-1	5
PMERR_NO_TASK_MANAGER					-1	5
PMERR_SAVE_NOT_IN_PROGRESS				-1	5
PMERR_NO_STACK_SPACE					-1	5
PMERR_INVALID_COLR_FIELD				-1	5
PMERR_INVALID_COLR_VALUE				-1	5
PMERR_COLR_WRITE					-1	5
PMERR_TARGET_FILE_EXISTS				-1	5
PMERR_SOURCE_SAME_AS_TARGET				-1	5
PMERR_SOURCE_FILE_NOT_FOUND				-1	5
PMERR_INVALID_NEW_PATH					-1	5
PMERR_TARGET_FILE_NOT_FOUND				-1	5
PMERR_INVALID_DRIVE_NUMBER				-1	5
PMERR_NAME_TOO_LONG					-1	5
PMERR_NOT_ENOUGH_ROOM_ON_DISK				-1	5
PMERR_NOT_ENOUGH_MEM					-1	5
PMERR_LOG_DRV_DOES_NOT_EXIST				-1	5
PMERR_INVALID_DRIVE					-1	5
PMERR_ACCESS_DENIED					-1	5
PMERR_NO_FIRST_SLASH					-1	5
PMERR_READ_ONLY_FILE					-1	5
PMERR_GROUP_PROTECTED					-1	5
PMERR_INVALID_PROGRAM_CATEGORY				-1	5
PMERR_INVALID_APPL					-1	5
PMERR_CANNOT_START					-1	5
PMERR_STARTED_IN_BACKGROUND				-1	5
PMERR_INVALID_HAPP					-1	5
PMERR_CANNOT_STOP					-1	5
PMERR_INTERNAL_ERROR_1					-1	5
PMERR_INTERNAL_ERROR_2					-1	5
PMERR_INTERNAL_ERROR_3					-1	5
PMERR_INTERNAL_ERROR_4					-1	5
PMERR_INTERNAL_ERROR_5					-1	5
PMERR_INTERNAL_ERROR_6					-1	5
PMERR_INTERNAL_ERROR_7					-1	5
PMERR_INTERNAL_ERROR_8					-1	5
PMERR_INTERNAL_ERROR_9					-1	5
PMERR_INTERNAL_ERROR_10 				-1	5
PMERR_INTERNAL_ERROR_11 				-1	5
PMERR_INTERNAL_ERROR_12 				-1	5
PMERR_INTERNAL_ERROR_13 				-1	5
PMERR_INTERNAL_ERROR_14 				-1	5
PMERR_INTERNAL_ERROR_15 				-1	5
PMERR_INTERNAL_ERROR_16 				-1	5
PMERR_INTERNAL_ERROR_17 				-1	5
PMERR_INTERNAL_ERROR_18 				-1	5
PMERR_INTERNAL_ERROR_19 				-1	5
PMERR_INTERNAL_ERROR_20 				-1	5
PMERR_INTERNAL_ERROR_21 				-1	5
PMERR_INTERNAL_ERROR_22 				-1	5
PMERR_INTERNAL_ERROR_23 				-1	5
PMERR_INTERNAL_ERROR_24 				-1	5
PMERR_INTERNAL_ERROR_25 				-1	5
PMERR_INTERNAL_ERROR_26 				-1	5
PMERR_INTERNAL_ERROR_27 				-1	5
PMERR_INTERNAL_ERROR_28 				-1	5
PMERR_INTERNAL_ERROR_29 				-1	5
PMERR_INVALID_FREE_MESSAGE_ID				-1	5
PMERR_FUNCTION_NOT_SUPPORTED				-1	5
PMERR_INVALID_ARRAY_COUNT				-1	5
PMERR_INVALID_LENGTH					-1	5
PMERR_INVALID_BUNDLE_TYPE				-1	5
PMERR_INVALID_PARAMETER 				-1	5
PMERR_INVALID_NUMBER_OF_PARMS				-1	5
PMERR_GREATER_THAN_64K					-1	5
PMERR_INVALID_PARAMETER_TYPE				-1	5
PMERR_NEGATIVE_STRCOND_DIM				-1	5
PMERR_INVALID_NUMBER_OF_TYPES				-1	5
PMERR_INCORRECT_HSTRUCT 				-1	5
PMERR_INVALID_ARRAY_SIZE				-1	5
PMERR_INVALID_CONTROL_DATATYPE				-1	5
PMERR_INCOMPLETE_CONTROL_SEQU				-1	5
PMERR_INVALID_DATATYPE					-1	5
PMERR_INCORRECT_DATATYPE				-1	5
PMERR_NOT_SELF_DESCRIBING_DTYP				-1	5
PMERR_INVALID_CTRL_SEQ_INDEX				-1	5
PMERR_INVALID_TYPE_FOR_LENGTH				-1	5
PMERR_INVALID_TYPE_FOR_OFFSET				-1	5
PMERR_INVALID_TYPE_FOR_MPARAM				-1	5
PMERR_INVALID_MESSAGE_ID				-1	5
PMERR_C_LENGTH_TOO_SMALL				-1	5
PMERR_APPL_STRUCTURE_TOO_SMALL				-1	5
PMERR_INVALID_ERRORINFO_HANDLE				-1	5
PMERR_INVALID_CHARACTER_INDEX				-1	5
INCL_WPERRORS_INCL					-1	5
WPERR_PROTECTED_CLASS					-1	5
WPERR_INVALID_CLASS					-1	5
WPERR_INVALID_SUPERCLASS				-1	5
WPERR_NO_MEMORY 					-1	5
WPERR_SEMAPHORE_ERROR					-1	5
WPERR_BUFFER_TOO_SMALL					-1	5
WPERR_CLSLOADMOD_FAILED 				-1	5
WPERR_CLSPROCADDR_FAILED				-1	5
WPERR_OBJWORD_LOCATION					-1	5
WPERR_INVALID_OBJECT					-1	5
WPERR_MEMORY_CLEANUP					-1	5
WPERR_INVALID_MODULE					-1	5
WPERR_INVALID_OLDCLASS					-1	5
WPERR_INVALID_NEWCLASS					-1	5
WPERR_NOT_IMMEDIATE_CHILD				-1	5
WPERR_NOT_WORKPLACE_CLASS				-1	5
WPERR_CANT_REPLACE_METACLS				-1	5
WPERR_INI_FILE_WRITE					-1	5
WPERR_INVALID_FOLDER					-1	5
WPERR_BUFFER_OVERFLOW					-1	5
WPERR_OBJECT_NOT_FOUND					-1	5
WPERR_INVALID_HFIND					-1	5
WPERR_INVALID_COUNT					-1	5
WPERR_INVALID_BUFFER					-1	5
WPERR_ALREADY_EXISTS					-1	5
WPERR_INVALID_FLAGS					-1	5
WPERR_INVALID_OBJECTID					-1	5
INCL_GPIERRORS_INCL					-1	5
PMERR_OK						-1	5
PMERR_ALREADY_IN_AREA					-1	5
PMERR_ALREADY_IN_ELEMENT				-1	5
PMERR_ALREADY_IN_PATH					-1	5
PMERR_ALREADY_IN_SEG					-1	5
PMERR_AREA_INCOMPLETE					-1	5
PMERR_BASE_ERROR					-1	5
PMERR_BITBLT_LENGTH_EXCEEDED				-1	5
PMERR_BITMAP_IN_USE					-1	5
PMERR_BITMAP_IS_SELECTED				-1	5
PMERR_BITMAP_NOT_FOUND					-1	5
PMERR_BITMAP_NOT_SELECTED				-1	5
PMERR_BOUNDS_OVERFLOW					-1	5
PMERR_CALLED_SEG_IS_CHAINED				-1	5
PMERR_CALLED_SEG_IS_CURRENT				-1	5
PMERR_CALLED_SEG_NOT_FOUND				-1	5
PMERR_CANNOT_DELETE_ALL_DATA				-1	5
PMERR_CANNOT_REPLACE_ELEMENT_0				-1	5
PMERR_COL_TABLE_NOT_REALIZABLE				-1	5
PMERR_COL_TABLE_NOT_REALIZED				-1	5
PMERR_COORDINATE_OVERFLOW				-1	5
PMERR_CORR_FORMAT_MISMATCH				-1	5
PMERR_DATA_TOO_LONG					-1	5
PMERR_DC_IS_ASSOCIATED					-1	5
PMERR_DESC_STRING_TRUNCATED				-1	5
PMERR_DEVICE_DRIVER_ERROR_1				-1	5
PMERR_DEVICE_DRIVER_ERROR_2				-1	5
PMERR_DEVICE_DRIVER_ERROR_3				-1	5
PMERR_DEVICE_DRIVER_ERROR_4				-1	5
PMERR_DEVICE_DRIVER_ERROR_5				-1	5
PMERR_DEVICE_DRIVER_ERROR_6				-1	5
PMERR_DEVICE_DRIVER_ERROR_7				-1	5
PMERR_DEVICE_DRIVER_ERROR_8				-1	5
PMERR_DEVICE_DRIVER_ERROR_9				-1	5
PMERR_DEVICE_DRIVER_ERROR_10				-1	5
PMERR_DEV_FUNC_NOT_INSTALLED				-1	5
PMERR_DOSOPEN_FAILURE					-1	5
PMERR_DOSREAD_FAILURE					-1	5
PMERR_DRIVER_NOT_FOUND					-1	5
PMERR_DUP_SEG						-1	5
PMERR_DYNAMIC_SEG_SEQ_ERROR				-1	5
PMERR_DYNAMIC_SEG_ZERO_INV				-1	5
PMERR_ELEMENT_INCOMPLETE				-1	5
PMERR_ESC_CODE_NOT_SUPPORTED				-1	5
PMERR_EXCEEDS_MAX_SEG_LENGTH				-1	5
PMERR_FONT_AND_MODE_MISMATCH				-1	5
PMERR_FONT_FILE_NOT_LOADED				-1	5
PMERR_FONT_NOT_LOADED					-1	5
PMERR_FONT_TOO_BIG					-1	5
PMERR_HARDWARE_INIT_FAILURE				-1	5
PMERR_HBITMAP_BUSY					-1	5
PMERR_HDC_BUSY						-1	5
PMERR_HRGN_BUSY 					-1	5
PMERR_HUGE_FONTS_NOT_SUPPORTED				-1	5
PMERR_ID_HAS_NO_BITMAP					-1	5
PMERR_IMAGE_INCOMPLETE					-1	5
PMERR_INCOMPAT_COLOR_FORMAT				-1	5
PMERR_INCOMPAT_COLOR_OPTIONS				-1	5
PMERR_INCOMPATIBLE_BITMAP				-1	5
PMERR_INCOMPATIBLE_METAFILE				-1	5
PMERR_INCORRECT_DC_TYPE 				-1	5
PMERR_INSUFFICIENT_DISK_SPACE				-1	5
PMERR_INSUFFICIENT_MEMORY				-1	5
PMERR_INV_ANGLE_PARM					-1	5
PMERR_INV_ARC_CONTROL					-1	5
PMERR_INV_AREA_CONTROL					-1	5
PMERR_INV_ARC_POINTS					-1	5
PMERR_INV_ATTR_MODE					-1	5
PMERR_INV_BACKGROUND_COL_ATTR				-1	5
PMERR_INV_BACKGROUND_MIX_ATTR				-1	5
PMERR_INV_BITBLT_MIX					-1	5
PMERR_INV_BITBLT_STYLE					-1	5
PMERR_INV_BITMAP_DIMENSION				-1	5
PMERR_INV_BOX_CONTROL					-1	5
PMERR_INV_BOX_ROUNDING_PARM				-1	5
PMERR_INV_CHAR_ANGLE_ATTR				-1	5
PMERR_INV_CHAR_DIRECTION_ATTR				-1	5
PMERR_INV_CHAR_MODE_ATTR				-1	5
PMERR_INV_CHAR_POS_OPTIONS				-1	5
PMERR_INV_CHAR_SET_ATTR 				-1	5
PMERR_INV_CHAR_SHEAR_ATTR				-1	5
PMERR_INV_CLIP_PATH_OPTIONS				-1	5
PMERR_INV_CODEPAGE					-1	5
PMERR_INV_COLOR_ATTR					-1	5
PMERR_INV_COLOR_DATA					-1	5
PMERR_INV_COLOR_FORMAT					-1	5
PMERR_INV_COLOR_INDEX					-1	5
PMERR_INV_COLOR_OPTIONS 				-1	5
PMERR_INV_COLOR_START_INDEX				-1	5
PMERR_INV_COORD_OFFSET					-1	5
PMERR_INV_COORD_SPACE					-1	5
PMERR_INV_COORDINATE					-1	5
PMERR_INV_CORRELATE_DEPTH				-1	5
PMERR_INV_CORRELATE_TYPE				-1	5
PMERR_INV_CURSOR_BITMAP 				-1	5
PMERR_INV_DC_DATA					-1	5
PMERR_INV_DC_TYPE					-1	5
PMERR_INV_DEVICE_NAME					-1	5
PMERR_INV_DEV_MODES_OPTIONS				-1	5
PMERR_INV_DRAW_CONTROL					-1	5
PMERR_INV_DRAW_VALUE					-1	5
PMERR_INV_DRAWING_MODE					-1	5
PMERR_INV_DRIVER_DATA					-1	5
PMERR_INV_DRIVER_NAME					-1	5
PMERR_INV_DRAW_BORDER_OPTION				-1	5
PMERR_INV_EDIT_MODE					-1	5
PMERR_INV_ELEMENT_OFFSET				-1	5
PMERR_INV_ELEMENT_POINTER				-1	5
PMERR_INV_END_PATH_OPTIONS				-1	5
PMERR_INV_ESC_CODE					-1	5
PMERR_INV_ESCAPE_DATA					-1	5
PMERR_INV_EXTENDED_LCID 				-1	5
PMERR_INV_FILL_PATH_OPTIONS				-1	5
PMERR_INV_FIRST_CHAR					-1	5
PMERR_INV_FONT_ATTRS					-1	5
PMERR_INV_FONT_FILE_DATA				-1	5
PMERR_INV_FOR_THIS_DC_TYPE				-1	5
PMERR_INV_FORMAT_CONTROL				-1	5
PMERR_INV_FORMS_CODE					-1	5
PMERR_INV_FONTDEF					-1	5
PMERR_INV_GEOM_LINE_WIDTH_ATTR				-1	5
PMERR_INV_GETDATA_CONTROL				-1	5
PMERR_INV_GRAPHICS_FIELD				-1	5
PMERR_INV_HBITMAP					-1	5
PMERR_INV_HDC						-1	5
PMERR_INV_HJOURNAL					-1	5
PMERR_INV_HMF						-1	5
PMERR_INV_HPS						-1	5
PMERR_INV_HRGN						-1	5
PMERR_INV_ID						-1	5
PMERR_INV_IMAGE_DATA_LENGTH				-1	5
PMERR_INV_IMAGE_DIMENSION				-1	5
PMERR_INV_IMAGE_FORMAT					-1	5
PMERR_INV_IN_AREA					-1	5
PMERR_INV_IN_CALLED_SEG 				-1	5
PMERR_INV_IN_CURRENT_EDIT_MODE				-1	5
PMERR_INV_IN_DRAW_MODE					-1	5
PMERR_INV_IN_ELEMENT					-1	5
PMERR_INV_IN_IMAGE					-1	5
PMERR_INV_IN_PATH					-1	5
PMERR_INV_IN_RETAIN_MODE				-1	5
PMERR_INV_IN_SEG					-1	5
PMERR_INV_IN_VECTOR_SYMBOL				-1	5
PMERR_INV_INFO_TABLE					-1	5
PMERR_INV_JOURNAL_OPTION				-1	5
PMERR_INV_KERNING_FLAGS 				-1	5
PMERR_INV_LENGTH_OR_COUNT				-1	5
PMERR_INV_LINE_END_ATTR 				-1	5
PMERR_INV_LINE_JOIN_ATTR				-1	5
PMERR_INV_LINE_TYPE_ATTR				-1	5
PMERR_INV_LINE_WIDTH_ATTR				-1	5
PMERR_INV_LOGICAL_ADDRESS				-1	5
PMERR_INV_MARKER_BOX_ATTR				-1	5
PMERR_INV_MARKER_SET_ATTR				-1	5
PMERR_INV_MARKER_SYMBOL_ATTR				-1	5
PMERR_INV_MATRIX_ELEMENT				-1	5
PMERR_INV_MAX_HITS					-1	5
PMERR_INV_METAFILE					-1	5
PMERR_INV_METAFILE_LENGTH				-1	5
PMERR_INV_METAFILE_OFFSET				-1	5
PMERR_INV_MICROPS_DRAW_CONTROL				-1	5
PMERR_INV_MICROPS_FUNCTION				-1	5
PMERR_INV_MICROPS_ORDER 				-1	5
PMERR_INV_MIX_ATTR					-1	5
PMERR_INV_MODE_FOR_OPEN_DYN				-1	5
PMERR_INV_MODE_FOR_REOPEN_SEG				-1	5
PMERR_INV_MODIFY_PATH_MODE				-1	5
PMERR_INV_MULTIPLIER					-1	5
PMERR_INV_NESTED_FIGURES				-1	5
PMERR_INV_OR_INCOMPAT_OPTIONS				-1	5
PMERR_INV_ORDER_LENGTH					-1	5
PMERR_INV_ORDERING_PARM 				-1	5
PMERR_INV_OUTSIDE_DRAW_MODE				-1	5
PMERR_INV_PAGE_VIEWPORT 				-1	5
PMERR_INV_PATH_ID					-1	5
PMERR_INV_PATH_MODE					-1	5
PMERR_INV_PATTERN_ATTR					-1	5
PMERR_INV_PATTERN_REF_PT_ATTR				-1	5
PMERR_INV_PATTERN_SET_ATTR				-1	5
PMERR_INV_PATTERN_SET_FONT				-1	5
PMERR_INV_PICK_APERTURE_OPTION				-1	5
PMERR_INV_PICK_APERTURE_POSN				-1	5
PMERR_INV_PICK_APERTURE_SIZE				-1	5
PMERR_INV_PICK_NUMBER					-1	5
PMERR_INV_PLAY_METAFILE_OPTION				-1	5
PMERR_INV_PRIMITIVE_TYPE				-1	5
PMERR_INV_PS_SIZE					-1	5
PMERR_INV_PUTDATA_FORMAT				-1	5
PMERR_INV_QUERY_ELEMENT_NO				-1	5
PMERR_INV_RECT						-1	5
PMERR_INV_REGION_CONTROL				-1	5
PMERR_INV_REGION_MIX_MODE				-1	5
PMERR_INV_REPLACE_MODE_FUNC				-1	5
PMERR_INV_RESERVED_FIELD				-1	5
PMERR_INV_RESET_OPTIONS 				-1	5
PMERR_INV_RGBCOLOR					-1	5
PMERR_INV_SCAN_START					-1	5
PMERR_INV_SEG_ATTR					-1	5
PMERR_INV_SEG_ATTR_VALUE				-1	5
PMERR_INV_SEG_CH_LENGTH 				-1	5
PMERR_INV_SEG_NAME					-1	5
PMERR_INV_SEG_OFFSET					-1	5
PMERR_INV_SETID 					-1	5
PMERR_INV_SETID_TYPE					-1	5
PMERR_INV_SET_VIEWPORT_OPTION				-1	5
PMERR_INV_SHARPNESS_PARM				-1	5
PMERR_INV_SOURCE_OFFSET 				-1	5
PMERR_INV_STOP_DRAW_VALUE				-1	5
PMERR_INV_TRANSFORM_TYPE				-1	5
PMERR_INV_USAGE_PARM					-1	5
PMERR_INV_VIEWING_LIMITS				-1	5
PMERR_JFILE_BUSY					-1	5
PMERR_JNL_FUNC_DATA_TOO_LONG				-1	5
PMERR_KERNING_NOT_SUPPORTED				-1	5
PMERR_LABEL_NOT_FOUND					-1	5
PMERR_MATRIX_OVERFLOW					-1	5
PMERR_METAFILE_INTERNAL_ERROR				-1	5
PMERR_METAFILE_IN_USE					-1	5
PMERR_METAFILE_LIMIT_EXCEEDED				-1	5
PMERR_NAME_STACK_FULL					-1	5
PMERR_NOT_CREATED_BY_DEVOPENDC				-1	5
PMERR_NOT_IN_AREA					-1	5
PMERR_NOT_IN_DRAW_MODE					-1	5
PMERR_NOT_IN_ELEMENT					-1	5
PMERR_NOT_IN_IMAGE					-1	5
PMERR_NOT_IN_PATH					-1	5
PMERR_NOT_IN_RETAIN_MODE				-1	5
PMERR_NOT_IN_SEG					-1	5
PMERR_NO_BITMAP_SELECTED				-1	5
PMERR_NO_CURRENT_ELEMENT				-1	5
PMERR_NO_CURRENT_SEG					-1	5
PMERR_NO_METAFILE_RECORD_HANDLE 			-1	5
PMERR_ORDER_TOO_BIG					-1	5
PMERR_OTHER_SET_ID_REFS 				-1	5
PMERR_OVERRAN_SEG					-1	5
PMERR_OWN_SET_ID_REFS					-1	5
PMERR_PATH_INCOMPLETE					-1	5
PMERR_PATH_LIMIT_EXCEEDED				-1	5
PMERR_PATH_UNKNOWN					-1	5
PMERR_PEL_IS_CLIPPED					-1	5
PMERR_PEL_NOT_AVAILABLE 				-1	5
PMERR_PRIMITIVE_STACK_EMPTY				-1	5
PMERR_PROLOG_ERROR					-1	5
PMERR_PROLOG_SEG_ATTR_NOT_SET				-1	5
PMERR_PS_BUSY						-1	5
PMERR_PS_IS_ASSOCIATED					-1	5
PMERR_RAM_JNL_FILE_TOO_SMALL				-1	5
PMERR_REALIZE_NOT_SUPPORTED				-1	5
PMERR_REGION_IS_CLIP_REGION				-1	5
PMERR_RESOURCE_DEPLETION				-1	5
PMERR_RESOURCE_DEPLETION				-1	5
PMERR_SEG_AND_REFSEG_ARE_SAME				-1	5
PMERR_SEG_CALL_RECURSIVE				-1	5
PMERR_SEG_CALL_STACK_EMPTY				-1	5
PMERR_SEG_CALL_STACK_FULL				-1	5
PMERR_SEG_IS_CURRENT					-1	5
PMERR_SEG_NOT_CHAINED					-1	5
PMERR_SEG_NOT_FOUND					-1	5
PMERR_SEG_STORE_LIMIT_EXCEEDED				-1	5
PMERR_SETID_IN_USE					-1	5
PMERR_SETID_NOT_FOUND					-1	5
PMERR_STARTDOC_NOT_ISSUED				-1	5
PMERR_STOP_DRAW_OCCURRED				-1	5
PMERR_TOO_MANY_METAFILES_IN_USE 			-1	5
PMERR_TRUNCATED_ORDER					-1	5
PMERR_UNCHAINED_SEG_ZERO_INV				-1	5
PMERR_UNSUPPORTED_ATTR					-1	5
PMERR_UNSUPPORTED_ATTR_VALUE				-1	5
PMERR_ENDDOC_NOT_ISSUED 				-1	5
PMERR_PS_NOT_ASSOCIATED 				-1	5
PMERR_INV_FLOOD_FILL_OPTIONS				-1	5
PMERR_INV_FACENAME					-1	5
PMERR_PALETTE_SELECTED					-1	5
PMERR_NO_PALETTE_SELECTED				-1	5
PMERR_INV_HPAL						-1	5
PMERR_PALETTE_BUSY					-1	5
PMERR_START_POINT_CLIPPED				-1	5
PMERR_NO_FILL						-1	5
PMERR_INV_FACENAMEDESC					-1	5
PMERR_INV_BITMAP_DATA					-1	5
PMERR_INV_CHAR_ALIGN_ATTR				-1	5
PMERR_INV_HFONT 					-1	5
PMERR_HFONT_IS_SELECTED 				-1	5
PMERR_DRVR_NOT_SUPPORTED				-1	5
INCL_SPLERRORS_INCL					-1	5
PMERR_SPL_DRIVER_ERROR					-1	5
PMERR_SPL_DEVICE_ERROR					-1	5
PMERR_SPL_DEVICE_NOT_INSTALLED				-1	5
PMERR_SPL_QUEUE_ERROR					-1	5
PMERR_SPL_INV_HSPL					-1	5
PMERR_SPL_NO_DISK_SPACE 				-1	5
PMERR_SPL_NO_MEMORY					-1	5
PMERR_SPL_PRINT_ABORT					-1	5
PMERR_SPL_SPOOLER_NOT_INSTALLED 			-1	5
PMERR_SPL_INV_FORMS_CODE				-1	5
PMERR_SPL_INV_PRIORITY					-1	5
PMERR_SPL_NO_FREE_JOB_ID				-1	5
PMERR_SPL_NO_DATA					-1	5
PMERR_SPL_INV_TOKEN					-1	5
PMERR_SPL_INV_DATATYPE					-1	5
PMERR_SPL_PROCESSOR_ERROR				-1	5
PMERR_SPL_INV_JOB_ID					-1	5
PMERR_SPL_JOB_NOT_PRINTING				-1	5
PMERR_SPL_JOB_PRINTING					-1	5
PMERR_SPL_QUEUE_ALREADY_EXISTS				-1	5
PMERR_SPL_INV_QUEUE_NAME				-1	5
PMERR_SPL_QUEUE_NOT_EMPTY				-1	5
PMERR_SPL_DEVICE_ALREADY_EXISTS 			-1	5
PMERR_SPL_DEVICE_LIMIT_REACHED				-1	5
PMERR_SPL_STATUS_STRING_TRUNC				-1	5
PMERR_SPL_INV_LENGTH_OR_COUNT				-1	5
PMERR_SPL_FILE_NOT_FOUND				-1	5
PMERR_SPL_CANNOT_OPEN_FILE				-1	5
PMERR_SPL_DRIVER_NOT_INSTALLED				-1	5
PMERR_SPL_INV_PROCESSOR_DATTYPE 			-1	5
PMERR_SPL_INV_DRIVER_DATATYPE				-1	5
PMERR_SPL_PROCESSOR_NOT_INST				-1	5
PMERR_SPL_NO_SUCH_LOG_ADDRESS				-1	5
PMERR_SPL_PRINTER_NOT_FOUND				-1	5
PMERR_SPL_DD_NOT_FOUND					-1	5
PMERR_SPL_QUEUE_NOT_FOUND				-1	5
PMERR_SPL_MANY_QUEUES_ASSOC				-1	5
PMERR_SPL_NO_QUEUES_ASSOCIATED				-1	5
PMERR_SPL_INI_FILE_ERROR				-1	5
PMERR_SPL_NO_DEFAULT_QUEUE				-1	5
PMERR_SPL_NO_CURRENT_FORMS_CODE 			-1	5
PMERR_SPL_NOT_AUTHORISED				-1	5
PMERR_SPL_TEMP_NETWORK_ERROR				-1	5
PMERR_SPL_HARD_NETWORK_ERROR				-1	5
PMERR_DEL_NOT_ALLOWED					-1	5
PMERR_CANNOT_DEL_QP_REF 				-1	5
PMERR_CANNOT_DEL_QNAME_REF				-1	5
PMERR_CANNOT_DEL_PRINTER_DD_REF 			-1	5
PMERR_CANNOT_DEL_PRN_NAME_REF				-1	5
PMERR_CANNOT_DEL_PRN_ADDR_REF				-1	5
PMERR_SPOOLER_QP_NOT_DEFINED				-1	5
PMERR_PRN_NAME_NOT_DEFINED				-1	5
PMERR_PRN_ADDR_NOT_DEFINED				-1	5
PMERR_PRINTER_DD_NOT_DEFINED				-1	5
PMERR_PRINTER_QUEUE_NOT_DEFINED 			-1	5
PMERR_PRN_ADDR_IN_USE					-1	5
PMERR_SPL_TOO_MANY_OPEN_FILES				-1	5
PMERR_SPL_CP_NOT_REQD					-1	5
PMERR_UNABLE_TO_CLOSE_DEVICE				-1	5
PMERR_SPL_ERROR_1					-1	5
PMERR_SPL_ERROR_2					-1	5
PMERR_SPL_ERROR_3					-1	5
PMERR_SPL_ERROR_4					-1	5
PMERR_SPL_ERROR_5					-1	5
PMERR_SPL_ERROR_6					-1	5
PMERR_SPL_ERROR_7					-1	5
PMERR_SPL_ERROR_8					-1	5
PMERR_SPL_ERROR_9					-1	5
PMERR_SPL_ERROR_10					-1	5
PMERR_SPL_ERROR_11					-1	5
PMERR_SPL_ERROR_12					-1	5
PMERR_SPL_ERROR_13					-1	5
PMERR_SPL_ERROR_14					-1	5
PMERR_SPL_ERROR_15					-1	5
PMERR_SPL_ERROR_16					-1	5
PMERR_SPL_ERROR_17					-1	5
PMERR_SPL_ERROR_18					-1	5
PMERR_SPL_ERROR_19					-1	5
PMERR_SPL_ERROR_20					-1	5
PMERR_SPL_ERROR_21					-1	5
PMERR_SPL_ERROR_22					-1	5
PMERR_SPL_ERROR_23					-1	5
PMERR_SPL_ERROR_24					-1	5
PMERR_SPL_ERROR_25					-1	5
PMERR_SPL_ERROR_26					-1	5
PMERR_SPL_ERROR_27					-1	5
PMERR_SPL_ERROR_28					-1	5
PMERR_SPL_ERROR_29					-1	5
PMERR_SPL_ERROR_30					-1	5
PMERR_SPL_ERROR_31					-1	5
PMERR_SPL_ERROR_32					-1	5
PMERR_SPL_ERROR_33					-1	5
PMERR_SPL_ERROR_34					-1	5
PMERR_SPL_ERROR_35					-1	5
PMERR_SPL_ERROR_36					-1	5
PMERR_SPL_ERROR_37					-1	5
PMERR_SPL_ERROR_38					-1	5
PMERR_SPL_ERROR_39					-1	5
PMERR_SPL_ERROR_40					-1	5
PMERR_SPLMSGBOX_INFO_CAPTION				-1	5
PMERR_SPLMSGBOX_WARNING_CAPTION 			-1	5
PMERR_SPLMSGBOX_ERROR_CAPTION				-1	5
PMERR_SPLMSGBOX_SEVERE_CAPTION				-1	5
PMERR_SPLMSGBOX_JOB_DETAILS				-1	5
PMERR_SPLMSGBOX_ERROR_ACTION				-1	5
PMERR_SPLMSGBOX_SEVERE_ACTION				-1	5
PMERR_SPLMSGBOX_BIT_0_TEXT				-1	5
PMERR_SPLMSGBOX_BIT_1_TEXT				-1	5
PMERR_SPLMSGBOX_BIT_2_TEXT				-1	5
PMERR_SPLMSGBOX_BIT_3_TEXT				-1	5
PMERR_SPLMSGBOX_BIT_4_TEXT				-1	5
PMERR_SPLMSGBOX_BIT_5_TEXT				-1	5
PMERR_SPLMSGBOX_BIT_15_TEXT				-1	5
PMERR_SPL_NOPATHBUFFER					-1	5
PMERR_SPL_ALREADY_INITIALISED				-1	5
PMERR_SPL_ERROR 					-1	5
NERR_BASE						-1	5
NERR_NetNotStarted					-1	5
NERR_RedirectedPath					-1	5
NERR_BufTooSmall					-1	5
NERR_InvalidAPI 					-1	5
NERR_QNotFound						-1	5
NERR_JobNotFound					-1	5
NERR_DestNotFound					-1	5
NERR_DestExists 					-1	5
NERR_QExists						-1	5
NERR_QNoRoom						-1	5
NERR_JobNoRoom						-1	5
NERR_DestNoRoom 					-1	5
NERR_DestIdle						-1	5
NERR_DestInvalidOp					-1	5
NERR_SpoolerNotLoaded					-1	5
NERR_DestInvalidState					-1	5
NERR_JobInvalidState					-1	5
NERR_SpoolNoMemory					-1	5
NERR_DriverNotFound					-1	5
NERR_DataTypeInvalid					-1	5
NERR_ProcNotFound					-1	5
NERR_BadDev						-1	5
NERR_CommDevInUse					-1	5
NERR_InvalidComputer					-1	5
NERR_OpenFiles						-1	5
NERR_LocalDrive 					-1	5
INCL_PICERRORS_INCL					-1	5
PMERR_INV_TYPE						-1	5
PMERR_INV_CONV						-1	5
PMERR_INV_SEGLEN					-1	5
PMERR_DUP_SEGNAME					-1	5
PMERR_INV_XFORM 					-1	5
PMERR_INV_VIEWLIM					-1	5
PMERR_INV_3DCOORD					-1	5
PMERR_SMB_OVFLOW					-1	5
PMERR_SEG_OVFLOW					-1	5
PMERR_PIC_DUP_FILENAME					-1	5
PMFONT_INCLUDED 					-1	5
FONTDEFFONT1						-1	5
FONTDEFFONT2						-1	5
FONTDEFFONT3						-1	5
FONTDEFCHAR1						-1	5
FONTDEFCHAR2						-1	5
FONTDEFCHAR3						-1	5
SPACE_UNDEF						-1	5
FONT_SIGNATURE						-1	5
FONT_METRICS						-1	5
FONT_DEFINITION 					-1	5
FONT_KERNPAIRS						-1	5
FONT_ADDITIONALMETRICS					-1	5
FONT_ENDRECORD						-1	5
QUERY_PUBLIC_FONTS					-1	5
QUERY_PRIVATE_FONTS					-1	5
CDEF_GENERIC						-1	5
CDEF_BOLD						-1	5
CDEF_ITALIC						-1	5
CDEF_UNDERSCORE 					-1	5
CDEF_STRIKEOUT						-1	5
CDEF_OUTLINE						-1	5
GPI_INCLUDED						-1	5
INCL_GPIBITMAPS 					-1	5
INCL_GPICONTROL 					-1	5
INCL_GPICORRELATION					-1	5
INCL_GPIDEFAULTS					-1	5
INCL_GPILCIDS						-1	5
INCL_GPILOGCOLORTABLE					-1	5
INCL_GPIMETAFILES					-1	5
INCL_GPIPATHS						-1	5
INCL_GPIPOLYGON 					-1	5
INCL_GPIPRIMITIVES					-1	5
INCL_GPIREGIONS 					-1	5
INCL_GPISEGEDITING					-1	5
INCL_GPISEGMENTS					-1	5
INCL_GPITRANSFORMS					-1	5
INCL_GPIERRORS						-1	5
INCL_GPIBITMAPS 					-1	5
INCL_GPIERRORS						-1	5
INCL_GPILCIDS						-1	5
INCL_GPILOGCOLORTABLE					-1	5
INCL_GPIPATHS						-1	5
INCL_GPIPOLYGON 					-1	5
INCL_GPIPRIMITIVES					-1	5
INCL_GPIREGIONS 					-1	5
INCL_GPITRANSFORMS					-1	5
INCL_GPIBITMAPS 					-1	5
INCL_GPICONTROL 					-1	5
INCL_GPICORRELATION					-1	5
INCL_GPIERRORS						-1	5
INCL_GPILCIDS						-1	5
INCL_GPILOGCOLORTABLE					-1	5
INCL_GPIMETAFILES					-1	5
INCL_GPIPATHS						-1	5
INCL_GPIPOLYGON 					-1	5
INCL_GPIPRIMITIVES					-1	5
INCL_GPIREGIONS 					-1	5
INCL_GPISEGEDITING					-1	5
INCL_GPISEGMENTS					-1	5
INCL_GPITRANSFORMS					-1	5
GPI_ERROR						-1	5
GPI_OK							-1	5
GPI_ALTERROR						-1	5
MAKEFIXED						-1	5
FIXEDFRAC						-1	5
FIXEDINT						-1	5
CLR_NOINDEX						-1	5
PU_ARBITRARY						-1	5
PU_PELS 						-1	5
PU_LOMETRIC						-1	5
PU_HIMETRIC						-1	5
PU_LOENGLISH						-1	5
PU_HIENGLISH						-1	5
PU_TWIPS						-1	5
GPIF_DEFAULT						-1	5
GPIF_SHORT						-1	5
GPIF_LONG						-1	5
GPIT_NORMAL						-1	5
GPIT_MICRO						-1	5
GPIA_NOASSOC						-1	5
GPIA_ASSOC						-1	5
GPIM_AREAEXCL						-1	5
HDC_ERROR						-1	5
GRES_ATTRS						-1	5
GRES_SEGMENTS						-1	5
GRES_ALL						-1	5
PS_UNITS						-1	5
PS_FORMAT						-1	5
PS_TYPE 						-1	5
PS_MODE 						-1	5
PS_ASSOCIATE						-1	5
PS_NORESET						-1	5
GPIE_SEGMENT						-1	5
GPIE_ELEMENT						-1	5
GPIE_DATA						-1	5
DCTL_ERASE						-1	5
DCTL_DISPLAY						-1	5
DCTL_BOUNDARY						-1	5
DCTL_DYNAMIC						-1	5
DCTL_CORRELATE						-1	5
DCTL_ERROR						-1	5
DCTL_OFF						-1	5
DCTL_ON 						-1	5
SDW_ERROR						-1	5
SDW_OFF 						-1	5
SDW_ON							-1	5
DM_ERROR						-1	5
DM_DRAW 						-1	5
DM_RETAIN						-1	5
DM_DRAWANDRETAIN					-1	5
PICKAP_DEFAULT						-1	5
PICKAP_REC						-1	5
PICKSEL_VISIBLE 					-1	5
PICKSEL_ALL						-1	5
GPI_HITS						-1	5
DFORM_NOCONV						-1	5
DFORM_S370SHORT 					-1	5
DFORM_PCSHORT						-1	5
DFORM_PCLONG						-1	5
ATTR_ERROR						-1	5
ATTR_DETECTABLE 					-1	5
ATTR_VISIBLE						-1	5
ATTR_CHAINED						-1	5
ATTR_DYNAMIC						-1	5
ATTR_FASTCHAIN						-1	5
ATTR_PROP_DETECTABLE					-1	5
ATTR_PROP_VISIBLE					-1	5
ATTR_OFF						-1	5
ATTR_ON 						-1	5
LOWER_PRI						-1	5
HIGHER_PRI						-1	5
SEGEM_ERROR						-1	5
SEGEM_INSERT						-1	5
SEGEM_REPLACE						-1	5
CVTC_WORLD						-1	5
CVTC_MODEL						-1	5
CVTC_DEFAULTPAGE					-1	5
CVTC_PAGE						-1	5
CVTC_DEVICE						-1	5
TRANSFORM_REPLACE					-1	5
TRANSFORM_ADD						-1	5
TRANSFORM_PREEMPT					-1	5
MPATH_STROKE						-1	5
FPATH_ALTERNATE 					-1	5
FPATH_WINDING						-1	5
FPATH_INCL						-1	5
FPATH_EXCL						-1	5
SCP_ALTERNATE						-1	5
SCP_WINDING						-1	5
SCP_AND 						-1	5
SCP_RESET						-1	5
SCP_INCL						-1	5
SCP_EXCL						-1	5
INCL_GPIBITMAPS 					-1	5
LCOL_RESET						-1	5
LCOL_REALIZABLE 					-1	5
LCOL_PURECOLOR						-1	5
LCOL_OVERRIDE_DEFAULT_COLORS				-1	5
LCOL_REALIZED						-1	5
LCOLF_DEFAULT						-1	5
LCOLF_INDRGB						-1	5
LCOLF_CONSECRGB 					-1	5
LCOLF_RGB						-1	5
LCOLF_PALETTE						-1	5
LCOLOPT_REALIZED					-1	5
LCOLOPT_INDEX						-1	5
QLCT_ERROR						-1	5
QLCT_RGB						-1	5
QLCT_NOTLOADED						-1	5
QCD_LCT_FORMAT						-1	5
QCD_LCT_LOINDEX 					-1	5
QCD_LCT_HIINDEX 					-1	5
QCD_LCT_OPTIONS 					-1	5
PAL_ERROR						-1	5
PC_RESERVED						-1	5
PC_EXPLICIT						-1	5
PC_NOCOLLAPSE						-1	5
CLR_FALSE						-1	5
CLR_TRUE						-1	5
CLR_ERROR						-1	5
CLR_DEFAULT						-1	5
CLR_WHITE						-1	5
CLR_BLACK						-1	5
CLR_BACKGROUND						-1	5
CLR_BLUE						-1	5
CLR_RED 						-1	5
CLR_PINK						-1	5
CLR_GREEN						-1	5
CLR_CYAN						-1	5
CLR_YELLOW						-1	5
CLR_NEUTRAL						-1	5
CLR_DARKGRAY						-1	5
CLR_DARKBLUE						-1	5
CLR_DARKRED						-1	5
CLR_DARKPINK						-1	5
CLR_DARKGREEN						-1	5
CLR_DARKCYAN						-1	5
CLR_BROWN						-1	5
CLR_PALEGRAY						-1	5
RGB_ERROR						-1	5
RGB_BLACK						-1	5
RGB_BLUE						-1	5
RGB_GREEN						-1	5
RGB_CYAN						-1	5
RGB_RED 						-1	5
RGB_PINK						-1	5
RGB_YELLOW						-1	5
RGB_WHITE						-1	5
BA_NOBOUNDARY						-1	5
BA_BOUNDARY						-1	5
BA_ALTERNATE						-1	5
BA_WINDING						-1	5
BA_INCL 						-1	5
BA_EXCL 						-1	5
DRO_FILL						-1	5
DRO_OUTLINE						-1	5
DRO_OUTLINEFILL 					-1	5
PATSYM_ERROR						-1	5
PATSYM_DEFAULT						-1	5
PATSYM_DENSE1						-1	5
PATSYM_DENSE2						-1	5
PATSYM_DENSE3						-1	5
PATSYM_DENSE4						-1	5
PATSYM_DENSE5						-1	5
PATSYM_DENSE6						-1	5
PATSYM_DENSE7						-1	5
PATSYM_DENSE8						-1	5
PATSYM_VERT						-1	5
PATSYM_HORIZ						-1	5
PATSYM_DIAG1						-1	5
PATSYM_DIAG2						-1	5
PATSYM_DIAG3						-1	5
PATSYM_DIAG4						-1	5
PATSYM_NOSHADE						-1	5
PATSYM_SOLID						-1	5
PATSYM_HALFTONE 					-1	5
PATSYM_HATCH						-1	5
PATSYM_DIAGHATCH					-1	5
PATSYM_BLANK						-1	5
LCID_ERROR						-1	5
LCID_DEFAULT						-1	5
AM_ERROR						-1	5
AM_PRESERVE						-1	5
AM_NOPRESERVE						-1	5
FM_ERROR						-1	5
FM_DEFAULT						-1	5
FM_OR							-1	5
FM_OVERPAINT						-1	5
FM_LEAVEALONE						-1	5
FM_XOR							-1	5
FM_AND							-1	5
FM_SUBTRACT						-1	5
FM_MASKSRCNOT						-1	5
FM_ZERO 						-1	5
FM_NOTMERGESRC						-1	5
FM_NOTXORSRC						-1	5
FM_INVERT						-1	5
FM_MERGESRCNOT						-1	5
FM_NOTCOPYSRC						-1	5
FM_MERGENOTSRC						-1	5
FM_NOTMASKSRC						-1	5
FM_ONE							-1	5
BM_ERROR						-1	5
BM_DEFAULT						-1	5
BM_OR							-1	5
BM_OVERPAINT						-1	5
BM_LEAVEALONE						-1	5
BM_XOR							-1	5
BM_AND							-1	5
BM_SUBTRACT						-1	5
BM_MASKSRCNOT						-1	5
BM_ZERO 						-1	5
BM_NOTMERGESRC						-1	5
BM_NOTXORSRC						-1	5
BM_INVERT						-1	5
BM_MERGESRCNOT						-1	5
BM_NOTCOPYSRC						-1	5
BM_MERGENOTSRC						-1	5
BM_NOTMASKSRC						-1	5
BM_ONE							-1	5
BM_SRCTRANSPARENT					-1	5
BM_DESTTRANSPARENT					-1	5
LINETYPE_ERROR						-1	5
LINETYPE_DEFAULT					-1	5
LINETYPE_DOT						-1	5
LINETYPE_SHORTDASH					-1	5
LINETYPE_DASHDOT					-1	5
LINETYPE_DOUBLEDOT					-1	5
LINETYPE_LONGDASH					-1	5
LINETYPE_DASHDOUBLEDOT					-1	5
LINETYPE_SOLID						-1	5
LINETYPE_INVISIBLE					-1	5
LINETYPE_ALTERNATE					-1	5
LINEWIDTH_ERROR 					-1	5
LINEWIDTH_DEFAULT					-1	5
LINEWIDTH_NORMAL					-1	5
LINEWIDTH_THICK 					-1	5
LINEWIDTHGEOM_ERROR					-1	5
LINEEND_ERROR						-1	5
LINEEND_DEFAULT 					-1	5
LINEEND_FLAT						-1	5
LINEEND_SQUARE						-1	5
LINEEND_ROUND						-1	5
LINEJOIN_ERROR						-1	5
LINEJOIN_DEFAULT					-1	5
LINEJOIN_BEVEL						-1	5
LINEJOIN_ROUND						-1	5
LINEJOIN_MITRE						-1	5
CHDIRN_ERROR						-1	5
CHDIRN_DEFAULT						-1	5
CHDIRN_LEFTRIGHT					-1	5
CHDIRN_TOPBOTTOM					-1	5
CHDIRN_RIGHTLEFT					-1	5
CHDIRN_BOTTOMTOP					-1	5
TA_NORMAL_HORIZ 					-1	5
TA_LEFT 						-1	5
TA_CENTER						-1	5
TA_RIGHT						-1	5
TA_STANDARD_HORIZ					-1	5
TA_NORMAL_VERT						-1	5
TA_TOP							-1	5
TA_HALF 						-1	5
TA_BASE 						-1	5
TA_BOTTOM						-1	5
TA_STANDARD_VERT					-1	5
CM_ERROR						-1	5
CM_DEFAULT						-1	5
CM_MODE1						-1	5
CM_MODE2						-1	5
CM_MODE3						-1	5
MARKSYM_ERROR						-1	5
MARKSYM_DEFAULT 					-1	5
MARKSYM_CROSS						-1	5
MARKSYM_PLUS						-1	5
MARKSYM_DIAMOND 					-1	5
MARKSYM_SQUARE						-1	5
MARKSYM_SIXPOINTSTAR					-1	5
MARKSYM_EIGHTPOINTSTAR					-1	5
MARKSYM_SOLIDDIAMOND					-1	5
MARKSYM_SOLIDSQUARE					-1	5
MARKSYM_DOT						-1	5
MARKSYM_SMALLCIRCLE					-1	5
MARKSYM_BLANK						-1	5
CHS_OPAQUE						-1	5
CHS_VECTOR						-1	5
CHS_LEAVEPOS						-1	5
CHS_CLIP						-1	5
CHS_UNDERSCORE						-1	5
CHS_STRIKEOUT						-1	5
PRIM_LINE						-1	5
PRIM_CHAR						-1	5
PRIM_MARKER						-1	5
PRIM_AREA						-1	5
PRIM_IMAGE						-1	5
LBB_COLOR						-1	5
LBB_BACK_COLOR						-1	5
LBB_MIX_MODE						-1	5
LBB_BACK_MIX_MODE					-1	5
LBB_WIDTH						-1	5
LBB_GEOM_WIDTH						-1	5
LBB_TYPE						-1	5
LBB_END 						-1	5
LBB_JOIN						-1	5
CBB_COLOR						-1	5
CBB_BACK_COLOR						-1	5
CBB_MIX_MODE						-1	5
CBB_BACK_MIX_MODE					-1	5
CBB_SET 						-1	5
CBB_MODE						-1	5
CBB_BOX 						-1	5
CBB_ANGLE						-1	5
CBB_SHEAR						-1	5
CBB_DIRECTION						-1	5
CBB_TEXT_ALIGN						-1	5
CBB_EXTRA						-1	5
CBB_BREAK_EXTRA 					-1	5
MBB_COLOR						-1	5
MBB_BACK_COLOR						-1	5
MBB_MIX_MODE						-1	5
MBB_BACK_MIX_MODE					-1	5
MBB_SET 						-1	5
MBB_SYMBOL						-1	5
MBB_BOX 						-1	5
ABB_COLOR						-1	5
ABB_BACK_COLOR						-1	5
ABB_MIX_MODE						-1	5
ABB_BACK_MIX_MODE					-1	5
ABB_SET 						-1	5
ABB_SYMBOL						-1	5
ABB_REF_POINT						-1	5
IBB_COLOR						-1	5
IBB_BACK_COLOR						-1	5
IBB_MIX_MODE						-1	5
IBB_BACK_MIX_MODE					-1	5
TXTBOX_TOPLEFT						-1	5
TXTBOX_BOTTOMLEFT					-1	5
TXTBOX_TOPRIGHT 					-1	5
TXTBOX_BOTTOMRIGHT					-1	5
TXTBOX_CONCAT						-1	5
TXTBOX_COUNT						-1	5
PVIS_ERROR						-1	5
PVIS_INVISIBLE						-1	5
PVIS_VISIBLE						-1	5
RVIS_ERROR						-1	5
RVIS_INVISIBLE						-1	5
RVIS_PARTIAL						-1	5
RVIS_VISIBLE						-1	5
FONT_DEFAULT						-1	5
FONT_MATCH						-1	5
LCIDT_FONT						-1	5
LCIDT_BITMAP						-1	5
LCID_ALL						-1	5
FWEIGHT_DONT_CARE					-1	5
FWEIGHT_ULTRA_LIGHT					-1	5
FWEIGHT_EXTRA_LIGHT					-1	5
FWEIGHT_LIGHT						-1	5
FWEIGHT_SEMI_LIGHT					-1	5
FWEIGHT_NORMAL						-1	5
FWEIGHT_SEMI_BOLD					-1	5
FWEIGHT_BOLD						-1	5
FWEIGHT_EXTRA_BOLD					-1	5
FWEIGHT_ULTRA_BOLD					-1	5
FWIDTH_DONT_CARE					-1	5
FWIDTH_ULTRA_CONDENSED					-1	5
FWIDTH_EXTRA_CONDENSED					-1	5
FWIDTH_CONDENSED					-1	5
FWIDTH_SEMI_CONDENSED					-1	5
FWIDTH_NORMAL						-1	5
FWIDTH_SEMI_EXPANDED					-1	5
FWIDTH_EXPANDED 					-1	5
FWIDTH_EXTRA_EXPANDED					-1	5
FWIDTH_ULTRA_EXPANDED					-1	5
FTYPE_ITALIC						-1	5
FTYPE_ITALIC_DONT_CARE					-1	5
FTYPE_OBLIQUE						-1	5
FTYPE_OBLIQUE_DONT_CARE 				-1	5
FTYPE_ROUNDED						-1	5
FTYPE_ROUNDED_DONT_CARE 				-1	5
QFA_PUBLIC						-1	5
QFA_PRIVATE						-1	5
QFA_ERROR						-1	5
QF_PUBLIC						-1	5
QF_PRIVATE						-1	5
QF_NO_GENERIC						-1	5
QF_NO_DEVICE						-1	5
ROP_SRCCOPY						-1	5
ROP_SRCPAINT						-1	5
ROP_SRCAND						-1	5
ROP_SRCINVERT						-1	5
ROP_SRCERASE						-1	5
ROP_NOTSRCCOPY						-1	5
ROP_NOTSRCERASE 					-1	5
ROP_MERGECOPY						-1	5
ROP_MERGEPAINT						-1	5
ROP_PATCOPY						-1	5
ROP_PATPAINT						-1	5
ROP_PATINVERT						-1	5
ROP_DSTINVERT						-1	5
ROP_ZERO						-1	5
ROP_ONE 						-1	5
BBO_OR							-1	5
BBO_AND 						-1	5
BBO_IGNORE						-1	5
BBO_PAL_COLORS						-1	5
BBO_NO_COLOR_INFO					-1	5
FF_BOUNDARY						-1	5
FF_SURFACE						-1	5
HBM_ERROR						-1	5
CBM_INIT						-1	5
BMB_ERROR						-1	5
CRGN_OR 						-1	5
CRGN_COPY						-1	5
CRGN_XOR						-1	5
CRGN_AND						-1	5
CRGN_DIFF						-1	5
RECTDIR_LFRT_TOPBOT					-1	5
RECTDIR_RTLF_TOPBOT					-1	5
RECTDIR_LFRT_BOTTOP					-1	5
RECTDIR_RTLF_BOTTOP					-1	5
RGN_ERROR						-1	5
RGN_NULL						-1	5
RGN_RECT						-1	5
RGN_COMPLEX						-1	5
PRGN_ERROR						-1	5
PRGN_OUTSIDE						-1	5
PRGN_INSIDE						-1	5
RRGN_ERROR						-1	5
RRGN_OUTSIDE						-1	5
RRGN_PARTIAL						-1	5
RRGN_INSIDE						-1	5
EQRGN_ERROR						-1	5
EQRGN_NOTEQUAL						-1	5
EQRGN_EQUAL						-1	5
HRGN_ERROR						-1	5
PMF_SEGBASE						-1	5
PMF_LOADTYPE						-1	5
PMF_RESOLVE						-1	5
PMF_LCIDS						-1	5
PMF_RESET						-1	5
PMF_SUPPRESS						-1	5
PMF_COLORTABLES 					-1	5
PMF_COLORREALIZABLE					-1	5
PMF_DEFAULTS						-1	5
PMF_DELETEOBJECTS					-1	5
RS_DEFAULT						-1	5
RS_NODISCARD						-1	5
LC_DEFAULT						-1	5
LC_NOLOAD						-1	5
LC_LOADDISC						-1	5
LT_DEFAULT						-1	5
LT_NOMODIFY						-1	5
LT_ORIGINALVIEW 					-1	5
RES_DEFAULT						-1	5
RES_NORESET						-1	5
RES_RESET						-1	5
SUP_DEFAULT						-1	5
SUP_NOSUPPRESS						-1	5
SUP_SUPPRESS						-1	5
CTAB_DEFAULT						-1	5
CTAB_NOMODIFY						-1	5
CTAB_REPLACE						-1	5
CTAB_REPLACEPALETTE					-1	5
CREA_DEFAULT						-1	5
CREA_REALIZE						-1	5
CREA_NOREALIZE						-1	5
CREA_DOREALIZE						-1	5
DDEF_DEFAULT						-1	5
DDEF_IGNORE						-1	5
DDEF_LOADDISC						-1	5
DOBJ_DEFAULT						-1	5
DOBJ_NODELETE						-1	5
DOBJ_DELETE						-1	5
RSP_DEFAULT						-1	5
RSP_NODISCARD						-1	5
POLYGON_NOBOUNDARY					-1	5
POLYGON_BOUNDARY					-1	5
POLYGON_ALTERNATE					-1	5
POLYGON_WINDING 					-1	5
POLYGON_INCL						-1	5
POLYGON_EXCL						-1	5
PMHELP_INCLUDED 					-1	5
HWND_PARENT						-1	5
HM_RESOURCEID						-1	5
HM_PANELNAME						-1	5
HMPANELTYPE_NUMBER					-1	5
HMPANELTYPE_NAME					-1	5
CMIC_HIDE_PANEL_ID					-1	5
CMIC_SHOW_PANEL_ID					-1	5
CMIC_TOGGLE_PANEL_ID					-1	5
HM_MSG_BASE						-1	5
HM_DISMISS_WINDOW					-1	5
HM_DISPLAY_HELP 					-1	5
HM_EXT_HELP						-1	5
HM_GENERAL_HELP 					-1	5
HM_SET_ACTIVE_WINDOW					-1	5
HM_LOAD_HELP_TABLE					-1	5
HM_CREATE_HELP_TABLE					-1	5
HM_SET_HELP_WINDOW_TITLE				-1	5
HM_SET_SHOW_PANEL_ID					-1	5
HM_REPLACE_HELP_FOR_HELP				-1	5
HM_REPLACE_USING_HELP					-1	5
HM_HELP_INDEX						-1	5
HM_HELP_CONTENTS					-1	5
HM_KEYS_HELP						-1	5
HM_SET_HELP_LIBRARY_NAME				-1	5
HM_SET_OBJCOM_WINDOW					-1	5
HM_UPDATE_OBJCOM_WINDOW_CHAIN				-1	5
HM_QUERY_DDF_DATA					-1	5
HM_INVALIDATE_DDF_DATA					-1	5
HM_QUERY						-1	5
HM_SET_COVERPAGE_SIZE					-1	5
HMQW_COVERPAGE						-1	5
HMQW_INDEX						-1	5
HMQW_TOC						-1	5
HMQW_SEARCH						-1	5
HMQW_VIEWPAGES						-1	5
HMQW_LIBRARY						-1	5
HMQW_VIEWPORT						-1	5
HMQW_OBJCOM_WINDOW					-1	5
HMQW_INSTANCE						-1	5
HMQW_ACTIVEVIEWPORT					-1	5
CONTROL_SELECTED					-1	5
HMQW_GROUP_VIEWPORT					-1	5
HMQW_RES_VIEWPORT					-1	5
USERDATA						-1	5
HMQVP_NUMBER						-1	5
HMQVP_NAME						-1	5
HMQVP_GROUP						-1	5
CTRL_PREVIOUS_ID					-1	5
CTRL_SEARCH_ID						-1	5
CTRL_PRINT_ID						-1	5
CTRL_INDEX_ID						-1	5
CTRL_CONTENTS_ID					-1	5
CTRL_BACK_ID						-1	5
CTRL_FORWARD_ID 					-1	5
CTRL_TUTORIAL_ID					-1	5
CTRL_USER_ID_BASE					-1	5
HM_ERROR						-1	5
HM_HELPSUBITEM_NOT_FOUND				-1	5
HM_QUERY_KEYS_HELP					-1	5
HM_TUTORIAL						-1	5
HM_EXT_HELP_UNDEFINED					-1	5
HM_GENERAL_HELP_UNDEFINED				-1	5
HM_ACTIONBAR_COMMAND					-1	5
HM_INFORM						-1	5
HM_NOTIFY						-1	5
HM_SET_USERDATA 					-1	5
HM_CONTROL						-1	5
OPEN_COVERPAGE						-1	5
OPEN_PAGE						-1	5
SWAP_PAGE						-1	5
OPEN_TOC						-1	5
OPEN_INDEX						-1	5
OPEN_HISTORY						-1	5
OPEN_SEARCH_HIT_LIST					-1	5
OPEN_LIBRARY						-1	5
HELP_REQUESTED						-1	5
HMERR_NO_FRAME_WND_IN_CHAIN				-1	5
HMERR_INVALID_ASSOC_APP_WND				-1	5
HMERR_INVALID_ASSOC_HELP_INST				-1	5
HMERR_INVALID_DESTROY_HELP_INST 			-1	5
HMERR_NO_HELP_INST_IN_CHAIN				-1	5
HMERR_INVALID_HELP_INSTANCE_HDL 			-1	5
HMERR_INVALID_QUERY_APP_WND				-1	5
HMERR_HELP_INST_CALLED_INVALID				-1	5
HMERR_HELPTABLE_UNDEFINE				-1	5
HMERR_HELP_INSTANCE_UNDEFINE				-1	5
HMERR_HELPITEM_NOT_FOUND				-1	5
HMERR_INVALID_HELPSUBITEM_SIZE				-1	5
HMERR_HELPSUBITEM_NOT_FOUND				-1	5
HMERR_INDEX_NOT_FOUND					-1	5
HMERR_CONTENT_NOT_FOUND 				-1	5
HMERR_OPEN_LIB_FILE					-1	5
HMERR_READ_LIB_FILE					-1	5
HMERR_CLOSE_LIB_FILE					-1	5
HMERR_INVALID_LIB_FILE					-1	5
HMERR_NO_MEMORY 					-1	5
HMERR_ALLOCATE_SEGMENT					-1	5
HMERR_FREE_MEMORY					-1	5
HMERR_PANEL_NOT_FOUND					-1	5
HMERR_DATABASE_NOT_OPEN 				-1	5
HMERR_LOAD_DLL						-1	5
PMDDF_H 						-1	5
REFERENCE_BY_ID 					-1	5
REFERENCE_BY_RES					-1	5
HMBT_NONE						-1	5
HMBT_ALL						-1	5
HMBT_FIT						-1	5
HMLS_SINGLELINE 					-1	5
HMLS_DOUBLELINE 					-1	5
ART_RUNIN						-1	5
ART_LEFT						-1	5
ART_RIGHT						-1	5
ART_CENTER						-1	5
CLR_UNCHANGED						-1	5
HMERR_DDF_MEMORY					-1	5
HMERR_DDF_ALIGN_TYPE					-1	5
HMERR_DDF_BACKCOLOR					-1	5
HMERR_DDF_FORECOLOR					-1	5
HMERR_DDF_FONTSTYLE					-1	5
HMERR_DDF_REFTYPE					-1	5
HMERR_DDF_LIST_UNCLOSED 				-1	5
HMERR_DDF_LIST_UNINITIALIZED				-1	5
HMERR_DDF_LIST_BREAKTYPE				-1	5
HMERR_DDF_LIST_SPACING					-1	5
HMERR_DDF_HINSTANCE					-1	5
HMERR_DDF_EXCEED_MAX_LENGTH				-1	5
HMERR_DDF_EXCEED_MAX_INC				-1	5
HMERR_DDF_INVALID_DDF					-1	5
HMERR_DDF_FORMAT_TYPE					-1	5
HMERR_DDF_INVALID_PARM					-1	5
HMERR_DDF_INVALID_FONT					-1	5
HMERR_DDF_SEVERE					-1	5
MLE_INCLUDED						-1	5
MLS_WORDWRAP						-1	5
MLS_BORDER						-1	5
MLS_VSCROLL						-1	5
MLS_HSCROLL						-1	5
MLS_READONLY						-1	5
MLS_IGNORETAB						-1	5
MLS_DISABLEUNDO 					-1	5
MLFFMTRECT_LIMITHORZ					-1	5
MLFFMTRECT_LIMITVERT					-1	5
MLFFMTRECT_MATCHWINDOW					-1	5
MLFFMTRECT_FORMATRECT					-1	5
MLFIE_CFTEXT						-1	5
MLFIE_NOTRANS						-1	5
MLFIE_WINFMT						-1	5
MLFIE_RTF						-1	5
MLFEFR_RESIZE						-1	5
MLFEFR_TABSTOP						-1	5
MLFEFR_FONT						-1	5
MLFEFR_TEXT						-1	5
MLFEFR_WORDWRAP 					-1	5
MLFETL_TEXTBYTES					-1	5
MLFMARGIN_LEFT						-1	5
MLFMARGIN_BOTTOM					-1	5
MLFMARGIN_RIGHT 					-1	5
MLFMARGIN_TOP						-1	5
MLFQS_MINMAXSEL 					-1	5
MLFQS_MINSEL						-1	5
MLFQS_MAXSEL						-1	5
MLFQS_ANCHORSEL 					-1	5
MLFQS_CURSORSEL 					-1	5
MLFCLPBD_TOOMUCHTEXT					-1	5
MLFCLPBD_ERROR						-1	5
MLFSEARCH_CASESENSITIVE 				-1	5
MLFSEARCH_SELECTMATCH					-1	5
MLFSEARCH_CHANGEALL					-1	5
MLM_SETTEXTLIMIT					-1	5
MLM_QUERYTEXTLIMIT					-1	5
MLM_SETFORMATRECT					-1	5
MLM_QUERYFORMATRECT					-1	5
MLM_SETWRAP						-1	5
MLM_QUERYWRAP						-1	5
MLM_SETTABSTOP						-1	5
MLM_QUERYTABSTOP					-1	5
MLM_SETREADONLY 					-1	5
MLM_QUERYREADONLY					-1	5
MLM_QUERYCHANGED					-1	5
MLM_SETCHANGED						-1	5
MLM_QUERYLINECOUNT					-1	5
MLM_CHARFROMLINE					-1	5
MLM_LINEFROMCHAR					-1	5
MLM_QUERYLINELENGTH					-1	5
MLM_QUERYTEXTLENGTH					-1	5
MLM_FORMAT						-1	5
MLM_SETIMPORTEXPORT					-1	5
MLM_IMPORT						-1	5
MLM_EXPORT						-1	5
MLM_DELETE						-1	5
MLM_QUERYFORMATLINELENGTH				-1	5
MLM_QUERYFORMATTEXTLENGTH				-1	5
MLM_INSERT						-1	5
MLM_SETSEL						-1	5
MLM_QUERYSEL						-1	5
MLM_QUERYSELTEXT					-1	5
MLM_QUERYUNDO						-1	5
MLM_UNDO						-1	5
MLM_RESETUNDO						-1	5
MLM_QUERYFONT						-1	5
MLM_SETFONT						-1	5
MLM_SETTEXTCOLOR					-1	5
MLM_QUERYTEXTCOLOR					-1	5
MLM_SETBACKCOLOR					-1	5
MLM_QUERYBACKCOLOR					-1	5
MLM_QUERYFIRSTCHAR					-1	5
MLM_SETFIRSTCHAR					-1	5
MLM_CUT 						-1	5
MLM_COPY						-1	5
MLM_PASTE						-1	5
MLM_CLEAR						-1	5
MLM_ENABLEREFRESH					-1	5
MLM_DISABLEREFRESH					-1	5
MLM_SEARCH						-1	5
MLM_QUERYIMPORTEXPORT					-1	5
MLN_OVERFLOW						-1	5
MLN_PIXHORZOVERFLOW					-1	5
MLN_PIXVERTOVERFLOW					-1	5
MLN_TEXTOVERFLOW					-1	5
MLN_VSCROLL						-1	5
MLN_HSCROLL						-1	5
MLN_CHANGE						-1	5
MLN_SETFOCUS						-1	5
MLN_KILLFOCUS						-1	5
MLN_MARGIN						-1	5
MLN_SEARCHPAUSE 					-1	5
MLN_MEMERROR						-1	5
MLN_UNDOOVERFLOW					-1	5
MLN_CLPBDFAIL						-1	5
ORD_INCLUDED						-1	5
BYTE_ORDER						-1	5
OCODE_GNOP1						-1	5
OCODE_GESD						-1	5
OCODE2_1						-1	5
OCODE2_2						-1	5
SHORT_ORDER						-1	5
OCODE_GBAR						-1	5
OCODE_GCFIG						-1	5
OCODE_GEEL						-1	5
OCODE_GEPTH						-1	5
OCODE_GEPROL						-1	5
OCODE_GPOP						-1	5
OCODE_GSBMX						-1	5
OCODE_GPSBMX						-1	5
OCODE_GSCD						-1	5
OCODE_GPSCD						-1	5
OCODE_GSCR						-1	5
OCODE_GPSCR						-1	5
OCODE_GSCS						-1	5
OCODE_GPSCS						-1	5
OCODE_GSCOL						-1	5
OCODE_GPSCOL						-1	5
OCODE_GSLE						-1	5
OCODE_GPSLE						-1	5
OCODE_GSLJ						-1	5
OCODE_GPSLJ						-1	5
OCODE_GSLT						-1	5
OCODE_GPSLT						-1	5
OCODE_GSLW						-1	5
OCODE_GPSLW						-1	5
OCODE_GSMP						-1	5
OCODE_GPSMP						-1	5
OCODE_GSMS						-1	5
OCODE_GPSMS						-1	5
OCODE_GSMT						-1	5
OCODE_GPSMT						-1	5
OCODE_GSMX						-1	5
OCODE_GPSMX						-1	5
OCODE_GSPS						-1	5
OCODE_GPSPS						-1	5
OCODE_GSPT						-1	5
OCODE_GPSPT						-1	5
GBAR_RESERVED						-1	5
GBAR_BOUNDARY						-1	5
GBAR_NOBOUNDARY 					-1	5
GBAR_WINDING						-1	5
GBAR_ALTERNATE						-1	5
GSCR_PRECISION						-1	5
OCODE_VLONG						-1	5
LONG_ORDER						-1	5
LORDER_ML						-1	5
OCODE_GEAR						-1	5
OCODE_GEIMG						-1	5
OCODE_GCCHST						-1	5
GCCHST_MC						-1	5
OCODE_GCHST						-1	5
GCHST_SMC						-1	5
GCHST_LMC						-1	5
OCODE_GCCHSTM						-1	5
GCCHSTM_MC						-1	5
OCODE_GCHSTM						-1	5
GCHSTM_SMC						-1	5
GCHSTM_LMC						-1	5
OCODE_GCOMT						-1	5
GCOMT_ML						-1	5
OCODE_GIMD						-1	5
GIMD_ML 						-1	5
OCODE_GCFARC						-1	5
OCODE_GFARC						-1	5
OCODE_GLABL						-1	5
OCODE_GSCP						-1	5
OCODE_GPSCP						-1	5
OCODE_GCBEZ						-1	5
GCBEZ_SMB						-1	5
GCBEZ_LMB						-1	5
OCODE_GBEZ						-1	5
GBEZ_SMB						-1	5
GBEZ_LMB						-1	5
OCODE_GCFLT						-1	5
GCFLT_SMP						-1	5
GCFLT_LMP						-1	5
OCODE_GFLT						-1	5
GFLT_SMP						-1	5
GFLT_LMP						-1	5
OCODE_GCLINE						-1	5
GCLINE_SMP						-1	5
GCLINE_LMP						-1	5
OCODE_GLINE						-1	5
GLINE_SMP						-1	5
GLINE_LMP						-1	5
OCODE_GCMRK						-1	5
GCMRK_SMP						-1	5
GCMRK_LMP						-1	5
OCODE_GMRK						-1	5
GMRK_SMP						-1	5
GMRK_LMP						-1	5
OCODE_GCRLINE						-1	5
GCRLINE_MP						-1	5
OCODE_GRLINE						-1	5
GRLINE_SMP						-1	5
GRLINE_LMP						-1	5
OCODE_GSBCOL						-1	5
OCODE_GPSBCOL						-1	5
OCODE_GSECOL						-1	5
OCODE_GPSECOL						-1	5
SECOL_DEFAULT0						-1	5
SECOL_DEFAULT1						-1	5
SECOL_NEUTRAL						-1	5
SECOL_RESET						-1	5
OCODE_GSCA						-1	5
OCODE_GPSCA						-1	5
OCODE_GSCH						-1	5
OCODE_GPSCH						-1	5
OCODE_GSFLW						-1	5
OCODE_GPSFLW						-1	5
OCODE_GSPIK						-1	5
OCODE_GPSPIK						-1	5
OCODE_GCARC						-1	5
OCODE_GARC						-1	5
OCODE_GBEL						-1	5
GBEL_DL 						-1	5
OCODE_GCBIMG						-1	5
OCODE_GBIMG						-1	5
OCODE_GBPTH						-1	5
OCODE_GCBOX						-1	5
OCODE_GBOX						-1	5
GCBOX_FILL						-1	5
GCBOX_BOUNDARY						-1	5
OCODE_GCALLS						-1	5
OCODE_GFPTH						-1	5
GFPTH_ALTERNATE 					-1	5
GFPTH_WINDING						-1	5
GFPTH_MODIFY						-1	5
OCODE_GOPTH						-1	5
OCODE_GMPTH						-1	5
GMPTH_STROKE						-1	5
OCODE_GCPARC						-1	5
OCODE_GPARC						-1	5
OCODE_GSCPTH						-1	5
GSCPTH_ALTERNATE					-1	5
GSCPTH_WINDING						-1	5
GSCPTH_RESET						-1	5
GSCPTH_INTERSECT					-1	5
OCODE_GSAP						-1	5
OCODE_GPSAP						-1	5
OCODE_GSBICOL						-1	5
OCODE_GSBICOL						-1	5
OCODE_GPSBICOL						-1	5
OCODE_GSICOL						-1	5
OCODE_GPSICOL						-1	5
SICOL_SPECIFY						-1	5
SICOL_SPECIAL						-1	5
SICOL_DEFAULT						-1	5
SICOL_BLACK						-1	5
SICOL_WHITE						-1	5
SICOL_ONES						-1	5
SICOL_ZEROES						-1	5
OCODE_GSCC						-1	5
OCODE_GPSCC						-1	5
GSCC_ZERODEF						-1	5
GSCC_ZEROZERO						-1	5
OCODE_GSMC						-1	5
OCODE_GPSMC						-1	5
GSMC_ZERODEF						-1	5
GSMC_ZEROZERO						-1	5
OCODE_GSPRP						-1	5
OCODE_GPSPRP						-1	5
GSPRP_DEFAULT						-1	5
GSPRP_SPECIFY						-1	5
OCODE_GSIA						-1	5
OCODE_GPSIA						-1	5
GSIA_VL 						-1	5
GSIA_COLOR						-1	5
GSIA_BCOLOR						-1	5
GSIA_MIX						-1	5
GSIA_BMIX						-1	5
GSIA_LINE						-1	5
GSIA_CHAR						-1	5
GSIA_MARKER						-1	5
GSIA_PATTERN						-1	5
GSIA_IMAGE						-1	5
GSIA_SPECIFY						-1	5
GSIA_SPECIAL						-1	5
GSIA_DEFAULT						-1	5
GSIA_BLACK						-1	5
GSIA_WHITE						-1	5
GSIA_ONES						-1	5
GSIA_ZEROES						-1	5
OCODE_GSTM						-1	5
OCODE_GPSTM						-1	5
OCODE_GSTV						-1	5
GSTM_ML 						-1	5
GSTM_M11						-1	5
GSTM_M12						-1	5
GSTM_M13						-1	5
GSTM_M14						-1	5
GSTM_M21						-1	5
GSTM_M22						-1	5
GSTM_M23						-1	5
GSTM_M24						-1	5
GSTM_M31						-1	5
GSTM_M32						-1	5
GSTM_M33						-1	5
GSTM_M34						-1	5
GSTM_M41						-1	5
GSTM_M42						-1	5
GSTM_M43						-1	5
GSTM_M44						-1	5
GSTM_UNITY						-1	5
GSTM_AFTER						-1	5
GSTM_BEFORE						-1	5
GSTM_OVERWRITE						-1	5
GSTV_OVERWRITE						-1	5
GSTV_AFTER						-1	5
OCODE_GSSB						-1	5
OCODE_GSVW						-1	5
OCODE_GPSVW						-1	5
GSSB_ML 						-1	5
GSSB_XLEFT						-1	5
GSSB_XRIGHT						-1	5
GSSB_YBOTTOM						-1	5
GSSB_YTOP						-1	5
GSVW_INTERSECT						-1	5
GSVW_REPLACE						-1	5
OCODE_GSGCH						-1	5
GSGCH_ML						-1	5
OCODE_GSSLW						-1	5
OCODE_GPSSLW						-1	5
GSSLW_DEFAULT						-1	5
GSSLW_SPECIFY						-1	5
OCODE_GCSFLT						-1	5
OCODE_GSFLT						-1	5
GCSFLT_SMF						-1	5
GSFLT_SMF						-1	5
GCSFLT_LMF						-1	5
GSFLT_LMF						-1	5
OCODE_GBBLT						-1	5
OCODE_GSCE						-1	5
OCODE_GPSCE						-1	5
OCODE_GSCBE						-1	5
OCODE_GPSCBE						-1	5
OCODE_GESCP						-1	5
GESCP_ML						-1	5
GESCP_REG						-1	5
GEBB_REGID						-1	5
ETYPE_GEBB						-1	5
GEBB_LMP						-1	5
GEPEL_REGID						-1	5
ETYPE_GEPEL						-1	5
GEDB_REGID						-1	5
ETYPE_GEDB						-1	5
GEFF_REGID						-1	5
ETYPE_GEFF						-1	5
ETYPE_LINEBUNDLE					-1	5
ETYPE_CHARBUNDLE					-1	5
ETYPE_MARKERBUNDLE					-1	5
ETYPE_AREABUNDLE					-1	5
ETYPE_IMAGEBUNDLE					-1	5
VLONG_ORDER						-1	5
VORDER_ML						-1	5
OCODEQ_GCCHSTE						-1	5
OCODEQ_GCHSTE						-1	5
ETYPE_GCCHSTE						-1	5
ETYPE_GCHSTE						-1	5
GCCHSTE_DRAWRECT					-1	5
GCCHSTE_NORECT						-1	5
GCCHSTE_CLIP						-1	5
GCCHSTE_NOCLIP						-1	5
GCCHSTE_DEEMPHASIZE					-1	5
GCCHSTE_NODEEMPHASIZE					-1	5
GCCHSTE_LEAVEPOS					-1	5
GCCHSTE_MOVEPOS 					-1	5
GCCHSTE_UNDERSCORE					-1	5
GCCHSTE_NOUNDERSCORE					-1	5
GCCHSTE_STRIKEOUT					-1	5
GCCHSTE_NOSTRIKEOUT					-1	5
OCODEQ_GEESCP						-1	5
GEESCP_ML						-1	5
PIC_INCLUDED						-1	5
PIP_MF							-1	5
PIP_PIF 						-1	5
PIC_PIFTOMET						-1	5
PIC_SSTOFONT						-1	5
SEI_INCLUDED						-1	5
SEI_BREAKPOINT						-1	5
SEI_NOBEEP						-1	5
SEI_NOPROMPT						-1	5
SEI_DBGRSRVD						-1	5
SEI_DEBUGONLY						-1	5
SEI_STACKTRACE						-1	5
SEI_REGISTERS						-1	5
SEI_ARGCOUNT						-1	5
SEI_DOSERROR						-1	5
SEI_RESERVED						-1	5
SHL_INCLUDED						-1	5
INCL_SHLERRORS						-1	5
MAXNAMEL						-1	5
HINI_PROFILE						-1	5
HINI_USERPROFILE					-1	5
HINI_SYSTEMPROFILE					-1	5
HINI_USER						-1	5
HINI_SYSTEM						-1	5
MAXPATHL						-1	5
SGH_ROOT						-1	5
PROG_DEFAULT						-1	5
PROG_FULLSCREEN 					-1	5
PROG_WINDOWABLEVIO					-1	5
PROG_PM 						-1	5
PROG_GROUP						-1	5
PROG_REAL						-1	5
PROG_VDM						-1	5
PROG_WINDOWEDVDM					-1	5
PROG_DLL						-1	5
PROG_PDD						-1	5
PROG_VDD						-1	5
PROG_WINDOW_REAL					-1	5
PROG_WINDOW_PROT					-1	5
PROG_30_STD						-1	5
PROG_WINDOW_AUTO					-1	5
PROG_SEAMLESSVDM					-1	5
PROG_30_STDSEAMLESSVDM					-1	5
PROG_SEAMLESSCOMMON					-1	5
PROG_30_STDSEAMLESSCOMMON				-1	5
PROG_31_STDSEAMLESSVDM					-1	5
PROG_31_STDSEAMLESSCOMMON				-1	5
PROG_31_ENHSEAMLESSVDM					-1	5
PROG_31_ENHSEAMLESSCOMMON				-1	5
PROG_31_ENH						-1	5
PROG_31_STD						-1	5
PROG_RESERVED						-1	5
SHE_VISIBLE						-1	5
SHE_INVISIBLE						-1	5
SHE_RESERVED						-1	5
SHE_UNPROTECTED 					-1	5
SHE_PROTECTED						-1	5
SAF_VALIDFLAGS						-1	5
SAF_INSTALLEDCMDLINE					-1	5
SAF_STARTCHILDAPP					-1	5
SAF_MAXIMIZED						-1	5
SAF_MINIMIZED						-1	5
SAF_BACKGROUND						-1	5
SWL_VISIBLE						-1	5
SWL_INVISIBLE						-1	5
SWL_GRAYED						-1	5
SWL_JUMPABLE						-1	5
SWL_NOTJUMPABLE 					-1	5
PL_ALTERED						-1	5
PMSPL_INCLUDED						-1	5
DosPrintDestControl					-1	5
DosPrintDestGetInfo					-1	5
DosPrintDestEnum					-1	5
DosPrintJobContinue					-1	5
DosPrintJobPause					-1	5
DosPrintJobDel						-1	5
DosPrintJobGetInfo					-1	5
DosPrintJobSetInfo					-1	5
DosPrintJobEnum 					-1	5
DosPrintQAdd						-1	5
DosPrintQPause						-1	5
DosPrintQContinue					-1	5
DosPrintQDel						-1	5
DosPrintQGetInfo					-1	5
DosPrintQSetInfo					-1	5
DosPrintQEnum						-1	5
DosPrintDestAdd 					-1	5
DosPrintDestSetInfo					-1	5
DosPrintDestDel 					-1	5
DosPrintQPurge						-1	5
DosPrintDriverEnum					-1	5
DosPrintQProcessorEnum					-1	5
DosPrintPortEnum					-1	5
INCL_SPLERRORS						-1	5
SPL_INI_SPOOLER 					-1	5
SPL_INI_QUEUE						-1	5
SPL_INI_PRINTER 					-1	5
SPL_INI_PRINTERDESCR					-1	5
SPL_INI_QUEUEDESCR					-1	5
SPL_INI_QUEUEDD 					-1	5
SPL_INI_QUEUEDDDATA					-1	5
SPL_ERROR						-1	5
SPL_OK							-1	5
SPLC_ABORT						-1	5
SPLC_PAUSE						-1	5
SPLC_CONTINUE						-1	5
QP_RAWDATA_BYPASS					-1	5
QPDAT_ADDRESS						-1	5
QPDAT_DRIVER_NAME					-1	5
QPDAT_DRIVER_DATA					-1	5
QPDAT_DATA_TYPE 					-1	5
QPDAT_COMMENT						-1	5
QPDAT_PROC_PARAMS					-1	5
QPDAT_SPL_PARAMS					-1	5
QPDAT_NET_PARAMS					-1	5
QPDAT_DOC_NAME						-1	5
QPDAT_QUEUE_NAME					-1	5
QPDAT_TOKEN						-1	5
QPDAT_JOBID						-1	5
SPLINFO_QPERROR 					-1	5
SPLINFO_DDERROR 					-1	5
SPLINFO_SPLERROR					-1	5
SPLINFO_OTHERERROR					-1	5
SPLINFO_INFORMATION					-1	5
SPLINFO_WARNING 					-1	5
SPLINFO_ERROR						-1	5
SPLINFO_SEVERE						-1	5
SPLINFO_USERINTREQD					-1	5
SPLDATA_PRINTERJAM					-1	5
SPLDATA_FORMCHGREQD					-1	5
SPLDATA_CARTCHGREQD					-1	5
SPLDATA_PENCHGREQD					-1	5
SPLDATA_DATAERROR					-1	5
SPLDATA_UNEXPECTERROR					-1	5
SPLDATA_OTHER						-1	5
SSQL_ERROR						-1	5
CNLEN							-1	5
UNLEN							-1	5
QNLEN							-1	5
PDLEN							-1	5
DTLEN							-1	5
QP_DATATYPE_SIZE					-1	5
DRIV_DEVICENAME_SIZE					-1	5
DRIV_NAME_SIZE						-1	5
PRINTERNAME_SIZE					-1	5
FORMNAME_SIZE						-1	5
MAXCOMMENTSZ						-1	5
PRQ_PRIORITY_PARMNUM					-1	5
PRQ_STARTTIME_PARMNUM					-1	5
PRQ_UNTILTIME_PARMNUM					-1	5
PRQ_SEPARATOR_PARMNUM					-1	5
PRQ_PROCESSOR_PARMNUM					-1	5
PRQ_DESTINATIONS_PARMNUM				-1	5
PRQ_PARMS_PARMNUM					-1	5
PRQ_COMMENT_PARMNUM					-1	5
PRQ_TYPE_PARMNUM					-1	5
PRQ_PRINTERS_PARMNUM					-1	5
PRQ_DRIVERNAME_PARMNUM					-1	5
PRQ_DRIVERDATA_PARMNUM					-1	5
PRQ_REMOTE_COMPUTER_PARMNUM				-1	5
PRQ_REMOTE_QUEUE_PARMNUM				-1	5
PRQ_MAXPARMNUM						-1	5
PRQ_MAX_PRIORITY					-1	5
PRQ_DEF_PRIORITY					-1	5
PRQ_MIN_PRIORITY					-1	5
PRQ_NO_PRIORITY 					-1	5
PRQ_STATUS_MASK 					-1	5
PRQ_ACTIVE						-1	5
PRQ_PAUSED						-1	5
PRQ_ERROR						-1	5
PRQ_PENDING						-1	5
PRQ3_PAUSED						-1	5
PRQ3_PENDING						-1	5
PRQ3_TYPE_RAW						-1	5
PRQ3_TYPE_BYPASS					-1	5
PRQ3_TYPE_APPDEFAULT					-1	5
PRJ_NOTIFYNAME_PARMNUM					-1	5
PRJ_DATATYPE_PARMNUM					-1	5
PRJ_PARMS_PARMNUM					-1	5
PRJ_POSITION_PARMNUM					-1	5
PRJ_JOBFILEINUSE_PARMNUM				-1	5
PRJ_COMMENT_PARMNUM					-1	5
PRJ_DOCUMENT_PARMNUM					-1	5
PRJ_STATUSCOMMENT_PARMNUM				-1	5
PRJ_PRIORITY_PARMNUM					-1	5
PRJ_PROCPARMS_PARMNUM					-1	5
PRJ_DRIVERDATA_PARMNUM					-1	5
PRJ_MAXPARMNUM						-1	5
PRJ_QSTATUS						-1	5
PRJ_DEVSTATUS						-1	5
PRJ_COMPLETE						-1	5
PRJ_INTERV						-1	5
PRJ_ERROR						-1	5
PRJ_DESTOFFLINE 					-1	5
PRJ_DESTPAUSED						-1	5
PRJ_NOTIFY						-1	5
PRJ_DESTNOPAPER 					-1	5
PRJ_DESTFORMCHG 					-1	5
PRJ_DESTCRTCHG						-1	5
PRJ_DESTPENCHG						-1	5
PRJ_JOBFILEINUSE					-1	5
PRJ_DELETED						-1	5
PRJ_QS_QUEUED						-1	5
PRJ_QS_PAUSED						-1	5
PRJ_QS_SPOOLING 					-1	5
PRJ_QS_PRINTING 					-1	5
PRJ_MAX_PRIORITY					-1	5
PRJ_MIN_PRIORITY					-1	5
PRJ_NO_PRIORITY 					-1	5
PRD_STATUS_MASK 					-1	5
PRD_DEVSTATUS						-1	5
PRD_ACTIVE						-1	5
PRD_PAUSED						-1	5
PRD_DELETE						-1	5
PRD_PAUSE						-1	5
PRD_CONT						-1	5
PRD_RESTART						-1	5
PRD_LOGADDR_PARMNUM					-1	5
PRD_COMMENT_PARMNUM					-1	5
PRD_DRIVERS_PARMNUM					-1	5
PRD_TIMEOUT_PARMNUM					-1	5
SPL_PR_QUEUE						-1	5
SPL_PR_DIRECT_DEVICE					-1	5
SPL_PR_QUEUED_DEVICE					-1	5
SPL_PR_LOCAL_ONLY					-1	5
STDDLG_INCLUDED 					-1	5
INCL_WINSTDFILE 					-1	5
INCL_WINSTDFONT 					-1	5
INCL_WINSTDSPIN 					-1	5
INCL_WINSTDDRAG 					-1	5
INCL_WINSTDCNR						-1	5
INCL_WINSTDSLIDER					-1	5
INCL_WINSTDVALSET					-1	5
INCL_WINSTDBOOK 					-1	5
INCL_WINSTDDRAG 					-1	5
INCL_WINSTDFILE_INCLUDED				-1	5
FDS_CENTER						-1	5
FDS_CUSTOM						-1	5
FDS_FILTERUNION 					-1	5
FDS_HELPBUTTON						-1	5
FDS_APPLYBUTTON 					-1	5
FDS_PRELOAD_VOLINFO					-1	5
FDS_MODELESS						-1	5
FDS_INCLUDE_EAS 					-1	5
FDS_OPEN_DIALOG 					-1	5
FDS_SAVEAS_DIALOG					-1	5
FDS_MULTIPLESEL 					-1	5
FDS_ENABLEFILELB					-1	5
FDS_EFSELECTION 					-1	5
FDS_LBSELECTION 					-1	5
FDS_SUCCESSFUL						-1	5
FDS_ERR_DEALLOCATE_MEMORY				-1	5
FDS_ERR_FILTER_TRUNC					-1	5
FDS_ERR_INVALID_DIALOG					-1	5
FDS_ERR_INVALID_DRIVE					-1	5
FDS_ERR_INVALID_FILTER					-1	5
FDS_ERR_INVALID_PATHFILE				-1	5
FDS_ERR_OUT_OF_MEMORY					-1	5
FDS_ERR_PATH_TOO_LONG					-1	5
FDS_ERR_TOO_MANY_FILE_TYPES				-1	5
FDS_ERR_INVALID_VERSION 				-1	5
FDS_ERR_INVALID_CUSTOM_HANDLE				-1	5
FDS_ERR_DIALOG_LOAD_ERROR				-1	5
FDS_ERR_DRIVE_ERROR					-1	5
FDM_FILTER						-1	5
FDM_VALIDATE						-1	5
FDM_ERROR						-1	5
DID_FILE_DIALOG 					-1	5
DID_FILENAME_TXT					-1	5
DID_FILENAME_ED 					-1	5
DID_DRIVE_TXT						-1	5
DID_DRIVE_CB						-1	5
DID_FILTER_TXT						-1	5
DID_FILTER_CB						-1	5
DID_DIRECTORY_TXT					-1	5
DID_DIRECTORY_LB					-1	5
DID_FILES_TXT						-1	5
DID_FILES_LB						-1	5
DID_HELP_PB						-1	5
DID_APPLY_PB						-1	5
DID_OK_PB						-1	5
DID_CANCEL_PB						-1	5
IDS_FILE_ALL_FILES_SELECTOR				-1	5
IDS_FILE_BACK_CUR_PATH					-1	5
IDS_FILE_BACK_PREV_PATH 				-1	5
IDS_FILE_BACK_SLASH					-1	5
IDS_FILE_BASE_FILTER					-1	5
IDS_FILE_BLANK						-1	5
IDS_FILE_COLON						-1	5
IDS_FILE_DOT						-1	5
IDS_FILE_DRIVE_LETTERS					-1	5
IDS_FILE_FWD_CUR_PATH					-1	5
IDS_FILE_FWD_PREV_PATH					-1	5
IDS_FILE_FORWARD_SLASH					-1	5
IDS_FILE_PARENT_DIR					-1	5
IDS_FILE_Q_MARK 					-1	5
IDS_FILE_SPLAT						-1	5
IDS_FILE_SPLAT_DOT					-1	5
IDS_FILE_SAVEAS_TITLE					-1	5
IDS_FILE_SAVEAS_FILTER_TXT				-1	5
IDS_FILE_SAVEAS_FILENM_TXT				-1	5
IDS_FILE_DUMMY_FILE_NAME				-1	5
IDS_FILE_DUMMY_FILE_EXT 				-1	5
IDS_FILE_DUMMY_DRIVE					-1	5
IDS_FILE_DUMMY_ROOT_DIR 				-1	5
IDS_FILE_PATH_PTR					-1	5
IDS_FILE_VOLUME_PREFIX					-1	5
IDS_FILE_VOLUME_SUFFIX					-1	5
IDS_FILE_PATH_PTR2					-1	5
IDS_FILE_INVALID_CHARS					-1	5
IDS_FILE_BAD_DRIVE_NAME 				-1	5
IDS_FILE_BAD_DRIVE_OR_PATH_NAME 			-1	5
IDS_FILE_BAD_FILE_NAME					-1	5
IDS_FILE_BAD_FQF					-1	5
IDS_FILE_BAD_NETWORK_NAME				-1	5
IDS_FILE_BAD_SUB_DIR_NAME				-1	5
IDS_FILE_DRIVE_NOT_AVAILABLE				-1	5
IDS_FILE_FQFNAME_TOO_LONG				-1	5
IDS_FILE_OPEN_DIALOG_NOTE				-1	5
IDS_FILE_PATH_TOO_LONG					-1	5
IDS_FILE_SAVEAS_DIALOG_NOTE				-1	5
IDS_FILE_DRIVE_DISK_CHANGE				-1	5
IDS_FILE_DRIVE_NOT_READY				-1	5
IDS_FILE_DRIVE_LOCKED					-1	5
IDS_FILE_DRIVE_NO_SECTOR				-1	5
IDS_FILE_DRIVE_SOME_ERROR				-1	5
IDS_FILE_DRIVE_INVALID					-1	5
IDS_FILE_INSERT_DISK_NOTE				-1	5
IDS_FILE_OK_WHEN_READY					-1	5
INCL_WINSTDFONT_INCLUDED				-1	5
FNTS_CENTER						-1	5
FNTS_CUSTOM						-1	5
FNTS_OWNERDRAWPREVIEW					-1	5
FNTS_HELPBUTTON 					-1	5
FNTS_APPLYBUTTON					-1	5
FNTS_RESETBUTTON					-1	5
FNTS_MODELESS						-1	5
FNTS_INITFROMFATTRS					-1	5
FNTS_BITMAPONLY 					-1	5
FNTS_VECTORONLY 					-1	5
FNTS_FIXEDWIDTHONLY					-1	5
FNTS_PROPORTIONALONLY					-1	5
FNTS_NOSYNTHESIZEDFONTS 				-1	5
FNTF_NOVIEWSCREENFONTS					-1	5
FNTF_NOVIEWPRINTERFONTS 				-1	5
FNTF_SCREENFONTSELECTED 				-1	5
FNTF_PRINTERFONTSELECTED				-1	5
CLRC_FOREGROUND 					-1	5
CLRC_BACKGROUND 					-1	5
FNTI_BITMAPFONT 					-1	5
FNTI_VECTORFONT 					-1	5
FNTI_FIXEDWIDTHFONT					-1	5
FNTI_PROPORTIONALFONT					-1	5
FNTI_SYNTHESIZED					-1	5
FNTI_DEFAULTLIST					-1	5
FNTI_FAMILYNAME 					-1	5
FNTI_STYLENAME						-1	5
FNTI_POINTSIZE						-1	5
FNTS_SUCCESSFUL 					-1	5
FNTS_ERR_INVALID_DIALOG 				-1	5
FNTS_ERR_ALLOC_SHARED_MEM				-1	5
FNTS_ERR_INVALID_PARM					-1	5
FNTS_ERR_OUT_OF_MEMORY					-1	5
FNTS_ERR_INVALID_VERSION				-1	5
FNTS_ERR_DIALOG_LOAD_ERROR				-1	5
FNTM_FACENAMECHANGED					-1	5
FNTM_POINTSIZECHANGED					-1	5
FNTM_STYLECHANGED					-1	5
FNTM_COLORCHANGED					-1	5
FNTM_UPDATEPREVIEW					-1	5
FNTM_FILTERLIST 					-1	5
DID_FONT_DIALOG 					-1	5
DID_NAME						-1	5
DID_STYLE						-1	5
DID_DISPLAY_FILTER					-1	5
DID_PRINTER_FILTER					-1	5
DID_SIZE						-1	5
DID_SAMPLE						-1	5
DID_OUTLINE						-1	5
DID_UNDERSCORE						-1	5
DID_STRIKEOUT						-1	5
DID_HELP_BUTTON 					-1	5
DID_APPLY_BUTTON					-1	5
DID_RESET_BUTTON					-1	5
DID_OK_BUTTON						-1	5
DID_CANCEL_BUTTON					-1	5
DID_NAME_PREFIX 					-1	5
DID_STYLE_PREFIX					-1	5
DID_SIZE_PREFIX 					-1	5
DID_SAMPLE_GROUPBOX					-1	5
DID_EMPHASIS_GROUPBOX					-1	5
DID_FONT_ISO_SUPPORT					-1	5
DID_FONT_ISO_UNTESTED					-1	5
IDS_FONT_SAMPLE 					-1	5
IDS_FONT_BLANK						-1	5
IDS_FONT_KEY_0						-1	5
IDS_FONT_KEY_9						-1	5
IDS_FONT_KEY_SEP					-1	5
IDS_FONT_DISP_ONLY					-1	5
IDS_FONT_PRINTER_ONLY					-1	5
IDS_FONT_COMBINED					-1	5
IDS_FONT_WEIGHT1					-1	5
IDS_FONT_WEIGHT2					-1	5
IDS_FONT_WEIGHT3					-1	5
IDS_FONT_WEIGHT4					-1	5
IDS_FONT_WEIGHT5					-1	5
IDS_FONT_WEIGHT6					-1	5
IDS_FONT_WEIGHT7					-1	5
IDS_FONT_WEIGHT8					-1	5
IDS_FONT_WEIGHT9					-1	5
IDS_FONT_WIDTH1 					-1	5
IDS_FONT_WIDTH2 					-1	5
IDS_FONT_WIDTH3 					-1	5
IDS_FONT_WIDTH4 					-1	5
IDS_FONT_WIDTH5 					-1	5
IDS_FONT_WIDTH6 					-1	5
IDS_FONT_WIDTH7 					-1	5
IDS_FONT_WIDTH8 					-1	5
IDS_FONT_WIDTH9 					-1	5
IDS_FONT_OPTION0					-1	5
IDS_FONT_OPTION1					-1	5
IDS_FONT_OPTION2					-1	5
IDS_FONT_OPTION3					-1	5
IDS_FONT_POINT_SIZE_LIST				-1	5
INCL_WINSTDSPIN_INCLUDED				-1	5
SPBS_ALLCHARACTERS					-1	5
SPBS_NUMERICONLY					-1	5
SPBS_READONLY						-1	5
SPBS_MASTER						-1	5
SPBS_SERVANT						-1	5
SPBS_JUSTDEFAULT					-1	5
SPBS_JUSTLEFT						-1	5
SPBS_JUSTRIGHT						-1	5
SPBS_JUSTCENTER 					-1	5
SPBS_NOBORDER						-1	5
SPBS_FASTSPIN						-1	5
SPBS_PADWITHZEROS					-1	5
SPBN_UPARROW						-1	5
SPBN_DOWNARROW						-1	5
SPBN_ENDSPIN						-1	5
SPBN_CHANGE						-1	5
SPBN_SETFOCUS						-1	5
SPBN_KILLFOCUS						-1	5
SPBM_OVERRIDESETLIMITS					-1	5
SPBM_QUERYLIMITS					-1	5
SPBM_SETTEXTLIMIT					-1	5
SPBM_SPINUP						-1	5
SPBM_SPINDOWN						-1	5
SPBM_QUERYVALUE 					-1	5
SPBQ_UPDATEIFVALID					-1	5
SPBQ_ALWAYSUPDATE					-1	5
SPBQ_DONOTUPDATE					-1	5
SPBM_SETARRAY						-1	5
SPBM_SETLIMITS						-1	5
SPBM_SETCURRENTVALUE					-1	5
SPBM_SETMASTER						-1	5
INCL_WINSTDDRAG_INCLUDED				-1	5
PMERR_NOT_DRAGGING					-1	5
PMERR_ALREADY_DRAGGING					-1	5
MSGF_DRAG						-1	5
WM_DRAGFIRST						-1	5
WM_DRAGLAST						-1	5
DM_DROP 						-1	5
DM_DRAGOVER						-1	5
DM_DRAGLEAVE						-1	5
DM_DROPHELP						-1	5
DM_ENDCONVERSATION					-1	5
DM_PRINT						-1	5
DM_RENDER						-1	5
DM_RENDERCOMPLETE					-1	5
DM_RENDERPREPARE					-1	5
DM_DRAGFILECOMPLETE					-1	5
DM_EMPHASIZETARGET					-1	5
DM_DRAGERROR						-1	5
DM_FILERENDERED 					-1	5
DM_RENDERFILE						-1	5
DM_DRAGOVERNOTIFY					-1	5
DM_PRINTOBJECT						-1	5
DM_DISCARDOBJECT					-1	5
DRT_ASM 						-1	5
DRT_BASIC						-1	5
DRT_BINDATA						-1	5
DRT_BITMAP						-1	5
DRT_C							-1	5
DRT_COBOL						-1	5
DRT_DLL 						-1	5
DRT_DOSCMD						-1	5
DRT_EXE 						-1	5
DRT_FORTRAN						-1	5
DRT_ICON						-1	5
DRT_LIB 						-1	5
DRT_METAFILE						-1	5
DRT_OS2CMD						-1	5
DRT_PASCAL						-1	5
DRT_RESOURCE						-1	5
DRT_TEXT						-1	5
DRT_UNKNOWN						-1	5
DOR_NODROP						-1	5
DOR_DROP						-1	5
DOR_NODROPOP						-1	5
DOR_NEVERDROP						-1	5
DO_COPYABLE						-1	5
DO_MOVEABLE						-1	5
DO_LINKABLE						-1	5
DC_OPEN 						-1	5
DC_REF							-1	5
DC_GROUP						-1	5
DC_CONTAINER						-1	5
DC_PREPARE						-1	5
DC_REMOVEABLEMEDIA					-1	5
DO_DEFAULT						-1	5
DO_UNKNOWN						-1	5
DO_COPY 						-1	5
DO_MOVE 						-1	5
DO_LINK 						-1	5
DO_CREATE						-1	5
DMFL_TARGETSUCCESSFUL					-1	5
DMFL_TARGETFAIL 					-1	5
DMFL_NATIVERENDER					-1	5
DMFL_RENDERRETRY					-1	5
DMFL_RENDEROK						-1	5
DMFL_RENDERFAIL 					-1	5
DRG_ICON						-1	5
DRG_BITMAP						-1	5
DRG_POLYGON						-1	5
DRG_STRETCH						-1	5
DRG_TRANSPARENT 					-1	5
DRG_CLOSED						-1	5
DME_IGNOREABORT 					-1	5
DME_IGNORECONTINUE					-1	5
DME_REPLACE						-1	5
DME_RETRY						-1	5
DF_MOVE 						-1	5
DF_SOURCE						-1	5
DF_SUCCESSFUL						-1	5
DRR_SOURCE						-1	5
DRR_TARGET						-1	5
DRR_ABORT						-1	5
DFF_MOVE						-1	5
DFF_COPY						-1	5
DFF_DELETE						-1	5
INCL_WINSTDCNR_INCLUDED 				-1	5
PMERR_NOFILTERED_ITEMS					-1	5
PMERR_COMPARISON_FAILED 				-1	5
PMERR_RECORD_CURRENTLY_INSERTED 			-1	5
PMERR_FI_CURRENTLY_INSERTED				-1	5
CCS_EXTENDSEL						-1	5
CCS_MULTIPLESEL 					-1	5
CCS_SINGLESEL						-1	5
CCS_AUTOPOSITION					-1	5
CCS_VERIFYPOINTERS					-1	5
CCS_READONLY						-1	5
CCS_MINIRECORDCORE					-1	5
CV_TEXT 						-1	5
CV_NAME 						-1	5
CV_ICON 						-1	5
CV_DETAIL						-1	5
CV_FLOW 						-1	5
CV_MINI 						-1	5
CV_TREE 						-1	5
CA_CONTAINERTITLE					-1	5
CA_TITLESEPARATOR					-1	5
CA_TITLELEFT						-1	5
CA_TITLERIGHT						-1	5
CA_TITLECENTER						-1	5
CA_OWNERDRAW						-1	5
CA_DETAILSVIEWTITLES					-1	5
CA_ORDEREDTARGETEMPH					-1	5
CA_DRAWBITMAP						-1	5
CA_DRAWICON						-1	5
CA_TITLEREADONLY					-1	5
CA_OWNERPAINTBACKGROUND 				-1	5
CA_MIXEDTARGETEMPH					-1	5
CA_TREELINE						-1	5
CID_LEFTCOLTITLEWND					-1	5
CID_RIGHTCOLTITLEWND					-1	5
CID_BLANKBOX						-1	5
CID_HSCROLL						-1	5
CID_RIGHTHSCROLL					-1	5
CID_CNRTITLEWND 					-1	5
CID_LEFTDVWND						-1	5
CID_RIGHTDVWND						-1	5
CID_VSCROLL						-1	5
CID_MLE 						-1	5
CFA_LEFT						-1	5
CFA_RIGHT						-1	5
CFA_CENTER						-1	5
CFA_TOP 						-1	5
CFA_VCENTER						-1	5
CFA_BOTTOM						-1	5
CFA_INVISIBLE						-1	5
CFA_BITMAPORICON					-1	5
CFA_SEPARATOR						-1	5
CFA_HORZSEPARATOR					-1	5
CFA_STRING						-1	5
CFA_OWNER						-1	5
CFA_DATE						-1	5
CFA_TIME						-1	5
CFA_FIREADONLY						-1	5
CFA_FITITLEREADONLY					-1	5
CFA_ULONG						-1	5
CRA_SELECTED						-1	5
CRA_TARGET						-1	5
CRA_CURSORED						-1	5
CRA_INUSE						-1	5
CRA_FILTERED						-1	5
CRA_DROPONABLE						-1	5
CRA_RECORDREADONLY					-1	5
CRA_EXPANDED						-1	5
CRA_COLLAPSED						-1	5
CM_ALLOCDETAILFIELDINFO 				-1	5
CM_ALLOCRECORD						-1	5
CM_ARRANGE						-1	5
CM_ERASERECORD						-1	5
CM_FILTER						-1	5
CM_FREEDETAILFIELDINFO					-1	5
CM_FREERECORD						-1	5
CM_HORZSCROLLSPLITWINDOW				-1	5
CM_INSERTDETAILFIELDINFO				-1	5
CM_INSERTRECORD 					-1	5
CM_INVALIDATEDETAILFIELDINFO				-1	5
CM_INVALIDATERECORD					-1	5
CM_PAINTBACKGROUND					-1	5
CM_QUERYCNRINFO 					-1	5
CM_QUERYDETAILFIELDINFO 				-1	5
CM_QUERYDRAGIMAGE					-1	5
CM_QUERYRECORD						-1	5
CM_QUERYRECORDEMPHASIS					-1	5
CM_QUERYRECORDFROMRECT					-1	5
CM_QUERYRECORDRECT					-1	5
CM_QUERYVIEWPORTRECT					-1	5
CM_REMOVEDETAILFIELDINFO				-1	5
CM_REMOVERECORD 					-1	5
CM_SCROLLWINDOW 					-1	5
CM_SEARCHSTRING 					-1	5
CM_SETCNRINFO						-1	5
CM_SETRECORDEMPHASIS					-1	5
CM_SORTRECORD						-1	5
CM_OPENEDIT						-1	5
CM_CLOSEEDIT						-1	5
CM_COLLAPSETREE 					-1	5
CM_EXPANDTREE						-1	5
CM_QUERYRECORDINFO					-1	5
CN_DRAGAFTER						-1	5
CN_DRAGLEAVE						-1	5
CN_DRAGOVER						-1	5
CN_DROP 						-1	5
CN_DROPHELP						-1	5
CN_ENTER						-1	5
CN_INITDRAG						-1	5
CN_EMPHASIS						-1	5
CN_KILLFOCUS						-1	5
CN_SCROLL						-1	5
CN_QUERYDELTA						-1	5
CN_SETFOCUS						-1	5
CN_REALLOCPSZ						-1	5
CN_BEGINEDIT						-1	5
CN_ENDEDIT						-1	5
CN_COLLAPSETREE 					-1	5
CN_EXPANDTREE						-1	5
CN_HELP 						-1	5
CN_CONTEXTMENU						-1	5
CMA_TOP 						-1	5
CMA_BOTTOM						-1	5
CMA_LEFT						-1	5
CMA_RIGHT						-1	5
CMA_FIRST						-1	5
CMA_LAST						-1	5
CMA_END 						-1	5
CMA_PREV						-1	5
CMA_NEXT						-1	5
CMA_HORIZONTAL						-1	5
CMA_VERTICAL						-1	5
CMA_ICON						-1	5
CMA_TEXT						-1	5
CMA_PARTIAL						-1	5
CMA_COMPLETE						-1	5
CMA_PARENT						-1	5
CMA_FIRSTCHILD						-1	5
CMA_LASTCHILD						-1	5
CMA_CNRTITLE						-1	5
CMA_DELTA						-1	5
CMA_FLWINDOWATTR					-1	5
CMA_LINESPACING 					-1	5
CMA_PFIELDINFOLAST					-1	5
CMA_PSORTRECORD 					-1	5
CMA_PTLORIGIN						-1	5
CMA_SLBITMAPORICON					-1	5
CMA_XVERTSPLITBAR					-1	5
CMA_PFIELDINFOOBJECT					-1	5
CMA_TREEICON						-1	5
CMA_TREEBITMAP						-1	5
CMA_CXTREEINDENT					-1	5
CMA_CXTREELINE						-1	5
CMA_SLTREEBITMAPORICON					-1	5
CMA_ITEMORDER						-1	5
CMA_WINDOW						-1	5
CMA_WORKSPACE						-1	5
CMA_ZORDER						-1	5
CMA_DELTATOP						-1	5
CMA_DELTABOT						-1	5
CMA_DELTAHOME						-1	5
CMA_DELTAEND						-1	5
CMA_NOREPOSITION					-1	5
CMA_REPOSITION						-1	5
CMA_TEXTCHANGED 					-1	5
CMA_ERASE						-1	5
CMA_FREE						-1	5
CMA_INVALIDATE						-1	5
INCL_WINSTDSLIDER_INCLUDED				-1	5
SLM_ADDDETENT						-1	5
SLM_QUERYDETENTPOS					-1	5
SLM_QUERYSCALETEXT					-1	5
SLM_QUERYSLIDERINFO					-1	5
SLM_QUERYTICKPOS					-1	5
SLM_QUERYTICKSIZE					-1	5
SLM_REMOVEDETENT					-1	5
SLM_SETSCALETEXT					-1	5
SLM_SETSLIDERINFO					-1	5
SLM_SETTICKSIZE 					-1	5
SLN_CHANGE						-1	5
SLN_SLIDERTRACK 					-1	5
SLN_SETFOCUS						-1	5
SLN_KILLFOCUS						-1	5
SLS_HORIZONTAL						-1	5
SLS_VERTICAL						-1	5
SLS_CENTER						-1	5
SLS_BOTTOM						-1	5
SLS_TOP 						-1	5
SLS_LEFT						-1	5
SLS_RIGHT						-1	5
SLS_SNAPTOINCREMENT					-1	5
SLS_BUTTONSBOTTOM					-1	5
SLS_BUTTONSTOP						-1	5
SLS_BUTTONSLEFT 					-1	5
SLS_BUTTONSRIGHT					-1	5
SLS_OWNERDRAW						-1	5
SLS_READONLY						-1	5
SLS_RIBBONSTRIP 					-1	5
SLS_HOMEBOTTOM						-1	5
SLS_HOMETOP						-1	5
SLS_HOMELEFT						-1	5
SLS_HOMERIGHT						-1	5
SLS_PRIMARYSCALE1					-1	5
SLS_PRIMARYSCALE2					-1	5
SMA_SCALE1						-1	5
SMA_SCALE2						-1	5
SMA_SHAFTDIMENSIONS					-1	5
SMA_SHAFTPOSITION					-1	5
SMA_SLIDERARMDIMENSIONS 				-1	5
SMA_SLIDERARMPOSITION					-1	5
SMA_RANGEVALUE						-1	5
SMA_INCREMENTVALUE					-1	5
SMA_SETALLTICKS 					-1	5
SDA_RIBBONSTRIP 					-1	5
SDA_SLIDERSHAFT 					-1	5
SDA_BACKGROUND						-1	5
SDA_SLIDERARM						-1	5
PMERR_UPDATE_IN_PROGRESS				-1	5
SLDERR_INVALID_PARAMETERS				-1	5
INCL_WINSTDVALSET_INCLUDED				-1	5
VM_QUERYITEM						-1	5
VM_QUERYITEMATTR					-1	5
VM_QUERYMETRICS 					-1	5
VM_QUERYSELECTEDITEM					-1	5
VM_SELECTITEM						-1	5
VM_SETITEM						-1	5
VM_SETITEMATTR						-1	5
VM_SETMETRICS						-1	5
VN_SELECT						-1	5
VN_ENTER						-1	5
VN_DRAGLEAVE						-1	5
VN_DRAGOVER						-1	5
VN_DROP 						-1	5
VN_DROPHELP						-1	5
VN_INITDRAG						-1	5
VN_SETFOCUS						-1	5
VN_KILLFOCUS						-1	5
VN_HELP 						-1	5
VS_BITMAP						-1	5
VS_ICON 						-1	5
VS_TEXT 						-1	5
VS_RGB							-1	5
VS_COLORINDEX						-1	5
VS_BORDER						-1	5
VS_ITEMBORDER						-1	5
VS_SCALEBITMAPS 					-1	5
VS_RIGHTTOLEFT						-1	5
VS_OWNERDRAW						-1	5
VIA_BITMAP						-1	5
VIA_ICON						-1	5
VIA_TEXT						-1	5
VIA_RGB 						-1	5
VIA_COLORINDEX						-1	5
VIA_OWNERDRAW						-1	5
VIA_DISABLED						-1	5
VIA_DRAGGABLE						-1	5
VIA_DROPONABLE						-1	5
VMA_ITEMSIZE						-1	5
VMA_ITEMSPACING 					-1	5
VDA_ITEM						-1	5
VDA_ITEMBACKGROUND					-1	5
VDA_SURROUNDING 					-1	5
VDA_BACKGROUND						-1	5
VSERR_INVALID_PARAMETERS				-1	5
INCL_WINSTDBOOK_INCLUDED				-1	5
BKM_CALCPAGERECT					-1	5
BKM_DELETEPAGE						-1	5
BKM_INSERTPAGE						-1	5
BKM_INVALIDATETABS					-1	5
BKM_TURNTOPAGE						-1	5
BKM_QUERYPAGECOUNT					-1	5
BKM_QUERYPAGEID 					-1	5
BKM_QUERYPAGEDATA					-1	5
BKM_QUERYPAGEWINDOWHWND 				-1	5
BKM_QUERYTABBITMAP					-1	5
BKM_QUERYTABTEXT					-1	5
BKM_SETDIMENSIONS					-1	5
BKM_SETPAGEDATA 					-1	5
BKM_SETPAGEWINDOWHWND					-1	5
BKM_SETSTATUSLINETEXT					-1	5
BKM_SETTABBITMAP					-1	5
BKM_SETTABTEXT						-1	5
BKM_SETNOTEBOOKCOLORS					-1	5
BKM_QUERYPAGESTYLE					-1	5
BKM_QUERYSTATUSLINETEXT 				-1	5
BKN_PAGESELECTED					-1	5
BKN_NEWPAGESIZE 					-1	5
BKN_HELP						-1	5
BKN_PAGEDELETED 					-1	5
BKA_ALL 						-1	5
BKA_SINGLE						-1	5
BKA_TAB 						-1	5
BKA_LAST						-1	5
BKA_FIRST						-1	5
BKA_NEXT						-1	5
BKA_PREV						-1	5
BKA_TOP 						-1	5
BKA_MAJORTAB						-1	5
BKA_MINORTAB						-1	5
BKA_PAGEBUTTON						-1	5
BKA_STATUSTEXTON					-1	5
BKA_MAJOR						-1	5
BKA_MINOR						-1	5
BKA_AUTOPAGESIZE					-1	5
BKA_END 						-1	5
BKA_TEXT						-1	5
BKA_BITMAP						-1	5
BKS_BACKPAGESBR 					-1	5
BKS_BACKPAGESBL 					-1	5
BKS_BACKPAGESTR 					-1	5
BKS_BACKPAGESTL 					-1	5
BKS_MAJORTABRIGHT					-1	5
BKS_MAJORTABLEFT					-1	5
BKS_MAJORTABTOP 					-1	5
BKS_MAJORTABBOTTOM					-1	5
BKS_SQUARETABS						-1	5
BKS_ROUNDEDTABS 					-1	5
BKS_POLYGONTABS 					-1	5
BKS_SOLIDBIND						-1	5
BKS_SPIRALBIND						-1	5
BKS_STATUSTEXTLEFT					-1	5
BKS_STATUSTEXTRIGHT					-1	5
BKS_STATUSTEXTCENTER					-1	5
BKS_TABTEXTLEFT 					-1	5
BKS_TABTEXTRIGHT					-1	5
BKS_TABTEXTCENTER					-1	5
BKA_BACKGROUNDPAGECOLORINDEX				-1	5
BKA_BACKGROUNDPAGECOLOR 				-1	5
BKA_BACKGROUNDMAJORCOLORINDEX				-1	5
BKA_BACKGROUNDMAJORCOLOR				-1	5
BKA_BACKGROUNDMINORCOLORINDEX				-1	5
BKA_BACKGROUNDMINORCOLOR				-1	5
BKA_FOREGROUNDMAJORCOLORINDEX				-1	5
BKA_FOREGROUNDMAJORCOLOR				-1	5
BKA_FOREGROUNDMINORCOLORINDEX				-1	5
BKA_FOREGROUNDMINORCOLOR				-1	5
BOOKERR_INVALID_PARAMETERS				-1	5
TYPES_INCLUDED						-1	5
DTYP_USER						-1	5
DTYP_CTL_ARRAY						-1	5
DTYP_CTL_PARRAY 					-1	5
DTYP_CTL_OFFSET 					-1	5
DTYP_CTL_LENGTH 					-1	5
DTYP_ACCEL						-1	5
DTYP_ACCELTABLE 					-1	5
DTYP_ARCPARAMS						-1	5
DTYP_AREABUNDLE 					-1	5
DTYP_ATOM						-1	5
DTYP_BITMAPINFO 					-1	5
DTYP_BITMAPINFOHEADER					-1	5
DTYP_BITMAPINFO2					-1	5
DTYP_BITMAPINFOHEADER2					-1	5
DTYP_BIT16						-1	5
DTYP_BIT32						-1	5
DTYP_BIT8						-1	5
DTYP_BOOL						-1	5
DTYP_BTNCDATA						-1	5
DTYP_BYTE						-1	5
DTYP_CATCHBUF						-1	5
DTYP_CHAR						-1	5
DTYP_CHARBUNDLE 					-1	5
DTYP_CLASSINFO						-1	5
DTYP_COUNT2						-1	5
DTYP_COUNT2B						-1	5
DTYP_COUNT2CH						-1	5
DTYP_COUNT4						-1	5
DTYP_COUNT4B						-1	5
DTYP_CPID						-1	5
DTYP_CREATESTRUCT					-1	5
DTYP_CURSORINFO 					-1	5
DTYP_DEVOPENSTRUC					-1	5
DTYP_DLGTEMPLATE					-1	5
DTYP_DLGTITEM						-1	5
DTYP_ENTRYFDATA 					-1	5
DTYP_ERRORID						-1	5
DTYP_FATTRS						-1	5
DTYP_FFDESCS						-1	5
DTYP_FIXED						-1	5
DTYP_FONTMETRICS					-1	5
DTYP_FRAMECDATA 					-1	5
DTYP_GRADIENTL						-1	5
DTYP_HAB						-1	5
DTYP_HACCEL						-1	5
DTYP_HAPP						-1	5
DTYP_HATOMTBL						-1	5
DTYP_HBITMAP						-1	5
DTYP_HCINFO						-1	5
DTYP_HDC						-1	5
DTYP_HENUM						-1	5
DTYP_HHEAP						-1	5
DTYP_HINI						-1	5
DTYP_HLIB						-1	5
DTYP_HMF						-1	5
DTYP_HMQ						-1	5
DTYP_HPOINTER						-1	5
DTYP_HPROGRAM						-1	5
DTYP_HPS						-1	5
DTYP_HRGN						-1	5
DTYP_HSEM						-1	5
DTYP_HSPL						-1	5
DTYP_HSWITCH						-1	5
DTYP_HVPS						-1	5
DTYP_HWND						-1	5
DTYP_IDENTITY						-1	5
DTYP_IDENTITY4						-1	5
DTYP_IMAGEBUNDLE					-1	5
DTYP_INDEX2						-1	5
DTYP_IPT						-1	5
DTYP_KERNINGPAIRS					-1	5
DTYP_LENGTH2						-1	5
DTYP_LENGTH4						-1	5
DTYP_LINEBUNDLE 					-1	5
DTYP_LONG						-1	5
DTYP_MARKERBUNDLE					-1	5
DTYP_MATRIXLF						-1	5
DTYP_MLECTLDATA 					-1	5
DTYP_MLEMARGSTRUCT					-1	5
DTYP_MLEOVERFLOW					-1	5
DTYP_OFFSET2B						-1	5
DTYP_OWNERITEM						-1	5
DTYP_PID						-1	5
DTYP_PIX						-1	5
DTYP_POINTERINFO					-1	5
DTYP_POINTL						-1	5
DTYP_PROGCATEGORY					-1	5
DTYP_PROGRAMENTRY					-1	5
DTYP_PROGTYPE						-1	5
DTYP_PROPERTY2						-1	5
DTYP_PROPERTY4						-1	5
DTYP_QMSG						-1	5
DTYP_RECTL						-1	5
DTYP_RESID						-1	5
DTYP_RGB						-1	5
DTYP_RGNRECT						-1	5
DTYP_SBCDATA						-1	5
DTYP_SEGOFF						-1	5
DTYP_SHORT						-1	5
DTYP_SIZEF						-1	5
DTYP_SIZEL						-1	5
DTYP_STRL						-1	5
DTYP_STR16						-1	5
DTYP_STR32						-1	5
DTYP_STR64						-1	5
DTYP_STR8						-1	5
DTYP_SWBLOCK						-1	5
DTYP_SWCNTRL						-1	5
DTYP_SWENTRY						-1	5
DTYP_SWP						-1	5
DTYP_TID						-1	5
DTYP_TIME						-1	5
DTYP_TRACKINFO						-1	5
DTYP_UCHAR						-1	5
DTYP_ULONG						-1	5
DTYP_USERBUTTON 					-1	5
DTYP_USHORT						-1	5
DTYP_WIDTH4						-1	5
DTYP_WNDPARAMS						-1	5
DTYP_WNDPROC						-1	5
DTYP_WPOINT						-1	5
DTYP_WRECT						-1	5
DTYP_XYWINSIZE						-1	5
DTYP_PACCEL						-1	5
DTYP_PACCELTABLE					-1	5
DTYP_PARCPARAMS 					-1	5
DTYP_PAREABUNDLE					-1	5
DTYP_PATOM						-1	5
DTYP_PBITMAPINFO					-1	5
DTYP_PBITMAPINFOHEADER					-1	5
DTYP_PBITMAPINFO2					-1	5
DTYP_PBITMAPINFOHEADER2 				-1	5
DTYP_PBIT16						-1	5
DTYP_PBIT32						-1	5
DTYP_PBIT8						-1	5
DTYP_PBOOL						-1	5
DTYP_PBTNCDATA						-1	5
DTYP_PBYTE						-1	5
DTYP_PCATCHBUF						-1	5
DTYP_PCHAR						-1	5
DTYP_PCHARBUNDLE					-1	5
DTYP_PCLASSINFO 					-1	5
DTYP_PCOUNT2						-1	5
DTYP_PCOUNT2B						-1	5
DTYP_PCOUNT2CH						-1	5
DTYP_PCOUNT4						-1	5
DTYP_PCOUNT4B						-1	5
DTYP_PCPID						-1	5
DTYP_PCREATESTRUCT					-1	5
DTYP_PCURSORINFO					-1	5
DTYP_PDEVOPENSTRUC					-1	5
DTYP_PDLGTEMPLATE					-1	5
DTYP_PDLGTITEM						-1	5
DTYP_PENTRYFDATA					-1	5
DTYP_PERRORID						-1	5
DTYP_PFATTRS						-1	5
DTYP_PFFDESCS						-1	5
DTYP_PFIXED						-1	5
DTYP_PFONTMETRICS					-1	5
DTYP_PFRAMECDATA					-1	5
DTYP_PGRADIENTL 					-1	5
DTYP_PHAB						-1	5
DTYP_PHACCEL						-1	5
DTYP_PHAPP						-1	5
DTYP_PHATOMTBL						-1	5
DTYP_PHBITMAP						-1	5
DTYP_PHCINFO						-1	5
DTYP_PHDC						-1	5
DTYP_PHENUM						-1	5
DTYP_PHHEAP						-1	5
DTYP_PHINI						-1	5
DTYP_PHLIB						-1	5
DTYP_PHMF						-1	5
DTYP_PHMQ						-1	5
DTYP_PHPOINTER						-1	5
DTYP_PHPROGRAM						-1	5
DTYP_PHPS						-1	5
DTYP_PHRGN						-1	5
DTYP_PHSEM						-1	5
DTYP_PHSPL						-1	5
DTYP_PHSWITCH						-1	5
DTYP_PHVPS						-1	5
DTYP_PHWND						-1	5
DTYP_PIDENTITY						-1	5
DTYP_PIDENTITY4 					-1	5
DTYP_PIMAGEBUNDLE					-1	5
DTYP_PINDEX2						-1	5
DTYP_PIPT						-1	5
DTYP_PKERNINGPAIRS					-1	5
DTYP_PLENGTH2						-1	5
DTYP_PLENGTH4						-1	5
DTYP_PLINEBUNDLE					-1	5
DTYP_PLONG						-1	5
DTYP_PMARKERBUNDLE					-1	5
DTYP_PMATRIXLF						-1	5
DTYP_PMLECTLDATA					-1	5
DTYP_PMLEMARGSTRUCT					-1	5
DTYP_PMLEOVERFLOW					-1	5
DTYP_POFFSET2B						-1	5
DTYP_POWNERITEM 					-1	5
DTYP_PPID						-1	5
DTYP_PPIX						-1	5
DTYP_PPOINTERINFO					-1	5
DTYP_PPOINTL						-1	5
DTYP_PPROGCATEGORY					-1	5
DTYP_PPROGRAMENTRY					-1	5
DTYP_PPROGTYPE						-1	5
DTYP_PPROPERTY2 					-1	5
DTYP_PPROPERTY4 					-1	5
DTYP_PQMSG						-1	5
DTYP_PRECTL						-1	5
DTYP_PRESID						-1	5
DTYP_PRGB						-1	5
DTYP_PRGNRECT						-1	5
DTYP_PSBCDATA						-1	5
DTYP_PSEGOFF						-1	5
DTYP_PSHORT						-1	5
DTYP_PSIZEF						-1	5
DTYP_PSIZEL						-1	5
DTYP_PSTRL						-1	5
DTYP_PSTR16						-1	5
DTYP_PSTR32						-1	5
DTYP_PSTR64						-1	5
DTYP_PSTR8						-1	5
DTYP_PSWBLOCK						-1	5
DTYP_PSWCNTRL						-1	5
DTYP_PSWENTRY						-1	5
DTYP_PSWP						-1	5
DTYP_PTID						-1	5
DTYP_PTIME						-1	5
DTYP_PTRACKINFO 					-1	5
DTYP_PUCHAR						-1	5
DTYP_PULONG						-1	5
DTYP_PUSERBUTTON					-1	5
DTYP_PUSHORT						-1	5
DTYP_PWIDTH4						-1	5
DTYP_PWNDPARAMS 					-1	5
DTYP_PWNDPROC						-1	5
DTYP_PWPOINT						-1	5
DTYP_PWRECT						-1	5
DTYP_PXYWINSIZE 					-1	5
WIN_INCLUDED						-1	5
INCL_WINWINDOWMGR					-1	5
INCL_WINMESSAGEMGR					-1	5
INCL_WININPUT						-1	5
INCL_WINDIALOGS 					-1	5
INCL_WINSTATICS 					-1	5
INCL_WINBUTTONS 					-1	5
INCL_WINENTRYFIELDS					-1	5
INCL_WINMLE						-1	5
INCL_WINLISTBOXES					-1	5
INCL_WINMENUS						-1	5
INCL_WINSCROLLBARS					-1	5
INCL_WINFRAMEMGR					-1	5
INCL_WINFRAMECTLS					-1	5
INCL_WINRECTANGLES					-1	5
INCL_WINSYS						-1	5
INCL_WINTIMER						-1	5
INCL_WINACCELERATORS					-1	5
INCL_WINTRACKRECT					-1	5
INCL_WINCLIPBOARD					-1	5
INCL_WINCURSORS 					-1	5
INCL_WINPOINTERS					-1	5
INCL_WINHOOKS						-1	5
INCL_WINSWITCHLIST					-1	5
INCL_WINPROGRAMLIST					-1	5
INCL_WINSHELLDATA					-1	5
INCL_WINCOUNTRY 					-1	5
INCL_WINHEAP						-1	5
INCL_WINATOM						-1	5
INCL_WINERRORS						-1	5
INCL_WINDDE						-1	5
INCL_WINHELP						-1	5
INCL_WINSEI						-1	5
INCL_WINLOAD						-1	5
INCL_WINTYPES						-1	5
INCL_WINDESKTOP 					-1	5
INCL_WINPALETTE 					-1	5
INCL_WINTHUNKAPI					-1	5
INCL_WINSTDDLGS 					-1	5
INCL_WININPUT						-1	5
INCL_WINDIALOGS 					-1	5
INCL_WINSTATICS 					-1	5
INCL_WINBUTTONS 					-1	5
INCL_WINENTRYFIELDS					-1	5
INCL_WINLISTBOXES					-1	5
INCL_WINMENUS						-1	5
INCL_WINSCROLLBARS					-1	5
INCL_WINFRAMEMGR					-1	5
INCL_WINFRAMECTLS					-1	5
INCL_WINACCELERATORS					-1	5
INCL_WINPOINTERS					-1	5
INCL_WINMESSAGEMGR					-1	5
INCL_WINMLE						-1	5
INCL_WINHELP						-1	5
INCL_WINSTDDLGS 					-1	5
INCL_WINSYS						-1	5
INCL_WINENTRYFIELDS					-1	5
INCL_WINWINDOWMGR					-1	5
INCL_WINERRORS						-1	5
MPVOID							-1	5
MPFROMP 						-1	5
MPFROMHWND						-1	5
MPFROMCHAR						-1	5
MPFROMSHORT						-1	5
MPFROM2SHORT						-1	5
MPFROMSH2CH						-1	5
MPFROMLONG						-1	5
PVOIDFROMMP						-1	5
HWNDFROMMP						-1	5
CHAR1FROMMP						-1	5
CHAR2FROMMP						-1	5
CHAR3FROMMP						-1	5
CHAR4FROMMP						-1	5
SHORT1FROMMP						-1	5
SHORT2FROMMP						-1	5
LONGFROMMP						-1	5
MRFROMP 						-1	5
MRFROMSHORT						-1	5
MRFROM2SHORT						-1	5
MRFROMLONG						-1	5
PVOIDFROMMR						-1	5
SHORT1FROMMR						-1	5
SHORT2FROMMR						-1	5
LONGFROMMR						-1	5
HWND_DESKTOP						-1	5
HWND_OBJECT						-1	5
HWND_TOP						-1	5
HWND_BOTTOM						-1	5
HWND_THREADCAPTURE					-1	5
WC_FRAME						-1	5
WC_COMBOBOX						-1	5
WC_BUTTON						-1	5
WC_MENU 						-1	5
WC_STATIC						-1	5
WC_ENTRYFIELD						-1	5
WC_LISTBOX						-1	5
WC_SCROLLBAR						-1	5
WC_TITLEBAR						-1	5
WC_MLE							-1	5
WC_APPSTAT						-1	5
WC_KBDSTAT						-1	5
WC_PECIC						-1	5
WC_DBE_KKPOPUP						-1	5
WC_SPINBUTTON						-1	5
WC_CONTAINER						-1	5
WC_SLIDER						-1	5
WC_VALUESET						-1	5
WC_NOTEBOOK						-1	5
WC_PENFIRST						-1	5
WC_PENLAST						-1	5
WC_MMPMFIRST						-1	5
WC_MMPMLAST						-1	5
WS_VISIBLE						-1	5
WS_DISABLED						-1	5
WS_CLIPCHILDREN 					-1	5
WS_CLIPSIBLINGS 					-1	5
WS_PARENTCLIP						-1	5
WS_SAVEBITS						-1	5
WS_SYNCPAINT						-1	5
WS_MINIMIZED						-1	5
WS_MAXIMIZED						-1	5
WS_ANIMATE						-1	5
WS_GROUP						-1	5
WS_TABSTOP						-1	5
WS_MULTISELECT						-1	5
CS_MOVENOTIFY						-1	5
CS_SIZEREDRAW						-1	5
CS_HITTEST						-1	5
CS_PUBLIC						-1	5
CS_FRAME						-1	5
CS_CLIPCHILDREN 					-1	5
CS_CLIPSIBLINGS 					-1	5
CS_PARENTCLIP						-1	5
CS_SAVEBITS						-1	5
CS_SYNCPAINT						-1	5
PSF_LOCKWINDOWUPDATE					-1	5
PSF_CLIPUPWARDS 					-1	5
PSF_CLIPDOWNWARDS					-1	5
PSF_CLIPSIBLINGS					-1	5
PSF_CLIPCHILDREN					-1	5
PSF_PARENTCLIP						-1	5
SW_SCROLLCHILDREN					-1	5
SW_INVALIDATERGN					-1	5
QV_OS2							-1	5
QV_CMS							-1	5
QV_TSO							-1	5
QV_TSOBATCH						-1	5
QV_OS400						-1	5
QW_NEXT 						-1	5
QW_PREV 						-1	5
QW_TOP							-1	5
QW_BOTTOM						-1	5
QW_OWNER						-1	5
QW_PARENT						-1	5
QW_NEXTTOP						-1	5
QW_PREVTOP						-1	5
QW_FRAMEOWNER						-1	5
AWP_MINIMIZED						-1	5
AWP_MAXIMIZED						-1	5
AWP_RESTORED						-1	5
AWP_ACTIVATE						-1	5
AWP_DEACTIVATE						-1	5
SWP_SIZE						-1	5
SWP_MOVE						-1	5
SWP_ZORDER						-1	5
SWP_SHOW						-1	5
SWP_HIDE						-1	5
SWP_NOREDRAW						-1	5
SWP_NOADJUST						-1	5
SWP_ACTIVATE						-1	5
SWP_DEACTIVATE						-1	5
SWP_EXTSTATECHANGE					-1	5
SWP_MINIMIZE						-1	5
SWP_MAXIMIZE						-1	5
SWP_RESTORE						-1	5
SWP_FOCUSACTIVATE					-1	5
SWP_FOCUSDEACTIVATE					-1	5
SWP_NOAUTOCLOSE 					-1	5
DBM_NORMAL						-1	5
DBM_INVERT						-1	5
DBM_HALFTONE						-1	5
DBM_STRETCH						-1	5
DBM_IMAGEATTRS						-1	5
DT_LEFT 						-1	5
DT_QUERYEXTENT						-1	5
DT_UNDERSCORE						-1	5
DT_STRIKEOUT						-1	5
DT_TEXTATTRS						-1	5
DT_EXTERNALLEADING					-1	5
DT_CENTER						-1	5
DT_RIGHT						-1	5
DT_TOP							-1	5
DT_VCENTER						-1	5
DT_BOTTOM						-1	5
DT_HALFTONE						-1	5
DT_MNEMONIC						-1	5
DT_WORDBREAK						-1	5
DT_ERASERECT						-1	5
DB_PATCOPY						-1	5
DB_PATINVERT						-1	5
DB_DESTINVERT						-1	5
DB_AREAMIXMODE						-1	5
DB_ROP							-1	5
DB_INTERIOR						-1	5
DB_AREAATTRS						-1	5
DB_STANDARD						-1	5
DB_DLGBORDER						-1	5
QWS_USER						-1	5
QWS_ID							-1	5
QWS_MIN 						-1	5
QWL_USER						-1	5
QWL_STYLE						-1	5
QWP_PFNWP						-1	5
QWL_HMQ 						-1	5
QWL_RESERVED						-1	5
QWL_PENDATA						-1	5
QWL_MIN 						-1	5
QWL_HHEAP						-1	5
QWL_HWNDFOCUSSAVE					-1	5
QWL_DEFBUTTON						-1	5
QWL_PSSCBLK						-1	5
QWL_PFEPBLK						-1	5
QWL_PSTATBLK						-1	5
QWS_FLAGS						-1	5
QWS_RESULT						-1	5
QWS_XRESTORE						-1	5
QWS_YRESTORE						-1	5
QWS_CXRESTORE						-1	5
QWS_CYRESTORE						-1	5
QWS_XMINIMIZE						-1	5
QWS_YMINIMIZE						-1	5
WM_NULL 						-1	5
WM_CREATE						-1	5
WM_DESTROY						-1	5
WM_ENABLE						-1	5
WM_SHOW 						-1	5
WM_MOVE 						-1	5
WM_SIZE 						-1	5
WM_ADJUSTWINDOWPOS					-1	5
WM_CALCVALIDRECTS					-1	5
WM_SETWINDOWPARAMS					-1	5
WM_QUERYWINDOWPARAMS					-1	5
WM_HITTEST						-1	5
WM_ACTIVATE						-1	5
WM_SETFOCUS						-1	5
WM_SETSELECTION 					-1	5
WM_PPAINT						-1	5
WM_PSETFOCUS						-1	5
WM_PSYSCOLORCHANGE					-1	5
WM_PSIZE						-1	5
WM_PACTIVATE						-1	5
WM_PCONTROL						-1	5
WM_COMMAND						-1	5
WM_SYSCOMMAND						-1	5
WM_HELP 						-1	5
WM_PAINT						-1	5
WM_TIMER						-1	5
WM_SEM1 						-1	5
WM_SEM2 						-1	5
WM_SEM3 						-1	5
WM_SEM4 						-1	5
WM_CLOSE						-1	5
WM_QUIT 						-1	5
WM_SYSCOLORCHANGE					-1	5
WM_SYSVALUECHANGED					-1	5
WM_APPTERMINATENOTIFY					-1	5
WM_PRESPARAMCHANGED					-1	5
WM_CONTROL						-1	5
WM_VSCROLL						-1	5
WM_HSCROLL						-1	5
WM_INITMENU						-1	5
WM_MENUSELECT						-1	5
WM_MENUEND						-1	5
WM_DRAWITEM						-1	5
WM_MEASUREITEM						-1	5
WM_CONTROLPOINTER					-1	5
WM_QUERYDLGCODE 					-1	5
WM_INITDLG						-1	5
WM_SUBSTITUTESTRING					-1	5
WM_MATCHMNEMO						-1	5
WM_MATCHMNEMONIC					-1	5
WM_SAVEAPPLICATION					-1	5
WM_HELPBASE						-1	5
WM_HELPTOP						-1	5
WM_USER 						-1	5
CMDSRC_PUSHBUTTON					-1	5
CMDSRC_MENU						-1	5
CMDSRC_ACCELERATOR					-1	5
CMDSRC_FONTDLG						-1	5
CMDSRC_FILEDLG						-1	5
CMDSRC_PRINTDLG 					-1	5
CMDSRC_COLORDLG 					-1	5
CMDSRC_OTHER						-1	5
COMMANDMSG						-1	5
PM_REMOVE						-1	5
PM_NOREMOVE						-1	5
RUM_IN							-1	5
RUM_OUT 						-1	5
RUM_INOUT						-1	5
SMD_DELAYED						-1	5
SMD_IMMEDIATE						-1	5
SSM_SYNCHRONOUS 					-1	5
SSM_ASYNCHRONOUS					-1	5
SSM_MIXED						-1	5
CVR_ALIGNLEFT						-1	5
CVR_ALIGNBOTTOM 					-1	5
CVR_ALIGNRIGHT						-1	5
CVR_ALIGNTOP						-1	5
CVR_REDRAW						-1	5
HT_NORMAL						-1	5
HT_TRANSPARENT						-1	5
HT_DISCARD						-1	5
HT_ERROR						-1	5
WPM_TEXT						-1	5
WPM_CTLDATA						-1	5
WPM_PRESPARAMS						-1	5
WPM_CCHTEXT						-1	5
WPM_CBCTLDATA						-1	5
WPM_CBPRESPARAMS					-1	5
BMSG_POST						-1	5
BMSG_SEND						-1	5
BMSG_POSTQUEUE						-1	5
BMSG_DESCENDANTS					-1	5
BMSG_FRAMEONLY						-1	5
QS_KEY							-1	5
QS_MOUSEBUTTON						-1	5
QS_MOUSEMOVE						-1	5
QS_MOUSE						-1	5
QS_TIMER						-1	5
QS_PAINT						-1	5
QS_POSTMSG						-1	5
QS_SEM1 						-1	5
QS_SEM2 						-1	5
QS_SEM3 						-1	5
QS_SEM4 						-1	5
QS_SENDMSG						-1	5
QS_MSGINPUT						-1	5
__HEV__ 						-1	5
SMIM_ALL						-1	5
SMI_NOINTEREST						-1	5
SMI_INTEREST						-1	5
SMI_RESET						-1	5
SMI_AUTODISPATCH					-1	5
FC_NOSETFOCUS						-1	5
FC_NOBRINGTOTOP 					-1	5
FC_NOLOSEFOCUS						-1	5
FC_NOBRINGTOPFIRSTWINDOW				-1	5
FC_NOSETACTIVE						-1	5
FC_NOLOSEACTIVE 					-1	5
FC_NOSETSELECTION					-1	5
FC_NOLOSESELECTION					-1	5
QFC_NEXTINCHAIN 					-1	5
QFC_ACTIVE						-1	5
QFC_FRAME						-1	5
QFC_SELECTACTIVE					-1	5
QFC_PARTOFCHAIN 					-1	5
WM_MOUSEFIRST						-1	5
WM_MOUSELAST						-1	5
WM_BUTTONCLICKFIRST					-1	5
WM_BUTTONCLICKLAST					-1	5
WM_MOUSEMOVE						-1	5
WM_BUTTON1DOWN						-1	5
WM_BUTTON1UP						-1	5
WM_BUTTON1DBLCLK					-1	5
WM_BUTTON2DOWN						-1	5
WM_BUTTON2UP						-1	5
WM_BUTTON2DBLCLK					-1	5
WM_BUTTON3DOWN						-1	5
WM_BUTTON3UP						-1	5
WM_BUTTON3DBLCLK					-1	5
WM_MOUSEMAP						-1	5
WM_EXTMOUSEFIRST					-1	5
WM_EXTMOUSELAST 					-1	5
WM_CHORD						-1	5
WM_BUTTON1MOTIONSTART					-1	5
WM_BUTTON1MOTIONEND					-1	5
WM_BUTTON1CLICK 					-1	5
WM_BUTTON2MOTIONSTART					-1	5
WM_BUTTON2MOTIONEND					-1	5
WM_BUTTON2CLICK 					-1	5
WM_BUTTON3MOTIONSTART					-1	5
WM_BUTTON3MOTIONEND					-1	5
WM_BUTTON3CLICK 					-1	5
WM_MOUSETRANSLATEFIRST					-1	5
WM_MOUSETRANSLATELAST					-1	5
WM_BEGINDRAG						-1	5
WM_ENDDRAG						-1	5
WM_SINGLESELECT 					-1	5
WM_OPEN 						-1	5
WM_CONTEXTMENU						-1	5
WM_CONTEXTHELP						-1	5
WM_TEXTEDIT						-1	5
WM_BEGINSELECT						-1	5
WM_ENDSELECT						-1	5
WM_PENFIRST						-1	5
WM_PENLAST						-1	5
WM_MMPMFIRST						-1	5
WM_MMPMLAST						-1	5
WM_CHAR 						-1	5
WM_VIOCHAR						-1	5
KC_NONE 						-1	5
KC_CHAR 						-1	5
KC_VIRTUALKEY						-1	5
KC_SCANCODE						-1	5
KC_SHIFT						-1	5
KC_CTRL 						-1	5
KC_ALT							-1	5
KC_KEYUP						-1	5
KC_PREVDOWN						-1	5
KC_LONEKEY						-1	5
KC_DEADKEY						-1	5
KC_COMPOSITE						-1	5
KC_INVALIDCOMP						-1	5
KC_TOGGLE						-1	5
KC_INVALIDCHAR						-1	5
KC_DBCSRSRVD1						-1	5
KC_DBCSRSRVD2						-1	5
MOUSEMSG						-1	5
CHARMSG 						-1	5
INP_NONE						-1	5
INP_KBD 						-1	5
INP_MULT						-1	5
INP_RES2						-1	5
INP_SHIFT						-1	5
INP_CTRL						-1	5
INP_ALT 						-1	5
INP_RES3						-1	5
INP_RES4						-1	5
INP_IGNORE						-1	5
INP_IGNORE						-1	5
VK_BUTTON1						-1	5
VK_BUTTON2						-1	5
VK_BUTTON3						-1	5
VK_BREAK						-1	5
VK_BACKSPACE						-1	5
VK_TAB							-1	5
VK_BACKTAB						-1	5
VK_NEWLINE						-1	5
VK_SHIFT						-1	5
VK_CTRL 						-1	5
VK_ALT							-1	5
VK_ALTGRAF						-1	5
VK_PAUSE						-1	5
VK_CAPSLOCK						-1	5
VK_ESC							-1	5
VK_SPACE						-1	5
VK_PAGEUP						-1	5
VK_PAGEDOWN						-1	5
VK_END							-1	5
VK_HOME 						-1	5
VK_LEFT 						-1	5
VK_UP							-1	5
VK_RIGHT						-1	5
VK_DOWN 						-1	5
VK_PRINTSCRN						-1	5
VK_INSERT						-1	5
VK_DELETE						-1	5
VK_SCRLLOCK						-1	5
VK_NUMLOCK						-1	5
VK_ENTER						-1	5
VK_SYSRQ						-1	5
VK_F1							-1	5
VK_F2							-1	5
VK_F3							-1	5
VK_F4							-1	5
VK_F5							-1	5
VK_F6							-1	5
VK_F7							-1	5
VK_F8							-1	5
VK_F9							-1	5
VK_F10							-1	5
VK_F11							-1	5
VK_F12							-1	5
VK_F13							-1	5
VK_F14							-1	5
VK_F15							-1	5
VK_F16							-1	5
VK_F17							-1	5
VK_F18							-1	5
VK_F19							-1	5
VK_F20							-1	5
VK_F21							-1	5
VK_F22							-1	5
VK_F23							-1	5
VK_F24							-1	5
VK_ENDDRAG						-1	5
VK_CLEAR						-1	5
VK_EREOF						-1	5
VK_PA1							-1	5
VK_MENU 						-1	5
VK_DBCSFIRST						-1	5
VK_DBCSLAST						-1	5
VK_USERFIRST						-1	5
VK_USERLAST						-1	5
WM_JOURNALNOTIFY					-1	5
JRN_QUEUESTATUS 					-1	5
JRN_PHYSKEYSTATE					-1	5
DID_OK							-1	5
DID_CANCEL						-1	5
DID_ERROR						-1	5
WA_WARNING						-1	5
WA_NOTE 						-1	5
WA_ERROR						-1	5
WA_CWINALARMS						-1	5
MB_OK							-1	5
MB_OKCANCEL						-1	5
MB_RETRYCANCEL						-1	5
MB_ABORTRETRYIGNORE					-1	5
MB_YESNO						-1	5
MB_YESNOCANCEL						-1	5
MB_CANCEL						-1	5
MB_ENTER						-1	5
MB_ENTERCANCEL						-1	5
MB_NOICON						-1	5
MB_CUANOTIFICATION					-1	5
MB_ICONQUESTION 					-1	5
MB_ICONEXCLAMATION					-1	5
MB_CUAWARNING						-1	5
MB_ICONASTERISK 					-1	5
MB_ICONHAND						-1	5
MB_CUACRITICAL						-1	5
MB_QUERY						-1	5
MB_WARNING						-1	5
MB_INFORMATION						-1	5
MB_CRITICAL						-1	5
MB_ERROR						-1	5
MB_DEFBUTTON1						-1	5
MB_DEFBUTTON2						-1	5
MB_DEFBUTTON3						-1	5
MB_APPLMODAL						-1	5
MB_SYSTEMMODAL						-1	5
MB_HELP 						-1	5
MB_MOVEABLE						-1	5
MBID_OK 						-1	5
MBID_CANCEL						-1	5
MBID_ABORT						-1	5
MBID_RETRY						-1	5
MBID_IGNORE						-1	5
MBID_YES						-1	5
MBID_NO 						-1	5
MBID_HELP						-1	5
MBID_ENTER						-1	5
MBID_ERROR						-1	5
WinCheckButton						-1	5
WinQueryButtonCheckstate				-1	5
WinEnableControl					-1	5
WinIsControlEnabled					-1	5
DLGC_ENTRYFIELD 					-1	5
DLGC_BUTTON						-1	5
DLGC_RADIOBUTTON					-1	5
DLGC_STATIC						-1	5
DLGC_DEFAULT						-1	5
DLGC_PUSHBUTTON 					-1	5
DLGC_CHECKBOX						-1	5
DLGC_SCROLLBAR						-1	5
DLGC_MENU						-1	5
DLGC_TABONCLICK 					-1	5
DLGC_MLE						-1	5
EDI_FIRSTTABITEM					-1	5
EDI_LASTTABITEM 					-1	5
EDI_NEXTTABITEM 					-1	5
EDI_PREVTABITEM 					-1	5
EDI_FIRSTGROUPITEM					-1	5
EDI_LASTGROUPITEM					-1	5
EDI_NEXTGROUPITEM					-1	5
EDI_PREVGROUPITEM					-1	5
SS_TEXT 						-1	5
SS_GROUPBOX						-1	5
SS_ICON 						-1	5
SS_BITMAP						-1	5
SS_FGNDRECT						-1	5
SS_HALFTONERECT 					-1	5
SS_BKGNDRECT						-1	5
SS_FGNDFRAME						-1	5
SS_HALFTONEFRAME					-1	5
SS_BKGNDFRAME						-1	5
SS_SYSICON						-1	5
SS_							-1	5
SS_AUTOSIZE						-1	5
SM_SETHANDLE						-1	5
SM_QUERYHANDLE						-1	5
BS_PUSHBUTTON						-1	5
BS_CHECKBOX						-1	5
BS_AUTOCHECKBOX 					-1	5
BS_RADIOBUTTON						-1	5
BS_AUTORADIOBUTTON					-1	5
BS_3STATE						-1	5
BS_AUTO3STATE						-1	5
BS_USERBUTTON						-1	5
BS_PRIMARYSTYLES					-1	5
BS_BITMAP						-1	5
BS_ICON 						-1	5
BS_HELP 						-1	5
BS_SYSCOMMAND						-1	5
BS_DEFAULT						-1	5
BS_NOPOINTERFOCUS					-1	5
BS_NOBORDER						-1	5
BS_NOCURSORSELECT					-1	5
BS_AUTOSIZE						-1	5
BM_CLICK						-1	5
BM_QUERYCHECKINDEX					-1	5
BM_QUERYHILITE						-1	5
BM_SETHILITE						-1	5
BM_QUERYCHECK						-1	5
BM_SETCHECK						-1	5
BM_SETDEFAULT						-1	5
BN_CLICKED						-1	5
BN_DBLCLICKED						-1	5
BN_PAINT						-1	5
BDS_HILITED						-1	5
BDS_DISABLED						-1	5
BDS_DEFAULT						-1	5
ES_LEFT 						-1	5
ES_CENTER						-1	5
ES_RIGHT						-1	5
ES_AUTOSCROLL						-1	5
ES_MARGIN						-1	5
ES_AUTOTAB						-1	5
ES_READONLY						-1	5
ES_COMMAND						-1	5
ES_UNREADABLE						-1	5
ES_AUTOSIZE						-1	5
ES_ANY							-1	5
ES_SBCS 						-1	5
ES_DBCS 						-1	5
ES_MIXED						-1	5
CBS_SIMPLE						-1	5
CBS_DROPDOWN						-1	5
CBS_DROPDOWNLIST					-1	5
CBS_COMPATIBLE						-1	5
CBID_LIST						-1	5
CBID_EDIT						-1	5
CBM_SHOWLIST						-1	5
CBM_HILITE						-1	5
CBM_ISLISTSHOWING					-1	5
CBN_EFCHANGE						-1	5
CBN_EFSCROLL						-1	5
CBN_MEMERROR						-1	5
CBN_LBSELECT						-1	5
CBN_LBSCROLL						-1	5
CBN_SHOWLIST						-1	5
CBN_ENTER						-1	5
EM_QUERYCHANGED 					-1	5
EM_QUERYSEL						-1	5
EM_SETSEL						-1	5
EM_SETTEXTLIMIT 					-1	5
EM_CUT							-1	5
EM_COPY 						-1	5
EM_CLEAR						-1	5
EM_PASTE						-1	5
EM_QUERYFIRSTCHAR					-1	5
EM_SETFIRSTCHAR 					-1	5
EM_QUERYREADONLY					-1	5
EM_SETREADONLY						-1	5
EM_SETINSERTMODE					-1	5
EN_SETFOCUS						-1	5
EN_KILLFOCUS						-1	5
EN_CHANGE						-1	5
EN_SCROLL						-1	5
EN_MEMERROR						-1	5
EN_OVERFLOW						-1	5
EN_INSERTMODETOGGLE					-1	5
LS_MULTIPLESEL						-1	5
LS_OWNERDRAW						-1	5
LS_NOADJUSTPOS						-1	5
LS_HORZSCROLL						-1	5
LS_EXTENDEDSEL						-1	5
LN_SELECT						-1	5
LN_SETFOCUS						-1	5
LN_KILLFOCUS						-1	5
LN_SCROLL						-1	5
LN_ENTER						-1	5
LM_QUERYITEMCOUNT					-1	5
LM_INSERTITEM						-1	5
LM_SETTOPINDEX						-1	5
LM_DELETEITEM						-1	5
LM_SELECTITEM						-1	5
LM_QUERYSELECTION					-1	5
LM_SETITEMTEXT						-1	5
LM_QUERYITEMTEXTLENGTH					-1	5
LM_QUERYITEMTEXT					-1	5
LM_SETITEMHANDLE					-1	5
LM_QUERYITEMHANDLE					-1	5
LM_SEARCHSTRING 					-1	5
LM_SETITEMHEIGHT					-1	5
LM_QUERYTOPINDEX					-1	5
LM_DELETEALL						-1	5
LIT_CURSOR						-1	5
LIT_ERROR						-1	5
LIT_MEMERROR						-1	5
LIT_NONE						-1	5
LIT_FIRST						-1	5
LIT_END 						-1	5
LIT_SORTASCENDING					-1	5
LIT_SORTDESCENDING					-1	5
LSS_SUBSTRING						-1	5
LSS_PREFIX						-1	5
LSS_CASESENSITIVE					-1	5
WinDeleteLboxItem					-1	5
WinInsertLboxItem					-1	5
WinQueryLboxCount					-1	5
WinQueryLboxItemText					-1	5
WinQueryLboxItemTextLength				-1	5
WinSetLboxItemText					-1	5
WinQueryLboxSelectedItem				-1	5
MS_ACTIONBAR						-1	5
MS_TITLEBUTTON						-1	5
MS_VERTICALFLIP 					-1	5
MS_CONDITIONALCASCADE					-1	5
MM_INSERTITEM						-1	5
MM_DELETEITEM						-1	5
MM_QUERYITEM						-1	5
MM_SETITEM						-1	5
MM_QUERYITEMCOUNT					-1	5
MM_STARTMENUMODE					-1	5
MM_ENDMENUMODE						-1	5
MM_REMOVEITEM						-1	5
MM_SELECTITEM						-1	5
MM_QUERYSELITEMID					-1	5
MM_QUERYITEMTEXT					-1	5
MM_QUERYITEMTEXTLENGTH					-1	5
MM_SETITEMHANDLE					-1	5
MM_SETITEMTEXT						-1	5
MM_ITEMPOSITIONFROMID					-1	5
MM_ITEMIDFROMPOSITION					-1	5
MM_QUERYITEMATTR					-1	5
MM_SETITEMATTR						-1	5
MM_ISITEMVALID						-1	5
MM_QUERYITEMRECT					-1	5
MM_QUERYDEFAULTITEMID					-1	5
MM_SETDEFAULTITEMID					-1	5
MTI_INCLUDED						-1	5
MIT_END 						-1	5
MIT_NONE						-1	5
MIT_MEMERROR						-1	5
MIT_ERROR						-1	5
MIT_FIRST						-1	5
MIT_LAST						-1	5
MID_NONE						-1	5
MID_ERROR						-1	5
MIS_TEXT						-1	5
MIS_BITMAP						-1	5
MIS_SEPARATOR						-1	5
MIS_OWNERDRAW						-1	5
MIS_SUBMENU						-1	5
MIS_MULTMENU						-1	5
MIS_SYSCOMMAND						-1	5
MIS_HELP						-1	5
MIS_STATIC						-1	5
MIS_BUTTONSEPARATOR					-1	5
MIS_BREAK						-1	5
MIS_BREAKSEPARATOR					-1	5
MIS_GROUP						-1	5
MIS_SINGLE						-1	5
MIA_NODISMISS						-1	5
MIA_FRAMED						-1	5
MIA_CHECKED						-1	5
MIA_DISABLED						-1	5
MIA_HILITED						-1	5
PU_POSITIONONITEM					-1	5
PU_HCONSTRAIN						-1	5
PU_VCONSTRAIN						-1	5
PU_NONE 						-1	5
PU_MOUSEBUTTON1DOWN					-1	5
PU_MOUSEBUTTON2DOWN					-1	5
PU_MOUSEBUTTON3DOWN					-1	5
PU_SELECTITEM						-1	5
PU_MOUSEBUTTON1 					-1	5
PU_MOUSEBUTTON2 					-1	5
PU_MOUSEBUTTON3 					-1	5
PU_KEYBOARD						-1	5
WinCheckMenuItem					-1	5
WinIsMenuItemChecked					-1	5
WinEnableMenuItem					-1	5
WinIsMenuItemEnabled					-1	5
WinSetMenuItemText					-1	5
WinIsMenuItemValid					-1	5
SBS_HORZ						-1	5
SBS_VERT						-1	5
SBS_THUMBSIZE						-1	5
SBS_AUTOTRACK						-1	5
SBS_AUTOSIZE						-1	5
SBM_SETSCROLLBAR					-1	5
SBM_SETPOS						-1	5
SBM_QUERYPOS						-1	5
SBM_QUERYRANGE						-1	5
SBM_SETTHUMBSIZE					-1	5
SB_LINEUP						-1	5
SB_LINEDOWN						-1	5
SB_LINELEFT						-1	5
SB_LINERIGHT						-1	5
SB_PAGEUP						-1	5
SB_PAGEDOWN						-1	5
SB_PAGELEFT						-1	5
SB_PAGERIGHT						-1	5
SB_SLIDERTRACK						-1	5
SB_SLIDERPOSITION					-1	5
SB_ENDSCROLL						-1	5
FCF_TITLEBAR						-1	5
FCF_SYSMENU						-1	5
FCF_MENU						-1	5
FCF_SIZEBORDER						-1	5
FCF_MINBUTTON						-1	5
FCF_MAXBUTTON						-1	5
FCF_MINMAX						-1	5
FCF_VERTSCROLL						-1	5
FCF_HORZSCROLL						-1	5
FCF_DLGBORDER						-1	5
FCF_BORDER						-1	5
FCF_SHELLPOSITION					-1	5
FCF_TASKLIST						-1	5
FCF_NOBYTEALIGN 					-1	5
FCF_NOMOVEWITHOWNER					-1	5
FCF_ICON						-1	5
FCF_ACCELTABLE						-1	5
FCF_SYSMODAL						-1	5
FCF_SCREENALIGN 					-1	5
FCF_MOUSEALIGN						-1	5
FCF_HIDEBUTTON						-1	5
FCF_HIDEMAX						-1	5
FCF_DBE_APPSTAT 					-1	5
FCF_AUTOICON						-1	5
FCF_STANDARD						-1	5
FS_ICON 						-1	5
FS_ACCELTABLE						-1	5
FS_SHELLPOSITION					-1	5
FS_TASKLIST						-1	5
FS_NOBYTEALIGN						-1	5
FS_NOMOVEWITHOWNER					-1	5
FS_SYSMODAL						-1	5
FS_DLGBORDER						-1	5
FS_BORDER						-1	5
FS_SCREENALIGN						-1	5
FS_MOUSEALIGN						-1	5
FS_SIZEBORDER						-1	5
FS_AUTOICON						-1	5
FS_DBE_APPSTAT						-1	5
FS_STANDARD						-1	5
FF_FLASHWINDOW						-1	5
FF_ACTIVE						-1	5
FF_FLASHHILITE						-1	5
FF_OWNERHIDDEN						-1	5
FF_DLGDISMISSED 					-1	5
FF_OWNERDISABLED					-1	5
FF_SELECTED						-1	5
FF_NOACTIVATESWP					-1	5
WM_FLASHWINDOW						-1	5
WM_FORMATFRAME						-1	5
WM_UPDATEFRAME						-1	5
WM_FOCUSCHANGE						-1	5
WM_SETBORDERSIZE					-1	5
WM_TRACKFRAME						-1	5
WM_MINMAXFRAME						-1	5
WM_SETICON						-1	5
WM_QUERYICON						-1	5
WM_SETACCELTABLE					-1	5
WM_QUERYACCELTABLE					-1	5
WM_TRANSLATEACCEL					-1	5
WM_QUERYTRACKINFO					-1	5
WM_QUERYBORDERSIZE					-1	5
WM_NEXTMENU						-1	5
WM_ERASEBACKGROUND					-1	5
WM_QUERYFRAMEINFO					-1	5
WM_QUERYFOCUSCHAIN					-1	5
WM_OWNERPOSCHANGE					-1	5
WM_CALCFRAMERECT					-1	5
WM_WINDOWPOSCHANGED					-1	5
WM_ADJUSTFRAMEPOS					-1	5
WM_QUERYFRAMECTLCOUNT					-1	5
WM_QUERYHELPINFO					-1	5
WM_SETHELPINFO						-1	5
WM_ERROR						-1	5
WM_REALIZEPALETTE					-1	5
FI_FRAME						-1	5
FI_OWNERHIDE						-1	5
FI_ACTIVATEOK						-1	5
FI_NOMOVEWITHOWNER					-1	5
FID_SYSMENU						-1	5
FID_TITLEBAR						-1	5
FID_MINMAX						-1	5
FID_MENU						-1	5
FID_VERTSCROLL						-1	5
FID_HORZSCROLL						-1	5
FID_CLIENT						-1	5
FID_DBE_APPSTAT 					-1	5
FID_DBE_KBDSTAT 					-1	5
FID_DBE_PECIC						-1	5
FID_DBE_KKPOPUP 					-1	5
SC_SIZE 						-1	5
SC_MOVE 						-1	5
SC_MINIMIZE						-1	5
SC_MAXIMIZE						-1	5
SC_CLOSE						-1	5
SC_NEXT 						-1	5
SC_APPMENU						-1	5
SC_SYSMENU						-1	5
SC_RESTORE						-1	5
SC_NEXTFRAME						-1	5
SC_NEXTWINDOW						-1	5
SC_TASKMANAGER						-1	5
SC_HELPKEYS						-1	5
SC_HELPKEYS						-1	5
SC_HELPINDEX						-1	5
SC_HELPEXTENDED 					-1	5
SC_SWITCHPANELIDS					-1	5
SC_DBE_FIRST						-1	5
SC_DBE_LAST						-1	5
SC_BEGINDRAG						-1	5
SC_ENDDRAG						-1	5
SC_SELECT						-1	5
SC_OPEN 						-1	5
SC_CONTEXTMENU						-1	5
SC_CONTEXTHELP						-1	5
SC_TEXTEDIT						-1	5
SC_BEGINSELECT						-1	5
SC_ENDSELECT						-1	5
SC_WINDOW						-1	5
SC_HIDE 						-1	5
TBM_SETHILITE						-1	5
TBM_QUERYHILITE 					-1	5
SV_SWAPBUTTON						-1	5
SV_DBLCLKTIME						-1	5
SV_CXDBLCLK						-1	5
SV_CYDBLCLK						-1	5
SV_CXSIZEBORDER 					-1	5
SV_CYSIZEBORDER 					-1	5
SV_ALARM						-1	5
SV_RESERVEDFIRST1					-1	5
SV_RESERVEDLAST1					-1	5
SV_CURSORRATE						-1	5
SV_FIRSTSCROLLRATE					-1	5
SV_SCROLLRATE						-1	5
SV_NUMBEREDLISTS					-1	5
SV_WARNINGFREQ						-1	5
SV_NOTEFREQ						-1	5
SV_ERRORFREQ						-1	5
SV_WARNINGDURATION					-1	5
SV_NOTEDURATION 					-1	5
SV_ERRORDURATION					-1	5
SV_RESERVEDFIRST					-1	5
SV_RESERVEDLAST 					-1	5
SV_CXSCREEN						-1	5
SV_CYSCREEN						-1	5
SV_CXVSCROLL						-1	5
SV_CYHSCROLL						-1	5
SV_CYVSCROLLARROW					-1	5
SV_CXHSCROLLARROW					-1	5
SV_CXBORDER						-1	5
SV_CYBORDER						-1	5
SV_CXDLGFRAME						-1	5
SV_CYDLGFRAME						-1	5
SV_CYTITLEBAR						-1	5
SV_CYVSLIDER						-1	5
SV_CXHSLIDER						-1	5
SV_CXMINMAXBUTTON					-1	5
SV_CYMINMAXBUTTON					-1	5
SV_CYMENU						-1	5
SV_CXFULLSCREEN 					-1	5
SV_CYFULLSCREEN 					-1	5
SV_CXICON						-1	5
SV_CYICON						-1	5
SV_CXPOINTER						-1	5
SV_CYPOINTER						-1	5
SV_DEBUG						-1	5
SV_CMOUSEBUTTONS					-1	5
SV_CPOINTERBUTTONS					-1	5
SV_POINTERLEVEL 					-1	5
SV_CURSORLEVEL						-1	5
SV_TRACKRECTLEVEL					-1	5
SV_CTIMERS						-1	5
SV_MOUSEPRESENT 					-1	5
SV_CXBYTEALIGN						-1	5
SV_CXALIGN						-1	5
SV_CYBYTEALIGN						-1	5
SV_CYALIGN						-1	5
SV_NOTRESERVED						-1	5
SV_EXTRAKEYBEEP 					-1	5
SV_SETLIGHTS						-1	5
SV_INSERTMODE						-1	5
SV_MENUROLLDOWNDELAY					-1	5
SV_MENUROLLUPDELAY					-1	5
SV_ALTMNEMONIC						-1	5
SV_TASKLISTMOUSEACCESS					-1	5
SV_CXICONTEXTWIDTH					-1	5
SV_CICONTEXTLINES					-1	5
SV_CHORDTIME						-1	5
SV_CXCHORD						-1	5
SV_CYCHORD						-1	5
SV_CXMOTIONSTART					-1	5
SV_CYMOTIONSTART					-1	5
SV_BEGINDRAG						-1	5
SV_ENDDRAG						-1	5
SV_SINGLESELECT 					-1	5
SV_OPEN 						-1	5
SV_CONTEXTMENU						-1	5
SV_CONTEXTHELP						-1	5
SV_TEXTEDIT						-1	5
SV_BEGINSELECT						-1	5
SV_ENDSELECT						-1	5
SV_BEGINDRAGKB						-1	5
SV_ENDDRAGKB						-1	5
SV_SELECTKB						-1	5
SV_OPENKB						-1	5
SV_CONTEXTMENUKB					-1	5
SV_CONTEXTHELPKB					-1	5
SV_TEXTEDITKB						-1	5
SV_BEGINSELECTKB					-1	5
SV_ENDSELECTKB						-1	5
SV_ANIMATION						-1	5
SV_ANIMATIONSPEED					-1	5
SV_MONOICONS						-1	5
SV_KBDALTERED						-1	5
SV_PRINTSCREEN						-1	5
SV_CSYSVALUES						-1	5
PP_FOREGROUNDCOLOR					-1	5
PP_FOREGROUNDCOLORINDEX 				-1	5
PP_BACKGROUNDCOLOR					-1	5
PP_BACKGROUNDCOLORINDEX 				-1	5
PP_HILITEFOREGROUNDCOLOR				-1	5
PP_HILITEFOREGROUNDCOLORINDEX				-1	5
PP_HILITEBACKGROUNDCOLOR				-1	5
PP_HILITEBACKGROUNDCOLORINDEX				-1	5
PP_DISABLEDFOREGROUNDCOLOR				-1	5
PP_DISABLEDFOREGROUNDCOLORINDEX 			-1	5
PP_DISABLEDBACKGROUNDCOLOR				-1	5
PP_DISABLEDBACKGROUNDCOLORINDEX 			-1	5
PP_BORDERCOLOR						-1	5
PP_BORDERCOLORINDEX					-1	5
PP_FONTNAMESIZE 					-1	5
PP_FONTHANDLE						-1	5
PP_RESERVED						-1	5
PP_ACTIVECOLOR						-1	5
PP_ACTIVECOLORINDEX					-1	5
PP_INACTIVECOLOR					-1	5
PP_INACTIVECOLORINDEX					-1	5
PP_ACTIVETEXTFGNDCOLOR					-1	5
PP_ACTIVETEXTFGNDCOLORINDEX				-1	5
PP_ACTIVETEXTBGNDCOLOR					-1	5
PP_ACTIVETEXTBGNDCOLORINDEX				-1	5
PP_INACTIVETEXTFGNDCOLOR				-1	5
PP_INACTIVETEXTFGNDCOLORINDEX				-1	5
PP_INACTIVETEXTBGNDCOLOR				-1	5
PP_INACTIVETEXTBGNDCOLORINDEX				-1	5
PP_SHADOW						-1	5
PP_MENUFOREGROUNDCOLOR					-1	5
PP_MENUFOREGROUNDCOLORINDEX				-1	5
PP_MENUBACKGROUNDCOLOR					-1	5
PP_MENUBACKGROUNDCOLORINDEX				-1	5
PP_MENUHILITEFGNDCOLOR					-1	5
PP_MENUHILITEFGNDCOLORINDEX				-1	5
PP_MENUHILITEBGNDCOLOR					-1	5
PP_MENUHILITEBGNDCOLORINDEX				-1	5
PP_MENUDISABLEDFGNDCOLOR				-1	5
PP_MENUDISABLEDFGNDCOLORINDEX				-1	5
PP_MENUDISABLEDBGNDCOLOR				-1	5
PP_MENUDISABLEDBGNDCOLORINDEX				-1	5
PP_USER 						-1	5
QPF_NOINHERIT						-1	5
QPF_ID1COLORINDEX					-1	5
QPF_ID2COLORINDEX					-1	5
QPF_PURERGBCOLOR					-1	5
QPF_VALIDFLAGS						-1	5
SYSCLR_SHADOWHILITEBGND 				-1	5
SYSCLR_SHADOWHILITEFGND 				-1	5
SYSCLR_SHADOWTEXT					-1	5
SYSCLR_ENTRYFIELD					-1	5
SYSCLR_MENUDISABLEDTEXT 				-1	5
SYSCLR_MENUHILITE					-1	5
SYSCLR_MENUHILITEBGND					-1	5
SYSCLR_PAGEBACKGROUND					-1	5
SYSCLR_FIELDBACKGROUND					-1	5
SYSCLR_BUTTONLIGHT					-1	5
SYSCLR_BUTTONMIDDLE					-1	5
SYSCLR_BUTTONDARK					-1	5
SYSCLR_BUTTONDEFAULT					-1	5
SYSCLR_TITLEBOTTOM					-1	5
SYSCLR_SHADOW						-1	5
SYSCLR_ICONTEXT 					-1	5
SYSCLR_DIALOGBACKGROUND 				-1	5
SYSCLR_HILITEFOREGROUND 				-1	5
SYSCLR_HILITEBACKGROUND 				-1	5
SYSCLR_INACTIVETITLETEXTBGND				-1	5
SYSCLR_ACTIVETITLETEXTBGND				-1	5
SYSCLR_INACTIVETITLETEXT				-1	5
SYSCLR_ACTIVETITLETEXT					-1	5
SYSCLR_OUTPUTTEXT					-1	5
SYSCLR_WINDOWSTATICTEXT 				-1	5
SYSCLR_SCROLLBAR					-1	5
SYSCLR_BACKGROUND					-1	5
SYSCLR_ACTIVETITLE					-1	5
SYSCLR_INACTIVETITLE					-1	5
SYSCLR_MENU						-1	5
SYSCLR_WINDOW						-1	5
SYSCLR_WINDOWFRAME					-1	5
SYSCLR_MENUTEXT 					-1	5
SYSCLR_WINDOWTEXT					-1	5
SYSCLR_TITLETEXT					-1	5
SYSCLR_ACTIVEBORDER					-1	5
SYSCLR_INACTIVEBORDER					-1	5
SYSCLR_APPWORKSPACE					-1	5
SYSCLR_HELPBACKGROUND					-1	5
SYSCLR_HELPTEXT 					-1	5
SYSCLR_HELPHILITE					-1	5
SYSCLR_CSYSCOLORS					-1	5
TID_CURSOR						-1	5
TID_SCROLL						-1	5
TID_FLASHWINDOW 					-1	5
TID_USERMAX						-1	5
AF_CHAR 						-1	5
AF_CHAR 						-1	5
AF_VIRTUALKEY						-1	5
AF_SCANCODE						-1	5
AF_SHIFT						-1	5
AF_CONTROL						-1	5
AF_ALT							-1	5
AF_LONEKEY						-1	5
AF_SYSCOMMAND						-1	5
AF_HELP 						-1	5
EAF_DEFAULTOWNER					-1	5
EAF_UNCHANGEABLE					-1	5
EAF_REUSEICON						-1	5
TF_LEFT 						-1	5
TF_TOP							-1	5
TF_RIGHT						-1	5
TF_BOTTOM						-1	5
TF_MOVE 						-1	5
TF_SETPOINTERPOS					-1	5
TF_GRID 						-1	5
TF_STANDARD						-1	5
TF_ALLINBOUNDARY					-1	5
TF_VALIDATETRACKRECT					-1	5
TF_PARTINBOUNDARY					-1	5
WM_RENDERFMT						-1	5
WM_RENDERALLFMTS					-1	5
WM_DESTROYCLIPBOARD					-1	5
WM_PAINTCLIPBOARD					-1	5
WM_SIZECLIPBOARD					-1	5
WM_HSCROLLCLIPBOARD					-1	5
WM_VSCROLLCLIPBOARD					-1	5
WM_DRAWCLIPBOARD					-1	5
CF_TEXT 						-1	5
CF_BITMAP						-1	5
CF_DSPTEXT						-1	5
CF_DSPBITMAP						-1	5
CF_METAFILE						-1	5
CF_DSPMETAFILE						-1	5
CF_PALETTE						-1	5
CF_MMPMFIRST						-1	5
CF_MMPMLAST						-1	5
SZFMT_TEXT						-1	5
SZFMT_BITMAP						-1	5
SZFMT_DSPTEXT						-1	5
SZFMT_DSPBITMAP 					-1	5
SZFMT_METAFILE						-1	5
SZFMT_DSPMETAFILE					-1	5
SZFMT_PALETTE						-1	5
SZFMT_SYLK						-1	5
SZFMT_DIF						-1	5
SZFMT_TIFF						-1	5
SZFMT_OEMTEXT						-1	5
SZFMT_DIB						-1	5
SZFMT_OWNERDISPLAY					-1	5
SZFMT_LINK						-1	5
SZFMT_METAFILEPICT					-1	5
SZFMT_DSPMETAFILEPICT					-1	5
SZFMT_CPTEXT						-1	5
SZDDEFMT_RTF						-1	5
SZDDEFMT_PTRPICT					-1	5
CFI_OWNERFREE						-1	5
CFI_OWNERDISPLAY					-1	5
CFI_POINTER						-1	5
CFI_HANDLE						-1	5
CURSOR_SOLID						-1	5
CURSOR_HALFTONE 					-1	5
CURSOR_FRAME						-1	5
CURSOR_FLASH						-1	5
CURSOR_SETPOS						-1	5
SPTR_ARROW						-1	5
SPTR_TEXT						-1	5
SPTR_WAIT						-1	5
SPTR_SIZE						-1	5
SPTR_MOVE						-1	5
SPTR_SIZENWSE						-1	5
SPTR_SIZENESW						-1	5
SPTR_SIZEWE						-1	5
SPTR_SIZENS						-1	5
SPTR_APPICON						-1	5
SPTR_ICONINFORMATION					-1	5
SPTR_ICONQUESTION					-1	5
SPTR_ICONERROR						-1	5
SPTR_ICONWARNING					-1	5
SPTR_ILLEGAL						-1	5
SPTR_FILE						-1	5
SPTR_FOLDER						-1	5
SPTR_MULTFILE						-1	5
SPTR_PROGRAM						-1	5
SPTR_DISPLAY_PTRS					-1	5
SPTR_PENFIRST						-1	5
SPTR_PENLAST						-1	5
SPTR_CPTR						-1	5
SPTR_HANDICON						-1	5
SPTR_QUESICON						-1	5
SPTR_BANGICON						-1	5
SPTR_NOTEICON						-1	5
DP_NORMAL						-1	5
DP_HALFTONED						-1	5
DP_INVERTED						-1	5
SBMP_OLD_SYSMENU					-1	5
SBMP_OLD_SBUPARROW					-1	5
SBMP_OLD_SBDNARROW					-1	5
SBMP_OLD_SBRGARROW					-1	5
SBMP_OLD_SBLFARROW					-1	5
SBMP_MENUCHECK						-1	5
SBMP_OLD_CHECKBOXES					-1	5
SBMP_BTNCORNERS 					-1	5
SBMP_OLD_MINBUTTON					-1	5
SBMP_OLD_MAXBUTTON					-1	5
SBMP_OLD_RESTOREBUTTON					-1	5
SBMP_OLD_CHILDSYSMENU					-1	5
SBMP_DRIVE						-1	5
SBMP_FILE						-1	5
SBMP_FOLDER						-1	5
SBMP_TREEPLUS						-1	5
SBMP_TREEMINUS						-1	5
SBMP_PROGRAM						-1	5
SBMP_MENUATTACHED					-1	5
SBMP_SIZEBOX						-1	5
SBMP_SYSMENU						-1	5
SBMP_MINBUTTON						-1	5
SBMP_MAXBUTTON						-1	5
SBMP_RESTOREBUTTON					-1	5
SBMP_CHILDSYSMENU					-1	5
SBMP_SYSMENUDEP 					-1	5
SBMP_MINBUTTONDEP					-1	5
SBMP_MAXBUTTONDEP					-1	5
SBMP_RESTOREBUTTON					-1	5
SBMP_RESTOREBUTTONDEP					-1	5
SBMP_CHILDSYSMENUDEP					-1	5
SBMP_SBUPARROW						-1	5
SBMP_SBDNARROW						-1	5
SBMP_SBLFARROW						-1	5
SBMP_SBRGARROW						-1	5
SBMP_SBUPARROWDEP					-1	5
SBMP_SBDNARROWDEP					-1	5
SBMP_SBLFARROWDEP					-1	5
SBMP_SBRGARROWDEP					-1	5
SBMP_SBUPARROWDIS					-1	5
SBMP_SBDNARROWDIS					-1	5
SBMP_SBLFARROWDIS					-1	5
SBMP_SBRGARROWDIS					-1	5
SBMP_COMBODOWN						-1	5
SBMP_CHECKBOXES 					-1	5
HK_SENDMSG						-1	5
HK_INPUT						-1	5
HK_MSGFILTER						-1	5
HK_JOURNALRECORD					-1	5
HK_JOURNALPLAYBACK					-1	5
HK_HELP 						-1	5
HK_LOADER						-1	5
HK_REGISTERUSERMSG					-1	5
HK_MSGCONTROL						-1	5
HK_PLIST_ENTRY						-1	5
HK_PLIST_EXIT						-1	5
HK_FINDWORD						-1	5
HK_CODEPAGECHANGED					-1	5
HK_WINDOWDC						-1	5
HK_DESTROYWINDOW					-1	5
HK_CHECKMSGFILTER					-1	5
HK_MSGINPUT						-1	5
HK_LOCKUP						-1	5
HK_FLUSHBUF						-1	5
HMQ_CURRENT						-1	5
MSGF_DIALOGBOX						-1	5
MSGF_MESSAGEBOX 					-1	5
MSGF_TRACK						-1	5
MSGF_DDEPOSTMSG 					-1	5
HLPM_FRAME						-1	5
HLPM_WINDOW						-1	5
HLPM_MENU						-1	5
PM_MODEL_1X						-1	5
PM_MODEL_2X						-1	5
LHK_DELETEPROC						-1	5
LHK_DELETELIB						-1	5
LHK_LOADPROC						-1	5
LHK_LOADLIB						-1	5
MCHK_MSGINTEREST					-1	5
MCHK_CLASSMSGINTEREST					-1	5
MCHK_SYNCHRONISATION					-1	5
MCHK_MSGMODE						-1	5
RUMHK_DATATYPE						-1	5
RUMHK_MSG						-1	5
WCS_ERROR						-1	5
WCS_EQ							-1	5
WCS_LT							-1	5
WCS_GT							-1	5
MAKEINTATOM						-1	5
WINDBG_HWND_NOT_DESTROYED				-1	5
WINDBG_HPTR_NOT_DESTROYED				-1	5
WINDBG_HACCEL_NOT_DESTROYED				-1	5
WINDBG_HENUM_NOT_DESTROYED				-1	5
WINDBG_VISRGN_SEM_BUSY					-1	5
WINDBG_USER_SEM_BUSY					-1	5
WINDBG_DC_CACHE_BUSY					-1	5
WINDBG_HOOK_STILL_INSTALLED				-1	5
WINDBG_WINDOW_STILL_LOCKED				-1	5
WINDBG_UPDATEPS_ASSERTION_FAIL				-1	5
WINDBG_SENDMSG_WITHIN_USER_SEM				-1	5
WINDBG_USER_SEM_NOT_ENTERED				-1	5
WINDBG_PROC_NOT_EXPORTED				-1	5
WINDBG_BAD_SENDMSG_HWND 				-1	5
WINDBG_ABNORMAL_EXIT					-1	5
WINDBG_INTERNAL_REVISION				-1	5
WINDBG_INITSYSTEM_FAILED				-1	5
WINDBG_HATOMTBL_NOT_DESTROYED				-1	5
WINDBG_WINDOW_UNLOCK_WAIT				-1	5
SEI_PMWIN						-1	5
SZDDESYS_TOPIC						-1	5
SZDDESYS_ITEM_TOPICS					-1	5
SZDDESYS_ITEM_SYSITEMS					-1	5
SZDDESYS_ITEM_RTNMSG					-1	5
SZDDESYS_ITEM_STATUS					-1	5
SZDDESYS_ITEM_FORMATS					-1	5
SZDDESYS_ITEM_SECURITY					-1	5
SZDDESYS_ITEM_ITEMFORMATS				-1	5
SZDDESYS_ITEM_HELP					-1	5
SZDDESYS_ITEM_PROTOCOLS 				-1	5
SZDDESYS_ITEM_RESTART					-1	5
DDECTXT_CASESENSITIVE					-1	5
DDE_FACK						-1	5
DDE_FBUSY						-1	5
DDE_FNODATA						-1	5
DDE_FACKREQ						-1	5
DDE_FRESPONSE						-1	5
DDE_NOTPROCESSED					-1	5
DDE_FRESERVED						-1	5
DDE_FAPPSTATUS						-1	5
DDEFMT_TEXT						-1	5
DDEPM_RETRY						-1	5
DDEPM_NOFREE						-1	5
WM_DDE_FIRST						-1	5
WM_DDE_INITIATE 					-1	5
WM_DDE_REQUEST						-1	5
WM_DDE_ACK						-1	5
WM_DDE_DATA						-1	5
WM_DDE_ADVISE						-1	5
WM_DDE_UNADVISE 					-1	5
WM_DDE_POKE						-1	5
WM_DDE_EXECUTE						-1	5
WM_DDE_TERMINATE					-1	5
WM_DDE_INITIATEACK					-1	5
WM_DDE_LAST						-1	5
DDES_PSZITEMNAME					-1	5
DDES_PABDATA						-1	5
DDEI_PCONVCONTEXT					-1	5
WM_QUERYCONVERTPOS					-1	5
QCP_CONVERT						-1	5
QCP_NOCONVERT						-1	5
SDT_DESTROY						-1	5
SDT_NOBKGND						-1	5
SDT_TILE						-1	5
SDT_SCALE						-1	5
SDT_PATTERN						-1	5
SDT_CENTER						-1	5
SDT_RETAIN						-1	5
SDT_LOADFILE						-1	5
STR_DLLNAME						-1	5
WM_DBCSFIRST						-1	5
WM_DBCSLAST						-1	5
PMWP_INCLUDED						-1	5
INCL_WPCLASS						-1	5
CCHMAXCLASS						-1	5
QC_First						-1	5
QC_Next 						-1	5
QC_Last 						-1	5
QC_FIRST						-1	5
QC_NEXT 						-1	5
QC_LAST 						-1	5
CO_FAILIFEXISTS 					-1	5
CO_REPLACEIFEXISTS					-1	5
CO_UPDATEIFEXISTS					-1	5
INCL_WPERRORS						-1	5
SETTINGS_PAGE_NUMBERS					-1	5
REXXSAA_INCLUDED					-1	5
INCL_RXSUBCOM						-1	5
INCL_RXSHV						-1	5
INCL_RXFUNC						-1	5
INCL_RXSYSEXIT						-1	5
INCL_RXMACRO						-1	5
INCL_RXARI						-1	5
RXAUTOBUFLEN						-1	5
RXNULLSTRING						-1	5
RXZEROLENSTRING 					-1	5
RXVALIDSTRING						-1	5
RXSTRLEN						-1	5
RXSTRPTR						-1	5
MAKERXSTRING						-1	5
RXCOMMAND						-1	5
RXSUBROUTINE						-1	5
RXFUNCTION						-1	5
RXSUBCOM_DROPPABLE					-1	5
RXSUBCOM_NONDROP					-1	5
RXSUBCOM_ISREG						-1	5
RXSUBCOM_ERROR						-1	5
RXSUBCOM_FAILURE					-1	5
RXSUBCOM_BADENTRY					-1	5
RXSUBCOM_NOEMEM 					-1	5
RXSUBCOM_BADTYPE					-1	5
RXSUBCOM_NOTINIT					-1	5
RXSUBCOM_OK						-1	5
RXSUBCOM_DUP						-1	5
RXSUBCOM_MAXREG 					-1	5
RXSUBCOM_NOTREG 					-1	5
RXSUBCOM_NOCANDROP					-1	5
RXSUBCOM_LOADERR					-1	5
RXSUBCOM_NOPROC 					-1	5
RXSHV_SET						-1	5
RXSHV_FETCH						-1	5
RXSHV_DROPV						-1	5
RXSHV_SYSET						-1	5
RXSHV_SYFET						-1	5
RXSHV_SYDRO						-1	5
RXSHV_NEXTV						-1	5
RXSHV_PRIV						-1	5
RXSHV_EXIT						-1	5
RXSHV_NOAVL						-1	5
RXSHV_OK						-1	5
RXSHV_NEWV						-1	5
RXSHV_LVAR						-1	5
RXSHV_TRUNC						-1	5
RXSHV_BADN						-1	5
RXSHV_MEMFL						-1	5
RXSHV_BADF						-1	5
RXFUNC_DYNALINK 					-1	5
RXFUNC_CALLENTRY					-1	5
RXFUNC_OK						-1	5
RXFUNC_DEFINED						-1	5
RXFUNC_NOMEM						-1	5
RXFUNC_NOTREG						-1	5
RXFUNC_MODNOTFND					-1	5
RXFUNC_ENTNOTFND					-1	5
RXFUNC_NOTINIT						-1	5
RXFUNC_BADTYPE						-1	5
RXEXIT_DROPPABLE					-1	5
RXEXIT_NONDROP						-1	5
RXEXIT_HANDLED						-1	5
RXEXIT_NOT_HANDLED					-1	5
RXEXIT_RAISE_ERROR					-1	5
RXEXIT_ISREG						-1	5
RXEXIT_ERROR						-1	5
RXEXIT_FAILURE						-1	5
RXEXIT_BADENTRY 					-1	5
RXEXIT_NOEMEM						-1	5
RXEXIT_BADTYPE						-1	5
RXEXIT_NOTINIT						-1	5
RXEXIT_OK						-1	5
RXEXIT_DUP						-1	5
RXEXIT_MAXREG						-1	5
RXEXIT_NOTREG						-1	5
RXEXIT_NOCANDROP					-1	5
RXEXIT_LOADERR						-1	5
RXEXIT_NOPROC						-1	5
RXENDLST						-1	5
RXFNC							-1	5
RXFNCCAL						-1	5
RXCMD							-1	5
RXCMDHST						-1	5
RXMSQ							-1	5
RXMSQPLL						-1	5
RXMSQPSH						-1	5
RXMSQSIZ						-1	5
RXMSQNAM						-1	5
RXSIO							-1	5
RXSIOSAY						-1	5
RXSIOTRC						-1	5
RXSIOTRD						-1	5
RXSIODTR						-1	5
RXSIOTLL						-1	5
RXHLT							-1	5
RXHLTCLR						-1	5
RXHLTTST						-1	5
RXTRC							-1	5
RXTRCTST						-1	5
RXINI							-1	5
RXINIEXT						-1	5
RXTER							-1	5
RXTEREXT						-1	5
RXNOOFEXITS						-1	5
RXARI_OK						-1	5
RXARI_NOT_FOUND 					-1	5
RXARI_PROCESSING_ERROR					-1	5
RXMACRO_SEARCH_BEFORE					-1	5
RXMACRO_SEARCH_AFTER					-1	5
RXMACRO_OK						-1	5
RXMACRO_NO_STORAGE					-1	5
RXMACRO_NOT_FOUND					-1	5
RXMACRO_EXTENSION_REQUIRED				-1	5
RXMACRO_ALREADY_EXISTS					-1	5
RXMACRO_FILE_ERROR					-1	5
RXMACRO_SIGNATURE_ERROR 				-1	5
RXMACRO_SOURCE_NOT_FOUND				-1	5
RXMACRO_INVALID_POSITION				-1	5
RXMACRO_NOT_INIT					-1	5
REXXSTART						-1	5
REXXREGISTERSUBCOMDLL					-1	5
REXXREGISTERSUBCOMEXE					-1	5
REXXQUERYSUBCOM 					-1	5
REXXDEREGISTERSUBCOM					-1	5
REXXVARIABLEPOOL					-1	5
REXXREGISTERFUNCTIONDLL 				-1	5
REXXREGISTERFUNCTIONEXE 				-1	5
REXXDEREGISTERFUNCTION					-1	5
REXXQUERYFUNCTION					-1	5
REXXREGISTEREXITDLL					-1	5
REXXREGISTEREXITEXE					-1	5
REXXDEREGISTEREXIT					-1	5
REXXQUERYEXIT						-1	5
REXXSETHALT						-1	5
REXXSETTRACE						-1	5
REXXRESETTRACE						-1	5
REXXADDMACRO						-1	5
REXXDROPMACRO						-1	5
REXXSAVEMACROSPACE					-1	5
REXXLOADMACROSPACE					-1	5
REXXQUERYMACRO						-1	5
REXXREORDERMACRO					-1	5
REXXCLEARMACROSPACE					-1	5
som_h							-1	5
SOMEXTERN						-1	5
SOMEXTERN						-1	5
SOMLINK 						-1	5
SOMLINK 						-1	5
SOMLINK 						-1	5
somcdev_h						-1	5
SOM_Resolve						-1	5
SOM_ResolveNoCheck					-1	5
SOM_ParentResolve					-1	5
SOM_ParentResolveE					-1	5
SOM_Resolve						-1	5
SOM_ResolveNoCheck					-1	5
SOM_ParentResolve					-1	5
SOM_ParentResolveE					-1	5
SOM_DataResolve 					-1	5
SOM_CompareValidIds					-1	5
SOM_CompareIds						-1	5
SOM_StringFromId					-1	5
SOM_IdFromString					-1	5
SOM_CheckId						-1	5
SOM_GetClass						-1	5
SOM_TestCls						-1	5
SOM_Measure						-1	5
SOM_TestCls						-1	5
SOM_Error						-1	5
SOM_NoTrace						-1	5
SOM_Trace						-1	5
SOM_TraceCore						-1	5
SOM_Trace						-1	5
SOM_TraceCore						-1	5
SOM_Assert						-1	5
SOM_AssertCore						-1	5
SOM_Expect						-1	5
SOM_WarnMsg						-1	5
SOM_Test						-1	5
SOM_TestC						-1	5
SOMMethodDebug						-1	5
SOM_Ok							-1	5
SOM_Warn						-1	5
SOM_Ignore						-1	5
SOM_Fatal						-1	5
SOM_Template						-1	5
SOM_FatalCode						-1	5
SOM_WarnCode						-1	5
SOM_IgnoreCode						-1	5
SOM_OkCode						-1	5
SOM_TemplateCode					-1	5
somcls_h						-1	5
SOMClass						-1	5
SOMClass_MajorVersion					-1	5
SOMClass_MinorVersion					-1	5
SOMClassNewClass					-1	5
SOMClassClassData					-1	5
SOMClassCClassData					-1	5
SOMClass_classObj					-1	5
_SOMClass						-1	5
_SOMClassNew						-1	5
SOMClassNew						-1	5
SOMClassRenew						-1	5
SOMClass_somInit					-1	5
SOMClass_somUninit					-1	5
SOMClass_somDumpSelfInt 				-1	5
somMD_SOMClass_somAddStaticMethod			-1	5
SOMClass_somAddStaticMethod				-1	5
_somAddStaticMethod					-1	5
somMD_SOMClass_somClassReady				-1	5
SOMClass_somClassReady					-1	5
_somClassReady						-1	5
somMD_SOMClass_somInitClass				-1	5
SOMClass_somInitClass					-1	5
_somInitClass						-1	5
somMD_SOMClass_somOverrideSMethod			-1	5
SOMClass_somOverrideSMethod				-1	5
_somOverrideSMethod					-1	5
somMD_SOMClass_somNew					-1	5
SOMClass_somNew 					-1	5
_somNew 						-1	5
somMD_SOMClass_somNewNoInit				-1	5
SOMClass_somNewNoInit					-1	5
_somNewNoInit						-1	5
somMD_SOMClass_somRenew 				-1	5
SOMClass_somRenew					-1	5
_somRenew						-1	5
somMD_SOMClass_somRenewNoInit				-1	5
SOMClass_somRenewNoInit 				-1	5
_somRenewNoInit 					-1	5
somMD_SOMClass_somGetApplyStub				-1	5
SOMClass_somGetApplyStub				-1	5
_somGetApplyStub					-1	5
somMD_SOMClass_somGetClassData				-1	5
SOMClass_somGetClassData				-1	5
_somGetClassData					-1	5
somMD_SOMClass_somGetClassMtab				-1	5
SOMClass_somGetClassMtab				-1	5
_somGetClassMtab					-1	5
somMD_SOMClass_somGetInstanceToken			-1	5
SOMClass_somGetInstanceToken				-1	5
_somGetInstanceToken					-1	5
somMD_SOMClass_somGetMemberToken			-1	5
SOMClass_somGetMemberToken				-1	5
_somGetMemberToken					-1	5
somMD_SOMClass_somGetInstanceOffset			-1	5
SOMClass_somGetInstanceOffset				-1	5
_somGetInstanceOffset					-1	5
somMD_SOMClass_somGetInstancePartSize			-1	5
SOMClass_somGetInstancePartSize 			-1	5
_somGetInstancePartSize 				-1	5
somMD_SOMClass_somGetInstanceSize			-1	5
SOMClass_somGetInstanceSize				-1	5
_somGetInstanceSize					-1	5
somMD_SOMClass_somGetMethodDescriptor			-1	5
SOMClass_somGetMethodDescriptor 			-1	5
_somGetMethodDescriptor 				-1	5
somMD_SOMClass_somGetName				-1	5
SOMClass_somGetName					-1	5
_somGetName						-1	5
somMD_SOMClass_somGetNumMethods 			-1	5
SOMClass_somGetNumMethods				-1	5
_somGetNumMethods					-1	5
somMD_SOMClass_somGetNumStaticMethods			-1	5
SOMClass_somGetNumStaticMethods 			-1	5
_somGetNumStaticMethods 				-1	5
somMD_SOMClass_somGetParent				-1	5
SOMClass_somGetParent					-1	5
_somGetParent						-1	5
somMD_SOMClass_somGetPClsMtab				-1	5
SOMClass_somGetPClsMtab 				-1	5
_somGetPClsMtab 					-1	5
somMD_SOMClass_somSetClassData				-1	5
SOMClass_somSetClassData				-1	5
_somSetClassData					-1	5
somMD_SOMClass_somCheckVersion				-1	5
SOMClass_somCheckVersion				-1	5
_somCheckVersion					-1	5
somMD_SOMClass_somDescendedFrom 			-1	5
SOMClass_somDescendedFrom				-1	5
_somDescendedFrom					-1	5
somMD_SOMClass_somSupportsMethod			-1	5
SOMClass_somSupportsMethod				-1	5
_somSupportsMethod					-1	5
somMD_SOMClass_somFindMethod				-1	5
SOMClass_somFindMethod					-1	5
_somFindMethod						-1	5
somMD_SOMClass_somFindMethodOk				-1	5
SOMClass_somFindMethodOk				-1	5
_somFindMethodOk					-1	5
som							-1	5
somMD_SOMClass_somFindSMethod				-1	5
SOMClass_somFindSMethod 				-1	5
_somFindSMethod 					-1	5
somMD_SOMClass_somFindSMethodOk 			-1	5
SOMClass_somFindSMethodOk				-1	5
_somFindSMethodOk					-1	5
somcm_h 						-1	5
SOMClassMgr						-1	5
SOMClassMgr_MajorVersion				-1	5
SOMClassMgr_MinorVersion				-1	5
SOMClassMgrNewClass					-1	5
SOMClassMgrClassData					-1	5
SOMClassMgrCClassData					-1	5
SOMClassMgr_classObj					-1	5
_SOMClassMgr						-1	5
_SOMClassMgrNew 					-1	5
SOMClassMgrNew						-1	5
SOMClassMgrRenew					-1	5
SOMClassMgr_somInit					-1	5
SOMClassMgr_somUninit					-1	5
SOMClassMgr_somDumpSelfInt				-1	5
somMD_SOMClassMgr_somLoadClassFile			-1	5
SOMClassMgr_somLoadClassFile				-1	5
_somLoadClassFile					-1	5
somMD_SOMClassMgr_somLocateClassFile			-1	5
SOMClassMgr_somLocateClassFile				-1	5
_somLocateClassFile					-1	5
somMD_SOMClassMgr_somRegisterClass			-1	5
SOMClassMgr_somRegisterClass				-1	5
_somRegisterClass					-1	5
somMD_SOMClassMgr_somUnloadClassFile			-1	5
SOMClassMgr_somUnloadClassFile				-1	5
_somUnloadClassFile					-1	5
somMD_SOMClassMgr_somUnregisterClass			-1	5
SOMClassMgr_somUnregisterClass				-1	5
_somUnregisterClass					-1	5
somMD_SOMClassMgr_somGetInitFunction			-1	5
SOMClassMgr_somGetInitFunction				-1	5
_somGetInitFunction					-1	5
somMD_SOMClassMgr_somGetRelatedClasses			-1	5
SOMClassMgr_somGetRelatedClasses			-1	5
_somGetRelatedClasses					-1	5
somMD_SOMClassMgr_somClassFromId			-1	5
SOMClassMgr_somClassFromId				-1	5
_somClassFromId 					-1	5
somMD_SOMClassMgr_somFindClass				-1	5
SOMClassMgr_somFindClass				-1	5
_somFindClass						-1	5
somMD_SOMClassMgr_somFindClsInFile			-1	5
SOMClassMgr_somFindClsInFile				-1	5
_somFindClsInFile					-1	5
somMD_SOMClassMgr_somMergeInto				-1	5
SOMClassMgr_somMergeInto				-1	5
_somMergeInto						-1	5
somerr_h						-1	5
SOM_EB							-1	5
SOMERROR_CCNullClass					-1	5
SOMERROR_SompntOverflow 				-1	5
SOMERROR_MethodNotFound 				-1	5
SOMERROR_StaticMethodTableOverflow			-1	5
SOMERROR_DefaultMethod					-1	5
SOM_FatalCode						-1	5
SOMERROR_MissingMethod					-1	5
SOMERROR_BadVersion					-1	5
SOMERROR_NullId 					-1	5
SOMERROR_OutOfMemory					-1	5
SOMERROR_TestObjectFailure				-1	5
SOMERROR_FailedTest					-1	5
SOMERROR_ClassNotFound					-1	5
SOMERROR_OldMethod					-1	5
SOMERROR_CouldNotStartup				-1	5
SOMERROR_NotRegistered					-1	5
SOMERROR_BadOverride					-1	5
SOMERROR_NotImplementedYet				-1	5
SOMERROR_MustOverride					-1	5
SOMERROR_BadArgument					-1	5
SOMERROR_NoParentClass					-1	5
SOMERROR_NoMetaClass					-1	5
SOMERROR_Indexrange					-1	5
SOMERROR_Underflow					-1	5
SOMERROR_Logic						-1	5
SOMERROR_6						-1	5
SOMERROR_7						-1	5
extnames_h						-1	5
SOM_AssertLevel 					-1	5
SOM_TraceLevel						-1	5
SOM_WarnLevel						-1	5
SOMCalloc						-1	5
SOMClassMgrObject					-1	5
SOMDeleteModule 					-1	5
SOMError						-1	5
SOMFree 						-1	5
SOMOutCharRoutine					-1	5
SOMLoadModule						-1	5
SOMMalloc						-1	5
SOMRealloc						-1	5
somAssert						-1	5
somBeginPersistentIds					-1	5
somCheckArgs						-1	5
somCheckId						-1	5
somCompareIds						-1	5
somConstructClass					-1	5
somDataResolve						-1	5
somEndPersistentIds					-1	5
somEnvironmentNew					-1	5
somGenericApply 					-1	5
somGetClass						-1	5
somIdFromString 					-1	5
somLPrintf						-1	5
somParentResolve					-1	5
somPrefixLevel						-1	5
somPrintf						-1	5
somRegisterId						-1	5
somResolve						-1	5
somSetExpectedIds					-1	5
somStringFromId 					-1	5
somTest 						-1	5
somTestCls						-1	5
somTotalRegIds						-1	5
somUniqueKey						-1	5
somVprintf						-1	5
somobj_h						-1	5
SOMObject						-1	5
SOMObject_MajorVersion					-1	5
SOMObject_MinorVersion					-1	5
SOMObjectNewClass					-1	5
SOMObjectClassData					-1	5
SOMObjectCClassData					-1	5
SOMObject_classObj					-1	5
_SOMObject						-1	5
_SOMObjectNew						-1	5
SOMObjectNew						-1	5
SOMObjectRenew						-1	5
somMD_SOMObject_somFree 				-1	5
SOMObject_somFree					-1	5
_somFree						-1	5
somMD_SOMObject_somInit 				-1	5
SOMObject_somInit					-1	5
_somInit						-1	5
somMD_SOMObject_somUninit				-1	5
SOMObject_somUninit					-1	5
_somUninit						-1	5
somMD_SOMObject_somGetClass				-1	5
SOMObject_somGetClass					-1	5
_somGetClass						-1	5
somMD_SOMObject_somGetClassName 			-1	5
SOMObject_somGetClassName				-1	5
_somGetClassName					-1	5
somMD_SOMObject_somGetSize				-1	5
SOMObject_somGetSize					-1	5
_somGetSize						-1	5
somMD_SOMObject_somIsA					-1	5
SOMObject_somIsA					-1	5
_somIsA 						-1	5
somMD_SOMObject_somIsInstanceOf 			-1	5
SOMObject_somIsInstanceOf				-1	5
_somIsInstanceOf					-1	5
somMD_SOMObject_somRespondsTo				-1	5
SOMObject_somRespondsTo 				-1	5
_somRespondsTo						-1	5
somMD_SOMObject_somDispatchV				-1	5
SOMObject_somDispatchV					-1	5
va_SOMObject_somDispatchV				-1	5
va_somDispatchV 					-1	5
_somDispatchV						-1	5
somMD_SOMObject_somDispatchL				-1	5
SOMObject_somDispatchL					-1	5
va_SOMObject_somDispatchL				-1	5
va_somDispatchL 					-1	5
_somDispatchL						-1	5
somMD_SOMObject_somDispatchA				-1	5
SOMObject_somDispatchA					-1	5
va_SOMObject_somDispatchA				-1	5
va_somDispatchA 					-1	5
_somDispatchA						-1	5
somMD_SOMObject_somDispatchD				-1	5
SOMObject_somDispatchD					-1	5
va_SOMObject_somDispatchD				-1	5
va_somDispatchD 					-1	5
_somDispatchD						-1	5
somMD_SOMObject_somPrintSelf				-1	5
SOMObject_somPrintSelf					-1	5
_somPrintSelf						-1	5
somMD_SOMObject_somDumpSelf				-1	5
SOMObject_somDumpSelf					-1	5
_somDumpSelf						-1	5
somMD_SOMObject_somDumpSelfInt				-1	5
SOMObject_somDumpSelfInt				-1	5
_somDumpSelfInt 					-1	5
somtypes_h						-1	5
NULL							-1	5
SOMObject						-1	5
SOMClass						-1	5
SOMClassMgr						-1	5
SOM_DynamicMethod					-1	5
SOM_StaticMethod					-1	5
IN							-1	5
OUT							-1	5
INOUT							-1	5
FLOAT4							-1	5
FLOAT8							-1	5
SOMID							-1	5
SOMTOKEN						-1	5
SOMANY							-1	5
SOMCLASS						-1	5
SOMOBJECT						-1	5
SOMMETHODTAB						-1	5
SOMMETHODDATA						-1	5
SOMMETHODPTR						-1	5
SOMTRAITANY						-1	5
SOMCLASSDATASTRUCT					-1	5
wpabs_h 						-1	5
WPAbstract						-1	5
WPAbstract_MajorVersion 				-1	5
WPAbstract_MinorVersion 				-1	5
WPAbstractNewClass					-1	5
WPAbstractClassData					-1	5
WPAbstractCClassData					-1	5
WPAbstract_classObj					-1	5
_WPAbstract						-1	5
_WPAbstractNew						-1	5
WPAbstractNew						-1	5
WPAbstractRenew 					-1	5
WPAbstract_wpQueryHandle				-1	5
WPAbstract_wpSaveImmediate				-1	5
WPAbstract_wpSaveState					-1	5
WPAbstract_wpRestoreState				-1	5
WPAbstract_wpSetTitle					-1	5
WPAbstract_wpCopyObject 				-1	5
WPAbstract_wpMoveObject 				-1	5
WPAbstract_wpQueryIconData				-1	5
WPAbstract_wpSetIconData				-1	5
WPAbstract_wpDragOver					-1	5
WPAbstract_wpReplaceObject				-1	5
WPAbstract_wpQueryNameClashOptions			-1	5
wpabs_mh						-1	5
M_WPAbstract						-1	5
M_WPAbstract_MajorVersion				-1	5
M_WPAbstract_MinorVersion				-1	5
M_WPAbstractNewClass					-1	5
M_WPAbstractClassData					-1	5
M_WPAbstractCClassData					-1	5
M_WPAbstract_classObj					-1	5
_M_WPAbstract						-1	5
_M_WPAbstractNew					-1	5
M_WPAbstractNew 					-1	5
M_WPAbstractRenew					-1	5
M_WPAbstract_wpclsQueryTitle				-1	5
wpbitmap_h						-1	5
WPBitmap						-1	5
WPBitmap_MajorVersion					-1	5
WPBitmap_MinorVersion					-1	5
WPBitmapNewClass					-1	5
WPBitmapClassData					-1	5
WPBitmapCClassData					-1	5
WPBitmap_classObj					-1	5
_WPBitmap						-1	5
_WPBitmapNew						-1	5
WPBitmapNew						-1	5
WPBitmapRenew						-1	5
WPBitmap_wpSetup					-1	5
wpbitmap_mh						-1	5
M_WPBitmap						-1	5
M_WPBitmap_MajorVersion 				-1	5
M_WPBitmap_MinorVersion 				-1	5
M_WPBitmapNewClass					-1	5
M_WPBitmapClassData					-1	5
M_WPBitmapCClassData					-1	5
M_WPBitmap_classObj					-1	5
_M_WPBitmap						-1	5
_M_WPBitmapNew						-1	5
M_WPBitmapNew						-1	5
M_WPBitmapRenew 					-1	5
M_WPBitmap_wpclsQueryInstanceFilter			-1	5
M_WPBitmap_wpclsQueryInstanceType			-1	5
M_WPBitmap_wpclsInitData				-1	5
M_WPBitmap_wpclsQueryTitle				-1	5
M_WPBitmap_wpclsQueryDefaultHelp			-1	5
wpclock_h						-1	5
WPClock 						-1	5
WPClock_MajorVersion					-1	5
WPClock_MinorVersion					-1	5
WPClockNewClass 					-1	5
WPClockClassData					-1	5
WPClockCClassData					-1	5
WPClock_classObj					-1	5
_WPClock						-1	5
_WPClockNew						-1	5
WPClockNew						-1	5
WPClockRenew						-1	5
WPClock_wpAddSettingsPages				-1	5
WPClock_wpFilterPopupMenu				-1	5
WPClock_wpOpen						-1	5
WPClock_wpModifyPopupMenu				-1	5
WPClock_wpMenuItemSelected				-1	5
WPClock_wpSaveState					-1	5
WPClock_wpRestoreState					-1	5
WPClock_wpMenuItemHelpSelected				-1	5
WPClock_wpAddObjectWindowPage				-1	5
somMD_WPClock_wpAddClockView1Page			-1	5
WPClock_wpAddClockView1Page				-1	5
_wpAddClockView1Page					-1	5
somMD_WPClock_wpAddClockView2Page			-1	5
WPClock_wpAddClockView2Page				-1	5
_wpAddClockView2Page					-1	5
somMD_WPClock_wpAddClockDateTimePage			-1	5
WPClock_wpAddClockDateTimePage				-1	5
_wpAddClockDateTimePage 				-1	5
somMD_WPClock_wpAddClockAlarmPage			-1	5
WPClock_wpAddClockAlarmPage				-1	5
_wpAddClockAlarmPage					-1	5
wpclock_mh						-1	5
M_WPClock						-1	5
M_WPClock_MajorVersion					-1	5
M_WPClock_MinorVersion					-1	5
M_WPClockNewClass					-1	5
M_WPClockClassData					-1	5
M_WPClockCClassData					-1	5
M_WPClock_classObj					-1	5
_M_WPClock						-1	5
_M_WPClockNew						-1	5
M_WPClockNew						-1	5
M_WPClockRenew						-1	5
M_WPClock_wpclsQueryDefaultView 			-1	5
M_WPClock_wpclsQueryStyle				-1	5
M_WPClock_wpclsQueryDefaultHelp 			-1	5
M_WPClock_wpclsQueryTitle				-1	5
M_WPClock_wpclsQueryIconData				-1	5
wpclrpal_h						-1	5
WPColorPalette						-1	5
WPColorPalette_MajorVersion				-1	5
WPColorPalette_MinorVersion				-1	5
WPColorPaletteNewClass					-1	5
WPColorPaletteClassData 				-1	5
WPColorPaletteCClassData				-1	5
WPColorPalette_classObj 				-1	5
_WPColorPalette 					-1	5
_WPColorPaletteNew					-1	5
WPColorPaletteNew					-1	5
WPColorPaletteRenew					-1	5
WPColorPalette_wpPaintCell				-1	5
WPColorPalette_wpEditCell				-1	5
WPColorPalette_wpDragCell				-1	5
WPColorPalette_wpQueryPaletteHelp			-1	5
WPColorPalette_wpSetup					-1	5
WPColorPalette_wpMenuItemHelpSelected			-1	5
WPColorPalette_wpInitData				-1	5
wpclrpal_mh						-1	5
M_WPColorPalette					-1	5
M_WPColorPalette_MajorVersion				-1	5
M_WPColorPalette_MinorVersion				-1	5
M_WPColorPaletteNewClass				-1	5
M_WPColorPaletteClassData				-1	5
M_WPColorPaletteCClassData				-1	5
M_WPColorPalette_classObj				-1	5
_M_WPColorPalette					-1	5
_M_WPColorPaletteNew					-1	5
M_WPColorPaletteNew					-1	5
M_WPColorPaletteRenew					-1	5
M_WPColorPalette_wpclsQueryEditString			-1	5
M_WPColorPalette_wpclsQueryTitle			-1	5
M_WPColorPalette_wpclsQueryStyle			-1	5
M_WPColorPalette_wpclsQueryDefaultHelp			-1	5
M_WPColorPalette_wpclsQueryIconData			-1	5
wpclsmgr_h						-1	5
WPClassManager						-1	5
WPClassManager_MajorVersion				-1	5
WPClassManager_MinorVersion				-1	5
WPClassManagerNewClass					-1	5
WPClassManagerClassData 				-1	5
WPClassManagerCClassData				-1	5
WPClassManager_classObj 				-1	5
_WPClassManager 					-1	5
_WPClassManagerNew					-1	5
WPClassManagerNew					-1	5
WPClassManagerRenew					-1	5
WPClassManager_somInit					-1	5
WPClassManager_somFindClass				-1	5
WPClassManager_somFindClsInFile 			-1	5
WPClassManager_somLocateClassFile			-1	5
WPClassManager_somMergeInto				-1	5
WPClassManager_somUnregisterClass			-1	5
somMD_WPClassManager_wpGetTrueClassName 		-1	5
WPClassManager_wpGetTrueClassName			-1	5
_wpGetTrueClassName					-1	5
wpcmdf_h						-1	5
WPCommandFile						-1	5
WPCommandFile_MajorVersion				-1	5
WPCommandFile_MinorVersion				-1	5
WPCommandFileNewClass					-1	5
WPCommandFileClassData					-1	5
WPCommandFileCClassData 				-1	5
WPCommandFile_classObj					-1	5
_WPCommandFile						-1	5
_WPCommandFileNew					-1	5
WPCommandFileNew					-1	5
WPCommandFileRenew					-1	5
WPCommandFile_wpPrintObject				-1	5
wpcmdf_mh						-1	5
M_WPCommandFile 					-1	5
M_WPCommandFile_MajorVersion				-1	5
M_WPCommandFile_MinorVersion				-1	5
M_WPCommandFileNewClass 				-1	5
M_WPCommandFileClassData				-1	5
M_WPCommandFileCClassData				-1	5
M_WPCommandFile_classObj				-1	5
_M_WPCommandFile					-1	5
_M_WPCommandFileNew					-1	5
M_WPCommandFileNew					-1	5
M_WPCommandFileRenew					-1	5
M_WPCommandFile_wpclsQueryStyle 			-1	5
M_WPCommandFile_wpclsQueryInstanceFilter		-1	5
M_WPCommandFile_wpclsQueryInstanceType			-1	5
M_WPCommandFile_wpclsQueryTitle 			-1	5
wpctry_h						-1	5
WPCountry						-1	5
WPCountry_MajorVersion					-1	5
WPCountry_MinorVersion					-1	5
WPCountryNewClass					-1	5
WPCountryClassData					-1	5
WPCountryCClassData					-1	5
WPCountry_classObj					-1	5
_WPCountry						-1	5
_WPCountryNew						-1	5
WPCountryNew						-1	5
WPCountryRenew						-1	5
WPCountry_wpAddSettingsPages				-1	5
WPCountry_wpAddObjectWindowPage 			-1	5
WPCountry_wpFilterPopupMenu				-1	5
WPCountry_wpInitData					-1	5
somMD_WPCountry_wpAddCountryTimePage			-1	5
WPCountry_wpAddCountryTimePage				-1	5
_wpAddCountryTimePage					-1	5
somMD_WPCountry_wpAddCountryDatePage			-1	5
WPCountry_wpAddCountryDatePage				-1	5
_wpAddCountryDatePage					-1	5
somMD_WPCountry_wpAddCountryNumbersPage 		-1	5
WPCountry_wpAddCountryNumbersPage			-1	5
_wpAddCountryNumbersPage				-1	5
somMD_WPCountry_wpAddCountryPage			-1	5
WPCountry_wpAddCountryPage				-1	5
_wpAddCountryPage					-1	5
wpctry_mh						-1	5
M_WPCountry						-1	5
M_WPCountry_MajorVersion				-1	5
M_WPCountry_MinorVersion				-1	5
M_WPCountryNewClass					-1	5
M_WPCountryClassData					-1	5
M_WPCountryCClassData					-1	5
M_WPCountry_classObj					-1	5
_M_WPCountry						-1	5
_M_WPCountryNew 					-1	5
M_WPCountryNew						-1	5
M_WPCountryRenew					-1	5
M_WPCountry_wpclsQueryTitle				-1	5
M_WPCountry_wpclsQueryDefaultHelp			-1	5
M_WPCountry_wpclsQueryDefaultView			-1	5
M_WPCountry_wpclsQueryStyle				-1	5
M_WPCountry_wpclsQueryIconData				-1	5
wpdataf_h						-1	5
MAX_ASSOC_ITEMS 					-1	5
WPDataFile						-1	5
WPDataFile_MajorVersion 				-1	5
WPDataFile_MinorVersion 				-1	5
WPDataFileNewClass					-1	5
WPDataFileClassData					-1	5
WPDataFileCClassData					-1	5
WPDataFile_classObj					-1	5
_WPDataFile						-1	5
_WPDataFileNew						-1	5
WPDataFileNew						-1	5
WPDataFileRenew 					-1	5
WPDataFile_wpDragOver					-1	5
WPDataFile_wpRestoreState				-1	5
WPDataFile_wpSetDefaultView				-1	5
WPDataFile_wpSetRealName				-1	5
WPDataFile_wpSetType					-1	5
WPDataFile_wpUnInitData 				-1	5
WPDataFile_wpAddSettingsPages				-1	5
WPDataFile_wpAddObjectWindowPage			-1	5
WPDataFile_wpOpen					-1	5
WPDataFile_wpPrintObject				-1	5
WPDataFile_wpModifyPopupMenu				-1	5
WPDataFile_wpMenuItemSelected				-1	5
WPDataFile_wpMenuItemHelpSelected			-1	5
WPDataFile_wpQueryDefaultHelp				-1	5
WPDataFile_wpFormatDragItem				-1	5
WPDataFile_wpConfirmRenameFileWithExt			-1	5
somMD_WPDataFile_wpAddFileTypePage			-1	5
WPDataFile_wpAddFileTypePage				-1	5
_wpAddFileTypePage					-1	5
somMD_WPDataFile_wpPrintMetaFile			-1	5
WPDataFile_wpPrintMetaFile				-1	5
_wpPrintMetaFile					-1	5
somMD_WPDataFile_wpPrintPifFile 			-1	5
WPDataFile_wpPrintPifFile				-1	5
_wpPrintPifFile 					-1	5
somMD_WPDataFile_wpPrintPrinterSpecificFile		-1	5
WPDataFile_wpPrintPrinterSpecificFile			-1	5
_wpPrintPrinterSpecificFile				-1	5
somMD_WPDataFile_wpPrintUnknownFile			-1	5
WPDataFile_wpPrintUnknownFile				-1	5
_wpPrintUnknownFile					-1	5
somMD_WPDataFile_wpQueryAssociatedProgram		-1	5
WPDataFile_wpQueryAssociatedProgram			-1	5
_wpQueryAssociatedProgram				-1	5
somMD_WPDataFile_wpSetAssociatedFileIcon		-1	5
WPDataFile_wpSetAssociatedFileIcon			-1	5
_wpSetAssociatedFileIcon				-1	5
wpdataf_mh						-1	5
M_WPDataFile						-1	5
M_WPDataFile_MajorVersion				-1	5
M_WPDataFile_MinorVersion				-1	5
M_WPDataFileNewClass					-1	5
M_WPDataFileClassData					-1	5
M_WPDataFileCClassData					-1	5
M_WPDataFile_classObj					-1	5
_M_WPDataFile						-1	5
_M_WPDataFileNew					-1	5
M_WPDataFileNew 					-1	5
M_WPDataFileRenew					-1	5
M_WPDataFile_wpclsQueryTitle				-1	5
M_WPDataFile_wpclsQueryIconData 			-1	5
M_WPDataFile_wpclsQueryStyle				-1	5
M_WPDataFile_wpclsQueryDefaultView			-1	5
M_WPDataFile_wpclsQueryDefaultHelp			-1	5
wpdesk_h						-1	5
WPDesktop						-1	5
WPDesktop_MajorVersion					-1	5
WPDesktop_MinorVersion					-1	5
WPDesktopNewClass					-1	5
WPDesktopClassData					-1	5
WPDesktopCClassData					-1	5
WPDesktop_classObj					-1	5
_WPDesktop						-1	5
_WPDesktopNew						-1	5
WPDesktopNew						-1	5
WPDesktopRenew						-1	5
WPDesktop_wpInitData					-1	5
WPDesktop_wpSaveState					-1	5
WPDesktop_wpRestoreState				-1	5
WPDesktop_wpModifyPopupMenu				-1	5
WPDesktop_wpMenuItemSelected				-1	5
WPDesktop_wpFilterPopupMenu				-1	5
WPDesktop_wpAddSettingsPages				-1	5
somMD_WPDesktop_wpIsCurrentDesktop			-1	5
WPDesktop_wpIsCurrentDesktop				-1	5
_wpIsCurrentDesktop					-1	5
somMD_WPDesktop_wpAddDesktopLockup1Page 		-1	5
WPDesktop_wpAddDesktopLockup1Page			-1	5
_wpAddDesktopLockup1Page				-1	5
somMD_WPDesktop_wpAddDesktopLockup2Page 		-1	5
WPDesktop_wpAddDesktopLockup2Page			-1	5
_wpAddDesktopLockup2Page				-1	5
somMD_WPDesktop_wpAddDesktopLockup3Page 		-1	5
WPDesktop_wpAddDesktopLockup3Page			-1	5
_wpAddDesktopLockup3Page				-1	5
wpdesk_mh						-1	5
M_WPDesktop						-1	5
M_WPDesktop_MajorVersion				-1	5
M_WPDesktop_MinorVersion				-1	5
M_WPDesktopNewClass					-1	5
M_WPDesktopClassData					-1	5
M_WPDesktopCClassData					-1	5
M_WPDesktop_classObj					-1	5
_M_WPDesktop						-1	5
_M_WPDesktopNew 					-1	5
M_WPDesktopNew						-1	5
M_WPDesktopRenew					-1	5
M_WPDesktop_wpclsQueryDefaultView			-1	5
M_WPDesktop_wpclsQueryTitle				-1	5
M_WPDesktop_wpclsQueryIconData				-1	5
M_WPDesktop_wpclsQueryStyle				-1	5
M_WPDesktop_wpclsQueryDefaultHelp			-1	5
wpdisk_h						-1	5
WPRootFolder						-1	5
OPEN_AUTO						-1	5
WPDisk							-1	5
WPDisk_MajorVersion					-1	5
WPDisk_MinorVersion					-1	5
WPDiskNewClass						-1	5
WPDiskClassData 					-1	5
WPDiskCClassData					-1	5
WPDisk_classObj 					-1	5
_WPDisk 						-1	5
_WPDiskNew						-1	5
WPDiskNew						-1	5
WPDiskRenew						-1	5
WPDisk_wpSetup						-1	5
WPDisk_wpSaveState					-1	5
WPDisk_wpRestoreState					-1	5
WPDisk_wpAddSettingsPages				-1	5
WPDisk_wpFilterPopupMenu				-1	5
WPDisk_wpModifyPopupMenu				-1	5
WPDisk_wpMenuItemHelpSelected				-1	5
WPDisk_wpMenuItemSelected				-1	5
WPDisk_wpSetTitle					-1	5
WPDisk_wpOpen						-1	5
WPDisk_wpQueryDefaultHelp				-1	5
WPDisk_wpDragOver					-1	5
WPDisk_wpDrop						-1	5
WPDisk_wpQueryIconData					-1	5
WPDisk_wpSetIconData					-1	5
WPDisk_wpViewObject					-1	5
somMD_WPDisk_wpAddDiskDetailsPage			-1	5
WPDisk_wpAddDiskDetailsPage				-1	5
_wpAddDiskDetailsPage					-1	5
somMD_WPDisk_wpQueryDriveLockStatus			-1	5
WPDisk_wpQueryDriveLockStatus				-1	5
_wpQueryDriveLockStatus 				-1	5
somMD_WPDisk_wpEjectDisk				-1	5
WPDisk_wpEjectDisk					-1	5
_wpEjectDisk						-1	5
somMD_WPDisk_wpLockDrive				-1	5
WPDisk_wpLockDrive					-1	5
_wpLockDrive						-1	5
somMD_WPDisk_wpQueryLogicalDrive			-1	5
WPDisk_wpQueryLogicalDrive				-1	5
_wpQueryLogicalDrive					-1	5
somMD_WPDisk_wpQueryRootFolder				-1	5
WPDisk_wpQueryRootFolder				-1	5
_wpQueryRootFolder					-1	5
wpdisk_mh						-1	5
M_WPDisk						-1	5
M_WPDisk_MajorVersion					-1	5
M_WPDisk_MinorVersion					-1	5
M_WPDiskNewClass					-1	5
M_WPDiskClassData					-1	5
M_WPDiskCClassData					-1	5
M_WPDisk_classObj					-1	5
_M_WPDisk						-1	5
_M_WPDiskNew						-1	5
M_WPDiskNew						-1	5
M_WPDiskRenew						-1	5
M_WPDisk_wpclsQueryDefaultHelp				-1	5
M_WPDisk_wpclsQueryIconData				-1	5
M_WPDisk_wpclsQueryStyle				-1	5
M_WPDisk_wpclsQueryTitle				-1	5
M_WPDisk_wpclsQueryDefaultView				-1	5
wpdrives_h						-1	5
WPDrives						-1	5
WPDrives_MajorVersion					-1	5
WPDrives_MinorVersion					-1	5
WPDrivesNewClass					-1	5
WPDrivesClassData					-1	5
WPDrivesCClassData					-1	5
WPDrives_classObj					-1	5
_WPDrives						-1	5
_WPDrivesNew						-1	5
WPDrivesNew						-1	5
WPDrivesRenew						-1	5
WPDrives_wpMenuItemSelected				-1	5
WPDrives_wpModifyPopupMenu				-1	5
WPDrives_wpMenuItemHelpSelected 			-1	5
WPDrives_wpFilterPopupMenu				-1	5
WPDrives_wpPopulate					-1	5
wpdrives_mh						-1	5
M_WPDrives						-1	5
M_WPDrives_MajorVersion 				-1	5
M_WPDrives_MinorVersion 				-1	5
M_WPDrivesNewClass					-1	5
M_WPDrivesClassData					-1	5
M_WPDrivesCClassData					-1	5
M_WPDrives_classObj					-1	5
_M_WPDrives						-1	5
_M_WPDrivesNew						-1	5
M_WPDrivesNew						-1	5
M_WPDrivesRenew 					-1	5
M_WPDrives_wpclsQueryTitle				-1	5
M_WPDrives_wpclsQueryIconData				-1	5
M_WPDrives_wpclsQueryStyle				-1	5
M_WPDrives_wpclsQueryDefaultHelp			-1	5
wpfntpal_h						-1	5
WPFontPalette						-1	5
CCHFONTNAME						-1	5
WPFontPalette_MajorVersion				-1	5
WPFontPalette_MinorVersion				-1	5
WPFontPaletteNewClass					-1	5
WPFontPaletteClassData					-1	5
WPFontPaletteCClassData 				-1	5
WPFontPalette_classObj					-1	5
_WPFontPalette						-1	5
_WPFontPaletteNew					-1	5
WPFontPaletteNew					-1	5
WPFontPaletteRenew					-1	5
WPFontPalette_wpPaintCell				-1	5
WPFontPalette_wpEditCell				-1	5
WPFontPalette_wpSetupCell				-1	5
WPFontPalette_wpDragCell				-1	5
WPFontPalette_wpQueryPaletteHelp			-1	5
WPFontPalette_wpSetup					-1	5
WPFontPalette_wpMenuItemHelpSelected			-1	5
wpfntpal_mh						-1	5
M_WPFontPalette 					-1	5
M_WPFontPalette_MajorVersion				-1	5
M_WPFontPalette_MinorVersion				-1	5
M_WPFontPaletteNewClass 				-1	5
M_WPFontPaletteClassData				-1	5
M_WPFontPaletteCClassData				-1	5
M_WPFontPalette_classObj				-1	5
_M_WPFontPalette					-1	5
_M_WPFontPaletteNew					-1	5
M_WPFontPaletteNew					-1	5
M_WPFontPaletteRenew					-1	5
M_WPFontPalette_wpclsQueryEditString			-1	5
M_WPFontPalette_wpclsQueryTitle 			-1	5
M_WPFontPalette_wpclsQueryIconData			-1	5
M_WPFontPalette_wpclsQueryStyle 			-1	5
M_WPFontPalette_wpclsQueryDefaultHelp			-1	5
wpfolder_h						-1	5
WPFolder						-1	5
FOI_POPULATEDWITHALL					-1	5
FOI_POPULATEDWITHFOLDERS				-1	5
FOI_WORKAREA						-1	5
FOI_CHANGEFONT						-1	5
FOI_WAMINIMIZED 					-1	5
FOI_WASTARTONRESTORE					-1	5
FOI_NOREFRESHVIEWS					-1	5
FOI_ASYNCREFRESHONOPEN					-1	5
FOI_TREEPOPULATED					-1	5
FOI_POPULATEINPROGRESS					-1	5
FOI_REFRESHINPROGRESS					-1	5
FOI_FIRSTPOPULATE					-1	5
FOI_WAMCRINPROGRESS					-1	5
OPEN_TREE						-1	5
OPEN_DETAILS						-1	5
IDKEY_FDRCONTENTATTR					-1	5
IDKEY_FDRTREEATTR					-1	5
IDKEY_FDRCVLFONT					-1	5
IDKEY_FDRCVNFONT					-1	5
IDKEY_FDRCVIFONT					-1	5
IDKEY_FDRTVLFONT					-1	5
IDKEY_FDRTVNFONT					-1	5
IDKEY_FDRDETAILSATTR					-1	5
IDKEY_FDRDVFONT 					-1	5
IDKEY_FDRDETAILSCLASS					-1	5
IDKEY_FDRICONPOS					-1	5
IDKEY_FDRINVISCOLUMNS					-1	5
IDKEY_FDRINCCLASS					-1	5
IDKEY_FDRINCNAME					-1	5
IDKEY_FDRFSYSSEARCHINFO 				-1	5
IDKEY_FILTERCONTENT					-1	5
IDKEY_CNRBACKGROUND					-1	5
IDKEY_FDRINCCRITERIA					-1	5
IDKEY_FDRICONVIEWPOS					-1	5
IDKEY_FDRSORTCLASS					-1	5
IDKEY_FDRSORTATTRIBS					-1	5
IDKEY_FDRSORTINFO					-1	5
IDKEY_FDRSNEAKYCOUNT					-1	5
IDKEY_FDRLONGARRAY					-1	5
IDKEY_FDRSTRARRAY					-1	5
PPFONTSTRSIZE						-1	5
ICONPOSSIZE						-1	5
PARTIAL_FILLFOLDER_SEM_TIMEOUT				-1	5
GETATTR 						-1	5
FOLDER_DEFATTRS 					-1	5
FOLDER_DEFTREEATTRS					-1	5
FOLDER_DEFDETAILS					-1	5
FOLDER_DEFSORT						-1	5
WPFolder_MajorVersion					-1	5
WPFolder_MinorVersion					-1	5
WPFolderNewClass					-1	5
WPFolderClassData					-1	5
WPFolderCClassData					-1	5
WPFolder_classObj					-1	5
_WPFolder						-1	5
_WPFolderNew						-1	5
WPFolderNew						-1	5
WPFolderRenew						-1	5
WPFolder_wpInitData					-1	5
WPFolder_wpUnInitData					-1	5
WPFolder_wpFree 					-1	5
WPFolder_wpDelete					-1	5
WPFolder_wpConfirmDelete				-1	5
WPFolder_wpSaveState					-1	5
WPFolder_wpRestoreState 				-1	5
WPFolder_wpMenuItemSelected				-1	5
WPFolder_wpModifyPopupMenu				-1	5
WPFolder_wpAddSettingsPages				-1	5
WPFolder_wpOpen 					-1	5
WPFolder_wpSetup					-1	5
WPFolder_wpMoveObject					-1	5
WPFolder_wpDrop 					-1	5
WPFolder_wpDragOver					-1	5
WPFolder_wpMenuItemHelpSelected 			-1	5
WPFolder_wpAddFile3Page 				-1	5
WPFolder_wpAddFile2Page 				-1	5
WPFolder_wpFormatDragItem				-1	5
WPFolder_wpRender					-1	5
WPFolder_wpRefresh					-1	5
WPFolder_wpFilterPopupMenu				-1	5
WPFolder_wpQueryDefaultView				-1	5
WPFolder_wpRenderComplete				-1	5
WPFolder_wpQueryDefaultHelp				-1	5
somMD_WPFolder_wpSetFldrFlags				-1	5
WPFolder_wpSetFldrFlags 				-1	5
_wpSetFldrFlags 					-1	5
somMD_WPFolder_wpQueryFldrFlags 			-1	5
WPFolder_wpQueryFldrFlags				-1	5
_wpQueryFldrFlags					-1	5
somMD_WPFolder_wpSetFldrFont				-1	5
WPFolder_wpSetFldrFont					-1	5
_wpSetFldrFont						-1	5
somMD_WPFolder_wpQueryFldrFont				-1	5
WPFolder_wpQueryFldrFont				-1	5
_wpQueryFldrFont					-1	5
somMD_WPFolder_wpSetFldrAttr				-1	5
WPFolder_wpSetFldrAttr					-1	5
_wpSetFldrAttr						-1	5
somMD_WPFolder_wpQueryFldrAttr				-1	5
WPFolder_wpQueryFldrAttr				-1	5
_wpQueryFldrAttr					-1	5
somMD_WPFolder_wpSetNextIconPos 			-1	5
WPFolder_wpSetNextIconPos				-1	5
_wpSetNextIconPos					-1	5
somMD_WPFolder_wpQueryNextIconPos			-1	5
WPFolder_wpQueryNextIconPos				-1	5
_wpQueryNextIconPos					-1	5
somMD_WPFolder_wpPopulate				-1	5
WPFolder_wpPopulate					-1	5
_wpPopulate						-1	5
somMD_WPFolder_wpQueryContent				-1	5
WPFolder_wpQueryContent 				-1	5
_wpQueryContent 					-1	5
somMD_WPFolder_wpAddFolderView1Page			-1	5
WPFolder_wpAddFolderView1Page				-1	5
_wpAddFolderView1Page					-1	5
somMD_WPFolder_wpAddFolderView2Page			-1	5
WPFolder_wpAddFolderView2Page				-1	5
_wpAddFolderView2Page					-1	5
somMD_WPFolder_wpAddFolderView3Page			-1	5
WPFolder_wpAddFolderView3Page				-1	5
_wpAddFolderView3Page					-1	5
somMD_WPFolder_wpAddFolderIncludePage			-1	5
WPFolder_wpAddFolderIncludePage 			-1	5
_wpAddFolderIncludePage 				-1	5
somMD_WPFolder_wpAddFolderSortPage			-1	5
WPFolder_wpAddFolderSortPage				-1	5
_wpAddFolderSortPage					-1	5
somMD_WPFolder_wpAddFolderBackgroundPage		-1	5
WPFolder_wpAddFolderBackgroundPage			-1	5
_wpAddFolderBackgroundPage				-1	5
somMD_WPFolder_wpInitIconPosData			-1	5
WPFolder_wpInitIconPosData				-1	5
_wpInitIconPosData					-1	5
somMD_WPFolder_wpFreeIconPosData			-1	5
WPFolder_wpFreeIconPosData				-1	5
_wpFreeIconPosData					-1	5
somMD_WPFolder_wpStoreIconPosData			-1	5
WPFolder_wpStoreIconPosData				-1	5
_wpStoreIconPosData					-1	5
somMD_WPFolder_wpQueryIconPosition			-1	5
WPFolder_wpQueryIconPosition				-1	5
_wpQueryIconPosition					-1	5
somMD_WPFolder_wpSetFldrSort				-1	5
WPFolder_wpSetFldrSort					-1	5
_wpSetFldrSort						-1	5
somMD_WPFolder_wpQueryFldrSort				-1	5
WPFolder_wpQueryFldrSort				-1	5
_wpQueryFldrSort					-1	5
somMD_WPFolder_wpRestoreFldrRunObjs			-1	5
WPFolder_wpRestoreFldrRunObjs				-1	5
_wpRestoreFldrRunObjs					-1	5
somMD_WPFolder_wpStoreFldrRunObjs			-1	5
WPFolder_wpStoreFldrRunObjs				-1	5
_wpStoreFldrRunObjs					-1	5
somMD_WPFolder_wpHideFldrRunObjs			-1	5
WPFolder_wpHideFldrRunObjs				-1	5
_wpHideFldrRunObjs					-1	5
somMD_WPFolder_wpDeleteContents 			-1	5
WPFolder_wpDeleteContents				-1	5
_wpDeleteContents					-1	5
somMD_WPFolder_wpSetFldrDetailsClass			-1	5
WPFolder_wpSetFldrDetailsClass				-1	5
_wpSetFldrDetailsClass					-1	5
somMD_WPFolder_wpQueryFldrDetailsClass			-1	5
WPFolder_wpQueryFldrDetailsClass			-1	5
_wpQueryFldrDetailsClass				-1	5
somMD_WPFolder_wpSearchFolder				-1	5
WPFolder_wpSearchFolder 				-1	5
_wpSearchFolder 					-1	5
somMD_WPFolder_wpContainsFolders			-1	5
WPFolder_wpContainsFolders				-1	5
_wpContainsFolders					-1	5
somMD_WPFolder_wpQueryOpenFolders			-1	5
WPFolder_wpQueryOpenFolders				-1	5
_wpQueryOpenFolders					-1	5
wpfolder_mh						-1	5
M_WPFolder						-1	5
M_WPFolder_MajorVersion 				-1	5
M_WPFolder_MinorVersion 				-1	5
M_WPFolderNewClass					-1	5
M_WPFolderClassData					-1	5
M_WPFolderCClassData					-1	5
M_WPFolder_classObj					-1	5
_M_WPFolder						-1	5
_M_WPFolderNew						-1	5
M_WPFolderNew						-1	5
M_WPFolderRenew 					-1	5
M_WPFolder_wpclsInitData				-1	5
M_WPFolder_wpclsQueryDefaultView			-1	5
M_WPFolder_wpclsQueryTitle				-1	5
M_WPFolder_wpclsQueryIconData				-1	5
M_WPFolder_wpclsQueryStyle				-1	5
M_WPFolder_wpclsQueryDefaultHelp			-1	5
somMD_M_WPFolder_wpclsQueryOpenFolders			-1	5
M_WPFolder_wpclsQueryOpenFolders			-1	5
_wpclsQueryOpenFolders					-1	5
wpfsys_h						-1	5
WPFileSystem						-1	5
NUM_FILEDETAILS_FIELDS					-1	5
ALIGN4							-1	5
KEEP_RENAMEFILESWITHEXT 				-1	5
DISCARD_RENAMEFILESWITHEXT				-1	5
CANCEL_RENAMEFILESWITHEXT				-1	5
WPFileSystem_MajorVersion				-1	5
WPFileSystem_MinorVersion				-1	5
WPFileSystemNewClass					-1	5
WPFileSystemClassData					-1	5
WPFileSystemCClassData					-1	5
WPFileSystem_classObj					-1	5
_WPFileSystem						-1	5
_WPFileSystemNew					-1	5
WPFileSystemNew 					-1	5
WPFileSystemRenew					-1	5
WPFileSystem_wpUnInitData				-1	5
WPFileSystem_wpQueryHandle				-1	5
WPFileSystem_wpSaveImmediate				-1	5
WPFileSystem_wpFilterPopupMenu				-1	5
WPFileSystem_wpSetTitle 				-1	5
WPFileSystem_wpViewObject				-1	5
WPFileSystem_wpSwitchTo 				-1	5
WPFileSystem_wpAddSettingsPages 			-1	5
WPFileSystem_wpCopyObject				-1	5
WPFileSystem_wpCreateFromTemplate			-1	5
WPFileSystem_wpMoveObject				-1	5
WPFileSystem_wpQueryIconData				-1	5
WPFileSystem_wpSetIconData				-1	5
WPFileSystem_wpQueryDetailsData 			-1	5
WPFileSystem_wpModifyPopupMenu				-1	5
WPFileSystem_wpSaveState				-1	5
WPFileSystem_wpRestoreState				-1	5
WPFileSystem_wpMenuItemSelected 			-1	5
WPFileSystem_wpOpen					-1	5
WPFileSystem_wpDraggedOverObject			-1	5
WPFileSystem_wpDroppedOnObject				-1	5
WPFileSystem_wpFormatDragItem				-1	5
WPFileSystem_wpQueryNameClashOptions			-1	5
WPFileSystem_wpAppendObject				-1	5
WPFileSystem_wpReplaceObject				-1	5
WPFileSystem_wpQueryStyle				-1	5
WPFileSystem_wpSetStyle 				-1	5
WPFileSystem_wpDoesObjectMatch				-1	5
somMD_WPFileSystem_wpSetRealName			-1	5
WPFileSystem_wpSetRealName				-1	5
_wpSetRealName						-1	5
somMD_WPFileSystem_wpSetType				-1	5
WPFileSystem_wpSetType					-1	5
_wpSetType						-1	5
somMD_WPFileSystem_wpQueryType				-1	5
WPFileSystem_wpQueryType				-1	5
_wpQueryType						-1	5
somMD_WPFileSystem_wpSetAttr				-1	5
WPFileSystem_wpSetAttr					-1	5
_wpSetAttr						-1	5
somMD_WPFileSystem_wpQueryAttr				-1	5
WPFileSystem_wpQueryAttr				-1	5
_wpQueryAttr						-1	5
somMD_WPFileSystem_wpAddFile1Page			-1	5
WPFileSystem_wpAddFile1Page				-1	5
_wpAddFile1Page 					-1	5
somMD_WPFileSystem_wpAddFile2Page			-1	5
WPFileSystem_wpAddFile2Page				-1	5
_wpAddFile2Page 					-1	5
somMD_WPFileSystem_wpAddFile3Page			-1	5
WPFileSystem_wpAddFile3Page				-1	5
_wpAddFile3Page 					-1	5
somMD_WPFileSystem_wpAddFileMenuPage			-1	5
WPFileSystem_wpAddFileMenuPage				-1	5
_wpAddFileMenuPage					-1	5
somMD_WPFileSystem_wpQueryCreation			-1	5
WPFileSystem_wpQueryCreation				-1	5
_wpQueryCreation					-1	5
somMD_WPFileSystem_wpQueryLastAccess			-1	5
WPFileSystem_wpQueryLastAccess				-1	5
_wpQueryLastAccess					-1	5
somMD_WPFileSystem_wpQueryLastWrite			-1	5
WPFileSystem_wpQueryLastWrite				-1	5
_wpQueryLastWrite					-1	5
somMD_WPFileSystem_wpQueryFileSize			-1	5
WPFileSystem_wpQueryFileSize				-1	5
_wpQueryFileSize					-1	5
somMD_WPFileSystem_wpQueryEASize			-1	5
WPFileSystem_wpQueryEASize				-1	5
_wpQueryEASize						-1	5
somMD_WPFileSystem_wpSetDateInfo			-1	5
WPFileSystem_wpSetDateInfo				-1	5
_wpSetDateInfo						-1	5
somMD_WPFileSystem_wpSetFileSizeInfo			-1	5
WPFileSystem_wpSetFileSizeInfo				-1	5
_wpSetFileSizeInfo					-1	5
somMD_WPFileSystem_wpRefresh				-1	5
WPFileSystem_wpRefresh					-1	5
_wpRefresh						-1	5
somMD_WPFileSystem_wpQueryRefreshFlags			-1	5
WPFileSystem_wpQueryRefreshFlags			-1	5
_wpQueryRefreshFlags					-1	5
somMD_WPFileSystem_wpSetRefreshFlags			-1	5
WPFileSystem_wpSetRefreshFlags				-1	5
_wpSetRefreshFlags					-1	5
somMD_WPFileSystem_wpPrintPlainTextFile 		-1	5
WPFileSystem_wpPrintPlainTextFile			-1	5
_wpPrintPlainTextFile					-1	5
somMD_WPFileSystem_wpSetTitleAndRenameFile		-1	5
WPFileSystem_wpSetTitleAndRenameFile			-1	5
_wpSetTitleAndRenameFile				-1	5
somMD_WPFileSystem_wpConfirmRenameFileWithExt		-1	5
WPFileSystem_wpConfirmRenameFileWithExt 		-1	5
_wpConfirmRenameFileWithExt				-1	5
somMD_WPFileSystem_wpVerifyUpdateAccess 		-1	5
WPFileSystem_wpVerifyUpdateAccess			-1	5
_wpVerifyUpdateAccess					-1	5
somMD_WPFileSystem_wpAddUserItemsToPopupMenu		-1	5
WPFileSystem_wpAddUserItemsToPopupMenu			-1	5
_wpAddUserItemsToPopupMenu				-1	5
somMD_WPFileSystem_wpQueryRealName			-1	5
WPFileSystem_wpQueryRealName				-1	5
_wpQueryRealName					-1	5
wpfsys_mh						-1	5
M_WPFileSystem						-1	5
M_WPFileSystem_MajorVersion				-1	5
M_WPFileSystem_MinorVersion				-1	5
M_WPFileSystemNewClass					-1	5
M_WPFileSystemClassData 				-1	5
M_WPFileSystemCClassData				-1	5
M_WPFileSystem_classObj 				-1	5
_M_WPFileSystem 					-1	5
_M_WPFileSystemNew					-1	5
M_WPFileSystemNew					-1	5
M_WPFileSystemRenew					-1	5
M_WPFileSystem_wpclsInitData				-1	5
M_WPFileSystem_wpclsQueryTitle				-1	5
M_WPFileSystem_wpclsQueryDetailsInfo			-1	5
M_WPFileSystem_wpclsQuerySearchInfo			-1	5
M_WPFileSystem_wpclsQueryExtendedCriteria		-1	5
somMD_M_WPFileSystem_wpclsQueryObjectFromPath		-1	5
M_WPFileSystem_wpclsQueryObjectFromPath 		-1	5
_wpclsQueryObjectFromPath				-1	5
somMD_M_WPFileSystem_wpclsQueryInstanceType		-1	5
M_WPFileSystem_wpclsQueryInstanceType			-1	5
_wpclsQueryInstanceType 				-1	5
somMD_M_WPFileSystem_wpclsQueryInstanceFilter		-1	5
M_WPFileSystem_wpclsQueryInstanceFilter 		-1	5
_wpclsQueryInstanceFilter				-1	5
wpicon_h						-1	5
WPIcon							-1	5
WPIcon_MajorVersion					-1	5
WPIcon_MinorVersion					-1	5
WPIconNewClass						-1	5
WPIconClassData 					-1	5
WPIconCClassData					-1	5
WPIcon_classObj 					-1	5
_WPIcon 						-1	5
_WPIconNew						-1	5
WPIconNew						-1	5
WPIconRenew						-1	5
WPIcon_wpSetup						-1	5
wpicon_mh						-1	5
M_WPIcon						-1	5
M_WPIcon_MajorVersion					-1	5
M_WPIcon_MinorVersion					-1	5
M_WPIconNewClass					-1	5
M_WPIconClassData					-1	5
M_WPIconCClassData					-1	5
M_WPIcon_classObj					-1	5
_M_WPIcon						-1	5
_M_WPIconNew						-1	5
M_WPIconNew						-1	5
M_WPIconRenew						-1	5
M_WPIcon_wpclsQueryInstanceFilter			-1	5
M_WPIcon_wpclsQueryInstanceType 			-1	5
M_WPIcon_wpclsInitData					-1	5
M_WPIcon_wpclsQueryTitle				-1	5
M_WPIcon_wpclsQueryDefaultHelp				-1	5
wpjob_h 						-1	5
WPJob							-1	5
WPJob_MajorVersion					-1	5
WPJob_MinorVersion					-1	5
WPJobNewClass						-1	5
WPJobClassData						-1	5
WPJobCClassData 					-1	5
WPJob_classObj						-1	5
_WPJob							-1	5
_WPJobNew						-1	5
WPJobNew						-1	5
WPJobRenew						-1	5
WPJob_wpInitData					-1	5
WPJob_wpUnInitData					-1	5
WPJob_somDumpSelfInt					-1	5
WPJob_wpAddSettingsPages				-1	5
WPJob_wpAddObjectGeneralPage				-1	5
WPJob_wpQueryTitle					-1	5
WPJob_wpQueryIcon					-1	5
WPJob_wpFilterPopupMenu 				-1	5
WPJob_wpFree						-1	5
WPJob_wpModifyPopupMenu 				-1	5
WPJob_wpMenuItemSelected				-1	5
WPJob_wpMenuItemHelpSelected				-1	5
WPJob_wpOpen						-1	5
WPJob_wpDrop						-1	5
WPJob_wpDragOver					-1	5
WPJob_wpQueryDetailsData				-1	5
WPJob_wpSetTitle					-1	5
somMD_WPJob_wpDeleteJob 				-1	5
WPJob_wpDeleteJob					-1	5
_wpDeleteJob						-1	5
somMD_WPJob_wpHoldJob					-1	5
WPJob_wpHoldJob 					-1	5
_wpHoldJob						-1	5
somMD_WPJob_wpReleaseJob				-1	5
WPJob_wpReleaseJob					-1	5
_wpReleaseJob						-1	5
somMD_WPJob_wpPrintJobNext				-1	5
WPJob_wpPrintJobNext					-1	5
_wpPrintJobNext 					-1	5
somMD_WPJob_wpStartJobAgain				-1	5
WPJob_wpStartJobAgain					-1	5
_wpStartJobAgain					-1	5
wpjob_mh						-1	5
M_WPJob 						-1	5
M_WPJob_MajorVersion					-1	5
M_WPJob_MinorVersion					-1	5
M_WPJobNewClass 					-1	5
M_WPJobClassData					-1	5
M_WPJobCClassData					-1	5
M_WPJob_classObj					-1	5
_M_WPJob						-1	5
_M_WPJobNew						-1	5
M_WPJobNew						-1	5
M_WPJobRenew						-1	5
M_WPJob_wpclsQueryTitle 				-1	5
M_WPJob_wpclsQueryIcon					-1	5
M_WPJob_wpclsQueryDefaultHelp				-1	5
M_WPJob_wpclsQueryDefaultView				-1	5
M_WPJob_wpclsQueryDetailsInfo				-1	5
M_WPJob_wpclsQueryStyle 				-1	5
wpkeybd_h						-1	5
WPKeyboard						-1	5
WPKeyboard_MajorVersion 				-1	5
WPKeyboard_MinorVersion 				-1	5
WPKeyboardNewClass					-1	5
WPKeyboardClassData					-1	5
WPKeyboardCClassData					-1	5
WPKeyboard_classObj					-1	5
_WPKeyboard						-1	5
_WPKeyboardNew						-1	5
WPKeyboardNew						-1	5
WPKeyboardRenew 					-1	5
WPKeyboard_wpAddSettingsPages				-1	5
WPKeyboard_wpAddObjectWindowPage			-1	5
WPKeyboard_wpFilterPopupMenu				-1	5
somMD_WPKeyboard_wpAddKeyboardMappingsPage		-1	5
WPKeyboard_wpAddKeyboardMappingsPage			-1	5
_wpAddKeyboardMappingsPage				-1	5
somMD_WPKeyboard_wpAddKeyboardTimingPage		-1	5
WPKeyboard_wpAddKeyboardTimingPage			-1	5
_wpAddKeyboardTimingPage				-1	5
somMD_WPKeyboard_wpAddKeyboardSpecialNeedsPage		-1	5
WPKeyboard_wpAddKeyboardSpecialNeedsPage		-1	5
_wpAddKeyboardSpecialNeedsPage				-1	5
wpkeybd_mh						-1	5
M_WPKeyboard						-1	5
M_WPKeyboard_MajorVersion				-1	5
M_WPKeyboard_MinorVersion				-1	5
M_WPKeyboardNewClass					-1	5
M_WPKeyboardClassData					-1	5
M_WPKeyboardCClassData					-1	5
M_WPKeyboard_classObj					-1	5
_M_WPKeyboard						-1	5
_M_WPKeyboardNew					-1	5
M_WPKeyboardNew 					-1	5
M_WPKeyboardRenew					-1	5
M_WPKeyboard_wpclsQueryTitle				-1	5
M_WPKeyboard_wpclsQueryDefaultHelp			-1	5
M_WPKeyboard_wpclsQueryDefaultView			-1	5
M_WPKeyboard_wpclsQueryStyle				-1	5
M_WPKeyboard_wpclsQueryIconData 			-1	5
wpmouse_h						-1	5
WPMouse 						-1	5
WPMouse_MajorVersion					-1	5
WPMouse_MinorVersion					-1	5
WPMouseNewClass 					-1	5
WPMouseClassData					-1	5
WPMouseCClassData					-1	5
WPMouse_classObj					-1	5
_WPMouse						-1	5
_WPMouseNew						-1	5
WPMouseNew						-1	5
WPMouseRenew						-1	5
WPMouse_wpAddSettingsPages				-1	5
WPMouse_wpAddObjectWindowPage				-1	5
WPMouse_wpFilterPopupMenu				-1	5
somMD_WPMouse_wpAddMouseMappingsPage			-1	5
WPMouse_wpAddMouseMappingsPage				-1	5
_wpAddMouseMappingsPage 				-1	5
somMD_WPMouse_wpAddMouseTimingPage			-1	5
WPMouse_wpAddMouseTimingPage				-1	5
_wpAddMouseTimingPage					-1	5
somMD_WPMouse_wpAddMouseTypePage			-1	5
WPMouse_wpAddMouseTypePage				-1	5
_wpAddMouseTypePage					-1	5
wpmouse_mh						-1	5
M_WPMouse						-1	5
M_WPMouse_MajorVersion					-1	5
M_WPMouse_MinorVersion					-1	5
M_WPMouseNewClass					-1	5
M_WPMouseClassData					-1	5
M_WPMouseCClassData					-1	5
M_WPMouse_classObj					-1	5
_M_WPMouse						-1	5
_M_WPMouseNew						-1	5
M_WPMouseNew						-1	5
M_WPMouseRenew						-1	5
M_WPMouse_wpclsQueryTitle				-1	5
M_WPMouse_wpclsQueryDefaultHelp 			-1	5
M_WPMouse_wpclsQueryDefaultView 			-1	5
M_WPMouse_wpclsQueryStyle				-1	5
M_WPMouse_wpclsQueryIconData				-1	5
wpobject_h						-1	5
INCL_WINSTDCNR						-1	5
M_WPObject						-1	5
WPObject						-1	5
OBJSTYLE_NOMOVE 					-1	5
OBJSTYLE_NOLINK 					-1	5
OBJSTYLE_NOCOPY 					-1	5
OBJSTYLE_NOTDEFAULTICON 				-1	5
OBJSTYLE_TEMPLATE					-1	5
OBJSTYLE_NODELETE					-1	5
OBJSTYLE_NOPRINT					-1	5
OBJSTYLE_NODRAG 					-1	5
OBJSTYLE_NOTVISIBLE					-1	5
OBJSTYLE_NOSETTINGS					-1	5
OBJSTYLE_NORENAME					-1	5
OBJSTYLE_NODROP 					-1	5
CLSSTYLE_NEVERMOVE					-1	5
CLSSTYLE_NEVERLINK					-1	5
CLSSTYLE_NEVERCOPY					-1	5
CLSSTYLE_NEVERTEMPLATE					-1	5
CLSSTYLE_NEVERDELETE					-1	5
CLSSTYLE_NEVERPRINT					-1	5
CLSSTYLE_NEVERDRAG					-1	5
CLSSTYLE_NEVERVISIBLE					-1	5
CLSSTYLE_NEVERRENAME					-1	5
CLSSTYLE_PRIVATE					-1	5
CTXT_CRANOTHER						-1	5
CTXT_NEW						-1	5
CTXT_OPEN						-1	5
CTXT_WINDOW						-1	5
CTXT_SWITCHTO						-1	5
CTXT_CLOSE						-1	5
CTXT_SETTINGS						-1	5
CTXT_PRINT						-1	5
CTXT_HELP						-1	5
CTXT_DELETE						-1	5
CTXT_COPY						-1	5
CTXT_MOVE						-1	5
CTXT_SHADOW						-1	5
CTXT_LINK						-1	5
CTXT_PROGRAM						-1	5
CTXT_ICON						-1	5
CTXT_TREE						-1	5
CTXT_DETAILS						-1	5
CTXT_FIND						-1	5
CTXT_SELECT						-1	5
CTXT_ARRANGE						-1	5
CTXT_SORT						-1	5
CTXT_SHUTDOWN						-1	5
CTXT_LOCKUP						-1	5
CTXT_PALETTE						-1	5
CTXT_REFRESH						-1	5
WPMENUID_USER						-1	5
WPMENUID_PRIMARY					-1	5
WPMENUID_OPEN						-1	5
WPMENUID_HELP						-1	5
WPMENUID_PRINT						-1	5
WPMENUID_SELECT 					-1	5
WPMENUID_SORT						-1	5
OPEN_UNKNOWN						-1	5
OPEN_DEFAULT						-1	5
OPEN_CONTENTS						-1	5
OPEN_SETTINGS						-1	5
OPEN_HELP						-1	5
OPEN_RUNNING						-1	5
OPEN_PROMPTDLG						-1	5
OPEN_PALETTE						-1	5
OPEN_USER						-1	5
USAGE_MEMORY						-1	5
USAGE_RECORD						-1	5
USAGE_OPENVIEW						-1	5
USAGE_LINK						-1	5
USAGE_OPENFILE						-1	5
VIEWSTATE_OPENING					-1	5
VIEWSTATE_OBJECTDELETED 				-1	5
VIEWSTATE_USERHIDDEN					-1	5
VIEWSTATE_POPULATING					-1	5
OBJECT_FROM_PREC					-1	5
USERWORD_FROM_PREC					-1	5
CMP_EQUAL						-1	5
CMP_GREATER						-1	5
CMP_LESS						-1	5
CMP_GREATER_OR_EQUAL					-1	5
CMP_LESS_OR_EQUAL					-1	5
CMP_NOT_EQUAL						-1	5
NUM_CMP_VALUES						-1	5
CRITERIA_AND						-1	5
CRITERIA_OR						-1	5
COMPARE_SUPPORTED					-1	5
SORTBY_SUPPORTED					-1	5
STDNOTEBOOKWIDTH					-1	5
STDNOTEBOOKHEIGHT					-1	5
CONFIRM_DELETE						-1	5
CONFIRM_DELETEFOLDER					-1	5
CONFIRM_RENAMEFILESWITHEXT				-1	5
CONFIRM_KEEPASSOC					-1	5
CONFIRM_ACTION						-1	5
CONFIRM_PROGRESS					-1	5
OK_DELETE						-1	5
NO_DELETE						-1	5
CANCEL_DELETE						-1	5
NUM_OBJDETAILS_FIELDS					-1	5
SEARCH_ALL_FOLDERS					-1	5
SEARCH_THIS_FOLDER					-1	5
SEARCH_THIS_TREE					-1	5
RC_DROP_DROPCOMPLETE					-1	5
RC_DROP_ITEMCOMPLETE					-1	5
RC_DROP_RENDERING					-1	5
RC_DROP_ERROR						-1	5
MAXSZHFS						-1	5
SETTINGS_PAGE_REMOVED					-1	5
CCVIEW_DEFAULT						-1	5
CCVIEW_ON						-1	5
CCVIEW_OFF						-1	5
MINWIN_DEFAULT						-1	5
MINWIN_HIDDEN						-1	5
MINWIN_VIEWER						-1	5
MINWIN_DESKTOP						-1	5
HIDEBUTTON						-1	5
MINBUTTON						-1	5
DEFAULTBUTTON						-1	5
HIDDENMINWINDOW_DEFAULT 				-1	5
WPFolder						-1	5
WPObject						-1	5
WPObject_MajorVersion					-1	5
WPObject_MinorVersion					-1	5
WPObjectNewClass					-1	5
WPObjectClassData					-1	5
WPObjectCClassData					-1	5
WPObject_classObj					-1	5
_WPObject						-1	5
_WPObjectNew						-1	5
WPObjectNew						-1	5
WPObjectRenew						-1	5
WPObject_somInit					-1	5
WPObject_somUninit					-1	5
somMD_WPObject_wpAddObjectGeneralPage			-1	5
WPObject_wpAddObjectGeneralPage 			-1	5
_wpAddObjectGeneralPage 				-1	5
somMD_WPObject_wpAddObjectWindowPage			-1	5
WPObject_wpAddObjectWindowPage				-1	5
_wpAddObjectWindowPage					-1	5
somMD_WPObject_wpAddSettingsPages			-1	5
WPObject_wpAddSettingsPages				-1	5
_wpAddSettingsPages					-1	5
somMD_WPObject_wpAddToObjUseList			-1	5
WPObject_wpAddToObjUseList				-1	5
_wpAddToObjUseList					-1	5
somMD_WPObject_wpAllocMem				-1	5
WPObject_wpAllocMem					-1	5
_wpAllocMem						-1	5
somMD_WPObject_wpAppendObject				-1	5
WPObject_wpAppendObject 				-1	5
_wpAppendObject 					-1	5
somMD_WPObject_wpAssertObjectMutexSem			-1	5
WPObject_wpAssertObjectMutexSem 			-1	5
_wpAssertObjectMutexSem 				-1	5
somMD_WPObject_wpClose					-1	5
WPObject_wpClose					-1	5
_wpClose						-1	5
somMD_WPObject_wpCnrInsertObject			-1	5
WPObject_wpCnrInsertObject				-1	5
_wpCnrInsertObject					-1	5
somMD_WPObject_wpCnrRemoveObject			-1	5
WPObject_wpCnrRemoveObject				-1	5
_wpCnrRemoveObject					-1	5
somMD_WPObject_wpCnrSetEmphasis 			-1	5
WPObject_wpCnrSetEmphasis				-1	5
_wpCnrSetEmphasis					-1	5
somMD_WPObject_wpConfirmDelete				-1	5
WPObject_wpConfirmDelete				-1	5
_wpConfirmDelete					-1	5
somMD_WPObject_wpConfirmObjectTitle			-1	5
WPObject_wpConfirmObjectTitle				-1	5
_wpConfirmObjectTitle					-1	5
somMD_WPObject_wpCopiedFromTemplate			-1	5
WPObject_wpCopiedFromTemplate				-1	5
_wpCopiedFromTemplate					-1	5
somMD_WPObject_wpCopyObject				-1	5
WPObject_wpCopyObject					-1	5
_wpCopyObject						-1	5
somMD_WPObject_wpCreateAnother				-1	5
WPObject_wpCreateAnother				-1	5
_wpCreateAnother					-1	5
somMD_WPObject_wpCreateFromTemplate			-1	5
WPObject_wpCreateFromTemplate				-1	5
_wpCreateFromTemplate					-1	5
somMD_WPObject_wpCreateShadowObject			-1	5
WPObject_wpCreateShadowObject				-1	5
_wpCreateShadowObject					-1	5
somMD_WPObject_wpDelete 				-1	5
WPObject_wpDelete					-1	5
_wpDelete						-1	5
somMD_WPObject_wpDeleteFromObjUseList			-1	5
WPObject_wpDeleteFromObjUseList 			-1	5
_wpDeleteFromObjUseList 				-1	5
somMD_WPObject_wpDisplayHelp				-1	5
WPObject_wpDisplayHelp					-1	5
_wpDisplayHelp						-1	5
somMD_WPObject_wpDoesObjectMatch			-1	5
WPObject_wpDoesObjectMatch				-1	5
_wpDoesObjectMatch					-1	5
somMD_WPObject_wpDraggedOverObject			-1	5
WPObject_wpDraggedOverObject				-1	5
_wpDraggedOverObject					-1	5
somMD_WPObject_wpDragOver				-1	5
WPObject_wpDragOver					-1	5
_wpDragOver						-1	5
somMD_WPObject_wpDrop					-1	5
WPObject_wpDrop 					-1	5
_wpDrop 						-1	5
somMD_WPObject_wpDroppedOnObject			-1	5
WPObject_wpDroppedOnObject				-1	5
_wpDroppedOnObject					-1	5
somMD_WPObject_wpEndConversation			-1	5
WPObject_wpEndConversation				-1	5
_wpEndConversation					-1	5
somMD_WPObject_wpFilterPopupMenu			-1	5
WPObject_wpFilterPopupMenu				-1	5
_wpFilterPopupMenu					-1	5
somMD_WPObject_wpFindUseItem				-1	5
WPObject_wpFindUseItem					-1	5
_wpFindUseItem						-1	5
somMD_WPObject_wpFormatDragItem 			-1	5
WPObject_wpFormatDragItem				-1	5
_wpFormatDragItem					-1	5
somMD_WPObject_wpFree					-1	5
WPObject_wpFree 					-1	5
_wpFree 						-1	5
somMD_WPObject_wpFreeMem				-1	5
WPObject_wpFreeMem					-1	5
_wpFreeMem						-1	5
somMD_WPObject_wpHide					-1	5
WPObject_wpHide 					-1	5
_wpHide 						-1	5
somMD_WPObject_wpInitData				-1	5
WPObject_wpInitData					-1	5
_wpInitData						-1	5
somMD_WPObject_wpInsertPopupMenuItems			-1	5
WPObject_wpInsertPopupMenuItems 			-1	5
_wpInsertPopupMenuItems 				-1	5
somMD_WPObject_wpInsertSettingsPage			-1	5
WPObject_wpInsertSettingsPage				-1	5
_wpInsertSettingsPage					-1	5
somMD_WPObject_wpMenuItemHelpSelected			-1	5
WPObject_wpMenuItemHelpSelected 			-1	5
_wpMenuItemHelpSelected 				-1	5
somMD_WPObject_wpMenuItemSelected			-1	5
WPObject_wpMenuItemSelected				-1	5
_wpMenuItemSelected					-1	5
somMD_WPObject_wpModifyPopupMenu			-1	5
WPObject_wpModifyPopupMenu				-1	5
_wpModifyPopupMenu					-1	5
somMD_WPObject_wpMoveObject				-1	5
WPObject_wpMoveObject					-1	5
_wpMoveObject						-1	5
somMD_WPObject_wpOpen					-1	5
WPObject_wpOpen 					-1	5
_wpOpen 						-1	5
somMD_WPObject_wpPrintObject				-1	5
WPObject_wpPrintObject					-1	5
_wpPrintObject						-1	5
somMD_WPObject_wpQueryConcurrentView			-1	5
WPObject_wpQueryConcurrentView				-1	5
_wpQueryConcurrentView					-1	5
somMD_WPObject_wpQueryButtonAppearance			-1	5
WPObject_wpQueryButtonAppearance			-1	5
_wpQueryButtonAppearance				-1	5
somMD_WPObject_wpQueryConfirmations			-1	5
WPObject_wpQueryConfirmations				-1	5
_wpQueryConfirmations					-1	5
somMD_WPObject_wpQueryDefaultHelp			-1	5
WPObject_wpQueryDefaultHelp				-1	5
_wpQueryDefaultHelp					-1	5
somMD_WPObject_wpQueryDefaultView			-1	5
WPObject_wpQueryDefaultView				-1	5
_wpQueryDefaultView					-1	5
somMD_WPObject_wpQueryDetailsData			-1	5
WPObject_wpQueryDetailsData				-1	5
_wpQueryDetailsData					-1	5
somMD_WPObject_wpQueryError				-1	5
WPObject_wpQueryError					-1	5
_wpQueryError						-1	5
somMD_WPObject_wpQueryIcon				-1	5
WPObject_wpQueryIcon					-1	5
_wpQueryIcon						-1	5
somMD_WPObject_wpQueryIconData				-1	5
WPObject_wpQueryIconData				-1	5
_wpQueryIconData					-1	5
somMD_WPObject_wpQueryMinWindow 			-1	5
WPObject_wpQueryMinWindow				-1	5
_wpQueryMinWindow					-1	5
somMD_WPObject_wpQueryNameClashOptions			-1	5
WPObject_wpQueryNameClashOptions			-1	5
_wpQueryNameClashOptions				-1	5
somMD_WPObject_wpQueryStyle				-1	5
WPObject_wpQueryStyle					-1	5
_wpQueryStyle						-1	5
somMD_WPObject_wpSetTaskRec				-1	5
WPObject_wpSetTaskRec					-1	5
_wpSetTaskRec						-1	5
somMD_WPObject_wpFindTaskRec				-1	5
WPObject_wpFindTaskRec					-1	5
_wpFindTaskRec						-1	5
somMD_WPObject_wpQueryTitle				-1	5
WPObject_wpQueryTitle					-1	5
_wpQueryTitle						-1	5
somMD_WPObject_wpRegisterView				-1	5
WPObject_wpRegisterView 				-1	5
_wpRegisterView 					-1	5
somMD_WPObject_wpReleaseObjectMutexSem			-1	5
WPObject_wpReleaseObjectMutexSem			-1	5
_wpReleaseObjectMutexSem				-1	5
somMD_WPObject_wpRender 				-1	5
WPObject_wpRender					-1	5
_wpRender						-1	5
somMD_WPObject_wpRenderComplete 			-1	5
WPObject_wpRenderComplete				-1	5
_wpRenderComplete					-1	5
somMD_WPObject_wpReplaceObject				-1	5
WPObject_wpReplaceObject				-1	5
_wpReplaceObject					-1	5
somMD_WPObject_wpRequestObjectMutexSem			-1	5
WPObject_wpRequestObjectMutexSem			-1	5
_wpRequestObjectMutexSem				-1	5
somMD_WPObject_wpRestore				-1	5
WPObject_wpRestore					-1	5
_wpRestore						-1	5
somMD_WPObject_wpRestoreData				-1	5
WPObject_wpRestoreData					-1	5
_wpRestoreData						-1	5
somMD_WPObject_wpRestoreLong				-1	5
WPObject_wpRestoreLong					-1	5
_wpRestoreLong						-1	5
somMD_WPObject_wpRestoreState				-1	5
WPObject_wpRestoreState 				-1	5
_wpRestoreState 					-1	5
somMD_WPObject_wpRestoreString				-1	5
WPObject_wpRestoreString				-1	5
_wpRestoreString					-1	5
somMD_WPObject_wpSaveData				-1	5
WPObject_wpSaveData					-1	5
_wpSaveData						-1	5
somMD_WPObject_wpSaveImmediate				-1	5
WPObject_wpSaveImmediate				-1	5
_wpSaveImmediate					-1	5
somMD_WPObject_wpSaveDeferred				-1	5
WPObject_wpSaveDeferred 				-1	5
_wpSaveDeferred 					-1	5
somMD_WPObject_wpSaveLong				-1	5
WPObject_wpSaveLong					-1	5
_wpSaveLong						-1	5
somMD_WPObject_wpSaveState				-1	5
WPObject_wpSaveState					-1	5
_wpSaveState						-1	5
somMD_WPObject_wpSaveString				-1	5
WPObject_wpSaveString					-1	5
_wpSaveString						-1	5
somMD_WPObject_wpScanSetupString			-1	5
WPObject_wpScanSetupString				-1	5
_wpScanSetupString					-1	5
somMD_WPObject_wpSetConcurrentView			-1	5
WPObject_wpSetConcurrentView				-1	5
_wpSetConcurrentView					-1	5
somMD_WPObject_wpSetButtonAppearance			-1	5
WPObject_wpSetButtonAppearance				-1	5
_wpSetButtonAppearance					-1	5
somMD_WPObject_wpSetDefaultHelp 			-1	5
WPObject_wpSetDefaultHelp				-1	5
_wpSetDefaultHelp					-1	5
somMD_WPObject_wpSetDefaultView 			-1	5
WPObject_wpSetDefaultView				-1	5
_wpSetDefaultView					-1	5
somMD_WPObject_wpSetError				-1	5
WPObject_wpSetError					-1	5
_wpSetError						-1	5
somMD_WPObject_wpSetIcon				-1	5
WPObject_wpSetIcon					-1	5
_wpSetIcon						-1	5
somMD_WPObject_wpSetIconData				-1	5
WPObject_wpSetIconData					-1	5
_wpSetIconData						-1	5
somMD_WPObject_wpSetMinWindow				-1	5
WPObject_wpSetMinWindow 				-1	5
_wpSetMinWindow 					-1	5
somMD_WPObject_wpSetStyle				-1	5
WPObject_wpSetStyle					-1	5
_wpSetStyle						-1	5
somMD_WPObject_wpModifyStyle				-1	5
WPObject_wpModifyStyle					-1	5
_wpModifyStyle						-1	5
somMD_WPObject_wpSetTitle				-1	5
WPObject_wpSetTitle					-1	5
_wpSetTitle						-1	5
somMD_WPObject_wpSetup					-1	5
WPObject_wpSetup					-1	5
_wpSetup						-1	5
somMD_WPObject_wpSwitchTo				-1	5
WPObject_wpSwitchTo					-1	5
_wpSwitchTo						-1	5
somMD_WPObject_wpUnInitData				-1	5
WPObject_wpUnInitData					-1	5
_wpUnInitData						-1	5
somMD_WPObject_wpViewObject				-1	5
WPObject_wpViewObject					-1	5
_wpViewObject						-1	5
WPObject_wpQueryTrueStyle				-1	5
_wpQueryTrueStyle					-1	5
somMD_WPObject_wpQueryHandle				-1	5
WPObject_wpQueryHandle					-1	5
_wpQueryHandle						-1	5
somMD_WPObject_wpUnlockObject				-1	5
WPObject_wpUnlockObject 				-1	5
_wpUnlockObject 					-1	5
wpobject_mh						-1	5
M_WPObject						-1	5
M_WPObject_MajorVersion 				-1	5
M_WPObject_MinorVersion 				-1	5
M_WPObjectNewClass					-1	5
M_WPObjectClassData					-1	5
M_WPObjectCClassData					-1	5
M_WPObject_classObj					-1	5
_M_WPObject						-1	5
_M_WPObjectNew						-1	5
M_WPObjectNew						-1	5
M_WPObjectRenew 					-1	5
M_WPObject_somUninit					-1	5
M_WPObject_somInitClass 				-1	5
M_WPObject_somNew					-1	5
M_WPObject_somRenew					-1	5
somMD_M_WPObject_wpclsCreateDefaultTemplates		-1	5
M_WPObject_wpclsCreateDefaultTemplates			-1	5
_wpclsCreateDefaultTemplates				-1	5
somMD_M_WPObject_wpclsInitData				-1	5
M_WPObject_wpclsInitData				-1	5
_wpclsInitData						-1	5
somMD_M_WPObject_wpclsMakeAwake 			-1	5
M_WPObject_wpclsMakeAwake				-1	5
_wpclsMakeAwake 					-1	5
somMD_M_WPObject_wpclsNew				-1	5
M_WPObject_wpclsNew					-1	5
_wpclsNew						-1	5
somMD_M_WPObject_wpclsQueryDefaultHelp			-1	5
M_WPObject_wpclsQueryDefaultHelp			-1	5
_wpclsQueryDefaultHelp					-1	5
somMD_M_WPObject_wpclsQueryDefaultView			-1	5
M_WPObject_wpclsQueryDefaultView			-1	5
_wpclsQueryDefaultView					-1	5
somMD_M_WPObject_wpclsQueryDetails			-1	5
M_WPObject_wpclsQueryDetails				-1	5
_wpclsQueryDetails					-1	5
somMD_M_WPObject_wpclsQueryDetailsInfo			-1	5
M_WPObject_wpclsQueryDetailsInfo			-1	5
_wpclsQueryDetailsInfo					-1	5
somMD_M_WPObject_wpclsQueryExtendedCriteria		-1	5
M_WPObject_wpclsQueryExtendedCriteria			-1	5
_wpclsQueryExtendedCriteria				-1	5
somMD_M_WPObject_wpclsQueryFolder			-1	5
M_WPObject_wpclsQueryFolder				-1	5
_wpclsQueryFolder					-1	5
somMD_M_WPObject_wpclsQueryIcon 			-1	5
M_WPObject_wpclsQueryIcon				-1	5
_wpclsQueryIcon 					-1	5
somMD_M_WPObject_wpclsQuerySearchInfo			-1	5
M_WPObject_wpclsQuerySearchInfo 			-1	5
_wpclsQuerySearchInfo					-1	5
somMD_M_WPObject_wpclsQueryStyle			-1	5
M_WPObject_wpclsQueryStyle				-1	5
_wpclsQueryStyle					-1	5
somMD_M_WPObject_wpclsQueryTitle			-1	5
M_WPObject_wpclsQueryTitle				-1	5
_wpclsQueryTitle					-1	5
somMD_M_WPObject_wpclsUnInitData			-1	5
M_WPObject_wpclsUnInitData				-1	5
_wpclsUnInitData					-1	5
somMD_M_WPObject_wpclsFindObjectFirst			-1	5
M_WPObject_wpclsFindObjectFirst 			-1	5
_wpclsFindObjectFirst					-1	5
somMD_M_WPObject_wpclsFindObjectNext			-1	5
M_WPObject_wpclsFindObjectNext				-1	5
_wpclsFindObjectNext					-1	5
somMD_M_WPObject_wpclsFindObjectEnd			-1	5
M_WPObject_wpclsFindObjectEnd				-1	5
_wpclsFindObjectEnd					-1	5
somMD_M_WPObject_wpclsSetError				-1	5
M_WPObject_wpclsSetError				-1	5
_wpclsSetError						-1	5
somMD_M_WPObject_wpclsQueryError			-1	5
M_WPObject_wpclsQueryError				-1	5
_wpclsQueryError					-1	5
somMD_M_WPObject_wpclsQuerySettingsPageSize		-1	5
M_WPObject_wpclsQuerySettingsPageSize			-1	5
_wpclsQuerySettingsPageSize				-1	5
somMD_M_WPObject_wpclsQueryIconData			-1	5
M_WPObject_wpclsQueryIconData				-1	5
_wpclsQueryIconData					-1	5
somMD_M_WPObject_wpclsQueryObject			-1	5
M_WPObject_wpclsQueryObject				-1	5
_wpclsQueryObject					-1	5
somMD_M_WPObject_wpclsQueryButtonAppearance		-1	5
M_WPObject_wpclsQueryButtonAppearance			-1	5
_wpclsQueryButtonAppearance				-1	5
wppalet_h						-1	5
WPPalette						-1	5
OPEN_PALETTE						-1	5
IDKEY_PALXCELLCOUNT					-1	5
IDKEY_PALYCELLCOUNT					-1	5
IDKEY_PALXCELLWIDTH					-1	5
IDKEY_PALYCELLHEIGHT					-1	5
IDKEY_PALXGAP						-1	5
IDKEY_PALYGAP						-1	5
IDKEY_PALSCREENSIZEX					-1	5
IDKEY_PALSCREENSIZEY					-1	5
IDKEY_PALCELLDATA_FIRST 				-1	5
DEF_XCELLCOUNT						-1	5
DEF_YCELLCOUNT						-1	5
SetPaletteDataPtr					-1	5
QueryPaletteDataPtr					-1	5
PM_INVALIDATECELL					-1	5
PALETTE_WIDTH						-1	5
PALETTE_HEIGHT						-1	5
ID_PALSCROLLHORZ					-1	5
ID_PALSCROLLVERT					-1	5
CXBUTTON						-1	5
CYBUTTON						-1	5
XBUTTONGAP						-1	5
YBUTTONGAP						-1	5
CYBUTTONAREA						-1	5
DEF_XCELLWIDTH						-1	5
DEF_YCELLHEIGHT 					-1	5
DEF_XCELLGAP						-1	5
DEF_YCELLGAP						-1	5
WPPalette_MajorVersion					-1	5
WPPalette_MinorVersion					-1	5
WPPaletteNewClass					-1	5
WPPaletteClassData					-1	5
WPPaletteCClassData					-1	5
WPPalette_classObj					-1	5
_WPPalette						-1	5
_WPPaletteNew						-1	5
WPPaletteNew						-1	5
WPPaletteRenew						-1	5
WPPalette_wpInitData					-1	5
WPPalette_wpUnInitData					-1	5
WPPalette_wpSetup					-1	5
WPPalette_wpSaveState					-1	5
WPPalette_wpRestoreState				-1	5
WPPalette_wpMenuItemSelected				-1	5
WPPalette_wpModifyPopupMenu				-1	5
WPPalette_wpFilterPopupMenu				-1	5
WPPalette_wpOpen					-1	5
WPPalette_wpMenuItemHelpSelected			-1	5
somMD_WPPalette_wpPaintCell				-1	5
WPPalette_wpPaintCell					-1	5
_wpPaintCell						-1	5
somMD_WPPalette_wpSetupCell				-1	5
WPPalette_wpSetupCell					-1	5
_wpSetupCell						-1	5
somMD_WPPalette_wpRedrawCell				-1	5
WPPalette_wpRedrawCell					-1	5
_wpRedrawCell						-1	5
somMD_WPPalette_wpQueryPaletteInfo			-1	5
WPPalette_wpQueryPaletteInfo				-1	5
_wpQueryPaletteInfo					-1	5
somMD_WPPalette_wpSetPaletteInfo			-1	5
WPPalette_wpSetPaletteInfo				-1	5
_wpSetPaletteInfo					-1	5
somMD_WPPalette_wpEditCell				-1	5
WPPalette_wpEditCell					-1	5
_wpEditCell						-1	5
somMD_WPPalette_wpDragCell				-1	5
WPPalette_wpDragCell					-1	5
_wpDragCell						-1	5
somMD_WPPalette_wpQueryPaletteHelp			-1	5
WPPalette_wpQueryPaletteHelp				-1	5
_wpQueryPaletteHelp					-1	5
wppalet_mh						-1	5
M_WPPalette						-1	5
M_WPPalette_MajorVersion				-1	5
M_WPPalette_MinorVersion				-1	5
M_WPPaletteNewClass					-1	5
M_WPPaletteClassData					-1	5
M_WPPaletteCClassData					-1	5
M_WPPalette_classObj					-1	5
_M_WPPalette						-1	5
_M_WPPaletteNew 					-1	5
M_WPPaletteNew						-1	5
M_WPPaletteRenew					-1	5
M_WPPalette_wpclsQueryTitle				-1	5
M_WPPalette_wpclsQueryStyle				-1	5
M_WPPalette_wpclsQueryDefaultView			-1	5
M_WPPalette_wpclsQueryDefaultHelp			-1	5
somMD_M_WPPalette_wpclsQueryEditString			-1	5
M_WPPalette_wpclsQueryEditString			-1	5
_wpclsQueryEditString					-1	5
wppdr_h 						-1	5
WPPdr							-1	5
WPPdr_MajorVersion					-1	5
WPPdr_MinorVersion					-1	5
WPPdrNewClass						-1	5
WPPdrClassData						-1	5
WPPdrCClassData 					-1	5
WPPdr_classObj						-1	5
_WPPdr							-1	5
_WPPdrNew						-1	5
WPPdrNew						-1	5
WPPdrRenew						-1	5
WPPdr_wpInitData					-1	5
WPPdr_wpUnInitData					-1	5
WPPdr_somDumpSelfInt					-1	5
WPPdr_wpAddSettingsPages				-1	5
WPPdr_wpQueryTitle					-1	5
WPPdr_wpQueryIcon					-1	5
WPPdr_wpFilterPopupMenu 				-1	5
WPPdr_wpFree						-1	5
WPPdr_wpModifyPopupMenu 				-1	5
WPPdr_wpMenuItemSelected				-1	5
WPPdr_wpMenuItemHelpSelected				-1	5
WPPdr_wpOpen						-1	5
WPPdr_wpDrop						-1	5
WPPdr_wpDragOver					-1	5
wppdr_mh						-1	5
M_WPPdr 						-1	5
M_WPPdr_MajorVersion					-1	5
M_WPPdr_MinorVersion					-1	5
M_WPPdrNewClass 					-1	5
M_WPPdrClassData					-1	5
M_WPPdrCClassData					-1	5
M_WPPdr_classObj					-1	5
_M_WPPdr						-1	5
_M_WPPdrNew						-1	5
M_WPPdrNew						-1	5
M_WPPdrRenew						-1	5
M_WPPdr_wpclsQueryTitle 				-1	5
M_WPPdr_wpclsQueryIcon					-1	5
M_WPPdr_wpclsQueryDefaultHelp				-1	5
M_WPPdr_wpclsQueryDefaultView				-1	5
M_WPPdr_wpclsQueryStyle 				-1	5
wppgm_h 						-1	5
WPProgram						-1	5
WPProgram_MajorVersion					-1	5
WPProgram_MinorVersion					-1	5
WPProgramNewClass					-1	5
WPProgramClassData					-1	5
WPProgramCClassData					-1	5
WPProgram_classObj					-1	5
_WPProgram						-1	5
_WPProgramNew						-1	5
WPProgramNew						-1	5
WPProgramRenew						-1	5
WPProgram_wpQueryDefaultHelp				-1	5
WPProgram_wpInitData					-1	5
WPProgram_wpSetup					-1	5
WPProgram_wpUnInitData					-1	5
WPProgram_wpSaveState					-1	5
WPProgram_wpRestoreState				-1	5
WPProgram_wpAddSettingsPages				-1	5
WPProgram_wpOpen					-1	5
WPProgram_wpModifyPopupMenu				-1	5
WPProgram_wpMenuItemSelected				-1	5
WPProgram_wpMenuItemHelpSelected			-1	5
WPProgram_wpCreateFromTemplate				-1	5
WPProgram_wpCreateAnother				-1	5
WPProgram_wpQueryIconData				-1	5
WPProgram_wpSetIconData 				-1	5
WPProgram_wpQueryIcon					-1	5
WPProgram_wpMoveObject					-1	5
WPProgram_wpCopyObject					-1	5
WPProgram_wpDragOver					-1	5
WPProgram_wpDrop					-1	5
WPProgram_wpSetTitle					-1	5
somMD_WPProgram_wpAddProgramAssociationPage		-1	5
WPProgram_wpAddProgramAssociationPage			-1	5
lookup_wpAddProgramAssociationPage			-1	5
_wpAddProgramAssociationPage				-1	5
somMD_WPProgram_wpQueryProgDetails			-1	5
WPProgram_wpQueryProgDetails				-1	5
lookup_wpQueryProgDetails				-1	5
_wpQueryProgDetails					-1	5
somMD_WPProgram_wpSetProgDetails			-1	5
WPProgram_wpSetProgDetails				-1	5
lookup_wpSetProgDetails 				-1	5
_wpSetProgDetails					-1	5
somMD_WPProgram_wpAddProgramPage			-1	5
WPProgram_wpAddProgramPage				-1	5
lookup_wpAddProgramPage 				-1	5
_wpAddProgramPage					-1	5
somMD_WPProgram_wpAddProgramSessionPage 		-1	5
WPProgram_wpAddProgramSessionPage			-1	5
lookup_wpAddProgramSessionPage				-1	5
_wpAddProgramSessionPage				-1	5
somMD_WPProgram_wpQueryAssociationFilter		-1	5
WPProgram_wpQueryAssociationFilter			-1	5
lookup_wpQueryAssociationFilter 			-1	5
_wpQueryAssociationFilter				-1	5
somMD_WPProgram_wpQueryAssociationType			-1	5
WPProgram_wpQueryAssociationType			-1	5
lookup_wpQueryAssociationType				-1	5
_wpQueryAssociationType 				-1	5
somMD_WPProgram_wpSetAssociationFilter			-1	5
WPProgram_wpSetAssociationFilter			-1	5
lookup_wpSetAssociationFilter				-1	5
_wpSetAssociationFilter 				-1	5
somMD_WPProgram_wpSetAssociationType			-1	5
WPProgram_wpSetAssociationType				-1	5
lookup_wpSetAssociationType				-1	5
_wpSetAssociationType					-1	5
wppgm_mh						-1	5
M_WPProgram						-1	5
M_WPProgram_MajorVersion				-1	5
M_WPProgram_MinorVersion				-1	5
M_WPProgramNewClass					-1	5
M_WPProgramClassData					-1	5
M_WPProgramCClassData					-1	5
M_WPProgram_classObj					-1	5
_M_WPProgram						-1	5
_M_WPProgramNew 					-1	5
M_WPProgramNew						-1	5
M_WPProgramRenew					-1	5
M_WPProgram_wpclsQueryTitle				-1	5
M_WPProgram_wpclsQueryIconData				-1	5
M_WPProgram_wpclsQueryStyle				-1	5
M_WPProgram_wpclsQueryDefaultHelp			-1	5
M_WPProgram_wpclsQueryDefaultView			-1	5
wppgmf_h						-1	5
WPProgramFile						-1	5
WPProgramFile_MajorVersion				-1	5
WPProgramFile_MinorVersion				-1	5
WPProgramFileNewClass					-1	5
WPProgramFileClassData					-1	5
WPProgramFileCClassData 				-1	5
WPProgramFile_classObj					-1	5
_WPProgramFile						-1	5
_WPProgramFileNew					-1	5
WPProgramFileNew					-1	5
WPProgramFileRenew					-1	5
WPProgramFile_wpSetAssociatedFileIcon			-1	5
WPProgramFile_wpInitData				-1	5
WPProgramFile_wpSaveState				-1	5
WPProgramFile_wpRestoreState				-1	5
WPProgramFile_wpAddSettingsPages			-1	5
WPProgramFile_wpOpen					-1	5
WPProgramFile_wpModifyPopupMenu 			-1	5
WPProgramFile_wpMenuItemSelected			-1	5
WPProgramFile_wpMenuItemHelpSelected			-1	5
WPProgramFile_wpMoveObject				-1	5
WPProgramFile_wpDragOver				-1	5
WPProgramFile_wpDrop					-1	5
WPProgramFile_wpCopyObject				-1	5
WPProgramFile_wpConfirmRenameFileWithExt		-1	5
WPProgramFile_wpCreateAnother				-1	5
WPProgramFile_wpFilterPopupMenu 			-1	5
WPProgramFile_wpSetup					-1	5
WPProgramFile_wpQueryNameClashOptions			-1	5
somMD_WPProgramFile_wpAddProgramAssociationPage 	-1	5
WPProgramFile_wpAddProgramAssociationPage		-1	5
lookup_wpAddProgramAssociationPage			-1	5
_wpAddProgramAssociationPage				-1	5
somMD_WPProgramFile_wpQueryProgDetails			-1	5
WPProgramFile_wpQueryProgDetails			-1	5
lookup_wpQueryProgDetails				-1	5
_wpQueryProgDetails					-1	5
somMD_WPProgramFile_wpSetProgDetails			-1	5
WPProgramFile_wpSetProgDetails				-1	5
lookup_wpSetProgDetails 				-1	5
_wpSetProgDetails					-1	5
somMD_WPProgramFile_wpAddProgramPage			-1	5
WPProgramFile_wpAddProgramPage				-1	5
lookup_wpAddProgramPage 				-1	5
_wpAddProgramPage					-1	5
somMD_WPProgramFile_wpAddProgramSessionPage		-1	5
WPProgramFile_wpAddProgramSessionPage			-1	5
lookup_wpAddProgramSessionPage				-1	5
_wpAddProgramSessionPage				-1	5
somMD_WPProgramFile_wpQueryAssociationFilter		-1	5
WPProgramFile_wpQueryAssociationFilter			-1	5
lookup_wpQueryAssociationFilter 			-1	5
_wpQueryAssociationFilter				-1	5
somMD_WPProgramFile_wpQueryAssociationType		-1	5
WPProgramFile_wpQueryAssociationType			-1	5
lookup_wpQueryAssociationType				-1	5
_wpQueryAssociationType 				-1	5
somMD_WPProgramFile_wpSetAssociationFilter		-1	5
WPProgramFile_wpSetAssociationFilter			-1	5
lookup_wpSetAssociationFilter				-1	5
_wpSetAssociationFilter 				-1	5
somMD_WPProgramFile_wpSetAssociationType		-1	5
WPProgramFile_wpSetAssociationType			-1	5
lookup_wpSetAssociationType				-1	5
_wpSetAssociationType					-1	5
wppgmf_mh						-1	5
M_WPProgramFile 					-1	5
M_WPProgramFile_MajorVersion				-1	5
M_WPProgramFile_MinorVersion				-1	5
M_WPProgramFileNewClass 				-1	5
M_WPProgramFileClassData				-1	5
M_WPProgramFileCClassData				-1	5
M_WPProgramFile_classObj				-1	5
_M_WPProgramFile					-1	5
_M_WPProgramFileNew					-1	5
M_WPProgramFileNew					-1	5
M_WPProgramFileRenew					-1	5
M_WPProgramFile_wpclsQueryTitle 			-1	5
M_WPProgramFile_wpclsQueryIconData			-1	5
M_WPProgramFile_wpclsQueryIconData			-1	5
M_WPProgramFile_wpclsQueryDefaultView			-1	5
M_WPProgramFile_wpclsQueryStyle 			-1	5
wpport_h						-1	5
WPPort							-1	5
WPPort_MajorVersion					-1	5
WPPort_MinorVersion					-1	5
WPPortNewClass						-1	5
WPPortClassData 					-1	5
WPPortCClassData					-1	5
WPPort_classObj 					-1	5
_WPPort 						-1	5
_WPPortNew						-1	5
WPPortNew						-1	5
WPPortRenew						-1	5
WPPort_wpInitData					-1	5
WPPort_wpUnInitData					-1	5
WPPort_somDumpSelfInt					-1	5
WPPort_wpQueryTitle					-1	5
WPPort_wpQueryIcon					-1	5
WPPort_wpFilterPopupMenu				-1	5
WPPort_wpFree						-1	5
WPPort_wpModifyPopupMenu				-1	5
WPPort_wpMenuItemSelected				-1	5
WPPort_wpMenuItemHelpSelected				-1	5
WPPort_wpOpen						-1	5
WPPort_wpDrop						-1	5
WPPort_wpDragOver					-1	5
WPPort_wpCnrSetEmphasis 				-1	5
wpport_mh						-1	5
M_WPPort						-1	5
M_WPPort_MajorVersion					-1	5
M_WPPort_MinorVersion					-1	5
M_WPPortNewClass					-1	5
M_WPPortClassData					-1	5
M_WPPortCClassData					-1	5
M_WPPort_classObj					-1	5
_M_WPPort						-1	5
_M_WPPortNew						-1	5
M_WPPortNew						-1	5
M_WPPortRenew						-1	5
M_WPPort_wpclsQueryTitle				-1	5
M_WPPort_wpclsQueryIcon 				-1	5
M_WPPort_wpclsQueryDefaultHelp				-1	5
M_WPPort_wpclsQueryDefaultView				-1	5
M_WPPort_wpclsQueryStyle				-1	5
wpprint_h						-1	5
WPPrinter						-1	5
WPPrinter_MajorVersion					-1	5
WPPrinter_MinorVersion					-1	5
WPPrinterNewClass					-1	5
WPPrinterClassData					-1	5
WPPrinterCClassData					-1	5
WPPrinter_classObj					-1	5
_WPPrinter						-1	5
_WPPrinterNew						-1	5
WPPrinterNew						-1	5
WPPrinterRenew						-1	5
WPPrinter_wpInitData					-1	5
WPPrinter_wpUnInitData					-1	5
WPPrinter_somDumpSelfInt				-1	5
WPPrinter_wpSetTitle					-1	5
WPPrinter_wpSaveState					-1	5
WPPrinter_wpRestoreState				-1	5
WPPrinter_wpAddSettingsPages				-1	5
WPPrinter_wpQueryTitle					-1	5
WPPrinter_wpQueryIcon					-1	5
WPPrinter_wpSetIcon					-1	5
WPPrinter_wpFilterPopupMenu				-1	5
WPPrinter_wpFree					-1	5
WPPrinter_wpModifyPopupMenu				-1	5
WPPrinter_wpMenuItemSelected				-1	5
WPPrinter_wpMenuItemHelpSelected			-1	5
WPPrinter_wpQueryDefaultHelp				-1	5
WPPrinter_wpOpen					-1	5
WPPrinter_wpDrop					-1	5
WPPrinter_wpDragOver					-1	5
WPPrinter_wpCreateAnother				-1	5
WPPrinter_wpCopyObject					-1	5
WPPrinter_wpCopiedFromTemplate				-1	5
WPPrinter_wpCreateFromTemplate				-1	5
WPPrinter_wpQueryStyle					-1	5
WPPrinter_wpMoveObject					-1	5
WPPrinter_wpCreateShadowObject				-1	5
WPPrinter_wpQueryIconData				-1	5
WPPrinter_wpSetIconData 				-1	5
somMD_WPPrinter_wpDeleteAllJobs 			-1	5
WPPrinter_wpDeleteAllJobs				-1	5
_wpDeleteAllJobs					-1	5
somMD_WPPrinter_wpHoldPrinter				-1	5
WPPrinter_wpHoldPrinter 				-1	5
_wpHoldPrinter						-1	5
somMD_WPPrinter_wpReleasePrinter			-1	5
WPPrinter_wpReleasePrinter				-1	5
_wpReleasePrinter					-1	5
somMD_WPPrinter_wpQueryComputerName			-1	5
WPPrinter_wpQueryComputerName				-1	5
_wpQueryComputerName					-1	5
somMD_WPPrinter_wpQueryPrinterName			-1	5
WPPrinter_wpQueryPrinterName				-1	5
_wpQueryPrinterName					-1	5
somMD_WPPrinter_wpSetComputerName			-1	5
WPPrinter_wpSetComputerName				-1	5
_wpSetComputerName					-1	5
somMD_WPPrinter_wpSetPrinterName			-1	5
WPPrinter_wpSetPrinterName				-1	5
_wpSetPrinterName					-1	5
somMD_WPPrinter_wpSetDefaultPrinter			-1	5
WPPrinter_wpSetDefaultPrinter				-1	5
_wpSetDefaultPrinter					-1	5
wpprint_mh						-1	5
M_WPPrinter						-1	5
M_WPPrinter_MajorVersion				-1	5
M_WPPrinter_MinorVersion				-1	5
M_WPPrinterNewClass					-1	5
M_WPPrinterClassData					-1	5
M_WPPrinterCClassData					-1	5
M_WPPrinter_classObj					-1	5
_M_WPPrinter						-1	5
_M_WPPrinterNew 					-1	5
M_WPPrinterNew						-1	5
M_WPPrinterRenew					-1	5
M_WPPrinter_wpclsQueryTitle				-1	5
M_WPPrinter_wpclsQueryIcon				-1	5
M_WPPrinter_wpclsQueryDefaultHelp			-1	5
M_WPPrinter_wpclsQueryDefaultView			-1	5
M_WPPrinter_wpclsQueryStyle				-1	5
M_WPPrinter_wpclsQueryIconData				-1	5
M_WPPrinter_wpclsInitData				-1	5
wpptr_h 						-1	5
WPPointer						-1	5
WPPointer_MajorVersion					-1	5
WPPointer_MinorVersion					-1	5
WPPointerNewClass					-1	5
WPPointerClassData					-1	5
WPPointerCClassData					-1	5
WPPointer_classObj					-1	5
_WPPointer						-1	5
_WPPointerNew						-1	5
WPPointerNew						-1	5
WPPointerRenew						-1	5
WPPointer_wpSetup					-1	5
wpptr_mh						-1	5
M_WPPointer						-1	5
M_WPPointer_MajorVersion				-1	5
M_WPPointer_MinorVersion				-1	5
M_WPPointerNewClass					-1	5
M_WPPointerClassData					-1	5
M_WPPointerCClassData					-1	5
M_WPPointer_classObj					-1	5
_M_WPPointer						-1	5
_M_WPPointerNew 					-1	5
M_WPPointerNew						-1	5
M_WPPointerRenew					-1	5
M_WPPointer_wpclsQueryInstanceFilter			-1	5
M_WPPointer_wpclsQueryInstanceType			-1	5
M_WPPointer_wpclsInitData				-1	5
M_WPPointer_wpclsQueryTitle				-1	5
M_WPPointer_wpclsQueryDefaultHelp			-1	5
wpqdr_h 						-1	5
WPQdr							-1	5
WPQdr_MajorVersion					-1	5
WPQdr_MinorVersion					-1	5
WPQdrNewClass						-1	5
WPQdrClassData						-1	5
WPQdrCClassData 					-1	5
WPQdr_classObj						-1	5
_WPQdr							-1	5
_WPQdrNew						-1	5
WPQdrNew						-1	5
WPQdrRenew						-1	5
WPQdr_wpInitData					-1	5
WPQdr_wpUnInitData					-1	5
WPQdr_somDumpSelfInt					-1	5
WPQdr_wpAddSettingsPages				-1	5
WPQdr_wpQueryTitle					-1	5
WPQdr_wpQueryIcon					-1	5
WPQdr_wpFilterPopupMenu 				-1	5
WPQdr_wpFree						-1	5
WPQdr_wpModifyPopupMenu 				-1	5
WPQdr_wpMenuItemSelected				-1	5
WPQdr_wpMenuItemHelpSelected				-1	5
WPQdr_wpOpen						-1	5
WPQdr_wpDrop						-1	5
WPQdr_wpDragOver					-1	5
wpqdr_mh						-1	5
M_WPQdr 						-1	5
M_WPQdr_MajorVersion					-1	5
M_WPQdr_MinorVersion					-1	5
M_WPQdrNewClass 					-1	5
M_WPQdrClassData					-1	5
M_WPQdrCClassData					-1	5
M_WPQdr_classObj					-1	5
_M_WPQdr						-1	5
_M_WPQdrNew						-1	5
M_WPQdrNew						-1	5
M_WPQdrRenew						-1	5
M_WPQdr_wpclsQueryTitle 				-1	5
M_WPQdr_wpclsQueryIcon					-1	5
M_WPQdr_wpclsQueryDefaultHelp				-1	5
M_WPQdr_wpclsQueryDefaultView				-1	5
M_WPQdr_wpclsQueryStyle 				-1	5
wprootf_h						-1	5
WPRootFolder						-1	5
WPRootFolder_MajorVersion				-1	5
WPRootFolder_MinorVersion				-1	5
WPRootFolderNewClass					-1	5
WPRootFolderClassData					-1	5
WPRootFolderCClassData					-1	5
WPRootFolder_classObj					-1	5
_WPRootFolder						-1	5
_WPRootFolderNew					-1	5
WPRootFolderNew 					-1	5
WPRootFolderRenew					-1	5
WPRootFolder_wpFilterPopupMenu				-1	5
WPRootFolder_wpSetTitle 				-1	5
WPRootFolder_wpOpen					-1	5
WPRootFolder_wpSaveState				-1	5
WPRootFolder_wpRestoreState				-1	5
WPRootFolder_wpAddFile1Page				-1	5
WPRootFolder_wpAddFile2Page				-1	5
WPRootFolder_wpAddFile3Page				-1	5
WPRootFolder_wpSetDefaultView				-1	5
wprootf_mh						-1	5
M_WPRootFolder						-1	5
M_WPRootFolder_MajorVersion				-1	5
M_WPRootFolder_MinorVersion				-1	5
M_WPRootFolderNewClass					-1	5
M_WPRootFolderClassData 				-1	5
M_WPRootFolderCClassData				-1	5
M_WPRootFolder_classObj 				-1	5
_M_WPRootFolder 					-1	5
_M_WPRootFolderNew					-1	5
M_WPRootFolderNew					-1	5
M_WPRootFolderRenew					-1	5
M_WPRootFolder_wpclsQueryStyle				-1	5
M_WPRootFolder_wpclsInitData				-1	5
M_WPRootFolder_wpclsUnInitData				-1	5
wpscheme_h						-1	5
WPSchemePalette 					-1	5
CCHSCHEMENAME						-1	5
CCHFONTNAME						-1	5
SYSCLR_TO_INDEX 					-1	5
INDEX_TO_SYSCLR 					-1	5
RGB_FROM_SYSCLR 					-1	5
WPSchemePalette_MajorVersion				-1	5
WPSchemePalette_MinorVersion				-1	5
WPSchemePaletteNewClass 				-1	5
WPSchemePaletteClassData				-1	5
WPSchemePaletteCClassData				-1	5
WPSchemePalette_classObj				-1	5
_WPSchemePalette					-1	5
_WPSchemePaletteNew					-1	5
WPSchemePaletteNew					-1	5
WPSchemePaletteRenew					-1	5
WPSchemePalette_wpPaintCell				-1	5
WPSchemePalette_wpEditCell				-1	5
WPSchemePalette_wpSetupCell				-1	5
WPSchemePalette_wpDragCell				-1	5
WPSchemePalette_wpQueryPaletteHelp			-1	5
WPSchemePalette_wpSetup 				-1	5
WPSchemePalette_wpMenuItemHelpSelected			-1	5
wpscheme_mh						-1	5
M_WPSchemePalette					-1	5
M_WPSchemePalette_MajorVersion				-1	5
M_WPSchemePalette_MinorVersion				-1	5
M_WPSchemePaletteNewClass				-1	5
M_WPSchemePaletteClassData				-1	5
M_WPSchemePaletteCClassData				-1	5
M_WPSchemePalette_classObj				-1	5
_M_WPSchemePalette					-1	5
_M_WPSchemePaletteNew					-1	5
M_WPSchemePaletteNew					-1	5
M_WPSchemePaletteRenew					-1	5
M_WPSchemePalette_wpclsQueryEditString			-1	5
M_WPSchemePalette_wpclsQueryTitle			-1	5
M_WPSchemePalette_wpclsQueryStyle			-1	5
M_WPSchemePalette_wpclsQueryDefaultHelp 		-1	5
M_WPSchemePalette_wpclsQueryIconData			-1	5
wpshadow_h						-1	5
WPShadow						-1	5
WPShadow_MajorVersion					-1	5
WPShadow_MinorVersion					-1	5
WPShadowNewClass					-1	5
WPShadowClassData					-1	5
WPShadowCClassData					-1	5
WPShadow_classObj					-1	5
_WPShadow						-1	5
_WPShadowNew						-1	5
WPShadowNew						-1	5
WPShadowRenew						-1	5
WPShadow_wpQueryTitle					-1	5
WPShadow_wpSetup					-1	5
WPShadow_wpSaveState					-1	5
WPShadow_wpRestoreState 				-1	5
WPShadow_wpQueryStyle					-1	5
WPShadow_wpInitData					-1	5
WPShadow_wpUnInitData					-1	5
WPShadow_wpSetTitle					-1	5
WPShadow_wpFilterPopupMenu				-1	5
WPShadow_wpModifyPopupMenu				-1	5
WPShadow_wpMenuItemSelected				-1	5
WPShadow_wpViewObject					-1	5
WPShadow_wpMenuItemHelpSelected 			-1	5
WPShadow_wpCreateFromTemplate				-1	5
WPShadow_wpOpen 					-1	5
WPShadow_wpInsertPopupMenuItems 			-1	5
WPShadow_wpCreateShadowObject				-1	5
WPShadow_wpDragOver					-1	5
WPShadow_wpDrop 					-1	5
WPShadow_wpQueryDefaultHelp				-1	5
WPShadow_wpConfirmDelete				-1	5
WPShadow_wpConfirmObjectTitle				-1	5
WPShadow_wpPrintObject					-1	5
WPShadow_wpFormatDragItem				-1	5
WPShadow_wpDraggedOverObject				-1	5
WPShadow_wpDroppedOnObject				-1	5
WPShadow_wpQueryNameClashOptions			-1	5
somMD_WPShadow_wpQueryShadowedObject			-1	5
WPShadow_wpQueryShadowedObject				-1	5
_wpQueryShadowedObject					-1	5
somMD_WPShadow_wpSetShadowTitle 			-1	5
WPShadow_wpSetShadowTitle				-1	5
_wpSetShadowTitle					-1	5
wpshadow_mh						-1	5
M_WPShadow						-1	5
M_WPShadow_MajorVersion 				-1	5
M_WPShadow_MinorVersion 				-1	5
M_WPShadowNewClass					-1	5
M_WPShadowClassData					-1	5
M_WPShadowCClassData					-1	5
M_WPShadow_classObj					-1	5
_M_WPShadow						-1	5
_M_WPShadowNew						-1	5
M_WPShadowNew						-1	5
M_WPShadowRenew 					-1	5
M_WPShadow_wpclsQueryTitle				-1	5
M_WPShadow_wpclsQueryStyle				-1	5
M_WPShadow_wpclsQueryIconData				-1	5
wpshred_h						-1	5
WPShredder						-1	5
WPShredder_MajorVersion 				-1	5
WPShredder_MinorVersion 				-1	5
WPShredderNewClass					-1	5
WPShredderClassData					-1	5
WPShredderCClassData					-1	5
WPShredder_classObj					-1	5
_WPShredder						-1	5
_WPShredderNew						-1	5
WPShredderNew						-1	5
WPShredderRenew 					-1	5
WPShredder_wpAddObjectWindowPage			-1	5
WPShredder_wpFilterPopupMenu				-1	5
WPShredder_wpDragOver					-1	5
WPShredder_wpDrop					-1	5
wpshred_mh						-1	5
M_WPShredder						-1	5
M_WPShredder_MajorVersion				-1	5
M_WPShredder_MinorVersion				-1	5
M_WPShredderNewClass					-1	5
M_WPShredderClassData					-1	5
M_WPShredderCClassData					-1	5
M_WPShredder_classObj					-1	5
_M_WPShredder						-1	5
_M_WPShredderNew					-1	5
M_WPShredderNew 					-1	5
M_WPShredderRenew					-1	5
M_WPShredder_wpclsQueryDefaultView			-1	5
M_WPShredder_wpclsQueryDefaultHelp			-1	5
M_WPShredder_wpclsQueryIconData 			-1	5
M_WPShredder_wpclsQueryStyle				-1	5
M_WPShredder_wpclsQueryTitle				-1	5
wpsound_h						-1	5
WPSound 						-1	5
WPSound_MajorVersion					-1	5
WPSound_MinorVersion					-1	5
WPSoundNewClass 					-1	5
WPSoundClassData					-1	5
WPSoundCClassData					-1	5
WPSound_classObj					-1	5
_WPSound						-1	5
_WPSoundNew						-1	5
WPSoundNew						-1	5
WPSoundRenew						-1	5
WPSound_wpAddSettingsPages				-1	5
WPSound_wpAddObjectWindowPage				-1	5
WPSound_wpFilterPopupMenu				-1	5
somMD_WPSound_wpAddSoundWarningBeepPage 		-1	5
WPSound_wpAddSoundWarningBeepPage			-1	5
_wpAddSoundWarningBeepPage				-1	5
wpsound_mh						-1	5
M_WPSound						-1	5
M_WPSound_MajorVersion					-1	5
M_WPSound_MinorVersion					-1	5
M_WPSoundNewClass					-1	5
M_WPSoundClassData					-1	5
M_WPSoundCClassData					-1	5
M_WPSound_classObj					-1	5
_M_WPSound						-1	5
_M_WPSoundNew						-1	5
M_WPSoundNew						-1	5
M_WPSoundRenew						-1	5
M_WPSound_wpclsQueryTitle				-1	5
M_WPSound_wpclsQueryDefaultHelp 			-1	5
M_WPSound_wpclsQueryDefaultView 			-1	5
M_WPSound_wpclsQueryStyle				-1	5
M_WPSound_wpclsQueryIconData				-1	5
wpspneed_h						-1	5
WPSpecialNeeds						-1	5
WPSpecialNeeds_MajorVersion				-1	5
WPSpecialNeeds_MinorVersion				-1	5
WPSpecialNeedsNewClass					-1	5
WPSpecialNeedsClassData 				-1	5
WPSpecialNeedsCClassData				-1	5
WPSpecialNeeds_classObj 				-1	5
_WPSpecialNeeds 					-1	5
_WPSpecialNeedsNew					-1	5
WPSpecialNeedsNew					-1	5
WPSpecialNeedsRenew					-1	5
WPSpecialNeeds_wpFilterPopupMenu			-1	5
wpspneed_mh						-1	5
M_WPSpecialNeeds					-1	5
M_WPSpecialNeeds_MajorVersion				-1	5
M_WPSpecialNeeds_MinorVersion				-1	5
M_WPSpecialNeedsNewClass				-1	5
M_WPSpecialNeedsClassData				-1	5
M_WPSpecialNeedsCClassData				-1	5
M_WPSpecialNeeds_classObj				-1	5
_M_WPSpecialNeeds					-1	5
_M_WPSpecialNeedsNew					-1	5
M_WPSpecialNeedsNew					-1	5
M_WPSpecialNeedsRenew					-1	5
M_WPSpecialNeeds_wpclsQueryIconData			-1	5
M_WPSpecialNeeds_wpclsQueryDefaultHelp			-1	5
M_WPSpecialNeeds_wpclsQueryTitle			-1	5
wpspool_h						-1	5
WPSpool 						-1	5
WPSpool_MajorVersion					-1	5
WPSpool_MinorVersion					-1	5
WPSpoolNewClass 					-1	5
WPSpoolClassData					-1	5
WPSpoolCClassData					-1	5
WPSpool_classObj					-1	5
_WPSpool						-1	5
_WPSpoolNew						-1	5
WPSpoolNew						-1	5
WPSpoolRenew						-1	5
WPSpool_wpInitData					-1	5
WPSpool_wpUnInitData					-1	5
WPSpool_somDumpSelfInt					-1	5
WPSpool_wpQueryTitle					-1	5
WPSpool_wpQueryIcon					-1	5
WPSpool_wpFilterPopupMenu				-1	5
WPSpool_wpModifyPopupMenu				-1	5
WPSpool_wpMenuItemSelected				-1	5
WPSpool_wpMenuItemHelpSelected				-1	5
WPSpool_wpOpen						-1	5
WPSpool_wpDrop						-1	5
WPSpool_wpCopyObject					-1	5
WPSpool_wpDragOver					-1	5
WPSpool_wpSaveState					-1	5
WPSpool_wpRestoreState					-1	5
WPSpool_wpAddSettingsPages				-1	5
wpspool_mh						-1	5
M_WPSpool						-1	5
M_WPSpool_MajorVersion					-1	5
M_WPSpool_MinorVersion					-1	5
M_WPSpoolNewClass					-1	5
M_WPSpoolClassData					-1	5
M_WPSpoolCClassData					-1	5
M_WPSpool_classObj					-1	5
_M_WPSpool						-1	5
_M_WPSpoolNew						-1	5
M_WPSpoolNew						-1	5
M_WPSpoolRenew						-1	5
M_WPSpool_wpclsQueryTitle				-1	5
M_WPSpool_wpclsQueryIcon				-1	5
M_WPSpool_wpclsQueryDefaultHelp 			-1	5
M_WPSpool_wpclsQueryDefaultView 			-1	5
M_WPSpool_wpclsQueryStyle				-1	5
M_WPSpool_wpclsQueryIconData				-1	5
wpstart_h						-1	5
WPStartup						-1	5
WPStartup_MajorVersion					-1	5
WPStartup_MinorVersion					-1	5
WPStartupNewClass					-1	5
WPStartupClassData					-1	5
WPStartupCClassData					-1	5
WPStartup_classObj					-1	5
_WPStartup						-1	5
_WPStartupNew						-1	5
WPStartupNew						-1	5
WPStartupRenew						-1	5
WPStartup_wpSetup					-1	5
WPStartup_wpRestoreState				-1	5
WPStartup_wpFree					-1	5
wpstart_mh						-1	5
M_WPStartup						-1	5
M_WPStartup_MajorVersion				-1	5
M_WPStartup_MinorVersion				-1	5
M_WPStartupNewClass					-1	5
M_WPStartupClassData					-1	5
M_WPStartupCClassData					-1	5
M_WPStartup_classObj					-1	5
_M_WPStartup						-1	5
_M_WPStartupNew 					-1	5
M_WPStartupNew						-1	5
M_WPStartupRenew					-1	5
M_WPStartup_wpclsQueryDefaultHelp			-1	5
M_WPStartup_wpclsQueryTitle				-1	5
M_WPStartup_wpclsQueryIconData				-1	5
M_WPStartup_wpclsQueryStyle				-1	5
wpsystem_h						-1	5
WPSystem						-1	5
WPSystem_MajorVersion					-1	5
WPSystem_MinorVersion					-1	5
WPSystemNewClass					-1	5
WPSystemClassData					-1	5
WPSystemCClassData					-1	5
WPSystem_classObj					-1	5
_WPSystem						-1	5
_WPSystemNew						-1	5
WPSystemNew						-1	5
WPSystemRenew						-1	5
WPSystem_wpAddSettingsPages				-1	5
WPSystem_wpAddObjectWindowPage				-1	5
WPSystem_wpFilterPopupMenu				-1	5
WPSystem_wpRestoreState 				-1	5
WPSystem_wpSaveState					-1	5
somMD_WPSystem_wpAddSystemWindowPage			-1	5
WPSystem_wpAddSystemWindowPage				-1	5
_wpAddSystemWindowPage					-1	5
somMD_WPSystem_wpAddSystemLogoPage			-1	5
WPSystem_wpAddSystemLogoPage				-1	5
_wpAddSystemLogoPage					-1	5
somMD_WPSystem_wpAddSystemPrintScreenPage		-1	5
WPSystem_wpAddSystemPrintScreenPage			-1	5
_wpAddSystemPrintScreenPage				-1	5
somMD_WPSystem_wpAddSystemConfirmationPage		-1	5
WPSystem_wpAddSystemConfirmationPage			-1	5
_wpAddSystemConfirmationPage				-1	5
somMD_WPSystem_wpAddTitleConfirmationPage		-1	5
WPSystem_wpAddTitleConfirmationPage			-1	5
_wpAddTitleConfirmationPage				-1	5
somMD_WPSystem_wpAddSystemScreenPage			-1	5
WPSystem_wpAddSystemScreenPage				-1	5
_wpAddSystemScreenPage					-1	5
somMD_WPSystem_wpAddDMQSDisplayTypePage 		-1	5
WPSystem_wpAddDMQSDisplayTypePage			-1	5
_wpAddDMQSDisplayTypePage				-1	5
wpsystem_mh						-1	5
M_WPSystem						-1	5
M_WPSystem_MajorVersion 				-1	5
M_WPSystem_MinorVersion 				-1	5
M_WPSystemNewClass					-1	5
M_WPSystemClassData					-1	5
M_WPSystemCClassData					-1	5
M_WPSystem_classObj					-1	5
_M_WPSystem						-1	5
_M_WPSystemNew						-1	5
M_WPSystemNew						-1	5
M_WPSystemRenew 					-1	5
M_WPSystem_wpclsQueryTitle				-1	5
M_WPSystem_wpclsQueryDefaultHelp			-1	5
M_WPSystem_wpclsQueryDefaultView			-1	5
M_WPSystem_wpclsQueryStyle				-1	5
M_WPSystem_wpclsQueryIconData				-1	5
M_WPSystem_wpclsQuerySettingsPageSize			-1	5
wptemps_h						-1	5
WPTemplates						-1	5
WPTemplates_MajorVersion				-1	5
WPTemplates_MinorVersion				-1	5
WPTemplatesNewClass					-1	5
WPTemplatesClassData					-1	5
WPTemplatesCClassData					-1	5
WPTemplates_classObj					-1	5
_WPTemplates						-1	5
_WPTemplatesNew 					-1	5
WPTemplatesNew						-1	5
WPTemplatesRenew					-1	5
WPTemplates_wpPopulate					-1	5
WPTemplates_wpSetup					-1	5
wptemps_mh						-1	5
M_WPTemplates						-1	5
M_WPTemplates_MajorVersion				-1	5
M_WPTemplates_MinorVersion				-1	5
M_WPTemplatesNewClass					-1	5
M_WPTemplatesClassData					-1	5
M_WPTemplatesCClassData 				-1	5
M_WPTemplates_classObj					-1	5
_M_WPTemplates						-1	5
_M_WPTemplatesNew					-1	5
M_WPTemplatesNew					-1	5
M_WPTemplatesRenew					-1	5
M_WPTemplates_wpclsQueryTitle				-1	5
M_WPTemplates_wpclsQueryIconData			-1	5
M_WPTemplates_wpclsQueryStyle				-1	5
wptrans_h						-1	5
WPTransient						-1	5
WPTransient_MajorVersion				-1	5
WPTransient_MinorVersion				-1	5
WPTransientNewClass					-1	5
WPTransientClassData					-1	5
WPTransientCClassData					-1	5
WPTransient_classObj					-1	5
_WPTransient						-1	5
_WPTransientNew 					-1	5
WPTransientNew						-1	5
WPTransientRenew					-1	5
WPTransient_wpQueryHandle				-1	5
WPTransient_wpCopyObject				-1	5
WPTransient_wpSaveDeferred				-1	5
wptrans_mh						-1	5
M_WPTransient						-1	5
M_WPTransient_MajorVersion				-1	5
M_WPTransient_MinorVersion				-1	5
M_WPTransientNewClass					-1	5
M_WPTransientClassData					-1	5
M_WPTransientCClassData 				-1	5
M_WPTransient_classObj					-1	5
_M_WPTransient						-1	5
_M_WPTransientNew					-1	5
M_WPTransientNew					-1	5
M_WPTransientRenew					-1	5
M_WPTransient_wpclsQueryTitle				-1	5
M_WPTransient_wpclsQueryStyle				-1	5
DosBeep 						-1	5
DosExit 						-1	5
DosCreateThread 					-1	5
DosResumeThread 					-1	5
DosSuspendThread					-1	5
DosGetInfoBlocks					-1	5
DosKillThread						-1	5
DosWaitChild						-1	5
DosWaitThread						-1	5
DosSleep						-1	5
DosDebug						-1	5
DosEnterCritSec 					-1	5
DosExitCritSec						-1	5
DosExitList						-1	5
DosExecPgm						-1	5
DosSetPriority						-1	5
DosKillProcess						-1	5
DosSetFileLocks 					-1	5
DosProtectSetFileLocks					-1	5
DosCancelLockRequest					-1	5
DosOpen 						-1	5
DosProtectOpen						-1	5
DosClose						-1	5
DosProtectClose 					-1	5
DosRead 						-1	5
DosProtectRead						-1	5
DosWrite						-1	5
DosProtectWrite 					-1	5
DosDelete						-1	5
DosForceDelete						-1	5
DosDupHandle						-1	5
DosQueryFHState 					-1	5
DosProtectQueryFHState					-1	5
DosSetFHState						-1	5
DosProtectSetFHState					-1	5
DosQueryHType						-1	5
DosFindFirst						-1	5
DosFindNext						-1	5
DosFindClose						-1	5
DosFSAttach						-1	5
DosQueryFSAttach					-1	5
DosFSCtl						-1	5
DosSetFileSize						-1	5
DosProtectSetFileSize					-1	5
DosResetBuffer						-1	5
DosSetFilePtr						-1	5
DosProtectSetFilePtr					-1	5
DosMove 						-1	5
DosCopy 						-1	5
DosEditName						-1	5
DosCreateDir						-1	5
DosDeleteDir						-1	5
DosSetDefaultDisk					-1	5
DosQueryCurrentDisk					-1	5
DosSetCurrentDir					-1	5
DosQueryCurrentDir					-1	5
DosQueryFSInfo						-1	5
DosSetFSInfo						-1	5
DosQueryVerify						-1	5
DosSetVerify						-1	5
DosSetMaxFH						-1	5
DosSetRelMaxFH						-1	5
DosQueryFileInfo					-1	5
DosProtectQueryFileInfo 				-1	5
DosSetFileInfo						-1	5
DosProtectSetFileInfo					-1	5
DosQueryPathInfo					-1	5
DosSetPathInfo						-1	5
DosShutdown						-1	5
DosEnumAttribute					-1	5
DosProtectEnumAttribute 				-1	5
DosAllocMem						-1	5
DosFreeMem						-1	5
DosSetMem						-1	5
DosGiveSharedMem					-1	5
DosGetSharedMem 					-1	5
DosGetNamedSharedMem					-1	5
DosAllocSharedMem					-1	5
DosQueryMem						-1	5
DosSubAllocMem						-1	5
DosSubFreeMem						-1	5
DosSubSetMem						-1	5
DosSubUnsetMem						-1	5
DosCreateEventSem					-1	5
DosOpenEventSem 					-1	5
DosCloseEventSem					-1	5
DosResetEventSem					-1	5
DosPostEventSem 					-1	5
DosWaitEventSem 					-1	5
DosQueryEventSem					-1	5
DosCreateMutexSem					-1	5
DosOpenMutexSem 					-1	5
DosCloseMutexSem					-1	5
DosRequestMutexSem					-1	5
DosReleaseMutexSem					-1	5
DosQueryMutexSem					-1	5
DosCreateMuxWaitSem					-1	5
DosOpenMuxWaitSem					-1	5
DosCloseMuxWaitSem					-1	5
DosWaitMuxWaitSem					-1	5
DosAddMuxWaitSem					-1	5
DosDeleteMuxWaitSem					-1	5
DosQueryMuxWaitSem					-1	5
DosGetDateTime						-1	5
DosSetDateTime						-1	5
DosAsyncTimer						-1	5
DosStartTimer						-1	5
DosStopTimer						-1	5
DosLoadModule						-1	5
DosFreeModule						-1	5
DosQueryProcAddr					-1	5
DosQueryModuleHandle					-1	5
DosQueryModuleName					-1	5
DosQueryProcType					-1	5
DosGetResource						-1	5
DosFreeResource 					-1	5
DosQueryResourceSize					-1	5
DosQueryCtryInfo					-1	5
DosQueryDBCSEnv 					-1	5
DosMapCase						-1	5
DosQueryCollate 					-1	5
DosQueryCp						-1	5
DosSetProcessCp 					-1	5
DosSetExceptionHandler					-1	5
DosUnsetExceptionHandler				-1	5
DosRaiseException					-1	5
DosSendSignalException					-1	5
DosUnwindException					-1	5
DosSetSignalExceptionFocus				-1	5
DosEnterMustComplete					-1	5
DosExitMustComplete					-1	5
DosAcknowledgeSignalException				-1	5
DosCreatePipe						-1	5
DosCloseQueue						-1	5
DosCreateQueue						-1	5
DosOpenQueue						-1	5
DosPeekQueue						-1	5
DosPurgeQueue						-1	5
DosQueryQueue						-1	5
DosReadQueue						-1	5
DosWriteQueue						-1	5
DosError						-1	5
DosGetMessage						-1	5
DosErrClass						-1	5
DosInsertMessage					-1	5
DosPutMessage						-1	5
DosQuerySysInfo 					-1	5
DosScanEnv						-1	5
DosSearchPath						-1	5
DosQueryMessageCP					-1	5
DosQueryRASInfo 					-1	5
DosStartSession 					-1	5
DosSetSession						-1	5
DosSelectSession					-1	5
DosStopSession						-1	5
DosQueryAppType 					-1	5
DosDevConfig						-1	5
DosDevIOCtl						-1	5
DosPhysicalDisk 					-1	5
DosCallNPipe						-1	5
DosConnectNPipe 					-1	5
DosDisConnectNPipe					-1	5
DosCreateNPipe						-1	5
DosPeekNPipe						-1	5
DosQueryNPHState					-1	5
DosQueryNPipeInfo					-1	5
DosQueryNPipeSemState					-1	5
DosRawReadNPipe 					-1	5
DosRawWriteNPipe					-1	5
DosSetNPHState						-1	5
DosSetNPipeSem						-1	5
DosTransactNPipe					-1	5
DosWaitNPipe						-1	5
DosTmrQueryFreq 					-1	5
DosTmrQueryTime 					-1	5
DosRegisterPerfCtrs					-1	5
DosOpenVDD						-1	5
DosRequestVDD						-1	5
DosCloseVDD						-1	5
DosQueryDOSProperty					-1	5
DosSetDOSProperty					-1	5
KBD16REGISTER						-1	5
KBD16DEREGISTER 					-1	5
KBD16CHARIN						-1	5
KBD16PEEK						-1	5
KBD16STRINGIN						-1	5
KBD16FLUSHBUFFER					-1	5
KBD16SETSTATUS						-1	5
KBD16GETSTATUS						-1	5
KBD16SETCP						-1	5
KBD16GETCP						-1	5
KBD16OPEN						-1	5
KBD16CLOSE						-1	5
KBD16GETFOCUS						-1	5
KBD16FREEFOCUS						-1	5
KBD16SYNCH						-1	5
KBD16SETFGND						-1	5
KBD16GETHWID						-1	5
KBD16SETHWID						-1	5
KBD16XLATE						-1	5
KBD16SETCUSTXT						-1	5
VIO16REGISTER						-1	5
VioGlobalReg						-1	5
VIO16DEREGISTER 					-1	5
VIO16GETBUF						-1	5
VIO16GETCURPOS						-1	5
VIO16SETCURPOS						-1	5
VIO16GETCURTYPE 					-1	5
VIO16SETCURTYPE 					-1	5
VIO16GETMODE						-1	5
VIO16SETMODE						-1	5
VIO16GETPHYSBUF 					-1	5
VIO16READCELLSTR					-1	5
VIO16READCHARSTR					-1	5
VIO16WRTCELLSTR 					-1	5
VIO16WRTCHARSTR 					-1	5
VIO16SCROLLDN						-1	5
VIO16SCROLLUP						-1	5
VIO16SCROLLLF						-1	5
VIO16SCROLLRT						-1	5
VIO16WRTNATTR						-1	5
VIO16WRTNCELL						-1	5
VIO16WRTNCHAR						-1	5
VIO16WRTTTY						-1	5
VIO16WRTCHARSTRATT					-1	5
VIO16CHECKCHARTYPE					-1	5
VIO16SHOWBUF						-1	5
VIO16SETANSI						-1	5
VIO16GETANSI						-1	5
VIO16PRTSC						-1	5
VIO16PRTSCTOGGLE					-1	5
VIO16REDRAWSIZE 					-1	5
VIO16SAVREDRAWWAIT					-1	5
VIO16SAVREDRAWUNDO					-1	5
VIO16MODEWAIT						-1	5
VIO16MODEUNDO						-1	5
VIO16SCRLOCK						-1	5
VIO16SCRUNLOCK						-1	5
VIO16POPUP						-1	5
VIO16ENDPOPUP						-1	5
VIO16GETCONFIG						-1	5
VIO16GETFONT						-1	5
VIO16SETFONT						-1	5
VIO16GETCP						-1	5
VIO16SETCP						-1	5
VIO16GETSTATE						-1	5
VIO16SETSTATE						-1	5
MOU16REGISTER						-1	5
MOU16DEREGISTER 					-1	5
MOU16FLUSHQUE						-1	5
MOU16GETPTRPOS						-1	5
MOU16SETPTRPOS						-1	5
MOU16SETPTRSHAPE					-1	5
MOU16GETPTRSHAPE					-1	5
MOU16GETDEVSTATUS					-1	5
MOU16GETNUMBUTTONS					-1	5
MOU16GETNUMMICKEYS					-1	5
MOU16READEVENTQUE					-1	5
MOU16GETNUMQUEEL					-1	5
MOU16GETEVENTMASK					-1	5
MOU16SETEVENTMASK					-1	5
MOU16GETSCALEFACT					-1	5
MOU16SETSCALEFACT					-1	5
MOU16OPEN						-1	5
MOU16CLOSE						-1	5
MOU16REMOVEPTR						-1	5
MOU16DRAWPTR						-1	5
MOU16SETDEVSTATUS					-1	5
MOU16INITREAL						-1	5
MOU16SYNCH						-1	5
MOU16GETTHRESHOLD					-1	5
MOU16SETTHRESHOLD					-1	5
WinRegisterClass					-1	5
WinDefWindowProc					-1	5
WinDestroyWindow					-1	5
WinShowWindow						-1	5
WinQueryWindowRect					-1	5
WinGetPS						-1	5
WinReleasePS						-1	5
WinEndPaint						-1	5
WinGetClipPS						-1	5
WinIsWindowShowing					-1	5
WinBeginPaint						-1	5
WinOpenWindowDC 					-1	5
WinScrollWindow 					-1	5
WinFillRect						-1	5
WinQueryVersion 					-1	5
WinInitialize						-1	5
WinTerminate						-1	5
WinQueryAnchorBlock					-1	5
WinCreateWindow 					-1	5
WinEnableWindow 					-1	5
WinIsWindowEnabled					-1	5
WinEnableWindowUpdate					-1	5
WinIsWindowVisible					-1	5
WinQueryWindowText					-1	5
WinSetWindowText					-1	5
WinQueryWindowTextLength				-1	5
WinWindowFromID 					-1	5
WinIsWindow						-1	5
WinQueryWindow						-1	5
WinMultWindowFromIDs					-1	5
WinSetParent						-1	5
WinIsChild						-1	5
WinSetOwner						-1	5
WinQueryWindowProcess					-1	5
WinQueryObjectWindow					-1	5
WinQueryDesktopWindow					-1	5
WinSetWindowPos 					-1	5
WinSetMultWindowPos					-1	5
WinQueryWindowPos					-1	5
WinUpdateWindow 					-1	5
WinInvalidateRect					-1	5
WinInvalidateRegion					-1	5
WinInvertRect						-1	5
WinDrawBitmap						-1	5
WinDrawText						-1	5
WinDrawBorder						-1	5
WinLoadString						-1	5
WinLoadMessage						-1	5
WinSetActiveWindow					-1	5
WinSubclassWindow					-1	5
WinQueryClassName					-1	5
WinQueryClassInfo					-1	5
WinQueryActiveWindow					-1	5
WinIsThreadActive					-1	5
WinQuerySysModalWindow					-1	5
WinSetSysModalWindow					-1	5
WinQueryWindowUShort					-1	5
WinSetWindowUShort					-1	5
WinQueryWindowULong					-1	5
WinSetWindowULong					-1	5
WinQueryWindowPtr					-1	5
WinSetWindowPtr 					-1	5
WinSetWindowBits					-1	5
WinBeginEnumWindows					-1	5
WinGetNextWindow					-1	5
WinEndEnumWindows					-1	5
WinWindowFromPoint					-1	5
WinMapWindowPoints					-1	5
WinValidateRect 					-1	5
WinValidateRegion					-1	5
WinWindowFromDC 					-1	5
WinQueryWindowDC					-1	5
WinGetScreenPS						-1	5
WinLockWindowUpdate					-1	5
WinLockVisRegions					-1	5
WinQueryUpdateRect					-1	5
WinQueryUpdateRegion					-1	5
WinExcludeUpdateRegion					-1	5
WinSendMsg						-1	5
WinCreateMsgQueue					-1	5
WinDestroyMsgQueue					-1	5
WinQueryQueueInfo					-1	5
WinCancelShutdown					-1	5
WinGetMsg						-1	5
WinPeekMsg						-1	5
WinDispatchMsg						-1	5
WinPostMsg						-1	5
WinRegisterUserMsg					-1	5
WinRegisterUserDatatype 				-1	5
WinSetMsgMode						-1	5
WinSetSynchroMode					-1	5
WinInSendMsg						-1	5
WinBroadcastMsg 					-1	5
WinWaitMsg						-1	5
WinQueryQueueStatus					-1	5
WinQueryMsgPos						-1	5
WinQueryMsgTime 					-1	5
WinWaitEventSem 					-1	5
WinRequestMutexSem					-1	5
WinWaitMuxWaitSem					-1	5
WinPostQueueMsg 					-1	5
WinSetMsgInterest					-1	5
WinSetClassMsgInterest					-1	5
WinSetFocus						-1	5
WinFocusChange						-1	5
WinLockupSystem 					-1	5
WinUnlockSystem 					-1	5
WinSetCapture						-1	5
WinQueryCapture 					-1	5
WinCheckInput						-1	5
WinQueryFocus						-1	5
WinGetKeyState						-1	5
WinGetPhysKeyState					-1	5
WinEnablePhysInput					-1	5
WinIsPhysInputEnabled					-1	5
WinSetKeyboardStateTable				-1	5
WinGetDlgMsg						-1	5
WinLoadDlg						-1	5
WinDlgBox						-1	5
WinDismissDlg						-1	5
WinQueryDlgItemShort					-1	5
WinSetDlgItemShort					-1	5
WinSetDlgItemText					-1	5
WinQueryDlgItemText					-1	5
WinQueryDlgItemTextLength				-1	5
WinDefDlgProc						-1	5
WinAlarm						-1	5
WinMessageBox						-1	5
WinProcessDlg						-1	5
WinSendDlgItemMsg					-1	5
WinMapDlgPoints 					-1	5
WinEnumDlgItem						-1	5
WinSubstituteStrings					-1	5
WinCreateDlg						-1	5
WinLoadMenu						-1	5
WinCreateMenu						-1	5
WinPopupMenu						-1	5
WinCreateStdWindow					-1	5
WinFlashWindow						-1	5
WinCreateFrameControls					-1	5
WinCalcFrameRect					-1	5
WinGetMinPosition					-1	5
WinGetMaxPosition					-1	5
WinSaveWindowPos					-1	5
WinCopyRect						-1	5
WinSetRect						-1	5
WinIsRectEmpty						-1	5
WinEqualRect						-1	5
WinSetRectEmpty 					-1	5
WinOffsetRect						-1	5
WinInflateRect						-1	5
WinPtInRect						-1	5
WinIntersectRect					-1	5
WinUnionRect						-1	5
WinSubtractRect 					-1	5
WinMakeRect						-1	5
WinMakePoints						-1	5
WinQuerySysValue					-1	5
WinSetSysValue						-1	5
WinSetPresParam 					-1	5
WinQueryPresParam					-1	5
WinRemovePresParam					-1	5
WinQuerySysColor					-1	5
WinSetSysColors 					-1	5
WinStartTimer						-1	5
WinStopTimer						-1	5
WinGetCurrentTime					-1	5
WinLoadAccelTable					-1	5
WinCopyAccelTable					-1	5
WinCreateAccelTable					-1	5
WinDestroyAccelTable					-1	5
WinTranslateAccel					-1	5
WinSetAccelTable					-1	5
WinQueryAccelTable					-1	5
WinTrackRect						-1	5
WinShowTrackRect					-1	5
WinSetClipbrdOwner					-1	5
WinSetClipbrdData					-1	5
WinQueryClipbrdData					-1	5
WinQueryClipbrdFmtInfo					-1	5
WinSetClipbrdViewer					-1	5
WinEnumClipbrdFmts					-1	5
WinEmptyClipbrd 					-1	5
WinOpenClipbrd						-1	5
WinCloseClipbrd 					-1	5
WinQueryClipbrdOwner					-1	5
WinQueryClipbrdViewer					-1	5
WinDestroyCursor					-1	5
WinShowCursor						-1	5
WinCreateCursor 					-1	5
WinQueryCursorInfo					-1	5
WinSetPointer						-1	5
WinSetPointerOwner					-1	5
WinShowPointer						-1	5
WinLockPointerUpdate					-1	5
WinQuerySysPointer					-1	5
WinQuerySysPointerData					-1	5
WinSetSysPointerData					-1	5
WinLoadPointer						-1	5
WinCreatePointer					-1	5
WinSetPointerPos					-1	5
WinDestroyPointer					-1	5
WinQueryPointer 					-1	5
WinQueryPointerPos					-1	5
WinCreatePointerIndirect				-1	5
WinQueryPointerInfo					-1	5
WinDrawPointer						-1	5
WinGetSysBitmap 					-1	5
WinSetHook						-1	5
WinReleaseHook						-1	5
WinCallMsgFilter					-1	5
WinSetClassThunkProc					-1	5
WinQueryClassThunkProc					-1	5
WinSetWindowThunkProc					-1	5
WinQueryWindowThunkProc 				-1	5
WinQueryWindowModel					-1	5
PrfQueryProgramTitles					-1	5
PrfAddProgram						-1	5
PrfChangeProgram					-1	5
PrfQueryDefinition					-1	5
PrfRemoveProgram					-1	5
PrfQueryProgramHandle					-1	5
PrfCreateGroup						-1	5
PrfDestroyGroup 					-1	5
PrfQueryProgramCategory 				-1	5
WinStartApp						-1	5
WinTerminateApp 					-1	5
WinAddSwitchEntry					-1	5
WinRemoveSwitchEntry					-1	5
WinChangeSwitchEntry					-1	5
WinCreateSwitchEntry					-1	5
WinQuerySessionTitle					-1	5
WinQuerySwitchEntry					-1	5
WinQuerySwitchHandle					-1	5
WinQuerySwitchList					-1	5
WinQueryTaskSizePos					-1	5
WinQueryTaskTitle					-1	5
WinSwitchToProgram					-1	5
PrfQueryProfileInt					-1	5
PrfQueryProfileString					-1	5
PrfWriteProfileString					-1	5
PrfQueryProfileSize					-1	5
PrfQueryProfileData					-1	5
PrfWriteProfileData					-1	5
PrfOpenProfile						-1	5
PrfCloseProfile 					-1	5
PrfReset						-1	5
PrfQueryProfile 					-1	5
WinQueryCp						-1	5
WinSetCp						-1	5
WinQueryCpList						-1	5
WinCpTranslateString					-1	5
WinCpTranslateChar					-1	5
WinUpper						-1	5
WinUpperChar						-1	5
WinNextChar						-1	5
WinPrevChar						-1	5
WinCompareStrings					-1	5
WinQuerySystemAtomTable 				-1	5
WinCreateAtomTable					-1	5
WinDestroyAtomTable					-1	5
WinAddAtom						-1	5
WinFindAtom						-1	5
WinDeleteAtom						-1	5
WinQueryAtomUsage					-1	5
WinQueryAtomLength					-1	5
WinQueryAtomName					-1	5
WinGetLastError 					-1	5
WinGetErrorInfo 					-1	5
WinFreeErrorInfo					-1	5
WinSetErrorInfo 					-1	5
WinDdeInitiate						-1	5
WinDdeRespond						-1	5
WinDdePostMsg						-1	5
WinDestroyHelpInstance					-1	5
WinCreateHelpInstance					-1	5
WinAssociateHelpInstance				-1	5
WinQueryHelpInstance					-1	5
WinLoadHelpTable					-1	5
WinCreateHelpTable					-1	5
WinDeleteProcedure					-1	5
WinDeleteLibrary					-1	5
WinLoadProcedure					-1	5
WinLoadLibrary						-1	5
WinSetDesktopBkgnd					-1	5
WinQueryDesktopBkgnd					-1	5
WinRealizePalette					-1	5
GpiCreatePS						-1	5
GpiDestroyPS						-1	5
GpiAssociate						-1	5
GpiRestorePS						-1	5
GpiSavePS						-1	5
GpiErase						-1	5
GpiQueryDevice						-1	5
GpiResetPS						-1	5
GpiSetPS						-1	5
GpiQueryPS						-1	5
GpiErrorSegmentData					-1	5
GpiQueryDrawControl					-1	5
GpiSetDrawControl					-1	5
GpiQueryDrawingMode					-1	5
GpiSetDrawingMode					-1	5
GpiQueryStopDraw					-1	5
GpiSetStopDraw						-1	5
GpiCorrelateChain					-1	5
GpiQueryTag						-1	5
GpiSetTag						-1	5
GpiQueryPickApertureSize				-1	5
GpiSetPickApertureSize					-1	5
GpiQueryPickAperturePosition				-1	5
GpiSetPickAperturePosition				-1	5
GpiQueryBoundaryData					-1	5
GpiResetBoundaryData					-1	5
GpiCorrelateFrom					-1	5
GpiCorrelateSegment					-1	5
GpiOpenSegment						-1	5
GpiCloseSegment 					-1	5
GpiDeleteSegment					-1	5
GpiQueryInitialSegmentAttrs				-1	5
GpiSetInitialSegmentAttrs				-1	5
GpiQuerySegmentAttrs					-1	5
GpiSetSegmentAttrs					-1	5
GpiQuerySegmentPriority 				-1	5
GpiSetSegmentPriority					-1	5
GpiDeleteSegments					-1	5
GpiQuerySegmentNames					-1	5
GpiGetData						-1	5
GpiPutData						-1	5
GpiDrawChain						-1	5
GpiDrawFrom						-1	5
GpiDrawSegment						-1	5
GpiDrawDynamics 					-1	5
GpiRemoveDynamics					-1	5
GpiBeginElement 					-1	5
GpiEndElement						-1	5
GpiLabel						-1	5
GpiElement						-1	5
GpiQueryElement 					-1	5
GpiDeleteElement					-1	5
GpiDeleteElementRange					-1	5
GpiDeleteElementsBetweenLabels				-1	5
GpiQueryEditMode					-1	5
GpiSetEditMode						-1	5
GpiQueryElementPointer					-1	5
GpiSetElementPointer					-1	5
GpiOffsetElementPointer 				-1	5
GpiQueryElementType					-1	5
GpiSetElementPointerAtLabel				-1	5
GpiQuerySegmentTransformMatrix				-1	5
GpiSetSegmentTransformMatrix				-1	5
GpiConvert						-1	5
GpiConvertWithMatrix					-1	5
GpiQueryModelTransformMatrix				-1	5
GpiSetModelTransformMatrix				-1	5
GpiCallSegmentMatrix					-1	5
GpiQueryDefaultViewMatrix				-1	5
GpiSetDefaultViewMatrix 				-1	5
GpiQueryPageViewport					-1	5
GpiSetPageViewport					-1	5
GpiQueryViewingTransformMatrix				-1	5
GpiSetViewingTransformMatrix				-1	5
GpiTranslate						-1	5
GpiScale						-1	5
GpiRotate						-1	5
GpiSetGraphicsField					-1	5
GpiQueryGraphicsField					-1	5
GpiSetViewingLimits					-1	5
GpiQueryViewingLimits					-1	5
GpiBeginPath						-1	5
GpiEndPath						-1	5
GpiCloseFigure						-1	5
GpiModifyPath						-1	5
GpiFillPath						-1	5
GpiSetClipPath						-1	5
GpiOutlinePath						-1	5
GpiPathToRegion 					-1	5
GpiStrokePath						-1	5
GpiCreateLogColorTable					-1	5
GpiQueryColorData					-1	5
GpiQueryLogColorTable					-1	5
GpiQueryRealColors					-1	5
GpiQueryNearestColor					-1	5
GpiQueryColorIndex					-1	5
GpiQueryRGBColor					-1	5
GpiCreatePalette					-1	5
GpiDeletePalette					-1	5
GpiSelectPalette					-1	5
GpiAnimatePalette					-1	5
GpiSetPaletteEntries					-1	5
GpiQueryPalette 					-1	5
GpiQueryPaletteInfo					-1	5
GpiSetColor						-1	5
GpiQueryColor						-1	5
GpiBox							-1	5
GpiMove 						-1	5
GpiLine 						-1	5
GpiPolyLine						-1	5
GpiPolyLineDisjoint					-1	5
GpiSetPattern						-1	5
GpiQueryPattern 					-1	5
GpiBeginArea						-1	5
GpiEndArea						-1	5
GpiCharString						-1	5
GpiCharStringAt 					-1	5
GpiSetAttrMode						-1	5
GpiQueryAttrMode					-1	5
GpiSetAttrs						-1	5
GpiQueryAttrs						-1	5
GpiSetBackColor 					-1	5
GpiQueryBackColor					-1	5
GpiSetMix						-1	5
GpiQueryMix						-1	5
GpiSetBackMix						-1	5
GpiQueryBackMix 					-1	5
GpiSetLineType						-1	5
GpiQueryLineType					-1	5
GpiSetLineWidth 					-1	5
GpiQueryLineWidth					-1	5
GpiSetLineWidthGeom					-1	5
GpiQueryLineWidthGeom					-1	5
GpiSetLineEnd						-1	5
GpiQueryLineEnd 					-1	5
GpiSetLineJoin						-1	5
GpiQueryLineJoin					-1	5
GpiSetCurrentPosition					-1	5
GpiQueryCurrentPosition 				-1	5
GpiSetArcParams 					-1	5
GpiQueryArcParams					-1	5
GpiPointArc						-1	5
GpiFullArc						-1	5
GpiPartialArc						-1	5
GpiPolyFillet						-1	5
GpiPolySpline						-1	5
GpiPolyFilletSharp					-1	5
GpiSetPatternSet					-1	5
GpiQueryPatternSet					-1	5
GpiSetPatternRefPoint					-1	5
GpiQueryPatternRefPoint 				-1	5
GpiQueryCharStringPos					-1	5
GpiQueryCharStringPosAt 				-1	5
GpiQueryTextBox 					-1	5
GpiQueryDefCharBox					-1	5
GpiSetCharSet						-1	5
GpiQueryCharSet 					-1	5
GpiSetCharBox						-1	5
GpiQueryCharBox 					-1	5
GpiSetCharAngle 					-1	5
GpiQueryCharAngle					-1	5
GpiSetCharShear 					-1	5
GpiQueryCharShear					-1	5
GpiSetCharDirection					-1	5
GpiQueryCharDirection					-1	5
GpiSetCharMode						-1	5
GpiQueryCharMode					-1	5
GpiSetTextAlignment					-1	5
GpiQueryTextAlignment					-1	5
GpiCharStringPos					-1	5
GpiCharStringPosAt					-1	5
GpiSetCharExtra 					-1	5
GpiSetCharBreakExtra					-1	5
GpiQueryCharExtra					-1	5
GpiQueryCharBreakExtra					-1	5
GpiMarker						-1	5
GpiPolyMarker						-1	5
GpiSetMarker						-1	5
GpiSetMarkerBox 					-1	5
GpiSetMarkerSet 					-1	5
GpiQueryMarker						-1	5
GpiQueryMarkerBox					-1	5
GpiQueryMarkerSet					-1	5
GpiImage						-1	5
GpiPop							-1	5
GpiPtVisible						-1	5
GpiRectVisible						-1	5
GpiComment						-1	5
GpiCreateLogFont					-1	5
GpiDeleteSetId						-1	5
GpiLoadFonts						-1	5
GpiUnloadFonts						-1	5
GpiQueryFonts						-1	5
GpiQueryFontMetrics					-1	5
GpiQueryKerningPairs					-1	5
GpiQueryWidthTable					-1	5
GpiQueryNumberSetIds					-1	5
GpiQuerySetIds						-1	5
GpiQueryFaceString					-1	5
GpiQueryLogicalFont					-1	5
GpiQueryFontAction					-1	5
GpiLoadPublicFonts					-1	5
GpiUnloadPublicFonts					-1	5
GpiSetCp						-1	5
GpiQueryCp						-1	5
GpiQueryFullFontFileDescs				-1	5
GpiQueryFontFileDescriptions				-1	5
GpiBitBlt						-1	5
GpiDeleteBitmap 					-1	5
GpiLoadBitmap						-1	5
GpiSetBitmap						-1	5
GpiWCBitBlt						-1	5
GpiCreateBitmap 					-1	5
GpiSetBitmapBits					-1	5
GpiSetBitmapDimension					-1	5
GpiSetBitmapId						-1	5
GpiQueryBitmapBits					-1	5
GpiQueryBitmapDimension 				-1	5
GpiQueryBitmapHandle					-1	5
GpiQueryBitmapParameters				-1	5
GpiQueryBitmapInfoHeader				-1	5
GpiQueryDeviceBitmapFormats				-1	5
GpiSetPel						-1	5
GpiQueryPel						-1	5
GpiFloodFill						-1	5
GpiDrawBits						-1	5
GpiCombineRegion					-1	5
GpiCreateRegion 					-1	5
GpiDestroyRegion					-1	5
GpiEqualRegion						-1	5
GpiOffsetRegion 					-1	5
GpiPaintRegion						-1	5
GpiFrameRegion						-1	5
GpiPtInRegion						-1	5
GpiQueryRegionBox					-1	5
GpiQueryRegionRects					-1	5
GpiRectInRegion 					-1	5
GpiSetRegion						-1	5
GpiSetClipRegion					-1	5
GpiQueryClipRegion					-1	5
GpiQueryClipBox 					-1	5
GpiExcludeClipRectangle 				-1	5
GpiIntersectClipRectangle				-1	5
GpiOffsetClipRegion					-1	5
GpiCopyMetaFile 					-1	5
GpiDeleteMetaFile					-1	5
GpiLoadMetaFile 					-1	5
GpiPlayMetaFile 					-1	5
GpiQueryMetaFileBits					-1	5
GpiQueryMetaFileLength					-1	5
GpiSaveMetaFile 					-1	5
GpiSetMetaFileBits					-1	5
GpiQueryDefArcParams					-1	5
GpiQueryDefAttrs					-1	5
GpiQueryDefTag						-1	5
GpiQueryDefViewingLimits				-1	5
GpiSetDefArcParams					-1	5
GpiSetDefAttrs						-1	5
GpiSetDefTag						-1	5
GpiSetDefViewingLimits					-1	5
GpiPolygons						-1	5
DevOpenDC						-1	5
DevCloseDC						-1	5
DevQueryCaps						-1	5
DevEscape						-1	5
DevQueryDeviceNames					-1	5
DevQueryHardcopyCaps					-1	5
DevPostDeviceModes					-1	5
WinRegisterObjectClass					-1	5
WinDeregisterObjectClass				-1	5
WinReplaceObjectClass					-1	5
WinEnumObjectClasses					-1	5
WinCreateObject 					-1	5
WinSetObjectData					-1	5
WinDestroyObject					-1	5
WinQueryObject						-1	5
WinSetFileIcon						-1	5
WinFreeFileIcon 					-1	5
WinLoadFileIcon 					-1	5
WinStoreWindowPos					-1	5
WinRestoreWindowPos					-1	5
WinShutdownSystem					-1	5
VIO16ASSOCIATE						-1	5
VIO16CREATELOGFONT					-1	5
VIO16CREATEPS						-1	5
VIO16DELETESETID					-1	5
VIO16DESTROYPS						-1	5
VIO16GETDEVICECELLSIZE					-1	5
VIO16GETORG						-1	5
VIO16QUERYFONTS 					-1	5
VIO16QUERYSETIDS					-1	5
VIO16SETDEVICECELLSIZE					-1	5
VIO16SETORG						-1	5
VIO16SHOWPS						-1	5
WIN16DEFAVIOWINDOWPROC					-1	5
SplQpOpen						-1	5
SplQpPrint						-1	5
SplQpClose						-1	5
SplQpControl						-1	5
SplQpQueryDt						-1	5
SplQpInstall						-1	5
SplQpQueryFlags 					-1	5
SplQmOpen						-1	5
SplQmStartDoc						-1	5
SplQmWrite						-1	5
SplQmEndDoc						-1	5
SplQmClose						-1	5
SplQmAbort						-1	5
SplQmAbortDoc						-1	5
SplMessageBox						-1	5
SplStdOpen						-1	5
SplStdClose						-1	5
SplStdStart						-1	5
SplStdStop						-1	5
SplStdDelete						-1	5
SplStdGetBits						-1	5
SplStdQueryLength					-1	5
SplCreateDevice 					-1	5
SplControlDevice					-1	5
SplDeleteDevice 					-1	5
SplEnumDevice						-1	5
SplQueryDevice						-1	5
SplSetDevice						-1	5
SplReleaseJob						-1	5
SplDeleteJob						-1	5
SplEnumJob						-1	5
SplQueryJob						-1	5
SplHoldJob						-1	5
SplSetJob						-1	5
SplCreateQueue						-1	5
SplReleaseQueue 					-1	5
SplDeleteQueue						-1	5
SplEnumQueue						-1	5
SplQueryQueue						-1	5
SplHoldQueue						-1	5
SplPurgeQueue						-1	5
SplSetQueue						-1	5
SplEnumDriver						-1	5
SplEnumPort						-1	5
SplEnumQueueProcessor					-1	5
SplEnumPrinter						-1	5
SplCopyJob						-1	5
PicPrint						-1	5
PicIchg 						-1	5
WinFileDlg						-1	5
WinDefFileDlgProc					-1	5
WinFreeFileDlgList					-1	5
WinFontDlg						-1	5
WinDefFontDlgProc					-1	5
DrgAcceptDroppedFiles					-1	5
DrgAllocDraginfo					-1	5
DrgAllocDragtransfer					-1	5
DrgDrag 						-1	5
DrgDragFiles						-1	5
DrgPostTransferMsg					-1	5
DrgQueryDragitem					-1	5
DrgQueryDragitemCount					-1	5
DrgQueryDragitemPtr					-1	5
DrgQueryNativeRMF					-1	5
DrgQueryNativeRMFLen					-1	5
DrgQueryStrName 					-1	5
DrgQueryStrNameLen					-1	5
DrgQueryTrueType					-1	5
DrgQueryTrueTypeLen					-1	5
DrgSendTransferMsg					-1	5
DrgSetDragitem						-1	5
DrgSetDragImage 					-1	5
DrgVerifyTypeSet					-1	5
DrgAccessDraginfo					-1	5
DrgAddStrHandle 					-1	5
DrgDeleteDraginfoStrHandles				-1	5
DrgDeleteStrHandle					-1	5
DrgFreeDraginfo 					-1	5
DrgFreeDragtransfer					-1	5
DrgGetPS						-1	5
DrgPushDraginfo 					-1	5
DrgReleasePS						-1	5
DrgSetDragPointer					-1	5
DrgVerifyNativeRMF					-1	5
DrgVerifyRMF						-1	5
DrgVerifyTrueType					-1	5
DrgVerifyType						-1	5
_QWORD							-1	5
_POINTL 						-1	5
_POINTS 						-1	5
_RECTL							-1	5
_DRIVDATA						-1	5
_DEVOPENSTRUC						-1	5
_PRINTDEST						-1	5
_FATTRS 						-1	5
_PANOSE 						-1	5
_FONTMETRICS						-1	5
_ICONINFO						-1	5
tib2_s							-1	5
tib2_s							-1	5
tib2_s							-1	5
tib_s							-1	5
tib_s							-1	5
tib_s							-1	5
tib_s							-1	5
pib_s							-1	5
pib_s							-1	5
pib_s							-1	5
pib_s							-1	5
_RESULTCODES						-1	5
_uDB							-1	5
_EASIZEBUF						-1	5
_FSQBUFFER						-1	5
_FSQBUFFER2						-1	5
_SPOOLATTACH						-1	5
_FTIME							-1	5
_FDATE							-1	5
_VOLUMELABEL						-1	5
_FSINFO 						-1	5
_FILELOCK						-1	5
_FILEFINDBUF						-1	5
_FILEFINDBUF2						-1	5
_FILEFINDBUF3						-1	5
_FILEFINDBUF4						-1	5
_GEA							-1	5
_GEALIST						-1	5
_FEA							-1	5
_FEALIST						-1	5
_EAOP							-1	5
_FEA2							-1	5
_FEA2LIST						-1	5
_GEA2							-1	5
_GEA2LIST						-1	5
_EAOP2							-1	5
_FILESTATUS						-1	5
_FILESTATUS2						-1	5
_FILESTATUS3						-1	5
_FILESTATUS4						-1	5
_FSALLOCATE						-1	5
_DENA1							-1	5
_PSEMRECORD						-1	5
_DATETIME						-1	5
_COUNTRYCODE						-1	5
_COUNTRYINFO						-1	5
_fpreg							-1	5
_CONTEXT						-1	5
_EXCEPTIONREPORTRECORD					-1	5
_EXCEPTIONREGISTRATIONRECORD				-1	5
_REQUESTDATA						-1	5
_STARTDATA						-1	5
_STATUSDATA						-1	5
_AVAILDATA						-1	5
_PIPEINFO						-1	5
_PIPESEMSTATE						-1	5
_KBDKEYINFO						-1	5
_STRINGINBUF						-1	5
_KBDINFO						-1	5
_KBDHWID						-1	5
_KBDTRANS						-1	5
_VIOCURSORINFO						-1	5
_VIOMODEINFO						-1	5
_VIOPHYSBUF						-1	5
_VIOCONFIGINFO						-1	5
_VIOFONTINFO						-1	5
_VIOPALSTATE						-1	5
_VIOOVERSCAN						-1	5
_VIOINTENSITY						-1	5
_VIOCOLORREG						-1	5
_VIOSETULINELOC 					-1	5
_VIOSETTARGET						-1	5
_PTRLOC 						-1	5
_PTRSHAPE						-1	5
_MOUEVENTINFO						-1	5
_MOUQUEINFO						-1	5
_SCALEFACT						-1	5
_NOPTRRECT						-1	5
_THRESHOLD						-1	5
_QVERSDATA						-1	5
_SWP							-1	5
_CREATESTRUCT						-1	5
_CLASSINFO						-1	5
_QMSG							-1	5
_COMMANDMSG						-1	5
_MQINFO 						-1	5
_WNDPARAMS						-1	5
_MOUSEMSG						-1	5
_CHARMSG						-1	5
_DLGTITEM						-1	5
_DLGTEMPLATE						-1	5
_BTNCDATA						-1	5
_USERBUTTON						-1	5
_ENTRYFDATA						-1	5
_FORMATRECT						-1	5
_MLECTLDATA						-1	5
_MLEOVERFLOW						-1	5
_MLEMARGSTRUCT						-1	5
_SEARCH 						-1	5
_mti							-1	5
_mt							-1	5
_OWNERITEM						-1	5
_MENUITEM						-1	5
_SBCDATA						-1	5
_FRAMECDATA						-1	5
_PARAM							-1	5
_PRESPARAMS						-1	5
_ACCEL							-1	5
_ACCELTABLE						-1	5
_TRACKINFO						-1	5
_MFP							-1	5
_CPTEXT 						-1	5
_CURSORINFO						-1	5
_POINTERINFO						-1	5
_SMHSTRUCT						-1	5
_PRFPROFILE						-1	5
_HPROGARRAY						-1	5
_PROGTYPE						-1	5
_PROGDETAILS						-1	5
_PROGTITLE						-1	5
_SWCNTRL						-1	5
_SWENTRY						-1	5
_SWBLOCK						-1	5
_ERRINFO						-1	5
_CONVCONTEXT						-1	5
_DDEINIT						-1	5
_DDESTRUCT						-1	5
_HELPTABLE						-1	5
_HELPINIT						-1	5
_ACVP							-1	5
_DESKTOP						-1	5
_SIZEL							-1	5
_MATRIXLF						-1	5
_ARCPARAMS						-1	5
_SIZEF							-1	5
_GRADIENTL						-1	5
_LINEBUNDLE						-1	5
_CHARBUNDLE						-1	5
_MARKERBUNDLE						-1	5
_AREABUNDLE						-1	5
_IMAGEBUNDLE						-1	5
_KERNINGPAIRS						-1	5
_FACENAMEDESC						-1	5
_FFDESCS2						-1	5
_BITMAPINFOHEADER					-1	5
_RGB							-1	5
_BITMAPINFO						-1	5
_BITMAPINFOHEADER2					-1	5
_RGB2							-1	5
_BITMAPINFO2						-1	5
_BITMAPFILEHEADER					-1	5
_BITMAPARRAYFILEHEADER					-1	5
_BITMAPFILEHEADER2					-1	5
_BITMAPARRAYFILEHEADER2 				-1	5
_RGNRECT						-1	5
_POLYGON						-1	5
_POLYSET						-1	5
_VIOSIZECOUNT						-1	5
_VIOFONTCELLSIZE					-1	5
_SFACTORS						-1	5
_BANDRECT						-1	5
_ESCMODE						-1	5
_HCINFO 						-1	5
_OBJECTIMAGE						-1	5
_OBJCLASS						-1	5
_PAGEINFO						-1	5
_ICONPOS						-1	5
_SQPOPENDATA						-1	5
_RECT1S 						-1	5
_ODPOINT						-1	5
_SIZES							-1	5
_SWPUSHORT						-1	5
_ORDER							-1	5
_LORDER 						-1	5
_ORDERS_GCARC						-1	5
_ORDERL_GCARC						-1	5
_ORDER_GBEL						-1	5
_ORDER_GCBIMG						-1	5
_ORDER_GBPTH						-1	5
_ORDERS_GCBOX						-1	5
_ORDERL_GCBOX						-1	5
_ORDER_GCALLS						-1	5
_ORDER_GFPTH						-1	5
_ORDER_GOPTH						-1	5
_ORDER_GMPTH						-1	5
_ORDERS_GCPARC						-1	5
_ORDERL_GCPARC						-1	5
_ORDER_GSCPTH						-1	5
_ORDERS_GSAP						-1	5
_ORDERL_GSAP						-1	5
_ORDER_GSBICOL						-1	5
_ORDERS_GSCC						-1	5
_ORDERL_GSCC						-1	5
_ORDERS_GSMC						-1	5
_ORDERL_GSMC						-1	5
_ORDERS_GSPRP						-1	5
_ORDERL_GSPRP						-1	5
_ORDER_GSIA						-1	5
_ORDERS_GSTM						-1	5
_ORDERL_GSTM						-1	5
_ORDERS_GSSB						-1	5
_ORDERL_GSSB						-1	5
_ORDER_GSGCH						-1	5
_ORDERS_GSSLW						-1	5
_ORDERL_GSSLW						-1	5
_ORDERS_GCSFLT						-1	5
_ORDERL_GCSFLT						-1	5
_ORDERS_GBBLT						-1	5
_ORDERL_GBBLT						-1	5
_ORDER_GSCBE						-1	5
_ORDER_GESCP						-1	5
_ORDERL_GEBB						-1	5
_ORDERL_GEDB						-1	5
_ORDERL_GEFF						-1	5
_VORDER 						-1	5
_ORDERS_GCCHSTE 					-1	5
_ORDERL_GCCHSTE 					-1	5
_ORDER_GEESCP						-1	5
_FOCAMETRICS						-1	5
_FONTFILEMETRICS					-1	5
_FONTDEFINITIONHEADER					-1	5
_FONTSIGNATURE						-1	5
_ADDITIONALMETRICS					-1	5
_FOCAFONT						-1	5
_FILEDLG						-1	5
_FONTDLG						-1	5
_STYLECHANGE						-1	5
_DRAGITEM						-1	5
_DRAGINFO						-1	5
_DRAGIMAGE						-1	5
_DRAGTRANSFER						-1	5
_RENDERFILE						-1	5
_TREEITEMDESC						-1	5
_FIELDINFO						-1	5
_RECORDCORE						-1	5
_MINIRECORDCORE 					-1	5
_CNRINFO						-1	5
_CDATE							-1	5
_CTIME							-1	5
_CNRDRAGINIT						-1	5
_FIELDINFOINSERT					-1	5
_RECORDINSERT						-1	5
_QUERYRECFROMRECT					-1	5
_QUERYRECORDRECT					-1	5
_SEARCHSTRING						-1	5
_CNRDRAGINFO						-1	5
_NOTIFYRECORDEMPHASIS					-1	5
_NOTIFYRECORDENTER					-1	5
_NOTIFYDELTA						-1	5
_NOTIFYSCROLL						-1	5
_CNREDITDATA						-1	5
_OWNERBACKGROUND					-1	5
_CNRDRAWITEMINFO					-1	5
_SLDCDATA						-1	5
_VSCDATA						-1	5
_VSDRAGINIT						-1	5
_VSDRAGINFO						-1	5
_VSTEXT 						-1	5
_BOOKTEXT						-1	5
_DELETENOTIFY						-1	5
_PAGESELECTNOTIFY					-1	5
APIRET16						-1	5
APIRET32						-1	5
SHANDLE 						-1	5
LHANDLE 						-1	5
UCHAR							-1	5
USHORT							-1	5
ULONG							-1	5
UINT							-1	5
PUCHAR16						-1	5
PCHAR16 						-1	5
BYTE							-1	5
PSZ							-1	5
NPSZ							-1	5
PCH							-1	5
NPCH							-1	5
_PFN							-1	5
PFN							-1	5
_NPFN							-1	5
NPFN							-1	5
PBYTE							-1	5
NPBYTE							-1	5
PCHAR							-1	5
PSHORT							-1	5
PLONG							-1	5
PINT							-1	5
PUCHAR							-1	5
PUSHORT 						-1	5
PULONG							-1	5
PUINT							-1	5
PVOID							-1	5
PPVOID							-1	5
PVOID16 						-1	5
BOOL							-1	5
PBOOL							-1	5
BOOL16							-1	5
PBOOL16 						-1	5
QWORD							-1	5
PQWORD							-1	5
SEL							-1	5
PSEL							-1	5
ERRORID 						-1	5
PERRORID						-1	5
HMODULE 						-1	5
PID							-1	5
TID							-1	5
SGID							-1	5
PHMODULE						-1	5
PPID							-1	5
PTID							-1	5
HSEM							-1	5
PHSEM							-1	5
HAB							-1	5
PHAB							-1	5
HPS							-1	5
PHPS							-1	5
HDC							-1	5
PHDC							-1	5
HRGN							-1	5
PHRGN							-1	5
HBITMAP 						-1	5
PHBITMAP						-1	5
HMF							-1	5
PHMF							-1	5
HPAL							-1	5
PHPAL							-1	5
COLOR							-1	5
PCOLOR							-1	5
POINTL							-1	5
PPOINTL 						-1	5
NPPOINTL						-1	5
POINTS							-1	5
PPOINTS 						-1	5
RECTL							-1	5
PRECTL							-1	5
NPRECTL 						-1	5
STR8							-1	5
PSTR8							-1	5
DRIVDATA						-1	5
PDRIVDATA						-1	5
PDEVOPENDATA						-1	5
DEVOPENSTRUC						-1	5
PDEVOPENSTRUC						-1	5
PRINTDEST						-1	5
PPRINTDEST						-1	5
FATTRS							-1	5
PFATTRS 						-1	5
PANOSE							-1	5
FONTMETRICS						-1	5
PFONTMETRICS						-1	5
HWND							-1	5
PHWND							-1	5
HMQ							-1	5
PHMQ							-1	5
ICONINFO						-1	5
PICONINFO						-1	5
TIB2							-1	5
PTIB2							-1	5
tib_t							-1	5
TIB							-1	5
PTIB							-1	5
pib_t							-1	5
PIB							-1	5
PPIB							-1	5
FNTHREAD						-1	5
PFNTHREAD						-1	5
RESULTCODES						-1	5
PRESULTCODES						-1	5
uDB_t							-1	5
FNEXITLIST						-1	5
PFNEXITLIST						-1	5
EASIZEBUF						-1	5
PEASIZEBUF						-1	5
FSQBUFFER						-1	5
PFSQBUFFER						-1	5
FSQBUFFER2						-1	5
PFSQBUFFER2						-1	5
SPOOLATTACH						-1	5
PSPOOLATTACH						-1	5
FTIME							-1	5
PFTIME							-1	5
FDATE							-1	5
PFDATE							-1	5
VOLUMELABEL						-1	5
PVOLUMELABEL						-1	5
FSINFO							-1	5
PFSINFO 						-1	5
FILELOCK						-1	5
PFILELOCK						-1	5
HFILE							-1	5
PHFILE							-1	5
HEV							-1	5
PHEV							-1	5
FHLOCK							-1	5
PFHLOCK 						-1	5
FILEFINDBUF						-1	5
PFILEFINDBUF						-1	5
FILEFINDBUF2						-1	5
PFILEFINDBUF2						-1	5
FILEFINDBUF3						-1	5
PFILEFINDBUF3						-1	5
FILEFINDBUF4						-1	5
PFILEFINDBUF4						-1	5
GEA							-1	5
PGEA							-1	5
GEALIST 						-1	5
PGEALIST						-1	5
FEA							-1	5
PFEA							-1	5
FEALIST 						-1	5
PFEALIST						-1	5
EAOP							-1	5
PEAOP							-1	5
FEA2							-1	5
PFEA2							-1	5
FEA2LIST						-1	5
PFEA2LIST						-1	5
GEA2							-1	5
PGEA2							-1	5
GEA2LIST						-1	5
PGEA2LIST						-1	5
EAOP2							-1	5
PEAOP2							-1	5
FILESTATUS						-1	5
PFILESTATUS						-1	5
FILESTATUS2						-1	5
PFILESTATUS2						-1	5
FILESTATUS3						-1	5
PFILESTATUS3						-1	5
FILESTATUS4						-1	5
PFILESTATUS4						-1	5
FSALLOCATE						-1	5
PFSALLOCATE						-1	5
HDIR							-1	5
PHDIR							-1	5
DENA1							-1	5
PDENA1							-1	5
DENA2							-1	5
PDENA2							-1	5
SEMRECORD						-1	5
PSEMRECORD						-1	5
HMTX							-1	5
PHMTX							-1	5
HMUX							-1	5
PHMUX							-1	5
DATETIME						-1	5
PDATETIME						-1	5
HTIMER							-1	5
PHTIMER 						-1	5
COUNTRYCODE						-1	5
PCOUNTRYCODE						-1	5
PCOUNTRYINFO						-1	5
PFPREG							-1	5
CONTEXTRECORD						-1	5
PCONTEXTRECORD						-1	5
EXCEPTIONREPORTRECORD					-1	5
PEXCEPTIONREPORTRECORD					-1	5
_ERR							-1	5
ERR							-1	5
EXCEPTIONREGISTRATIONRECORD				-1	5
PEXCEPTIONREGISTRATIONRECORD				-1	5
HQUEUE							-1	5
PHQUEUE 						-1	5
REQUESTDATA						-1	5
PREQUESTDATA						-1	5
STARTDATA						-1	5
PSTARTDATA						-1	5
STATUSDATA						-1	5
PSTATUSDATA						-1	5
HPIPE							-1	5
PHPIPE							-1	5
AVAILDATA						-1	5
PAVAILDATA						-1	5
PIPEINFO						-1	5
PPIPEINFO						-1	5
PIPESEMSTATE						-1	5
PPIPESEMSTATE						-1	5
HVDD							-1	5
PHVDD							-1	5
HKBD							-1	5
PHKBD							-1	5
KBDKEYINFO						-1	5
PKBDKEYINFO						-1	5
STRINGINBUF						-1	5
PSTRINGINBUF						-1	5
KBDINFO 						-1	5
PKBDINFO						-1	5
KBDHWID 						-1	5
PKBDHWID						-1	5
KBDTRANS						-1	5
PKBDTRANS						-1	5
HVIO							-1	5
PHVIO							-1	5
VIOCURSORINFO						-1	5
PVIOCURSORINFO						-1	5
VIOMODEINFO						-1	5
PVIOMODEINFO						-1	5
VIOPHYSBUF						-1	5
PVIOPHYSBUF						-1	5
VIOCONFIGINFO						-1	5
PVIOCONFIGINFO						-1	5
VIOFONTINFO						-1	5
PVIOFONTINFO						-1	5
VIOPALSTATE						-1	5
PVIOPALSTATE						-1	5
VIOOVERSCAN						-1	5
PVIOOVERSCAN						-1	5
VIOINTENSITY						-1	5
PVIOINTENSITY						-1	5
VIOCOLORREG						-1	5
PVIOCOLORREG						-1	5
VIOSETULINELOC						-1	5
PVIOSETULINELOC 					-1	5
VIOSETTARGET						-1	5
PVIOSETTARGET						-1	5
HMOU							-1	5
PHMOU							-1	5
PTRLOC							-1	5
PPTRLOC 						-1	5
PTRSHAPE						-1	5
PPTRSHAPE						-1	5
MOUEVENTINFO						-1	5
PMOUEVENTINFO						-1	5
MOUQUEINFO						-1	5
PMOUQUEINFO						-1	5
SCALEFACT						-1	5
PSCALEFACT						-1	5
NOPTRRECT						-1	5
PNOPTRRECT						-1	5
THRESHOLD						-1	5
PTHRESHOLD						-1	5
MPARAM							-1	5
PMPARAM 						-1	5
MRESULT 						-1	5
PMRESULT						-1	5
FNWP							-1	5
PFNWP							-1	5
QVERSDATA						-1	5
PQVERSDATA						-1	5
SWP							-1	5
PSWP							-1	5
CREATESTRUCT						-1	5
PCREATESTRUCT						-1	5
CLASSINFO						-1	5
PCLASSINFO						-1	5
HENUM							-1	5
QMSG							-1	5
PQMSG							-1	5
CMDMSG							-1	5
PCMDMSG 						-1	5
MQINFO							-1	5
PMQINFO 						-1	5
WNDPARAMS						-1	5
PWNDPARAMS						-1	5
MSEMSG							-1	5
PMSEMSG 						-1	5
CHRMSG							-1	5
PCHRMSG 						-1	5
DLGTITEM						-1	5
PDLGTITEM						-1	5
DLGTEMPLATE						-1	5
PDLGTEMPLATE						-1	5
BTNCDATA						-1	5
PBTNCDATA						-1	5
USERBUTTON						-1	5
PUSERBUTTON						-1	5
ENTRYFDATA						-1	5
PENTRYFDATA						-1	5
IPT							-1	5
PIPT							-1	5
PIX							-1	5
LINE							-1	5
MLEFORMATRECT						-1	5
PFORMATRECT						-1	5
MLECTLDATA						-1	5
PMLECTLDATA						-1	5
MLEOVERFLOW						-1	5
POVERFLOW						-1	5
MLEMARGSTRUCT						-1	5
PMARGSTRUCT						-1	5
MLE_SEARCHDATA						-1	5
PMLE_SEARCHDATA 					-1	5
MTI							-1	5
MT							-1	5
LPMT							-1	5
OWNERITEM						-1	5
POWNERITEM						-1	5
MENUITEM						-1	5
PMENUITEM						-1	5
SBCDATA 						-1	5
PSBCDATA						-1	5
FRAMECDATA						-1	5
PFRAMECDATA						-1	5
HSAVEWP 						-1	5
PARAM							-1	5
NPPARAM 						-1	5
PPARAM							-1	5
PRESPARAMS						-1	5
NPPRESPARAMS						-1	5
PPRESPARAMS						-1	5
HACCEL							-1	5
ACCEL							-1	5
PACCEL							-1	5
ACCELTABLE						-1	5
PACCELTABLE						-1	5
TRACKINFO						-1	5
PTRACKINFO						-1	5
MFP							-1	5
PMFP							-1	5
CPTEXT							-1	5
PCPTEXT 						-1	5
CURSORINFO						-1	5
PCURSORINFO						-1	5
HPOINTER						-1	5
POINTERINFO						-1	5
PPOINTERINFO						-1	5
SMHSTRUCT						-1	5
PSMHSTRUCT						-1	5
HPROGRAM						-1	5
PHPROGRAM						-1	5
HAPP							-1	5
HINI							-1	5
PHINI							-1	5
PRFPROFILE						-1	5
PPRFPROFILE						-1	5
HPROGARRAY						-1	5
PHPROGARRAY						-1	5
PROGCATEGORY						-1	5
PPROGCATEGORY						-1	5
PROGTYPE						-1	5
PPROGTYPE						-1	5
PROGDETAILS						-1	5
PPROGDETAILS						-1	5
PROGTITLE						-1	5
PPROGTITLE						-1	5
HSWITCH 						-1	5
PHSWITCH						-1	5
SWCNTRL 						-1	5
PSWCNTRL						-1	5
SWENTRY 						-1	5
PSWENTRY						-1	5
SWBLOCK 						-1	5
PSWBLOCK						-1	5
HATOMTBL						-1	5
ATOM							-1	5
ERRINFO 						-1	5
PERRINFO						-1	5
CONVCONTEXT						-1	5
PCONVCONTEXT						-1	5
DDEINIT 						-1	5
PDDEINIT						-1	5
DDESTRUCT						-1	5
PDDESTRUCT						-1	5
HELPSUBTABLE						-1	5
PHELPSUBTABLE						-1	5
HELPTABLE						-1	5
PHELPTABLE						-1	5
HELPINIT						-1	5
PHELPINIT						-1	5
PACVP							-1	5
HLIB							-1	5
PHLIB							-1	5
DESKTOP 						-1	5
PDESKTOP						-1	5
FIXED							-1	5
PFIXED							-1	5
FIXED88 						-1	5
FIXED114						-1	5
SIZEL							-1	5
PSIZEL							-1	5
MATRIXLF						-1	5
PMATRIXLF						-1	5
ARCPARAMS						-1	5
PARCPARAMS						-1	5
SIZEF							-1	5
PSIZEF							-1	5
GRADIENTL						-1	5
PGRADIENTL						-1	5
LINEBUNDLE						-1	5
PLINEBUNDLE						-1	5
CHARBUNDLE						-1	5
PCHARBUNDLE						-1	5
MARKERBUNDLE						-1	5
PMARKERBUNDLE						-1	5
AREABUNDLE						-1	5
PAREABUNDLE						-1	5
IMAGEBUNDLE						-1	5
PIMAGEBUNDLE						-1	5
PBUNDLE 						-1	5
KERNINGPAIRS						-1	5
PKERNINGPAIRS						-1	5
FACENAMEDESC						-1	5
PFACENAMEDESC						-1	5
FFDESCS 						-1	5
PFFDESCS						-1	5
FFDESCS2						-1	5
PFFDESCS2						-1	5
BITMAPINFOHEADER					-1	5
PBITMAPINFOHEADER					-1	5
RGB							-1	5
BITMAPINFO						-1	5
PBITMAPINFO						-1	5
BITMAPINFOHEADER2					-1	5
PBITMAPINFOHEADER2					-1	5
RGB2							-1	5
PRGB2							-1	5
BITMAPINFO2						-1	5
PBITMAPINFO2						-1	5
BITMAPFILEHEADER					-1	5
PBITMAPFILEHEADER					-1	5
BITMAPARRAYFILEHEADER					-1	5
PBITMAPARRAYFILEHEADER					-1	5
BITMAPFILEHEADER2					-1	5
PBITMAPFILEHEADER2					-1	5
BITMAPARRAYFILEHEADER2					-1	5
PBITMAPARRAYFILEHEADER2 				-1	5
RGNRECT 						-1	5
PRGNRECT						-1	5
POLYGON 						-1	5
PPOLYGON						-1	5
POLYSET 						-1	5
PPOLYSET						-1	5
VIOSIZECOUNT						-1	5
PVIOSIZECOUNT						-1	5
VIOFONTCELLSIZE 					-1	5
PVIOFONTCELLSIZE					-1	5
SFACTORS						-1	5
PSFACTORS						-1	5
BANDRECT						-1	5
PBANDRECT						-1	5
ESCMODE 						-1	5
PESCMODE						-1	5
STR16							-1	5
PSTR16							-1	5
STR32							-1	5
PSTR32							-1	5
STR64							-1	5
PSTR64							-1	5
HCINFO							-1	5
PHCINFO 						-1	5
HOBJECT 						-1	5
OBJECTIMAGE						-1	5
POBJECTIMAGE						-1	5
OBJCLASS						-1	5
POBJCLASS						-1	5
PAGEINFO						-1	5
PPAGEINFO						-1	5
ICONPOS 						-1	5
PICONPOS						-1	5
HVPS							-1	5
PHVPS							-1	5
HSPL							-1	5
HSTD							-1	5
PHSTD							-1	5
PQMOPENDATA						-1	5
HPROC							-1	5
PQPOPENDATA						-1	5
SQPOPENDATA						-1	5
PSQPOPENDATA						-1	5
SPLERR							-1	5
RECT1S							-1	5
ODPOINT 						-1	5
SIZES							-1	5
SWPUSHORT						-1	5
ORDER							-1	5
LORDER							-1	5
ORDERS_GCARC						-1	5
ORDERL_GCARC						-1	5
ORDER_GBEL						-1	5
ORDER_GCBIMG						-1	5
ORDER_GBPTH						-1	5
ORDERS_GCBOX						-1	5
ORDERL_GCBOX						-1	5
ORDER_GCALLS						-1	5
ORDER_GFPTH						-1	5
ORDER_GOPTH						-1	5
ORDER_GMPTH						-1	5
ORDERS_GCPARC						-1	5
ORDERL_GCPARC						-1	5
ORDER_GSCPTH						-1	5
ORDERS_GSAP						-1	5
ORDERL_GSAP						-1	5
ORDER_GSBICOL						-1	5
ORDERS_GSCC						-1	5
ORDERL_GSCC						-1	5
ORDERS_GSMC						-1	5
ORDERL_GSMC						-1	5
ORDERS_GSPRP						-1	5
ORDERL_GSPRP						-1	5
ORDER_GSIA						-1	5
ORDERS_GSTM						-1	5
ORDERL_GSTM						-1	5
ORDERS_GSSB						-1	5
ORDERL_GSSB						-1	5
ORDER_GSGCH						-1	5
ORDERS_GSSLW						-1	5
ORDERL_GSSLW						-1	5
ORDERS_GCSFLT						-1	5
ORDERL_GCSFLT						-1	5
ORDERS_GBBLT						-1	5
ORDERL_GBBLT						-1	5
ORDER_GPSCBE						-1	5
ORDER_GESCP						-1	5
ORDERL_GEBB						-1	5
ORDERL_GEDB						-1	5
ORDERL_GEFF						-1	5
VORDER							-1	5
ORDERS_GCCHSTE						-1	5
ORDERL_GCCHSTE						-1	5
ORDER_GEESCP						-1	5
FOCAMETRICS						-1	5
PFOCAMETRICS						-1	5
FONTFILEMETRICS 					-1	5
PFONTFILEMETRICS					-1	5
FONTDEFINITIONHEADER					-1	5
PFONTDEFINITIONHEADER					-1	5
FONTSIGNATURE						-1	5
PFONTSIGNATURE						-1	5
ADDITIONALMETRICS					-1	5
PADDITIONALMETRICS					-1	5
FOCAFONT						-1	5
PFOCAFONT						-1	5
APSZ							-1	5
PAPSZ							-1	5
FILEDLG 						-1	5
PFILEDLG						-1	5
FONTDLG 						-1	5
PFONTDLG						-1	5
STYLECHANGE						-1	5
PSTYLECHANGE						-1	5
HSTR							-1	5
DRAGITEM						-1	5
PDRAGITEM						-1	5
DRAGINFO						-1	5
PDRAGINFO						-1	5
DRAGIMAGE						-1	5
PDRAGIMAGE						-1	5
DRAGTRANSFER						-1	5
PDRAGTRANSFER						-1	5
RENDERFILE						-1	5
PRENDERFILE						-1	5
TREEITEMDESC						-1	5
PTREEITEMDESC						-1	5
FIELDINFO						-1	5
PFIELDINFO						-1	5
RECORDCORE						-1	5
PRECORDCORE						-1	5
MINIRECORDCORE						-1	5
PMINIRECORDCORE 					-1	5
CNRINFO 						-1	5
PCNRINFO						-1	5
CDATE							-1	5
PCDATE							-1	5
CTIME							-1	5
PCTIME							-1	5
CNRDRAGINIT						-1	5
PCNRDRAGINIT						-1	5
FIELDINFOINSERT 					-1	5
PFIELDINFOINSERT					-1	5
RECORDINSERT						-1	5
PRECORDINSERT						-1	5
QUERYRECFROMRECT					-1	5
PQUERYRECFROMRECT					-1	5
QUERYRECORDRECT 					-1	5
PQUERYRECORDRECT					-1	5
SEARCHSTRING						-1	5
PSEARCHSTRING						-1	5
CNRDRAGINFO						-1	5
PCNRDRAGINFO						-1	5
NOTIFYRECORDEMPHASIS					-1	5
PNOTIFYRECORDEMPHASIS					-1	5
NOTIFYRECORDENTER					-1	5
PNOTIFYRECORDENTER					-1	5
NOTIFYDELTA						-1	5
PNOTIFYDELTA						-1	5
NOTIFYSCROLL						-1	5
PNOTIFYSCROLL						-1	5
CNREDITDATA						-1	5
PCNREDITDATA						-1	5
OWNERBACKGROUND 					-1	5
POWNERBACKGROUND					-1	5
CNRDRAWITEMINFO 					-1	5
PCNRDRAWITEMINFO					-1	5
SLDCDATA						-1	5
PSLDCDATA						-1	5
VSCDATA 						-1	5
PVSCDATA						-1	5
VSDRAGINIT						-1	5
PVSDRAGINIT						-1	5
VSDRAGINFO						-1	5
PVSDRAGINFO						-1	5
VSTEXT							-1	5
PVSTEXT 						-1	5
BOOKTEXT						-1	5
PBOOKTEXT						-1	5
DELETENOTIFY						-1	5
PDELETENOTIFY						-1	5
PAGESELECTNOTIFY					-1	5
PPAGESELECTNOTIFY					-1	5
