/**************************************************************************
 This is CSTeX for EPM, version 8.6.1996 (but no change from 28.5.1996)
 Written by Petr Mikulk, mikulik@physics.muni.cz
     Address: Dept. of Solid State Physics, Masaryk University, 
               Kotlarska 2, Brno, Czech Republic
 Package location: http://www.sci.muni.cz/~mikulik/os2.html

 This macro file pmCSTeX.e (together with pm4epm.e) implements CSTeX menu 
 for various (La)TeX related commands. 

 This package was intended to be the (final?) replacement for CSTeX, EPMTeX, 
 TeXshell and pmgraf (and emacs perhaps?) under OS/2.  
  *Must have* for TeX under OS/2 :-)

   Installation:

 1. Copy this file and pm4epm.e to any directory on your EPMPATH
    (create directory E:\APPS\EPM\CSTeX, copy all files into it, modify
     EPMPATH=...;E:\APPS\EPM\CSTeX;... in your CONFIG.SYS)
 2. Write these lines into your Profile.erx:
	'link pm4epm'
	'link pmcstex'
	'link czech'  -- this is for Czech users: Czech keyboard implementation by Z. Wagner 	
        'link sampactn' -- there is syntax highlighting there
	'link MyCNF'  -- there are your actions there 
 3. Add these two lines into  actions.lst  file:
	CSTeX
	pm4epm
 4. Maybe something more, thus:

 5. *** Please read manual pmCSTeX.INF ***

 Compilation (of *.e to *.ex files): 
 You must have received file  stdconst.e  from EPMMAC.ZIP  (it can be found 
 on hobbes.nmsu.edu:os2/editors). Then type
	etpm pm4epm
	etpm cstex

  This package is free, but you can modify it only for your purposes and 
you have to keep the original on a safe place. You must distribute this 
package free of charge. If you make small changes here (you introduce a new 
menu for your printer etc.), then keep the filename. Otherwise rename this 
file. If you find bugs, or you find something missing, or you want to send 
me your codes to put it in, you are welcome. 
  Otherwise, if you think this package saves you $40, then send me $20, 
so you gain $20! :-)) At least send me happy email if you happy using this
package. 


***************************************************************************/

include 'stdconst.e'	-- from EPMMAC.ZIP
-- include 'pm4epm.e'  -- Routines are used, but include not needed


/*** define CSTeX hotkeys ***/
def S_F11 = 'cstex_texit_background S'
def S_F12 = 'cstex_next_error S'

DEFINIT
  universal	pm4epm_MasterNotFound,
		cstex_error_array_id, cstex_error_index, cstex_errorarray_name,
		cstex_no_more_errors,
		cstex_true_tex_background, cstex_background_beep
cstex_error_index=-1
cstex_no_more_errors=0
cstex_true_tex_background=1  -- background compilation is: 0=window 1=icon
cstex_background_beep=0      -- 0/1 nobeep/beep after background texing
'PostMe BuildCSTeXMenu'


/*
DEFLOAD 
  -- 'a_togl_hilit S'
  -- 'toggle_parse 1 epmkwds.tex'
Syntax hilighting is now discussed in the manual pmCSTeX.INF. 
Toggling the syntax on has been moved to your local config file, i.e. MyCNF.e
Lines with  --PMTOGGLE  are no more needed, but for historical reasons 
  they are still here
*/


const 
  CSTEX_CSTEX = 1 -- allow Czech (CSTeX distribution) related features
  -- CSTEX_CSTEX = 0 -- disable Czech (CSTeX distribution) related features
  -- enables/disables CSTOCS, CSTeX spell checker, dvi-out etc. 

  CSTEX_CS2CS = 1 -- use cs2cs program for Czech to Czech conversion
  -- CSTEX_CS2CS = 0 -- use old DOS program


const
  cstex_texit_inf = 'Compile document by (La)TeX  (pm_command_cmd %format.cmd %N)'
  cstex_preview_inf = 'Preview document by dvipm (using dvipm.cnf)'
  cstex_paragraph_inf = 'Run LaTeX over current paragraph'
  cstex_dvips_inf = 'Run dvi-out and dvips'
  cstex_master_inf = 'Load Master file'
  cstex_include_inf = 'Load the file under cursor'
  cstex_refresh_inf = 'Refresh current file (reload from disk)'
  cstex_save_all_inf = 'Save all files in the ring'
  cstex_highlight_all_inf = 'Toggle syntax highlighting for the whole ring'
  cstex_texit_background_inf = '(La)TeX the document on background'
  cstex_next_error_inf = 'Locate next error in .log file (and open .log if necessary)'

DEFC cstex_actionlist
universal ActionsList_FileID

 insertline 'cstex_texit'cstex_texit_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_preview'cstex_preview_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_paragraph'cstex_paragraph_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_dvips'cstex_dvips_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_master'cstex_master_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_include'cstex_include_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_refresh'cstex_refresh_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_save_all'cstex_save_all_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_texit_background'cstex_texit_background_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_next_error'cstex_next_error_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_highlight_all'cstex_highlight_all_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID


const 
COMPILE IF CSTEX_CSTEX=1
  csindex='csIndex'
  csbibtex='csBibTeX'
COMPILE ELSE
  csindex='Index'
  csbibtex='BibTeX'
COMPILE ENDIF

--------------------- KEYS DEFINITION ---------------------------------


-- CTRL/3 \begin{} \end{} LaTeX environment
def C_3 = 
--x=winmessagebox('Choose environment','i=itemize' ,65535)
  /* -- This comes from my Turbo Vision pmgraf program
  s=',flush~left,~center,flush~right,eqnarray,~equation,array,~tabular,table,tabbing,'
  s=s'e~numerate,~itemize,~description,displaymath,~picture,~figure,~verbatim,document'
  */
s=',array,center,description,displaymath,document,enumerate,eqnarray,equation,figure,flushleft,flushright,itemize,picture,tabbing,table,tabular,verbatim'
s=listbox('environment',s,,20,22,17,25)  -- pos1,pos2,height,width
-- s=entry_box('environment',s,'equation',30,30)
if s='' then return; endif 
if .col>1 then .line=.line+1; endif
s=word(s,1)
insertline '\begin{'s'}'
insertline ''
insertline '\end{'s'}'
.line=.line-2
.col=1


-- CTRL/4 AMSLaTeX environments
def C_4 = 
s=',align,align*,aligntat,alignat*,bmatrix,cases,gather,gather*,matrix,multline,multline*,pmatrix,smallmatrix,split,subequations,Sb,Sp,vmatrix,Vmatrix,xalignat,xlignat*,xxalignat,xxlignat*'
s=listbox('AMSLaTeX env.',s,,20,22,23,25)  -- pos1,pos2,height,width
-- s=entry_box('environment',s,'equation',30,30)
if s='' then return; endif 
if .col>1 then .line=.line+1; endif
s=word(s,1)
insertline '\begin{'s'}'
insertline ''
insertline '\end{'s'}'
.line=.line-2
.col=1


-- CTRL/5 LATeX font sizes
def C_5 = 
s=',tiny,scriptsize,footnotesize,smalle,normalsize,large,Large,LARGE,huge,Huge'
s=listbox('font size',s,,20,22,10,25)  -- pos1,pos2,height,width
if s='' then return; endif
getline x; replaceline( insertstr('\'s,x,.col-1) )
.col=.col+1+length(s)



-- Alt-G defines Greek keyboard. Keyboard layout according to Chi-writer
def A_G = 
keys pm_GreekKeys

DEFKEYS pm_OrigKeys

DEFKEYS pm_GreekKeys
def 'a'-'t','x'-'z','G','D','E','S','L','X','P','S','F','O','J' = pm_TypeGreek()

DEFPROC pm_TypeGreek()
universal czech_is
a=lastkey(0)
GreekAlphabet='\alpha\beta\chi\delta\epsilon\phi\gamma\eta\iota\psi\kappa\lambda\mu\nu\omega\pi\theta\rho\sigma\tau\\\upsilon\ksi\upsilon\zeta\'
a=asc(a);
if a>90 then i=a-96; else i=a-64; endif
p=1; j=2
while j<=i do p=pos('\',GreekAlphabet,p+1); j=j+1; endwhile
i=pos('\',GreekAlphabet,p+1); 
if a>90 
  then s=substr(GreekAlphabet,p,i-p)
  else s=upcase(substr(GreekAlphabet,p+1,1)); s='\'s''substr(GreekAlphabet,p+2,i-p-2)
  endif
getline x; replaceline( insertstr(s,x,.col-1) )
.col=.col+length(s)
-- load the keyset as before. If Czech.E is used, then czech_is holds the state
if 	czech_is=1 then keys czech_keys
elseif	czech_is=2 then keys czech_switch
else 	keys pm_OrigKeys
endif



------------------------ PROCEDURES -----------------------------



DEFPROC PleaseRelax ()
-- wait a little bit. I don't know how to put a DOS prog into window without STARTing it
InfoBox('Please relax...','Wait till the program finishes. I do not know how to run DOS windowed program and wait till it finishes. Please send me the solution if you know it.')
return

DEFC cstex_texit
  universal pm4epm_MasterNotFound, cstex_reLaTeXed
parse arg action x
if action='S' then 
  i=length(.filename)
  if (i>4) and (upcase(substr(.filename,i-3,4))='.LOG')  -- update 28.5.1996
	then	e='% MASTER: 'substr(.filename,1,i-4)'.tex'
		insertline e,1
 		N=pm_expansion('%format.cmd %N') -- you edit .log file, thus name only
 	else	N=pm_expansion('%format.cmd %.N') -- full name
	endif
  if pm4epm_MasterNotFound=1 then return ''; endif
  save_the_ring()
  e=get_env('EMTEXOPT');	-- now cool tricks to set up EMTEXOPT environment variable
  if (words(e)>0) then e=e' ' endif
  e=e''pm_expansion('%optsemtex')
  if (words(e)=0) then e=N; else e='(set EMTEXOPT='e') & 'N; endif
  'start /c /win /f cmd.exe /c "'e'"'
  cstex_reLaTeXed=1  -- information for cstex_next_error
elseif action='I' then sayerror cstex_texit_inf
endif

DEFC cstex_texit_background
  universal pm4epm_MasterNotFound, cstex_reLaTeXed,cstex_true_tex_background, cstex_background_beep
parse arg action
if action='S' then 
  /* before 28.5.1996:
  i=lastpos('.',.filename)
  if (i>0) and (upcase(substr(.filename,i,length(.filename)-i))='LOG') 
	then	N=pm_expansion('%format.cmd %.N') -- full name
		if pm4epm_MasterNotFound=1 then return ''; endif
	else	N=pm_expansion('%format.cmd %N') -- you edit .log file, thus name only
	endif
  */
  i=length(.filename)
  if (i>4) and (upcase(substr(.filename,i-3,4))='.LOG')  -- update 28.5.1996
	then	e='% MASTER: 'substr(.filename,1,i-4)'.tex'
		insertline e,1
 		N=pm_expansion('%format.cmd %N') -- you edit .log file, thus name only
 	else	N=pm_expansion('%format.cmd %.N') -- full name
	endif
  if pm4epm_MasterNotFound=1 then return ''; endif
  save_the_ring()
  e=get_env('EMTEXOPT')		-- again cool tricks to set up EMTEXOPT environment variable
  if (words(e)>0) then e=e' ' endif
  e=e''pm_expansion('%optsemtex')
  if (words(e)=0) then e='/b'; else e=e' /b'; endif   -- "je to spicovy", it works!
  c='start /c /win /b '
  if (cstex_true_tex_background<>0) then c=c'/min '; endif
  c=c'cmd.exe /c "(set EMTEXOPT='e') & 'N
  if (cstex_background_beep<>0) then c=c' & echo '; endif
  c'"'
  -- previously: 'start /c /win /b cmd.exe /c 'N
  cstex_reLaTeXed=1 -- information for cstex_next_error
elseif action='I' then sayerror cstex_texit_background_inf
endif

DEFC cstex_preview
  universal pm4epm_MasterNotFound
parse arg action
if action='S' then 
   M=pm_expansion('%m')
   -- it was: '%M'  and pointed out by Kroni: TeX always outputs in the current directory
   -- if pm4epm_MasterNotFound=1 then return ''; endif -- you can have only .dvi file
   if EXIST(M'.dvi')=0 then ErrorBox('Error','.dvi file not found. Please run (La)TeX first.'); return; endif
   'start dvipm.exe @dvipm.cnf ' M
elseif action='I' then sayerror cstex_preview_inf
endif

-- Temporary version. See remark in the routine below. 
DEFPROC cstex_dvips (opts)
  universal pm4epm_MasterNotFound
Master=pm_expansion('%m')  -- changed from '%M'
dvipsopts=pm_expansion('%optsdvips')
-- if pm4epm_MasterNotFound=1 then return ''; endif
if EXIST(Master'.dvi')=0 then ErrorBox('Error','.dvi file not found. Please run (La)TeX first.'); return; endif
COMPILE IF CSTEX_CSTEX=1
'start /win /c /dos dvi-out -m 'Master
PleaseRelax()
COMPILE ENDIF
-- 'cmd /c dvips 'opts' 'Master
x='dvips 'dvipsopts' 'opts' 'Master
sayerror x
'cmd /c 'x
return Master


/* -- This is an alternative version TO BE USED AFTER someone compiles dvi-out for OS/2
DEFPROC cstex_dvips (opts)
  universal pm4epm_MasterNotFound
Master=pm_expansion('%M')
dvipsopts=pm_expansion('%optsdvips')
-- if pm4epm_MasterNotFound=1 then return ''; endif
if EXIST(Master'.dvi')=0 then ErrorBox('Error','.dvi file not found. Please run (La)TeX first.'); return; endif
COMPILE IF CSTEX_CSTEX=1
'cmd /c csdvips 'dvipsopts' 'opts' 'Master
COMPILE ELSE
'cmd /c dvips 'dvipsopts' 'opts' 'Master
COMPILE ENDIF
return Master
*/

DEFC cstex_dvips
parse arg action opts
if action='S' then call cstex_dvips(opts)
elseif action='I' then sayerror cstex_dvips_inf
endif

DEFC cstex_gvpm
parse arg action x
if action='S' then 
   Master=cstex_dvips('')
   if Master<>'' then 'start gvpm 'Master'.ps' endif
endif

DEFC cstex_psview
parse arg action x
if action='S' then Master=cstex_dvips(''); 
   if Master<>'' then 'pm_command_dosfs S psview.bat %m.ps' endif
   endif

DEFC cstex_about
InfoBox('This is CSTeX for EPM','Version 8.6.1996'\13\13'Written by Petr Mikulk'\13'  Dept. of Solid State Physics'\13'  Masaryk University'\13'  Brno, Czech Republic'\13\13'pmCSTeX for EPM resides at http://www.sci.muni.cz/~mikulik/os2.html')

DEFC cstex_bugs
WinMessageBox('This is CSTeX for EPM','Please address your bug reports, suggestions, comments, congratulations, improvements and solutions by e-mail to mikulik@physics.muni.cz',MB_OK + MB_MOVEABLE +MB_ERROR)

DEFC cstex_next_error
  universal cstex_error_array_id, cstex_error_index, cstex_errorarray_name,
	    cstex_last_error_pos, cstex_no_more_errors, cstex_reLaTeXed
parse arg action x
if action='S' then 
getfileid W
LogName=pm_expansion('%m.log')
getfileid Lid, LogName
if ((cstex_reLaTeXed<>0) or (cstex_no_more_errors=1)) and (Lid<>'') then 
i='Y'; /* 15.5.1996: taking this annoying question away
    if (cstex_reLaTeXed<>0) 
	then line='I think your document has been reLaTeXed. Reload .log from disk?'
	else line='There are no more errors in the current .log file. Refresh it from disk?'
	endif
    i=AskYesNo(line);
*/
    if i='Y' then 
	activatefile Lid; .modify=0; 'xcom quit'; Lid=''; endif
    endif
cstex_reLaTeXed = 0
if Lid='' -- .log is not in ring
  then if EXIST(LogName)=0 then ErrorBox('Error',LogName' does not exist'); return; endif
	'xcom edit 'LogName; top
	--PMTOGGLE 'a_togl_hilit S' 
	-- delete error list if it exists
	if cstex_error_index>0 
	  then while (cstex_error_index>1) do
		  do_array 4, cstex_error_array_id, cstex_error_index
		  cstex_error_index=cstex_error_index-1
		  endwhile
	  else if cstex_error_index<0 then -- create error list
		  do_array 1, cstex_error_array_id, cstex_errorarray_name
		  cstex_error_index=0
		  endif
	  endif
  else	activatefile Lid 
	if (cstex_last_error_pos<>'') then 
	  prestore_pos(cstex_last_error_pos)
	  line='x'
          -- debugbox('start line='line' lasterrorpos='cstex_last_error_pos)
	  while (.line<.last) and (words(line)>0) do 
		.line=.line+1
		getline line
		endwhile
	  endif

	-- .line=.line+1
  /* --This code would look whether the .log file has changed: 
      --  but it would require disk access... choose as you want
    psave_pos(p); bot; getline lastline; top; getline firstline
    .modify=0; quitfile(); activatefile W 
    'xcom edit 'LogName
    top; getline line;  -- look at first and last line whether the file hasn't been changed
    if line=firstline then
      bot; getline line; top
      if line=lastline then prestore_pos(p); endif  -- restore position of the last error
      endif
  */
  endif
linenumber=.line
while (linenumber<.last) do
   getline line,linenumber
   if leftstr(line,1)='!' then
     cstex_no_more_errors=0
     parse value line with '!' error
     do forever 
       linenumber=linenumber+1; getline line,linenumber; if leftstr(line,2)='l.' then leave; endif
     enddo
     .line=linenumber
     parse value line with 'l.'wrongline what
     if words(what)>0 then what=': 'what; endif
     if cstex_error_index<1 then ErrorBox('Fatal error',LogName' seems to be corrupted [or my algorithm is wrong]: () do not match'); return; endif
     psave_pos(cstex_last_error_pos)
     -- debugbox('SAVE lasterrorpos='cstex_last_error_pos)
     do_array 3, cstex_error_array_id, cstex_error_index, line
     line=translate(line,'\','/') -- convert from unix format
     if pos('\',line)=0 then 
        if already_in_ring(line,n) then -- Kroni: EPM always finds files which are already loaded
	  line=n.filename
	else
	  line=directory()'\'line; endif
        endif -- EPM requires full spec.
     getfileid Wid,line
     -- DebugBox('File with errors seems to be *'line'* with Wid='Wid' on wrongline='wrongline) 
     if Wid='' 
	then 'xcom edit 'line; getfileid Wid; --PMTOGGLE 'toggle_parse 1 epmkwds.tex' 
	else activatefile Wid
	endif
     top 
     activatefile Wid
     sayerror 'TeX error: 'error
     if wrongline>.last 
	then ErrorBox('Fatal error','Log file out of date: cannot find file 'line' or line 'wrongline' exceeds its eof')
	else 
	.line=wrongline; .col=1 -- place cursor on the error
	i=words(what)
	if i>0 then
	  /* before 28.5.1996
	    i=wordindex(what,i); j=length(what)
	    .col=j
	    circleit 2,wrongline,i,length(what),1
	  */
	what=substr(what,3,length(what)-2) -- delete ': '
	if (substr(what,1,3)='...') 
	  then	what=substr(what,4,length(what)-3))
		getline line
		i=pos(what,line); j=i+length(what)
	  else	i=1; j=length(what)
	  endif
	.col=i
	circleit 2,wrongline,i,j,1
	  -- the same problem as in EPM: ovals are not resistant for the first time
     -- WHY DOES IT SOMETIMES GO BACK TO .LOG FILE INSTEAD OF STAYING HERE ????!!!!
     -- 'xcom edit '.filename
     -- debugbox('I AM HERE'.filename)
     -- activatefile Wid
        return
	endif
     return
     endif -- line with !
   -- count parentheses and change the list accordingly
   lz=pos('(',line); pz=pos(')',line); l=length(line)
   while (lz<>0) or (pz<>0) do
     if (lz=0) or ((pz<lz) and (pz>0))
      then -- remove the last word from the list
	if cstex_error_index<1 then ErrorBox('Fatal error','Log file corrupted: () do not match, index='cstex_error_index); return; endif
	do_array 3, cstex_error_array_id, cstex_error_index, x
	do_array 4, cstex_error_array_id, cstex_error_index
	cstex_error_index=cstex_error_index-1
	pz=pos(')',line,pz+1)
      else
	i=verify(line,' )'\9'','M',lz+1)
	if (i=pz) and (i>0)
	  then lz=pos('(',line,pz+1); pz=pos(')',line,pz+1)
	  else
	    nextlz=pos('(',line,lz+1)
	    if ((pz<nextlz) and (pz>0)) or ((pz>0) and (nextlz=0)) then pz=pos(')',line,pz+1); lz=nextlz  --(
	    else
	    if i=0 then i=l; else i=i-1; endif -- last position
	    cstex_error_index=cstex_error_index+1 -- add this word to the list
	    theword=substr(line,lz+1,i-lz)
	    do_array 2, cstex_error_array_id, cstex_error_index, theword
	    lz=nextlz
	    endif
	  endif
      endif
   endwhile
   linenumber=linenumber+1
   endwhile
-- calculate Warning:
.line=1; i=0; 
while .line<.last do 
  getline line; if pos('Warning:',line)>0 then i=i+1; endif; .line=.line+1; endwhile
-- get last line
getline line; 
if i>0 then line='Warnings: 'i\13\13''line; endif
activatefile W
InfoBox('Congratulation!','No (more) errors.'\13''line) -- \13'Refresh from disk?'
cstex_no_more_errors=1
elseif action='I' then sayerror cstex_next_error_inf
endif

DEFC cstex_paragraph
  universal pm4epm_MasterNotFound
/* Algorithn: Open master file. Copy everything till \begin{document}. Close it. 
Localize the paragraph in the current file. Copy it. Append \end{document}. 
Run LaTeX over this temporary file. Copy its .dvi to master.dvi */
parse arg action x
if action='S' then 
-- are we Master or Working file?
s=pm_expansion('%.M')
if pm4epm_MasterNotFound=1 then return; endif
if translate(s)=translate(.filename) then WeAreMaster=1; else WeAreMaster=0; endif
localdir=pm_expansion('%d')
psave_pos(Wpos)
getfileid W
CloseMaster=0
l4=.line -- line with cursor, it determines the paragraph
if WeAreMaster=0 
  then
     getfileid Mid, s
     if Mid='' then CloseMaster=1; 'edit 's; getfileid Mid
        else activatefile Mid; endif
  else Mid=W
  endif
top; 'xcom L \begin{document}' -- search string
-- people without \begin{document} will have troubles. Their problem, sorry
l2=.line -- line with \begin{document}
if WeAreMaster=1 -- first line of the current paragraph
   then if (l4<=l2) then l4=l2+1 endif; stopit=l2+1;
   else stopit=1;
   endif
l3=l4
getline s, l4, W
while (l3>stopit) and (words(s)>0) do l3=l3-1; getline s,l3,W; endwhile
getline s,W.line,W -- last line of the current paragraph
while (l4<W.last) and (words(s)>0) do l4=l4+1; getline s,l4,W; endwhile
'EDIT 'localdir'\$$cstex$.tex' -- avoid existence of $cstex$.tex file
'NAME 'localdir'\$cstex$.tex'  -- rename it
getfileid P
for i=1 to l2
  getline s,i,Mid
  insertline s,.last
  endfor
if CloseMaster=1 then activatefile Mid; quitfile(); activatefile P; endif
for i=l3 to l4
  getline s,i,W
  insertline s,.last
  endfor
insertline '\end{document}',.last
'FILE'  -- save and quit
sayerror 'TeXing paragraph...'
activatefile W
prestore_pos(Wpos)
e=get_env('EMTEXOPT')
if (words(e)>0) then e=e' ' endif -- cool tricks, hot stuff, 17.5.1996
e=e''pm_expansion('%optsemtex')
if (words(e)<>0) then e=e' /b'; else e='/b'; endif -- /batchmode
e='(set EMTEXOPT='e') & '
'pm_command_pm S /c /b /min cmd.exe /c "'e'(cd %d) & (%format.cmd $cstex$.tex) & (if exist %m.dvi del %m.dvi) & (ren $cstex$.dvi %m.dvi) & (if exist %m.log del %m.log) & (ren $cstex$.log %m.log) & (del $cstex$.* >nul)"'
sayerror 0
return
elseif action='I' then sayerror cstex_paragraph_inf
endif


DEFC cstex_master
  universal pm4epm_MasterNotFound
parse arg action
if action='S' then
Master=pm_expansion('%.M')
if pm4epm_MasterNotFound=1 then return; endif
'xcom edit ' Master
sayerror 'This is master'
elseif action='I' then sayerror cstex_master_inf
endif


DEFPROC cstex_WhereExists ( Name ) 
if EXIST(Name)<>0 then return Name; endif
s=pm_expansion('%d\'Name); -- look at Master's directory
if EXIST(s)<>0 then return s; endif
updir=directory(); i=lastpos('\',updir); updir=substr(updir,1,i-1);
s=updir'\units\'Name  -- there could be my .h files
if EXIST(s)<>0 then return s; endif
s='\emtex\texinput\'Name  -- there could be my .tex or .sty files
if EXIST(s)<>0 then return s; endif
s='\emx\include\'Name  -- look for GNU C/C++ files
if EXIST(s)<>0 then return s; endif
s='\emx\include\cpp\'Name  -- look for GNU C/C++ files
if EXIST(s)<>0 then return s; endif
s='\emx\include\sys\'Name  -- look for GNU C/C++ files
if EXIST(s)<>0 then return s; endif
s='\emx\include\cpp\gen\'Name  -- look for GNU C/C++ files
if EXIST(s)<>0 then return s; endif
return '' -- not found


-- the following routine withdraws the file name under cursor and (re)loads it
DEFC cstex_include
parse arg action line
if action='S' then
getline line
k=words(line)
if (k=0) or (.col>wordindex(line,k)+length(word(line,k))-1) then Beep(440,222); return; endif
i=2 -- find the word the char is in
while (i<=k) and (.col>=wordindex(line,i)) do i=i+1; endwhile --first word above cursor
i=i-1; if (i<k) and (.col>wordindex(line,i)+length(word(line,i))-1) then Beep(440,222); return; endif
--i=i-1; if i>k then i=k; elseif i<1 then i=1; endif
c=.col-wordindex(line,i)+1; line=word(line,i)
l=length(line);
-- chars that can appear in file name
CharsInName='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@._$-젡֐'
Name=''
if c>1 then -- from cursor-1 to left
    Name=reverse(substr(line,1,c-1))
    k=verify(Name,CharsInName)
    if k=0 then Name=substr(line,1,c-1)
            else Name=substr(line,c-k+1,k-1)
	    endif
  endif
k=verify(line,CharsInName,'N',c)  -- from cursor to right
if k=0 then Name=Name''substr(line,c,l-c+1)
  else Name=Name''substr(line,c,k-c)
  endif
-- the following routine tries to load Name to editor
if words(Name)=0 then Beep(440,220); return; endif
getfileid Lid, Name -- is that file in ring?
if Lid<>'' then activatefile(Lid); return; endif
-- so look at some directories. List your favourite ones here:
s=directory()'\'Name; 
s=cstex_WhereExists(Name) 
if s='' then s=cstex_WhereExists(Name'.h') 
  if s='' then s=cstex_WhereExists(Name'.cpp') 
  if s='' then s=cstex_WhereExists(Name'.cxx') 
  if s='' then s=cstex_WhereExists(Name'.sty') 
  if s='' then s=cstex_WhereExists(Name'.tex') 
  if s='' then s=cstex_WhereExists(Name'.dtx') 
  if s='' then s=cstex_WhereExists(Name'.pas') 
  if s='' then s=cstex_WhereExists(Name'.txt') 
  if s='' then s=cstex_WhereExists(Name'.doc') 
endif endif endif endif endif endif endif endif endif 
/*  -- this is old, explicit version
if EXIST(s)=0 then s=pm_expansion('%d\'Name); -- look at Master's directory
if EXIST(s)=0 then 
updir=directory(); i=lastpos('\',updir); updir=substr(updir,1,i-1);
s=updir'\units\'Name  -- there could be my .h files
if EXIST(s)=0 then s='\emtex\texinput\'Name  -- there could be my .tex or .sty files
if EXIST(s)=0 then s='\emx\include\'Name  -- look for GNU C/C++ files
if EXIST(s)=0 then s='\emx\include\cpp\'Name  -- look for GNU C/C++ files
if EXIST(s)=0 then s='\emx\include\sys\'Name  -- look for GNU C/C++ files
if EXIST(s)=0 then s='\emx\include\cpp\gen\'Name  -- look for GNU C/C++ files
endif endif endif endif endif endif endif
*/
-- now open it if exists
getfileid Lid, s -- is that file in ring?
if Lid<>'' then activatefile(Lid); return; endif
if EXIST(s)<>0 
  then 'edit 's; --PMTOGGLE 'a_togl_hilit S'
  else ErrorBox('Sorry','File 'Name' not found.'\13\13'You can try to edit CSTeX.e, routines cstex_WhereExists and cstex_include, to supply your favourite paths and extensions.')
  endif
elseif action='I' then sayerror cstex_include_inf
endif

DEFC cstex_cykl
  universal pm4epm_MasterNotFound
parse arg action
if action='S' then
-- 'pm_command_cmd S cykl! %.W call %format.cmd %.N'
x=pm_expansion('%.W call %format.cmd %.N')
if pm4epm_MasterNotFound=1 then return; endif
'pm_command_cmd S cykl! 'x
endif

DEFPROC RefreshCurrentFile ()
--ct = windowmessage(1,  getpminfo(EPMINFO_EDITFRAME),
--       5505,          -- EPM_EDIT_KW_QUERYPARSE
--       0,0)  -- returns 0 / 1 if syntax highl. off/on
-- InfoBox('myinfo','Keyword parsing is' ct)
psave_pos(x); .modify=0
'xcom edit /d '.filename
getfileid fid
prevfile; 'xcom quit'
activatefile fid; prestore_pos(x)
--PMTOGGLE if ct=1 then 'a_togl_hilit S'; endif
return

DEFC cstex_refresh
parse arg action
if action='S' then
x=AskYesNo( 'Refresh current file' .filename' ?')
if x<>'Y' then return; endif
RefreshCurrentFile()
elseif action='I' then sayerror cstex_refresh_inf
endif

DEFC cstex_highlight_all
parse arg action
if action='S' then
n = filesinring()
for i = 1 to n
  'a_togl_hilit S'
  nextfile
  endfor
sayerror ' '
elseif action='I' then sayerror cstex_highlight_all_inf
endif

DEFC cstex_save_all
parse arg action x
if action = 'S' then
  sayerror ''
  call save_the_ring()
elseif action='I' then sayerror cstex_save_all_inf
endif

COMPILE IF CSTEX_CSTEX=1

COMPILE IF CSTEX_CS2CS=1
DEFC CStoCS
-- CS2CS using OS/2 program
w=pm_expansion('%.W')
'save 'w  -- save
CP='*CP852        (PC Latin II - CP 852)*KEYBCS2     (podle Kamenickych)*CP850        (PC Latin I - CP 850)*IBM852      (Latin II - IBM 852)*ISO-8859-1  (ISO-8859-1 Latin 1)*ISO-8859-2  (ISO-8859-2 Latin 2)*TEX1         (TeX, \v{C})*TEX2         (TeX, \v C)*CORKY        (podle Corky)*CP1250       (MS-Windows - CP 1250)*KOI8-CS      (KOI8-CS)*MAC          (Macintosh)*'
iCP='*autodetect'CP
iCP=listbox('Input encoding',iCP,,20,22,13,45)  -- pos1,pos2,height,width
if iCP='' then return; endif
iCP=word(iCP,1)
CP=CP'ASCII        (bez diakritiky),'
CP=listbox('Output encoding',CP,,20,22,13,45)  -- pos1,pos2,height,width
if CP='' then return; endif
CP=word(CP,1)
if (iCP='autodetect') 
  then 'cs2cs -s 'w' -o'CP' -w';
  else 'cs2cs -s 'w' -i'iCP' -o'CP' -w'; endif
RefreshCurrentFile()
return

COMPILE ELSE

DEFPROC CS1toCS2 ( From, ToTo )
-- CStoCS using DOS program
w=pm_expansion('%.W')
'save 'w  -- save
-- 'start /win /c /dos cstocs -'From' 'w' -'ToTo' 'w
-- or: 'pm_command_dos S cstocs -'From' 'w' -'ToTo' 'w
getfileid fid
'edit $.Untitled$'
.filename='$cstex$.bat'
s=get_env('EMTEXDIR')'\cstocs.exe'
if EXIST(s) <> 0
  then insertline s' -'From' 'w' -'ToTo' 'w
  else insertline 'cstocs -'From' 'w' -'ToTo' 'w
  endif
insertline 'pause'
'FILE'
sayerror ''
'start /c /win /dos /f $cstex$.bat'
activatefile fid
PleaseRelax()
'start /c /b cmd /c del $cstex$.bat'
RefreshCurrentFile()
return
DEFC CStoCS
parse arg action From ToTo
if action='S' then
  CS1toCS2(From,ToTo)
  endif

COMPILE ENDIF


DEFC Vlnkax
parse arg action
if action='S' then
w=pm_expansion('%.W')
'save 'w
s=get_env('EMTEXDIR')'\vlnka.exe'
if EXIST(s) <> 0
  then 'start /win /c /dos 's' 'w' KkOoUuVvSsZzAI'
  else 'start /win /c /dos vlnka 'w' KkOoUuVvSsZzAI'
  endif
-- or: 'pm_command_dos S vlnka 'w' KkOoUuVvSsZzAI'
--'os2 (cmd /c vlnka 'w' KkOoUuVvSsZzAI) & exit'
PleaseRelax()
RefreshCurrentFile()
endif

DEFC csTeXspell
parse arg action dict
if action='S' then
w=pm_expansion('%.W')
'save 'w
s=get_env('EMTEXDIR')'\cstug\texspell.exe'
if EXIST(s) = 0 then ErrorBox('Error','Program 's' not found.'); return; endif
'start /win /c /dos 's' 'w' @L ='dict
PleaseRelax()
RefreshCurrentFile()
endif
COMPILE ENDIF

DEFC csBibTeXx
parse arg action
if action='S' then
--'pm_command_os2 S 'csbibtex' /p /and %M'
'pm_command_os2fs S cmd /c "'csbibtex' /p /and %M & pause"'
--'pm_command_os2 S 'csbibtex' /f=$(EMTEXDIR)\data\csbibtex\pclatin2.alp /and %M'
endif

DEFC cstex_texclean
'start /c /win cmd /c "for %i in (*.aux *.log *.dlg *.dvi *.toc *.lot *.lof *.blg *.idx *.ind *.glo *.gls *.hp *.mfj *.pri) do del %i >nul 2>nul"'

DEFC cstex_printmy
parse arg action myprt outfile
if action='S' then 'pm_command_cmd S 'myprt' // %viewopts %M 'outfile
endif

DEFC cstex_printpm
parse arg action cnf
if action='S' then 'pm_command_pm S dvipm.exe @'cnf'.cnf // %viewopts %M'
endif

DEFC cstex_printfs
parse arg action cnf
if action='S' then 'pm_command_os2fs S dviscr.exe @'cnf'.cnf // %viewopts %M'
endif

DEFPROC cstex_print ( hpljcnf, outfile )
'pm_command_os2 S dvi'hpljcnf'.cnf // %viewopts %M 'outfile
DEFC cstex_print
parse arg action args
if action='S' then cstex_print(args,'prn')
endif
DEFC cstex_printfile
parse arg action args
if action='S' then cstex_print(args,'%M.pri')
endif


/*************************** BUILD CSTEX MENU *********************/

DEFC BuildCSTeXMenu
   universal  defaultmenu,
              app_hini

defaultmenu = 'default'

-- Note for accelkeys: 'cstex_texit'1\'Preview Document'\9'Sh+F11'


idcount = 6940 -- start value of counter of ids
cstexid = 1969 -- registration id of the CSTeX menu

cstex_cykl_inf = '(La)TeX forever on the master file when working file changed'

id=idcount  --  Note: center hotkeys right: 'Texujx'\9'Sh+F12'
buildsubmenu defaultmenu, cstexid, 'CS~TeX', \1'Menu for (La)TeXing', 0,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, '(La)TeX document', 'cstex_texit S'\1''cstex_texit_inf, 0,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, '(La)TeX paragraph',  'cstex_paragraph S'\1''cstex_paragraph_inf, 0,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Cykl! (La)TeX document', 'cstex_cykl S'\1''cstex_cykl_inf, 0,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
id=id+1; buildmenuitem defaultmenu, cstexid, id, '(La)TeX document /b  Sh-F11', 'cstex_texit_background S'\1''cstex_texit_background_inf, 0,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Locate ~Next Error      Sh-F12', 'cstex_next_error S'\1''cstex_next_error_inf, 0,0
-- id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Reload .~log file',  'pm_expand S edit /d %M.log'\1'pm_expand S edit /d %M.log', 0,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
id=id+1; buildmenuitem defaultmenu, cstexid, id, '~View document', 'cstex_preview S'\1''cstex_preview_inf, 0,0  
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Post~Script',  ' '\1'PostScript actions', 64+17,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~dvips-it',  'cstex_dvips S'\1'Run dvips', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'dvips + gv~pm',  'cstex_gvpm S'\1'Run dvips and then gvpm (GhostView for OS/2 PM)', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'dvips + psview',  'cstex_psview S'\1'Run dvips and then psview.bat ("GhostView" for DOS)', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'print from dvips',  'cstex_dvips S -o prn'\1'Run dvips, output to prn', 32768+1,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'PM Preview before print', ' '\1'Preview document by dvipm with @_theprinter_.cnf and VIEWOPTS:',17+64,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 300 dpi', 'cstex_printpm S lj'\1'using @lj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 600 dpi', 'cstex_printpm S ljh'\1'using @ljh.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP DeskJet', 'cstex_printpm S dj'\1'using @dj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Stylus', 'cstex_printpm S sty'\1'using @sty.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt1', 'cstex_printpm S myprt1'\1"using user's @myprt1.cnf", 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt2', 'cstex_printpm S myprt2'\1"using user's @myprt2.cnf", 32768+1,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'FS Preview before print', ' '\1'Preview document by dviscr with @_theprinter_.cnf and VIEWOPTS:',17+64,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 300 dpi', 'cstex_printfs S lj'\1'using @lj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 600 dpi', 'cstex_printfs S ljh'\1'using @ljh.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP DeskJet', 'cstex_printfs S dj'\1'using @dj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Stylus', 'cstex_printfs S sty'\1'using @sty.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt1', 'cstex_printfs S myprt1'\1"using user's @myprt1.cnf", 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt2', 'cstex_printfs S myprt2'\1"using user's @myprt2.cnf", 32768+1,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Print document', ' '\1'Print the document',17+64,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 300 dpi', 'cstex_print S hplj @lj'\1'dvihplj @lj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 600 dpi', 'cstex_print S hplj @ljh'\1'dvihplj @ljh.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP DeskJet', 'cstex_print S hplj @dj'\1'dvihplj @dj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Stylus', 'cstex_print S dot sty.dot @sty'\1'dvidot sty.dot @sty.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt1', 'cstex_printmy S myprt1'\1"using user's myprt1.cmd", 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt2', 'cstex_printmy S myprt2'\1"using user's myprt2.cmd", 32768+1,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Print to ~file', ' '\1'Print document to file _Master_.pri',17+64,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 300 dpi', 'cstex_printfile S hplj @lj'\1'dvihplj @lj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 600 dpi', 'cstex_printfile S hplj @ljh'\1'dvihplj @ljh.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP DeskJet', 'cstex_printfile S hplj @dj'\1'dvihplj @dj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Stylus', 'cstex_printfile S dot sty.dot @sty'\1'dvidot sty.dot @sty.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt1', 'cstex_printmy S myprt1 %M.pri'\1"using user's myprt1.cmd", 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt2', 'cstex_printmy S myprt2 %M.pri'\1"using user's myprt2.cmd", 32768+1,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
COMPILE IF CSTEX_CSTEX=1
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Tie (vlnka)',  'Vlnkax S'\1'Pidn vlnek za pedloky', 0,0
COMPILE IF CSTEX_CS2CS=1
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'CStoCS',  'CStoCS S'\1'Czech encodings conversion using program cs2cs.exe', 0, 0
COMPILE ELSE
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'CStoCS',  ' '\1'Czech encodings conversion using program cstocs.exe', 17+64, 0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Kamenit to PC-Latin 2', 'CStoCS S i1 o2', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'PC-Latin2 to Kamenit', 'CStoCS S i2 o1', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'ISO8859-Latin 2 to PC-Latin2', 'CStoCS S i3 o2', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'PC-Latin2 to ISO8859-Latin 2', 'CStoCS S i2 o3', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'PC-Latin2 to TeX sequencies', 'CStoCS S i2 o0', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'TeX sequencies to PC-Latin2', 'CStoCS S i0 o2', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Strip accents from PC-Latin2', 'CStoCS S i2 a', 32768+1,0
COMPILE ENDIF
id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Spell', ' '\1'Only for registered CSTUG members', 17+64, 0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Czech', 'csTeXspell S C', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Slovak', 'csTeXspell S S', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~English', 'csTeXspell S A', 32768+1,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline  
COMPILE ENDIF
id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Other TeX programs', ' '\1'Some additional programs', 17+64, 0
COMPILE IF CSTEX_CSTEX
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~DVI-Out cs->cm', 'pm_command_dos S dvi-out %M'\1'Convert 8bit cs-fonts to 7bit cm-fonts', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~DVI-Out cm->cs', 'pm_command_dos S dvi-out -m %M'\1'Convert 7bit cm-fonts to 8bit cs-fonts', 0,0
COMPILE ENDIF
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Make~Index', 'pm_command_dos S 'csindex' -z latin2 %M'\1''csIndex' program (index, rejstky)', 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~BibTeX', 'csBibTeXx S'\1''csBibTeX' program', 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~TeXCAD', 'start /c /fs /dos command.com /c texcad'\1'TeXCAD drawing program', 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Qfig', 'start /c /fs /dos command.com /c qfig'\1'Qfig drawing program', 32768+1,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'TeXclean', 'cstex_texclean S'\1'Clean all garbage files', 0,0 
id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Editor', ' '\1'EPM related commands', 17+64, 0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Master', 'cstex_master S'\1''cstex_master_inf, 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Include', 'cstex_include S'\1''cstex_include_inf, 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Refresh', 'cstex_refresh S'\1''cstex_refresh_inf, 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Save ~all', 'cstex_save_all S'\1''cstex_save_all_inf, 0,0 

id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Syntax highlighting', '', 32768 +17+64, 0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Auto current file', 'a_togl_hilit S', 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Auto a~ll files', 'cstex_highlight_all S'\1''cstex_highlight_all_inf, 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~C/C++ current file', 'toggle_parse 1 epmkwds.c', 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~TeX current file', 'toggle_parse 1 epmkwds.tex', 32768+1,0 

id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline 
id=id+1; buildmenuitem defaultmenu, cstexid, id, '~About CSTeX for EPM', 'cstex_about'\1'Info about the current version of CSTeX', 0,0 
id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Bug reports', 'cstex_bugs'\1'Where to send you suggestions and bug reports', 0,0 
showmenu 'default' 
return

/* end of CSTeX.e */
