/*======================================================================
        PCBOARD.CMD  1.10 04/28/92 PCBoard universal logon script
         for Multi-Net's PMcomm 1.10, under IBM OS/2 1.30 REXX.
            Copyright (C) 1992 Brad Berson, Psycho Psoftware.
               #2 Chaparral Road, Chestnut Ridge, NY 10977
        Attach to appropriate PMcomm dialing entries, change the
         variables as directed on the next few lines and edit
     BBS' and passwords into the GetBbs section for full operation.
------------------------------------------------------------------------
       PCBOARD.CMD is Shareware.  If after a reasonable period of
     evaluation you continue to use this software, please consider
      sending a registration fee of $10 to encourage development.
======================================================================*/

  CALL RxFuncadd "init_dll","RxPmcomm","init_dll"
  PARSE ARG port portname scr_hndl dde_output dde_input semaphore
  PARSE SOURCE host caller fn .
  CALL init_dll
  etime=Time('R')
  name='BRAD BERSON'                   /* <- your own name here */
  qdir='C:\COMM\QMAIL\'                /* <- dir for Qmail files */
  loglvl=3                             /* <- set logfile verbosity 1-3 */
  autoff='YES'                         /* <- auto-off aft mail, xfers */
  delmail='YES'                        /* <- auto del QWK/REP files */
  autorep='YES'                        /* <- force repeat mail scans */
  waitnc='NO'                          /* <- wait NO CARRIER if halted */
  filelist='C:\COMM\UPDOWN\UPDOWN.LST' /* <- name of file xfer list */
  logfile='C:\COMM\UPDOWN\PCBOARD.LOG' /* <- name of activity log */
  odlpath='C:\COMM\UPDOWN'             /* <- downld path to reset to */
  qmail='NO X X'
  qupdn='N'
  pwdcnt=0
  namcnt=0
  pktcnt=0
  repflg=0
  cr='0d'x
  crlf='0d0a'x
  bs='08'x
  esc='1b'x
  scp=esc'[s'
  rcp=esc'[u'
  sred=esc'[31;1m'
  swit=esc'[0;1m'
  errl=esc'[25;1H'
  CALL Read_timeout '20000',port
  SIGNAL ON SYNTAX NAME RexxErr
  SIGNAL ON NOVALUE NAME RexxErr
  SIGNAL ON HALT NAME ExitScr
  CALL ON ERROR NAME HostErr
  CALL ON FAILURE NAME HostErr
  DO 3
    CALL Beep 1000,200
    CALL Beep 1200,200
  END
  IF logfile>' ' THEN
    lfstate=Stream(logfile,'c','open write')
  CALL WriteLog COPIES('=',50),1
  CALL WriteLog 'Modem connected...',1

Start:
  DO FOREVER
    match=Wait_fore('change?','graphics','NS)?','rst name',port,scr_hndl)
    CALL ScrDeb('ST')
    SELECT
      WHEN match=0 THEN
        SIGNAL Errh
      WHEN match=1 THEN
        CALL Put_s '1'cr,port
      WHEN match=2 THEN
        CALL Put_s 'Y Q N'cr,port
      WHEN match=3 THEN
        CALL Put_s 'N'cr,port
      WHEN match=4 THEN
        LEAVE
      OTHERWISE NOP
    END
  END

Inam:
  CALL Put_s name||cr,port
  DO FOREVER
    match=Wait_fore('ot found in us','rect?','rong pass','ssword','ence Co',,
    ')=yes?',', Mor','N)','NS)?','nter) to','ard Command',port,scr_hndl)
    CALL ScrDeb('IN')
    SELECT
      WHEN match=0 THEN
        SIGNAL Errh
      WHEN match=1 THEN DO
        IF namcnt>2 THEN DO
          CALL WriteLog 'Name not recognised',1
          SIGNAL Errh ; END
        CALL Put_s name||cr,port
        namcnt=namcnt+1 ; END
      WHEN match=2 THEN
        CALL Put_s 'Y'cr,port
      WHEN match=3 THEN DO
        IF pwdcnt>2 THEN DO
          CALL WriteLog 'Password not correct',1
          SIGNAL Errh ; END
        CALL Put_s pword||cr,port
        pwdcnt=pwdcnt+1 ; END
      WHEN match=4 THEN DO
        CALL Flush
        CALL GetBbs
        CALL Put_s pword||cr,port
        pwdcnt=pwdcnt+1 ; END
      WHEN match=5 THEN
        CALL Put_s 'A'cr,port
      WHEN match>5 & match<10 THEN
        CALL Put_s 'N'cr,port
      WHEN match=10 THEN
        CALL Put_s cr,port
      WHEN match=11 THEN
        LEAVE
      OTHERWISE NOP
    END
  END
  CALL Flush
  CALL WriteLog 'Successful log-in: 'LEFT(line,30),2
  PARSE VAR qmail doqmail packet xprot
  IF doqmail='YES' THEN
    CALL CheckMail
  IF filelist\='' THEN
    filelist=Stream(filelist,'c','query exists')
  IF qupdn\='N' THEN DO
    CALL Qmail
    IF autoff='YES' & filelist='' THEN CALL LogOff
  END
  IF filelist\='' THEN DO
    IF qupdn\='N' THEN CALL QuitMail
    CALL PcbXfer
    IF autoff='YES' THEN CALL LogOff
  END
  DO 3 ; CALL Beep 800,300 ; END
  CALL WriteLog 'Control given to user',1
  IF waitnc='YES' THEN DO
    CALL Read_timeout '3600000',port
    DO FOREVER
      match=Wait_fore('NO CARRIER'cr,port,scr_hndl)
      CALL ScrDeb('NC')
      SELECT
        WHEN match=0 THEN ; SIGNAL Errh
        WHEN match=1 THEN ; LEAVE
        OTHERWISE ; SIGNAL Errh
      END
    END
    CALL WriteLog 'Connection terminated',1
    CALL WriteLog 'ET',1
  END
  lfstate=Stream(logfile,'c','close')
  EXIT

/*====================[HANDLE QMAIL]====================*/
/*   Downloads & uploads Qmail packets and pointer and  */
/*    key files depending on existence of each file     */
/* Must have Qmail door configured for extended prompts */
/*======================================================*/

Qmail:
  CALL Delay(5)
  CALL WriteLog 'Opening Qmail4 door',3
  CALL Put_s 'QMAIL4'cr,port
  DO FOREVER
    match=Wait_fore('NS)?','any key','<COMMAND>',port,scr_hndl)
    CALL ScrDeb('OQ')
    SELECT
      WHEN match=0 THEN
        SIGNAL Errh
      WHEN match=1 THEN
        CALL Put_s ' ',port
      WHEN match=2 THEN
        CALL Put_s 'N'cr,port
      OTHERWISE LEAVE
    END
  END
  CALL WriteLog 'Qmail4 door opened',2

  pathn=qdir
  IF ptrfile\='' THEN DO /*send pointer file*/
    CALL Put_s 'R'cr,port
    CALL Wait_fore '<PTRUP>',port,scr_hndl
    IF result=0 THEN SIGNAL Errh
    CALL WriteLog 'Sending pointer file',3
    dpfname=ptrfile ; xcmd='U' ; CALL DoXfer
    CALL Wait_fore '<PTRFILE>',port,scr_hndl
    IF result=0 THEN SIGNAL Errh
    CALL Put_s '1'cr,port /* set ptrs to before pkt */
    CALL Wait_fore '<COMMAND>',port,scr_hndl
    IF result=0 THEN SIGNAL Errh
    CALL WriteLog 'Pointer file sent',3
  END

  IF keyfile\='' THEN DO /*send key file*/
    CALL Put_s 'K'cr,port
    CALL Wait_fore '<KEYUP>',port,scr_hndl
    IF result=0 THEN SIGNAL Errh
    CALL WriteLog 'Sending keyword file',3
    dpfname=keyfile ; xcmd='U' ; CALL DoXfer
    CALL Wait_fore '<COMMAND>',port,scr_hndl
    IF result=0 THEN SIGNAL Errh
    CALL WriteLog 'Keyword file sent',3
  END

  IF qupdn='D' | qupdn='B' THEN DO /*download Qmail file*/
    CALL Read_timeout '480000',port
    CALL Put_s 'D'cr,port
    CALL WriteLog 'Beginning mail scan',2
    DO FOREVER
      match=Wait_fore('<NO TRANSFER>','<NO TIME>','<DLASK>','<DOWNLOAD>',,
      '<COMMAND>','<DL ERROR>','<DL SUCCESS>','<MAX>','<REPEAT>','...',,
      port,scr_hndl)
      CALL ScrDeb('QD')
      SELECT
        WHEN match=0 THEN
          SIGNAL Errh
        WHEN match=1 THEN DO
          CALL WriteLog 'No mail to download',3
          LEAVE ; END
        WHEN match=2 THEN DO
          CALL WriteLog 'Not enough time for mail',2
          LEAVE ; END
        WHEN match=3 THEN
          CALL Put_s 'Y'cr,port
        WHEN match=4 THEN DO
          CALL WriteLog 'Initiating QWK download',3
          filen=packet'.QWK' ; xcmd='D'
          IF pktcnt>0 THEN
            filen=Overlay(Format(pktcnt-1,1),filen,Length(filen))
          CALL DoXfer ; END
        WHEN match=5 THEN DO
          IF autorep='YES' & repflg=1 THEN DO
            CALL Put_s 'D'cr,port
            CALL WriteLog 'Beginning next scan',2
            repflg=0 ; END
          ELSE DO
            CALL Flush
            LEAVE ; END
          END
        WHEN match=6 THEN DO
          CALL WriteLog 'QWK receive failed',2
          qwksucc=0 ; END
        WHEN match=7 THEN DO
          CALL WriteLog 'QWK file received',3
          pktcnt=pktcnt+1
          qwksucc=1 ; END
        WHEN match=8 THEN DO
          CALL WriteLog 'Reached max packet size',2
          repflg=1 ; END
        WHEN match=9 THEN DO
          CALL WriteLog 'Qmail auto-repeating scan',2
          CALL Put_s esc||esc||esc,port ; END
        OTHERWISE NOP
      END
    END
  END

  IF qupdn='U' | qupdn='B' THEN DO /*upload reply file*/
    CALL Read_timeout '60000',port
    CALL Put_s 'U'cr,port
    DO FOREVER
      match=Wait_fore('<UPLOAD>','<UP ERROR>','S NOT INSERTED>',,
      'S INSERTED>','<UP SUCCESS>','<COMMAND>',port,scr_hndl)
      CALL ScrDeb('QU')
      SELECT
        WHEN match=0 THEN
          SIGNAL Errh
        WHEN match=1 THEN DO
          CALL WriteLog 'Initiating REP upload',3
          dpfname=repfile ; xcmd='U'
          CALL DoXfer ; END
        WHEN match=2 | match=3 THEN DO
          CALL WriteLog 'REP send failed',2
          repsucc=0 ; END
        WHEN match=4 & delmail='YES' THEN DO
          shellcmd='DEL 'repfile'> NUL'
          ADDRESS CMD shellcmd
          CALL WriteLog 'REP file deleted',3
          IF qupdn='U' THEN DO
            shellcmd='DEL 'qwkfile'> NUL'
            ADDRESS CMD shellcmd
            /* delete REP, and QWK if 'U' */
            CALL WriteLog 'QWK file deleted',3 ; END
          repsucc=1 ; END
        WHEN match=6 THEN DO
          CALL Flush
          LEAVE ; END
        OTHERWISE NOP
      END
    END
  END
  CALL Flush
  RETURN

QuitMail:
  CALL Sleep '2000'
  CALL Flush
  CALL WriteLog 'Exiting Qmail system',3
  CALL Put_s 'Q'cr,port
  CALL Read_timeout '20000',port
  DO FOREVER
    match=Wait_fore('echo','Command',port,scr_hndl)
    CALL ScrDeb('QQ')
    SELECT
      WHEN match=0 THEN
        SIGNAL Errh
      WHEN match=1 THEN
        CALL Put_s pword||cr,port
      WHEN match=2 THEN
        LEAVE
      OTHERWISE NOP
    END
  END
  CALL WriteLog 'Exited Qmail system',2
  CALL Flush
  RETURN

CheckMail: /*Checks existence of Qmail files*/
  repfile=Stream(qdir||packet'.REP','c','query exists')
  qwkfile=Stream(qdir||packet'.QWK','c','query exists')
  ptrfile=Stream(qdir||packet'.PTR','c','query exists')
  keyfile=Stream(qdir||packet'.KEY','c','query exists')
  IF qwkfile\='' & repfile='' THEN qupdn='N'
  IF qwkfile='' & repfile='' THEN qupdn='D'
  IF qwkfile='' & repfile\='' THEN qupdn='B'
  IF qwkfile\='' & repfile\='' THEN qupdn='U'
  RETURN

/*====================[PERFORM LOGOFF]====================*/
/* Gets past logoff verification and questionnaires, etc. */
/*  until it sees "NO CARRIER" status report from modem   */
/*========================================================*/

LogOff:
  CALL Delay(5)
  CALL Set_download_path odlpath,dde_output
  CALL Read_timeout '20000',port
  CALL Put_s 'G Q'cr,port
  DO FOREVER
    match=Wait_fore('--)','? (','(Enter)','ogoff?',,
    ', Mor','NS)?','any key','NO CARRIER',port,scr_hndl)
    CALL ScrDeb('LO')
    SELECT
      WHEN match=0 THEN
        SIGNAL Errh
      WHEN match>0 & match<4 THEN
        CALL Put_s cr,port
      WHEN match=4 THEN
        CALL Put_s 'Y'cr,port
      WHEN match=5 | match=6 THEN
        CALL Put_s 'N'cr,port
      WHEN match=7 THEN
        CALL Put_s ' ',port
      WHEN match=8 THEN
        LEAVE
      OTHERWISE NOP
    END
  END
  DO 3 ; CALL Beep 800,300 ; END
  CALL WriteLog 'Logged off normally',1
  CALL WriteLog 'ET',1
  lfstate=Stream(logfile,'c','close')
  EXIT

/*====================[UPLOADS AND DOWNLOADS]====================*/
/*  Parse and execute PCBoard file xfer commands from list file  */
/*===============================================================*/

PcbXfer:
  CALL Delay(5)
  curconf=0
  DO WHILE Lines(filelist)\=0
    CALL Read_timeout '60000',port
    cmdline=Linein(filelist)
    IF cmdline='' THEN ITERATE
    PARSE VAR cmdline xconf xcmd xprot xfile xdesc
    xcmd=TRANSLATE(xcmd)
    xprot=TRANSLATE(xprot)
    IF xconf<>curconf THEN DO
      CALL JoinConf
      IF xconf<>curconf THEN DO
        CALL WriteLog 'Failed to join conference 'xconf,2
        CALL WriteLog 'Subsequently bypassing 'xfile,3
        ITERATE
      ELSE
        CALL WriteLog 'Entered conference 'curconf' from 'oldconf,2
      END
    END
    SELECT
      WHEN xcmd='D' THEN
        IF xprot\='' & xfile\='' THEN
          CALL XferCmds
        ELSE
          CALL WriteLog 'Xfer syntax error in 'cmdline,1
      WHEN xcmd='U' THEN
        IF xprot\='' & xfile\='' & xdesc\='' THEN
          CALL XferCmds
        ELSE
          CALL WriteLog 'Xfer syntax error in 'cmdline,1
      OTHERWISE CALL WriteLog 'Xfer syntax error in 'cmdline,1
    END
  END
  CALL Flush
  RETURN

JoinConf:
  CALL Put_s 'J 'xconf' Q'cr,port
  oldconf=curconf
  curconf=xconf
  DO FOREVER
    match=Wait_fore('ence #',', More','N)','NS)?','(Ent',,
    'ence Co','ard Command','nvalid','not regis',port,scr_hndl)
    CALL ScrDeb('JC')
    SELECT
      WHEN match=0 THEN
        SIGNAL Errh
      WHEN match=1 THEN DO
        CALL Flush
        CALL Put_s cr,port ; END
      WHEN match>1 & match<6 THEN DO
        CALL Flush
        CALL Put_s 'N'cr,port ; END
      WHEN match=6 | match=7 THEN DO
        CALL Flush
        LEAVE ; END
      WHEN match=8 THEN DO
        CALL WriteLog 'Invalid conference selection',3
        curconf=oldconf ; END
      WHEN match=9 THEN DO
        CALL WriteLog 'Not registered in conference',3
        curconf=oldconf ; END
      OTHERWISE NOP
    END
  END
  CALL Flush
  RETURN

XferCmds:
  drivn=Filespec('drive',xfile)
  pathn=Filespec('path',xfile)
  filen=Filespec('name',xfile)
  pathn=drivn||pathn
  dpfname=Stream(pathn||filen,'c','query exists')
  IF Pos('?',dpfname)>0 | Pos('*',dpfname)>0 THEN DO
    dpfname='' ; wcflag=1 ; END
  ELSE
    wcflag=0
  IF xcmd='D' & dpfname\='' THEN DO
    CALL WriteLog 'Download bypassed, file exists',2
    CALL WriteLog pathn||filen,3
    RETURN ; END
  IF xcmd='U' & dpfname='' THEN DO
    CALL WriteLog 'Upload bypassed, not found',2
    CALL WriteLog pathn||filen,3
    RETURN ; END
  CALL Put_s xcmd filen xprot cr,port
  DO FOREVER
    match=Wait_fore('ot Accept','plicates','exists','not found','upload!',,
    'p upload in','ription wi','Aborts','ommand','nter)',,
    'erifying','ter)=n','(G)',port,scr_hndl)
    CALL ScrDeb('FX')
    SELECT
      WHEN match=0 THEN
        SIGNAL Errh
      WHEN match=1 THEN
        CALL WriteLog 'Transfer aborted, not accepted',3
      WHEN match=2 | match=3 THEN
        CALL WriteLog 'Transfer aborted, dupe UL',3
      WHEN match=4 THEN
        CALL WriteLog 'Transfer aborted, not found',3
      WHEN match=5 THEN
        CALL WriteLog 'Transfer aborted, priv viol',3
      WHEN match=6 THEN
        CALL Put_s 'Y'cr,port
      WHEN match=7 THEN
        CALL Put_s xdesc||cr||cr,port
      WHEN match=8 THEN
        CALL DoXfer
      WHEN match=9 THEN
        LEAVE
      WHEN match=10 THEN
        CALL Put_s cr,port
      WHEN match=11 THEN
        CALL Read_timeout '120000',port
      WHEN match=12 THEN
        CALL Put_s cr,port        
      WHEN match=13 THEN DO
        CALL Flush
        CALL Put_s cr,port        
	CALL DoXfer ; END
      OTHERWISE NOP
    END
  END
  RETURN

DoXfer:
  CALL WriteLog 'File transfer executing, 'xcmd||xprot':',3
  SELECT
    WHEN xprot='Z' & xcmd='U' THEN DO
      CALL WriteLog dpfname,2
      fc=zmodem_send(dpfname,dde_output,dde_input) ; END
    WHEN xprot='Z' & xcmd='D' THEN DO
      CALL WriteLog pathn||filen,2
      CALL Set_download_path pathn,dde_output
      fc=zmodem_receive(dde_output,dde_input) ; END
    WHEN xprot='G' & xcmd='U' THEN DO
      CALL WriteLog dpfname,2
      fc=ymodemg_send(dpfname,dde_output,dde_input) ; END
    WHEN xprot='G' & xcmd='D' THEN DO
      CALL WriteLog pathn||filen,2
      CALL Set_download_path pathn,dde_output
      fc=ymodemg_receive(dde_output,dde_input) ; END
    WHEN xprot='K' & xcmd='U' THEN DO
      CALL WriteLog dpfname,2
      fc=kermit_send(dpfname,dde_output,dde_input) ; END
    WHEN xprot='K' & xcmd='D' THEN DO
      CALL WriteLog pathn||filen,2
      CALL Set_download_path pathn,dde_output
      fc=kermit_receive(dde_output,dde_input) ; END
    WHEN xprot='Y' & xcmd='U' THEN DO
      CALL WriteLog dpfname,2
      fc=ymodem_send(dpfname,dde_output,dde_input) ; END
    WHEN xprot='Y' & xcmd='D' THEN DO
      CALL WriteLog pathn||filen,2
      CALL Set_download_path pathn,dde_output
      fc=ymodem_receive(dde_output,dde_input) ; END
    WHEN xprot='O' & xcmd='U' THEN DO
      CALL WriteLog dpfname,2
      fc=xmodem_1k_send(dpfname,dde_output,dde_input) ; END
    WHEN xprot='O' & xcmd='D' THEN DO
      IF wcflag=1 THEN CALL GetFnam
      CALL WriteLog pathn||filen,2
      CALL Set_download_path pathn,dde_output
      fc=xmodem_1k_receive(filen,dde_output,dde_input) ; END
    WHEN xprot='C' & xcmd='U' THEN DO
      CALL WriteLog dpfname,2
      fc=xmodem_send(dpfname,dde_output,dde_input) ; END
    WHEN xprot='C' & xcmd='D' THEN DO
      IF wcflag=1 THEN CALL GetFnam
      CALL WriteLog pathn||filen,2
      CALL Set_download_path pathn,dde_output
      fc=xmodem_receive(filen,dde_output,dde_input) ; END
    WHEN xprot='X' & xcmd='U' THEN DO
      CALL WriteLog dpfname,2
      fc=xmodem_chk_send(dpfname,dde_output,dde_input) ; END
    WHEN xprot='X' & xcmd='D' THEN DO
      IF wcflag=1 THEN CALL GetFnam
      CALL WriteLog pathn||filen,2
      CALL Set_download_path pathn,dde_output
      fc=xmodem_chk_receive(filen,dde_output,dde_input) ; END
    OTHERWISE DO
      CALL WriteLog 'Xfer protocol syntax error',1
      fc=2 ; END
  END
  IF fc\=2 THEN DO
    IF fc=0 THEN fc='FAILURE'
    IF fc=1 THEN fc='SUCCESS'
    CALL WriteLog 'File transfer exit code 'fc,1
  END
  RETURN

GetFnam:
  currow=Get_cursor_position('row',dde_output,dde_input)
  found=0
  DO lcnt=currow-1 TO currow-8 BY -1 UNTIL found>0
    line=Get_char_at(lcnt,0,40,dde_output,dde_input)
    found=Pos('elected:',line)
  END
  line=Get_char_at(lcnt,0,40,dde_output,dde_input)
  IF Pos('elected:',line)>0 THEN
    PARSE line . . filen .
  ELSE
    filen='*UNKNOWN'
  RETURN

/*====================[HANDLE ERRORS]====================*/
/* Print error message and yell, drop carrier if timeout */
/*=======================================================*/

RexxErr:
  CALL Put_s crlf||sred,scr_hndl
  IF RC='RC' THEN
    CALL Put_s 'REXX ERROR in line 'sigl||crlf,scr_hndl
  ELSE
    CALL Put_s 'REXX ERROR 'rc' in line 'sigl': 'Errortext(rc)crlf,scr_hndl
  CALL Put_s Sourceline(sigl)crlf,scr_hndl
  CALL Put_s 'Condition: 'Condition('C')crlf,scr_hndl
  CALL Put_s 'PROGRAM ABENDED.'swit||crlf,scr_hndl
  CALL Set_download_path odlpath,dde_output
  CALL WriteLog 'REXX procedure error encountered at 'sigl,1
  CALL Beep 40,2000
  CALL Sleep '30000'
  CALL Drop_dtr port
  CALL Sleep '2000'
  CALL Raise_dtr port
  CALL WriteLog 'Terminated by RexxErr',1
  CALL WriteLog 'ET',1
  lfstate=Stream(logfile,'c','close')
  EXIT

HostErr:
  CALL Put_s crlf||sred'HOST CMD ERROR 'rc' in line 'sigl':',scr_hndl
  CALL Put_s Errortext(rc)crlf||Sourceline(sigl)swit||crlf,scr_hndl
  CALL WriteLog 'Host CMD error occurred at 'sigl,1
  CALL Beep 40,2000
  RETURN

Errh:
  CALL Put_s crlf||sred'SCRIPT ERROR in line 'sigl||swit||crlf,scr_hndl
  CALL Set_download_path odlpath,dde_output
  CALL WriteLog 'Script error occurred at 'sigl,1
  lfstate=Stream(logfile,'c','close')
  DO 30 ; CALL Beep 1800,100 ; END
  CALL Sleep '30000'
  CALL Drop_dtr port
  CALL Sleep '2000'
  CALL Raise_dtr port
  CALL WriteLog 'Terminated by Errh',1
  CALL WriteLog 'ET',1
  lfstate=Stream(logfile,'c','close')
  EXIT

ExitScr:
  DO 3 ; CALL Beep 800,300 ; END
  CALL Put_s crlf'PCBOARD.CMD Terminated at line 'sigl||crlf,scr_hndl
  CALL Set_download_path odlpath,dde_output
  CALL WriteLog 'CMD file terminated by user at 'sigl,1
  IF waitnc='YES' THEN DO
    CALL Read_timeout '3600000',port
    DO FOREVER
      match=Wait_fore('NO CARRIER'cr,port,scr_hndl)
      CALL ScrDeb('NC')
      SELECT
        WHEN match=0 THEN ; SIGNAL Errh
        WHEN match=1 THEN ; LEAVE
        OTHERWISE ; SIGNAL Errh
      END
    END
    CALL WriteLog 'Connection terminated',1
    CALL WriteLog 'ET',1
  END
  lfstate=Stream(logfile,'c','close')
  EXIT

/*====================[GET BBS PWORD]====================*/
/* Searches scrollback buffer for BBS ID line before the */
/* PCBoard version ID line, sets password and qmail vars */
/* May fail due to line noise, handshake problems, etc.  */
/*=======================================================*/

GetBbs:
  currow=Get_cursor_position('row',dde_output,dde_input)
  found=0
  DO lcnt=currow-1 TO currow-100 BY -1 UNTIL found>0 | currow=0
    line=Get_char_at(lcnt,0,40,dde_output,dde_input)
    found=Pos('PCBoard (R)',line)
  END
  line=Get_char_at(lcnt-1,0,40,dde_output,dde_input)
  line=Translate(line)
  SELECT
    WHEN Pos('INVENTION',line)\=0 THEN DO
      pword='INVPW1T'                  /* your password for BBS */
      qmail='YES INV-FAC Z' ; END      /* YES, packet name, protocol */
    WHEN Pos('ACE ',line)\=0 THEN DO
      pword='ACEPW1S'
      qmail='YES ACEBBS Z' ; END
    WHEN Pos('WISHBONE',line)\=0 THEN
      pword='ZXYTWRRWZ'                /* this fmt for BBS w/o Qmail */
    WHEN Pos('BROTHERS',line)\=0 THEN
      pword='ABCDEFG'
    OTHERWISE DO
      CALL WriteLog 'Error detecting BBS and password',1
      DO tone=1500 TO 2500 BY 100
        CALL Beep tone,50 ; END
      CALL Put_s ' <ENTER MANUALLY!> ',scr_hndl
      CALL SLEEP '20000'
      pword='' ; END
  END
  RETURN

/*====================[OTHER ROUTINES]====================*/
/* Write logfile statements.  CALL WriteLog 'text',lvl    */
/* N second delay with ticking sound.  CALL Delay(n)      */
/* Flush flushes pending input from current COM port.     */
/* WrEltime writes total elapsed time to activity log.    */
/*========================================================*/

Flush:
  DO WHILE Char_avail(port)>0
    CALL Put_s Get_ch(port),scr_hndl
  END
  RETURN

WriteLog:
  stamp=arg(1)
  level=arg(2)
  IF logfile>' ' & level<=loglvl THEN DO
    IF stamp='ET' THEN DO
      etime=Trunc(Time('E'))
      emin=etime%60
      esec=etime//60
      IF esec<10 THEN esec='0'esec
      stamp='Total elapsed - 'emin':'esec
    END
    lfrecord=date('U')' 'time()' 'stamp||crlf
    lfstate=Charout(logfile,lfrecord)
  END
  RETURN

ScrDeb:
  section=arg(1)
  IF loglvl=4 THEN
    CALL Put_s crlf||sred'<'section':',
    match'>'swit||crlf,scr_hndl
  RETURN

Delay:
  DO arg(1)
    CALL Sleep '1000'
    CALL Beep 2000,50
  END
  RETURN

