//---------------------------------------------------------------------------
// This program demonstrates the controls in the Plumber Custom Control Pack
// 1.  To see just how easy it is to add and use these controls in your app,
// look for the lines of code ending in or surrounded with the comments,
// " <--- Added."
//---------------------------------------------------------------------------

#include "StdAfx.h"

#include "resource.h"
#include "resrc1.h"

#include <ctl3d.h>

#include "PlPak1.h"


#include <CalenDlg.h>							// <--- Added
#include <EditDate.h>							// <--- Added

CPlumberPack1 ThisApp;

BOOL CPlumberPack1::InitInstance()
{
	CCalenDlg::RegisterControl ();      		// <--- Added

	m_pMainWnd = new CDlgWindow();		
	
	Ctl3dRegister(AfxGetInstanceHandle());
	Ctl3dSubclassDlg(m_pMainWnd->m_hWnd, CTL3D_ALL);

	m_pMainWnd->Invalidate(TRUE);
	m_pMainWnd->ShowWindow(SW_SHOW);

	SetClassWord(m_pMainWnd->m_hWnd,GCW_HICON, (WORD)LoadIcon(AFX_IDI_STD_FRAME));
	
	return TRUE;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CDlgWindow, CDialog)
	//{{AFX_MSG_MAP(CDlgWindow)
	ON_WM_CLOSE()
	ON_COMMAND(ID_EXIT, OnExit)
	ON_BN_CLICKED(IDC_CHECK1, OnWithCombo)
	ON_BN_CLICKED(IDC_CHECK2, OnWithScroll)
	ON_WM_CTLCOLOR()
	ON_MESSAGE (PPC_DATECHANGED, OnDateChanged)
	ON_COMMAND(ID_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


CDlgWindow::CDlgWindow()
{
	Create (MAIN_DLG_WINDOW);		// Create the Main Dialog Window
}

void CDlgWindow::OnCancel ()
{
	return;							// don't allow Esc key to close
}

BOOL CDlgWindow::OnInitDialog()
{
	CString Tmp;

	CDialog::OnInitDialog();

	// <--- Added
	((CButton*) GetDlgItem (IDC_CHECK1))->SetCheck(1);
	((CButton*) GetDlgItem (IDC_CHECK2))->SetCheck(1);

	m_ComboDate.SubclassDlgItem (IDC_EDIT1, this);
	m_ScrollDate.SubclassDlgItem (IDC_EDIT2, this);	
	m_EditDate.SubclassDlgItem (IDC_EDIT3, this);
	
	m_ComboDate.AttachCombo ();
	m_ComboDate.InitDate	(Tmp);

	m_ScrollDate.AttachScroll ();
	m_ScrollDate.InitDate     (Tmp);

	m_EditDate.InitDate (Tmp);
	
	OnDateChanged ((WPARAM) GetDlgItem (IDC_FULLCAL)->GetSafeHwnd(), 0);
	// display current date
	// ---> Added

	CenterWindow ();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDlgWindow::OnClose()
{
	DestroyWindow();				// Destroy the dialog box window
	delete this;					// Delete 'this' dialog box object
	Ctl3dUnregister(AfxGetInstanceHandle());
	PostQuitMessage(0);				// End the application
}


HBRUSH CDlgWindow::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	const MSG	*msg=GetCurrentMessage();	

	CModalDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	return Ctl3dCtlColorEx(msg->message, msg->wParam, msg->lParam); 
}

void CDlgWindow::OnExit()
{
	OnClose();						// Do the OnClose member function
}


void CDlgWindow::OnHelp()
{
	AfxGetApp()->WinHelp (0, HELP_CONTENTS);
}

// <--- Added
LRESULT CDlgWindow::OnDateChanged (WPARAM WParam, LPARAM LParam)
{
	if (WParam == (WPARAM) GetDlgItem (IDC_FULLCAL)->GetSafeHwnd())
	{
		CTime Date = ((CCalendar*) GetDlgItem (IDC_FULLCAL))->GetSelectedDate();
	 	
	 	int Day = Date.GetDay();
	 
		CString Str = Date.Format ("%B, %d, %Y");
		
		GetDlgItem (IDC_DATETXT)->SetWindowText (Str);	
    }
    
	return (LRESULT) 0;
}

void CDlgWindow::OnWithCombo()
{
	if (((CButton*) GetDlgItem (IDC_CHECK1))->GetCheck())
		m_ComboDate.AttachCombo();
	else
		m_ComboDate.DetachCombo();
}

void CDlgWindow::OnWithScroll()
{
	if (((CButton*) GetDlgItem (IDC_CHECK2))->GetCheck())
		m_ScrollDate.AttachScroll();
	else
		m_ScrollDate.DetachScroll();
}
// ---> Added


