
//  playwave.cpp
//
//  WAVE File Player
//
//  by Chris Peterson (Compuserve ID: 76550,3670)
//
//  Written on May 6, 1993
//
//  Note:  Set Tab Stops to 4

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <commdlg.h>
#include <mmsystem.h>


#define		ID_PLAY		101		//  Play WAVE File Menu Choice
#define		ID_REPLAY   102		//  Replay WAVE File Menu Choice
#define		ID_EXIT		103		//  Exit This Program Menu Choice
#define		ID_ABOUT	104		//  About This Program Menu Choice

static OPENFILENAME ofn;		//  Open File Dialog Structure

static char WaveFileName[100],	//  WAVE Input File Pathname
			WaveTitleName[20];	//  WAVE Input File Basename

int GetFileName(HWND);			//  Get WAVE Filename to Play


void PlayWave(char *);			//  Play The File

long FAR PASCAL _export WndProc(HWND, UINT, UINT, LONG);	//  Main Message Processer

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
	static char szAppName[] = "WAVE File Player";
	HWND        hwnd;
	MSG         msg;
	WNDCLASS    wndclass;
    DWORD 		WStyle = WS_POPUPWINDOW | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX;

	if (hPrevInstance == 0)
	{
		wndclass.style         = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc   = WndProc;
		wndclass.cbClsExtra    = 0;
		wndclass.cbWndExtra    = 0;
		wndclass.hInstance     = hInstance;
		wndclass.hIcon         = LoadIcon (hInstance, "WAVE");
		wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
		wndclass.hbrBackground = GetStockObject (WHITE_BRUSH);
		wndclass.lpszMenuName  = "WAVEMENU";
		wndclass.lpszClassName = szAppName;
		RegisterClass(&wndclass);
	}

	hwnd = CreateWindow(szAppName,          //  Window Class Name
			"WAVE File Player",             //  Window Caption
			WStyle,                         //  Window Style
			150,                            //  Initial x Position
			100,                            //  Initial y Position
			300,                            //  Initial x Size
			250,                            //  Initial y Size
			NULL,                           //  Parent Window Handle
			NULL,                           //  Window Menu Handle
			hInstance,                      //  Program Instance Handle
			NULL);					        //  Creation Parameters

	ShowWindow(hwnd, nCmdShow);
	UpdateWindow(hwnd);

	while (GetMessage(&msg, NULL, 0, 0) != 0)
	{
		TranslateMessage (&msg);
		DispatchMessage (&msg);
	}
	return(msg.wParam);
}


long FAR PASCAL _export WndProc(HWND hwnd, UINT message, UINT wParam, LONG lParam)
{
	HDC         hdc;
	PAINTSTRUCT ps;
    static int	gf = 0;

	switch (message)
	{
		case WM_PAINT:
			BeginPaint(hwnd, &ps);
			EndPaint(hwnd, &ps);
			return(0);

		case WM_COMMAND:
			if (wParam == ID_PLAY)
			{
				if ((gf = GetFileName(hwnd)) != 0)
				{
                    PlayWave(WaveFileName);
				}
			}
			else if (wParam == ID_REPLAY && gf != 0)
			{
				PlayWave(WaveFileName);
            }
			else if (wParam == ID_EXIT)
			{
				SendMessage(hwnd,WM_DESTROY,NULL,NULL);
            }
			else if (wParam == ID_ABOUT)
			{
				MessageBox(hwnd,"by Chris Peterson","WAVE File Player",MB_OK);
			}
			return(0);

		case WM_DESTROY:
			PostQuitMessage(0);
			return(0);

	}
	return(DefWindowProc(hwnd, message, wParam, lParam));
}


//  Input WAVE Filename to Play

int GetFileName(HWND hwnd)
{
	static char *szFilter[] = { "WAVE Files", "*.wav", "", "" };

	ofn.lStructSize       = sizeof(OPENFILENAME);
	ofn.hwndOwner         = hwnd;
	ofn.hInstance         = NULL;
	ofn.lpstrFilter       = szFilter[0];
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter    = 0;
	ofn.nFilterIndex      = 0;
	ofn.lpstrFile         = WaveFileName;
	ofn.nMaxFile          = 100;
	ofn.lpstrFileTitle    = WaveTitleName;
	ofn.nMaxFileTitle     = 20;
	ofn.lpstrInitialDir   = NULL;
	ofn.lpstrTitle        = "Select a WAVE File";
	ofn.Flags             = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST;
	ofn.nFileOffset       = 0;
	ofn.nFileExtension    = 0;
	ofn.lpstrDefExt       = "wav";
	ofn.lCustData         = 0L;
	ofn.lpfnHook          = NULL;
	ofn.lpTemplateName    = NULL;

	return(GetOpenFileName(&ofn));
}


//  Play The WAVE File

void PlayWave(char *Filename)
{
	sndPlaySound(Filename,SND_ASYNC);
}
