/* rexx:
   Create a PineOS2 object for WPS
 */

if value('HOME',,'OS2ENVIRONMENT')='' & value('PINEHOME',,'OS2ENVIRONMENT')='' then do
  SAY 'You need to set the HOME or PINEHOME environment variable in CONFIG.SYS!'
  exit 0
  end

SAY
SAY '------------------------------------------------------------'
SAY 'This script creates a WPS object that invokes PineOS2'
SAY 'For other steps you need to do to install PineOS2 correctly'
SAY 'please read the file README.OS2 that accompanied the archive'
SAY '------------------------------------------------------------'
SAY
SAY 'Is this what you wish to do? (Y/N)'
pull YesNo
if \ ((YesNo = 'Y') | (YesNo = 'y')) then exit 0

SAY 'Enter the number of rows you wish to make the PineOS2 window'
SAY 'e.g. 25, 32, 40, 50 etc (default is 25)'

pull lines

if lines='' then lines=25

call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs

curdir=directory()

rc=SysCreateObject('WPProgram','PineOS2','<WP_DESKTOP>',,
                   "EXENAME="curdir"\Pine.exe;PARAMETERS=-w "lines)

SAY 'Program object created.'

exit


