/* REXX NUL2SPAC.CMD

    This program changes any NUL to a SPACE.

    Post Road Mailer 1.99 and 2.00 introduced a problem which makes the first part
or even all of the PGP output appended to a mail file invisible when you VIEW the
mail (the problem does not occur with printing or with quoting in a reply).
    There is a NUL character near the end of the mail file which makes PRM stumble.
This simple REXX script serves to change this NUL into a SPACE
*/
ARG FileIn .

call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'

Tempfile = SysTempFileName('NUL?????.TMP')
Erg = STREAM(FileIn,'C','OPEN READ')
Erg = STREAM(Tempfile,'C','OPEN WRITE')

Say 'Eingabe: ' FileIn
Say 'Ausgabe: ' FileIn

DO WHILE LINES(FileIn) > 0
   Erg = LINEOUT(TempFile,TRANSLATE(LINEIN(FileIn),'20'x,'00'x))
END /* DO While */

Erg = STREAM(FileIn,'C','CLOSE')
Erg = STREAM(TempFile,'C','CLOSE')


'COPY ' TempFile FileIn
'del ' TempFile

EXIT


