/* REXX
   Program SPLITMAIL Version 1.0
   Sends header lines via QUEUE to another REXX program, 
   outputs rest of file to standard output for a filter to consume it.
*/
/* CopyRight Lueko Willms <lueko.willms@T-Online.de>
                          <L.WILLMS@LINK-F.rhein-main.de>
*/

parse arg OutMail DEBUG
OutMail = strip(translate(OutMail))

DEBUG = (strip(translate(DEBUG)) = 'DEBUG')
TRUE = 1
PARSE SOURCE BetrSyst Shell IchHeisse

Erg = STREAM(Outmail,'C','OPEN READ')
IF DEBUG Then
  Say IchHeisse 'Ergebnis von OPEN READ von ' Outmail ':' Erg

Zeile = ''
DO UNTIL Length(Zeile) = 0
    Zeile = linein(OutMail)
    Queue Zeile
END /* Do Header */

DO While LINES(OutMail) > 0
    Erg = LINEOUT(,LINEIN(OutMail))
END /* the rest of it */

Erg = STREAM(Outmail,'C','CLOSE')
IF DEBUG Then
  Say IchHeisse 'Ergebnis von CLOSE von ' Outmail ':' Erg

EXIT
