/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 */

#include <stdio.h>
#include <stdlib.h>
#include "pmod.h"

int notLoaded;
int shrinkedInstrs;

static FILE *inputFile;
static struct SAMPLE *smpPtrs[ GUS_MAX_SAMPLES ];
static int currentSample;

static unsigned int getSampleType( struct SAMPLE *smp )
{
  unsigned int res;

  res = 0;  
  if ( smp -> type & SMP_TYPE_UNSIGNED ) res |= GUS_WAVE_UNSIGNED;
  if ( smp -> type & SMP_TYPE_16BIT ) res |= GUS_WAVE_16BIT;
  if ( smp -> type & SMP_TYPE_DELTA ) res |= GUS_WAVE_DELTA;
  if ( smp -> lend > 2 && smp -> lstart < smp -> lend ) res |= GUS_WAVE_LOOP;
  if ( smp -> type & SMP_TYPE_PINGPONG_LOOP ) res |= GUS_WAVE_BIDIRECTIONAL;
  return res;
}

static int sampleReadFunction( unsigned short number, unsigned char *ptr, int size )
{
  struct SAMPLE *smp;
  long l;
  
  pprintf( "\rLoading sample %d...       \x8\x8\x8\x8\x8\x8", currentSample++ );
  fflush( stdout );
  smp = smpPtrs[ number ];
  fseek( inputFile, smp -> ident, SEEK_SET );
  smp -> ident = number;
  ASSERT( smp -> length == size );
  smp -> used = 1;
  if ( ( l = fread( ptr, 1, smp -> length, inputFile ) ) != smp -> length )
    {
      byte b;
          
      wprintf( "instr: short sample (%i != %i)\n", l, smp -> length );
      if ( l <= 0 )
        {
          smp -> length = 0;
          return -1;
        }          
      if ( !( smp -> type & SMP_TYPE_16BIT ) )
        {
          b = ptr[ l - 1 ];
          for ( ; l < smp -> length; l++ ) ptr[ l ] = b;
        }
       else
        fatal( "instr: short 16-bit sample" );
    }
  return 0;
}

static void sampleErrorFunction( unsigned short number, int error )
{
  struct SAMPLE *smp;
  
  smp = smpPtrs[ number ];
  smp -> used = 0;
  smp -> ident = -1;
  wprintf( "\rSkipping sample %d (error = %i).\n", currentSample--, error );
  fflush( stdout );
  notLoaded++;
}

void loadInstruments( FILE *file )
{
  int i, j, ident;
  struct INSTR *is;
  struct SAMPLE *smp;

  notLoaded = shrinkedInstrs = 0;
  inputFile = file;

  for ( i = ident = 0; i < MAX_INSTRUMENTS; i++ )
    {
      if ( ( is = songInstrs[ i ] ) == NULL ) continue;
      for ( j = 0; j < MAX_SAMPLES; j++ )
        {
          if ( ( smp = is -> samples[ j ] ) == NULL ) continue;
          ASSERT( smp -> ident >= 0 );
          ASSERT( smp -> used == 0 );
          if ( !smp -> length )
            {
              smp -> used = 0;
              smp -> ident = -1;
              continue;
            }
          smpPtrs[ ident ] = smp;
          if ( gus_sample_reg( ident++, getSampleType( smp ), 
          		       smp -> type & SMP_TYPE_16BIT ? smp -> length >> 1 : smp -> length,
          		       smp -> type & SMP_TYPE_16BIT ? smp -> lstart >> 1 : smp -> lstart, 
          		       smp -> type & SMP_TYPE_16BIT ? smp -> lend >> 1 : smp -> lend ) < 0 )
            fatal( "loadInstruments: gus_sample_reg" );
        }
    }

  currentSample = 0;
  if ( gus_sample_reg_size() > gus_memory_free() )
    {
      if ( !( songOptions & SNDO_DONT_SHRINK ) )
        gus_sample_reg_expand( GUS_SAMPLE_EXPAND_S16 );
    }
   else
    {
      if ( !(songOptions & SNDO_DONT_STRETCH ) )
        {
          if ( !(songOptions & SNDO_STRETCH_MODE_2) )
            gus_sample_reg_expand( GUS_SAMPLE_EXPAND_S8 );
           else
            gus_sample_reg_expand( GUS_SAMPLE_EXPAND_S16 );
        }
    }
  if ( gus_sample_reg_download( sampleReadFunction, sampleErrorFunction ) < 0 )
    fatal( "loadInstruments: gus_sample_reg_download" );

  for ( i = ident = 0; i < MAX_INSTRUMENTS; i++ )
    {
      if ( ( is = songInstrs[ i ] ) == NULL ) continue;
      for ( j = 0; j < MAX_SAMPLES; j++ )
        {
          if ( ( smp = is -> samples[ j ] ) == NULL ) continue;
          if ( smp -> used ) break;
        }
      if ( j < MAX_SAMPLES && smp -> used ) is -> used = 1;
    }

  pprintf( "\r                                                 \r" );
  fflush( stdout );
}
